/*!
 * Name          : steelseries.js
 * Authors       : Gerrit Grunwald, Mark Crossley
 * Last modified : 06.03.2012
 * Revision      : 0.11.1
 *
 * Copyright (c) 2011, Gerrit Grunwald, Mark Crossley
 * All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *
 *  # Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *  # Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 *   BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 *   SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var GLOBAL_buffer=null;var GLOBAL_context=null;function GLOBAL_getColorValues(a){if(GLOBAL_buffer==null){GLOBAL_buffer=document.createElement("canvas");GLOBAL_buffer.width=1;GLOBAL_buffer.height=1;GLOBAL_context=GLOBAL_buffer.getContext("2d")}GLOBAL_context.fillStyle=a;GLOBAL_context.beginPath();GLOBAL_context.rect(0,0,1,1);GLOBAL_context.clearRect(0,0,1,1);GLOBAL_context.fill();var b=GLOBAL_context.getImageData(0,0,2,2).data;return[b[0],b[1],b[2],b[3]]}var steelseries=function(){var H=document;var aM="LCDMono2Ultra,sans-serif";var ac=function(c7,bM){bM=bM||{};var b8=(undefined===bM.gaugeType?steelseries.GaugeType.TYPE4:bM.gaugeType);var b1=(undefined===bM.size?200:bM.size);var cx=(undefined===bM.minValue?0:bM.minValue);var cu=(undefined===bM.maxValue?(cx+100):bM.maxValue);var cg=(undefined===bM.niceScale?true:bM.niceScale);var cN=(undefined===bM.threshold?(cu-cx)/2:bM.threshold);var cH=(undefined===bM.section?null:bM.section);var ba=(undefined===bM.area?null:bM.area);var b9=(undefined===bM.titleString?"":bM.titleString);var bf=(undefined===bM.unitString?"":bM.unitString);var c1=(undefined===bM.frameDesign?steelseries.FrameDesign.METAL:bM.frameDesign);var cV=(undefined===bM.frameVisible?true:bM.frameVisible);var bK=(undefined===bM.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bM.backgroundColor);var c5=(undefined===bM.backgroundVisible?true:bM.backgroundVisible);var cz=(undefined===bM.pointerType?steelseries.PointerType.TYPE1:bM.pointerType);var cQ=(undefined===bM.pointerColor?steelseries.ColorDef.RED:bM.pointerColor);var cZ=(undefined===bM.knobType?steelseries.KnobType.STANDARD_KNOB:bM.knobType);var cd=(undefined===bM.knobStyle?steelseries.KnobStyle.SILVER:bM.knobStyle);var cw=(undefined===bM.lcdColor?steelseries.LcdColor.STANDARD:bM.lcdColor);var bv=(undefined===bM.lcdVisible?true:bM.lcdVisible);var c2=(undefined===bM.lcdDecimals?2:bM.lcdDecimals);var bI=(undefined===bM.digitalFont?false:bM.digitalFont);var cK=(undefined===bM.fractionalScaleDecimals?1:bM.fractionalScaleDecimals);var bO=(undefined===bM.ledColor?steelseries.LedColor.RED_LED:bM.ledColor);var be=(undefined===bM.ledVisible?true:bM.ledVisible);var c6=(undefined===bM.thresholdVisible?true:bM.thresholdVisible);var b0=(undefined===bM.minMeasuredValueVisible?false:bM.minMeasuredValueVisible);var bU=(undefined===bM.maxMeasuredValueVisible?false:bM.maxMeasuredValueVisible);var cU=(undefined===bM.foregroundType?steelseries.ForegroundType.TYPE1:bM.foregroundType);var cC=(undefined===bM.foregroundVisible?true:bM.foregroundVisible);var bN=(undefined===bM.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bM.labelNumberFormat);var cY=(undefined===bM.playAlarm?false:bM.playAlarm);var bc=(undefined===bM.alarmSound?false:bM.alarmSound);var ck=(undefined===bM.customLayer?null:bM.customLayer);var cf=(undefined===bM.tickLabelOrientation?(b8===steelseries.GaugeType.TYPE1?steelseries.TickLabelOrientation.TANGENT:steelseries.TickLabelOrientation.NORMAL):bM.tickLabelOrientation);var b6=(undefined===bM.trendVisible?false:bM.trendVisible);var cs=(undefined===bM.trendColors?[steelseries.LedColor.RED_LED,steelseries.LedColor.GREEN_LED,steelseries.LedColor.CYAN_LED]:bM.trendColors);var bo=(undefined===bM.useOdometer?false:bM.useOdometer);var cI=(undefined===bM.odometerParams?{}:bM.odometerParams);var bp=(undefined===bM.odometerUseValue?false:bM.odometerUseValue);if(cY&&bc!==false){var a5=H.createElement("audio");a5.setAttribute("src",bc);a5.setAttribute("preload","auto")}var b2=cx;var cD=cx;var cJ=this;var bz=cu;var bZ=cx;var bG=false;var ct=0;var bk;var cO=steelseries.TrendState.OFF;var bY=b1*0.06;var bQ=b1*0.29;var bP=b1*0.36;var cP;var cv;var bH;var cE;var cM;var bR=cv+(b2-cx)*cM;var br=H.getElementById(c7).getContext("2d");br.save();br.clearRect(0,0,br.canvas.width,br.canvas.height);br.canvas.width=b1;br.canvas.height=b1;var bh=b1;var c0=b1;var bC=bh/2;var bA=c0/2;var bd=0.6*bh;var bb=0.4*c0;var cL=Math.floor(bh/10);var ci=cL+"px sans-serif";var bL=cL+"px "+aM;var bE=c0*0.13;var by=bh*0.4;var cX=(bh-by)/2;var cW=c0*0.57;var bV,bT=c0*0.61;var cc=Math.PI/2;var bm=Math.PI/180;var a8=false;var bq=cx;var bJ=cu;var bg=cu-cx;var bX=bJ-bq;var cb=0;var bl=0;var b5=10;var cT=10;var bt=function bt(){if(cg){bg=l(cu-cx,false);bl=l(bg/(cT-1),true);bq=Math.floor(cx/bl)*bl;bJ=Math.ceil(cu/bl)*bl;cb=l(bl/(b5-1),true);cx=bq;cu=bJ;bX=cu-cx}else{bg=(cu-cx);bq=cx;bJ=cu;bX=bg;bl=l(bg/(cT-1),true);cb=l(bl/(b5-1),true)}switch(b8.type){case"type1":cP=0;cv=Math.PI;bH=cc;cE=cc;cM=cE/bX;break;case"type2":cP=0;cv=Math.PI;bH=cc;cE=Math.PI;cM=cE/bX;break;case"type3":cP=0;cv=cc;bH=0;cE=1.5*Math.PI;cM=cE/bX;break;case"type4":default:cP=60*bm;cv=cc+(cP/2);bH=0;cE=2*Math.PI-cP;cM=cE/bX;break}bR=cv+(b2-cx)*cM};var co=P(b1,b1);var bS=co.getContext("2d");var b3=P(b1,b1);var b7=b3.getContext("2d");var cA;var bs=P(b1*0.093457,b1*0.093457);var bW=bs.getContext("2d");var bF=P(b1*0.093457,b1*0.093457);var a7=bF.getContext("2d");var cn=bF;var bw=P(Math.ceil(b1*0.028037),Math.ceil(b1*0.028037));var cR=bw.getContext("2d");var b4=P(Math.ceil(b1*0.028037),Math.ceil(b1*0.028037));var a9=b4.getContext("2d");var ca=P(b1,b1);var c4=ca.getContext("2d");var bD=P(b1,b1);var ce=bD.getContext("2d");var bn=P(b1,b1);var bx=bn.getContext("2d");var cF=P(b1,b1);var bi=cF.getContext("2d");var cj,cy,bu,bB;var ch,cm,cS;if(bo&&bv){cm=P(10,10);cS=cm.getContext("2d")}var cG=function(c8){br.save();br.textAlign="right";br.strokeStyle=cw.textColor;br.fillStyle=cw.textColor;if(cw===steelseries.LcdColor.STANDARD||cw===steelseries.LcdColor.STANDARD_GREEN){br.shadowColor="gray";br.shadowOffsetX=bh*0.007;br.shadowOffsetY=bh*0.007;br.shadowBlur=bh*0.007}if(bI){br.font=bL}else{br.font=ci}br.fillText(c8.toFixed(c2),cX+by-by*0.05,cW+bE*0.5+cL*0.38,by*0.9);br.restore()};var cp=function(c8){c8.save();if("type1"===b8.type){c8.drawImage(K(Math.ceil(c0*0.037383),steelseries.KnobType.STANDARD_KNOB,cd),bh*0.523364,c0*0.130841)}if("type1"===b8.type||"type2"===b8.type){c8.drawImage(K(Math.ceil(c0*0.037383),steelseries.KnobType.STANDARD_KNOB,cd),bh*0.130841,c0*0.514018)}if("type2"===b8.type||"type3"===b8.type){c8.drawImage(K(Math.ceil(c0*0.037383),steelseries.KnobType.STANDARD_KNOB,cd),bh*0.831775,c0*0.514018)}if("type3"===b8.type){c8.drawImage(K(Math.ceil(c0*0.037383),steelseries.KnobType.STANDARD_KNOB,cd),bh*0.523364,c0*0.831775)}if("type4"===b8.type){c8.drawImage(K(Math.ceil(c0*0.037383),steelseries.KnobType.STANDARD_KNOB,cd),bh*0.336448,c0*0.803738);c8.drawImage(K(Math.ceil(c0*0.037383),steelseries.KnobType.STANDARD_KNOB,cd),bh*0.626168,c0*0.803738)}c8.restore()};var c3=function(){var da=H.createElement("canvas");da.width=Math.ceil(b1*0.046728);da.height=Math.ceil(da.width*0.9);var c9=da.getContext("2d");c9.save();var c8=c9.createLinearGradient(0,0.1,0,da.height*0.9);c8.addColorStop(0,"#520000");c8.addColorStop(0.3,"#fc1d00");c8.addColorStop(0.59,"#fc1d00");c8.addColorStop(1,"#520000");c9.fillStyle=c8;c9.beginPath();c9.moveTo(da.width*0.5,0.1);c9.lineTo(da.width*0.9,da.height*0.9);c9.lineTo(da.width*0.1,da.height*0.9);c9.lineTo(da.width*0.5,0.1);c9.closePath();c9.fill();c9.strokeStyle="#FFFFFF";c9.stroke();c9.restore();return da};var a6=function(c8,de,db,c9,dc){if(de<cx){de=cx}else{if(de>cu){de=cu}}if(db<cx){db=cx}else{if(db>cu){db=cu}}if(de>=db){return}c8.save();c8.strokeStyle=c9;c8.fillStyle=c9;c8.lineWidth=bh*0.035;var da=(cE/bX*de-cE/bX*cx);var dd=da+(db-de)/(bX/cE);c8.translate(bC,bA);c8.rotate(cv);c8.beginPath();if(dc){c8.moveTo(0,0);c8.arc(0,0,bh*0.365-c8.lineWidth/2,da,dd,false)}else{c8.arc(0,0,bh*0.365,da,dd,false)}if(dc){c8.moveTo(0,0);c8.fill()}else{c8.stroke()}c8.translate(-bC,-bA);c8.restore()};var cl=function(dn,dg){bK.labelColor.setAlpha(1);dn.save();dn.textAlign="center";dn.textBaseline="middle";var dp=Math.ceil(bh*0.04);dn.font=dp+"px sans-serif";dn.strokeStyle=bK.labelColor.getRgbaColor();dn.fillStyle=bK.labelColor.getRgbaColor();dn.translate(bC,bA);dn.rotate(cv);var dd=cv;var dh=cM*cb;var dj;var df=cx;var dm=b5-1;var dc=bh*0.38;var da=bh*0.35;var di=bh*0.355;var c9=bh*0.36;var dk=bh*0.3;var c8=bh*0.1;if(b8.type==="type1"||b8.type==="type2"){c8=bh*0.035}var db=b5/2;var dl=parseFloat(cu.toFixed(2));for(var de=cx;parseFloat(de.toFixed(2))<=dl;de+=cb){dj=dh+cc;dm++;if(dm===b5){dn.lineWidth=1.5;dn.beginPath();dn.moveTo(dc,0);dn.lineTo(da,0);dn.closePath();dn.stroke();dn.save();dn.translate(dk,0);switch(cf.type){case"horizontal":dj=-dd;break;case"tangent":dj=(dd<=cc+Math.PI?Math.PI:0);break;case"normal":default:dj=cc;break}dn.rotate(dj);switch(dg.format){case"fractional":dn.fillText((df.toFixed(cK)),0,0,c8);break;case"scientific":dn.fillText((df.toPrecision(2)),0,0,c8);break;case"standard":default:dn.fillText((df.toFixed(0)),0,0,c8);break}dn.translate(-dk,0);dn.restore();df+=bl;dm=0;dn.rotate(dh);dd+=dh;continue}if(0===b5%2&&dm===(db)){dn.lineWidth=1;dn.beginPath();dn.moveTo(dc,0);dn.lineTo(di,0);dn.closePath();dn.stroke()}else{dn.lineWidth=0.5;dn.beginPath();dn.moveTo(dc,0);dn.lineTo(c9,0);dn.closePath();dn.stroke()}dn.rotate(dh);dd+=dh}dn.translate(-bC,-bA);dn.restore()};var cr=function(dg){dg=dg||{};var dh=(undefined===dg.frame?false:dg.frame);var c9=(undefined===dg.background?false:dg.background);var dd=(undefined===dg.led?false:dg.led);var c8=(undefined===dg.pointer?false:dg.pointer);var df=(undefined===dg.foreground?false:dg.foreground);var db=(undefined===dg.trend?false:dg.trend);a8=true;bt();if(dh&&cV){g(bS,c1,bC,bA,bh,c0)}if(c9&&c5){a2(b7,bK,bC,bA,bh,c0);W(b7,ck,bC,bA,bh,c0)}if(dd){bW.drawImage(aj(Math.ceil(b1*0.093457),1,bO),0,0);a7.drawImage(aj(Math.ceil(b1*0.093457),0,bO),0,0)}if(b0){cR.drawImage(C(Math.ceil(b1*0.028037),steelseries.ColorDef.BLUE.dark.getRgbaColor(),true,true),0,0)}if(bU){a9.drawImage(C(Math.ceil(b1*0.028037),steelseries.ColorDef.RED.medium.getRgbaColor(),true),0,0)}if(c9&&c5){cp(b7);if(null!==cH&&0<cH.length){var de=cH.length;do{de--;a6(b7,cH[de].start,cH[de].stop,cH[de].color,false)}while(0<de)}if(null!==ba&&0<ba.length){var da=ba.length;do{da--;a6(b7,ba[da].start,ba[da].stop,ba[da].color,true)}while(0<da)}cl(b7,bN);au(b7,bh,c0,b9,bf,bK,true,true)}if(c9&&c6){b7.save();b7.translate(bC,bA);b7.rotate(cv+(cN-cx)*cM+cc);b7.translate(-bC,-bA);b7.drawImage(c3(),bh*0.475,c0*0.13);b7.translate(bC,bA);b7.restore()}if(c9&&bv){if(bo){ch=new aJ("",{_context:cS,height:b1*0.075,decimals:cI.decimals,digits:(cI.digits===undefined?5:cI.digits),valueForeColor:cI.valueForeColor,valueBackColor:cI.valueBackColor,decimalForeColor:cI.decimalForeColor,decimalBackColor:cI.decimalBackColor,font:cI.font,value:b2});bV=(bh-cm.width)/2}else{cA=ab(by,bE,cw);b7.drawImage(cA,cX,cW)}}if(c8){J(c4,bh,cz,cQ,bK.labelColor,false);J(ce,bh,cz,cQ,bK.labelColor,true)}if(df&&cC){var dc=(cz.type==="type15"||cz.type==="type16"?false:true);G(bi,cU,bh,c0,dc,cZ,cd,b8)}if(db&&b6){cj=am(bY,steelseries.TrendState.UP,cs);cy=am(bY,steelseries.TrendState.STEADY,cs);bu=am(bY,steelseries.TrendState.DOWN,cs);bB=am(bY,steelseries.TrendState.OFF,cs)}};var bj=function(c9){c9=c9||{};var db=(undefined===c9.frame?false:c9.frame);var dc=(undefined===c9.background?false:c9.background);var dd=(undefined===c9.led?false:c9.led);var da=(undefined===c9.pointer?false:c9.pointer);var c8=(undefined===c9.foreground?false:c9.foreground);if(db){co.width=b1;co.height=b1;bS=co.getContext("2d")}if(dc){b3.width=b1;b3.height=b1;b7=b3.getContext("2d")}if(dd){bs.width=Math.ceil(b1*0.093457);bs.height=Math.ceil(b1*0.093457);bW=bs.getContext("2d");bF.width=Math.ceil(b1*0.093457);bF.height=Math.ceil(b1*0.093457);a7=bF.getContext("2d");cn=bF}if(da){ca.width=b1;ca.height=b1;c4=ca.getContext("2d");bD.width=b1;bD.height=b1;ce=bD.getContext("2d");bn.width=b1;bn.height=b1;bx=bn.getContext("2d")}if(c8){cF.width=b1;cF.height=b1;bi=cF.getContext("2d")}};var cq=function(c8){if(c8){ct=setInterval(cB,1000)}else{clearInterval(ct)}};var cB=function(){if(be){if(cn===bs){cn=bF}else{cn=bs}cJ.repaint()}};this.setValue=function(c9){var c8=c9<cx?cx:(c9>cu?cu:c9);if(b2!==c8){b2=c8;if(b2>bZ){bZ=b2}if(b2<bz){bz=b2}if(b2>=cN&&!bG){bG=true;cq(bG);if(cY){a5.play()}}else{if(b2<cN){bG=false;cq(bG);if(cY){a5.pause()}}}this.repaint()}};this.getValue=function(){return b2};this.setOdoValue=function(c9){var c8=(c9<0?0:c9);if(cD!==c8){cD=c8;this.repaint()}};this.getOdoValue=function(){return cD};this.setValueAnimated=function(da){var c8=(da<cx?cx:(da>cu?cu:da));if(b2!==c8){if(undefined!==bk){if(bk.playing){bk.stop()}}bk=new Tween({},"",Tween.regularEaseInOut,b2,c8,1);var c9=this;bk.onMotionChanged=function(db){b2=db.target._pos;if(b2>=cN&&!bG){bG=true;cq(bG)}else{if(b2<cN){bG=false;cq(bG)}}if(b2>bZ){bZ=b2}if(b2<bz){bz=b2}c9.repaint()};bk.start()}};this.resetMinMeasuredValue=function(){bz=b2;this.repaint()};this.resetMaxMeasuredValue=function(){bZ=b2;this.repaint()};this.setMinMeasuredValueVisible=function(c8){b0=c8;this.repaint()};this.setMaxMeasuredValueVisible=function(c8){bU=c8;this.repaint()};this.setMaxMeasuredValue=function(c9){var c8=c9<cx?cx:(c9>cu?cu:c9);bZ=c8;this.repaint()};this.setMinMeasuredValue=function(c9){var c8=c9<cx?cx:(c9>cu?cu:c9);bz=c8;this.repaint()};this.setTitleString=function(c8){b9=c8;cr({background:true});this.repaint()};this.setUnitString=function(c8){bf=c8;cr({background:true});this.repaint()};this.setMinValue=function(c8){cx=c8;cr({frame:true,background:true});this.repaint()};this.getMinValue=function(){return cx};this.setMaxValue=function(c8){cu=c8;cr({frame:true,background:true});this.repaint()};this.getMaxValue=function(){return cu};this.setThreshold=function(c9){var c8=c9<cx?cx:(c9>cu?cu:c9);cN=c8;cr({background:true});this.repaint()};this.setArea=function(c8){ba=c8;bj({foreground:true});cr({background:true,foreground:true});this.repaint()};this.setSection=function(c8){cH=c8;bj({foreground:true});cr({background:true,foreground:true});this.repaint()};this.setThresholdVisible=function(c8){c6=c8;this.repaint()};this.setLcdDecimals=function(c8){c2=c8;this.repaint()};this.setFrameDesign=function(c8){bj({frame:true});c1=c8;cr({frame:true});this.repaint()};this.setBackgroundColor=function(c8){bj({background:true,pointer:true});bK=c8;cr({background:true,pointer:true});this.repaint()};this.setForegroundType=function(c8){bj({foreground:true});cU=c8;cr({foreground:true});this.repaint()};this.setPointerType=function(c8){bj({pointer:true,foreground:true});cz=c8;cr({pointer:true,foreground:true});this.repaint()};this.setPointerColor=function(c8){bj({pointer:true});cQ=c8;cr({pointer:true});this.repaint()};this.setLedColor=function(c8){bj({led:true});bO=c8;cr({led:true});this.repaint()};this.setLcdColor=function(c8){cw=c8;cr({background:true});this.repaint()};this.setTrend=function(c8){cO=c8;this.repaint()};this.setTrendVisible=function(c8){b6=c8;this.repaint()};this.repaint=function(){if(!a8){cr({frame:true,background:true,led:true,pointer:true,trend:true,foreground:true})}br.clearRect(0,0,br.canvas.width,br.canvas.height);if(cV){br.drawImage(co,0,0)}br.drawImage(b3,0,0);if(bv){if(bo){ch.setValue(bp?b2:cD);br.drawImage(cm,bV,bT)}else{cG(b2)}}if(be){if(b2<cN){bG=false;cn=bF}br.drawImage(cn,bd,bb)}if(b6){switch(cO.state){case"up":br.drawImage(cj,bQ,bP);break;case"steady":br.drawImage(cy,bQ,bP);break;case"down":br.drawImage(bu,bQ,bP);break;case"off":br.drawImage(bB,bQ,bP);break}}if(b0){br.save();br.translate(bC,bA);br.rotate(cv+cc+(bz-cx)*cM);br.translate(-bC,-bA);br.drawImage(bw,br.canvas.width*0.4865,br.canvas.height*0.105);br.restore()}if(bU){br.save();br.translate(bC,bA);br.rotate(cv+cc+(bZ-cx)*cM);br.translate(-bC,-bA);br.drawImage(b4,br.canvas.width*0.4865,br.canvas.height*0.105);br.restore()}bR=cv+cc+(b2-cx)*cM;var c8=bh*0.006;bx.clearRect(0,0,bh,c0);bx.save();bx.translate(bC,bA);bx.rotate(bR);bx.translate(-bC,-bA);bx.drawImage(bD,0,0);bx.restore();br.drawImage(bn,0,0,bh,c0,c8,c8,bh+c8,c0+c8);br.save();br.translate(bC,bA);br.rotate(bR);br.translate(-bC,-bA);br.drawImage(ca,0,0);br.restore();if(cC){br.drawImage(cF,0,0)}};this.repaint();return this};var E=function(cQ,bK){bK=bK||{};var b1=(undefined===bK.gaugeType?steelseries.GaugeType.TYPE4:bK.gaugeType);var bV=(undefined===bK.size?200:bK.size);var cn=(undefined===bK.minValue?0:bK.minValue);var ck=(undefined===bK.maxValue?(cn+100):bK.maxValue);var b8=(undefined===bK.niceScale?true:bK.niceScale);var cD=(undefined===bK.threshold?(ck-cn)/2:bK.threshold);var cz=(undefined===bK.section?null:bK.section);var b6=(undefined===bK.useSectionColors?false:bK.useSectionColors);var b2=(undefined===bK.titleString?"":bK.titleString);var bg=(undefined===bK.unitString?"":bK.unitString);var cN=(undefined===bK.frameDesign?steelseries.FrameDesign.METAL:bK.frameDesign);var cI=(undefined===bK.frameVisible?true:bK.frameVisible);var bG=(undefined===bK.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bK.backgroundColor);var cP=(undefined===bK.backgroundVisible?true:bK.backgroundVisible);var b4=(undefined===bK.valueColor?steelseries.ColorDef.RED:bK.valueColor);var cm=(undefined===bK.lcdColor?steelseries.LcdColor.STANDARD:bK.lcdColor);var bv=(undefined===bK.lcdVisible?true:bK.lcdVisible);var cO=(undefined===bK.lcdDecimals?2:bK.lcdDecimals);var bE=(undefined===bK.digitalFont?false:bK.digitalFont);var cA=(undefined===bK.fractionalScaleDecimals?1:bK.fractionalScaleDecimals);var cc=(undefined===bK.customLayer?null:bK.customLayer);var bM=(undefined===bK.ledColor?steelseries.LedColor.RED_LED:bK.ledColor);var bf=(undefined===bK.ledVisible?true:bK.ledVisible);var bL=(undefined===bK.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bK.labelNumberFormat);var cH=(undefined===bK.foregroundType?steelseries.ForegroundType.TYPE1:bK.foregroundType);var cs=(undefined===bK.foregroundVisible?true:bK.foregroundVisible);var cL=(undefined===bK.playAlarm?false:bK.playAlarm);var be=(undefined===bK.alarmSound?false:bK.alarmSound);var bh=(undefined===bK.valueGradient?null:bK.valueGradient);var bp=(undefined===bK.useValueGradient?false:bK.useValueGradient);var b7=(undefined===bK.tickLabelOrientation?(b1===steelseries.GaugeType.TYPE1?steelseries.TickLabelOrientation.TANGENT:steelseries.TickLabelOrientation.NORMAL):bK.tickLabelOrientation);var bZ=(undefined===bK.trendVisible?false:bK.trendVisible);var ci=(undefined===bK.trendColors?[steelseries.LedColor.RED_LED,steelseries.LedColor.GREEN_LED,steelseries.LedColor.CYAN_LED]:bK.trendColors);if(cL&&be!==false){var a8=H.createElement("audio");a8.setAttribute("src",be);a8.setAttribute("preload","auto")}var bW=cn;var bT=ck-cn;var bC=false;var cj=0;var bm;var cF;var cl;var bP;var bD;var cv;var bb;var cC;var bS=[];var a7=false;var bc=false;var br=H.getElementById(cQ).getContext("2d");br.clearRect(0,0,br.canvas.width,br.canvas.height);br.canvas.width=bV;br.canvas.height=bV;var bj=bV;var cM=bV;var bz=bj/2;var bw=cM/2;var cB=Math.floor(bj/10);var b9=cB+"px sans-serif";var bI=cB+"px "+aM;var bA=cM*0.13;var bx=bj*0.4;var cK=(bj-bx)/2;var cJ=cM/2-bA/2;var b5=Math.PI/2;var ct=bj*0.116822;var cq=bj*0.485981;var cu=Math.ceil(bV*0.093457);var a6=bj*0.53;var a5=cM*0.61;var bo=Math.PI/180;var cE=steelseries.TrendState.OFF;var bU=bV*0.06;var bO=bV*0.38;var bN=bV*0.57;switch(b1.type){case"type1":cF=0;cl=Math.PI;bP=0;bD=b5;cv=b5;bb=cv/Math.PI*180;cC=cv/bT;break;case"type2":cF=0;cl=Math.PI;bP=0;bD=b5;cv=Math.PI;bb=cv/Math.PI*180;cC=cv/bT;break;case"type3":cF=0;cl=b5;bP=-b5;bD=0;cv=1.5*Math.PI;bb=cv/Math.PI*180;cC=cv/bT;break;case"type4":default:cF=60*Math.PI/180;cl=b5+(cF/2);bP=-2*Math.PI/6;bD=0;cv=2*Math.PI-cF;bb=cv/Math.PI*180;cC=cv/bT;break}var cf=P(bV,bV);var bQ=cf.getContext("2d");var bX=P(bV,bV);var b0=bX.getContext("2d");var cp;var cy=P(Math.ceil(bV*0.060747),Math.ceil(bV*0.023364));var bd=cy.getContext("2d");var bt=P(cu,cu);var bR=bt.getContext("2d");var bB=P(cu,cu);var ba=bB.getContext("2d");var ce=bB;var bJ;var cw=P(bV,bV);var bk=cw.getContext("2d");var cb,co,bu,by;var a9=false;var bq=cn;var bF=ck;var bi=ck-cn;bT=bF-bq;var b3=0;var bn=0;var bY=10;var cG=10;var bs=function bs(){if(b8){bi=l(ck-cn,false);bn=l(bi/(cG-1),true);bq=Math.floor(cn/bn)*bn;bF=Math.ceil(ck/bn)*bn;b3=l(bn/(bY-1),true);cn=bq;ck=bF;bT=ck-cn}else{bi=(ck-cn);bq=cn;bF=ck;bT=bi;bn=l(bi/(cG-1),true);b3=l(bn/(bY-1),true)}switch(b1.type){case"type1":cF=0;cl=Math.PI;bD=b5;cv=b5;cC=cv/bT;break;case"type2":cF=0;cl=Math.PI;bD=b5;cv=Math.PI;cC=cv/bT;break;case"type3":cF=0;cl=b5;bD=0;cv=1.5*Math.PI;cC=cv/bT;break;case"type4":default:cF=60*bo;cl=b5+(cF/2);bD=0;cv=2*Math.PI-cF;cC=cv/bT;break}angle=cl+(bW-cn)*cC};var ch=function(cV){cV=cV||{};var cW=(undefined===cV.frame?false:cV.frame);var cY=(undefined===cV.background?false:cV.background);var cU=(undefined===cV.led?false:cV.led);var cT=(undefined===cV.value?false:cV.value);var cR=(undefined===cV.foreground?false:cV.foreground);var cS=(undefined===cV.trend?false:cV.trend);a9=true;bs();if(cW&&cI){g(bQ,cN,bz,bw,bj,cM)}if(cY&&cP){a2(b0,bG,bz,bw,bj,cM);W(b0,cc,bz,bw,bj,cM)}if(cU){bR.drawImage(aj(cu,1,bM),0,0);ba.drawImage(aj(cu,0,bM),0,0);bJ=b0.getImageData(a6,a5,cu,cu)}if(cY){ca(b0)}if(cY&&cP){cd(b0,bL);au(b0,bj,cM,b2,bg,bG,true,true)}if(cY&&bv){cp=ab(bx,bA,cm);b0.drawImage(cp,cK,cJ)}a7=false;if(b6&&null!==cz&&0<cz.length){a7=true;var cX=cz.length;bS=[];do{cX--;bS.push({start:(((cz[cX].start+Math.abs(cn))/(ck-cn))*bb),stop:(((cz[cX].stop+Math.abs(cn))/(ck-cn))*bb),color:x(cz[cX].color)})}while(0<cX)}bc=false;if(bp&&bh!==null){a7=false;bc=true}if(cT){bH(bd,b4)}if(cR&&cs){G(bk,cH,bj,cM,false,b1)}if(cS&&bZ){cb=am(bU,steelseries.TrendState.UP,ci);co=am(bU,steelseries.TrendState.STEADY,ci);bu=am(bU,steelseries.TrendState.DOWN,ci);by=am(bU,steelseries.TrendState.OFF,ci)}};var bl=function(cT){cT=cT||{};var cU=(undefined===cT.frame?false:cT.frame);var cV=(undefined===cT.background?false:cT.background);var cW=(undefined===cT.led?false:cT.led);var cS=(undefined===cT.value?false:cT.value);var cR=(undefined===cT.foreground?false:cT.foreground);if(cU){cf.width=bV;cf.height=bV;bQ=cf.getContext("2d")}if(cV){bX.width=bV;bX.height=bV;b0=bX.getContext("2d")}if(cS){cy.width=Math.ceil(bV*0.060747);cy.height=Math.ceil(bV*0.023364);bd=cy.getContext("2d")}if(cW){bt.width=Math.ceil(bV*0.093457);bt.height=Math.ceil(bV*0.093457);bR=bt.getContext("2d");bB.width=Math.ceil(bV*0.093457);bB.height=Math.ceil(bV*0.093457);ba=bB.getContext("2d");ce=bB}if(cR){cw.width=bV;cw.height=bV;bk=cw.getContext("2d")}};var ca=function(cS){cS.save();cS.save();cS.lineWidth=bV*0.085;cS.beginPath();cS.translate(bz,bw);cS.rotate(cl-4*bo);cS.translate(-bz,-bw);cS.arc(bz,bw,bj*0.35514,0,cv+8*bo,false);cS.rotate(-cl);var cR=cS.createLinearGradient(0,0.107476*cM,0,0.897195*cM);cR.addColorStop(0,"#000000");cR.addColorStop(0.22,"#333333");cR.addColorStop(0.76,"#333333");cR.addColorStop(1,"#cccccc");cS.strokeStyle=cR;cS.stroke();cS.restore();cS.save();cS.lineWidth=bV*0.075;cS.beginPath();cS.translate(bz,bw);cS.rotate(cl-4*bo);cS.translate(-bz,-bw);cS.arc(bz,bw,bj*0.35514,0,cv+8*bo,false);cS.rotate(-cl);var cU=cS.createLinearGradient(0,0.112149*cM,0,0.892523*cM);cU.addColorStop(0,"#111111");cU.addColorStop(1,"#333333");cS.strokeStyle=cU;cS.stroke();cS.restore();var cX=(bj*0.116822+bj*0.060747)/2;var cV=(bj*0.485981+bj*0.023364)/2;var cT=cS.createRadialGradient(cX,cV,0,cX,cV,0.030373*bj);cT.addColorStop(0,"#3c3c3c");cT.addColorStop(1,"#323232");for(var cW=0;cW<=bb;cW+=5){cS.save();cS.translate(bz,bw);cS.rotate((cW*bo)+bP);cS.translate(-bz,-bw);cS.beginPath();cS.rect(bj*0.116822,bj*0.485981,bj*0.060747,bj*0.023364);cS.closePath();cS.fillStyle=cT;cS.fill();cS.restore()}cS.restore()};var bH=function(cR,cS){cR.save();cR.beginPath();cR.rect(0,0,cR.canvas.width,cR.canvas.height);cR.closePath();var cV=(cR.canvas.width/2);var cU=(cR.canvas.height/2);var cT=br.createRadialGradient(cV,cU,0,cV,cU,cR.canvas.width/2);cT.addColorStop(0,cS.light.getRgbaColor());cT.addColorStop(1,cS.dark.getRgbaColor());cR.fillStyle=cT;cR.fill();cR.restore()};var cx=function(cR){br.save();br.textAlign="right";br.strokeStyle=cm.textColor;br.fillStyle=cm.textColor;if(cm===steelseries.LcdColor.STANDARD||cm===steelseries.LcdColor.STANDARD_GREEN){br.shadowColor="gray";br.shadowOffsetX=bj*0.007;br.shadowOffsetY=bj*0.007;br.shadowBlur=bj*0.007}if(bE){br.font=bI}else{br.font=b9}br.fillText(cR.toFixed(cO),cK+bx-bx*0.05,cJ+bA*0.5+cB*0.38,bx*0.9);br.restore()};var cd=function(c1,cV){bG.labelColor.setAlpha(1);c1.save();c1.textAlign="center";c1.textBaseline="middle";var c2=Math.ceil(bj*0.04);c1.font=c2+"px sans-serif";c1.strokeStyle=bG.labelColor.getRgbaColor();c1.fillStyle=bG.labelColor.getRgbaColor();c1.translate(bz,bw);c1.rotate(cl);var cS=cl;var cW=cC*b3;var cX;var cU=cn;var c0=bY-1;var cY=bj*0.28;var cR=bj*0.1;if(b1.type==="type1"||b1.type==="type2"){cR=bj*0.0375}var cZ=parseFloat(ck.toFixed(2));for(var cT=cn;parseFloat(cT.toFixed(2))<=cZ;cT+=b3){cX=+cW+b5;c0++;if(c0===bY){c1.save();c1.translate(cY,0);switch(b7.type){case"horizontal":cX=-cS;break;case"tangent":cX=(cS<=b5+Math.PI?Math.PI:0);break;case"normal":default:cX=b5;break}c1.rotate(cX);switch(cV.format){case"fractional":c1.fillText((cU.toFixed(cA)),0,0,cR);break;case"scientific":c1.fillText((cU.toPrecision(2)),0,0,cR);break;case"standard":default:c1.fillText((cU.toFixed(0)),0,0,cR);break}c1.translate(-cY,0);c1.restore();cU+=bn;c0=0;c1.rotate(cW);cS+=cW;continue}c1.rotate(cW);cS+=cW}c1.translate(-bz,-bw);c1.restore()};var cg=function(cR){if(cR){cj=setInterval(cr,1000)}else{clearInterval(cj)}};var cr=function(){if(bf){if(ce===bt){ce=bB}else{ce=bt}br.drawImage(ce,a6,a5)}};this.setValue=function(cS){var cR=(cS<cn?cn:(cS>ck?ck:cS));if(bW!==cR){bW=cR;if(bW>=cD&&!bC){bC=true;cg(bC);if(cL){a8.play()}}else{if(bW<cD){bC=false;cg(bC);if(cL){a8.pause()}}}this.repaint()}};this.getValue=function(){return bW};this.setValueAnimated=function(cT){var cR=(cT<cn?cn:(cT>ck?ck:cT));if(bW!==cR){if(undefined!==bm){if(bm.playing){bm.stop()}}bm=new Tween({},"",Tween.regularEaseInOut,bW,cR,1);var cS=this;bm.onMotionChanged=function(cU){bW=cU.target._pos;if(bW>=cD&&!bC){bC=true;cg(bC)}else{if(bW<cD){bC=false;cg(bC)}}cS.repaint()};bm.start()}};this.setFrameDesign=function(cR){bl({frame:true});cN=cR;ch({frame:true});this.repaint()};this.setBackgroundColor=function(cR){bl({background:true,led:true});bG=cR;ch({background:true,led:true});this.repaint()};this.setForegroundType=function(cR){bl({foreground:true});cH=cR;ch({foreground:true});this.repaint()};this.setValueColor=function(cR){bl({value:true});b4=cR;ch({value:true});this.repaint()};this.setLedColor=function(cR){bl({led:true});bM=cR;ch({led:true});this.repaint()};this.setLcdColor=function(cR){cm=cR;ch({background:true});this.repaint()};this.setSection=function(cR){cz=cR;ch();this.repaint()};this.setSectionActive=function(cR){b6=cR;ch();this.repaint()};this.setGradient=function(cR){bh=cR;ch();this.repaint()};this.setGradientActive=function(cR){useGradient=cR;ch();this.repaint()};this.setMinValue=function(cR){cn=cR;ch({background:true});this.repaint()};this.getMinValue=function(){return cn};this.setMaxValue=function(cR){ck=cR;ch({background:true});this.repaint()};this.getMaxValue=function(){return ck};this.setThreshold=function(cS){var cR=cS<cn?cn:(cS>ck?ck:cS);cD=cR;ch({background:true});this.repaint()};this.setTitleString=function(cR){b2=cR;ch({background:true});this.repaint()};this.setUnitString=function(cR){bg=cR;ch({background:true});this.repaint()};this.setTrend=function(cR){cE=cR;this.repaint()};this.setTrendVisible=function(cR){bZ=cR;this.repaint()};this.repaint=function(){if(!a9){ch({frame:true,background:true,led:true,value:true,trend:true,foreground:true})}br.clearRect(0,0,br.canvas.width,br.canvas.height);if(cI){br.drawImage(cf,0,0)}br.drawImage(bX,0,0);var cY=((bW+Math.abs(cn))/(ck-cn))*bb;var cR;var cW=b4;for(var cX=0;cX<=cY;cX+=5){cR=b4;if(bc){var cV=cn+(cX/bb)*(ck-cn);var cU=bh.getEnd()-bh.getStart();var cT=cV/cU;cT=Math.max(Math.min(cT,1),0);cR=x(bh.getColorAt(cT).getRgbaColor())}else{if(a7){for(var cS=0;cS<bS.length;cS++){if(cX>=bS[cS].start&&cX<bS[cS].stop){cR=bS[cS].color;break}}}}if(cW.medium.getHexColor()!=cR.medium.getHexColor()){bH(bd,cR);cW=cR}br.save();br.translate(bz,bw);br.rotate((cX*bo)+bP);br.translate(-bz,-bw);br.drawImage(cy,ct,cq);br.restore()}if(bv){cx(bW)}if(bf){if(bW<cD){bC=false;ce=bB}br.drawImage(ce,a6,a5)}if(bZ){switch(cE.state){case"up":br.drawImage(cb,bO,bN);break;case"steady":br.drawImage(co,bO,bN);break;case"down":br.drawImage(bu,bO,bN);break;case"off":br.drawImage(by,bO,bN);break}}if(cs){br.drawImage(cw,0,0)}};this.repaint();return this};var ah=function(cA,bD){bD=bD||{};var ch=(undefined===bD.orientation?steelseries.Orientation.NORTH:bD.orientation);var bN=(undefined===bD.size?200:bD.size);var cb=(undefined===bD.minValue?0:bD.minValue);var b9=(undefined===bD.maxValue?(cb+100):bD.maxValue);var b0=(undefined===bD.niceScale?true:bD.niceScale);var cl=(undefined===bD.threshold?(b9-cb)/2:bD.threshold);var ci=(undefined===bD.section?null:bD.section);var ba=(undefined===bD.area?null:bD.area);var bU=(undefined===bD.titleString?"":bD.titleString);var bf=(undefined===bD.unitString?"":bD.unitString);var cv=(undefined===bD.frameDesign?steelseries.FrameDesign.METAL:bD.frameDesign);var cq=(undefined===bD.frameVisible?true:bD.frameVisible);var bC=(undefined===bD.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bD.backgroundColor);var cy=(undefined===bD.backgroundVisible?true:bD.backgroundVisible);var cc=(undefined===bD.pointerType?steelseries.PointerType.TYPE1:bD.pointerType);var cn=(undefined===bD.pointerColor?steelseries.ColorDef.RED:bD.pointerColor);var ct=(undefined===bD.knobType?steelseries.KnobType.STANDARD_KNOB:bD.knobType);var bY=(undefined===bD.knobStyle?steelseries.KnobStyle.SILVER:bD.knobStyle);var bF=(undefined===bD.ledColor?steelseries.LedColor.RED_LED:bD.ledColor);var be=(undefined===bD.ledVisible?true:bD.ledVisible);var cz=(undefined===bD.thresholdVisible?true:bD.thresholdVisible);var bM=(undefined===bD.minMeasuredValueVisible?false:bD.minMeasuredValueVisible);var bI=(undefined===bD.maxMeasuredValueVisible?false:bD.maxMeasuredValueVisible);var cp=(undefined===bD.foregroundType?steelseries.ForegroundType.TYPE1:bD.foregroundType);var ce=(undefined===bD.foregroundVisible?true:bD.foregroundVisible);var bE=(undefined===bD.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bD.labelNumberFormat);var cs=(undefined===bD.playAlarm?false:bD.playAlarm);var bc=(undefined===bD.alarmSound?false:bD.alarmSound);if(cs&&bc!==false){var a5=H.createElement("audio");a5.setAttribute("src",bc);a5.setAttribute("preload","auto")}var bT=steelseries.GaugeType.TYPE5;var cj=this;var bO=cb;var bu=b9;var bL=cb;var bz=false;var b7=0;var bk;var bG=ca+(bO-cb)*ck;var bp=H.getElementById(cA).getContext("2d");bp.clearRect(0,0,bp.canvas.width,bp.canvas.height);bp.canvas.width=bN;bp.canvas.height=bN;var bg=bN;var cu=bN;var bw=bg/2;var bv=cu*0.733644;var bd=0.455*bg;var bb=0.51*cu;var bX=Math.PI/2;var bm=Math.PI/180;var cm=0;var ca=1.25*Math.PI;var bA=1.25*Math.PI;var cf=bX;var ck=cf/bK;var a8=false;var bo=cb;var bB=b9;var bh=b9-cb;var bK=bB-bo;var bW=0;var bl=0;var bR=10;var cr=10;var bq=function bq(){if(b0){bh=l(b9-cb,false);bl=l(bh/(cr-1),true);bo=Math.floor(cb/bl)*bl;bB=Math.ceil(b9/bl)*bl;bW=l(bl/(bR-1),true);cb=bo;b9=bB;bK=b9-cb}else{bh=(b9-cb);bo=cb;bB=b9;bK=bh;bW=1;bl=10}cm=0;ca=1.25*Math.PI;bA=1.25*Math.PI;cf=bX;ck=cf/bK;bG=ca+(bO-cb)*ck};var b3=P(bN,bN);var bH=b3.getContext("2d");var bP=P(bN,bN);var bS=bP.getContext("2d");var br=P(bN*0.093457,bN*0.093457);var bJ=br.getContext("2d");var by=P(bN*0.093457,bN*0.093457);var a7=by.getContext("2d");var b2=by;var bs=P(Math.ceil(bN*0.028037),Math.ceil(bN*0.028037));var co=bs.getContext("2d");var bQ=P(Math.ceil(bN*0.028037),Math.ceil(bN*0.028037));var a9=bQ.getContext("2d");var bV=P(bN,bN);var cx=bV.getContext("2d");var bx=P(bN,bN);var bZ=bx.getContext("2d");var bn=P(bN,bN);var bt=bn.getContext("2d");var cg=P(bN,bN);var bi=cg.getContext("2d");var b4=function(cB){if("type5"===bT.type){cB.save();switch(ch.type){case"west":cB.drawImage(K(Math.ceil(cu*0.037383),steelseries.KnobType.STANDARD_KNOB,bY),bg*0.44,cu*0.8);cB.drawImage(K(Math.ceil(cu*0.037383),steelseries.KnobType.STANDARD_KNOB,bY),bg*0.44,cu*0.16);break;default:cB.drawImage(K(Math.ceil(cu*0.037383),steelseries.KnobType.STANDARD_KNOB,bY),bg*0.2-cu*0.037383,cu*0.446666);cB.drawImage(K(Math.ceil(cu*0.037383),steelseries.KnobType.STANDARD_KNOB,bY),bg*0.8,cu*0.446666);break}cB.restore()}};var cw=function(){var cD=H.createElement("canvas");cD.width=Math.ceil(bN*0.046728);cD.height=Math.ceil(cD.width*0.9);var cC=cD.getContext("2d");cC.save();var cB=cC.createLinearGradient(0,0.1,0,cD.height*0.9);cB.addColorStop(0,"#520000");cB.addColorStop(0.3,"#fc1d00");cB.addColorStop(0.59,"#fc1d00");cB.addColorStop(1,"#520000");cC.fillStyle=cB;cC.beginPath();cC.moveTo(cD.width*0.5,0.1);cC.lineTo(cD.width*0.9,cD.height*0.9);cC.lineTo(cD.width*0.1,cD.height*0.9);cC.lineTo(cD.width*0.5,0.1);cC.closePath();cC.fill();cC.strokeStyle="#FFFFFF";cC.stroke();cC.restore();return cD};var a6=function(cB,cH,cE,cC,cF){cB.save();cB.strokeStyle=cC;cB.fillStyle=cC;cB.lineWidth=bg*0.035;var cD=(cf/bK*cH-cf/bK*cb);var cG=cD+(cE-cH)/(bK/cf);cB.translate(bw,bv);cB.rotate(ca);cB.beginPath();if(cF){cB.moveTo(0,0);cB.arc(0,0,bg*0.365-cB.lineWidth/2,cD,cG,false)}else{cB.arc(0,0,bg*0.365,cD,cG,false)}if(cF){cB.moveTo(0,0);cB.fill()}else{cB.stroke()}cB.translate(-bw,-bv);cB.restore()};var b8=function(cB){cB.save();cB.textAlign="left";cB.textBaseline="middle";cB.strokeStyle=bC.labelColor.getRgbaColor();cB.fillStyle=bC.labelColor.getRgbaColor();var cD=bg;if(!ac&&!vertical){cD=cu}cB.font=0.046728*bg+"px sans-serif";var cE=cB.measureText(bU).width;cB.fillText(bU,(bg-cE)/2,cu*0.4,bg*0.3);var cC=cB.measureText(bf).width;cB.fillText(bf,(bg-cC)/2,cu*0.47,bg*0.2);cB.restore()};var b1=function(cP,cI){bC.labelColor.setAlpha(1);cP.save();if(steelseries.Orientation.WEST===ch){cP.translate(bw,bw);cP.rotate(-Math.PI/2);cP.translate(-bw,-bw)}cP.textAlign="center";cP.textBaseline="middle";var cQ=Math.ceil(bg*0.04);cP.font=cQ+"px sans-serif";cP.strokeStyle=bC.labelColor.getRgbaColor();cP.fillStyle=bC.labelColor.getRgbaColor();cP.translate(bw,bv);cP.rotate(ca);var cJ=ck*bW;var cL;var cH=cb;var cO=bR-1;var cF=bg*0.44;var cD=bg*0.41;var cK=bg*0.415;var cC=bg*0.42;var cM=bg*0.48;var cB=bg*0.0375;var cE=bR/2;var cN=parseFloat(b9.toFixed(2));for(var cG=cb;parseFloat(cG.toFixed(2))<=cN;cG+=bW){cL=+cJ+bX;cO++;if(cO===bR){cP.lineWidth=1.5;cP.beginPath();cP.moveTo(cF,0);cP.lineTo(cD,0);cP.closePath();cP.stroke();cP.save();cP.translate(cM,0);cP.rotate(cL);switch(cI.format){case"fractional":cP.fillText((cH.toFixed(2)),0,0,cB);break;case"scientific":cP.fillText((cH.toPrecision(2)),0,0,cB);break;case"standard":default:cP.fillText((cH.toFixed(0)),0,0,cB);break}cP.translate(-cM,0);cP.restore();cH+=bl;cO=0;cP.rotate(cJ);continue}if(0===bR%2&&cO===(cE)){cP.lineWidth=1;cP.beginPath();cP.moveTo(cF,0);cP.lineTo(cK,0);cP.closePath();cP.stroke()}else{cP.lineWidth=0.5;cP.beginPath();cP.moveTo(cF,0);cP.lineTo(cC,0);cP.closePath();cP.stroke()}cP.rotate(cJ)}cP.translate(-bw,-bv);cP.restore()};var b6=function(cI){cI=cI||{};var cJ=(undefined===cI.frame?false:cI.frame);var cC=(undefined===cI.background?false:cI.background);var cF=(undefined===cI.led?false:cI.led);var cB=(undefined===cI.pointer?false:cI.pointer);var cH=(undefined===cI.foreground?false:cI.foreground);a8=true;bq();if(cJ&&cq){g(bH,cv,bw,bN/2,bg,cu)}if(cC&&cy){a2(bS,bC,bw,bN/2,bg,cu)}if(cF){bJ.drawImage(aj(Math.ceil(bN*0.093457),1,bF),0,0);a7.drawImage(aj(Math.ceil(bN*0.093457),0,bF),0,0)}if(bM){co.drawImage(C(Math.ceil(bN*0.028037),steelseries.ColorDef.BLUE.dark.getRgbaColor(),true,true),0,0);co.restore()}if(bI){a9.drawImage(C(Math.ceil(bN*0.028037),steelseries.ColorDef.RED.medium.getRgbaColor(),true),0,0);a9.restore()}if(cC&&cy){b4(bS);if(null!==ci&&0<ci.length){bS.save();if(steelseries.Orientation.WEST===ch){bS.translate(bw,bw);bS.rotate(-Math.PI/2);bS.translate(-bw,-bw)}var cG=ci.length;do{cG--;a6(bS,ci[cG].start,ci[cG].stop,ci[cG].color,false)}while(0<cG);bS.restore()}if(null!==ba&&0<ba.length){if(steelseries.Orientation.WEST===ch){bS.translate(bw,bw);bS.rotate(-Math.PI/2);bS.translate(-bw,-bw)}var cD=ba.length;do{cD--;a6(bS,ba[cD].start,ba[cD].stop,ba[cD].color,true)}while(0<cD);bS.restore()}b1(bS,bE);b8(bS)}if(cz){bS.save();if(steelseries.Orientation.WEST===ch){bS.translate(bw,bw);bS.rotate(-Math.PI/2);bS.translate(-bw,-bw)}bS.translate(bw,bv);bS.rotate(ca+(cl-cb)*ck+bX);bS.translate(-bw,-bv);bS.drawImage(cw(),bg*0.475,cu*0.32);bS.restore()}if(cB){J(cx,bg*1.17,cc,cn,bC.labelColor,false);J(bZ,bg*1.17,cc,cn,bC.labelColor,true)}if(cH&&ce){var cE=(cc.type==="type15"||cc.type==="type16"?false:true);G(bi,cp,bg,cu,cE,ct,bY,bT,ch)}};var bj=function(cC){cC=cC||{};var cE=(undefined===cC.frame?false:cC.frame);var cF=(undefined===cC.background?false:cC.background);var cG=(undefined===cC.led?false:cC.led);var cD=(undefined===cC.pointer?false:cC.pointer);var cB=(undefined===cC.foreground?false:cC.foreground);if(cE){b3.width=bN;b3.height=bN;bH=b3.getContext("2d")}if(cF){bP.width=bN;bP.height=bN;bS=bP.getContext("2d")}if(cG){br.width=Math.ceil(bN*0.093457);br.height=Math.ceil(bN*0.093457);bJ=br.getContext("2d");by.width=Math.ceil(bN*0.093457);by.height=Math.ceil(bN*0.093457);a7=by.getContext("2d");b2=by}if(cD){bV.width=bN;bV.height=bN;cx=bV.getContext("2d");bx.width=bN;bx.height=bN;bZ=bx.getContext("2d");bn.width=bN;bn.height=bN;bt=bn.getContext("2d")}if(cB){cg.width=bN;cg.height=bN;bi=cg.getContext("2d")}};var b5=function(cB){if(cB){b7=setInterval(cd,1000)}else{clearInterval(b7)}};var cd=function(){if(be){if(b2===br){b2=by}else{b2=br}cj.repaint()}};this.setValue=function(cC){var cB=(cC<cb?cb:(cC>b9?b9:cC));if(bO!==cB){bO=cB;if(bO>bL){bL=bO}if(bO<bu){bu=bO}if(bO>=cl&&!bz){bz=true;b5(bz);if(cs){a5.play()}}else{if(bO<cl){bz=false;b5(bz);if(cs){a5.pause()}}}this.repaint()}};this.getValue=function(){return bO};this.setValueAnimated=function(cD){var cB=(cD<cb?cb:(cD>b9?b9:cD));if(bO!==cB){if(undefined!==bk){if(bk.playing){bk.stop()}}bk=new Tween({},"",Tween.regularEaseInOut,bO,cB,1);var cC=this;bk.onMotionChanged=function(cE){bO=cE.target._pos;if(bO>=cl&&!bz){bz=true;b5(bz)}else{if(bO<cl){bz=false;b5(bz)}}if(bO>bL){bL=bO}if(bO<bu){bu=bO}cC.repaint()};bk.start()}};this.resetMinMeasuredValue=function(){bu=bO;this.repaint()};this.resetMaxMeasuredValue=function(){bL=bO;this.repaint()};this.setMinMeasuredValueVisible=function(cB){bM=cB;this.repaint()};this.setMaxMeasuredValueVisible=function(cB){bI=cB;this.repaint()};this.setThresholdVisible=function(cB){cz=cB;this.repaint()};this.setFrameDesign=function(cB){bj({frame:true});cv=cB;b6({frame:true});this.repaint()};this.setBackgroundColor=function(cB){bj({background:true,pointer:true});bC=cB;b6({background:true,pointer:true});this.repaint()};this.setForegroundType=function(cB){bj({foreground:true});cp=cB;b6({foreground:true});this.repaint()};this.setPointerType=function(cB){bj({pointer:true,foreground:true});cc=cB;b6({pointer:true,foreground:true});this.repaint()};this.setPointerColor=function(cB){bj({pointer:true});cn=cB;b6({pointer:true});this.repaint()};this.setLedColor=function(cB){bj({led:true});bF=cB;b6({led:true});this.repaint()};this.repaint=function(){if(!a8){b6({frame:true,background:true,led:true,pointer:true,foreground:true})}bp.clearRect(0,0,bp.canvas.width,bp.canvas.height);bp.save();if(cq){bp.drawImage(b3,0,0)}bp.drawImage(bP,0,0);if(be){if(bO<cl){bz=false;b2=by}bp.drawImage(b2,bd,bb)}if(steelseries.Orientation.WEST===ch){bp.translate(bw,bw);bp.rotate(-Math.PI/2);bp.translate(-bw,-bw)}if(bM){bp.save();bp.translate(bw,bv);bp.rotate(ca+bX+(bu-cb)*ck);bp.translate(-bw,-bv);bp.drawImage(bs,bp.canvas.width*0.4865,bp.canvas.height*0.27);bp.restore()}if(bI){bp.save();bp.translate(bw,bv);bp.rotate(ca+bX+(bL-cb)*ck);bp.translate(-bw,-bv);bp.drawImage(bQ,bp.canvas.width*0.4865,bp.canvas.height*0.27);bp.restore()}bG=ca+bX+(bO-cb)*ck;var cB=bg*0.006;bt.clearRect(0,0,bg,cu);bt.save();bt.translate(bw,bv);bt.rotate(bG);bt.translate(-bg*1.17/2,-bg*1.17/2);bt.drawImage(bx,0,0);bt.restore();if(steelseries.Orientation.NORTH===ch){bp.drawImage(bn,0,0,bg,cu,cB,cB,bg+cB,cu+cB)}else{bp.drawImage(bn,0,0,bg,cu,-cB,cB,bg-cB,cu+cB)}bp.save();bp.translate(bw,bv);bp.rotate(bG);bp.translate(-bg*1.17/2,-bg*1.17/2);bp.drawImage(bV,0,0);bp.restore();if(ce){bp.save();if(steelseries.Orientation.WEST===ch){bp.translate(bw,bw);bp.rotate(Math.PI/2);bp.translate(-bw,-bw)}bp.drawImage(cg,0,0);bp.restore()}bp.restore()};this.repaint();return this};var S=function(cq,bB){bB=bB||{};var bP=(undefined===bB.gaugeType?steelseries.GaugeType.TYPE1:bB.gaugeType);var ce=(undefined===bB.width?140:bB.width);var br=(undefined===bB.height?320:bB.height);var b6=(undefined===bB.minValue?0:bB.minValue);var b2=(undefined===bB.maxValue?(b6+100):bB.maxValue);var bU=(undefined===bB.niceScale?true:bB.niceScale);var cd=(undefined===bB.threshold?(b2-b6)/2:bB.threshold);var bQ=(undefined===bB.titleString?"":bB.titleString);var bd=(undefined===bB.unitString?"":bB.unitString);var ck=(undefined===bB.frameDesign?steelseries.FrameDesign.METAL:bB.frameDesign);var cg=(undefined===bB.frameVisible?true:bB.frameVisible);var bz=(undefined===bB.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bB.backgroundColor);var cn=(undefined===bB.backgroundVisible?true:bB.backgroundVisible);var bT=(undefined===bB.valueColor?steelseries.ColorDef.RED:bB.valueColor);var b3=(undefined===bB.lcdColor?steelseries.LcdColor.STANDARD:bB.lcdColor);var bq=(undefined===bB.lcdVisible?true:bB.lcdVisible);var cl=(undefined===bB.lcdDecimals?2:bB.lcdDecimals);var bx=(undefined===bB.digitalFont?false:bB.digitalFont);var bD=(undefined===bB.ledColor?steelseries.LedColor.RED_LED:bB.ledColor);var bc=(undefined===bB.ledVisible?true:bB.ledVisible);var cp=(undefined===bB.thresholdVisible?true:bB.thresholdVisible);var bJ=(undefined===bB.minMeasuredValueVisible?false:bB.minMeasuredValueVisible);var bF=(undefined===bB.maxMeasuredValueVisible?false:bB.maxMeasuredValueVisible);var bC=(undefined===bB.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bB.labelNumberFormat);var b9=(undefined===bB.foregroundVisible?true:bB.foregroundVisible);var ci=(undefined===bB.playAlarm?false:bB.playAlarm);var ba=(undefined===bB.alarmSound?false:bB.alarmSound);if(ci&&ba!==false){var a5=H.createElement("audio");a5.setAttribute("src",ba);a5.setAttribute("preload","auto")}var cc=this;var bK=b6;var bt=b2;var bI=b6;if(bP.type!=="type1"&&bP.type!=="type2"){bP=steelseries.GaugeType.TYPE1}var bj;var bw=false;var b1=0;var bn=H.getElementById(cq).getContext("2d");bn.clearRect(0,0,bn.canvas.width,bn.canvas.height);bn.canvas.width=ce;bn.canvas.height=br;var be=ce;var cj=br;var bu=ce<=br;var bb;var a9;var bl=Math.round((bu?br:ce)*0.05);var b4=Math.round((bu?ce:br)*0.05);var bV;var bA;if(bu){bb=be/2-bl/2;a9=(bP.type==="type1"?0.053:0.038)*cj;bV=Math.floor(cj/22)+"px sans-serif";bA=Math.floor(cj/22)+"px "+aM}else{bb=0.89*be;a9=cj/2-bl/2;bV=Math.floor(cj/10)+"px sans-serif";bA=Math.floor(cj/10)+"px "+aM}var a7=false;var bm=b6;var by=b2;var bf=b2-b6;var bH=by-bm;var bS=0;var bk=0;var bN=10;var ch=10;var bo=function bo(){if(bU){bf=l(b2-b6,false);bk=l(bf/(ch-1),true);bm=Math.floor(b6/bk)*bk;by=Math.ceil(b2/bk)*bk;bS=l(bk/(bN-1),true);b6=bm;b2=by;bH=b2-b6}else{bf=(b2-b6);bm=b6;by=b2;bH=bf;bS=1;bk=10}};var bY=P(ce,br);var bE=bY.getContext("2d");var bL=P(ce,br);var bO=bL.getContext("2d");var b7;var bp=P(bl,bl);var bG=bp.getContext("2d");var bv=P(bl,bl);var a6=bv.getContext("2d");var bX=bv;var bs=P(b4,b4);var cf=bs.getContext("2d");var bM=P(b4,b4);var a8=bM.getContext("2d");var ca=P(ce,br);var bg=ca.getContext("2d");var cb=function(cr,cw,cs){cr.save();cr.textAlign="right";cr.textBaseline="middle";cr.strokeStyle=b3.textColor;cr.fillStyle=b3.textColor;if(b3===steelseries.LcdColor.STANDARD||b3===steelseries.LcdColor.STANDARD_GREEN){cr.shadowColor="gray";if(cs){cr.shadowOffsetX=cj*0.003;cr.shadowOffsetY=cj*0.003;cr.shadowBlur=cj*0.004}else{cr.shadowOffsetX=cj*0.007;cr.shadowOffsetY=cj*0.007;cr.shadowBlur=cj*0.009}}var cu;var ct;var cv;if(bx){cr.font=bA}else{cr.font=bV}if(cs){cu=(be-(be*0.571428))/2+be*0.571428-2;ct=cj*0.88+1+(cj*0.055-2)/2;cv=be*0.7-2}else{cu=(be*0.695)+be*0.18-2;ct=(cj*0.22)+1+(cj*0.15-2)/2;cv=cj*0.22-2}cr.fillText(cw.toFixed(cl),cu,ct,cv);cr.restore()};var cm=function(cr){var cu=H.createElement("canvas");cu.height=cu.width=b4;cu.width;var ct=cu.getContext("2d");ct.save();var cs=ct.createLinearGradient(0,0.1,0,cu.height*0.9);cs.addColorStop(0,"#520000");cs.addColorStop(0.3,"#fc1d00");cs.addColorStop(0.59,"#fc1d00");cs.addColorStop(1,"#520000");ct.fillStyle=cs;if(cr){ct.beginPath();ct.moveTo(0.1,cu.height*0.5);ct.lineTo(cu.width*0.9,0.1);ct.lineTo(cu.width*0.9,cu.height*0.9);ct.closePath()}else{ct.beginPath();ct.moveTo(0.1,0.1);ct.lineTo(cu.width*0.9,0.1);ct.lineTo(cu.width*0.5,cu.height*0.9);ct.closePath()}ct.fill();ct.strokeStyle="#FFFFFF";ct.stroke();ct.restore();return cu};var bW=function(cD,cv,cs){bz.labelColor.setAlpha(1);cD.save();cD.textBaseline="middle";var cA=be*0.1;cD.strokeStyle=bz.labelColor.getRgbaColor();cD.fillStyle=bz.labelColor.getRgbaColor();var cx=b6;var cw=bN-1;var cG;var cF;var cH;var cu;var cI=1;var ct;var cJ;var cz;var cr;var cB;var cy;if(cs){ct=(0.34*be);cJ=(0.36*be);cz=(0.33*be);cr=(0.36*be);cB=(0.32*be);cy=(0.36*be);cD.textAlign="right";cG=0;cF=cj*0.12864;cH=0;if(bP.type==="type1"){cu=(cj*0.856796-cj*0.12864)}else{cu=(cj*0.7475-cj*0.12864)}cI=cu/(b2-b6)}else{ct=(0.65*cj);cJ=(0.63*cj);cz=(0.66*cj);cr=(0.63*cj);cB=(0.67*cj);cy=(0.63*cj);cD.textAlign="center";cF=0;if(bP.type==="type1"){cG=be*0.142857;cH=(be*0.871012-cG)}else{cG=be*0.19857;cH=(be*0.82-cG)}cu=0;cI=cH/(b2-b6)}for(var cE=b6,cC=0;cE<=b2;cE+=bS,cC+=bS){if(cs){currentPos=cF+cu-cC*cI}else{currentPos=cG+cC*cI}cw++;if(cw===bN){cD.lineWidth=1.5;co(cD,cB,cy,currentPos,cs);if(cs){switch(cv.format){case"fractional":cD.fillText((cx.toFixed(2)),be*0.28,currentPos,cA);break;case"scientific":cD.fillText((cx.toPrecision(2)),be*0.28,currentPos,cA);break;case"standard":default:cD.fillText((cx.toFixed(0)),be*0.28,currentPos,cA);break}}else{switch(cv.format){case"fractional":cD.fillText((cx.toFixed(2)),currentPos,(cj*0.73),cA);break;case"scientific":cD.fillText((cx.toPrecision(2)),currentPos,(cj*0.73),cA);break;case"standard":default:cD.fillText((cx.toFixed(0)),currentPos,(cj*0.73),cA);break}}cx+=bk;cw=0;continue}if(0===bN%2&&cw===(bN/2)){cD.lineWidth=1;co(cD,cz,cr,currentPos,cs)}else{cD.lineWidth=0.5;co(cD,ct,cJ,currentPos,cs)}}cD.restore()};var co=function(cr,cu,cv,ct,cs){if(cs){cr.beginPath();cr.moveTo(cu,ct);cr.lineTo(cv,ct);cr.closePath();cr.stroke()}else{cr.beginPath();cr.moveTo(ct,cu);cr.lineTo(ct,cv);cr.closePath();cr.stroke()}};var b0=function(cu){cu=cu||{};var cv=(undefined===cu.frame?false:cu.frame);var cw=(undefined===cu.background?false:cu.background);var ct=(undefined===cu.led?false:cu.led);var cr=(undefined===cu.foreground?false:cu.foreground);a7=true;bo();if(cv&&cg){p(bE,ck,be,cj,bu)}if(cw&&cn){ad(bO,bz,be,cj,bu)}if(cw&&bP.type==="type2"){bh(bO)}if(ct){if(bu){bG.drawImage(aj(bl,1,bD),0,0);a6.drawImage(aj(bl,0,bD),0,0)}else{bG.drawImage(aj(bl,1,bD),0,0);a6.drawImage(aj(bl,0,bD),0,0)}}if(bJ){if(bu){cf.drawImage(C(b4,steelseries.ColorDef.BLUE.dark.getRgbaColor(),false,bu),0,0)}else{cf.drawImage(C(b4,steelseries.ColorDef.BLUE.dark.getRgbaColor(),false,bu),0,0)}}if(bF){if(bu){a8.drawImage(C(b4,steelseries.ColorDef.RED.medium.getRgbaColor(),false,bu),0,0)}else{a8.drawImage(C(b4,steelseries.ColorDef.RED.medium.getRgbaColor(),false,bu),0,0)}}if(cw&&cn){bW(bO,bC,bu);var cs;if(bu){au(bO,be,cj,bQ,bd,bz,bu,null,bq,bP)}else{au(bO,be,cj,bQ,bd,bz,bu,null,bq,bP)}}if(cw&&cp){bO.save();if(bu){var cx=(bP.type==="type1"?0.856796:0.7475);var cy=cx-0.12864;cs=cj*cx-(cj*cy)*(cd/(b2-b6));bO.translate(be*0.365,cs-b4/2)}else{var cx=(bP.type==="type1"?0.871012:0.82);var cy=cx-(bP.type==="type1"?0.142857:0.19857);cs=be*cy*cd/(b2-b6);bO.translate(be*(bP.type==="type1"?0.142857:0.19857)-b4/2+cs,cj*0.58)}bO.drawImage(cm(bu),0,0);bO.restore()}if(cw&&bq){if(bu){b7=ab(be*0.571428,cj*0.055,b3);bO.drawImage(b7,((be-(be*0.571428))/2),cj*0.88)}else{b7=ab(be*0.18,cj*0.15,b3);bO.drawImage(b7,be*0.695,cj*0.22)}}if(cr&&bP.type==="type2"){bR(bg)}if(cr&&b9){aS(bg,be,cj,bu,false)}};var bi=function(cs){cs=cs||{};var ct=(undefined===cs.frame?false:cs.frame);var cu=(undefined===cs.background?false:cs.background);var cv=(undefined===cs.led?false:cs.led);var cr=(undefined===cs.foreground?false:cs.foreground);if(ct){bY.width=ce;bY.height=br;bE=bY.getContext("2d")}if(cu){bL.width=ce;bL.height=br;bO=bL.getContext("2d")}if(cv){bp.width=Math.ceil(ce*0.093457);bp.height=Math.ceil(br*0.093457);bG=bp.getContext("2d");bv.width=Math.ceil(ce*0.093457);bv.height=Math.ceil(br*0.093457);a6=bv.getContext("2d");bX=bv}if(cr){ca.width=ce;ca.height=br;bg=ca.getContext("2d")}};var bZ=function(cr){if(cr){b1=setInterval(b8,1000)}else{clearInterval(b1)}};var b8=function(){if(bc){if(bX===bp){bX=bv}else{bX=bp}cc.repaint()}};var b5=function(cN,cE,cS){var cL;var cD;var cT=bz.labelColor;var cM;var cw,cV;var cC,cB,cQ,cO;var cz,cx,ct,cs;var cA,cy,cK,cI;var cR,cP,cJ,cH;if(bu){cL=cS*0.12864;if(bP.type==="type1"){cD=cS*0.856796}else{cD=cS*0.7475}cM=cD-cL;cw=cM*(bK-b6)/(b2-b6);cV=cD-cw;cz=0;cx=cL;ct=0;cs=cD}else{if(bP.type==="type1"){cL=cE*0.871012;cD=cE*0.142857}else{cL=cE*0.82;cD=cE*0.19857}cM=cL-cD;cw=cM*(bK-b6)/(b2-b6);cV=cD;cz=cL;cx=0;ct=cD;cs=0}if(bP.type==="type1"){var cv=(bz===steelseries.BackgroundColor.CARBON||bz===steelseries.BackgroundColor.PUNCHED_SHEET||bz===steelseries.BackgroundColor.STAINLESS||bz===steelseries.BackgroundColor.BRUSHED_STAINLESS||bz===steelseries.BackgroundColor.TURNED)?0.3:0;var cU=cN.createLinearGradient(cz,cx,ct,cs);cT.setAlpha(0.05+cv);cU.addColorStop(0,cT.getRgbaColor());cT.setAlpha(0.15+cv);cU.addColorStop(0.48,cT.getRgbaColor());cT.setAlpha(0.15+cv);cU.addColorStop(0.49,cT.getRgbaColor());cT.setAlpha(0.05+cv);cU.addColorStop(1,cT.getRgbaColor());cN.fillStyle=cU;if(bu){cN.fillRect(cE*0.435714,cL,cE*0.142857,cM)}else{cN.fillRect(cE*0.142857,cS*0.435714,cM,cS*0.142857)}if(bu){cA=0;cy=cL;cK=0;cI=cL+cM}else{cA=cE*0.142857+cM;cy=0;cK=cE*0.142857;cI=0}var cr=cN.createLinearGradient(cA,cy,cK,cI);cT.setAlpha(0.3+cv);cr.addColorStop(0,cT.getRgbaColor());cT.setAlpha(0.69);cr.addColorStop(0.48,cT.getRgbaColor());cT.setAlpha(0.7);cr.addColorStop(0.49,cT.getRgbaColor());cT.setAlpha(0.4);cr.addColorStop(1,cT.getRgbaColor());cN.fillStyle=cr;if(bu){cN.fillRect(cE*0.435714,cL,cE*0.007142,cM);cN.fillRect(cE*0.571428,cL,cE*0.007142,cM)}else{cN.fillRect(cE*0.142857,cS*0.435714,cM,cS*0.007142);cN.fillRect(cE*0.142857,cS*0.571428,cM,cS*0.007142)}}if(bu){if(bP.type==="type1"){cC=cE*0.45;cB=0;cQ=cE*0.45+cE*0.114285;cO=0}else{cC=cE/2-cS*0.0486/2;cB=0;cQ=cC+cS*0.053;cO=0}}else{if(bP.type==="type1"){cC=0;cB=cS*0.45;cQ=0;cO=cS*0.45+cS*0.114285}else{cC=0;cB=cS/2-cE*0.025;cQ=0;cO=cB+cE*0.053}}var cG=cN.createLinearGradient(cC,cB,cQ,cO);cG.addColorStop(0,bT.medium.getRgbaColor());cG.addColorStop(1,bT.light.getRgbaColor());cN.fillStyle=cG;var cF=(bP.type==="type1"?0:(bu?cS*0.05:cE*0.05));if(bu){cN.fillRect(cC,cV,cQ-cC,cw+cF)}else{cN.fillRect(cV-cF,cB,cw+cF,cO-cB)}if(bP.type==="type1"){if(bu){cR=cE*0.45;cP=0;cJ=cR+cE*0.05;cH=0}else{cR=0;cP=cS*0.45;cJ=0;cH=cP+cS*0.05}var cu=cN.createLinearGradient(cR,cP,cJ,cH);cu.addColorStop(0,"rgba(255, 255, 255, 0.7)");cu.addColorStop(0.98,"rgba(255, 255, 255, 0.0)");cN.fillStyle=cu;if(bu){cN.fillRect(cR,cV,cJ,cw)}else{cN.fillRect(cV,cP,cw,cH-cP)}}};var bR=function(cs){var cr=(bu?cj:be);cs.save();if(bu){cs.translate(be/2,0)}else{cs.translate(be/2,cj/2);cs.rotate(Math.PI*0.5);cs.translate(0,-be/2+be*0.05)}cs.beginPath();cs.moveTo(-0.049*cr,0.825*cr);cs.bezierCurveTo(-0.049*cr,0.7975*cr,-0.0264*cr,0.775*cr,0.0013*cr,0.775*cr);cs.bezierCurveTo(0.0264*cr,0.775*cr,0.049*cr,0.7975*cr,0.049*cr,0.825*cr);cs.bezierCurveTo(0.049*cr,0.85*cr,0.0264*cr,0.8725*cr,0.0013*cr,0.8725*cr);cs.bezierCurveTo(-0.0264*cr,0.8725*cr,-0.049*cr,0.85*cr,-0.049*cr,0.825*cr);cs.closePath();var ct=cs.createRadialGradient(0*cr,0.825*cr,0,0*cr,0.825*cr,0.049*cr);ct.addColorStop(0,bT.medium.getRgbaColor());ct.addColorStop(0.3,bT.medium.getRgbaColor());ct.addColorStop(1,bT.light.getRgbaColor());cs.fillStyle=ct;cs.fill();cs.beginPath();if(bu){cs.moveTo(-0.0365*cr,0.8075*cr);cs.bezierCurveTo(-0.0365*cr,0.7925*cr,-0.0214*cr,0.7875*cr,-0.0214*cr,0.7825*cr);cs.bezierCurveTo(0.0189*cr,0.785*cr,0.0365*cr,0.7925*cr,0.0365*cr,0.8075*cr);cs.bezierCurveTo(0.0365*cr,0.8175*cr,0.0214*cr,0.815*cr,0.0013*cr,0.8125*cr);cs.bezierCurveTo(-0.0189*cr,0.8125*cr,-0.0365*cr,0.8175*cr,-0.0365*cr,0.8075*cr);ct=cs.createRadialGradient(0,0.8*cr,0,0,0.8*cr,0.0377*cr)}else{cs.beginPath();cs.moveTo(-0.0214*cr,0.86*cr);cs.bezierCurveTo(-0.0365*cr,0.86*cr,-0.0415*cr,0.845*cr,-0.0465*cr,0.825*cr);cs.bezierCurveTo(-0.0465*cr,0.805*cr,-0.0365*cr,0.7875*cr,-0.0214*cr,0.7875*cr);cs.bezierCurveTo(-0.0113*cr,0.7875*cr,-0.0163*cr,0.8025*cr,-0.0163*cr,0.8225*cr);cs.bezierCurveTo(-0.0163*cr,0.8425*cr,-0.0113*cr,0.86*cr,-0.0214*cr,0.86*cr);ct=cs.createRadialGradient(-0.03*cr,0.8225*cr,0,-0.03*cr,0.8225*cr,0.0377*cr)}ct.addColorStop(0,"rgba(255, 255, 255, 0.55)");ct.addColorStop(1,"rgba(255, 255, 255, 0.05)");cs.fillStyle=ct;cs.closePath();cs.fill();cs.beginPath();cs.moveTo(-0.0214*cr,0.115*cr);cs.bezierCurveTo(-0.0214*cr,0.1075*cr,-0.0163*cr,0.1025*cr,-0.0113*cr,0.1025*cr);cs.bezierCurveTo(-0.0113*cr,0.1025*cr,-0.0113*cr,0.1025*cr,-0.0113*cr,0.1025*cr);cs.bezierCurveTo(-0.0038*cr,0.1025*cr,0.0013*cr,0.1075*cr,0.0013*cr,0.115*cr);cs.bezierCurveTo(0.0013*cr,0.115*cr,0.0013*cr,0.76*cr,0.0013*cr,0.76*cr);cs.bezierCurveTo(0.0013*cr,0.7675*cr,-0.0038*cr,0.7725*cr,-0.0113*cr,0.7725*cr);cs.bezierCurveTo(-0.0113*cr,0.7725*cr,-0.0113*cr,0.7725*cr,-0.0113*cr,0.7725*cr);cs.bezierCurveTo(-0.0163*cr,0.7725*cr,-0.0214*cr,0.7675*cr,-0.0214*cr,0.76*cr);cs.bezierCurveTo(-0.0214*cr,0.76*cr,-0.0214*cr,0.115*cr,-0.0214*cr,0.115*cr);cs.closePath();ct=cs.createLinearGradient(-0.0189*cr,0,0.0013*cr,0);ct.addColorStop(0,"rgba(255, 255, 255, 0.1)");ct.addColorStop(0.34,"rgba(255, 255, 255, 0.5)");ct.addColorStop(1,"rgba(255, 255, 255, 0.1)");cs.fillStyle=ct;cs.fill();cs.restore()};var bh=function(cs){var cr=(bu?cj:be);cs.save();if(bu){cs.translate(be/2,0)}else{cs.translate(be/2,cj/2);cs.rotate(Math.PI*0.5);cs.translate(0,-be/2+be*0.05)}cs.beginPath();cs.moveTo(-0.0516*cr,0.825*cr);cs.bezierCurveTo(-0.0516*cr,0.8525*cr,-0.0289*cr,0.875*cr,0.0013*cr,0.875*cr);cs.bezierCurveTo(0.0289*cr,0.875*cr,0.0516*cr,0.8525*cr,0.0516*cr,0.825*cr);cs.bezierCurveTo(0.0516*cr,0.8075*cr,0.044*cr,0.7925*cr,0.0314*cr,0.7825*cr);cs.bezierCurveTo(0.0314*cr,0.7825*cr,0.0314*cr,0.12*cr,0.0314*cr,0.12*cr);cs.bezierCurveTo(0.0314*cr,0.1025*cr,0.0189*cr,0.0875*cr,0.0013*cr,0.0875*cr);cs.bezierCurveTo(-0.0163*cr,0.0875*cr,-0.0289*cr,0.1025*cr,-0.0289*cr,0.12*cr);cs.bezierCurveTo(-0.0289*cr,0.12*cr,-0.0289*cr,0.7825*cr,-0.0289*cr,0.7825*cr);cs.bezierCurveTo(-0.0415*cr,0.79*cr,-0.0516*cr,0.805*cr,-0.0516*cr,0.825*cr);cs.closePath();var ct=cs.createLinearGradient(-0.0163*cr,0,0.0289*cr,0);ct.addColorStop(0,"rgba(226, 226, 226, 0.5)");ct.addColorStop(0.5,"rgba(226, 226, 226, 0.2)");ct.addColorStop(1,"rgba(226, 226, 226, 0.5)");cs.fillStyle=ct;cs.fill();cs.lineWidth=1;cs.strokeStyle="rgba(153, 153, 153, 0.5)";cs.stroke();cs.restore()};this.setValue=function(cs){var cr=(cs<b6?b6:(cs>b2?b2:cs));if(bK!==cr){bK=cr;if(bK>bI){bI=bK}if(bK<bt){bt=bK}if(bK>=cd&&!bw){bw=true;bZ(bw);if(ci){a5.play()}}else{if(bK<cd){bw=false;bZ(bw);if(ci){a5.pause()}}}this.repaint()}};this.getValue=function(){return bK};this.setValueAnimated=function(ct){var cr=(ct<b6?b6:(ct>b2?b2:ct));if(bK!==cr){if(undefined!==bj){if(bj.playing){bj.stop()}}bj=new Tween({},"",Tween.regularEaseInOut,bK,cr,1);var cs=this;bj.onMotionChanged=function(cu){cs.setValue(cu.target._pos)};bj.start()}};this.resetMinMeasuredValue=function(){bt=bK;this.repaint()};this.resetMaxMeasuredValue=function(){bI=bK;this.repaint()};this.setMinMeasuredValueVisible=function(cr){bJ=cr;this.repaint()};this.setMaxMeasuredValueVisible=function(cr){bF=cr;this.repaint()};this.setThresholdVisible=function(cr){cp=cr;this.repaint()};this.setLcdDecimals=function(cr){cl=cr;this.repaint()};this.setFrameDesign=function(cr){bi({frame:true});ck=cr;b0({frame:true});this.repaint()};this.setBackgroundColor=function(cr){bi({background:true});bz=cr;b0({background:true});this.repaint()};this.setValueColor=function(cr){bi({foreground:true});bT=cr;b0({foreground:true});this.repaint()};this.setLedColor=function(cr){bi({led:true});bD=cr;b0({led:true});this.repaint()};this.setLcdColor=function(cr){bi({background:true});b3=cr;b0({background:true});this.repaint()};this.setMaxMeasuredValue=function(cr){var cs=(cr<b6?b6:(cr>b2?b2:cr));bI=cs;this.repaint()};this.setMinMeasuredValue=function(cr){var cs=(cr<b6?b6:(cr>b2?b2:cr));bt=cs;this.repaint()};this.setTitleString=function(cr){bQ=cr;b0({background:true});this.repaint()};this.setUnitString=function(cr){bd=cr;b0({background:true});this.repaint()};this.setMinValue=function(cr){bi({background:true});b6=cr;if(mminMeasuredValue<b6){bt=b6}if(bK<b6){bK=b6}b0({background:true});this.repaint()};this.getMinValue=function(){return b6};this.setMaxValue=function(cr){bi({background:true});b2=cr;if(bI>b2){bI=b2}if(bK>b2){bK=b2}b0({background:true});this.repaint()};this.getMaxValue=function(){return b2};this.setThreshold=function(cr){var cs=(cr<b6?b6:(cr>b2?b2:cr));cd=cs;b0({background:true});this.repaint()};this.repaint=function(){if(!a7){b0({frame:true,background:true,led:true,foreground:true})}bn.clearRect(0,0,bn.canvas.width,bn.canvas.height);if(cg){bn.drawImage(bY,0,0)}bn.drawImage(bL,0,0);if(bq){cb(bn,bK,bu)}if(bc){if(bK<cd){bw=false;bX=bv}bn.drawImage(bX,bb,a9)}var ct;var cu;var cv;var cs,cr;if(bJ){if(bu){cu=(bP.type==="type1"?0.856796:0.7475);cv=(cu-0.12864);ct=cj*cu-(cj*cv)*(bt/(b2-b6));cs=be*0.34-bs.width;cr=ct-bs.height/2}else{cu=(bP.type==="type1"?0.871012:0.82);cv=cu-(bP.type==="type1"?0.142857:0.19857);ct=(be*cv)*bt/(b2-b6);cs=be*(bP.type==="type1"?0.142857:0.19857)-bs.height/2+ct;cr=cj*0.65}bn.drawImage(bs,cs,cr)}if(bF){if(bu){ct=cj*cu-(cj*cv)*(bI/(b2-b6));cs=be*0.34-bM.width;cr=ct-bM.height/2}else{cu=(bP.type==="type1"?0.871012:0.8);cv=cu-(bP.type==="type1"?0.14857:0.19857);ct=(be*cv)*bI/(b2-b6);cs=be*(bP.type==="type1"?0.142857:0.19857)-bM.height/2+ct;cr=cj*0.65}bn.drawImage(bM,cs,cr)}bn.save();b5(bn,be,cj);bn.restore();if(b9||bP.type==="type2"){bn.drawImage(ca,0,0)}};this.repaint();return this};var F=function(cB,bI){bI=bI||{};var co=(undefined===bI.width?140:bI.width);var bw=(undefined===bI.height?320:bI.height);var cd=(undefined===bI.minValue?0:bI.minValue);var b9=(undefined===bI.maxValue?(cd+100):bI.maxValue);var ck=(undefined===bI.section?null:bI.section);var bZ=(undefined===bI.useSectionColors?false:bI.useSectionColors);var b0=(undefined===bI.niceScale?true:bI.niceScale);var cn=(undefined===bI.threshold?(b9-cd)/2:bI.threshold);var bW=(undefined===bI.titleString?"":bI.titleString);var bh=(undefined===bI.unitString?"":bI.unitString);var cv=(undefined===bI.frameDesign?steelseries.FrameDesign.METAL:bI.frameDesign);var cq=(undefined===bI.frameVisible?true:bI.frameVisible);var bF=(undefined===bI.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bI.backgroundColor);var cy=(undefined===bI.backgroundVisible?true:bI.backgroundVisible);var bY=(undefined===bI.valueColor?steelseries.ColorDef.RED:bI.valueColor);var ca=(undefined===bI.lcdColor?steelseries.LcdColor.STANDARD:bI.lcdColor);var bv=(undefined===bI.lcdVisible?true:bI.lcdVisible);var cw=(undefined===bI.lcdDecimals?2:bI.lcdDecimals);var bC=(undefined===bI.digitalFont?false:bI.digitalFont);var bK=(undefined===bI.ledColor?steelseries.LedColor.RED_LED:bI.ledColor);var bg=(undefined===bI.ledVisible?true:bI.ledVisible);var cA=(undefined===bI.thresholdVisible?true:bI.thresholdVisible);var bQ=(undefined===bI.minMeasuredValueVisible?false:bI.minMeasuredValueVisible);var bM=(undefined===bI.maxMeasuredValueVisible?false:bI.maxMeasuredValueVisible);var bJ=(undefined===bI.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bI.labelNumberFormat);var cg=(undefined===bI.foregroundVisible?true:bI.foregroundVisible);var cs=(undefined===bI.playAlarm?false:bI.playAlarm);var be=(undefined===bI.alarmSound?false:bI.alarmSound);var bi=(undefined===bI.valueGradient?null:bI.valueGradient);var bq=(undefined===bI.useValueGradient?false:bI.useValueGradient);var bU=(undefined===bI.maxNoOfMinorTicks?10:bI.maxNoOfMinorTicks);var cr=(undefined===bI.maxNoOfMajorTicks?10:bI.maxNoOfMajorTicks);var cm=(undefined===bI.fractionalScaleDecimals?1:bI.fractionalScaleDecimals);if(cs&&be!==false){var a6=H.createElement("audio");a6.setAttribute("src",be);a6.setAttribute("preload","auto")}var cl=this;var bR=cd;var by=b9;var bP=cd;var bn;var bB=false;var a5=false;var bb=false;var ba=[];var b8=0;var bs=H.getElementById(cB).getContext("2d");bs.clearRect(0,0,bs.canvas.width,bs.canvas.height);bs.canvas.width=co;bs.canvas.height=bw;var bj=bs.canvas.width;var cu=bs.canvas.height;var bz=co<=bw;var bf;var bc;var bp=Math.round((bz?bw:co)*0.05);var cb=Math.round((bz?co:bw)*0.05);var b1;var bH;if(bz){bf=bj/2-bp/2;bc=0.053*cu;b1=Math.floor(cu/22)+"px sans-serif";bH=Math.floor(cu/22)+"px "+aM}else{bf=0.89*bj;bc=cu/1.95-bp/2;b1=Math.floor(cu/10)+"px sans-serif";bH=Math.floor(cu/10)+"px "+aM}var a8=false;var br=cd;var bE=b9;var bk=b9-cd;var bO=bE-br;var bX=0;var bo=0;var bu=function bu(){if(b0){bk=l(b9-cd,false);bo=l(bk/(cr-1),true);br=Math.floor(cd/bo)*bo;bE=Math.ceil(b9/bo)*bo;bX=l(bo/(bU-1),true);cd=br;b9=bE;bO=b9-cd}else{bk=(b9-cd);br=cd;bE=b9;bO=bk;bo=l(bk/(cr),true);bX=l(bo/(bU),true)}};var b4=P(co,bw);var bL=b4.getContext("2d");var bS=P(co,bw);var bV=bS.getContext("2d");var ce;var cj=H.createElement("canvas");if(bz){cj.width=bj*0.121428;cj.height=cu*0.012135}else{cj.width=bj*0.012135;cj.height=cu*0.121428}var bd=cj.getContext("2d");var b7=H.createElement("canvas");if(bz){b7.width=bj*0.121428;b7.height=cu*0.012135}else{b7.width=bj*0.012135;b7.height=cu*0.121428}var bD=b7.getContext("2d");var bt=P(bp,bp);var bN=bt.getContext("2d");var bA=P(bp,bp);var a7=bA.getContext("2d");var b3=bA;var bx=P(cb,cb);var cp=bx.getContext("2d");var bT=P(cb,cb);var a9=bT.getContext("2d");var ch=P(co,bw);var bl=ch.getContext("2d");var ci=function(cC,cH,cD){cC.save();cC.textAlign="right";cC.textBaseline="middle";cC.strokeStyle=ca.textColor;cC.fillStyle=ca.textColor;if(ca===steelseries.LcdColor.STANDARD||ca===steelseries.LcdColor.STANDARD_GREEN){cC.shadowColor="gray";if(cD){cC.shadowOffsetX=bj*0.007;cC.shadowOffsetY=bj*0.007;cC.shadowBlur=bj*0.009}else{cC.shadowOffsetX=cu*0.007;cC.shadowOffsetY=cu*0.007;cC.shadowBlur=cu*0.009}}var cF;var cE;var cG;if(bC){cC.font=bH}else{cC.font=b1}if(cD){cF=(bj-(bj*0.571428))/2+1+bj*0.571428-2;cE=cu*0.88+1+(cu*0.055-2)/2;cG=bj*0.7-2}else{cF=(bj*0.695)+bj*0.18-2;cE=(cu*0.22)+1+(cu*0.15-2)/2;cG=cu*0.22-2}cC.fillText(cH.toFixed(cw),cF,cE,cG);cC.restore()};var cx=function(cC){var cF=H.createElement("canvas");cF.height=cF.width=cb;var cE=cF.getContext("2d");cE.save();var cD=cE.createLinearGradient(0,0.1,0,cF.height*0.9);cD.addColorStop(0,"#520000");cD.addColorStop(0.3,"#fc1d00");cD.addColorStop(0.59,"#fc1d00");cD.addColorStop(1,"#520000");cE.fillStyle=cD;if(cC){cE.beginPath();cE.moveTo(0.1,cF.height*0.5);cE.lineTo(cF.width*0.9,0.1);cE.lineTo(cF.width*0.9,cF.height*0.9);cE.closePath()}else{cE.beginPath();cE.moveTo(0.1,0.1);cE.lineTo(cF.width*0.9,0.1);cE.lineTo(cF.width*0.5,cF.height*0.9);cE.closePath()}cE.fill();cE.strokeStyle="#FFFFFF";cE.stroke();cE.restore();return cF};var b2=function(cO,cG,cD){bF.labelColor.setAlpha(1);cO.save();cO.textBaseline="middle";var cL=bj*0.1;cO.strokeStyle=bF.labelColor.getRgbaColor();cO.fillStyle=bF.labelColor.getRgbaColor();var cI=cd;var cH=bU-1;var cR;var cQ;var cS;var cF;var cT=1;var cE;var cU;var cK;var cC;var cM;var cJ;if(cD){cE=(0.34*bj);cU=(0.36*bj);cK=(0.33*bj);cC=(0.36*bj);cM=(0.32*bj);cJ=(0.36*bj);cO.textAlign="right";cR=0;cQ=cu*0.12864;cS=0;cF=(cu*0.856796-cu*0.12864);cT=cF/(b9-cd)}else{cE=(0.65*cu);cU=(0.63*cu);cK=(0.66*cu);cC=(0.63*cu);cM=(0.67*cu);cJ=(0.63*cu);cO.textAlign="center";cR=bj*0.142857;cQ=0;cS=(bj*0.871012-bj*0.142857);cF=0;cT=cS/(b9-cd)}for(var cP=cd,cN=0;cP<=b9;cP+=bX,cN+=bX){if(cD){currentPos=cQ+cF-cN*cT}else{currentPos=cR+cN*cT}cH++;if(cH===bU){cO.lineWidth=1.5;cz(cO,cM,cJ,currentPos,cD);if(cD){switch(cG.format){case"fractional":cO.fillText((cI.toFixed(cm)),bj*0.28,currentPos,cL);break;case"scientific":cO.fillText((cI.toPrecision(2)),bj*0.28,currentPos,cL);break;case"standard":default:cO.fillText((cI.toFixed(0)),bj*0.28,currentPos,cL);break}}else{switch(cG.format){case"fractional":cO.fillText((cI.toFixed(cm)),currentPos,(cu*0.73),cL);break;case"scientific":cO.fillText((cI.toPrecision(2)),currentPos,(cu*0.73),cL);break;case"standard":default:cO.fillText((cI.toFixed(0)),currentPos,(cu*0.73),cL);break}}cI+=bo;cH=0;continue}if(0===bU%2&&cH===(bU/2)){cO.lineWidth=1;cz(cO,cK,cC,currentPos,cD)}else{cO.lineWidth=0.5;cz(cO,cE,cU,currentPos,cD)}}cO.restore()};var cz=function(cC,cF,cG,cE,cD){if(cD){cC.beginPath();cC.moveTo(cF,cE);cC.lineTo(cG,cE);cC.closePath();cC.stroke()}else{cC.beginPath();cC.moveTo(cE,cF);cC.lineTo(cE,cG);cC.closePath();cC.stroke()}};var b6=function(cM){cM=cM||{};var cN=(undefined===cM.frame?false:cM.frame);var cF=(undefined===cM.background?false:cM.background);var cH=(undefined===cM.led?false:cM.led);var cK=(undefined===cM.foreground?false:cM.foreground);var cG=(undefined===cM.bargraphled?false:cM.bargraphled);a8=true;bu();if(cN&&cq){p(bL,cv,bj,cu,bz)}if(cF&&cy){ad(bV,bF,bj,cu,bz)}if(cH){if(bz){bN.drawImage(aj(bp,1,bK),0,0);a7.drawImage(aj(bp,0,bK),0,0)}else{bN.drawImage(aj(bp,1,bK),0,0);a7.drawImage(aj(bp,0,bK),0,0)}}if(bQ){if(bz){cp.drawImage(C(cb,steelseries.ColorDef.BLUE.dark.getRgbaColor(),false,bz),0,0)}else{cp.drawImage(C(cb,steelseries.ColorDef.BLUE.dark.getRgbaColor(),false,bz),0,0)}}if(bM){if(bz){a9.drawImage(C(cb,steelseries.ColorDef.RED.medium.getRgbaColor(),false,bz),0,0)}else{a9.drawImage(C(cb,steelseries.ColorDef.RED.medium.getRgbaColor(),false,bz),0,0)}}if(cF&&cy){var cL;b2(bV,bJ,bz);if(cA){bV.save();if(bz){cL=cu*0.856796-(cu*0.728155)*(cn/(b9-cd));bV.translate(bj*0.365,cL-cb/2)}else{cL=(bj*0.856796-bj*0.12864)*cn/(b9-cd);bV.translate(bj*0.142857-cb/2+cL,cu*0.58)}bV.drawImage(cx(bz),0,0);bV.restore()}if(bz){au(bV,bj,cu,bW,bh,bF,bz,null,bv)}else{au(bV,bj,cu,bW,bh,bF,bz,null,bv)}}if(cF&&bv){if(bz){ce=ab(bj*0.571428,cu*0.055,ca);bV.drawImage(ce,((bj-(bj*0.571428))/2),cu*0.88)}else{ce=ab(bj*0.18,cu*0.15,ca);bV.drawImage(ce,bj*0.695,cu*0.22)}}if(cG){ct(bD);bG(bd,bY)}a5=false;if(null!==ck&&0<ck.length){a5=true;var cJ=ck.length;var cI,cC,cE,cD;if(bz){cI=cu*0.12864;cC=cu*0.856796;cE=cC-cI;cD=0}else{cI=bj*0.856796;cC=bj*0.12864;cE=cI-cC;cD=bj*0.012135/2}ba=[];do{cJ--;ba.push({start:(((ck[cJ].start+Math.abs(cd))/(b9-cd))*cE-cD),stop:(((ck[cJ].stop+Math.abs(cd))/(b9-cd))*cE-cD),color:x(ck[cJ].color)})}while(0<cJ)}bb=false;if(bq&&bi!==null){a5=false;bb=true}if(cK&&cg){aS(bl,bj,cu,bz,false)}};var bm=function(cD){cD=cD||{};var cE=(undefined===cD.frame?false:cD.frame);var cG=(undefined===cD.background?false:cD.background);var cH=(undefined===cD.led?false:cD.led);var cF=(undefined===cD.bargraphled?false:cD.bargraphled);var cC=(undefined===cD.foreground?false:cD.foreground);if(cE){b4.width=co;b4.height=bw;bL=b4.getContext("2d")}if(cG){bS.width=co;bS.height=bw;bV=bS.getContext("2d")}if(cF){if(bz){cj.width=co*0.121428;cj.height=bw*0.012135}else{cj.width=co*0.012135;cj.height=bw*0.121428}bd=cj.getContext("2d");if(bz){b7.width=co*0.121428;b7.height=bw*0.012135}else{b7.width=co*0.012135;b7.height=bw*0.121428}bD=b7.getContext("2d")}if(cH){bt.width=Math.ceil(co*0.093457);bt.height=Math.ceil(bw*0.093457);bN=bt.getContext("2d");bA.width=Math.ceil(co*0.093457);bA.height=Math.ceil(bw*0.093457);a7=bA.getContext("2d");b3=bA}if(cC){ch.width=co;ch.height=bw;bl=ch.getContext("2d")}};var b5=function(cC){if(cC){b8=setInterval(cf,1000)}else{clearInterval(b8)}};var cf=function(){if(bg){if(b3===bt){b3=bA}else{b3=bt}cl.repaint()}};var cc=function(cW,db,c1){var cJ;var cC;var c2=bF.labelColor;var cX;var da;var cY;var cQ;var cO;var cK;var cI;var c8;var c7;var c6;var c5;if(bz){cJ=c1*0.12864;cC=c1*0.856796;cX=cC-cJ;da=cX*(bR-cd)/(b9-cd);cY=cJ+cX-da;cQ=0;cO=cJ;cK=0;cI=cJ+cX*1.014}else{cJ=db*0.856796;cC=db*0.12864;cX=cJ-cC;da=cX*(bR-cd)/(b9-cd);cY=cC;cQ=db*0.13;cO=c1*0.435714;cK=cQ+cX*1.035;cI=cO}var cS=(bF===steelseries.BackgroundColor.CARBON||bF===steelseries.BackgroundColor.PUNCHED_SHEET||bF===steelseries.BackgroundColor.STAINLESS||bF===steelseries.BackgroundColor.BRUSHED_STAINLESS||bF===steelseries.BackgroundColor.TURNED)?0.3:0;var cV=cW.createLinearGradient(cQ,cO,cK,cI);c2.setAlpha(0.047058+cS);cV.addColorStop(0,c2.getRgbaColor());c2.setAlpha(0.145098+cS);cV.addColorStop(0.48,c2.getRgbaColor());c2.setAlpha(0.149019+cS);cV.addColorStop(0.49,c2.getRgbaColor());c2.setAlpha(0.047058+cS);cV.addColorStop(1,c2.getRgbaColor());cW.fillStyle=cV;if(bz){cW.fillRect(db*0.435714,cJ,db*0.15,cX*1.014)}else{cW.fillRect(cQ,cO,cX*1.035,c1*0.152857)}if(bz){c8=0;c7=cJ;c6=0;c5=cJ+cX*1.014}else{c8=cQ;c7=0;c6=cK;c5=0}var cU=cW.createLinearGradient(c8,c7,c6,c5);c2.setAlpha(0.298039+cS);cU.addColorStop(0,c2.getRgbaColor());c2.setAlpha(0.686274+cS);cU.addColorStop(0.48,c2.getRgbaColor());c2.setAlpha(0.698039+cS);cU.addColorStop(0.49,c2.getRgbaColor());c2.setAlpha(0.4+cS);cU.addColorStop(1,c2.getRgbaColor());cW.fillStyle=cU;if(bz){cW.fillRect(db*0.435714,cJ,db*0.007142,cX*1.014);cW.fillRect(db*0.571428,cJ,db*0.007142,cX*1.014)}else{cW.fillRect(db*0.13,c1*0.435714,cX*1.035,c1*0.007142);cW.fillRect(db*0.13,c1*0.571428,cX*1.035,c1*0.007142)}var cF;var cE;var cG;var cM;var cR;var cP;var cZ;var cL;if(bz){cF=db*0.45;cE=c1*0.851941;cG=db*0.121428;cM=c1*0.012135;cR=(cF+cG)/2;cP=(cE+cM)/2}else{cF=db*0.142857;cE=c1*0.45;cG=db*0.012135;cM=c1*0.121428;cR=(cF+cG)/2;cP=(cE+cM)/2}var c4,c3;var cH;var cD=bY;if(bz){cL=((b9+Math.abs(cd))/(b9-cd))*cX;for(c3=0;c3<=cL;c3+=cM+1){cW.translate(0,-c3);cW.drawImage(b7,cF,cE);cW.translate(0,c3)}cZ=((bR+Math.abs(cd))/(b9-cd))*cX;for(c3=0;c3<=cZ;c3+=cM+1){cH=bY;if(bb){var cN=cd+(c3/cX)*(b9-cd);var c0=bi.getEnd()-bi.getStart();var cT=cN/c0;cT=Math.max(Math.min(cT,1),0);cH=x(bi.getColorAt(cT).getRgbaColor())}else{if(a5){for(var c9=0;c9<ba.length;c9++){if(c3>=ba[c9].start&&c3<ba[c9].stop){cH=ba[c9].color;break}}}}if(cD.medium.getHexColor()!=cH.medium.getHexColor()){bG(bd,cH);cD=cH}cW.translate(0,-c3);cW.drawImage(cj,cF,cE);cW.translate(0,c3)}}else{cL=((b9+Math.abs(cd))/(b9-cd))*cX;for(c4=-(cG/2);c4<=cL;c4+=cG+1){cW.translate(c4,0);cW.drawImage(b7,cF,cE);cW.translate(-c4,0)}cZ=((bR+Math.abs(cd))/(b9-cd))*cX;for(c4=-(cG/2);c4<=cZ;c4+=cG+1){cH=bY;if(bb){var cN=cd+(c4/cX)*(b9-cd);var c0=bi.getEnd()-bi.getStart();var cT=cN/c0;cT=Math.max(Math.min(cT,1),0);cH=x(bi.getColorAt(cT).getRgbaColor())}else{if(a5){for(var c9=0;c9<ba.length;c9++){if(c4>=ba[c9].start&&c4<ba[c9].stop){cH=ba[c9].color;break}}}}if(cD.medium.getHexColor()!=cH.medium.getHexColor()){bG(bd,cH);cD=cH}cW.translate(c4,0);cW.drawImage(cj,cF,cE);cW.translate(-c4,0)}}};var ct=function(cC){cC.save();cC.beginPath();cC.rect(0,0,cC.canvas.width,cC.canvas.height);cC.closePath();var cF=(cC.canvas.width/2);var cE=(cC.canvas.height/2);var cD=bs.createRadialGradient(cF,cE,0,cF,cE,cC.canvas.width/2);cD.addColorStop(0,"#3c3c3c");cD.addColorStop(1,"#323232");cC.fillStyle=cD;cC.fill();cC.restore()};var bG=function(cC,cD){cC.save();cC.beginPath();cC.rect(0,0,cC.canvas.width,cC.canvas.height);cC.closePath();var cH=(cC.canvas.width/2);var cG=(cC.canvas.height/2);var cE;if(bz){cE=cC.canvas.width/2}else{cE=cC.canvas.height/2}var cF=bs.createRadialGradient(cH,cG,0,cH,cG,cE);cF.addColorStop(0,cD.light.getRgbaColor());cF.addColorStop(1,cD.dark.getRgbaColor());cC.fillStyle=cF;cC.fill();cC.restore()};this.setValue=function(cD){var cC=(cD<cd?cd:(cD>b9?b9:cD));if(bR!==cC){bR=cC;if(bR>bP){bP=bR}if(bR<by){by=bR}if(bR>=cn&&!bB){bB=true;b5(bB);if(cs){a6.play()}}else{if(bR<cn){bB=false;b5(bB);if(cs){a6.pause()}}}this.repaint()}};this.getValue=function(){return bR};this.setValueAnimated=function(cE){var cC=(cE<cd?cd:(cE>b9?b9:cE));if(bR!==cC){if(undefined!==bn){if(bn.playing){bn.stop()}}bn=new Tween({},"",Tween.regularEaseInOut,bR,cC,1);var cD=this;bn.onMotionChanged=function(cF){bR=cF.target._pos;if(bR>=cn&&!bB){bB=true;b5(bB)}else{if(bR<cn){bB=false;b5(bB)}}if(bR>bP){bP=bR}if(bR<by){by=bR}cD.repaint()};bn.start()}};this.resetMinMeasuredValue=function(){by=bR;this.repaint()};this.resetMaxMeasuredValue=function(){bP=bR;this.repaint()};this.setMinMeasuredValueVisible=function(cC){bQ=cC;this.repaint()};this.setMaxMeasuredValueVisible=function(cC){bM=cC;this.repaint()};this.setThresholdVisible=function(cC){cA=cC;this.repaint()};this.setLcdDecimals=function(cC){cw=cC;this.repaint()};this.setFrameDesign=function(cC){bm({frame:true});cv=cC;b6({frame:true});this.repaint()};this.setBackgroundColor=function(cC){bm({background:true});bF=cC;b6({background:true});this.repaint()};this.setValueColor=function(cC){bm({bargraphled:true});bY=cC;b6({bargraphled:true});this.repaint()};this.setLedColor=function(cC){bm({led:true});bK=cC;b6({led:true});this.repaint()};this.setLcdColor=function(cC){ca=cC;b6({background:true});this.repaint()};this.setSection=function(cC){ck=cC;b6();this.repaint()};this.setSectionActive=function(cC){bZ=cC;b6();this.repaint()};this.setGradient=function(cC){bi=cC;b6();this.repaint()};this.setGradientActive=function(cC){useGradient=cC;b6();this.repaint()};this.setMaxMeasuredValue=function(cD){var cC=(cD<cd?cd:(cD>b9?b9:cD));if(bP!==cC){bP=cC;this.repaint()}};this.setMinMeasuredValue=function(cD){var cC=(cD<cd?cd:(cD>b9?b9:cD));if(by!==cC){by=cC;this.repaint()}};this.setTitleString=function(cC){bW=cC;b6({background:true});this.repaint()};this.setUnitString=function(cC){bh=cC;b6({background:true});this.repaint()};this.setMinValue=function(cC){cd=cC;b6({background:true,foreground:true,pointer:true});this.repaint()};this.getMinValue=function(){return cd};this.setMaxValue=function(cC){if(b9!==cC){b9=cC;b6({background:true,foreground:true,pointer:true});this.repaint()}};this.getMaxValue=function(){return b9};this.setThreshold=function(cD){var cC=(cD<cd?cd:(cD>b9?b9:cD));if(cn!==cC){cn=cC;b6({background:true});this.repaint()}};this.repaint=function(){if(!a8){b6({frame:true,background:true,led:true,pointer:true,foreground:true,bargraphled:true})}bs.clearRect(0,0,bs.canvas.width,bs.canvas.height);if(cq){bs.drawImage(b4,0,0)}if(cy){bs.drawImage(bS,0,0)}if(bv){ci(bs,bR,bz)}if(bg){if(bR<cn){bB=false;b3=bA}bs.drawImage(b3,bf,bc)}var cE;var cD,cC;if(bQ){if(bz){cE=cu*0.856796-(cu*0.728155)*(by/(b9-cd));cD=bj*0.34-bx.width;cC=cE-bx.height/2}else{cE=((bj*0.856796)-(bj*0.12864))*by/(b9-cd);cD=bj*0.142857-bx.height/2+cE;cC=cu*0.65}bs.drawImage(bx,cD,cC)}if(bM){if(bz){cE=cu*0.856796-(cu*0.728155)*(bP/(b9-cd));cD=bj*0.34-bT.width;cC=cE-bT.height/2}else{cE=((bj*0.856796)-(bj*0.12864))*bP/(b9-cd);cD=bj*0.142857-bT.height/2+cE;cC=cu*0.65}bs.drawImage(bT,cD,cC)}bs.save();cc(bs,bj,cu);bs.restore();if(cg){bs.drawImage(ch,0,0)}};this.repaint();return this};var o=function(a8,bh){bh=bh||{};var bv=(undefined===bh.width?128:bh.width);var br=(undefined===bh.height?48:bh.height);var bz=(undefined===bh.lcdColor?steelseries.LcdColor.STANDARD:bh.lcdColor);var bk=(undefined===bh.lcdDecimals?2:bh.lcdDecimals);var a7=(undefined===bh.unitString?"":bh.unitString);var bc=(undefined===bh.unitStringVisible?false:bh.unitStringVisible);var bn=(undefined===bh.digitalFont?false:bh.digitalFont);var bs=(undefined===bh.valuesNumeric?true:bh.valuesNumeric);var bw=(undefined===bh.value?0:bh.value);var bb=(undefined===bh.autoScroll?false:bh.autoScroll);var bi=(undefined===bh.section?null:bh.section);var bo=false;var bx=0;var be;var bq=this;var bm=H.getElementById(a8).getContext("2d");bm.save();bm.clearRect(0,0,bm.canvas.width,bm.canvas.height);bm.canvas.width=bv;bm.canvas.height=br;var bl=bv;var bB=br;var a6=0;var bp=Math.floor(bB/1.5);var bg=bp+"px sans-serif";var bu=bp+"px "+aM;var ba=false;var a5;var bA=[];var bj=[];var bt=function(bE,bC){bm.save();bm.textAlign="right";bm.strokeStyle=bC;bm.fillStyle=bC;bm.beginPath();bm.rect(2,0,bl-4,bB);bm.closePath();bm.clip();if(bn){bm.font=bu}else{bm.font=bg}if(bs){var bD=0;a6=0;if(bc){bm.font=Math.floor(bB/2.5)+"px sans-serif";bD=bm.measureText(a7).width}if(bn){bm.font=bu}else{bm.font=bg}var bF=bE.toFixed(bk);a6=bm.measureText(bF).width;bm.fillText(bF,bl-bD-4-bx,bB*0.5+bp*0.38);if(bc){bm.font=Math.floor(bB/2.5)+"px sans-serif";bm.fillText(a7,bl-2-bx,bB*0.5+bp*0.38)}}else{a6=bm.measureText(bE).width;if(bb&&a6>bl-4){if(!bo){bx=bl-a6-bl*0.2;bo=true;clearTimeout(be);be=setTimeout(bd,200)}}else{if(bb&&a6<=bl-4){bx=0;bo=false}}bm.fillText(bE,bl-2-bx,bB*0.5+bp*0.38)}bm.restore()};var bf=function(bV,bS,bY,b0){var bG=P(bV,bS);var bH=bG.getContext("2d");bH.save();var bR=0;var b1=0;var bE=bV;var ca=bS;var bO=Math.min(bV,bS)*0.095;var bX=bH.createLinearGradient(0,b1,0,b1+ca);bX.addColorStop(0,"#4c4c4c");bX.addColorStop(0.08,"#666666");bX.addColorStop(0.92,"#666666");bX.addColorStop(1,"#e6e6e6");bH.fillStyle=bX;V(bH,bR,b1,bE,ca,bO);bH.fill();bH.restore();bH.save();var bD=aI(bY);var bT=aE(bD[0],bD[1],bD[2]);var bI=aI(b0.gradientStartColor);var b8=aE(bI[0],bI[1],bI[2]);var bQ=aI(b0.gradientFraction1Color);var b7=aE(bQ[0],bQ[1],bQ[2]);var bN=aI(b0.gradientFraction2Color);var b5=aE(bN[0],bN[1],bN[2]);var bM=aI(b0.gradientFraction3Color);var b4=aE(bM[0],bM[1],bM[2]);var bF=aI(b0.gradientStopColor);var bK=aE(bF[0],bF[1],bF[2]);var bU=O(bT[0],bT[1],b8[2]-0.31);var bZ=O(bT[0],bT[1],b7[2]-0.31);var b3=O(bT[0],bT[1],b5[2]-0.31);var b9=O(bT[0],bT[1],b4[2]-0.31);var b2=O(bT[0],bT[1],bK[2]-0.31);var bL=1;var bW=1;var bC=bV-2;var b6=bS-2;var bJ=bO-1;var bP=bH.createLinearGradient(0,bW,0,bW+b6);bP.addColorStop(0,"rgb("+bU[0]+", "+bU[1]+", "+bU[2]+")");bP.addColorStop(0.03,"rgb("+bZ[0]+","+bZ[1]+","+bZ[2]+")");bP.addColorStop(0.49,"rgb("+b3[0]+","+b3[1]+","+b3[2]+")");bP.addColorStop(0.5,"rgb("+b9[0]+","+b9[1]+","+b9[2]+")");bP.addColorStop(1,"rgb("+b2[0]+","+b2[1]+","+b2[2]+")");bH.fillStyle=bP;V(bH,bL,bW,bC,b6,bJ);bH.fill();bH.restore();return bG};var a9=function(bE){var bD=aI(bE);var bF=aE(bD[0],bD[1],bD[2]);var bC=O(bF[0],0.57,0.83);return"rgb("+bC[0]+", "+bC[1]+", "+bC[2]+")"};var bd=function(){if(bo){if(bx>bl){bx=-a6}bx+=2;be=setTimeout(bd,60)}else{bx=0}bq.repaint()};var by=function(){ba=true;a5=ab(bv,br,bz);if(null!==bi&&0<bi.length){for(var bC=0;bC<bi.length;bC++){bA[bC]=bf(bv,br,bi[bC].color,bz);bj[bC]=a9(bi[bC].color)}}};this.setValue=function(bC){if(bw!==bC){bw=bC;this.repaint()}};this.setLcdColor=function(bC){bz=bC;by();this.repaint()};this.setSection=function(bC){bi=bC;resetBuffers({foreground:true});by({background:true,foreground:true});this.repaint()};this.setScrolling=function(bC){if(bC){if(bo){return}else{bo=bC;bd()}}else{bo=bC}};this.repaint=function(){if(!ba){by()}bm.clearRect(0,0,bm.canvas.width,bm.canvas.height);var bD=a5;var bC=bz.textColor;if(null!==bi&&0<bi.length){for(var bE=0;bE<bi.length;bE++){if(bw>=bi[bE].start&&bw<=bi[bE].stop){bD=bA[bE];bC=bj[bE];break}}}bm.drawImage(bD,0,0);bt(bw,bC)};this.repaint();return this};var X=function(a7,bb){bb=bb||{};var bn=(undefined===bb.width?128:bb.width);var bi=(undefined===bb.height?64:bb.height);var bq=(undefined===bb.lcdColor?steelseries.LcdColor.STANDARD:bb.lcdColor);var bd=(undefined===bb.lcdDecimals?2:bb.lcdDecimals);var a6=(undefined===bb.unitString?"":bb.unitString);var a9=(undefined===bb.unitStringVisible?false:bb.unitStringVisible);var bh=(undefined===bb.digitalFont?false:bb.digitalFont);var bk=(undefined===bb.valuesNumeric?true:bb.valuesNumeric);var bo=(undefined===bb.value?0:bb.value);var bj=0;var bg=H.getElementById(a7).getContext("2d");bg.save();bg.clearRect(0,0,bg.canvas.width,bg.canvas.height);bg.canvas.width=bn;bg.canvas.height=bi;var bf=bn;var br=bi;var ba=Math.floor(br/1.875)+"px sans-serif";var bm=Math.floor(br/1.875)+"px "+aM;var be=Math.floor(br/3.5)+"px sans-serif";var bc=Math.floor(br/3.5)+"px "+aM;var a8=false;var a5;var bl=function(bu){bg.save();bg.textAlign="right";bg.textBaseline="middle";bg.strokeStyle=bq.textColor;bg.fillStyle=bq.textColor;if(bq===steelseries.LcdColor.STANDARD||bq===steelseries.LcdColor.STANDARD_GREEN){bg.shadowColor="gray";bg.shadowOffsetX=br*0.05;bg.shadowOffsetY=br*0.05;bg.shadowBlur=br*0.06}if(bk){bg.font=Math.floor(br/2.5)+"px sans-serif";var bt=0;if(a9){bg.font=Math.floor(br/2.5)+"px sans-serif";bt=bg.measureText(a6).width}if(bh){bg.font=bm}else{bg.font=ba}var bs=bu.toFixed(bd);bg.fillText(bs,bf-bt-4,br*0.38);if(a9){bg.font=Math.floor(br/3)+"px sans-serif";bg.fillText(a6,bf-2,br*0.46)}var bv=bj.toFixed(bd);if(bh){bg.font=bc}else{bg.font=be}bg.textAlign="center";bg.fillText(bv,bf/2,br*0.8)}else{bg.font=Math.floor(br/2.5)+"px sans-serif";bg.fillText(bu,bf-2,br*0.38);bg.font=be;bg.textAlign="center";bg.fillText(bj,bf/2,br*0.8)}bg.restore()};var bp=function(){a8=true;a5=ab(bn,bi,bq)};this.setValue=function(bs){if(bo!==bs||bj!==bs){bj=bo;bo=bs;this.repaint()}};this.setLcdColor=function(bs){bq=bs;bp();this.repaint()};this.repaint=function(){if(!a8){bp()}bg.clearRect(0,0,bg.canvas.width,bg.canvas.height);bg.drawImage(a5,0,0);bl(bo)};this.repaint();return this};var at=function(bg,bA){bA=bA||{};var bf=(undefined===bA.size?200:bA.size);var bE=(undefined===bA.decimalsVisible?false:bA.decimalsVisible);var be=(undefined===bA.textOrientationFixed?false:bA.textOrientationFixed);var a8=(undefined===bA.frameDesign?steelseries.FrameDesign.METAL:bA.frameDesign);var bp=(undefined===bA.frameVisible?true:bA.frameVisible);var a6=(undefined===bA.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bA.backgroundColor);var bn=(undefined===bA.backgroundVisible?true:bA.backgroundVisible);var bG=(undefined===bA.pointerColor?steelseries.ColorDef.RED:bA.pointerColor);var bD=(undefined===bA.foregroundType?steelseries.ForegroundType.TYPE1:bA.foregroundType);var bC=(undefined===bA.foregroundVisible?true:bA.foregroundVisible);var bj;var bv=0;var bs=0;var bq=0;var bw=2*Math.PI/360;var bk=this.value;var bm=bE?1:0;var bz=H.getElementById(bg).getContext("2d");bz.save();bz.clearRect(0,0,bz.canvas.width,bz.canvas.height);bz.canvas.width=bf;bz.canvas.height=bf;var bH=bf;var br=bf;var bb=bH/2;var ba=br/2;var bh=false;var bt=P(bf,bf);var a5=bt.getContext("2d");var bo=P(bf,bf);var a7=bo.getContext("2d");var bu=P(bf,bf);var a9=bu.getContext("2d");var bx=P(bf,bf);var bl=bx.getContext("2d");var bF=function(bI){bI.textAlign="center";bI.textBaseline="middle";bI.save();bI.strokeStyle=a6.labelColor.getRgbaColor();bI.fillStyle=a6.labelColor.getRgbaColor();bI.translate(bb,ba);var bK;var bJ;for(i=0;360>i;i++){bI.strokeStyle=a6.labelColor.getRgbaColor();bI.lineWidth=0.5;bI.beginPath();bI.moveTo(bH*0.38,0);bI.lineTo(bH*0.37,0);bI.closePath();bI.stroke();if(0===i%5){bI.strokeStyle=a6.labelColor.getRgbaColor();bI.lineWidth=1;bI.beginPath();bI.moveTo(bH*0.38,0);bI.lineTo(bH*0.36,0);bI.closePath();bI.stroke()}if(0===i%45){bI.strokeStyle=a6.labelColor.getRgbaColor();bI.lineWidth=1;bI.beginPath();bI.moveTo(bH*0.38,0);bI.lineTo(bH*0.34,0);bI.closePath();bI.stroke()}if(300<bH){bK="14px sans-serif";bJ="12px sans-serif"}if(300>=bH){bK="12px sans-serif";bJ="10px sans-serif"}if(200>=bH){bK="10px sans-serif";bJ="8px sans-serif"}if(100>=bH){bK="8px sans-serif";bJ="6px sans-serif"}bI.save();switch(i){case 0:bI.translate(bH*0.31,0);bI.rotate((i*Math.PI/180)+Math.PI/2);bI.font=bK;bI.fillText("0\u00B0",0,0,bH);bI.rotate(-(i*Math.PI/180)+Math.PI/2);bI.translate(-bH*0.31,0);bI.translate(bH*0.41,0);bI.rotate((i*Math.PI/180)-Math.PI/2);bI.font=bJ;bI.fillText("0%",0,0,bH);break;case 45:bI.translate(bH*0.31,0);bI.rotate((i*Math.PI/180)+0.25*Math.PI);bI.font=bK;bI.fillText("45\u00B0",0,0,bH);bI.rotate(-(i*Math.PI/180)+0.25*Math.PI);bI.translate(-bH*0.31,0);bI.translate(bH*0.31,bH*0.085);bI.rotate((i*Math.PI/180)-0.25*Math.PI);bI.font=bJ;bI.fillText("100%",0,0,bH);break;case 90:bI.translate(bH*0.31,0);bI.rotate((i*Math.PI/180));bI.font=bK;bI.fillText("90\u00B0",0,0,bH);bI.rotate(-(i*Math.PI/180));bI.translate(-bH*0.31,0);bI.translate(bH*0.21,0);bI.rotate((i*Math.PI/180));bI.font=bJ;bI.fillText("\u221E",0,0,bH);break;case 135:bI.translate(bH*0.31,0);bI.rotate((i*Math.PI/180)-0.25*Math.PI);bI.font=bK;bI.fillText("45\u00B0",0,0,bH);bI.rotate(-(i*Math.PI/180)-0.25*Math.PI);bI.translate(-bH*0.31,0);bI.translate(bH*0.31,-bH*0.085);bI.rotate((i*Math.PI/180)+0.25*Math.PI);bI.font=bJ;bI.fillText("100%",0,0,bH);break;case 180:bI.translate(bH*0.31,0);bI.rotate((i*Math.PI/180)-Math.PI/2);bI.font=bK;bI.fillText("0\u00B0",0,0,bH);bI.rotate(-(i*Math.PI/180)-Math.PI/2);bI.translate(-bH*0.31,0);bI.translate(bH*0.41,0);bI.rotate((i*Math.PI/180)+Math.PI/2);bI.font=bJ;bI.fillText("0%",0,0,bH);bI.translate(-bH*0.41,0);break;case 225:bI.translate(bH*0.31,0);bI.rotate((i*Math.PI/180)-0.75*Math.PI);bI.font=bK;bI.fillText("45\u00B0",0,0,bH);bI.rotate(-(i*Math.PI/180)-0.75*Math.PI);bI.translate(-bH*0.31,0);bI.translate(bH*0.31,bH*0.085);bI.rotate((i*Math.PI/180)+0.75*Math.PI);bI.font=bJ;bI.fillText("100%",0,0,bH);break;case 270:bI.translate(bH*0.31,0);bI.rotate((i*Math.PI/180)-Math.PI);bI.font=bK;bI.fillText("90\u00B0",0,0,bH);bI.rotate(-(i*Math.PI/180)-Math.PI);bI.translate(-bH*0.31,0);bI.translate(bH*0.21,0);bI.rotate((i*Math.PI/180)-Math.PI);bI.font=bJ;bI.fillText("\u221E",0,0,bH);break;case 315:bI.translate(bH*0.31,0);bI.rotate((i*Math.PI/180)-1.25*Math.PI);bI.font=bK;bI.fillText("45\u00B0",0,0,bH);bI.rotate(-(i*Math.PI/180)-1.25*Math.PI);bI.translate(-bH*0.31,0);bI.translate(bH*0.31,-bH*0.085);bI.rotate((i*Math.PI/180)+1.25*Math.PI);bI.font=bJ;bI.fillText("100%",0,0,bH);break}bI.restore();bI.rotate(bw)}bI.translate(-bb,-ba);bI.restore()};var bd=function(bI){bI.save();bI.strokeStyle=a6.labelColor.getRgbaColor();bI.fillStyle=a6.labelColor.getRgbaColor();bI.save();bI.beginPath();bI.moveTo(bH*0.200934,br*0.434579);bI.lineTo(bH*0.163551,br*0.434579);bI.lineTo(bH*0.163551,br*0.560747);bI.lineTo(bH*0.200934,br*0.560747);bI.lineWidth=1;bI.lineCap="square";bI.lineJoin="miter";bI.stroke();bI.save();bI.beginPath();bI.moveTo(bH*0.163551,br*0.471962);bI.lineTo(bH*0.205607,br*0.5);bI.lineTo(bH*0.163551,br*0.523364);bI.lineTo(bH*0.163551,br*0.471962);bI.closePath();bI.fill();bI.save();bI.beginPath();bI.moveTo(bH*0.799065,br*0.434579);bI.lineTo(bH*0.836448,br*0.434579);bI.lineTo(bH*0.836448,br*0.560747);bI.lineTo(bH*0.799065,br*0.560747);bI.lineWidth=1;bI.lineCap="square";bI.lineJoin="miter";bI.stroke();bI.save();bI.beginPath();bI.moveTo(bH*0.836448,br*0.471962);bI.lineTo(bH*0.794392,br*0.5);bI.lineTo(bH*0.836448,br*0.523364);bI.lineTo(bH*0.836448,br*0.471962);bI.closePath();bI.fill();bI.restore()};var bi=function(bJ){bJ.save();bJ.save();bJ.beginPath();bJ.moveTo(bH*0.523364,br*0.350467);bJ.lineTo(bH*0.5,br*0.130841);bJ.lineTo(bH*0.476635,br*0.350467);bJ.bezierCurveTo(bH*0.476635,br*0.350467,bH*0.490654,br*0.345794,bH*0.5,br*0.345794);bJ.bezierCurveTo(bH*0.509345,br*0.345794,bH*0.523364,br*0.350467,bH*0.523364,br*0.350467);bJ.closePath();var bI=bJ.createLinearGradient(0,0.154205*br,0,0.350466*br);var bL=bG.dark;var bK=bG.light;bL.setAlpha(0.70588);bK.setAlpha(0.70588);bI.addColorStop(0,bL.getRgbaColor());bI.addColorStop(0.3,bK.getRgbaColor());bI.addColorStop(0.59,bK.getRgbaColor());bI.addColorStop(1,bL.getRgbaColor());bJ.fillStyle=bI;var bM=bG.light.getRgbaColor();bJ.lineWidth=1;bJ.lineCap="square";bJ.lineJoin="miter";bJ.strokeStyle=bM;bJ.fill();bJ.stroke();bL.setAlpha(1);bK.setAlpha(1);bJ.restore()};var bc=function(bI){bI.save();var bN=bG.dark;var bJ=bG.light;bN.setAlpha(0.70588);bJ.setAlpha(0.70588);bI.save();bI.beginPath();bI.moveTo(bH*0.285046,br*0.514018);bI.lineTo(bH*0.21028,br*0.5);bI.lineTo(bH*0.285046,br*0.481308);bI.bezierCurveTo(bH*0.285046,br*0.481308,bH*0.280373,br*0.490654,bH*0.280373,br*0.495327);bI.bezierCurveTo(bH*0.280373,br*0.504672,bH*0.285046,br*0.514018,bH*0.285046,br*0.514018);bI.closePath();var bK=bI.createLinearGradient(0.224299*bH,0,0.289719*bH,0);bK.addColorStop(0,bN.getRgbaColor());bK.addColorStop(0.3,bJ.getRgbaColor());bK.addColorStop(0.59,bJ.getRgbaColor());bK.addColorStop(1,bN.getRgbaColor());bI.fillStyle=bK;var bO=bG.light.getRgbaColor();bI.lineWidth=1;bI.lineCap="square";bI.lineJoin="miter";bI.strokeStyle=bO;bI.fill();bI.stroke();bI.save();bI.beginPath();bI.moveTo(bH*0.714953,br*0.514018);bI.lineTo(bH*0.789719,br*0.5);bI.lineTo(bH*0.714953,br*0.481308);bI.bezierCurveTo(bH*0.714953,br*0.481308,bH*0.719626,br*0.490654,bH*0.719626,br*0.495327);bI.bezierCurveTo(bH*0.719626,br*0.504672,bH*0.714953,br*0.514018,bH*0.714953,br*0.514018);bI.closePath();var bL=bI.createLinearGradient(0.7757*bH,0,0.71028*bH,0);bL.addColorStop(0,bN.getRgbaColor());bL.addColorStop(0.3,bJ.getRgbaColor());bL.addColorStop(0.59,bJ.getRgbaColor());bL.addColorStop(1,bN.getRgbaColor());bI.fillStyle=bL;var bM=bG.light.getRgbaColor();bI.lineWidth=1;bI.lineCap="square";bI.lineJoin="miter";bI.strokeStyle=bM;bI.fill();bI.stroke();bN.setAlpha(1);bJ.setAlpha(1);bI.restore()};var by=function(){bh=true;if(bp){g(a5,a8,bb,ba,bH,br)}if(bn){a2(a5,a6,bb,ba,bH,br);bF(a5)}bd(a7);bi(a7);bc(a9);if(bC){G(bl,bD,bH,br,false)}};var bB=function(){bt.width=bf;bt.height=bf;a5=bt.getContext("2d");bo.width=bf;bo.height=bf;a7=bo.getContext("2d");bu.width=bf;bu.height=bf;a9=bu.getContext("2d");bx.width=bf;bx.height=bf;bl=bx.getContext("2d")};this.setValue=function(bJ){var bI;bI=0>bJ?(360+bJ):bJ;bI=359.9<bJ?(bJ-360):bJ;if(bv!==bI){bv=bI;bs=2*((Math.abs(bv)*10)%10);if(10<bs){bs-=20}if(0===bv){bq=90}if(0<bv&&90>=bv){bq=(90-bv)}if(90<bv&&180>=bv){bq=(bv-90)}if(180<bv&&270>=bv){bq=(270-bv)}if(270<bv&&360>=bv){bq=(bv-270)}if(0>bv&&bv>=-90){bq=(90-Math.abs(bv))}if(bv<-90&&bv>=-180){bq=Math.abs(bv)-90}if(bv<-180&&bv>=-270){bq=270-Math.abs(bv)}if(bv<-270&&bv>=-360){bq=Math.abs(bv)-270}this.repaint()}};this.getValue=function(){return bv};this.setValueAnimated=function(bJ){if(360-bJ+bv<bJ-bv){bJ=360-bJ}if(bv!==bJ){if(undefined!==bj){if(bj.playing){bj.stop()}}bj=new Tween({},"",Tween.regularEaseInOut,bv,bJ,1);var bI=this;bj.onMotionChanged=function(bK){bv=bK.target._pos;bs=2*((Math.abs(bv)*10)%10);if(10<bs){bs-=20}if(0===bv){bq=90}if(0<bv&&90>=bv){bq=(90-bv)}if(90<bv&&180>=bv){bq=(bv-90)}if(180<bv&&270>=bv){bq=(270-bv)}if(270<bv&&360>=bv){bq=(bv-270)}if(0>bv&&bv>=-90){bq=(90-Math.abs(bv))}if(bv<-90&&bv>=-180){bq=Math.abs(bv)-90}if(bv<-180&&bv>=-270){bq=270-Math.abs(bv)}if(bv<-270&&bv>=-360){bq=Math.abs(bv)-270}bI.repaint()};bj.start()}};this.setFrameDesign=function(bI){bB();a8=bI;by();this.repaint()};this.setBackgroundColor=function(bI){bB();a6=bI;by();this.repaint()};this.setForegroundType=function(bI){bB();bD=bI;by();this.repaint()};this.setPointerColor=function(bI){bB();bG=bI;by();this.repaint()};this.repaint=function(){if(!bh){by()}bz.save();bz.clearRect(0,0,bz.canvas.width,bz.canvas.height);if(bp||bn){bz.drawImage(bt,0,0)}bk=Math.PI/2+bv*bw-Math.PI/2;bz.save();bz.translate(bb,ba);bz.rotate(bk);bz.translate(-bb,-ba);bz.drawImage(bo,0,0);bz.fillStyle=a6.labelColor.getRgbaColor();bz.textAlign="center";bz.textBaseline="middle";if(be){bz.restore();if(bE){bz.font=bH*0.1+"px sans-serif"}else{bz.font=bH*0.15+"px sans-serif"}bz.fillText(bq.toFixed(bm)+"\u00B0",bb,ba,bH*0.35)}else{if(bE){bz.font=bH*0.15+"px sans-serif"}else{bz.font=bH*0.2+"px sans-serif"}bz.fillText(bq.toFixed(bm)+"\u00B0",bb,ba,bH*0.35);bz.restore()}bz.translate(bb,ba);bz.rotate(bk+bs*Math.PI/180);bz.translate(-bb,-ba);bz.drawImage(bu,0,0);bz.restore();if(bC){bz.drawImage(bx,0,0)}bz.restore()};this.repaint();return this};var aA=function(be,bB){bB=bB||{};var bd=(undefined===bB.size?200:bB.size);var a9=(undefined===bB.frameDesign?steelseries.FrameDesign.METAL:bB.frameDesign);var bs=(undefined===bB.frameVisible?true:bB.frameVisible);var a6=(undefined===bB.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bB.backgroundColor);var bp=(undefined===bB.backgroundVisible?true:bB.backgroundVisible);var bn=(undefined===bB.pointerType?steelseries.PointerType.TYPE2:bB.pointerType);var bG=(undefined===bB.pointerColor?steelseries.ColorDef.RED:bB.pointerColor);var bH=(undefined===bB.knobType?steelseries.KnobType.STANDARD_KNOB:bB.knobType);var bt=(undefined===bB.knobStyle?steelseries.KnobStyle.SILVER:bB.knobStyle);var bE=(undefined===bB.foregroundType?steelseries.ForegroundType.TYPE1:bB.foregroundType);var bD=(undefined===bB.foregroundVisible?true:bB.foregroundVisible);var bk=(undefined===bB.pointSymbols?["N","NE","E","SE","S","SW","W","NW"]:bB.pointSymbols);var bJ=(undefined===bB.customLayer?null:bB.customLayer);var bg=(undefined===bB.degreeScale?false:bB.degreeScale);var bc=(undefined===bB.roseVisible?true:bB.roseVisible);var bj;var bw=0;var bx=2*Math.PI/360;var bm=this.value;var bA=H.getElementById(be).getContext("2d");bA.save();bA.clearRect(0,0,bA.canvas.width,bA.canvas.height);bA.canvas.width=bd;bA.canvas.height=bd;var bI=bd;var bu=bd;var bb=bI/2;var ba=bu/2;var bh=false;var bv=P(bd,bd);var a5=bv.getContext("2d");var br=P(bd,bd);var a7=br.getContext("2d");var a8=P(bd,bd);var bq=a8.getContext("2d");var bl=P(bd,bd);var bf=bl.getContext("2d");var by=P(bd,bd);var bo=by.getContext("2d");var bF=function(bK){bK.textAlign="center";bK.textBaseline="middle";var bM,bL;bK.save();bK.strokeStyle=a6.labelColor.getRgbaColor();bK.fillStyle=a6.labelColor.getRgbaColor();bK.translate(bb,ba);if(!bg){bM=0.12*bI+"px serif";bL=0.06*bI+"px serif";for(i=0;360>i;i+=2.5){if(0===i%5){bK.lineWidth=1;bK.beginPath();bK.moveTo(bI*0.38,0);bK.lineTo(bI*0.36,0);bK.closePath();bK.stroke()}bK.save();switch(i){case 0:bK.translate(bI*0.35,0);bK.rotate(Math.PI/2);bK.font=bM;bK.fillText(bk[2],0,0,bI);bK.translate(-bI*0.35,0);break;case 45:bK.translate(bI*0.29,0);bK.rotate(Math.PI/2);bK.font=bL;bK.fillText(bk[3],0,0,bI);bK.translate(-bI*0.29,0);break;case 90:bK.translate(bI*0.35,0);bK.rotate(Math.PI/2);bK.font=bM;bK.fillText(bk[4],0,0,bI);bK.translate(-bI*0.35,0);break;case 135:bK.translate(bI*0.29,0);bK.rotate(Math.PI/2);bK.font=bL;bK.fillText(bk[5],0,0,bI);bK.translate(-bI*0.29,0);break;case 180:bK.translate(bI*0.35,0);bK.rotate(Math.PI/2);bK.font=bM;bK.fillText(bk[6],0,0,bI);bK.translate(-bI*0.35,0);break;case 225:bK.translate(bI*0.29,0);bK.rotate(Math.PI/2);bK.font=bL;bK.fillText(bk[7],0,0,bI);bK.translate(-bI*0.29,0);break;case 270:bK.translate(bI*0.35,0);bK.rotate(Math.PI/2);bK.font=bM;bK.fillText(bk[0],0,0,bI);bK.translate(-bI*0.35,0);break;case 315:bK.translate(bI*0.29,0);bK.rotate(Math.PI/2);bK.font=bL;bK.fillText(bk[1],0,0,bI);bK.translate(-bI*0.29,0);break}bK.restore();if(bc&&(0===i||22.5===i||45===i||67.5===i||90===i||112.5===i||135===i||157.5===i||180===i||202.5===i||225===i||247.5===i||270===i||292.5===i||315===i||337.5===i||360===i)){bK.save();bK.beginPath();if(i%45){bK.moveTo(bI*0.29,0)}else{bK.moveTo(bI*0.38,0)}bK.lineTo(bI*0.1,0);bK.closePath();bK.restore();bK.lineWidth=1;bK.strokeStyle=a6.symbolColor.getRgbaColor();bK.stroke()}bK.rotate(bx*2.5)}}else{bM=0.08*bI+"px serif";bL=bI*0.033+"px serif";bK.rotate(bx*10);for(i=10;360>=i;i+=10){bK.save();switch(i){case 360:bK.translate(bI*0.35,0);bK.rotate(Math.PI/2);bK.font=bM;bK.fillText(bk[2],0,0,bI);bK.translate(-bI*0.35,0);break;case 90:bK.translate(bI*0.35,0);bK.rotate(Math.PI/2);bK.font=bM;bK.fillText(bk[4],0,0,bI);bK.translate(-bI*0.35,0);break;case 180:bK.translate(bI*0.35,0);bK.rotate(Math.PI/2);bK.font=bM;bK.fillText(bk[6],0,0,bI);bK.translate(-bI*0.35,0);break;case 270:bK.translate(bI*0.35,0);bK.rotate(Math.PI/2);bK.font=bM;bK.fillText(bk[0],0,0,bI);bK.translate(-bI*0.35,0);break;default:var bN=(i+90)%360;bK.translate(bI*0.37,0);bK.rotate(Math.PI/2);bK.font=bL;bK.fillText(("0".substring(bN>=100)+bN),0,0,bI);bK.translate(-bI*0.37,0)}bK.restore();bK.rotate(bx*10)}}bK.translate(-bb,-ba);bK.restore()};var bi=function(bS,bP){bS.save();if(bP){bS.fillStyle="rgba(0, 0, 0, 0.5)";bS.strokeStyle="rgba(0, 0, 0, 0.5)"}switch(bn.type){case"type2":bS.beginPath();bS.moveTo(bI*0.53271,bu*0.453271);bS.bezierCurveTo(bI*0.53271,bu*0.453271,bI*0.5,bu*0.149532,bI*0.5,bu*0.149532);bS.bezierCurveTo(bI*0.5,bu*0.149532,bI*0.467289,bu*0.453271,bI*0.467289,bu*0.453271);bS.bezierCurveTo(bI*0.453271,bu*0.462616,bI*0.443925,bu*0.481308,bI*0.443925,bu*0.5);bS.bezierCurveTo(bI*0.443925,bu*0.5,bI*0.556074,bu*0.5,bI*0.556074,bu*0.5);bS.bezierCurveTo(bI*0.556074,bu*0.481308,bI*0.546728,bu*0.462616,bI*0.53271,bu*0.453271);bS.closePath();if(!bP){var bR=bS.createLinearGradient(0.471962*bI,0,0.528036*bI,0);bR.addColorStop(0,bG.light.getRgbaColor());bR.addColorStop(0.46,bG.light.getRgbaColor());bR.addColorStop(0.47,bG.medium.getRgbaColor());bR.addColorStop(1,bG.medium.getRgbaColor());bS.fillStyle=bR;bS.strokeStyle=bG.dark.getRgbaColor()}bS.lineWidth=1;bS.lineCap="square";bS.lineJoin="miter";bS.fill();bS.stroke();bS.beginPath();bS.moveTo(bI*0.467289,bu*0.546728);bS.bezierCurveTo(bI*0.467289,bu*0.546728,bI*0.5,bu*0.850467,bI*0.5,bu*0.850467);bS.bezierCurveTo(bI*0.5,bu*0.850467,bI*0.53271,bu*0.546728,bI*0.53271,bu*0.546728);bS.bezierCurveTo(bI*0.546728,bu*0.537383,bI*0.556074,bu*0.518691,bI*0.556074,bu*0.5);bS.bezierCurveTo(bI*0.556074,bu*0.5,bI*0.443925,bu*0.5,bI*0.443925,bu*0.5);bS.bezierCurveTo(bI*0.443925,bu*0.518691,bI*0.453271,bu*0.537383,bI*0.467289,bu*0.546728);bS.closePath();if(!bP){var bL=bS.createLinearGradient(0.471962*bI,0,0.528036*bI,0);bL.addColorStop(0,"#e3e5e8");bL.addColorStop(0.48,"#e3e5e8");bL.addColorStop(0.48,"#abb1b8");bL.addColorStop(1,"#abb1b8");bS.fillStyle=bL;var bM="#abb1b8";bS.strokeStyle=bM}bS.lineWidth=1;bS.lineCap="square";bS.lineJoin="miter";bS.fill();bS.stroke();break;case"type3":bS.beginPath();bS.moveTo(bI*0.5,bu*0.149532);bS.bezierCurveTo(bI*0.5,bu*0.149532,bI*0.443925,bu*0.490654,bI*0.443925,bu*0.5);bS.bezierCurveTo(bI*0.443925,bu*0.53271,bI*0.467289,bu*0.556074,bI*0.5,bu*0.556074);bS.bezierCurveTo(bI*0.53271,bu*0.556074,bI*0.556074,bu*0.53271,bI*0.556074,bu*0.5);bS.bezierCurveTo(bI*0.556074,bu*0.490654,bI*0.5,bu*0.149532,bI*0.5,bu*0.149532);bS.closePath();if(!bP){var bN=bS.createLinearGradient(0.471962*bI,0,0.528036*bI,0);bN.addColorStop(0,bG.light.getRgbaColor());bN.addColorStop(0.46,bG.light.getRgbaColor());bN.addColorStop(0.47,bG.medium.getRgbaColor());bN.addColorStop(1,bG.medium.getRgbaColor());bS.fillStyle=bN;bS.strokeStyle=bG.dark.getRgbaColor()}bS.lineWidth=1;bS.lineCap="square";bS.lineJoin="miter";bS.fill();bS.stroke();break;case"type1:":default:bS.beginPath();bS.moveTo(bI*0.5,bu*0.495327);bS.lineTo(bI*0.528037,bu*0.495327);bS.lineTo(bI*0.5,bu*0.149532);bS.lineTo(bI*0.471962,bu*0.495327);bS.lineTo(bI*0.5,bu*0.495327);bS.closePath();if(!bP){var bO=bS.createLinearGradient(0.471962*bI,0,0.528036*bI,0);bO.addColorStop(0,bG.light.getRgbaColor());bO.addColorStop(0.46,bG.light.getRgbaColor());bO.addColorStop(0.47,bG.medium.getRgbaColor());bO.addColorStop(1,bG.medium.getRgbaColor());bS.fillStyle=bO;bS.strokeStyle=bG.dark.getRgbaColor()}bS.lineWidth=1;bS.lineCap="square";bS.lineJoin="miter";bS.fill();bS.stroke();bS.beginPath();bS.moveTo(bI*0.5,bu*0.504672);bS.lineTo(bI*0.471962,bu*0.504672);bS.lineTo(bI*0.5,bu*0.850467);bS.lineTo(bI*0.528037,bu*0.504672);bS.lineTo(bI*0.5,bu*0.504672);bS.closePath();if(!bP){var bQ=bS.createLinearGradient(0.471962*bI,0,0.528036*bI,0);bQ.addColorStop(0,"#e3e5e8");bQ.addColorStop(0.48,"#e3e5e8");bQ.addColorStop(0.480099,"#abb1b8");bQ.addColorStop(1,"#abb1b8");bS.fillStyle=bQ;var bK="#abb1b8";bS.strokeStyle=bK}bS.lineWidth=1;bS.lineCap="square";bS.lineJoin="miter";bS.fill();bS.stroke();break}if(bP){al(bS,bI,bu,Math.floor(bI*0.006))}bS.restore()};var bz=function(){bh=true;if(bs){g(a5,a9,bb,ba,bI,bu)}if(bp){a2(a5,a6,bb,ba,bI,bu);W(a5,bJ,bb,ba,bI,bu);if(bc){j(a5,bb,ba,bI,bu,a6)}bF(a5)}bi(a7,false);bi(bq,true);if(bD){G(bo,bE,bI,bu,true,bH,bt)}};var bC=function(){bv.width=bd;bv.height=bd;a5=bv.getContext("2d");br.width=bd;br.height=bd;a7=br.getContext("2d");a8.width=bd;a8.height=bd;bq=a8.getContext("2d");bl.width=bd;bl.height=bd;bf=bl.getContext("2d");by.width=bd;by.height=bd;bo=by.getContext("2d")};this.setValue=function(bK){bK=bK%360;if(bw!==bK){bw=bK;this.repaint()}};this.getValue=function(){return bw};this.setValueAnimated=function(bN){var bK=bN%360;var bL=this;var bM;if(bw!==bK){if(undefined!==bj){if(bj.playing){bj.stop()}}bM=ap(bw,bK);bj=new Tween({},"",Tween.elasticEaseOut,bw,bw+bM,2);bj.onMotionChanged=function(bO){bw=bO.target._pos%360;bL.repaint()};bj.start()}};this.setFrameDesign=function(bK){bC();a9=bK;bz();this.repaint()};this.setBackgroundColor=function(bK){bC();a6=bK;bz();this.repaint()};this.setForegroundType=function(bK){bC();bE=bK;bz();this.repaint()};this.setPointerColor=function(bK){bC();bG=bK;bz();this.repaint()};this.setPointerType=function(bK){bC();bn=bK;bz();this.repaint()};this.setPointSymbols=function(bK){bC();bk=bK;bz();this.repaint()};this.repaint=function(){if(!bh){bz()}bA.clearRect(0,0,bA.canvas.width,bA.canvas.height);if(bs||bp){bA.drawImage(bv,0,0)}bm=Math.PI/2+bw*bx-Math.PI/2;var bK=bI*0.006;bf.clearRect(0,0,bI,bu);bf.save();bf.translate(bb,ba);bf.rotate(bm);bf.translate(-bb,-ba);bf.drawImage(a8,0,0);bf.restore();bA.drawImage(bl,0,0,bI,bu,bK,bK,bI+bK,bu+bK);bA.save();bA.translate(bb,ba);bA.rotate(bm);bA.translate(-bb,-ba);bA.drawImage(br,0,0);bA.restore();if(bD){bA.drawImage(by,0,0)}bA.restore()};this.repaint();return this};var N=function(ce,bs){bs=bs||{};var bz=(undefined===bs.size?200:bs.size);var cc=(undefined===bs.frameDesign?steelseries.FrameDesign.METAL:bs.frameDesign);var b5=(undefined===bs.frameVisible?true:bs.frameVisible);var bo=(undefined===bs.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bs.backgroundColor);var cd=(undefined===bs.backgroundVisible?true:bs.backgroundVisible);var b3=(undefined===bs.pointerTypeLatest?steelseries.PointerType.TYPE1:bs.pointerTypeLatest);var bq=(undefined===bs.pointerTypeAverage?steelseries.PointerType.TYPE8:bs.pointerTypeAverage);var b2=(undefined===bs.pointerColor?steelseries.ColorDef.RED:bs.pointerColor);var bF=(undefined===bs.pointerColorAverage?steelseries.ColorDef.BLUE:bs.pointerColorAverage);var b7=(undefined===bs.knobType?steelseries.KnobType.STANDARD_KNOB:bs.knobType);var bG=(undefined===bs.knobStyle?steelseries.KnobStyle.SILVER:bs.knobStyle);var b4=(undefined===bs.foregroundType?steelseries.ForegroundType.TYPE1:bs.foregroundType);var bS=(undefined===bs.foregroundVisible?true:bs.foregroundVisible);var bv=(undefined===bs.pointSymbols?["N","NE","E","SE","S","SW","W","NW"]:bs.pointSymbols);var bJ=(undefined===bs.customLayer?null:bs.customLayer);var b9=(undefined===bs.degreeScale?true:bs.degreeScale);var bQ=(undefined===bs.roseVisible?false:bs.roseVisible);var bN=(undefined===bs.lcdColor?steelseries.LcdColor.STANDARD:bs.lcdColor);var bg=(undefined===bs.lcdVisible?true:bs.lcdVisible);var bn=(undefined===bs.digitalFont?false:bs.digitalFont);var bZ=(undefined===bs.section?null:bs.section);var a8=(undefined===bs.area?null:bs.area);var bB=(undefined===bs.lcdTitleStrings?["Latest","Average"]:bs.lcdTitleStrings);var bE=(undefined===bs.titleString?"":bs.titleString);var bd=(undefined===bs.useColorLabels?false:bs.useColorLabels);var bW;var bu;var bk=0;var a5=0;var b1=2*Math.PI/360;var bt=this.valueLatest;var by=this.valueAverage;var bM=-Math.PI/2;var bU=Math.PI*2;var bx=360;var bf=H.getElementById(ce).getContext("2d");bf.save();bf.clearRect(0,0,bf.canvas.width,bf.canvas.height);bf.canvas.width=bz;bf.canvas.height=bz;var ba=bz;var b8=bz;var bl=ba/2;var bi=b8/2;var b0=Math.floor(ba/10);var bI=b0+"px sans-serif";var bp=b0+"px "+aM;var bj=ba*0.3;var bm=b8*0.12;var b6=(ba-bj)/2;var cb=b8*0.32;var ca=b8*0.565;var a7=false;var bA=P(bz,bz);var bC=bA.getContext("2d");var bR;var bH=P(bz,bz);var a9=bH.getContext("2d");var br=P(bz,bz);var bO=br.getContext("2d");var bP=P(bz,bz);var bD=bP.getContext("2d");var bw=P(bz,bz);var bX=bw.getContext("2d");var be=P(bz,bz);var bh=be.getContext("2d");var bV=P(bz,bz);var bb=bV.getContext("2d");var bY=function(cg,cf){bf.save();bf.textAlign="center";bf.strokeStyle=bN.textColor;bf.fillStyle=bN.textColor;if(cg<0){cg+=360}cg="00"+Math.round(cg);cg=cg.substring(cg.length,cg.length-3);if(bN===steelseries.LcdColor.STANDARD||bN===steelseries.LcdColor.STANDARD_GREEN){bf.shadowColor="gray";bf.shadowOffsetX=ba*0.007;bf.shadowOffsetY=ba*0.007;bf.shadowBlur=ba*0.007}bf.font=(bn?bp:bI);bf.fillText(cg+"\u00B0",ba/2+bj*0.05,(cf?cb:ca)+bm*0.5+b0*0.38,bj*0.9);bf.restore()};var a6=function(cf,cl,ci,cg,cj){cf.save();cf.strokeStyle=cg;cf.fillStyle=cg;cf.lineWidth=ba*0.035;var ch=(bU/bx*cl);var ck=ch+(ci-cl)/(bx/bU);cf.translate(bl,bi);cf.rotate(bM);cf.beginPath();if(cj){cf.moveTo(0,0);cf.arc(0,0,ba*0.365-cf.lineWidth/2,ch,ck,false)}else{cf.arc(0,0,ba*0.365,ch,ck,false)}if(cj){cf.moveTo(0,0);cf.fill()}else{cf.stroke()}cf.translate(-bl,-bi);cf.restore()};var bK=function(cq){cq.textAlign="center";cq.textBaseline="middle";var cl=ba*0.38;var cg=ba*0.35;var cn=ba*0.355;var ci=ba*0.36;var ch=ba*0.1;var co=ba*0.31;var cf=ba*0.36;var cp,cj;cq.save();cq.strokeStyle=bo.labelColor.getRgbaColor();cq.fillStyle=bo.labelColor.getRgbaColor();cq.translate(bl,bi);if(!b9){cp=0.12*ba+"px serif";cj=0.06*ba+"px serif";cq.lineWidth=1;cq.strokeStyle=bo.symbolColor.getRgbaColor();for(i=0;360>i;i+=2.5){if(0===i%5){cq.beginPath();cq.moveTo(ba*0.38,0);cq.lineTo(ba*0.36,0);cq.closePath();cq.stroke()}cq.save();switch(i){case 0:cq.translate(ba*0.35,0);cq.rotate(Math.PI/2);cq.font=cp;cq.fillText(bv[2],0,0);cq.translate(-ba*0.35,0);break;case 45:cq.translate(ba*0.29,0);cq.rotate(Math.PI/2);cq.font=cj;cq.fillText(bv[3],0,0);cq.translate(-ba*0.29,0);break;case 90:cq.translate(ba*0.35,0);cq.rotate(Math.PI/2);cq.font=cp;cq.fillText(bv[4],0,0);cq.translate(-ba*0.35,0);break;case 135:cq.translate(ba*0.29,0);cq.rotate(Math.PI/2);cq.font=cj;cq.fillText(bv[5],0,0);cq.translate(-ba*0.29,0);break;case 180:cq.translate(ba*0.35,0);cq.rotate(Math.PI/2);cq.font=cp;cq.fillText(bv[6],0,0);cq.translate(-ba*0.35,0);break;case 225:cq.translate(ba*0.29,0);cq.rotate(Math.PI/2);cq.font=cj;cq.fillText(bv[7],0,0);cq.translate(-ba*0.29,0);break;case 270:cq.translate(ba*0.35,0);cq.rotate(Math.PI/2);cq.font=cp;cq.fillText(bv[0],0,0);cq.translate(-ba*0.35,0);break;case 315:cq.translate(ba*0.29,0);cq.rotate(Math.PI/2);cq.font=cj;cq.fillText(bv[1],0,0);cq.translate(-ba*0.29,0);break}cq.restore();if(bQ&&(0===i||22.5===i||45===i||67.5===i||90===i||112.5===i||135===i||157.5===i||180===i||202.5===i||225===i||247.5===i||270===i||292.5===i||315===i||337.5===i||360===i)){cq.save();cq.beginPath();if(i%45){cq.moveTo(ba*0.29,0)}else{cq.moveTo(ba*0.38,0)}cq.lineTo(ba*0.1,0);cq.closePath();cq.restore();cq.stroke()}cq.rotate(b1*2.5)}}else{cp=Math.floor(0.1*ba)+"px serif bold";cj=Math.floor(ba*0.04)+"px sans-serif";cq.rotate(b1*5);for(i=5;360>=i;i+=5){cq.save();switch(i){case 360:cq.translate(cf,0);cq.rotate(Math.PI/2);cq.font=cp;cq.fillText(bv[2],0,0,ch);cq.translate(-cf,0);break;case 90:cq.translate(cf,0);cq.rotate(Math.PI/2);cq.font=cp;cq.fillText(bv[4],0,0,ch);cq.translate(-cf,0);break;case 180:cq.translate(cf,0);cq.rotate(Math.PI/2);cq.font=cp;cq.fillText(bv[6],0,0,ch);cq.translate(-cf,0);break;case 270:cq.translate(cf,0);cq.rotate(Math.PI/2);cq.font=cp;cq.fillText(bv[0],0,0,ch);cq.translate(-cf,0);break;case 5:case 85:case 95:case 175:case 185:case 265:case 275:case 355:break;default:if((i+90)%20){cq.lineWidth=((i+90)%5)?1.5:1;cq.beginPath();cq.moveTo(cl,0);var cm=(i+90)%10?ci:cg;cq.lineTo(cm,0);cq.closePath();cq.stroke()}else{cq.lineWidth=1.5;cq.beginPath();cq.moveTo(cl,0);cq.lineTo(cg,0);cq.closePath();cq.stroke();var ck=(i+90)%360;cq.translate(co,0);cq.rotate(Math.PI/2);cq.font=cj;cq.fillText(("0".substring(ck>=100)+ck),0,0,ch);cq.translate(-co,0)}}cq.restore();cq.rotate(b1*5)}}cq.translate(-bl,-bi);cq.restore()};var bT=function(cf){if(bB.length>0){cf.save();cf.textAlign="center";cf.textBaseline="middle";cf.fillStyle=(bd?b2.medium.getRgbaColor():bo.labelColor.getRgbaColor());cf.font=0.04*ba+"px sans-serif";cf.fillText(bB[0],ba/2,b8*0.29,ba*0.3);cf.fillStyle=(bd?bF.medium.getRgbaColor():bo.labelColor.getRgbaColor());cf.fillText(bB[1],ba/2,b8*0.71,ba*0.3);if(bE.length>0){cf.fillStyle=bo.labelColor.getRgbaColor();cf.font=0.0467*ba+"px sans-serif";cf.fillText(bE,ba/2,b8*0.5,ba*0.3)}}};var bL=function(ci){ci=ci||{};var cj=(undefined===ci.frame?false:ci.frame);var cl=(undefined===ci.background?false:ci.background);var ch=(undefined===ci.pointer?false:ci.pointer);var cf=(undefined===ci.foreground?false:ci.foreground);a7=true;if(cj&&b5){g(bC,cc,bl,bi,ba,b8)}if(cl&&cd){a2(bC,bo,bl,bi,ba,b8);W(bC,bJ,bl,bi,ba,b8);if(null!==bZ&&0<bZ.length){var ck=bZ.length;do{ck--;a6(bC,bZ[ck].start,bZ[ck].stop,bZ[ck].color,false)}while(0<ck)}if(null!==a8&&0<a8.length){var cg=a8.length;do{cg--;a6(bC,a8[cg].start,a8[cg].stop,a8[cg].color,true)}while(0<cg)}bK(bC)}if(cl&&bQ){j(bC,bl,bi,ba,b8,bo)}if(cl&&bg){bR=ab(bj,bm,bN);bC.drawImage(bR,b6,cb);bC.drawImage(bR,b6,ca);bT(bC)}if(ch){J(bD,ba,bq,bF,bo.labelColor);J(bX,ba,bq,b2,bo.labelColor,true);J(a9,ba,b3,b2,bo.labelColor);J(bO,ba,b3,b2,bo.labelColor,true)}if(cf&&bS){var cm=(b3.type==="type15"||b3.type==="type16"?false:true);G(bb,b4,ba,b8,cm,b7,bG)}};var bc=function(cg){cg=cg||{};var ci=(undefined===cg.background?false:cg.background);var ch=(undefined===cg.pointer?false:cg.pointer);var cf=(undefined===cg.foreground?false:cg.foreground);if(ci){bA.width=bz;bA.height=bz;bC=bA.getContext("2d")}if(ch){bH.width=bz;bH.height=bz;a9=bH.getContext("2d");br.width=bz;br.height=bz;bO=br.getContext("2d");bP.width=bz;bP.height=bz;bD=bP.getContext("2d");bw.width=bz;bw.height=bz;bX=bw.getContext("2d");be.width=bz;be.height=bz;bh=be.getContext("2d")}if(cf){bV.width=bz;bV.height=bz;bb=bV.getContext("2d")}};this.setValueLatest=function(cf){cf=cf===360?360:cf%360;if(bk!==cf){bk=cf;this.repaint()}};this.getValueLatest=function(){return bk};this.setValueAverage=function(cf){cf=cf%360;if(a5!==cf){a5=cf;this.repaint()}};this.getValueAverage=function(){return a5};this.setValueAnimatedLatest=function(ci){var cf=(ci===360?360:ci%360);if(bk!==cf){var cg=this;if(undefined!==bW){if(bW.playing){bW.stop()}}var ch=ap(bk,cf);bW=new Tween({},"",Tween.regularEaseInOut,bk,bk+ch,2.5);bW.onMotionChanged=function(cj){bk=cj.target._pos%360;cg.repaint()};if(cf===360){bW.onMotionFinished=function(cj){bk=cf;cg.repaint()}}bW.start()}};this.setValueAnimatedAverage=function(ci){var cf=(ci===360?360:ci%360);if(a5!==ci){var cg=this;if(undefined!==bu){if(bu.playing){bu.stop()}}var ch=ap(a5,cf);bu=new Tween({},"",Tween.regularEaseInOut,a5,a5+ch,2.5);bu.onMotionChanged=function(cj){a5=cj.target._pos%360;cg.repaint()};if(cf===360){bW.onMotionFinished=function(cj){a5=cf;cg.repaint()}}bu.start()}};this.setArea=function(cf){a8=cf;bL({background:true});this.repaint()};this.setSection=function(cf){bZ=cf;bL({background:true});this.repaint()};this.setFrameDesign=function(cf){cc=cf;bL({frame:true,background:true});this.repaint()};this.setBackgroundColor=function(cf){bo=cf;bL({frame:true,background:true});this.repaint()};this.setForegroundType=function(cf){bc({foreground:true});b4=cf;bL({foreground:true});this.repaint()};this.setPointerColor=function(cf){bc({pointer:true});b2=cf;bL({pointer:true});this.repaint()};this.setPointerColorAverage=function(cf){bc({pointer:true});bF=cf;bL({pointer:true});this.repaint()};this.setPointerType=function(cf){bc({pointer:true});b3=cf;bL({pointer:true});this.repaint()};this.setPointerTypeAverage=function(cf){bc({pointer:true});bq=cf;bL({pointer:true});this.repaint()};this.setPointSymbols=function(cf){bv=cf;bL({frame:true,background:true});this.repaint()};this.setLcdColor=function(cf){bN=cf;bL({background:true});this.repaint()};this.setLcdTitleStrings=function(cf){bB=cf;bL({background:true});this.repaint()};this.repaint=function(){if(!a7){bL({frame:true,background:true,led:true,pointer:true,foreground:true})}bf.clearRect(0,0,bf.canvas.width,bf.canvas.height);if(b5||cd){bf.drawImage(bA,0,0)}if(bg){bY(bk,true);bY(a5,false)}by=Math.PI/2+a5*b1-Math.PI/2;var cf=ba*0.006;bh.clearRect(0,0,ba,b8);bh.save();bh.translate(bl,bi);bh.rotate(by);bh.translate(-bl,-bi);bh.drawImage(bw,0,0);bh.restore();bf.drawImage(be,0,0,ba,b8,cf,cf,ba+cf,b8+cf);bf.save();bf.translate(bl,bi);bf.rotate(by);bf.translate(-bl,-bi);bf.drawImage(bP,0,0);bf.restore();bt=Math.PI/2+bk*b1-Math.PI/2;bh.clearRect(0,0,ba,b8);bh.save();bh.translate(bl,bi);bh.rotate(bt);bh.translate(-bl,-bi);bh.drawImage(br,0,0);bh.restore();bf.drawImage(be,0,0,ba,b8,cf,cf,ba+cf,b8+cf);bf.save();bf.translate(bl,bi);bf.rotate(bt);bf.translate(-bl,-bi);bf.drawImage(bH,0,0);bf.restore();if(bS){bf.drawImage(bV,0,0)}};this.repaint();return this};var an=function(bb,bg){bg=bg||{};var bq=(undefined===bg.size?200:bg.size);var bf=(undefined===bg.frameDesign?steelseries.FrameDesign.METAL:bg.frameDesign);var a8=(undefined===bg.frameVisible?true:bg.frameVisible);var by=(undefined===bg.foregroundType?steelseries.ForegroundType.TYPE1:bg.foregroundType);var bu=(undefined===bg.foregroundVisible?true:bg.foregroundVisible);var bt=(undefined===bg.pointerColor?steelseries.ColorDef.WHITE:bg.pointerColor);var bB;var be;var bw=0;var bk=0;var bp=(Math.PI*bq)/360;var br=0;var bx=false;var bn=H.getElementById(bb).getContext("2d");bn.save();bn.clearRect(0,0,bn.canvas.width,bn.canvas.height);bn.canvas.width=bq;bn.canvas.height=bq;var bm=bq;var bA=bq;var bj=bm/2;var bi=bA/2;var bc=false;var a9=P(bq,bq);var bC=a9.getContext("2d");var bd=P(bq,bq*Math.PI);var a6=bd.getContext("2d");var bl=P(bq*0.037383,bq*0.056074);var a7=bl.getContext("2d");var bs=P(bq,bq);var ba=bs.getContext("2d");var bz=function(bK){bK.save();var bH=bq;var bI=bq*Math.PI;var bG;bK.beginPath();bK.rect(0,0,bH,bI);bK.closePath();var bF=bK.createLinearGradient(0,0,0,bI);bF.addColorStop(0,"#7fd5f0");bF.addColorStop(0.5,"#7fd5f0");bF.addColorStop(0.5,"#3c4439");bF.addColorStop(1,"#3c4439");bK.fillStyle=bF;bK.fill();bK.lineWidth=1;var bJ=bI/360*5;var bE=false;var bD=10;bK.textAlign="center";bK.textBaseline="middle";var bL=bH*0.04;bK.font=bL+"px sans-serif";bK.fillStyle="#37596e";for(bG=bI/2-bJ;bG>0;bG-=bJ){if(bD<=90){if(bE){bK.fillText(bD,(bH-(bH*0.2))/2-8,bG,bH*0.375);bK.fillText(bD,bH-(bH-(bH*0.2))/2+8,bG,bH*0.375);bK.beginPath();bK.moveTo((bH-(bH*0.2))/2,bG);bK.lineTo(bH-(bH-(bH*0.2))/2,bG);bK.closePath();bD+=10}else{bK.beginPath();bK.moveTo((bH-(bH*0.1))/2,bG);bK.lineTo(bH-(bH-(bH*0.1))/2,bG);bK.closePath()}bK.stroke()}bE^=true}bE=false;bD=10;bK.strokeStyle="#FFFFFF";bK.lineWidth=1.5;bK.beginPath();bK.moveTo(0,bI/2);bK.lineTo(bH,bI/2);bK.closePath();bK.stroke();bK.fillStyle="#FFFFFF";bK.lineWidth=1;for(bG=bI/2+bJ;bG<=bI;bG+=bJ){if(bD<=90){if(bE){bK.fillText(-bD,(bH-(bH*0.2))/2-8,bG,bH*0.375);bK.fillText(-bD,bH-(bH-(bH*0.2))/2+8,bG,bH*0.375);bK.beginPath();bK.moveTo((bH-(bH*0.2))/2,bG);bK.lineTo(bH-(bH-(bH*0.2))/2,bG);bK.closePath();bD+=10}else{bK.beginPath();bK.moveTo((bH-(bH*0.1))/2,bG);bK.lineTo(bH-(bH-(bH*0.1))/2,bG);bK.closePath()}bK.stroke()}bE^=true}bK.restore()};var bh=function(bD){bD.save();bD.fillStyle=bt.light.getRgbaColor();bD.beginPath();bD.moveTo(bm*0.476635,bA*0.5);bD.bezierCurveTo(bm*0.476635,bA*0.514018,bm*0.485981,bA*0.523364,bm*0.5,bA*0.523364);bD.bezierCurveTo(bm*0.514018,bA*0.523364,bm*0.523364,bA*0.514018,bm*0.523364,bA*0.5);bD.bezierCurveTo(bm*0.523364,bA*0.485981,bm*0.514018,bA*0.476635,bm*0.5,bA*0.476635);bD.bezierCurveTo(bm*0.485981,bA*0.476635,bm*0.476635,bA*0.485981,bm*0.476635,bA*0.5);bD.closePath();bD.moveTo(bm*0.415887,bA*0.504672);bD.lineTo(bm*0.415887,bA*0.495327);bD.bezierCurveTo(bm*0.415887,bA*0.495327,bm*0.467289,bA*0.495327,bm*0.467289,bA*0.495327);bD.bezierCurveTo(bm*0.471962,bA*0.481308,bm*0.481308,bA*0.471962,bm*0.495327,bA*0.467289);bD.bezierCurveTo(bm*0.495327,bA*0.467289,bm*0.495327,bA*0.415887,bm*0.495327,bA*0.415887);bD.lineTo(bm*0.504672,bA*0.415887);bD.bezierCurveTo(bm*0.504672,bA*0.415887,bm*0.504672,bA*0.467289,bm*0.504672,bA*0.467289);bD.bezierCurveTo(bm*0.518691,bA*0.471962,bm*0.528037,bA*0.481308,bm*0.53271,bA*0.495327);bD.bezierCurveTo(bm*0.53271,bA*0.495327,bm*0.584112,bA*0.495327,bm*0.584112,bA*0.495327);bD.lineTo(bm*0.584112,bA*0.504672);bD.bezierCurveTo(bm*0.584112,bA*0.504672,bm*0.53271,bA*0.504672,bm*0.53271,bA*0.504672);bD.bezierCurveTo(bm*0.528037,bA*0.518691,bm*0.518691,bA*0.53271,bm*0.5,bA*0.53271);bD.bezierCurveTo(bm*0.481308,bA*0.53271,bm*0.471962,bA*0.518691,bm*0.467289,bA*0.504672);bD.bezierCurveTo(bm*0.467289,bA*0.504672,bm*0.415887,bA*0.504672,bm*0.415887,bA*0.504672);bD.closePath();bD.fill();var bF=5;var bE=5*Math.PI/180;bD.translate(bj,bi);bD.rotate(-Math.PI/2);bD.translate(-bj,-bi);for(var bG=-90;bG<=90;bG+=bF){if(bG%45===0||bG===0){bD.strokeStyle=bt.medium.getRgbaColor();bD.lineWidth=2;bD.beginPath();bD.moveTo(bm*0.5,bA*0.088785);bD.lineTo(bm*0.5,bA*0.113);bD.closePath();bD.stroke()}else{if(bG%15===0){bD.strokeStyle="#FFFFFF";bD.lineWidth=1;bD.beginPath();bD.moveTo(bm*0.5,bA*0.088785);bD.lineTo(bm*0.5,bA*0.103785);bD.closePath();bD.stroke()}else{bD.strokeStyle="#FFFFFF";bD.lineWidth=0.5;bD.beginPath();bD.moveTo(bm*0.5,bA*0.088785);bD.lineTo(bm*0.5,bA*0.093785);bD.closePath();bD.stroke()}}bD.translate(bj,bi);bD.rotate(bE,bj,bi);bD.translate(-bj,-bi)}bD.restore()};var a5=function(bE){bE.save();var bF=bm*0.037383;var bD=bA*0.056074;bE.beginPath();bE.moveTo(bF*0.5,0);bE.lineTo(0,bD);bE.lineTo(bF,bD);bE.closePath();bE.fillStyle=bt.light.getRgbaColor();bE.fill();bE.strokeStyle=bt.medium.getRgbaColor();bE.stroke();bE.restore()};var bv=function(){bc=true;if(a8){g(bC,bf,bj,bi,bm,bA)}bz(a6);a5(a7);bh(ba);if(bu){G(ba,by,bm,bA,true,aU,aa,R)}};var bo=function(){a9.width=bq;a9.height=bq;bC=a9.getContext("2d");bd.width=bq;bd.height=bq*Math.PI;a6=bd.getContext("2d");bl.width=bq*0.037383;bl.height=bq*0.056074;a7=bl.getContext("2d");bs.width=bq;bs.height=bq;ba=bs.getContext("2d")};this.setRoll=function(bD){bD=bD%360;if(bw!==bD){bw=bD;this.repaint()}};this.getRoll=function(){return bw};this.setRollAnimated=function(bD){bD=bD%360;if(bw!==bD){var bE=this;if(undefined!==bB){if(bB.playing){bB.stop()}}bB=new Tween({},"",Tween.regularEaseInOut,bw,bD,1);bB.onMotionChanged=function(bF){bw=bF.target._pos;bE.repaint()};bB.start()}};this.setPitch=function(bD){bD=((bD+180-br)%360)-180;if(bk!==bD){bk=bD;if(bk>90){bk=90-(bk-90);if(!bx){this.setRoll(bw-180)}bx=true}else{if(bk<-90){bk=-90+(-90-bk);if(!bx){this.setRoll(bw+180)}bx=true}else{bx=false}}this.repaint()}};this.getPitch=function(){return bk};this.setPitchAnimated=function(bE){if(bk!==bE){if(undefined!==be){if(be.playing){be.stop()}}var bD=this;be=new Tween({},"",Tween.regularEaseInOut,bk,bE,1);be.onMotionChanged=function(bF){bD.setPitch(bF.target._pos)};be.start()}};this.setPitchOffset=function(bD){br=bD;this.repaint()};this.setFrameDesign=function(bD){bo();bf=bD;bv();this.repaint()};this.setForegroundType=function(bD){bo();by=bD;bv();this.repaint()};this.repaint=function(){if(!bc){bv()}bn.save();bn.clearRect(0,0,bn.canvas.width,bn.canvas.height);bn.drawImage(a9,0,0);bn.save();bn.beginPath();bn.arc(bj,bi,bm*0.831775/2,0,Math.PI*2,true);bn.closePath();bn.clip();bn.translate(bj,bi);bn.rotate(-(bw*Math.PI/180));bn.translate(-bj,0);bn.translate(0,(bk*bp));bn.drawImage(bd,0,-bd.height/2);bn.translate(0,-(bk*bp)-bi);bn.drawImage(bl,(bm*0.5-bl.width/2),(bm*0.107476));bn.restore();bn.drawImage(bs,0,0);bn.restore()};this.repaint();return this};var ay=function(a9,bg){bg=bg||{};var bj=(undefined===bg.size?32:bg.size);var a8=(undefined===bg.ledColor?steelseries.LedColor.RED_LED:bg.ledColor);var bi=false;var a7=0;var a6=H.getElementById(a9).getContext("2d");a6.save();a6.clearRect(0,0,a6.canvas.width,a6.canvas.height);a6.canvas.width=bj;a6.canvas.height=bj;var bb=false;var bf=H.createElement("canvas");bf.width=bj;bf.height=bj;var be=bf.getContext("2d");var a5=H.createElement("canvas");a5.width=bj;a5.height=bj;var ba=a5.getContext("2d");var bd=a5;var bh=function(){bb=true;be.clearRect(0,0,be.canvas.width,be.canvas.height);be.drawImage(aj(bj,1,a8),0,0);ba.clearRect(0,0,ba.canvas.width,ba.canvas.height);ba.drawImage(aj(bj,0,a8),0,0)};this.toggleLed=function(){if(bd===bf){bd=a5}else{bd=bf}bc()};this.setLedColor=function(bk){a8=bk;bb=false;bc()};this.setLedOnOff=function(bk){if(true===bk){bd=bf}else{bd=a5}bc()};this.blink=function(bk){if(bk){if(!bi){a7=setInterval(this.toggleLed,1000);bi=true}}else{if(bi){clearInterval(a7);bi=false}}};var bc=function(){if(!bb){bh()}a6.save();a6.clearRect(0,0,a6.canvas.width,a6.canvas.height);a6.drawImage(bd,0,0);a6.restore()};bc();return this};var f=function(bi,bW){bW=bW||{};var bh=(undefined===bW.size?200:bW.size);var a8=(undefined===bW.frameDesign?steelseries.FrameDesign.METAL:bW.frameDesign);var bJ=(undefined===bW.frameVisible?true:bW.frameVisible);var bu=(undefined===bW.pointerType?steelseries.PointerType.TYPE1:bW.pointerType);var b4=(undefined===bW.pointerColor?(bu===steelseries.PointerType.TYPE1?steelseries.ColorDef.GRAY:steelseries.ColorDef.BLACK):bW.pointerColor);var a7=(undefined===bW.backgroundColor?(bu===steelseries.PointerType.TYPE1?steelseries.BackgroundColor.ANTHRACITE:steelseries.BackgroundColor.LIGHT_GRAY):bW.backgroundColor);var bC=(undefined===bW.backgroundVisible?true:bW.backgroundVisible);var b2=(undefined===bW.foregroundType?steelseries.ForegroundType.TYPE1:bW.foregroundType);var b1=(undefined===bW.foregroundVisible?true:bW.foregroundVisible);var b9=(undefined===bW.customLayer?null:bW.customLayer);var bx=(undefined===bW.isAutomatic?true:bW.isAutomatic);var bA=(undefined===bW.hour?11:bW.hour);var bl=(undefined===bW.minute?5:bW.minute);var bF=(undefined===bW.second?0:bW.second);var b7=(undefined===bW.secondMovesContinuous?false:bW.secondMovesContinuous);var bQ=(undefined===bW.timeZoneOffsetHour?0:bW.timeZoneOffsetHour);var bH=(undefined===bW.timeZoneOffsetMinute?0:bW.timeZoneOffsetMinute);var bw=(undefined===bW.secondPointerVisible?true:bW.secondPointerVisible);var bI=new Date();var bP;var bK;var bY;var by;var ba=(b7?100:1000);ba=(bw?ba:100);var bk=this;var bS=Math.PI/2;var bd=Math.PI*2;var bR=Math.PI/180;var bc=6;var bV=H.getElementById(bi).getContext("2d");bV.save();bV.clearRect(0,0,bV.canvas.width,bV.canvas.height);bV.canvas.width=bh;bV.canvas.height=bh;var b6=bh;var bM=bh;var bb=b6/2;var a9=bM/2;var bn=false;var bo=P(bh,bh);var be=bo.getContext("2d");var bN=P(bh,bh);var a6=bN.getContext("2d");var bp=P(bh,bh);var bf=bp.getContext("2d");var bX=P(bh,bh);var bj=bX.getContext("2d");var bD=P(bh,bh);var bE=bD.getContext("2d");var b5=P(bh,bh);var bB=b5.getContext("2d");var bO=P(bh,bh);var b0=bO.getContext("2d");var bg=P(bh,bh);var bs=bg.getContext("2d");var br=P(bh,bh);var bm=br.getContext("2d");var bT=P(bh,bh);var bz=bT.getContext("2d");var b3=function(ca,cg){var ce;var cd;var cf;var cb,cc;cb=b6*0.405;ca.save();ca.translate(bb,a9);switch(cg.type){case"type1":cd=b6*0.074766;cc=cb-cd;ca.strokeStyle=a7.labelColor.getRgbaColor();ca.lineWidth=b6*0.014018;for(ce=0;ce<360;ce+=30){ca.beginPath();ca.moveTo(cb,0);ca.lineTo(cc,0);ca.closePath();ca.stroke();ca.rotate(30*bR)}cf=b6*0.126168;cc=cb-cf;ca.lineWidth=b6*0.03271;for(ce=0;ce<360;ce+=90){ca.beginPath();ca.moveTo(cb,0);ca.lineTo(cc,0);ca.closePath();ca.stroke();ca.rotate(90*bR)}break;case"type2":default:cd=b6*0.037383;cc=cb-cd;ca.strokeStyle=a7.labelColor.getRgbaColor();ca.lineWidth=b6*0.009345;for(ce=0;ce<360;ce+=6){ca.beginPath();ca.moveTo(cb,0);ca.lineTo(cc,0);ca.closePath();ca.stroke();ca.rotate(6*bR)}cf=b6*0.084112;cc=cb-cf;ca.lineWidth=b6*0.028037;for(ce=0;ce<360;ce+=30){ca.beginPath();ca.moveTo(cb,0);ca.lineTo(cc,0);ca.closePath();ca.stroke();ca.rotate(30*bR)}break}ca.translate(-bb,-a9);ca.restore()};var b8=function(ca,cb,cd){ca.save();var cc;if(cd){ca.fillStyle="rgba(0, 0, 0, 0.5)";ca.strokeStyle="rgba(0, 0, 0, 0.5)"}switch(cb.type){case"type2":ca.beginPath();ca.lineWidth=b6*0.046728;ca.moveTo(bb,b6*0.289719);ca.lineTo(bb,b6*0.289719+b6*0.224299);if(!cd){ca.strokeStyle=b4.medium.getRgbaColor()}ca.closePath();ca.stroke();break;case"type1":default:ca.beginPath();ca.moveTo(b6*0.471962,bM*0.560747);ca.lineTo(b6*0.471962,bM*0.214953);ca.lineTo(b6*0.5,bM*0.182242);ca.lineTo(b6*0.528037,bM*0.214953);ca.lineTo(b6*0.528037,bM*0.560747);ca.lineTo(b6*0.471962,bM*0.560747);ca.closePath();if(!cd){cc=ca.createLinearGradient(b6*0.471962,bM*0.560747,b6*0.528037,bM*0.214953);cc.addColorStop(1,b4.veryLight.getRgbaColor());cc.addColorStop(0,b4.light.getRgbaColor());ca.fillStyle=cc;ca.strokeStyle=b4.light.getRgbaColor()}ca.fill();ca.stroke();break}if(cd){al(ca,b6,bM,Math.floor(b6*0.006))}ca.restore()};var a5=function(ca,cb,cd){ca.save();var cc;if(cd){ca.fillStyle="rgba(0, 0, 0, 0.4)";ca.strokeStyle="rgba(0, 0, 0, 0.4)"}switch(cb.type){case"type2":ca.beginPath();ca.lineWidth=b6*0.03271;ca.moveTo(bb,b6*0.116822);ca.lineTo(bb,b6*0.116822+b6*0.38785);if(!cd){ca.strokeStyle=b4.medium.getRgbaColor()}ca.closePath();ca.stroke();break;case"type1":default:ca.beginPath();ca.moveTo(b6*0.518691,bM*0.574766);ca.lineTo(b6*0.523364,bM*0.135514);ca.lineTo(b6*0.5,bM*0.107476);ca.lineTo(b6*0.476635,bM*0.140186);ca.lineTo(b6*0.476635,bM*0.574766);ca.lineTo(b6*0.518691,bM*0.574766);ca.closePath();if(!cd){cc=ca.createLinearGradient(b6*0.518691,bM*0.574766,b6*0.476635,bM*0.140186);cc.addColorStop(1,b4.veryLight.getRgbaColor());cc.addColorStop(0,b4.light.getRgbaColor());ca.fillStyle=cc;ca.strokeStyle=b4.light.getRgbaColor()}ca.fill();ca.stroke();break}if(cd){al(ca,b6,bM,Math.floor(b6*0.006))}ca.restore()};var bt=function(ca,cb,cd){ca.save();var cc;if(cd){ca.fillStyle="rgba(0, 0, 0, 0.5)";ca.strokeStyle="rgba(0, 0, 0, 0.5)"}else{ca.fillStyle=steelseries.ColorDef.RED.medium.getRgbaColor();ca.strokeStyle=steelseries.ColorDef.RED.medium.getRgbaColor()}switch(cb.type){case"type2":ca.lineWidth=b6*0.009345;ca.beginPath();ca.moveTo(bb,b6*0.09813);ca.lineTo(bb,b6*0.09813+b6*0.126168);ca.closePath();ca.stroke();ca.lineWidth=b6*0.018691;ca.beginPath();ca.moveTo(bb,b6*0.308411);ca.lineTo(bb,b6*0.308411+b6*0.191588);ca.closePath();ca.stroke();ca.lineWidth=b6*0.016;ca.beginPath();ca.arc(bb,b6*0.26,b6*0.085/2,0,bd);ca.closePath();ca.stroke();break;case"type1":default:ca.beginPath();ca.moveTo(b6*0.509345,bM*0.116822);ca.lineTo(b6*0.509345,bM*0.574766);ca.lineTo(b6*0.490654,bM*0.574766);ca.lineTo(b6*0.490654,bM*0.116822);ca.lineTo(b6*0.509345,bM*0.116822);ca.closePath();if(!cd){cc=ca.createLinearGradient(b6*0.509345,bM*0.116822,b6*0.490654,bM*0.574766);cc.addColorStop(0,steelseries.ColorDef.RED.light.getRgbaColor());cc.addColorStop(0.47,steelseries.ColorDef.RED.medium.getRgbaColor());cc.addColorStop(1,steelseries.ColorDef.RED.dark.getRgbaColor());ca.fillStyle=cc;ca.strokeStyle=steelseries.ColorDef.RED.dark.getRgbaColor()}ca.fill();ca.stroke();break}if(cd){al(ca,b6,bM,Math.floor(b6*0.006))}ca.restore()};var bv=function(cb){var ca=b6*0.006;var cc;cb.beginPath();cb.arc(bb,a9,b6*0.045,0,bd);cb.closePath();cc=cb.createLinearGradient(bb-b6*0.045/2,a9-b6*0.045/2,bb+b6*0.045/2,a9+b6*0.045/2);cc.addColorStop(0,"#eef0f2");cc.addColorStop(1,"#65696d");cb.fillStyle=cc;cb.fill()};var bL=function(cb,cc){var ca=b6*0.006;var cd;cb.save();switch(cc.type){case"type2":cb.fillStyle="#000000";cb.beginPath();cb.arc(bb,a9,b6*0.088785/2,0,bd);cb.closePath();cb.fill();break;case"type1":default:cd=cb.createLinearGradient(bb-b6*0.027/2,a9-b6*0.027/2,bb+b6*0.027/2,a9+b6*0.027/2);cd.addColorStop(0,"#f3f4f7");cd.addColorStop(0.11,"#f3f5f7");cd.addColorStop(0.12,"#f1f3f5");cd.addColorStop(0.2,"#c0c5cb");cd.addColorStop(0.2,"#bec3c9");cd.addColorStop(1,"#bec3c9");cb.fillStyle=cd;cb.beginPath();cb.arc(bb,a9,b6*0.027,0,bd);cb.closePath();cb.fill();break}cb.restore()};var bG=function(ca,cc,cb){bY=cb*bc*bR;bP=cc*bc*bR;bK=(ca+cc/60)*bc*5*bR};var bq=function(){if(bx){bI=new Date()}else{bI.setHours(bA);bI.setMinutes(bl);bI.setSeconds(bF)}bF=bI.getSeconds()+(b7?bI.getMilliseconds()/1000:0);if(bQ!=0&&bH!=0){bA=bI.getUTCHours()+bQ}else{bA=bI.getHours()}bA=bA%12;if(bQ!=0&&bH!=0){bl=bI.getUTCMinutes()+bH}else{bl=bI.getMinutes()}if(bl>60){bl-=60;bA++}if(bl<0){bl+=60;bA--}bA=bA%12;bG(bA,bl,bF);if(bx){by=setTimeout(bq,ba)}bk.repaint()};var bU=function(cb){cb=cb||{};var cc=(undefined===cb.frame?false:cb.frame);var cd=(undefined===cb.background?false:cb.background);var ce=(undefined===cb.pointers?false:cb.pointers);var ca=(undefined===cb.foreground?false:cb.foreground);bn=true;if(cc&&bJ){g(be,a8,bb,a9,b6,bM)}if(cd&&bC){a2(a6,a7,bb,a9,b6,bM);W(a6,b9,bb,a9,b6,bM);b3(a6,bu)}if(ce){b8(bf,bu,false);b8(bj,bu,true);a5(bE,bu,false);a5(bB,bu,true);bt(b0,bu,false);bt(bs,bu,true)}if(ca&&b1){bL(bz,bu);G(bz,b2,b6,bM,false)}};var bZ=function(cb){cb=cb||{};var cc=(undefined===cb.frame?false:cb.frame);var cd=(undefined===cb.background?false:cb.background);var ce=(undefined===cb.pointers?false:cb.pointers);var ca=(undefined===cb.foreground?false:cb.foreground);if(cc){bo.width=bh;bo.height=bh;be=bo.getContext("2d")}if(cd){bN.width=bh;bN.height=bh;a6=bN.getContext("2d")}if(ce){bp.width=bh;bp.height=bh;bf=bp.getContext("2d");bX.width=bh;bX.height=bh;bj=bX.getContext("2d");bD.width=bh;bD.height=bh;bE=bD.getContext("2d");b5.width=bh;b5.height=bh;bB=b5.getContext("2d");bO.width=bh;bO.height=bh;b0=bO.getContext("2d");bg.width=bh;bg.height=bh;bs=bg.getContext("2d");br.width=bh;br.height=bh;bm=br.getContext("2d")}if(ca){bT.width=bh;bT.height=bh;bz=bT.getContext("2d")}};this.getAutomatic=function(){return bx};this.setAutomatic=function(ca){if(bx&&!ca){clearTimer(by);bx=ca}else{if(!bx&&ca){bx=ca;bq()}}};this.getHour=function(){return bA};this.setHour=function(ca){ca=ca%12;if(bA!==ca){bA=ca;bG(bA,bl,bF);this.repaint()}};this.getMinute=function(){return bl};this.setMinute=function(ca){ca=ca%60;if(bl!==ca){bl=ca;bG(bA,bl,bF);this.repaint()}};this.getSecond=function(){return bF};this.setSecond=function(ca){bF=ca%60;if(bF!==ca){bF=ca;bG(bA,bl,bF);this.repaint()}};this.getTimeZoneOffsetHour=function(){return bQ};this.setTimeZoneOffsetHour=function(ca){bQ=ca;this.repaint()};this.getTimeZoneOffsetMinute=function(){return bH};this.setTimeZoneOffsetMinute=function(ca){bH=ca;this.repaint()};this.getSecondPointerVisible=function(){return bw};this.setSecondPointerVisible=function(ca){bw=ca;this.repaint()};this.getSecondMovesContinuous=function(){return b7};this.setSecondMovesContinuous=function(ca){b7=ca;ba=(b7?100:1000);ba=(bw?ba:100)};this.setFrameDesign=function(ca){bZ({frame:true});a8=ca;bU({frame:true});this.repaint()};this.setBackgroundColor=function(ca){bZ({frame:true,background:true});a7=ca;bU({frame:true,background:true});this.repaint()};this.setForegroundType=function(ca){bZ({foreground:true});b2=ca;bU({foreground:true});this.repaint()};this.setPointerType=function(ca){bZ({foreground:true,pointers:true});bu=ca;if(bu.type==="type1"){b4=steelseries.ColorDef.GRAY;a7=steelseries.BackgroundColor.ANTHRACITE}else{b4=steelseries.ColorDef.BLACK;a7=steelseries.BackgroundColor.LIGHT_GRAY}bU({background:true,foreground:true,pointers:true});this.repaint()};this.setPointerColor=function(ca){bZ({pointers:true});b4=ca;bU({pointers:true});this.repaint()};this.repaint=function(){if(!bn){bU({frame:true,background:true,pointers:true,foreground:true})}bV.clearRect(0,0,bV.canvas.width,bV.canvas.height);if(bJ){bV.drawImage(bo,0,0)}if(bC){bV.drawImage(bN,0,0)}var ca=b6*0.006;bm.clearRect(0,0,b6,bM);bm.save();bm.translate(bb,a9);bm.rotate(bK);bm.translate(-bb,-a9);bm.drawImage(bX,0,0);bm.restore();bV.drawImage(br,0,0,b6,bM,ca,ca,b6+ca,bM+ca);bV.save();bV.translate(bb,a9);bV.rotate(bK);bV.translate(-bb,-a9);bV.drawImage(bp,0,0);bV.restore();bm.clearRect(0,0,b6,bM);bm.save();bm.translate(bb,a9);bm.rotate(bP);bm.translate(-bb,-a9);bm.drawImage(b5,0,0);bm.restore();bV.drawImage(br,0,0,b6,bM,ca,ca,b6+ca,bM+ca);bV.save();bV.translate(bb,a9);bV.rotate(bP);bV.translate(-bb,-a9);bV.drawImage(bD,0,0);bV.restore();if(bu.type==="type1"){bv(bV)}if(bw){bm.clearRect(0,0,b6,bM);bm.save();bm.translate(bb,a9);bm.rotate(bY);bm.translate(-bb,-a9);bm.drawImage(bg,0,0);bm.restore();bV.drawImage(br,0,0,b6,bM,ca,ca,b6+ca,bM+ca);bV.save();bV.translate(bb,a9);bV.rotate(bY);bV.translate(-bb,-a9);bV.drawImage(bO,0,0);bV.restore()}if(b1){bV.drawImage(bT,0,0)}};bq();return this};var ag=function(a8,bb){bb=bb||{};var ba=(undefined===bb.size?50:bb.size);var bc=(undefined===bb.value?50:bb.value);var a7=ba;var a6=Math.ceil(ba*0.45);var a9=H.getElementById(a8).getContext("2d");a9.save();a9.clearRect(0,0,a9.canvas.width,a9.canvas.height);a9.canvas.width=a7;a9.canvas.height=a7;var a5=function(bq,bm,bk,bo){var bn;bq.beginPath();bq.moveTo(bm*0.025,bk*0.055555);bq.lineTo(bm*0.9,bk*0.055555);bq.lineTo(bm*0.9,bk*0.944444);bq.lineTo(bm*0.025,bk*0.944444);bq.lineTo(bm*0.025,bk*0.055555);bq.closePath();bq.beginPath();bq.moveTo(bm*0.925,0);bq.lineTo(0,0);bq.lineTo(0,bk);bq.lineTo(bm*0.925,bk);bq.lineTo(bm*0.925,bk*0.722222);bq.bezierCurveTo(bm*0.925,bk*0.722222,bm*0.975,bk*0.722222,bm*0.975,bk*0.722222);bq.bezierCurveTo(bm,bk*0.722222,bm,bk*0.666666,bm,bk*0.666666);bq.bezierCurveTo(bm,bk*0.666666,bm,bk*0.333333,bm,bk*0.333333);bq.bezierCurveTo(bm,bk*0.333333,bm,bk*0.277777,bm*0.975,bk*0.277777);bq.bezierCurveTo(bm*0.975,bk*0.277777,bm*0.925,bk*0.277777,bm*0.925,bk*0.277777);bq.lineTo(bm*0.925,0);bq.closePath();bn=bq.createLinearGradient(0,0,0,bk);bn.addColorStop(0,"#ffffff");bn.addColorStop(1,"#7e7e7e");bq.fillStyle=bn;bq.fill();bq.beginPath();var bh=Math.max(bm*0.875*(bo/100),Math.ceil(bm*0.01));bq.rect(bm*0.025,bm*0.025,bh,bk*0.888888);bq.closePath();var bd=[0,0.4,1];var be=[new Q(177,25,2,1),new Q(219,167,21,1),new Q(121,162,75,1)];var bg=new M(0,100,bd,be);bq.fillStyle=bg.getColorAt(bo/100).getRgbColor();bq.fill();bq.beginPath();bh=Math.max(bh-bm*0.05,0);bq.rect(bm*0.05,bm*0.05,bh,bk*0.777777);bq.closePath();var bi=[new Q(198,39,5,1),new Q(228,189,32,1),new Q(163,216,102,1)];var bf=[new Q(246,121,48,1),new Q(246,244,157,1),new Q(223,233,86,1)];var bp=[0,0.4,1];var bl=new M(0,100,bp,bi);var bj=new M(0,100,bp,bf);bn=bq.createLinearGradient(bm*0.05,0,bm*0.875,0);bn.addColorStop(0,bl.getColorAt(bo/100).getRgbColor());bn.addColorStop(0.5,bj.getColorAt(bo/100).getRgbColor());bn.addColorStop(1,bl.getColorAt(bo/100).getRgbColor());bq.fillStyle=bn;bq.fill();bq.beginPath();bq.rect(bm*0.025,bm*0.025,bm*0.875,bk*0.444444);bq.closePath();bn=bq.createLinearGradient(bm*0.025,bm*0.025,bm*0.875,bk*0.444444);bn.addColorStop(0,"rgba(255, 255, 255, 0)");bn.addColorStop(1,"rgba(255, 255, 255, 0.8)");bq.fillStyle=bn;bq.fill()};this.setValue=function(bd){bd=(bd<0?0:(bd>100?100:bd));if(bc!==bd){bc=bd;this.repaint()}};this.getValue=function(){return bc};this.repaint=function(){a9.clearRect(0,0,a9.canvas.width,a9.canvas.height);a5(a9,a7,a6,bc)};this.repaint();return this};var ak=function(bj,bQ){bQ=bQ||{};var bi=(undefined===bQ.size?200:bQ.size);var a8=(undefined===bQ.frameDesign?steelseries.FrameDesign.METAL:bQ.frameDesign);var bD=(undefined===bQ.frameVisible?true:bQ.frameVisible);var bX=(undefined===bQ.pointerColor?steelseries.ColorDef.BLACK:bQ.pointerColor);var a6=(undefined===bQ.backgroundColor?steelseries.BackgroundColor.LIGHT_GRAY:bQ.backgroundColor);var bA=(undefined===bQ.backgroundVisible?true:bQ.backgroundVisible);var bV=(undefined===bQ.foregroundType?steelseries.ForegroundType.TYPE1:bQ.foregroundType);var bU=(undefined===bQ.foregroundVisible?true:bQ.foregroundVisible);var bZ=(undefined===bQ.customLayer?null:bQ.customLayer);var bH=0;var bR=0;var bv;var bb=6;var be=Math.PI*2;var bI=Math.PI/180;var bk=this;var bz=0;var br=0;var bJ=0;var bq=0;var by=0;var bC=false;var bF=false;var bP=H.getElementById(bj).getContext("2d");bP.save();bP.clearRect(0,0,bP.canvas.width,bP.canvas.height);bP.canvas.width=bi;bP.canvas.height=bi;var bY=bi;var bE=bi;var ba=bY/2;var a9=bE/2;var bu=0.285*bY;var bL=ba-bu/2;var bT=0.17*bY;var bo=false;var bp=P(bi,bi);var bf=bp.getContext("2d");var bG=P(bi,bi);var a5=bG.getContext("2d");var bx=P(bi,bi);var bc=bx.getContext("2d");var bM=P(bi,bi);var bh=bM.getContext("2d");var bd=P(bi,bi);var bg=bd.getContext("2d");var bm=P(bi,bi);var bO=bm.getContext("2d");var bt=P(bi,bi);var bl=bt.getContext("2d");var bK=P(bi,bi);var bw=bK.getContext("2d");var bW=function(co,cl,ch,cd,ci,cg,cj){var ce;co.width=co.height=cl;var cs=cd*cl;var b4=cs+"px sans-serif";var b9=cl*0.15;var b2=0.5;var cf=1;var cb=1.5;var b8=ci*cl;var ck=Math.round(0.025*cl);var b5=Math.round(0.035*cl);var cq=Math.round(0.045*cl);var cc=a6.labelColor.getRgbaColor();var cu=a6.labelColor.getRgbaColor();var ct=cl/2;var cn=cl*0.4;var ca=0;var b1=0;var cm=0;var b0=0;var cr=0;var b6;var b3=-Math.PI;var b7;var cp=(2*Math.PI)/(ch);co.save();co.textAlign="center";co.textBaseline="middle";co.font=b4;for(b6=b3,b7=0;b7<=ch+1;b6-=cp*0.1,b7+=0.1){co.lineWidth=b2;b0=Math.sin(b6);cr=Math.cos(b6);if(ca%2===0){innerPoint=[ct+(cn-ck)*b0+cg,ct+(cn-ck)*cr+cj];outerPoint=[ct+cn*b0+cg,ct+cn*cr+cj];co.strokeStyle=cu;co.beginPath();co.moveTo(innerPoint[0],innerPoint[1]);co.lineTo(outerPoint[0],outerPoint[1]);co.closePath();co.stroke()}if(ca===10||ca===0){co.fillStyle=cc;co.lineWidth=cf;outerPoint=[ct+cn*b0+cg,ct+cn*cr+cj];textPoint=[ct+(cn-b8)*b0+cg,ct+(cn-b8)*cr+cj];if(b1===5){if(b7!==ch){if(Math.round(b7)!==60){co.fillText(Math.round(b7),textPoint[0],textPoint[1],b9)}}co.lineWidth=cb;innerPoint=[ct+(cn-cq)*b0+cg,ct+(cn-cq)*cr+cj];b1=0}else{co.lineWidth=cf;innerPoint=[ct+(cn-b5)*b0+cg,ct+(cn-b5)*cr+cj]}co.strokeStyle=cu;co.beginPath();co.moveTo(innerPoint[0],innerPoint[1]);co.lineTo(outerPoint[0],outerPoint[1]);co.closePath();co.stroke();ca=0;cm++;b1++}ca++}co.restore()};var a7=function(b1,b3){var b2;b1.save();b1.beginPath();b1.moveTo(bY*0.509345,bY*0.457943);b1.lineTo(bY*0.5,bY*0.102803);b1.lineTo(bY*0.490654,bY*0.457943);b1.bezierCurveTo(bY*0.490654,bY*0.457943,bY*0.490654,bY*0.457943,bY*0.490654,bY*0.457943);b1.bezierCurveTo(bY*0.471962,bY*0.462616,bY*0.457943,bY*0.481308,bY*0.457943,bY*0.5);b1.bezierCurveTo(bY*0.457943,bY*0.518691,bY*0.471962,bY*0.537383,bY*0.490654,bY*0.542056);b1.bezierCurveTo(bY*0.490654,bY*0.542056,bY*0.490654,bY*0.542056,bY*0.490654,bY*0.542056);b1.lineTo(bY*0.490654,bY*0.621495);b1.lineTo(bY*0.509345,bY*0.621495);b1.lineTo(bY*0.509345,bY*0.542056);b1.bezierCurveTo(bY*0.509345,bY*0.542056,bY*0.509345,bY*0.542056,bY*0.509345,bY*0.542056);b1.bezierCurveTo(bY*0.528037,bY*0.537383,bY*0.542056,bY*0.518691,bY*0.542056,bY*0.5);b1.bezierCurveTo(bY*0.542056,bY*0.481308,bY*0.528037,bY*0.462616,bY*0.509345,bY*0.457943);b1.bezierCurveTo(bY*0.509345,bY*0.457943,bY*0.509345,bY*0.457943,bY*0.509345,bY*0.457943);b1.closePath();if(b3){b1.fillStyle="rgba(0, 0, 0, 0.5)";b1.strokeStyle="rgba(0, 0, 0, 0.5)";b1.fill()}else{b2=b1.createLinearGradient(0,0,0,bY*0.621495);b2.addColorStop(0,bX.medium.getRgbaColor());b2.addColorStop(0.388888,bX.medium.getRgbaColor());b2.addColorStop(0.5,bX.light.getRgbaColor());b2.addColorStop(0.611111,bX.medium.getRgbaColor());b2.addColorStop(1,bX.medium.getRgbaColor());b1.fillStyle=b2;b1.strokeStyle=bX.dark.getRgbaColor();b1.fill();b1.stroke()}if(!b3){b1.beginPath();var b0=bY*0.06542/2;b1.arc(ba,a9,b0,0,be);b2=b1.createLinearGradient(ba-b0,ba+b0,0,ba+b0);b2.addColorStop(0,"#e6b35c");b2.addColorStop(0.01,"#e6b35c");b2.addColorStop(0.99,"#c48200");b2.addColorStop(1,"#c48200");b1.fillStyle=b2;b1.closePath();b1.fill();b1.beginPath();b0=bY*0.046728/2;b1.arc(ba,a9,b0,0,be);b2=b1.createRadialGradient(ba,ba,0,ba,ba,b0);b2.addColorStop(0,"#c5c5c5");b2.addColorStop(0.19,"#c5c5c5");b2.addColorStop(0.22,"#000000");b2.addColorStop(0.8,"#000000");b2.addColorStop(0.99,"#707070");b2.addColorStop(1,"#707070");b1.fillStyle=b2;b1.closePath();b1.fill()}else{al(b1,bY,bE,Math.floor(bY*0.006))}b1.restore()};var bn=function(b1,b3){var b2;b1.save();b1.beginPath();b1.moveTo(bY*0.476635,bY*0.313084);b1.bezierCurveTo(bY*0.476635,bY*0.322429,bY*0.485981,bY*0.331775,bY*0.495327,bY*0.336448);b1.bezierCurveTo(bY*0.495327,bY*0.336448,bY*0.495327,bY*0.350467,bY*0.495327,bY*0.350467);b1.lineTo(bY*0.504672,bY*0.350467);b1.bezierCurveTo(bY*0.504672,bY*0.350467,bY*0.504672,bY*0.336448,bY*0.504672,bY*0.336448);b1.bezierCurveTo(bY*0.514018,bY*0.331775,bY*0.523364,bY*0.322429,bY*0.523364,bY*0.313084);b1.bezierCurveTo(bY*0.523364,bY*0.303738,bY*0.514018,bY*0.294392,bY*0.504672,bY*0.289719);b1.bezierCurveTo(bY*0.504672,bY*0.289719,bY*0.5,bY*0.200934,bY*0.5,bY*0.200934);b1.bezierCurveTo(bY*0.5,bY*0.200934,bY*0.495327,bY*0.289719,bY*0.495327,bY*0.289719);b1.bezierCurveTo(bY*0.485981,bY*0.294392,bY*0.476635,bY*0.303738,bY*0.476635,bY*0.313084);b1.closePath();if(b3){b1.fillStyle="rgba(0, 0, 0, 0.5)";b1.strokeStyle="rgba(0, 0, 0, 0.5)";b1.fill()}else{b2=b1.createLinearGradient(0,0,bY,0);b2.addColorStop(0,bX.medium.getRgbaColor());b2.addColorStop(0.388888,bX.medium.getRgbaColor());b2.addColorStop(0.5,bX.light.getRgbaColor());b2.addColorStop(0.611111,bX.medium.getRgbaColor());b2.addColorStop(1,bX.medium.getRgbaColor());b1.fillStyle=b2;b1.strokeStyle=bX.dark.getRgbaColor();b1.fill();b1.stroke()}if(!b3){b1.beginPath();var b0=bY*0.037383/2;b1.arc(ba,bT+bu/2,b0,0,be);b1.fillStyle="#C48200";b1.closePath();b1.fill();b1.beginPath();b0=bY*0.028037/2;b1.arc(ba,bT+bu/2,b0,0,be);b1.fillStyle="#999999";b1.closePath();b1.fill();b1.beginPath();b0=bY*0.018691/2;b1.arc(ba,bT+bu/2,b0,0,be);b1.fillStyle="#000000";b1.closePath();b1.fill()}else{al(b1,bY,bE,Math.floor(bY*0.006))}b1.restore()};var bB=function(){br=new Date().getTime()-bz;bR=(br*bb/1000);bH=(bR%10800)/30;bJ=(br/60000)%30;bq=(br/1000)%60;by=(br)%1000};var bN=function(b1){b1=b1||{};var b2=(undefined===b1.frame?false:b1.frame);var b3=(undefined===b1.background?false:b1.background);var b4=(undefined===b1.pointers?false:b1.pointers);var b0=(undefined===b1.foreground?false:b1.foreground);bo=true;if(b2&&bD){g(bf,a8,ba,a9,bY,bE)}if(b3&&bA){a2(a5,a6,ba,a9,bY,bE);W(a5,bZ,ba,a9,bY,bE);bW(a5,bY,60,0.075,0.1,0,0);bW(a5,bu,30,0.095,0.13,bL,bT)}if(b4){a7(bg,false);a7(bO,true);bn(bc,false);bn(bh,true)}if(b0&&bU){G(bw,bV,bY,bE,false)}};var bS=function(b1){b1=b1||{};var b2=(undefined===b1.frame?false:b1.frame);var b3=(undefined===b1.background?false:b1.background);var b4=(undefined===b1.pointers?false:b1.pointers);var b0=(undefined===b1.foreground?false:b1.foreground);if(b2){bp.width=bi;bp.height=bi;bf=bp.getContext("2d")}if(b3){bG.width=bi;bG.height=bi;a5=bG.getContext("2d")}if(b4){bx.width=bi;bx.height=bi;bc=bx.getContext("2d");bM.width=bi;bM.height=bi;bh=bM.getContext("2d");bd.width=bi;bd.height=bi;bg=bd.getContext("2d");bm.width=bi;bm.height=bi;bO=bm.getContext("2d");bt.width=bi;bt.height=bi;bl=bt.getContext("2d")}if(b0){bK.width=bi;bK.height=bi;bw=bK.getContext("2d")}};var bs=function(){if(!bF){bB();bk.repaint()}if(bC){bv=setTimeout(bs,200)}};this.isRunning=function(){return bC};this.start=function(){if(!bC){bC=true;bz=new Date().getTime()-br;bs()}};this.stop=function(){if(bC){bC=false;clearTimeout(bv)}if(bF){bF=false;bB();this.repaint()}};this.reset=function(){if(bC){bC=false;bF=false;clearTimeout(bv)}bz=new Date().getTime();bB();this.repaint()};this.lap=function(){if(bC&&!bF){bF=true}else{if(bF){bF=false}}};this.getMeasuredTime=function(){return(bJ+":"+bq+":"+by)};this.setFrameDesign=function(b0){bS({frame:true});a8=b0;bN({frame:true});this.repaint()};this.setBackgroundColor=function(b0){bS({background:true});a6=b0;bN({background:true});this.repaint()};this.setForegroundType=function(b0){bS({foreground:true});bV=b0;bN({foreground:true});this.repaint()};this.setPointerColor=function(b0){bS({pointers:true});bX=b0;bN({pointers:true});this.repaint()};this.repaint=function(){if(!bo){bN({frame:true,background:true,pointers:true,foreground:true})}bP.clearRect(0,0,bP.canvas.width,bP.canvas.height);if(bD){bP.drawImage(bp,0,0)}if(bA){bP.drawImage(bG,0,0)}var b0=bY*0.006;var b1=(bH+(2*Math.sin(bH*bI)))*bI;bl.clearRect(0,0,bY,bE);bl.save();bl.translate(ba,bT+bu/2);bl.rotate(b1);bl.translate(-ba,-(bT+bu/2));bl.drawImage(bM,0,0);bl.restore();bP.drawImage(bt,0,0,bY,bE,b0/2,b0/2,bY+b0/2,bE+b0/2);bP.save();bP.translate(ba,bT+bu/2);bP.rotate(b1);bP.translate(-ba,-(bT+bu/2));bP.drawImage(bx,0,0);bP.restore();b1=(bR+(2*Math.sin(bR*bI)))*bI;bl.clearRect(0,0,bY,bE);bl.save();bl.translate(ba,a9);bl.rotate(b1);bl.translate(-ba,-a9);bl.drawImage(bm,0,0);bl.restore();bP.drawImage(bt,0,0,bY,bE,b0,b0,bY+b0,bE+b0);bP.save();bP.translate(ba,a9);bP.rotate(b1);bP.translate(-ba,-a9);bP.drawImage(bd,0,0);bP.restore();if(bU){bP.drawImage(bK,0,0)}};bz=new Date().getTime();bs();return this};var a4=function(bj,bY){bY=bY||{};var bi=(undefined===bY.size?200:bY.size);var a9=(undefined===bY.frameDesign?steelseries.FrameDesign.METAL:bY.frameDesign);var bI=(undefined===bY.frameVisible?true:bY.frameVisible);var a6=(undefined===bY.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bY.backgroundColor);var bC=(undefined===bY.backgroundVisible?true:bY.backgroundVisible);var b6=(undefined===bY.knobType?steelseries.KnobType.METAL_KNOB:bY.knobType);var bJ=(undefined===bY.knobStyle?steelseries.KnobStyle.BLACK:bY.knobStyle);var bH=(undefined===bY.lcdColor?steelseries.LcdColor.BLACK:bY.lcdColor);var bS=(undefined===bY.lcdVisible?true:bY.lcdVisible);var bf=(undefined===bY.digitalFont?false:bY.digitalFont);var b2=(undefined===bY.foregroundType?steelseries.ForegroundType.TYPE1:bY.foregroundType);var b1=(undefined===bY.foregroundVisible?true:bY.foregroundVisible);var b8=(undefined===bY.customLayer?null:bY.customLayer);var bd=0;var br=10;var bQ=bd;var bU=0;var bt=0;var bq=0;var bn;var bM;var bp;var bV=1;var bu;var bX=H.getElementById(bj).getContext("2d");bX.save();bX.clearRect(0,0,bX.canvas.width,bX.canvas.height);bX.canvas.width=bi;bX.canvas.height=bi;var b7=bi;var bK=bi;var bb=b7/2;var ba=bK/2;var bG=Math.floor(b7*0.09)+"px sans-serif";var bR=Math.PI/2;var bP=Math.PI/180;var bz=Math.PI;var bo=false;var bs=P(bi,bi);var be=bs.getContext("2d");var bN=P(bi,bi);var a5=bN.getContext("2d");var b4;var bh=P(bi,bi);var bL=bh.getContext("2d");var bc=P(bi,bi);var b0=bc.getContext("2d");var bx=P(bi,bi);var a7=bx.getContext("2d");var bF=P(bi,bi);var bB=bF.getContext("2d");var bk=P(bi,bi);var bl=bk.getContext("2d");var bE=P(bi,bi);var b5=bE.getContext("2d");var bw=P(bi,bi);var bm=bw.getContext("2d");var bT=P(bi,bi);var by=bT.getContext("2d");var bv=function(b9){bX.save();bX.textAlign="right";bX.textBaseline="middle";bX.strokeStyle=bH.textColor;bX.fillStyle=bH.textColor;if(bH===steelseries.LcdColor.STANDARD||bH===steelseries.LcdColor.STANDARD_GREEN){bX.shadowColor="gray";bX.shadowOffsetX=b7*0.007;bX.shadowOffsetY=b7*0.007;bX.shadowBlur=b7*0.009}if(bf){bX.font=Math.floor(b7*0.075)+"px "+aM}else{bX.font=Math.floor(b7*0.075)+"px sans-serif"}bX.fillText(Math.round(b9),(b7+(b7*0.4))/2-4,b7*0.607,b7*0.4);bX.restore()};var b3=function(cp,cv,cf,ct,ch,cl,cr,ck,ca,cn){var cm=Math.max(b7*0.012,2);var cb=Math.max(b7*0.007,1.5);var ci=b7*0.13;var cd=b7*0.05;var cs=b7*0.07;var cq=b7*0.4;var cj=0;var co=0;var b9=0;var cu=0;var ce;var cg;var cc=-cf-(cv/2);cp.save();cp.textAlign="center";cp.textBaseline="middle";cp.font=bG;cp.strokeStyle=a6.labelColor.getRgbaColor();cp.fillStyle=a6.labelColor.getRgbaColor();for(ce=cc,cg=0;cg<=10;ce-=cl*0.1,cg+=0.1){b9=Math.sin(ce);cu=Math.cos(ce);if(cj%2===0){cp.lineWidth=cb;cp.beginPath();cp.moveTo(bb+(cq-cd)*b9,ba+(cq-cd)*cu);cp.lineTo(bb+cq*b9,ba+cq*cu);cp.closePath();cp.stroke()}if(cj===10||cj===0){cp.lineWidth=cm;if(cv===0){if(Math.round(cg)!=br){cp.fillText(Math.round(cg).toString(),bb+(cq-ci)*b9,ba+(cq-ci)*cu)}}cj=0;co++;cp.beginPath();cp.moveTo(bb+(cq-cs)*b9,ba+(cq-cs)*cu);cp.lineTo(bb+cq*b9,ba+cq*cu);cp.closePath();cp.stroke()}cj++}cp.restore()};var bg=function(b9,cb){var ca;if(cb){b9.fillStyle="rgba(0, 0, 0, 0.5)";b9.strokeStyle="rgba(0, 0, 0, 0.5)"}else{ca=b9.createLinearGradient(0,bK*0.168224,0,bK*0.626168);ca.addColorStop(0,"#ffffff");ca.addColorStop(0.31,"#ffffff");ca.addColorStop(0.3101,"#ffffff");ca.addColorStop(0.32,"#202020");ca.addColorStop(1,"#202020");b9.fillStyle=ca}b9.save();b9.beginPath();b9.moveTo(b7*0.518691,bK*0.471962);b9.bezierCurveTo(b7*0.514018,bK*0.471962,b7*0.509345,bK*0.467289,b7*0.509345,bK*0.467289);b9.lineTo(b7*0.509345,bK*0.200934);b9.lineTo(b7*0.5,bK*0.168224);b9.lineTo(b7*0.490654,bK*0.200934);b9.lineTo(b7*0.490654,bK*0.467289);b9.bezierCurveTo(b7*0.490654,bK*0.467289,b7*0.481308,bK*0.471962,b7*0.481308,bK*0.471962);b9.bezierCurveTo(b7*0.471962,bK*0.481308,b7*0.467289,bK*0.490654,b7*0.467289,bK*0.5);b9.bezierCurveTo(b7*0.467289,bK*0.514018,b7*0.476635,bK*0.528037,b7*0.490654,bK*0.53271);b9.bezierCurveTo(b7*0.490654,bK*0.53271,b7*0.490654,bK*0.579439,b7*0.490654,bK*0.588785);b9.bezierCurveTo(b7*0.485981,bK*0.593457,b7*0.481308,bK*0.59813,b7*0.481308,bK*0.607476);b9.bezierCurveTo(b7*0.481308,bK*0.616822,b7*0.490654,bK*0.626168,b7*0.5,bK*0.626168);b9.bezierCurveTo(b7*0.509345,bK*0.626168,b7*0.518691,bK*0.616822,b7*0.518691,bK*0.607476);b9.bezierCurveTo(b7*0.518691,bK*0.59813,b7*0.514018,bK*0.593457,b7*0.504672,bK*0.588785);b9.bezierCurveTo(b7*0.504672,bK*0.579439,b7*0.504672,bK*0.53271,b7*0.509345,bK*0.53271);b9.bezierCurveTo(b7*0.523364,bK*0.528037,b7*0.53271,bK*0.514018,b7*0.53271,bK*0.5);b9.bezierCurveTo(b7*0.53271,bK*0.490654,b7*0.528037,bK*0.481308,b7*0.518691,bK*0.471962);b9.closePath();b9.fill();if(cb){al(b9,b7,bK,Math.floor(b7*0.006))}b9.restore()};var bA=function(b9,cb){var ca;if(cb){b9.fillStyle="rgba(0, 0, 0, 0.5)";b9.strokeStyle="rgba(0, 0, 0, 0.5)"}else{ca=b9.createLinearGradient(0,bK*0.401869,0,bK*0.616822);ca.addColorStop(0,"#ffffff");ca.addColorStop(0.51,"#ffffff");ca.addColorStop(0.52,"#ffffff");ca.addColorStop(0.5201,"#202020");ca.addColorStop(0.53,"#202020");ca.addColorStop(1,"#202020");b9.fillStyle=ca}b9.beginPath();b9.moveTo(b7*0.518691,bK*0.471962);b9.bezierCurveTo(b7*0.514018,bK*0.462616,b7*0.528037,bK*0.401869,b7*0.528037,bK*0.401869);b9.lineTo(b7*0.5,bK*0.331775);b9.lineTo(b7*0.471962,bK*0.401869);b9.bezierCurveTo(b7*0.471962,bK*0.401869,b7*0.485981,bK*0.462616,b7*0.481308,bK*0.471962);b9.bezierCurveTo(b7*0.471962,bK*0.481308,b7*0.467289,bK*0.490654,b7*0.467289,bK*0.5);b9.bezierCurveTo(b7*0.467289,bK*0.514018,b7*0.476635,bK*0.528037,b7*0.490654,bK*0.53271);b9.bezierCurveTo(b7*0.490654,bK*0.53271,b7*0.462616,bK*0.574766,b7*0.462616,bK*0.593457);b9.bezierCurveTo(b7*0.467289,bK*0.616822,b7*0.5,bK*0.612149,b7*0.5,bK*0.612149);b9.bezierCurveTo(b7*0.5,bK*0.612149,b7*0.53271,bK*0.616822,b7*0.537383,bK*0.593457);b9.bezierCurveTo(b7*0.537383,bK*0.574766,b7*0.509345,bK*0.53271,b7*0.509345,bK*0.53271);b9.bezierCurveTo(b7*0.523364,bK*0.528037,b7*0.53271,bK*0.514018,b7*0.53271,bK*0.5);b9.bezierCurveTo(b7*0.53271,bK*0.490654,b7*0.528037,bK*0.481308,b7*0.518691,bK*0.471962);b9.closePath();b9.fill();if(cb){al(b9,b7,bK,Math.floor(b7*0.006))}b9.restore()};var bO=function(b9,ca){if(ca){b9.fillStyle="rgba(0, 0, 0, 0.5)";b9.strokeStyle="rgba(0, 0, 0, 0.5)"}else{b9.fillStyle="#ffffff"}b9.beginPath();b9.moveTo(b7*0.518691,bK*0.471962);b9.bezierCurveTo(b7*0.514018,bK*0.471962,b7*0.514018,bK*0.467289,b7*0.514018,bK*0.467289);b9.lineTo(b7*0.514018,bK*0.317757);b9.lineTo(b7*0.504672,bK*0.303738);b9.lineTo(b7*0.504672,bK*0.182242);b9.lineTo(b7*0.53271,bK*0.116822);b9.lineTo(b7*0.462616,bK*0.116822);b9.lineTo(b7*0.495327,bK*0.182242);b9.lineTo(b7*0.495327,bK*0.299065);b9.lineTo(b7*0.485981,bK*0.317757);b9.lineTo(b7*0.485981,bK*0.467289);b9.bezierCurveTo(b7*0.485981,bK*0.467289,b7*0.485981,bK*0.471962,b7*0.481308,bK*0.471962);b9.bezierCurveTo(b7*0.471962,bK*0.481308,b7*0.467289,bK*0.490654,b7*0.467289,bK*0.5);b9.bezierCurveTo(b7*0.467289,bK*0.518691,b7*0.481308,bK*0.53271,b7*0.5,bK*0.53271);b9.bezierCurveTo(b7*0.518691,bK*0.53271,b7*0.53271,bK*0.518691,b7*0.53271,bK*0.5);b9.bezierCurveTo(b7*0.53271,bK*0.490654,b7*0.528037,bK*0.481308,b7*0.518691,bK*0.471962);b9.closePath();b9.fill();if(ca){al(b9,b7,bK,Math.floor(b7*0.006))}};function bD(){bn=(2*Math.PI)/(br-bd);bM=bn/10;bp=bM/10}function a8(){bU=(bQ%1000)/100;bt=(bQ%10000)/100;bq=(bQ%100000)/100}var bW=function(ca){ca=ca||{};var cb=(undefined===ca.frame?false:ca.frame);var cc=(undefined===ca.background?false:ca.background);var cd=(undefined===ca.pointers?false:ca.pointers);var b9=(undefined===ca.foreground?false:ca.foreground);bo=true;bD();if(cb&&bI){g(be,a9,bb,ba,b7,bK)}if(cc&&bC){a2(a5,a6,bb,ba,b7,bK);W(a5,b8,bb,ba,b7,bK);b3(a5,0,bz,0,10,bn,bV,0,true,true,null)}if(cc&&bS){b4=ab(b7*0.4,bK*0.09,bH);a5.drawImage(b4,(b7-(b7*0.4))/2,bK*0.56)}if(cd){bg(bl,false);bg(b5,true);bA(a7,false);bA(bB,true);bO(bL,false);bO(b0,true)}if(b9&&b1){G(by,b2,b7,bK,true,b6,bJ)}};var bZ=function(ca){ca=ca||{};var cb=(undefined===ca.frame?false:ca.frame);var cc=(undefined===ca.background?false:ca.background);var cd=(undefined===ca.pointers?false:ca.pointers);var b9=(undefined===ca.foreground?false:ca.foreground);if(cb){bs.width=bi;bs.height=bi;be=bs.getContext("2d")}if(cc){bN.width=bi;bN.height=bi;a5=bN.getContext("2d")}if(cd){pointer100ftBuffer.width=bi;pointer100ftBuffer.height=bi;pointer100ftContext=pointer100ftBuffer.getContext("2d");pointer100ftShadowBuffer.width=bi;pointer100ftShadowBuffer.height=bi;pointer100ftShadowContext=pointer100ftShadowBuffer.getContext("2d");pointer1000ftBuffer.width=bi;pointer1000ftBuffer.height=bi;pointer1000ftContext=pointer1000ftBuffer.getContext("2d");pointer1000ftShadowBuffer.width=bi;pointer1000ftShadowBuffer.height=bi;pointer1000ftShadowContext=pointer1000ftShadowBuffer.getContext("2d");pointer10000ftBuffer.width=bi;pointer10000ftBuffer.height=bi;pointer10000ftContext=pointer10000ftBuffer.getContext("2d");pointer10000ftShadowBuffer.width=bi;pointer10000ftShadowBuffer.height=bi;pointer10000ftShadowContext=pointer10000ftShadowBuffer.getContext("2d");bw.width=bi;bw.height=bi;bm=bw.getContext("2d")}if(b9){bT.width=bi;bT.height=bi;by=bT.getContext("2d")}};this.setValue=function(b9){bQ=b9;this.repaint()};this.getValue=function(){return bQ};this.setValueAnimated=function(cc){var b9=(cc<bd?bd:cc);if(bQ!==b9){if(undefined!==bu){if(bu.playing){bu.stop()}}var cb=Math.max(Math.abs(bQ-b9)/10000*5,1);bu=new Tween({},"",Tween.regularEaseInOut,bQ,b9,cb);var ca=this;bu.onMotionChanged=function(cd){bQ=cd.target._pos;ca.repaint()};bu.start()}};this.setFrameDesign=function(b9){bZ({frame:true});a9=b9;bW({frame:true});this.repaint()};this.setBackgroundColor=function(b9){bZ({background:true,pointer:true});a6=b9;bW({background:true,pointer:true});this.repaint()};this.setForegroundType=function(b9){bZ({foreground:true});b2=b9;bW({foreground:true});this.repaint()};this.setLcdColor=function(b9){bH=b9;bW({background:true});this.repaint()};this.repaint=function(){if(!bo){bW({frame:true,background:true,led:true,pointers:true,foreground:true})}bX.clearRect(0,0,bX.canvas.width,bX.canvas.height);if(bI){bX.drawImage(bs,0,0)}bX.drawImage(bN,0,0);if(bS){bv(bQ)}a8();var b9=b7*0.006*0.5;bm.clearRect(0,0,b7,bK);bm.save();bm.translate(bb,ba);bm.rotate((bq-bd)*bp);bm.translate(-bb,-ba);bm.drawImage(bc,0,0);bm.restore();bX.drawImage(bw,0,0,b7,bK,b9,b9,b7+b9,bK+b9);bX.save();bX.translate(bb,ba);bX.rotate((bq-bd)*bp);bX.translate(-bb,-ba);bX.drawImage(bh,0,0);bX.restore();bm.clearRect(0,0,b7,bK);bm.save();bm.translate(bb,ba);bm.rotate((bt-bd)*bM);bm.translate(-bb,-ba);bm.drawImage(bF,0,0);bm.restore();bX.drawImage(bw,0,0,b7,bK,b9,b9,b7+b9,bK+b9);b9=b7*0.006*0.75;bX.save();bX.translate(bb,ba);bX.rotate((bt-bd)*bM);bX.translate(-bb,-ba);bX.drawImage(bx,0,0);bX.restore();b9=b7*0.006;bm.clearRect(0,0,b7,bK);bm.save();bm.translate(bb,ba);bm.rotate((bU-bd)*bn);bm.translate(-bb,-ba);bm.drawImage(bE,0,0);bm.restore();bX.drawImage(bw,0,0,b7,bK,b9,b9,b7+b9,bK+b9);bX.save();bX.translate(bb,ba);bX.rotate((bU-bd)*bn);bX.translate(-bb,-ba);bX.drawImage(bk,0,0);bX.restore();if(b1){bX.drawImage(bT,0,0)}};this.repaint();return this};var aO=function(ba,bK){bK=bK||{};var a5=(undefined===bK.width?98:bK.width);var a6=(undefined===bK.height?278:bK.height);var bJ=H.getElementById(ba).getContext("2d");bJ.save();bJ.clearRect(0,0,bJ.canvas.width,bJ.canvas.height);bJ.canvas.width=a5;bJ.canvas.height=a6;var bo=a5<(a6*0.352517)?(a5*2.836734):a6;var bN=bo*0.352517;var by=bo;var bB=false;var bD=false;var bd=false;var bc=false;var bb=H.createElement("canvas");bb.width=bN;bb.height=by;var bG=bb.getContext("2d");var bi=H.createElement("canvas");bi.width=bN;bi.height=by;var bI=bi.getContext("2d");var bM=H.createElement("canvas");bM.width=bN;bM.height=by;var br=bM.getContext("2d");var be=H.createElement("canvas");be.width=bN;be.height=by;var bA=be.getContext("2d");var bx=H.createElement("canvas");bx.width=bN;bx.height=by;var bF=bx.getContext("2d");var bs=H.createElement("canvas");bs.width=bN;bs.height=by;var bw=bs.getContext("2d");var bv=H.createElement("canvas");bv.width=bN;bv.height=by;var bt=bv.getContext("2d");var bk=H.createElement("canvas");bk.width=bN;bk.height=by;var a8=bk.getContext("2d");var bC=H.createElement("canvas");bC.width=bN;bC.height=by;var bm=bC.getContext("2d");var a7=H.createElement("canvas");a7.width=bN;a7.height=by;var bu=a7.getContext("2d");var bp=function(bO){bO.save();bO.save();bO.beginPath();bO.moveTo(0.107142*bN,0);bO.lineTo(bN-0.107142*bN,0);bO.quadraticCurveTo(bN,0,bN,0.107142*bN);bO.lineTo(bN,by-0.107142*bN);bO.quadraticCurveTo(bN,by,bN-0.107142*bN,by);bO.lineTo(0.107142*bN,by);bO.quadraticCurveTo(0,by,0,by-0.107142*bN);bO.lineTo(0,0.107142*bN);bO.quadraticCurveTo(0,0,0.107142*bN,by);bO.closePath();var bP=bO.createLinearGradient(0.040816*bN,0.007194*by,0.952101*bN,0.995882*by);bP.addColorStop(0,"rgb(152, 152, 154)");bP.addColorStop(0.01,"rgb(152, 152, 154)");bP.addColorStop(0.09,"#333333");bP.addColorStop(0.24,"rgb(152, 152, 154)");bP.addColorStop(0.55,"rgb(31, 31, 31)");bP.addColorStop(0.78,"#363636");bP.addColorStop(0.98,"#000000");bP.addColorStop(1,"#000000");bO.fillStyle=bP;bO.fill();bO.restore();bO.save();bO.beginPath();bO.moveTo(0.030612*bN+0.084183*bN,0.010791*by);bO.lineTo(0.030612*bN+0.938775*bN-0.084183*bN,0.010791*by);bO.quadraticCurveTo(0.030612*bN+0.938775*bN,0.010791*by,0.030612*bN+0.938775*bN,0.010791*by+0.084183*bN);bO.lineTo(0.030612*bN+0.938775*bN,0.010791*by+0.978417*by-0.084183*bN);bO.quadraticCurveTo(0.030612*bN+0.938775*bN,0.010791*by+0.978417*by,0.030612*bN+0.938775*bN-0.084183*bN,0.010791*by+0.978417*by);bO.lineTo(0.030612*bN+0.084183*bN,0.010791*by+0.978417*by);bO.quadraticCurveTo(0.030612*bN,0.010791*by+0.978417*by,0.030612*bN,0.010791*by+0.978417*by-0.084183*bN);bO.lineTo(0.030612*bN,0.010791*by+0.084183*bN);bO.quadraticCurveTo(0.030612*bN,0.010791*by,0.030612*bN+0.084183*bN,0.010791*by);bO.closePath();var bQ=bO.createLinearGradient(-0.132653*bN,-0.053956*by,2.061408*bN,0.667293*by);bQ.addColorStop(0,"#000000");bQ.addColorStop(0.01,"#000000");bQ.addColorStop(0.16,"#373735");bQ.addColorStop(0.31,"#000000");bQ.addColorStop(0.44,"#303030");bQ.addColorStop(0.65,"#000000");bQ.addColorStop(0.87,"#363636");bQ.addColorStop(0.98,"#000000");bQ.addColorStop(1,"#000000");bO.fillStyle=bQ;bO.fill();bO.restore();bO.restore()};var bg=function(bQ){bQ.save();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.805755*by,0.397959*bN,0,2*Math.PI,false);var bS=bQ.createLinearGradient(0,0.665467*by,0,0.946043*by);bS.addColorStop(0,"#ffffff");bS.addColorStop(0.05,"rgb(204, 204, 204)");bS.addColorStop(0.1,"rgb(153, 153, 153)");bS.addColorStop(0.17,"#666666");bS.addColorStop(0.27,"#333333");bS.addColorStop(1,"#010101");bQ.fillStyle=bS;bQ.fill();bQ.restore();bQ.save();bQ.scale(1.083333,1);bQ.beginPath();bQ.arc(0.461538*bN,0.816546*by,0.367346*bN,0,2*Math.PI,false);var bP=bQ.createLinearGradient(0,0.68705*by,0,0.946043*by);bP.addColorStop(0,"#000000");bP.addColorStop(0.35,"#040404");bP.addColorStop(0.66,"#000000");bP.addColorStop(1,"#010101");bQ.fillStyle=bP;bQ.fill();bQ.restore();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.809352*by,0.357142*bN,0,2*Math.PI,false);var bO=bQ.createRadialGradient(0.5*bN,0.809352*by,0,0.5*bN,0.809352*by,0.362244*bN);bO.addColorStop(0,"#000000");bO.addColorStop(0.88,"#000000");bO.addColorStop(0.95,"rgb(94, 94, 94)");bO.addColorStop(1,"#010101");bQ.fillStyle=bO;bQ.fill();bQ.restore();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.809352*by,0.357142*bN,0,2*Math.PI,false);var bR=bQ.createLinearGradient(0,0.68705*by,0,0.917266*by);bR.addColorStop(0,"#000000");bR.addColorStop(1,"rgba(1, 1, 1, 0)");bQ.fillStyle=bR;bQ.fill();bQ.restore();bQ.restore()};var a9=function(bP){bP.save();bP.save();bP.scale(1,1);bP.beginPath();bP.arc(0.5*bN,0.809352*by,0.32653*bN,0,2*Math.PI,false);var bQ=bP.createRadialGradient(0.5*bN,0.809352*by,0,0.5*bN,0.809352*by,0.32653*bN);bQ.addColorStop(0,"rgb(85, 185, 123)");bQ.addColorStop(1,"rgb(0, 31, 0)");bP.fillStyle=bQ;bP.fill();bP.restore();bP.save();bP.beginPath();bP.moveTo(0,0.812949*by);bP.bezierCurveTo(0,0.910071*by,0.224489*bN,0.989208*by,0.5*bN,0.989208*by);bP.bezierCurveTo(0.77551*bN,0.989208*by,bN,0.910071*by,bN,0.809352*by);bP.bezierCurveTo(0.908163*bN,0.751798*by,0.704081*bN,0.68705*by,0.5*bN,0.68705*by);bP.bezierCurveTo(0.285714*bN,0.68705*by,0.081632*bN,0.751798*by,0,0.812949*by);bP.closePath();var bO=bP.createRadialGradient(0.5*bN,0.809352*by,0,0.5*bN,0.809352*by,0.515306*bN);bO.addColorStop(0,"rgb(65, 187, 126)");bO.addColorStop(1,"rgba(4, 37, 8, 0)");bP.fillStyle=bO;bP.fill();bP.restore();bP.restore()};var bn=function(bO){bO.save();bO.save();bO.scale(1,1);bO.beginPath();bO.arc(0.5*bN,0.809352*by,0.32653*bN,0,2*Math.PI,false);var bP=bO.createRadialGradient(0.5*bN,0.809352*by,0,0.5*bN,0.809352*by,0.32653*bN);bP.addColorStop(0,"rgba(0, 255, 0, 0.25)");bP.addColorStop(1,"rgba(0, 255, 0, 0.05)");bO.fillStyle=bP;bO.fill();bO.restore();bO.save();bO.scale(1,1);bO.beginPath();bO.arc(0.5*bN,0.809352*by,0.32653*bN,0,2*Math.PI,false);var bQ=bO.createRadialGradient(0.5*bN,0.809352*by,0,0.5*bN,0.809352*by,0.32653*bN);bQ.addColorStop(0,"rgba(1, 1, 1, 0)");bQ.addColorStop(0.55,"rgba(0, 0, 0, 0)");bQ.addColorStop(0.5501,"rgba(0, 0, 0, 0)");bQ.addColorStop(0.78,"rgba(0, 0, 0, 0.12)");bQ.addColorStop(0.79,"rgba(0, 0, 0, 0.12)");bQ.addColorStop(1,"rgba(0, 0, 0, 0.5)");bO.fillStyle=bQ;bO.fill();bO.restore();bO.fillStyle=bO.createPattern(bL,"repeat");bO.fill();bO.restore()};var bh=function(bQ){bQ.save();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.496402*by,0.397959*bN,0,2*Math.PI,false);var bP=bQ.createLinearGradient(0,0.356115*by,0,0.63669*by);bP.addColorStop(0,"#ffffff");bP.addColorStop(0.05,"rgb(204, 204, 204)");bP.addColorStop(0.1,"rgb(153, 153, 153)");bP.addColorStop(0.17,"#666666");bP.addColorStop(0.27,"#333333");bP.addColorStop(1,"#010101");bQ.fillStyle=bP;bQ.fill();bQ.restore();bQ.save();bQ.scale(1.083333,1);bQ.beginPath();bQ.arc(0.461538*bN,0.507194*by,0.367346*bN,0,2*Math.PI,false);var bO=bQ.createLinearGradient(0,0.377697*by,0,0.63669*by);bO.addColorStop(0,"#000000");bO.addColorStop(0.35,"#040404");bO.addColorStop(0.66,"#000000");bO.addColorStop(1,"#010101");bQ.fillStyle=bO;bQ.fill();bQ.restore();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.5*by,0.357142*bN,0,2*Math.PI,false);var bS=bQ.createRadialGradient(0.5*bN,0.5*by,0,0.5*bN,0.5*by,0.362244*bN);bS.addColorStop(0,"#000000");bS.addColorStop(0.88,"#000000");bS.addColorStop(0.95,"#5e5e5e");bS.addColorStop(1,"#010101");bQ.fillStyle=bS;bQ.fill();bQ.restore();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.5*by,0.357142*bN,0,2*Math.PI,false);var bR=bQ.createLinearGradient(0,0.377697*by,0,0.607913*by);bR.addColorStop(0,"#000000");bR.addColorStop(1,"rgba(1, 1, 1, 0)");bQ.fillStyle=bR;bQ.fill();bQ.restore();bQ.restore()};var bE=function(bO){bO.save();bO.save();bO.scale(1,1);bO.beginPath();bO.arc(0.5*bN,0.5*by,0.32653*bN,0,2*Math.PI,false);var bP=bO.createRadialGradient(0.5*bN,0.5*by,0,0.5*bN,0.5*by,0.32653*bN);bP.addColorStop(0,"#fed434");bP.addColorStop(1,"#82330c");bO.fillStyle=bP;bO.fill();bO.restore();bO.save();bO.beginPath();bO.moveTo(0,0.503597*by);bO.bezierCurveTo(0,0.600719*by,0.224489*bN,0.679856*by,0.5*bN,0.679856*by);bO.bezierCurveTo(0.77551*bN,0.679856*by,bN,0.600719*by,bN,0.5*by);bO.bezierCurveTo(0.908163*bN,0.442446*by,0.704081*bN,0.377697*by,0.5*bN,0.377697*by);bO.bezierCurveTo(0.285714*bN,0.377697*by,0.081632*bN,0.442446*by,0,0.503597*by);bO.closePath();var bQ=bO.createRadialGradient(0.5*bN,0.5*by,0,0.5*bN,0.5*by,0.515306*bN);bQ.addColorStop(0,"#fed434");bQ.addColorStop(1,"rgba(130, 51, 12, 0)");bO.fillStyle=bQ;bO.fill();bO.restore();bO.restore()};var bj=function(bO){bO.save();bO.save();bO.scale(1,1);bO.beginPath();bO.arc(0.5*bN,0.5*by,0.32653*bN,0,2*Math.PI,false);var bQ=bO.createRadialGradient(0.5*bN,0.5*by,0,0.5*bN,0.5*by,0.32653*bN);bQ.addColorStop(0,"rgba(255, 255, 0, 0.25)");bQ.addColorStop(1,"rgba(255, 255, 0, 0.05)");bO.fillStyle=bQ;bO.fill();bO.restore();bO.save();bO.scale(1,1);bO.beginPath();bO.arc(0.5*bN,0.5*by,0.32653*bN,0,2*Math.PI,false);var bP=bO.createRadialGradient(0.5*bN,0.5*by,0,0.5*bN,0.5*by,0.32653*bN);bP.addColorStop(0,"rgba(1, 1, 1, 0)");bP.addColorStop(0.55,"rgba(0, 0, 0, 0)");bP.addColorStop(0.5501,"rgba(0, 0, 0, 0)");bP.addColorStop(0.78,"rgba(0, 0, 0, 0.12)");bP.addColorStop(0.79,"rgba(0, 0, 0, 0.13)");bP.addColorStop(1,"rgba(0, 0, 0, 0.5)");bO.fillStyle=bP;bO.fill();bO.restore();bO.fillStyle=bO.createPattern(bL,"repeat");bO.fill();bO.restore()};var bq=function(bQ){bQ.save();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.18705*by,0.397959*bN,0,2*Math.PI,false);var bS=bQ.createLinearGradient((0.5*bN),(0.046762*by),((0.5)*bN),((0.327338)*by));bS.addColorStop(0,"#ffffff");bS.addColorStop(0.05,"#cccccc");bS.addColorStop(0.1,"#999999");bS.addColorStop(0.17,"#666666");bS.addColorStop(0.27,"#333333");bS.addColorStop(1,"#010101");bQ.fillStyle=bS;bQ.fill();bQ.restore();bQ.save();bQ.scale(1.083333,1);bQ.beginPath();bQ.arc(0.461538*bN,0.197841*by,0.367346*bN,0,2*Math.PI,false);var bP=bQ.createLinearGradient((0.5*bN),(0.068345*by),((0.5)*bN),((0.327338)*by));bP.addColorStop(0,"#000000");bP.addColorStop(0.35,"#040404");bP.addColorStop(0.66,"#000000");bP.addColorStop(1,"#010101");bQ.fillStyle=bP;bQ.fill();bQ.restore();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.190647*by,0.357142*bN,0,2*Math.PI,false);var bR=bQ.createRadialGradient((0.5)*bN,((0.190647)*by),0,((0.5)*bN),((0.190647)*by),0.362244*bN);bR.addColorStop(0,"#000000");bR.addColorStop(0.88,"#000000");bR.addColorStop(0.95,"#5e5e5e");bR.addColorStop(1,"#010101");bQ.fillStyle=bR;bQ.fill();bQ.restore();bQ.save();bQ.scale(1,1);bQ.beginPath();bQ.arc(0.5*bN,0.190647*by,0.357142*bN,0,2*Math.PI,false);var bO=bQ.createLinearGradient((0.5*bN),(0.068345*by),((0.5)*bN),((0.298561)*by));bO.addColorStop(0,"#000000");bO.addColorStop(1,"rgba(1, 1, 1, 0)");bQ.fillStyle=bO;bQ.fill();bQ.restore();bQ.restore()};var bz=function(bO){bO.save();bO.save();bO.scale(1,1);bO.beginPath();bO.arc(0.5*bN,0.190647*by,0.32653*bN,0,2*Math.PI,false);var bQ=bO.createRadialGradient(0.5*bN,0.190647*by,0,0.5*bN,0.190647*by,0.32653*bN);bQ.addColorStop(0,"#ff0000");bQ.addColorStop(1,"#410004");bO.fillStyle=bQ;bO.fill();bO.restore();bO.save();bO.beginPath();bO.moveTo(0,0.194244*by);bO.bezierCurveTo(0,0.291366*by,0.224489*bN,0.370503*by,0.5*bN,0.370503*by);bO.bezierCurveTo(0.77551*bN,0.370503*by,bN,0.291366*by,bN,0.190647*by);bO.bezierCurveTo(0.908163*bN,0.133093*by,0.704081*bN,0.068345*by,0.5*bN,0.068345*by);bO.bezierCurveTo(0.285714*bN,0.068345*by,0.081632*bN,0.133093*by,0,0.194244*by);bO.closePath();var bP=bO.createRadialGradient(0.5*bN,0.190647*by,0,0.5*bN,0.190647*by,0.515306*bN);bP.addColorStop(0,"#ff0000");bP.addColorStop(1,"rgba(118, 5, 1, 0)");bO.fillStyle=bP;bO.fill();bO.restore();bO.restore()};var bl=function(bP){bP.save();bP.save();bP.scale(1,1);bP.beginPath();bP.arc(0.5*bN,0.190647*by,0.32653*bN,0,2*Math.PI,false);var bO=bP.createRadialGradient(0.5*bN,0.190647*by,0,0.5*bN,0.190647*by,0.32653*bN);bO.addColorStop(0,"rgba(255, 0, 0, 0.25)");bO.addColorStop(1,"rgba(255, 0, 0, 0.05)");bP.fillStyle=bO;bP.fill();bP.restore();bP.save();bP.scale(1,1);bP.beginPath();bP.arc(0.5*bN,0.190647*by,0.32653*bN,0,2*Math.PI,false);var bQ=bP.createRadialGradient(0.5*bN,0.190647*by,0,0.5*bN,0.190647*by,0.32653*bN);bQ.addColorStop(0,"rgba(1, 1, 1, 0)");bQ.addColorStop(0.55,"rgba(0, 0, 0, 0)");bQ.addColorStop(0.5501,"rgba(0, 0, 0, 0)");bQ.addColorStop(0.78,"rgba(0, 0, 0, 0.12)");bQ.addColorStop(0.79,"rgba(0, 0, 0, 0.13)");bQ.addColorStop(1,"rgba(0, 0, 0, 0.5)");bP.fillStyle=bQ;bP.fill();bP.restore();bP.fillStyle=bP.createPattern(bL,"repeat");bP.fill();bP.restore()};var bL=bf(2,2,function(bO){bO.save();bO.strokeStyle="rgba(0, 0, 0, 0.1)";bO.beginPath();bO.lineTo(0,0,1,0);bO.lineTo(0,1,0,1);bO.stroke();bO.restore()});function bf(bQ,bO,bR){var bP=H.createElement("canvas");bP.width=bQ;bP.height=bO;bR(bP.getContext("2d"));return bP}var bH=function(){bc=true;bp(bG);bg(bI);a9(br);bn(bA);bh(bF);bE(bw);bj(bt);bq(a8);bz(bm);bl(bu)};this.setRedOn=function(bO){bB=bO;this.repaint()};this.isRedOn=function(){return bB};this.setYellowOn=function(bO){bD=bO;this.repaint()};this.isYellowOn=function(){return bD};this.setGreenOn=function(bO){bd=bO;this.repaint()};this.isGreenOn=function(){return bd};this.repaint=function(){if(!bc){bH()}bJ.save();bJ.clearRect(0,0,bJ.canvas.width,bJ.canvas.height);bJ.drawImage(bb,0,0);bJ.drawImage(bi,0,0);if(bd){bJ.drawImage(bM,0,0)}bJ.drawImage(be,0,0);bJ.drawImage(bx,0,0);if(bD){bJ.drawImage(bs,0,0)}bJ.drawImage(bv,0,0);bJ.drawImage(bk,0,0);if(bB){bJ.drawImage(bC,0,0)}bJ.drawImage(a7,0,0);bJ.restore()};this.repaint();return this};var T=function(a8,bc){bc=bc||{};var bk=(undefined===bc.width?100:bc.width);var bj=(undefined===bc.height?100:bc.height);var bs=(undefined===bc.glowColor?"#ffff00":bc.glowColor);var bg=document.getElementById(a8).getContext("2d");bg.save();bg.clearRect(0,0,bg.canvas.width,bg.canvas.height);bg.canvas.width=bk;bg.canvas.height=bj;var bi=bk<bj?bk:bj;var bf=bi;var br=bi;var ba=false;var a6=false;var bb=1;function bq(bw,bu,bx){var bv=H.createElement("canvas");bv.width=bw;bv.height=bu;bx(bv.getContext("2d"));return bv}var a9=function(bu){var bw;var bv=bq(1,1,function(bx){bx.fillStyle=bu;bx.beginPath();bx.rect(0,0,1,1);bx.fill()});bw=bv.getContext("2d").getImageData(0,0,2,2).data;return new Array(bw[0],bw[1],bw[2])};var be=H.createElement("canvas");be.width=bf;be.height=br;var bl=be.getContext("2d");var bt=H.createElement("canvas");bt.width=bf;bt.height=br;var bo=bt.getContext("2d");var a7=H.createElement("canvas");a7.width=bf;a7.height=br;var bn=a7.getContext("2d");var bp=function(bu){bu.save();bu.clearRect(0,0,bu.canvas.width,bu.canvas.height);bu.save();bu.beginPath();bu.moveTo(0.289473*bf,0.438596*br);bu.bezierCurveTo(0.289473*bf,0.561403*br,0.385964*bf,0.605263*br,0.385964*bf,0.745614*br);bu.bezierCurveTo(0.385964*bf,0.745614*br,0.587719*bf,0.745614*br,0.587719*bf,0.745614*br);bu.bezierCurveTo(0.587719*bf,0.605263*br,0.692982*bf,0.561403*br,0.692982*bf,0.438596*br);bu.bezierCurveTo(0.692982*bf,0.324561*br,0.605263*bf,0.22807*br,0.5*bf,0.22807*br);bu.bezierCurveTo(0.385964*bf,0.22807*br,0.289473*bf,0.324561*br,0.289473*bf,0.438596*br);bu.closePath();var bv=bu.createLinearGradient(0,0.289473*br,0,0.701754*br);bv.addColorStop(0,"#eeeeee");bv.addColorStop(0.99,"#999999");bv.addColorStop(1,"#999999");bu.fillStyle=bv;bu.fill();bu.lineCap="butt";bu.lineJoin="round";bu.lineWidth=0.008771*bf;bu.strokeStyle="#cccccc";bu.stroke();bu.restore();bu.restore()};var bd=function(bv){bv.save();bv.clearRect(0,0,bv.canvas.width,bv.canvas.height);bv.save();bv.beginPath();bv.moveTo(0.289473*bf,0.438596*br);bv.bezierCurveTo(0.289473*bf,0.561403*br,0.385964*bf,0.605263*br,0.385964*bf,0.745614*br);bv.bezierCurveTo(0.385964*bf,0.745614*br,0.587719*bf,0.745614*br,0.587719*bf,0.745614*br);bv.bezierCurveTo(0.587719*bf,0.605263*br,0.692982*bf,0.561403*br,0.692982*bf,0.438596*br);bv.bezierCurveTo(0.692982*bf,0.324561*br,0.605263*bf,0.22807*br,0.5*bf,0.22807*br);bv.bezierCurveTo(0.385964*bf,0.22807*br,0.289473*bf,0.324561*br,0.289473*bf,0.438596*br);bv.closePath();var bx=bv.createLinearGradient(0,0.289473*br,0,0.701754*br);var bz=a9(bs);var bA=bz[0];var by=bz[1];var bu=bz[2];var bw=az(bA,by,bu);if(bA===by&&by===bu){bx.addColorStop(0,"hsl(0, 60%, 0%)");bx.addColorStop(1,"hsl(0, 40%, 0%)")}else{bx.addColorStop(0,"hsl("+bw[0]*255+", "+bw[1]*100+"%, 70%)");bx.addColorStop(1,"hsl("+bw[0]*255+", "+bw[1]*100+"%, 80%)")}bv.fillStyle=bx;bv.shadowOffsetX=0;bv.shadowOffsetY=0;bv.shadowBlur=30;bv.shadowColor=bs;bv.fill();bv.lineCap="butt";bv.lineJoin="round";bv.lineWidth=0.008771*bf;bv.strokeStyle="rgba("+bA+", "+by+", "+bu+", 0.4)";bv.stroke();bv.restore();bv.restore()};var a5=function(bv){bv.save();bv.clearRect(0,0,bv.canvas.width,bv.canvas.height);bv.save();bv.beginPath();bv.moveTo(0.350877*bf,0.333333*br);bv.bezierCurveTo(0.350877*bf,0.280701*br,0.41228*bf,0.236842*br,0.5*bf,0.236842*br);bv.bezierCurveTo(0.578947*bf,0.236842*br,0.64035*bf,0.280701*br,0.64035*bf,0.333333*br);bv.bezierCurveTo(0.64035*bf,0.385964*br,0.578947*bf,0.429824*br,0.5*bf,0.429824*br);bv.bezierCurveTo(0.41228*bf,0.429824*br,0.350877*bf,0.385964*br,0.350877*bf,0.333333*br);bv.closePath();var bx=bv.createLinearGradient(0,0.245614*br,0,0.429824*br);bx.addColorStop(0,"#ffffff");bx.addColorStop(0.99,"rgba(255, 255, 255, 0)");bx.addColorStop(1,"rgba(255, 255, 255, 0)");bv.fillStyle=bx;bv.fill();bv.restore();bv.save();bv.beginPath();bv.moveTo(0.377192*bf,0.745614*br);bv.bezierCurveTo(0.377192*bf,0.745614*br,0.429824*bf,0.72807*br,0.491228*bf,0.72807*br);bv.bezierCurveTo(0.561403*bf,0.72807*br,0.605263*bf,0.736842*br,0.605263*bf,0.736842*br);bv.lineTo(0.605263*bf,0.763157*br);bv.lineTo(0.596491*bf,0.780701*br);bv.lineTo(0.605263*bf,0.798245*br);bv.lineTo(0.596491*bf,0.815789*br);bv.lineTo(0.605263*bf,0.833333*br);bv.lineTo(0.596491*bf,0.850877*br);bv.lineTo(0.605263*bf,0.868421*br);bv.lineTo(0.596491*bf,0.885964*br);bv.lineTo(0.605263*bf,0.894736*br);bv.bezierCurveTo(0.605263*bf,0.894736*br,0.570175*bf,0.95614*br,0.535087*bf,0.991228*br);bv.bezierCurveTo(0.526315*bf,0.991228*br,0.517543*bf,br,0.5*bf,br);bv.bezierCurveTo(0.482456*bf,br,0.473684*bf,br,0.464912*bf,0.991228*br);bv.bezierCurveTo(0.421052*bf,0.947368*br,0.394736*bf,0.903508*br,0.394736*bf,0.903508*br);bv.lineTo(0.394736*bf,0.894736*br);bv.lineTo(0.385964*bf,0.885964*br);bv.lineTo(0.394736*bf,0.868421*br);bv.lineTo(0.385964*bf,0.850877*br);bv.lineTo(0.394736*bf,0.833333*br);bv.lineTo(0.385964*bf,0.815789*br);bv.lineTo(0.394736*bf,0.798245*br);bv.lineTo(0.377192*bf,0.789473*br);bv.lineTo(0.394736*bf,0.771929*br);bv.lineTo(0.377192*bf,0.763157*br);bv.lineTo(0.377192*bf,0.745614*br);bv.closePath();var by=bv.createLinearGradient(0.473684*bf,0.72807*br,0.484702*bf,0.938307*br);by.addColorStop(0,"#333333");by.addColorStop(0.04,"#d9dad6");by.addColorStop(0.19,"#e4e5e0");by.addColorStop(0.24,"#979996");by.addColorStop(0.31,"#fbffff");by.addColorStop(0.4,"#818584");by.addColorStop(0.48,"#f5f7f4");by.addColorStop(0.56,"#959794");by.addColorStop(0.64,"#f2f2f0");by.addColorStop(0.7,"#828783");by.addColorStop(0.78,"#fcfcfc");by.addColorStop(1,"#666666");bv.fillStyle=by;bv.fill();bv.restore();bv.save();bv.beginPath();bv.moveTo(0.377192*bf,0.745614*br);bv.bezierCurveTo(0.377192*bf,0.745614*br,0.429824*bf,0.72807*br,0.491228*bf,0.72807*br);bv.bezierCurveTo(0.561403*bf,0.72807*br,0.605263*bf,0.736842*br,0.605263*bf,0.736842*br);bv.lineTo(0.605263*bf,0.763157*br);bv.lineTo(0.596491*bf,0.780701*br);bv.lineTo(0.605263*bf,0.798245*br);bv.lineTo(0.596491*bf,0.815789*br);bv.lineTo(0.605263*bf,0.833333*br);bv.lineTo(0.596491*bf,0.850877*br);bv.lineTo(0.605263*bf,0.868421*br);bv.lineTo(0.596491*bf,0.885964*br);bv.lineTo(0.605263*bf,0.894736*br);bv.bezierCurveTo(0.605263*bf,0.894736*br,0.570175*bf,0.95614*br,0.535087*bf,0.991228*br);bv.bezierCurveTo(0.526315*bf,0.991228*br,0.517543*bf,br,0.5*bf,br);bv.bezierCurveTo(0.482456*bf,br,0.473684*bf,br,0.464912*bf,0.991228*br);bv.bezierCurveTo(0.421052*bf,0.947368*br,0.394736*bf,0.903508*br,0.394736*bf,0.903508*br);bv.lineTo(0.394736*bf,0.894736*br);bv.lineTo(0.385964*bf,0.885964*br);bv.lineTo(0.394736*bf,0.868421*br);bv.lineTo(0.385964*bf,0.850877*br);bv.lineTo(0.394736*bf,0.833333*br);bv.lineTo(0.385964*bf,0.815789*br);bv.lineTo(0.394736*bf,0.798245*br);bv.lineTo(0.377192*bf,0.789473*br);bv.lineTo(0.394736*bf,0.771929*br);bv.lineTo(0.377192*bf,0.763157*br);bv.lineTo(0.377192*bf,0.745614*br);bv.closePath();var bw=bv.createLinearGradient(0.377192*bf,0.789473*br,0.605263*bf,0.789473*br);bw.addColorStop(0,"rgba(0, 0, 0, 0.4)");bw.addColorStop(0.15,"rgba(0, 0, 0, 0.32)");bw.addColorStop(0.85,"rgba(0, 0, 0, 0.33)");bw.addColorStop(1,"rgba(0, 0, 0, 0.4)");bv.fillStyle=bw;bv.fill();bv.restore();bv.save();bv.beginPath();bv.moveTo(0.421052*bf,0.947368*br);bv.bezierCurveTo(0.438596*bf,0.95614*br,0.447368*bf,0.973684*br,0.464912*bf,0.991228*br);bv.bezierCurveTo(0.473684*bf,br,0.482456*bf,br,0.5*bf,br);bv.bezierCurveTo(0.517543*bf,br,0.526315*bf,0.991228*br,0.535087*bf,0.991228*br);bv.bezierCurveTo(0.543859*bf,0.982456*br,0.561403*bf,0.95614*br,0.578947*bf,0.947368*br);bv.bezierCurveTo(0.552631*bf,0.938596*br,0.526315*bf,0.938596*br,0.5*bf,0.938596*br);bv.bezierCurveTo(0.473684*bf,0.938596*br,0.447368*bf,0.938596*br,0.421052*bf,0.947368*br);bv.closePath();var bu=bv.createLinearGradient(0,0.938596*br,0,br);bu.addColorStop(0,"#050a06");bu.addColorStop(0.61,"#070602");bu.addColorStop(0.71,"#999288");bu.addColorStop(0.83,"#010101");bu.addColorStop(1,"#000000");bv.fillStyle=bu;bv.fill();bv.restore();bv.restore()};var bh=function(bu){bu.save();bu.setTransform(1,0,0,1,0,0);bu.clearRect(0,0,bu.canvas.width,bu.canvas.height);bu.restore()};var bm=function(){ba=true;bp(bl);bd(bo);a5(bn)};this.setOn=function(bu){a6=bu;this.repaint()};this.isOn=function(){return a6};this.setAlpha=function(bu){bb=bu;this.repaint()};this.getAlpha=function(){return bb};this.setGlowColor=function(bu){bs=bu;bm();this.repaint()};this.getGlowColor=function(){return bs};this.repaint=function(){if(!ba){bm()}bh(bg);bg.save();bg.drawImage(be,0,0);bg.globalAlpha=bb;if(a6){bg.drawImage(bt,0,0)}bg.globalAlpha=1;bg.drawImage(a7,0,0);bg.restore()};this.repaint();return this};var aJ=function(ba,bh){bh=bh||{};var bn=(undefined===bh.height?null:bh._context);var bo=(undefined===bh.height?40:bh.height);var bk=(undefined===bh.digits?6:bh.digits);var bC=(undefined===bh.decimals?1:bh.decimals);var bf=(undefined===bh.decimalBackColor?"#F0F0F0":bh.decimalBackColor);var bj=(undefined===bh.decimalForeColor?"#F01010":bh.decimalForeColor);var bm=(undefined===bh.font?"sans-serif":bh.font);var bs=(undefined===bh.value?0:bh.value);var a5=(undefined===bh.valueBackColor?"#050505":bh.valueBackColor);var be=(undefined===bh.valueForeColor?"#F8F8F8":bh.valueForeColor);var bx=(undefined===bh.wobbleFactor?0.07:bh.wobbleFactor);var bB=document;var bc=false;var bt;if(bn){bt=bn}else{bt=bB.getElementById(ba).getContext("2d")}if(bs<0){bs=0}var bv=Math.floor(bo*0.85);var bg="600 "+bv+"px "+bm;var bb=Math.floor(bo*0.68);var bq=bb*(bk+bC);var bp=bv*11;var a6=bp/12;var bz=a6*0.81;var bl=[];bt.canvas.width=bq;bt.canvas.height=bo;var a7=P(bq,bo);var bA=a7.getContext("2d");var br=P(bq,bo);var a9=br.getContext("2d");var by=P(bb,bp*1.1);var a8=by.getContext("2d");var bd=P(bb,bp*1.1);var bu=bd.getContext("2d");function bw(){bc=true;a9.rect(0,0,bq,bo);gradHighlight=a9.createLinearGradient(0,0,0,bo);gradHighlight.addColorStop(0,"rgba(0, 0, 0, 1)");gradHighlight.addColorStop(0.1,"rgba(0, 0, 0, 0.4)");gradHighlight.addColorStop(0.33,"rgba(255, 255, 255, 0.45)");gradHighlight.addColorStop(0.46,"rgba(255, 255, 255, 0)");gradHighlight.addColorStop(0.9,"rgba(0, 0, 0, 0.4)");gradHighlight.addColorStop(1,"rgba(0, 0, 0, 1)");a9.fillStyle=gradHighlight;a9.fill();a8.rect(0,0,bb,bp*1.1);a8.fillStyle=a5;a8.fill();a8.strokeStyle="#f0f0f0";a8.lineWidth="1px";a8.moveTo(0,0);a8.lineTo(0,bp*1.1);a8.stroke();a8.strokeStyle="#202020";a8.moveTo(bb,0);a8.lineTo(bb,bp*1.1);a8.stroke();a8.textAlign="center";a8.textBaseline="middle";a8.font=bg;a8.fillStyle=be;for(var bD=9;bD<21;bD++){a8.fillText(bD%10,bb*0.5,a6*(bD-9)+a6/2)}if(bC>0){bu.rect(0,0,bb,bp*1.1);bu.fillStyle=bf;bu.fill();bu.strokeStyle="#f0f0f0";bu.lineWidth="1px";bu.moveTo(0,0);bu.lineTo(0,bp*1.1);bu.stroke();bu.strokeStyle="#202020";bu.moveTo(bb,0);bu.lineTo(bb,bp*1.1);bu.stroke();bu.textAlign="center";bu.textBaseline="middle";bu.font=bg;bu.fillStyle=bj;for(var bD=9;bD<21;bD++){bu.fillText(bD%10,bb*0.5,a6*(bD-9)+a6/2)}}for(var bD=0;bD<(bk+bC);bD++){bl[bD]=Math.random()*bx*bo-bx*bo/2}}function bi(){var bJ=1;var bI;bI=bs;for(var bH=0;bH<bC;bH++){bI*=10}var bF=Math.floor(bI);var bE=bI-bF;bF=String(bF);var bG=9;for(var bH=0;bH<bC+bk;bH++){var bD=+bF.substring(bF.length-bH-1,bF.length-bH)||0;if(bG!=9){bE=0}if(bH<bC){bA.drawImage(bd,bq-bb*bJ,-(a6*(bD+bE)+bz+bl[bH]))}else{bA.drawImage(by,bq-bb*bJ,-(a6*(bD+bE)+bz+bl[bH]))}bJ++;bG=bD}}this.setValue=function(bD){bs=bD;if(bs<0){bs=0}this.repaint()};this.getValue=function(){return bs};this.repaint=function(){if(!bc){bw()}bi();bA.drawImage(br,0,0);bt.drawImage(a7,0,0)};this.repaint()};var aC=P(1,1);var I=P(1,1);var L;var a3;var a1=P(1,1);var ao=P(1,1);var aq;var t;var w=P(1,1);var ae;var b;var Y;var aW;var aN;var aZ;var aH=P(1,1);var h;var j=function(bf,a7,a6,bc,a9,bd){var be=true;var a8;var ba=Math.PI/180;bf.save();bf.lineWidth=1;bf.fillStyle=bd.symbolColor.getRgbaColor();bf.strokeStyle=bd.symbolColor.getRgbaColor();bf.translate(a7,a6);for(a8=0;a8<360;a8+=15){be=!be;bf.beginPath();bf.arc(0,0,bc*0.26,a8*ba,(a8+15)*ba,false);bf.arc(0,0,bc*0.23,(a8+15)*ba,a8*ba,true);bf.closePath();if(be){bf.fill()}bf.stroke()}bf.translate(-a7,-a6);var a5=bd.symbolColor.getRgbaColor();bf.strokeStyle=bd.symbolColor.getRgbaColor();for(a8=0;360>=a8;a8+=90){bf.beginPath();bf.moveTo(bc*0.560747,a9*0.584112);bf.lineTo(bc*0.640186,a9*0.644859);bf.lineTo(bc*0.584112,a9*0.560747);bf.lineTo(bc*0.560747,a9*0.584112);bf.closePath();bf.fillStyle=a5;bf.fill();bf.stroke();bf.beginPath();bf.moveTo(bc*0.523364,a9*0.397196);bf.lineTo(bc*0.5,a9*0.196261);bf.lineTo(bc*0.471962,a9*0.397196);bf.lineTo(bc*0.523364,a9*0.397196);bf.closePath();var bb=bf.createLinearGradient(0.476635*bc,0,0.518691*bc,0);bb.addColorStop(0,"rgb(222, 223, 218)");bb.addColorStop(0.48,"rgb(222, 223, 218)");bb.addColorStop(0.49,bd.symbolColor.getRgbaColor());bb.addColorStop(1,bd.symbolColor.getRgbaColor());bf.fillStyle=bb;bf.fill();bf.stroke();bf.translate(a7,a6);bf.rotate(a8*Math.PI/180);bf.translate(-a7,-a6)}bf.beginPath();bf.translate(a7,a6);bf.arc(0,0,bc*0.1,0,Math.PI*2,false);bf.lineWidth=bc*0.022;bf.strokeStyle=bd.symbolColor.getRgbaColor();bf.stroke();bf.translate(-a7,-a6);bf.restore()};var J=function(a6,a7,ba,a9,a8,bc){a6.save();var bb;if(bc){a6.fillStyle="rgba(0, 0, 0, 0.6)";a6.strokeStyle="rgba(0, 0, 0, 0.5)"}switch(ba.type){case"type2":if(!bc){bb=a6.createLinearGradient(0,a7*0.471962,0,a7*0.130841);bb.addColorStop(0,a8.getRgbaColor());bb.addColorStop(0.36,a8.getRgbaColor());bb.addColorStop(0.361,a9.light.getRgbaColor());bb.addColorStop(1,a9.light.getRgbaColor());a6.fillStyle=bb}a6.beginPath();a6.moveTo(a7*0.518691,a7*0.471962);a6.lineTo(a7*0.509345,a7*0.462616);a6.lineTo(a7*0.509345,a7*0.341121);a6.lineTo(a7*0.504672,a7*0.130841);a6.lineTo(a7*0.495327,a7*0.130841);a6.lineTo(a7*0.490654,a7*0.341121);a6.lineTo(a7*0.490654,a7*0.462616);a6.lineTo(a7*0.481308,a7*0.471962);a6.closePath();a6.fill();break;case"type3":a6.beginPath();a6.rect(a7*0.495327,a7*0.130841,a7*0.009345,a7*0.373831);a6.closePath();if(!bc){a6.fillStyle=a9.light.getRgbaColor()}a6.fill();break;case"type4":if(!bc){bb=a6.createLinearGradient(0.467289*a7,0,0.528036*a7,0);bb.addColorStop(0,a9.dark.getRgbaColor());bb.addColorStop(0.51,a9.dark.getRgbaColor());bb.addColorStop(0.52,a9.light.getRgbaColor());bb.addColorStop(1,a9.light.getRgbaColor());a6.fillStyle=bb}a6.beginPath();a6.moveTo(a7*0.5,a7*0.126168);a6.lineTo(a7*0.514018,a7*0.135514);a6.lineTo(a7*0.53271,a7*0.5);a6.lineTo(a7*0.523364,a7*0.602803);a6.lineTo(a7*0.476635,a7*0.602803);a6.lineTo(a7*0.467289,a7*0.5);a6.lineTo(a7*0.485981,a7*0.135514);a6.lineTo(a7*0.5,a7*0.126168);a6.closePath();a6.fill();break;case"type5":if(!bc){bb=a6.createLinearGradient(0.471962*a7,0,0.528036*a7,0);bb.addColorStop(0,a9.light.getRgbaColor());bb.addColorStop(0.5,a9.light.getRgbaColor());bb.addColorStop(0.5,a9.medium.getRgbaColor());bb.addColorStop(1,a9.medium.getRgbaColor());a6.fillStyle=bb}a6.beginPath();a6.moveTo(a7*0.5,a7*0.495327);a6.lineTo(a7*0.528037,a7*0.495327);a6.lineTo(a7*0.5,a7*0.149532);a6.lineTo(a7*0.471962,a7*0.495327);a6.lineTo(a7*0.5,a7*0.495327);a6.closePath();a6.fill();a6.lineWidth=1;a6.lineCap="square";a6.lineJoin="miter";if(!bc){a6.strokeStyle=a9.dark.getRgbaColor()}a6.stroke();break;case"type6":if(!bc){a6.fillStyle=a9.medium.getRgbaColor()}a6.beginPath();a6.moveTo(a7*0.481308,a7*0.485981);a6.lineTo(a7*0.481308,a7*0.392523);a6.lineTo(a7*0.485981,a7*0.317757);a6.lineTo(a7*0.495327,a7*0.130841);a6.lineTo(a7*0.504672,a7*0.130841);a6.lineTo(a7*0.514018,a7*0.317757);a6.lineTo(a7*0.518691,a7*0.38785);a6.lineTo(a7*0.518691,a7*0.485981);a6.lineTo(a7*0.504672,a7*0.485981);a6.lineTo(a7*0.504672,a7*0.38785);a6.lineTo(a7*0.5,a7*0.317757);a6.lineTo(a7*0.495327,a7*0.392523);a6.lineTo(a7*0.495327,a7*0.485981);a6.lineTo(a7*0.481308,a7*0.485981);a6.closePath();a6.fill();break;case"type7":if(!bc){bb=a6.createLinearGradient(0.481308*a7,0,0.518691*a7,0);bb.addColorStop(0,a9.dark.getRgbaColor());bb.addColorStop(1,a9.medium.getRgbaColor());a6.fillStyle=bb}a6.beginPath();a6.moveTo(a7*0.490654,a7*0.130841);a6.lineTo(a7*0.481308,a7*0.5);a6.lineTo(a7*0.518691,a7*0.5);a6.lineTo(a7*0.504672,a7*0.130841);a6.lineTo(a7*0.490654,a7*0.130841);a6.closePath();a6.fill();break;case"type8":if(!bc){bb=a6.createLinearGradient(0.471962*a7,0,0.528036*a7,0);bb.addColorStop(0,a9.light.getRgbaColor());bb.addColorStop(0.5,a9.light.getRgbaColor());bb.addColorStop(0.5,a9.medium.getRgbaColor());bb.addColorStop(1,a9.medium.getRgbaColor());a6.fillStyle=bb;a6.strokeStyle=a9.dark.getRgbaColor()}a6.beginPath();a6.moveTo(a7*0.5,a7*0.53271);a6.lineTo(a7*0.53271,a7*0.5);a6.bezierCurveTo(a7*0.53271,a7*0.5,a7*0.509345,a7*0.457943,a7*0.5,a7*0.149532);a6.bezierCurveTo(a7*0.490654,a7*0.457943,a7*0.467289,a7*0.5,a7*0.467289,a7*0.5);a6.lineTo(a7*0.5,a7*0.53271);a6.closePath();a6.fill();a6.stroke();break;case"type9":if(!bc){bb=a6.createLinearGradient(0.471962*a7,0,0.528036*a7,0);bb.addColorStop(0,"rgb(50, 50, 50)");bb.addColorStop(0.5,"#666666");bb.addColorStop(1,"rgb(50, 50, 50)");a6.fillStyle=bb;a6.strokeStyle="#2E2E2E"}a6.beginPath();a6.moveTo(a7*0.495327,a7*0.233644);a6.lineTo(a7*0.504672,a7*0.233644);a6.lineTo(a7*0.514018,a7*0.439252);a6.lineTo(a7*0.485981,a7*0.439252);a6.lineTo(a7*0.495327,a7*0.233644);a6.closePath();a6.moveTo(a7*0.490654,a7*0.130841);a6.lineTo(a7*0.471962,a7*0.471962);a6.lineTo(a7*0.471962,a7*0.528037);a6.bezierCurveTo(a7*0.471962,a7*0.528037,a7*0.476635,a7*0.602803,a7*0.476635,a7*0.602803);a6.bezierCurveTo(a7*0.476635,a7*0.607476,a7*0.481308,a7*0.607476,a7*0.5,a7*0.607476);a6.bezierCurveTo(a7*0.518691,a7*0.607476,a7*0.523364,a7*0.607476,a7*0.523364,a7*0.602803);a6.bezierCurveTo(a7*0.523364,a7*0.602803,a7*0.528037,a7*0.528037,a7*0.528037,a7*0.528037);a6.lineTo(a7*0.528037,a7*0.471962);a6.lineTo(a7*0.509345,a7*0.130841);a6.lineTo(a7*0.490654,a7*0.130841);a6.closePath();a6.fill();a6.beginPath();a6.moveTo(a7*0.495327,a7*0.219626);a6.lineTo(a7*0.504672,a7*0.219626);a6.lineTo(a7*0.504672,a7*0.135514);a6.lineTo(a7*0.495327,a7*0.135514);a6.lineTo(a7*0.495327,a7*0.219626);a6.closePath();if(!bc){a6.fillStyle=a9.medium.getRgbaColor()}a6.fill();break;case"type10":a6.beginPath();a6.moveTo(a7*0.5,a7*0.149532);a6.bezierCurveTo(a7*0.5,a7*0.149532,a7*0.443925,a7*0.490654,a7*0.443925,a7*0.5);a6.bezierCurveTo(a7*0.443925,a7*0.53271,a7*0.467289,a7*0.556074,a7*0.5,a7*0.556074);a6.bezierCurveTo(a7*0.53271,a7*0.556074,a7*0.556074,a7*0.53271,a7*0.556074,a7*0.5);a6.bezierCurveTo(a7*0.556074,a7*0.490654,a7*0.5,a7*0.149532,a7*0.5,a7*0.149532);a6.closePath();if(!bc){bb=a6.createLinearGradient(0.471962*a7,0,0.528036*a7,0);bb.addColorStop(0,a9.light.getRgbaColor());bb.addColorStop(0.5,a9.light.getRgbaColor());bb.addColorStop(0.5,a9.medium.getRgbaColor());bb.addColorStop(1,a9.medium.getRgbaColor());a6.fillStyle=bb;a6.strokeStyle=a9.medium.getRgbaColor()}a6.lineWidth=1;a6.lineCap="square";a6.lineJoin="miter";a6.fill();a6.stroke();break;case"type11":a6.beginPath();a6.moveTo(0.5*a7,0.168224*a7);a6.lineTo(0.485981*a7,0.5*a7);a6.bezierCurveTo(0.485981*a7,0.5*a7,0.481308*a7,0.584112*a7,0.5*a7,0.584112*a7);a6.bezierCurveTo(0.514018*a7,0.584112*a7,0.509345*a7,0.5*a7,0.509345*a7,0.5*a7);a6.lineTo(0.5*a7,0.168224*a7);a6.closePath();if(!bc){bb=a6.createLinearGradient(0,0.168224*a7,0,0.584112*a7);bb.addColorStop(0,a9.medium.getRgbaColor());bb.addColorStop(1,a9.dark.getRgbaColor());a6.fillStyle=bb;a6.strokeStyle=a9.dark.getRgbaColor()}a6.fill();a6.stroke();break;case"type12":a6.beginPath();a6.moveTo(0.5*a7,0.168224*a7);a6.lineTo(0.485981*a7,0.5*a7);a6.lineTo(0.5*a7,0.504672*a7);a6.lineTo(0.509345*a7,0.5*a7);a6.lineTo(0.5*a7,0.168224*a7);a6.closePath();if(!bc){bb=a6.createLinearGradient(0,0.168224*a7,0,0.504672*a7);bb.addColorStop(0,a9.medium.getRgbaColor());bb.addColorStop(1,a9.dark.getRgbaColor());a6.fillStyle=bb;a6.strokeStyle=a9.dark.getRgbaColor()}a6.fill();a6.stroke();break;case"type13":case"type14":a6.beginPath();a6.moveTo(0.485981*a7,0.168224*a7);a6.lineTo(0.5*a7,0.130841*a7);a6.lineTo(0.509345*a7,0.168224*a7);a6.lineTo(0.509345*a7,0.509345*a7);a6.lineTo(0.485981*a7,0.509345*a7);a6.lineTo(0.485981*a7,0.168224*a7);a6.closePath();if(!bc){if(ba.type==="type13"){bb=a6.createLinearGradient(0,0.5*a7,0,0.130841*a7);bb.addColorStop(0,a8.getRgbaColor());bb.addColorStop(0.85,a8.getRgbaColor());bb.addColorStop(0.85,a9.medium.getRgbaColor());bb.addColorStop(1,a9.medium.getRgbaColor());a6.fillStyle=bb}else{bb=a6.createLinearGradient(0.485981*a7,0,0.509345*a7,0);bb.addColorStop(0,a9.veryDark.getRgbaColor());bb.addColorStop(0.5,a9.light.getRgbaColor());bb.addColorStop(1,a9.veryDark.getRgbaColor());a6.fillStyle=bb}}a6.fill();break;case"type15":case"type16":a6.beginPath();a6.moveTo(a7*0.509345,a7*0.457943);a6.lineTo(a7*0.5015,a7*0.13);a6.lineTo(a7*0.4985,a7*0.13);a6.lineTo(a7*0.490654,a7*0.457943);a6.bezierCurveTo(a7*0.490654,a7*0.457943,a7*0.490654,a7*0.457943,a7*0.490654,a7*0.457943);a6.bezierCurveTo(a7*0.471962,a7*0.462616,a7*0.457943,a7*0.481308,a7*0.457943,a7*0.5);a6.bezierCurveTo(a7*0.457943,a7*0.518691,a7*0.471962,a7*0.537383,a7*0.490654,a7*0.542056);a6.bezierCurveTo(a7*0.490654,a7*0.542056,a7*0.490654,a7*0.542056,a7*0.490654,a7*0.542056);if(ba.type==="type15"){a6.lineTo(a7*0.490654,a7*0.57);a6.bezierCurveTo(a7*0.46,a7*0.58,a7*0.46,a7*0.62,a7*0.490654,a7*0.63);a6.bezierCurveTo(a7*0.47,a7*0.62,a7*0.48,a7*0.59,a7*0.5,a7*0.59);a6.bezierCurveTo(a7*0.53,a7*0.59,a7*0.52,a7*0.62,a7*0.509345,a7*0.63);a6.bezierCurveTo(a7*0.54,a7*0.62,a7*0.54,a7*0.58,a7*0.509345,a7*0.57);a6.lineTo(a7*0.509345,a7*0.57)}else{a6.lineTo(a7*0.490654,a7*0.621495);a6.lineTo(a7*0.509345,a7*0.621495)}a6.lineTo(a7*0.509345,a7*0.542056);a6.bezierCurveTo(a7*0.509345,a7*0.542056,a7*0.509345,a7*0.542056,a7*0.509345,a7*0.542056);a6.bezierCurveTo(a7*0.528037,a7*0.537383,a7*0.542056,a7*0.518691,a7*0.542056,a7*0.5);a6.bezierCurveTo(a7*0.542056,a7*0.481308,a7*0.528037,a7*0.462616,a7*0.509345,a7*0.457943);a6.bezierCurveTo(a7*0.509345,a7*0.457943,a7*0.509345,a7*0.457943,a7*0.509345,a7*0.457943);a6.closePath();if(bc){a6.fill()}else{if(ba.type==="type15"){bb=a6.createLinearGradient(0,0,0,a7*0.63)}else{bb=a6.createLinearGradient(0,0,0,a7*0.621495)}bb.addColorStop(0,a9.medium.getRgbaColor());bb.addColorStop(0.388888,a9.medium.getRgbaColor());bb.addColorStop(0.5,a9.light.getRgbaColor());bb.addColorStop(0.611111,a9.medium.getRgbaColor());bb.addColorStop(1,a9.medium.getRgbaColor());a6.fillStyle=bb;a6.strokeStyle=a9.dark.getRgbaColor();a6.fill();a6.stroke()}if(!bc){a6.beginPath();var a5=a7*0.06542/2;a6.arc(a7*0.5,a7*0.5,a5,0,Math.PI*2);bb=a6.createLinearGradient(a7*0.5-a5,a7*0.5+a5,0,a7*0.5+a5);bb.addColorStop(0,"#e6b35c");bb.addColorStop(0.01,"#e6b35c");bb.addColorStop(0.99,"#c48200");bb.addColorStop(1,"#c48200");a6.fillStyle=bb;a6.closePath();a6.fill();a6.beginPath();a5=a7*0.046728/2;a6.arc(a7*0.5,a7*0.5,a5,0,Math.PI*2);bb=a6.createRadialGradient(a7*0.5,a7*0.5,0,a7*0.5,a7*0.5,a5);bb.addColorStop(0,"#c5c5c5");bb.addColorStop(0.19,"#c5c5c5");bb.addColorStop(0.22,"#000000");bb.addColorStop(0.8,"#000000");bb.addColorStop(0.99,"#707070");bb.addColorStop(1,"#707070");a6.fillStyle=bb;a6.closePath();a6.fill()}break;case"type1":default:if(!bc){bb=a6.createLinearGradient(0,a7*0.471962,0,a7*0.130841);bb.addColorStop(0,a9.veryDark.getRgbaColor());bb.addColorStop(0.3,a9.medium.getRgbaColor());bb.addColorStop(0.59,a9.medium.getRgbaColor());bb.addColorStop(1,a9.veryDark.getRgbaColor());a6.fillStyle=bb}a6.beginPath();a6.moveTo(a7*0.518691,a7*0.471962);a6.bezierCurveTo(a7*0.514018,a7*0.457943,a7*0.509345,a7*0.415887,a7*0.509345,a7*0.401869);a6.bezierCurveTo(a7*0.504672,a7*0.383177,a7*0.5,a7*0.130841,a7*0.5,a7*0.130841);a6.bezierCurveTo(a7*0.5,a7*0.130841,a7*0.490654,a7*0.383177,a7*0.490654,a7*0.397196);a6.bezierCurveTo(a7*0.490654,a7*0.415887,a7*0.485981,a7*0.457943,a7*0.481308,a7*0.471962);a6.bezierCurveTo(a7*0.471962,a7*0.481308,a7*0.467289,a7*0.490654,a7*0.467289,a7*0.5);a6.bezierCurveTo(a7*0.467289,a7*0.518691,a7*0.481308,a7*0.53271,a7*0.5,a7*0.53271);a6.bezierCurveTo(a7*0.518691,a7*0.53271,a7*0.53271,a7*0.518691,a7*0.53271,a7*0.5);a6.bezierCurveTo(a7*0.53271,a7*0.490654,a7*0.528037,a7*0.481308,a7*0.518691,a7*0.471962);a6.closePath();a6.fill();break}if(bc){al(a6,a7,a7,Math.floor(a7*0.006))}a6.restore()};var g=function(bg,bb,a9,a8,be,bc){if(be===aC.width&&bc===aC.height&&bb===a3){bg.drawImage(aC,0,0);bg.restore();return this}a3=bb;aC.width=be;aC.height=bc;var bd=aC.getContext("2d");bd.fillStyle="#848484";bd.strokeStyle="rgba(132, 132, 132, 0.5)";bd.beginPath();bd.arc(a9,a8,be/2,0,Math.PI*2,true);bd.closePath();bd.fill();bd.stroke();var bf;var a6;var ba;var a7;var a5;bd.beginPath();bd.arc(a9,a8,be*0.990654/2,0,Math.PI*2,true);bd.closePath();switch(bb.design){case"metal":bf=bd.createLinearGradient(0,be*0.004672,0,bc*0.990654);bf.addColorStop(0,"#fefefe");bf.addColorStop(0.07,"rgb(210, 210, 210)");bf.addColorStop(0.12,"rgb(179, 179, 179)");bf.addColorStop(1,"rgb(213, 213, 213)");bd.fillStyle=bf;bd.fill();break;case"brass":bf=bd.createLinearGradient(0,be*0.004672,0,bc*0.990654);bf.addColorStop(0,"rgb(249, 243, 155)");bf.addColorStop(0.05,"rgb(246, 226, 101)");bf.addColorStop(0.1,"rgb(240, 225, 132)");bf.addColorStop(0.5,"rgb(90, 57, 22)");bf.addColorStop(0.9,"rgb(249, 237, 139)");bf.addColorStop(0.95,"rgb(243, 226, 108)");bf.addColorStop(1,"rgb(202, 182, 113)");bd.fillStyle=bf;bd.fill();break;case"steel":bf=bd.createLinearGradient(0,be*0.004672,0,bc*0.990654);bf.addColorStop(0,"rgb(231, 237, 237)");bf.addColorStop(0.05,"rgb(189, 199, 198)");bf.addColorStop(0.1,"rgb(192, 201, 200)");bf.addColorStop(0.5,"rgb(23, 31, 33)");bf.addColorStop(0.9,"rgb(196, 205, 204)");bf.addColorStop(0.95,"rgb(194, 204, 203)");bf.addColorStop(1,"rgb(189, 201, 199)");bd.fillStyle=bf;bd.fill();break;case"gold":bf=bd.createLinearGradient(0,be*0.004672,0,bc*0.990654);bf.addColorStop(0,"rgb(255, 255, 207)");bf.addColorStop(0.15,"rgb(255, 237, 96)");bf.addColorStop(0.22,"rgb(254, 199, 57)");bf.addColorStop(0.3,"rgb(255, 249, 203)");bf.addColorStop(0.38,"rgb(255, 199, 64)");bf.addColorStop(0.44,"rgb(252, 194, 60)");bf.addColorStop(0.51,"rgb(255, 204, 59)");bf.addColorStop(0.6,"rgb(213, 134, 29)");bf.addColorStop(0.68,"rgb(255, 201, 56)");bf.addColorStop(0.75,"rgb(212, 135, 29)");bf.addColorStop(1,"rgb(247, 238, 101)");bd.fillStyle=bf;bd.fill();break;case"anthracite":bf=bd.createLinearGradient(0,0.004672*bc,0,0.995326*bc);bf.addColorStop(0,"rgb(118, 117, 135)");bf.addColorStop(0.06,"rgb(74, 74, 82)");bf.addColorStop(0.12,"rgb(50, 50, 54)");bf.addColorStop(1,"rgb(79, 79, 87)");bd.fillStyle=bf;bd.fill();break;case"tiltedGray":bf=bd.createLinearGradient(0.233644*be,0.084112*bc,0.81258*be,0.910919*bc);bf.addColorStop(0,"#ffffff");bf.addColorStop(0.07,"rgb(210, 210, 210)");bf.addColorStop(0.16,"rgb(179, 179, 179)");bf.addColorStop(0.33,"#ffffff");bf.addColorStop(0.55,"#c5c5c5");bf.addColorStop(0.79,"#ffffff");bf.addColorStop(1,"#666666");bd.fillStyle=bf;bd.fill();break;case"tiltedBlack":bf=bd.createLinearGradient(0.228971*be,0.079439*bc,0.802547*be,0.898591*bc);bf.addColorStop(0,"#666666");bf.addColorStop(0.21,"#000000");bf.addColorStop(0.47,"#666666");bf.addColorStop(0.99,"#000000");bf.addColorStop(1,"#000000");bd.fillStyle=bf;bd.fill();break;case"glossyMetal":bf=bd.createRadialGradient(0.5*be,0.5*bc,0,0.5*be,0.5*be,0.5*be);bf.addColorStop(0,"rgb(207, 207, 207)");bf.addColorStop(0.96,"rgb(205, 204, 205)");bf.addColorStop(1,"rgb(244, 244, 244)");bd.fillStyle=bf;bd.fill();bd.beginPath();bd.arc(0.5*be,0.5*bc,0.973962*be/2,0,Math.PI*2);bd.closePath();bf=bd.createLinearGradient(0,bc-0.971962*bc,0,0.971962*bc);bf.addColorStop(0,"rgb(249, 249, 249)");bf.addColorStop(0.23,"rgb(200, 195, 191)");bf.addColorStop(0.36,"#ffffff");bf.addColorStop(0.59,"rgb(29, 29, 29)");bf.addColorStop(0.76,"rgb(200, 194, 192)");bf.addColorStop(1,"rgb(209, 209, 209)");bd.fillStyle=bf;bd.fill();bd.beginPath();bd.arc(0.5*be,0.5*bc,0.869158*be/2,0,Math.PI*2);bd.closePath();bd.fillStyle="#f6f6f6";bd.fill();bd.beginPath();bd.arc(0.5*be,0.5*bc,0.85*be/2,0,Math.PI*2);bd.closePath();bd.fillStyle="#333333";bd.fill();break;case"blackMetal":a7=[0,0.125,0.347222,0.5,0.680555,0.875,1];a5=[new Q(254,254,254,1),new Q(0,0,0,1),new Q(153,153,153,1),new Q(0,0,0,1),new Q(153,153,153,1),new Q(0,0,0,1),new Q(254,254,254,1)];bd.save();bd.clip(bd.arc(a9,a8,be*0.990654/2,0,Math.PI*2,true));a6=be*0.495327;ba=be*0.42056;bf=new aw(a7,a5,-Math.PI/2);bf.fill(bd,a9,a8,ba,a6);bd.strokeStyle="#848484";bd.strokeStyle="rgba(132, 132, 132, 0.8)";bd.beginPath();bd.lineWidth=be/90;bd.arc(a9,a8,be/2,0,Math.PI*2,true);bd.closePath();bd.stroke();bd.restore();break;case"shinyMetal":a7=[0,0.125,0.25,0.347222,0.5,0.652777,0.75,0.875,1];a5=[new Q(254,254,254,1),new Q(210,210,210,1),new Q(179,179,179,1),new Q(238,238,238,1),new Q(160,160,160,1),new Q(238,238,238,1),new Q(179,179,179,1),new Q(210,210,210,1),new Q(254,254,254,1)];bd.save();bd.clip(bd.arc(a9,a8,be*0.990654/2,0,Math.PI*2,true));a6=be*0.495327;ba=be*0.42056;bf=new aw(a7,a5,-Math.PI/2);bf.fill(bd,a9,a8,ba,a6);bd.strokeStyle="#848484";bd.strokeStyle="rgba(132, 132, 132, 0.8)";bd.beginPath();bd.lineWidth=be/90;bd.arc(a9,a8,be/2,0,Math.PI*2,true);bd.closePath();bd.stroke();bd.restore();break;case"chrome":a7=[0,0.09,0.12,0.16,0.25,0.29,0.33,0.38,0.48,0.52,0.63,0.68,0.8,0.83,0.87,0.97,1];a5=[new Q(255,255,255,1),new Q(255,255,255,1),new Q(136,136,138,1),new Q(164,185,190,1),new Q(158,179,182,1),new Q(112,112,112,1),new Q(221,227,227,1),new Q(155,176,179,1),new Q(156,176,177,1),new Q(254,255,255,1),new Q(255,255,255,1),new Q(156,180,180,1),new Q(198,209,211,1),new Q(246,248,247,1),new Q(204,216,216,1),new Q(164,188,190,1),new Q(255,255,255,1)];bd.save();bd.clip(bd.arc(a9,a8,be*0.990654/2,0,Math.PI*2,true));a6=be*0.495327;ba=be*0.42056;bf=new aw(a7,a5,-Math.PI/2);bf.fill(bd,a9,a8,ba,a6);bd.strokeStyle="#848484";bd.strokeStyle="rgba(132, 132, 132, 0.8)";bd.beginPath();bd.lineWidth=be/90;bd.arc(a9,a8,be/2,0,Math.PI*2,true);bd.closePath();bd.stroke();bd.restore();break}bd.fillStyle="rgb(191, 191, 191)";bd.beginPath();bd.arc(a9,a8,be*0.841121/2,0,Math.PI*2,true);bd.closePath();bd.fill();bd.globalCompositeOperation="destination-out";bd.beginPath();bd.arc(a9,a8,be*0.831775/2,0,Math.PI*2,true);bd.closePath();bd.fill();bg.drawImage(aC,0,0);return this};var p=function(bf,a8,ba,a9,a6){bf.save();if(ba===a1.width&&a9===a1.height&&a8===t){bf.drawImage(a1,0,0);bf.restore();return this}var bb=Math.sqrt(ba*ba+a9*a9)*0.04;bb=Math.min(bb,(a6?ba:a9)*0.1);t=a8;a1.width=ba;a1.height=a9;var a5=a1.getContext("2d");var a7;var bd;var be;if(a6){a7=ba*0.05;bd=a7-1;be=ba*0.028571}else{a7=a9*0.05;bd=a7-1;be=a9*0.028571}V(a5,0,0,ba,a9,a7);a5.fillStyle="#838383";a5.fill();V(a5,1,1,ba-2,a9-2,bd);var bc=a5.createLinearGradient(0,1,0,a9-1);switch(a8.design){case"metal":bc=a5.createLinearGradient(0,ba*0.004672,0,a9*0.990654);bc.addColorStop(0,"#fefefe");bc.addColorStop(0.07,"rgb(210, 210, 210)");bc.addColorStop(0.12,"rgb(179, 179, 179)");bc.addColorStop(1,"rgb(213, 213, 213)");a5.fillStyle=bc;a5.fill();break;case"brass":bc=a5.createLinearGradient(0,ba*0.004672,0,a9*0.990654);bc.addColorStop(0,"rgb(249, 243, 155)");bc.addColorStop(0.05,"rgb(246, 226, 101)");bc.addColorStop(0.1,"rgb(240, 225, 132)");bc.addColorStop(0.5,"rgb(90, 57, 22)");bc.addColorStop(0.9,"rgb(249, 237, 139)");bc.addColorStop(0.95,"rgb(243, 226, 108)");bc.addColorStop(1,"rgb(202, 182, 113)");a5.fillStyle=bc;a5.fill();break;case"steel":bc=a5.createLinearGradient(0,ba*0.004672,0,a9*0.990654);bc.addColorStop(0,"rgb(231, 237, 237)");bc.addColorStop(0.05,"rgb(189, 199, 198)");bc.addColorStop(0.1,"rgb(192, 201, 200)");bc.addColorStop(0.5,"rgb(23, 31, 33)");bc.addColorStop(0.9,"rgb(196, 205, 204)");bc.addColorStop(0.95,"rgb(194, 204, 203)");bc.addColorStop(1,"rgb(189, 201, 199)");a5.fillStyle=bc;a5.fill();break;case"gold":bc=a5.createLinearGradient(0,ba*0.004672,0,a9*0.990654);bc.addColorStop(0,"rgb(255, 255, 207)");bc.addColorStop(0.15,"rgb(255, 237, 96)");bc.addColorStop(0.22,"rgb(254, 199, 57)");bc.addColorStop(0.3,"rgb(255, 249, 203)");bc.addColorStop(0.38,"rgb(255, 199, 64)");bc.addColorStop(0.44,"rgb(252, 194, 60)");bc.addColorStop(0.51,"rgb(255, 204, 59)");bc.addColorStop(0.6,"rgb(213, 134, 29)");bc.addColorStop(0.68,"rgb(255, 201, 56)");bc.addColorStop(0.75,"rgb(212, 135, 29)");bc.addColorStop(1,"rgb(247, 238, 101)");a5.fillStyle=bc;a5.fill();break;case"anthracite":bc=a5.createLinearGradient(0,0.004672*a9,0,0.995326*a9);bc.addColorStop(0,"rgb(118, 117, 135)");bc.addColorStop(0.06,"rgb(74, 74, 82)");bc.addColorStop(0.12,"rgb(50, 50, 54)");bc.addColorStop(1,"rgb(79, 79, 87)");a5.fillStyle=bc;a5.fill();break;case"tiltedGray":bc=a5.createLinearGradient(0.233644*ba,0.084112*a9,0.81258*ba,0.910919*a9);bc.addColorStop(0,"#ffffff");bc.addColorStop(0.07,"rgb(210, 210, 210)");bc.addColorStop(0.16,"rgb(179, 179, 179)");bc.addColorStop(0.33,"#ffffff");bc.addColorStop(0.55,"#c5c5c5");bc.addColorStop(0.79,"#ffffff");bc.addColorStop(1,"#666666");a5.fillStyle=bc;a5.fill();break;case"tiltedBlack":bc=a5.createLinearGradient(0.228971*ba,0.079439*a9,0.802547*ba,0.898591*a9);bc.addColorStop(0,"#666666");bc.addColorStop(0.21,"#000000");bc.addColorStop(0.47,"#666666");bc.addColorStop(0.99,"#000000");bc.addColorStop(1,"#000000");a5.fillStyle=bc;a5.fill();break;case"glossyMetal":a5.clip(V(a5,1,1,ba-2,a9-2,a7));bc=a5.createLinearGradient(0,1,0,a9-2);bc.addColorStop(0,"rgb(249, 249, 249)");bc.addColorStop(0.2,"rgb(200, 195, 191)");bc.addColorStop(0.3,"#ffffff");bc.addColorStop(0.6,"rgb(29, 29, 29)");bc.addColorStop(0.8,"rgb(200, 194, 192)");bc.addColorStop(1,"rgb(209, 209, 209)");a5.fillStyle=bc;a5.fill();a5.clip(V(a5,bb-2,bb-2,ba-(bb-2)*2,a9-(bb-2)*2,be));a5.fillStyle="#f6f6f6";a5.fill();a5.clip(V(a5,bb-1,bb-1,ba-(bb-1)*2,a9-(bb-1)*2,be));a5.fillStyle="#333333";a5.fill();break;case"blackMetal":fractions=[0,0.125,0.347222,0.5,0.680555,0.875,1];colors=[new Q(254,254,254,1),new Q(0,0,0,1),new Q(153,153,153,1),new Q(0,0,0,1),new Q(153,153,153,1),new Q(0,0,0,1),new Q(254,254,254,1)];innerX=0;outerX=Math.sqrt(a9*a9+ba*ba)/2;a5.clip(V(a5,1,1,ba-2,a9-2,a7));bc=new aw(fractions,colors,-Math.PI/2);bc.fill(a5,ba/2,a9/2,innerX,outerX);break;case"shinyMetal":fractions=[0,0.125,0.25,0.347222,0.5,0.652777,0.75,0.875,1];colors=[new Q(254,254,254,1),new Q(210,210,210,1),new Q(179,179,179,1),new Q(238,238,238,1),new Q(160,160,160,1),new Q(238,238,238,1),new Q(179,179,179,1),new Q(210,210,210,1),new Q(254,254,254,1)];innerX=0;outerX=Math.sqrt(a9*a9+ba*ba)/2;a5.clip(V(a5,1,1,ba-2,a9-2,a7));bc=new aw(fractions,colors,-Math.PI/2);bc.fill(a5,ba/2,a9/2,innerX,outerX);break;case"chrome":fractions=[0,0.09,0.12,0.16,0.25,0.29,0.33,0.38,0.48,0.52,0.63,0.68,0.8,0.83,0.87,0.97,1];colors=[new Q(255,255,255,1),new Q(255,255,255,1),new Q(136,136,138,1),new Q(164,185,190,1),new Q(158,179,182,1),new Q(112,112,112,1),new Q(221,227,227,1),new Q(155,176,179,1),new Q(156,176,177,1),new Q(254,255,255,1),new Q(255,255,255,1),new Q(156,180,180,1),new Q(198,209,211,1),new Q(246,248,247,1),new Q(204,216,216,1),new Q(164,188,190,1),new Q(255,255,255,1)];innerX=0;outerX=Math.sqrt(a9*a9+ba*ba)/2;a5.clip(V(a5,1,1,ba-2,a9-2,a7));bc=new aw(fractions,colors,-Math.PI/2);bc.fill(a5,ba/2,a9/2,innerX,outerX);break}V(a5,bb-1,bb-1,ba-(bb-1)*2,a9-(bb-1)*2,be-1);a5.fillStyle="rgb(192, 192, 192)";a5.globalCompositeOperation="destination-out";V(a5,bb,bb,ba-bb*2,a9-bb*2,4);a5.fill();bf.drawImage(a1,0,0);bf.restore();return this};var a2=function(bj,a9,bd,bb,be,bp){if(be===I.width&&bp===I.height&&a9===L){bj.drawImage(I,0,0);bj.restore();return this}L=a9;I.width=be;I.height=bp;var bg=I.getContext("2d");bg.beginPath();bg.arc(bd,bb,be*0.831775/2,0,Math.PI*2,true);bg.closePath();if(a9===steelseries.BackgroundColor.CARBON||a9===steelseries.BackgroundColor.PUNCHED_SHEET||a9===steelseries.BackgroundColor.BRUSHED_METAL||a9===steelseries.BackgroundColor.BRUSHED_STAINLESS){if(a9===steelseries.BackgroundColor.CARBON){bg.fillStyle=bg.createPattern(k,"repeat");bg.fill()}if(a9===steelseries.BackgroundColor.PUNCHED_SHEET){bg.fillStyle=bg.createPattern(ax,"repeat");bg.fill()}var bl=be*0.831775/2;var bc=bg.createLinearGradient(bl,0,be-bl,0);bc.addColorStop(0,"rgba(0, 0, 0, 0.25)");bc.addColorStop(0.5,"rgba(0, 0, 0, 0)");bc.addColorStop(1,"rgba(0, 0, 0, 0.25)");bg.fillStyle=bc;bg.beginPath();bg.arc(bd,bb,be*0.831775/2,0,Math.PI*2,true);bg.closePath();bg.fill();if(a9===steelseries.BackgroundColor.BRUSHED_METAL||a9===steelseries.BackgroundColor.BRUSHED_STAINLESS){var bk=(a9===steelseries.BackgroundColor.BRUSHED_METAL?true:false);var a5=parseInt(a9.gradientStop.getHexColor().substr(-6),16);var bh=u(a5,5,0.1,bk,0.5);bg.fillStyle=bg.createPattern(bh.fill(0,0,be,bp),"no-repeat");bg.fill()}}else{if(a9===steelseries.BackgroundColor.STAINLESS||a9===steelseries.BackgroundColor.TURNED){var bq=[0,0.03,0.1,0.14,0.24,0.33,0.38,0.5,0.62,0.67,0.76,0.81,0.85,0.97,1];var bf=[new Q("#FDFDFD"),new Q("#FDFDFD"),new Q("#B2B2B4"),new Q("#ACACAE"),new Q("#FDFDFD"),new Q("#6E6E70"),new Q("#6E6E70"),new Q("#FDFDFD"),new Q("#6E6E70"),new Q("#6E6E70"),new Q("#FDFDFD"),new Q("#ACACAE"),new Q("#B2B2B4"),new Q("#FDFDFD"),new Q("#FDFDFD")];outerX=be*0.831775/2;innerX=0;ba=new aw(bq,bf,Math.PI/1.75);ba.fill(bg,bd,bb,innerX,outerX);bg.closePath();if(a9===steelseries.BackgroundColor.TURNED){var bo=Math.PI*2;var a7=be*0.831775/2;var bi=a7*0.55;var a8=bo/360*(500/a7);bg.save();bg.clip(bg.arc(bd,bb,a7,0,bo));bg.lineWidth=0.5;var a6=bo-a8*0.3;for(var bn=0;bn<a6;bn+=a8){bg.strokeStyle="rgba(240, 240, 255, 0.25)";bg.beginPath();bg.arc(bd+bi,bb,bi,0,bo);bg.stroke();bg.translate(bd,bb);bg.rotate(a8*0.3);bg.translate(-bd,-bb);bg.strokeStyle="rgba(25, 10, 10, 0.1)";bg.beginPath();bg.arc(bd+bi,bb,bi,0,bo);bg.stroke();bg.translate(bd,bb);bg.rotate(-a8*0.3);bg.translate(-bd,-bb);bg.translate(bd,bb);bg.rotate(a8);bg.translate(-bd,-bb)}bg.restore()}}else{var ba=bg.createLinearGradient(0,be*0.084112,0,bp*0.831775);ba.addColorStop(0,a9.gradientStart.getRgbaColor());ba.addColorStop(0.4,a9.gradientFraction.getRgbaColor());ba.addColorStop(1,a9.gradientStop.getRgbaColor());bg.fillStyle=ba;bg.fill()}}var bm=bg.createRadialGradient(bd,bb,0,bd,bb,be*0.831775/2);bm.addColorStop(0,"rgba(0, 0, 0, 0)");bm.addColorStop(0.7,"rgba(0, 0, 0, 0)");bm.addColorStop(0.71,"rgba(0, 0, 0, 0)");bm.addColorStop(0.86,"rgba(0, 0, 0, 0.03)");bm.addColorStop(0.92,"rgba(0, 0, 0, 0.07)");bm.addColorStop(0.97,"rgba(0, 0, 0, 0.15)");bm.addColorStop(1,"rgba(0, 0, 0, 0.3)");bg.fillStyle=bm;bg.beginPath();bg.arc(bd,bb,be*0.831775/2,0,Math.PI*2,true);bg.closePath();bg.fill();bj.drawImage(I,0,0);return this};var W=function(be,a7,a6,a5,ba,a9){if(a7!==null&&a7.height>0&&a7.width>0){be.save();be.beginPath();be.arc(a6,a5,ba*0.831775/2,0,Math.PI*2,true);be.clip();var bd=ba*0.831775;var a8=a9*0.831775;var bc=(ba-bd)/2;var bb=(a9-a8)/2;be.drawImage(a7,bc,bb,bd,a8);be.restore()}return this};var ad=function(bm,bb,bh,br,a6){bm.save();if(bh===ao.width&&br===ao.height&&bb===aq){bm.drawImage(ao,0,0);bm.restore();return this}var bo=Math.sqrt(bh*bh+br*br)*0.04;bo=Math.min(bo,(a6?bh:br)*0.1);aq=bb;ao.width=bh;ao.height=br;var a5=ao.getContext("2d");V(a5,bo,bo,bh-bo*2,br-bo*2,4);if(bb===steelseries.BackgroundColor.CARBON||bb===steelseries.BackgroundColor.PUNCHED_SHEET||bb===steelseries.BackgroundColor.STAINLESS||bb===steelseries.BackgroundColor.BRUSHED_METAL||bb===steelseries.BackgroundColor.BRUSHED_STAINLESS||bb===steelseries.BackgroundColor.TURNED){if(bb===steelseries.BackgroundColor.CARBON){a5.fillStyle=a5.createPattern(k,"repeat");a5.fill()}if(bb===steelseries.BackgroundColor.PUNCHED_SHEET){a5.fillStyle=a5.createPattern(ax,"repeat");a5.fill()}if(bb===steelseries.BackgroundColor.STAINLESS||bb===steelseries.BackgroundColor.TURNED){var bt=60;var bd=P(bt,bt);var bk=bd.getContext("2d");bk.save();var bs=[0,0.03,0.1,0.14,0.24,0.33,0.38,0.5,0.62,0.67,0.76,0.81,0.85,0.97,1];var bi=[new Q("#FDFDFD"),new Q("#FDFDFD"),new Q("#B2B2B4"),new Q("#ACACAE"),new Q("#FDFDFD"),new Q("#6E6E70"),new Q("#6E6E70"),new Q("#FDFDFD"),new Q("#6E6E70"),new Q("#6E6E70"),new Q("#FDFDFD"),new Q("#ACACAE"),new Q("#B2B2B4"),new Q("#FDFDFD"),new Q("#FDFDFD")];bc=new aw(bs,bi,Math.PI/1.75);a5.clip(V(a5,bo,bo,bh-bo*2,br-bo*2,4));var a9=Math.sqrt((bh-bo*2)*(bh-bo*2)+(br-bo*2)*(br-bo*2))/2;bc.fill(a5,bh/2,br/2,0,a9);var bf=a5.createLinearGradient(0,bo,0,br-bo*2);bf.addColorStop(0,"rgba(0, 0, 0, 0.25)");bf.addColorStop(0.1,"rgba(0, 0, 0, 0.05)");bf.addColorStop(1,"rgba(0, 0, 0, 0)");a5.fillStyle=bf;V(a5,bo,bo,bh-bo*2,br-bo*2,4);a5.fill();a5.restore();if(bb===steelseries.BackgroundColor.TURNED){var bq=Math.PI*2;var bl=a9*0.55;var bg=bh/2;var be=br/2;var ba=bq/360*(400/a9);a5.save();a5.lineWidth=0.5;var a8=bq-ba*0.3;for(var bp=0;bp<a8;bp+=ba){a5.strokeStyle="rgba(240, 240, 255, 0.25)";a5.beginPath();a5.arc(bg+bl,be,bl,0,bq);a5.stroke();a5.translate(bg,be);a5.rotate(ba*0.3);a5.translate(-bg,-be);a5.strokeStyle="rgba(25, 10, 10, 0.1)";a5.beginPath();a5.arc(bg+bl,be,bl,0,bq);a5.stroke();a5.translate(bg,be);a5.rotate(-ba*0.3);a5.translate(-bg,-be);a5.translate(bg,be);a5.rotate(ba);a5.translate(-bg,-be)}a5.restore()}}var bf=a5.createLinearGradient(bo,bo,bh-bo*2,br-bo*2);bf.addColorStop(0,"rgba(0, 0, 0, 0.25)");bf.addColorStop(0.5,"rgba(0, 0, 0, 0)");bf.addColorStop(1,"rgba(0, 0, 0, 0.25)");a5.fillStyle=bf;V(a5,bo,bo,bh-bo*2,br-bo*2,4);a5.fill();if(bb===steelseries.BackgroundColor.BRUSHED_METAL||bb===steelseries.BackgroundColor.BRUSHED_STAINLESS){var bn=(bb===steelseries.BackgroundColor.BRUSHED_METAL?true:false);var a7=parseInt(bb.gradientStop.getHexColor().substr(-6),16);var bj=u(a7,5,0.1,bn,0.5);a5.fillStyle=a5.createPattern(bj.fill(0,0,bh,br),"no-repeat");a5.fill()}}else{var bc=a5.createLinearGradient(0,bo,0,br-bo*2);bc.addColorStop(0,bb.gradientStart.getRgbaColor());bc.addColorStop(0.4,bb.gradientFraction.getRgbaColor());bc.addColorStop(1,bb.gradientStop.getRgbaColor());a5.fillStyle=bc;a5.fill()}var bi=new Array("rgba(0, 0, 0, 0.3)","rgba(0, 0, 0, 0.15)","rgba(0, 0, 0, 0.07)","rgba(0, 0, 0, 0.03)","rgba(0, 0, 0, 0)","rgba(0, 0, 0, 0)","rgba(0, 0, 0, 0)");for(var bp=0;bp<7;bp++){V(a5,bo+bp,bo+bp,bh-bo*2-(2*bp),br-bo*2-(2*bp),4);a5.strokeStyle=bi[bp];a5.stroke()}bm.drawImage(ao,0,0);bm.restore();return this};var G=function(bh,a8,bc,ba,bf,a7,a5,a9,a6){if(a8.type===b&&bc===w.width&&ba===w.height&&bf===Y&&a7===aW&&a5===ae&&aN===a9&&aZ===a6){bh.drawImage(w,0,0);bh.restore();return this}Y=bf;aW=a7;ae=a5;w.width=bc;w.height=ba;aN=a9;aZ=a6;b=a8.type;var bd=w.getContext("2d");var bg=bc*0.008;if(bf){if(a9===steelseries.GaugeType.TYPE5){if(steelseries.Orientation.WEST===a6){bd.drawImage(K(Math.ceil(ba*0.084112),a7,a5,true),bc*0.687+bg,ba*0.45+bg);bd.drawImage(K(Math.ceil(ba*0.084112),a7,a5,false),bc*0.687,ba*0.45)}else{bd.drawImage(K(Math.ceil(ba*0.084112),a7,a5,true),bc*0.45+bg,ba*0.6857+bg);bd.drawImage(K(Math.ceil(ba*0.084112),a7,a5,false),bc*0.45,ba*0.6857)}}else{bd.drawImage(K(Math.ceil(ba*0.084112),a7,a5,true),bc*0.45+bg,ba*0.45+bg);bd.drawImage(K(Math.ceil(ba*0.084112),a7,a5,false),bc*0.45,ba*0.45)}}var be;switch(b){case"type2":bd.beginPath();bd.moveTo(bc*0.135514,ba*0.696261);bd.bezierCurveTo(bc*0.214953,ba*0.588785,bc*0.317757,ba*0.5,bc*0.462616,ba*0.425233);bd.bezierCurveTo(bc*0.612149,ba*0.345794,bc*0.733644,ba*0.317757,bc*0.873831,ba*0.322429);bd.bezierCurveTo(bc*0.766355,ba*0.112149,bc*0.528037,ba*0.023364,bc*0.313084,ba*0.130841);bd.bezierCurveTo(bc*0.09813,ba*0.238317,bc*0.028037,ba*0.485981,bc*0.135514,ba*0.696261);bd.closePath();be=bd.createLinearGradient(0.313084*bc,0.135514*ba,0.495528*bc,0.493582*ba);be.addColorStop(0,"rgba(255, 255, 255, 0.275)");be.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type3":bd.beginPath();bd.moveTo(bc*0.084112,ba*0.509345);bd.bezierCurveTo(bc*0.21028,ba*0.556074,bc*0.462616,ba*0.560747,bc*0.5,ba*0.560747);bd.bezierCurveTo(bc*0.537383,ba*0.560747,bc*0.794392,ba*0.560747,bc*0.915887,ba*0.509345);bd.bezierCurveTo(bc*0.915887,ba*0.2757,bc*0.738317,ba*0.084112,bc*0.5,ba*0.084112);bd.bezierCurveTo(bc*0.261682,ba*0.084112,bc*0.084112,ba*0.2757,bc*0.084112,ba*0.509345);bd.closePath();be=bd.createLinearGradient(0,0.093457*ba,0,0.556073*ba);be.addColorStop(0,"rgba(255, 255, 255, 0.275)");be.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type4":bd.beginPath();bd.moveTo(bc*0.67757,ba*0.24299);bd.bezierCurveTo(bc*0.771028,ba*0.308411,bc*0.822429,ba*0.411214,bc*0.813084,ba*0.528037);bd.bezierCurveTo(bc*0.799065,ba*0.654205,bc*0.719626,ba*0.757009,bc*0.593457,ba*0.799065);bd.bezierCurveTo(bc*0.485981,ba*0.831775,bc*0.369158,ba*0.808411,bc*0.285046,ba*0.728971);bd.bezierCurveTo(bc*0.2757,ba*0.719626,bc*0.252336,ba*0.714953,bc*0.233644,ba*0.728971);bd.bezierCurveTo(bc*0.214953,ba*0.747663,bc*0.219626,ba*0.771028,bc*0.228971,ba*0.7757);bd.bezierCurveTo(bc*0.331775,ba*0.878504,bc*0.476635,ba*0.915887,bc*0.616822,ba*0.869158);bd.bezierCurveTo(bc*0.771028,ba*0.822429,bc*0.873831,ba*0.691588,bc*0.88785,ba*0.53271);bd.bezierCurveTo(bc*0.897196,ba*0.38785,bc*0.836448,ba*0.257009,bc*0.719626,ba*0.182242);bd.bezierCurveTo(bc*0.705607,ba*0.172897,bc*0.682242,ba*0.163551,bc*0.663551,ba*0.186915);bd.bezierCurveTo(bc*0.654205,ba*0.205607,bc*0.668224,ba*0.238317,bc*0.67757,ba*0.24299);bd.closePath();be=bd.createRadialGradient((0.5)*bc,((0.5)*ba),0,((0.5)*bc),((0.5)*ba),0.38785*bc);be.addColorStop(0,"rgba(255, 255, 255, 0)");be.addColorStop(0.82,"rgba(255, 255, 255, 0)");be.addColorStop(0.83,"rgba(255, 255, 255, 0)");be.addColorStop(1,"rgba(255, 255, 255, 0.15)");bd.beginPath();bd.moveTo(bc*0.261682,ba*0.224299);bd.bezierCurveTo(bc*0.285046,ba*0.238317,bc*0.252336,ba*0.285046,bc*0.24299,ba*0.317757);bd.bezierCurveTo(bc*0.24299,ba*0.350467,bc*0.271028,ba*0.383177,bc*0.271028,ba*0.397196);bd.bezierCurveTo(bc*0.2757,ba*0.415887,bc*0.261682,ba*0.457943,bc*0.238317,ba*0.509345);bd.bezierCurveTo(bc*0.224299,ba*0.542056,bc*0.17757,ba*0.612149,bc*0.158878,ba*0.612149);bd.bezierCurveTo(bc*0.144859,ba*0.612149,bc*0.088785,ba*0.546728,bc*0.130841,ba*0.369158);bd.bezierCurveTo(bc*0.140186,ba*0.336448,bc*0.214953,ba*0.200934,bc*0.261682,ba*0.224299);bd.closePath();var bb=bd.createLinearGradient(0.130841*bc,0.369158*ba,0.273839*bc,0.412877*ba);bb.addColorStop(0,"rgba(255, 255, 255, 0.275)");bb.addColorStop(1,"rgba(255, 255, 255, 0.015)");bd.fillStyle=bb;bd.fill();break;case"type5":bd.beginPath();bd.moveTo(bc*0.084112,ba*0.5);bd.bezierCurveTo(bc*0.084112,ba*0.271028,bc*0.271028,ba*0.084112,bc*0.5,ba*0.084112);bd.bezierCurveTo(bc*0.700934,ba*0.084112,bc*0.864485,ba*0.224299,bc*0.906542,ba*0.411214);bd.bezierCurveTo(bc*0.911214,ba*0.439252,bc*0.911214,ba*0.518691,bc*0.845794,ba*0.537383);bd.bezierCurveTo(bc*0.794392,ba*0.546728,bc*0.551401,ba*0.411214,bc*0.392523,ba*0.457943);bd.bezierCurveTo(bc*0.168224,ba*0.509345,bc*0.135514,ba*0.7757,bc*0.093457,ba*0.593457);bd.bezierCurveTo(bc*0.088785,ba*0.560747,bc*0.084112,ba*0.53271,bc*0.084112,ba*0.5);bd.closePath();be=bd.createLinearGradient(0,0.084112*ba,0,0.644859*ba);be.addColorStop(0,"rgba(255, 255, 255, 0.275)");be.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type1":default:bd.beginPath();bd.moveTo(bc*0.084112,ba*0.509345);bd.bezierCurveTo(bc*0.205607,ba*0.448598,bc*0.336448,ba*0.415887,bc*0.5,ba*0.415887);bd.bezierCurveTo(bc*0.672897,ba*0.415887,bc*0.789719,ba*0.443925,bc*0.915887,ba*0.509345);bd.bezierCurveTo(bc*0.915887,ba*0.2757,bc*0.738317,ba*0.084112,bc*0.5,ba*0.084112);bd.bezierCurveTo(bc*0.261682,ba*0.084112,bc*0.084112,ba*0.2757,bc*0.084112,ba*0.509345);bd.closePath();be=bd.createLinearGradient(0,0.088785*ba,0,0.490654*ba);be.addColorStop(0,"rgba(255, 255, 255, 0.275)");be.addColorStop(1,"rgba(255, 255, 255, 0.015)");break}bd.fillStyle=be;bd.fill();bh.drawImage(w,0,0);return this};var aS=function(bc,ba,a9,a7){if(ba===aH.width&&a9===aH.height&&h===a7){bc.drawImage(aH,0,0);return this}h=a7;aH.width=ba;aH.height=a9;var a8=aH.getContext("2d");var bd;var bb=Math.sqrt(ba*ba+a9*a9)*0.04;bb=Math.min(bb,(a7?ba:a9)*0.1);var a5=bb*1.3;var a6=a5*1.33;a8.beginPath();a8.moveTo(a5,a9-a5);a8.lineTo(ba-a5,a9-a5);a8.bezierCurveTo(ba-a5,a9-a5,ba-a6,a9*0.7,ba-a6,a9*0.5);a8.bezierCurveTo(ba-a6,a6,ba-a5,a5,ba-bb,a5);a8.lineTo(a5,a5);a8.bezierCurveTo(a5,a5,a6,a9*0.285714,a6,a9*0.5);a8.bezierCurveTo(a6,a9*0.7,a5,a9-a5,bb,a9-a5);a8.closePath();bd=a8.createLinearGradient(0,(a9-bb),0,bb);bd.addColorStop(0,"rgba(255, 255, 255, 0)");bd.addColorStop(0.06,"rgba(255, 255, 255, 0)");bd.addColorStop(0.07,"rgba(255, 255, 255, 0)");bd.addColorStop(0.12,"rgba(255, 255, 255, 0)");bd.addColorStop(0.17,"rgba(255, 255, 255, 0.013546)");bd.addColorStop(0.1701,"rgba(255, 255, 255, 0)");bd.addColorStop(0.79,"rgba(255, 255, 255, 0)");bd.addColorStop(0.8,"rgba(255, 255, 255, 0)");bd.addColorStop(0.84,"rgba(255, 255, 255, 0.082217)");bd.addColorStop(0.93,"rgba(255, 255, 255, 0.288702)");bd.addColorStop(0.94,"rgba(255, 255, 255, 0.298039)");bd.addColorStop(0.96,"rgba(255, 255, 255, 0.119213)");bd.addColorStop(0.97,"rgba(255, 255, 255, 0)");bd.addColorStop(1,"rgba(255, 255, 255, 0)");a8.fillStyle=bd;a8.fill();bc.drawImage(aH,0,0);return this};var K=function(bl,a6,a5,bi){var bb=H.createElement("canvas");bb.width=bl*1.18889;bb.height=bl*1.18889;var bc=bb.getContext("2d");bc.save();var ba=bl/2;var a8=bl/2;if(bi){bc.fillStyle="rgba(0, 0, 0, 0.5)";bc.strokeStyle="rgba(0, 0, 0, 0.5)"}bc.translate(bl*0.06,bl*0.06);switch(a6.type){case"metalKnob":bc.beginPath();bc.moveTo(0,bl*0.5);bc.bezierCurveTo(0,bl*0.222222,bl*0.222222,0,bl*0.5,0);bc.bezierCurveTo(bl*0.777777,0,bl,bl*0.222222,bl,bl*0.5);bc.bezierCurveTo(bl,bl*0.777777,bl*0.777777,bl,bl*0.5,bl);bc.bezierCurveTo(bl*0.222222,bl,0,bl*0.777777,0,bl*0.5);bc.closePath();if(!bi){var bg=bc.createLinearGradient(0,0,0,bl);bg.addColorStop(0,"rgb(92, 95, 101)");bg.addColorStop(0.47,"rgb(46, 49, 53)");bg.addColorStop(1,"rgb(22, 23, 26)");bc.fillStyle=bg}bc.fill();bc.beginPath();bc.moveTo(bl*0.055555,bl*0.5);bc.bezierCurveTo(bl*0.055555,bl*0.277777,bl*0.277777,bl*0.055555,bl*0.5,bl*0.055555);bc.bezierCurveTo(bl*0.722222,bl*0.055555,bl*0.944444,bl*0.277777,bl*0.944444,bl*0.5);bc.bezierCurveTo(bl*0.944444,bl*0.722222,bl*0.722222,bl*0.944444,bl*0.5,bl*0.944444);bc.bezierCurveTo(bl*0.277777,bl*0.944444,bl*0.055555,bl*0.722222,bl*0.055555,bl*0.5);bc.closePath();if(!bi){var a7=bc.createLinearGradient(0,0.055555*bl,0,0.944443*bl);switch(a5.style){case"black":a7.addColorStop(0,"rgb(43, 42, 47)");a7.addColorStop(1,"rgb(26, 27, 32)");bc.fillStyle=a7;bc.fill();break;case"brass":a7.addColorStop(0,"rgb(150, 110, 54)");a7.addColorStop(1,"rgb(124, 95, 61)");bc.fillStyle=a7;bc.fill();break;case"silver":default:a7.addColorStop(0,"rgb(204, 204, 204)");a7.addColorStop(1,"rgb(87, 92, 98)");bc.fillStyle=a7;bc.fill();break}}else{bc.fill()}bc.beginPath();bc.moveTo(bl*0.777777,bl*0.833333);bc.bezierCurveTo(bl*0.722222,bl*0.722222,bl*0.611111,bl*0.666666,bl*0.5,bl*0.666666);bc.bezierCurveTo(bl*0.388888,bl*0.666666,bl*0.277777,bl*0.722222,bl*0.222222,bl*0.833333);bc.bezierCurveTo(bl*0.277777,bl*0.888888,bl*0.388888,bl*0.944444,bl*0.5,bl*0.944444);bc.bezierCurveTo(bl*0.611111,bl*0.944444,bl*0.722222,bl*0.888888,bl*0.777777,bl*0.833333);bc.closePath();if(!bi){var bh=bc.createRadialGradient((0.555555)*bl,((0.944444)*bl),0,((0.555555)*bl),((0.944444)*bl),0.388888*bl);bh.addColorStop(0,"rgba(255, 255, 255, 0.6)");bh.addColorStop(1,"rgba(255, 255, 255, 0)");bc.fillStyle=bh}bc.fill();bc.beginPath();bc.moveTo(bl*0.944444,bl*0.277777);bc.bezierCurveTo(bl*0.833333,bl*0.111111,bl*0.666666,0,bl*0.5,0);bc.bezierCurveTo(bl*0.333333,0,bl*0.166666,bl*0.111111,bl*0.055555,bl*0.277777);bc.bezierCurveTo(bl*0.166666,bl*0.333333,bl*0.333333,bl*0.388888,bl*0.5,bl*0.388888);bc.bezierCurveTo(bl*0.666666,bl*0.388888,bl*0.833333,bl*0.333333,bl*0.944444,bl*0.277777);bc.closePath();if(!bi){var be=bc.createRadialGradient(0.5*bl,0,0,((0.5)*bl),0,0.583333*bl);be.addColorStop(0,"rgba(255, 255, 255, 0.749019)");be.addColorStop(1,"rgba(255, 255, 255, 0)");bc.fillStyle=be}bc.fill();bc.beginPath();bc.moveTo(bl*0.277777,bl*0.555555);bc.bezierCurveTo(bl*0.277777,bl*0.388888,bl*0.388888,bl*0.277777,bl*0.5,bl*0.277777);bc.bezierCurveTo(bl*0.611111,bl*0.277777,bl*0.777777,bl*0.388888,bl*0.777777,bl*0.555555);bc.bezierCurveTo(bl*0.777777,bl*0.666666,bl*0.611111,bl*0.777777,bl*0.5,bl*0.777777);bc.bezierCurveTo(bl*0.388888,bl*0.777777,bl*0.277777,bl*0.666666,bl*0.277777,bl*0.555555);bc.closePath();if(!bi){var bd=bc.createLinearGradient(0,0.277777*bl,0,0.722221*bl);bd.addColorStop(0,"#000000");bd.addColorStop(1,"rgb(204, 204, 204)");bc.fillStyle=bd}bc.fill();bc.beginPath();bc.moveTo(bl*0.333333,bl*0.555555);bc.bezierCurveTo(bl*0.333333,bl*0.444444,bl*0.388888,bl*0.333333,bl*0.5,bl*0.333333);bc.bezierCurveTo(bl*0.611111,bl*0.333333,bl*0.722222,bl*0.444444,bl*0.722222,bl*0.555555);bc.bezierCurveTo(bl*0.722222,bl*0.611111,bl*0.611111,bl*0.722222,bl*0.5,bl*0.722222);bc.bezierCurveTo(bl*0.388888,bl*0.722222,bl*0.333333,bl*0.611111,bl*0.333333,bl*0.555555);bc.closePath();if(!bi){var bf=bc.createLinearGradient(0,0.333333*bl,0,0.666666*bl);bf.addColorStop(0,"rgb(10, 9, 1)");bf.addColorStop(1,"rgb(42, 41, 37)");bc.fillStyle=bf}bc.fill();break;case"standardKnob":if(!bi){var bj=bc.createLinearGradient(0,0,0,bl);bj.addColorStop(0,"rgb(180, 180, 180)");bj.addColorStop(0.46,"rgb(63, 63, 63)");bj.addColorStop(1,"rgb(40, 40, 40)");bc.fillStyle=bj}bc.beginPath();bc.arc(ba,a8,bl/2,0,Math.PI*2,true);bc.closePath();bc.fill();if(!bi){var bk=bc.createLinearGradient(0,bl-bl*0.77,0,bl-bl*0.77+bl*0.77);switch(a5.style){case"black":bk.addColorStop(0,"rgb(191, 191, 191)");bk.addColorStop(0.5,"rgb(45, 44, 49)");bk.addColorStop(1,"rgb(125, 126, 128)");bc.fillStyle=bk;break;case"brass":bk.addColorStop(0,"rgb(223, 208, 174)");bk.addColorStop(0.5,"rgb(123, 95, 63)");bk.addColorStop(1,"rgb(207, 190, 157)");bc.fillStyle=bk;break;case"silver":default:bk.addColorStop(0,"rgb(215, 215, 215)");bk.addColorStop(0.5,"rgb(116, 116, 116)");bk.addColorStop(1,"rgb(215, 215, 215)");bc.fillStyle=bk;break}}bc.beginPath();bc.arc(ba,a8,bl*0.77/2,0,Math.PI*2,true);bc.closePath();bc.fill();if(!bi){var a9=bc.createRadialGradient(ba,a8,0,ba,a8,bl*0.77/2);a9.addColorStop(0,"rgba(0, 0, 0, 0)");a9.addColorStop(0.75,"rgba(0, 0, 0, 0)");a9.addColorStop(0.76,"rgba(0, 0, 0, 0.01)");a9.addColorStop(1,"rgba(0, 0, 0, 0.2)");bc.fillStyle=a9}bc.beginPath();bc.arc(ba,a8,bl*0.77/2,0,Math.PI*2,true);bc.closePath();bc.fill();break}bc.translate(-bl*0.06,-bl*0.06);if(bi){al(bc,bb.width,bb.height,Math.floor(bl*0.06))}return bb};var aj=function(bg,a6,a8){var ba=H.createElement("canvas");ba.width=bg;ba.height=bg;var a9=ba.getContext("2d");var a7=bg/2;var a5=bg/2;var bf;var bc;switch(a6){case 0:a9.save();bf=a9.createRadialGradient(a7,a5,0,a7,a5,bg*0.5/2);bf.addColorStop(0,a8.innerColor1_OFF);bf.addColorStop(0.2,a8.innerColor2_OFF);bf.addColorStop(1,a8.outerColor_OFF);a9.fillStyle=bf;a9.beginPath();a9.arc(a7,a5,bg*0.5/2,0,Math.PI*2,true);a9.closePath();a9.fill();a9.restore();a9.save();var bd=a9.createRadialGradient(a7,a5,0,a7,a5,bg*0.5/2);bd.addColorStop(0,"rgba(0, 0, 0, 0)");bd.addColorStop(0.8,"rgba(0, 0, 0, 0)");bd.addColorStop(1,"rgba(0, 0, 0, 0.4)");a9.fillStyle=bd;a9.beginPath();a9.arc(a7,a5,bg*0.5/2,0,Math.PI*2,true);a9.closePath();a9.fill();a9.restore();a9.save();bc=a9.createLinearGradient(0,0.35*bg,0,0.35*bg+0.15*bg);bc.addColorStop(0,"rgba(255, 255, 255, 0.4)");bc.addColorStop(1,"rgba(255, 255, 255, 0)");a9.fillStyle=bc;a9.beginPath();a9.arc(a7,0.35*bg+0.2*bg/2,bg*0.2,0,Math.PI*2,true);a9.closePath();a9.fill();a9.restore();break;case 1:a9.save();bf=a9.createRadialGradient(a7,a5,0,a7,a5,bg*0.5/2);bf.addColorStop(0,a8.innerColor1_ON);bf.addColorStop(0.2,a8.innerColor2_ON);bf.addColorStop(1,a8.outerColor_ON);a9.fillStyle=bf;a9.beginPath();a9.arc(a7,a5,bg*0.5/2,0,Math.PI*2,true);a9.closePath();a9.fill();a9.restore();a9.save();var bb=a9.createRadialGradient(a7,a5,0,a7,a5,bg*0.5/2);bb.addColorStop(0,"rgba(0, 0, 0, 0)");bb.addColorStop(0.8,"rgba(0, 0, 0, 0)");bb.addColorStop(1,"rgba(0, 0, 0, 0.4)");a9.fillStyle=bb;a9.beginPath();a9.arc(a7,a5,bg*0.5/2,0,Math.PI*2,true);a9.closePath();a9.fill();a9.restore();a9.save();bc=a9.createLinearGradient(0,0.35*bg,0,0.35*bg+0.15*bg);bc.addColorStop(0,"rgba(255, 255, 255, 0.4)");bc.addColorStop(1,"rgba(255, 255, 255, 0)");a9.fillStyle=bc;a9.beginPath();a9.arc(a7,0.35*bg+0.2*bg/2,bg*0.2,0,Math.PI*2,true);a9.closePath();a9.fill();a9.restore();a9.save();var be=a9.createRadialGradient(a7,a5,0,a7,a5,bg/2);be.addColorStop(0,U(a8.coronaColor,0).color);be.addColorStop(0.6,U(a8.coronaColor,0.4).color);be.addColorStop(0.7,U(a8.coronaColor,0.25).color);be.addColorStop(0.8,U(a8.coronaColor,0.15).color);be.addColorStop(0.85,U(a8.coronaColor,0.05).color);be.addColorStop(1,U(a8.coronaColor,0).color);a9.fillStyle=be;a9.beginPath();a9.arc(a7,a5,bg/2,0,Math.PI*2,true);a9.closePath();a9.fill();a9.restore();break}return ba};var ab=function(a7,bi,bl){var be=P(a7,bi);var bb=be.getContext("2d");bb.save();var ba=0;var a5=0;var bf=a7;var bk=bi;var bc=Math.min(a7,bi)*0.095;var a6=bb.createLinearGradient(0,a5,0,a5+bk);a6.addColorStop(0,"#4c4c4c");a6.addColorStop(0.08,"#666666");a6.addColorStop(0.92,"#666666");a6.addColorStop(1,"#e6e6e6");bb.fillStyle=a6;V(bb,ba,a5,bf,bk,bc);bb.fill();bb.restore();bb.save();var a8=1;var bh=1;var bd=a7-2;var bg=bi-2;var a9=bc-1;var bj=bb.createLinearGradient(0,bh,0,bh+bg);bj.addColorStop(0,bl.gradientStartColor);bj.addColorStop(0.03,bl.gradientFraction1Color);bj.addColorStop(0.49,bl.gradientFraction2Color);bj.addColorStop(0.5,bl.gradientFraction3Color);bj.addColorStop(1,bl.gradientStopColor);bb.fillStyle=bj;V(bb,a8,bh,bd,bg,a9);bb.fill();bb.restore();return be};var C=function(a7,a8,a5,a6){var ba=H.createElement("canvas");ba.width=a7;ba.height=a7;var a9=ba.getContext("2d");a9.save();a9.fillStyle=a8;if(a5){a9.beginPath();a9.moveTo(a7*0.5,a7);a9.lineTo(0,0);a9.lineTo(a7,0);a9.closePath();a9.fill()}else{if(a6){a9.beginPath();a9.moveTo(a7,a7*0.5);a9.lineTo(0,0);a9.lineTo(0,a7);a9.closePath();a9.fill()}else{a9.beginPath();a9.moveTo(a7*0.5,0);a9.lineTo(a7,a7);a9.lineTo(0,a7);a9.closePath();a9.fill()}}a9.restore();return ba};var am=function(a7,bc,a6){var bd=a7*2;var a9=P(a7*2,a7*4);var a8=a9.getContext("2d");var be,bf;var ba=function(){var bg=a6[0];if(bc.state==="up"){be=a8.createRadialGradient(0.5*a7,0.2*bd,0,0.5*a7,0.2*bd,0.5*a7);be.addColorStop(0,bg.innerColor1_ON);be.addColorStop(0.2,bg.innerColor2_ON);be.addColorStop(1,bg.outerColor_ON)}else{be=a8.createLinearGradient(0,0,0,0.5*bd);be.addColorStop(0,"#323232");be.addColorStop(1,"#5c5c5c")}a8.fillStyle=be;a8.beginPath();a8.moveTo(0.5*a7,0);a8.lineTo(a7,0.2*bd);a8.lineTo(0.752*a7,0.2*bd);a8.lineTo(0.752*a7,0.37*bd);a8.lineTo(0.252*a7,0.37*bd);a8.lineTo(0.252*a7,0.2*bd);a8.lineTo(0,0.2*bd);a8.closePath();a8.fill();if(bc.state!=="up"){a8.strokeStyle="rgba(0, 0, 0, 0.4)";a8.beginPath();a8.moveTo(0,0.2*bd);a8.lineTo(0.5*a7,0);a8.lineTo(a7,0.2*bd);a8.moveTo(0.252*a7,0.2*bd);a8.lineTo(0.252*a7,0.37*bd);a8.stroke();a8.strokeStyle="rgba(255, 255, 255, 0.3)";a8.beginPath();a8.moveTo(0.252*a7,0.37*bd);a8.lineTo(0.752*a7,0.37*bd);a8.lineTo(0.752*a7,0.2*bd);a8.lineTo(a7,0.2*bd);a8.stroke()}else{be=a8.createRadialGradient(0.5*a7,0.2*bd,0,0.5*a7,0.2*bd,0.7*a7);be.addColorStop(0,U(bg.coronaColor,0).color);be.addColorStop(0.5,U(bg.coronaColor,0.3).color);be.addColorStop(0.7,U(bg.coronaColor,0.2).color);be.addColorStop(0.8,U(bg.coronaColor,0.1).color);be.addColorStop(0.85,U(bg.coronaColor,0.05).color);be.addColorStop(1,U(bg.coronaColor,0).color);a8.fillStyle=be;a8.beginPath();a8.arc(0.5*a7,0.2*bd,0.7*a7,0,Math.PI*2,true);a8.closePath();a8.fill()}};var bb=function(){D=a6[1];a8.beginPath();if(bc.state==="steady"){be=D.outerColor_ON;a8.fillStyle=be;a8.rect(0.128*a7,0.41*bd,0.744*a7,0.074*bd);a8.rect(0.128*a7,0.516*bd,0.744*a7,0.074*bd);a8.closePath();a8.fill()}else{be=a8.createLinearGradient(0,0.41*bd,0,0.41*bd+0.074*bd);be.addColorStop(0,"#323232");be.addColorStop(1,"#5c5c5c");a8.fillStyle=be;a8.rect(0.128*a7,0.41*bd,0.744*a7,0.074*bd);a8.closePath();a8.fill();be=a8.createLinearGradient(0,0.516*bd,0,0.516*bd+0.074*bd);be.addColorStop(0,"#323232");be.addColorStop(1,"#5c5c5c");a8.fillStyle=be;a8.rect(0.128*a7,0.516*bd,0.744*a7,0.074*bd);a8.closePath();a8.fill()}if(bc.state!=="steady"){a8.strokeStyle="rgba(0, 0, 0, 0.4)";a8.beginPath();a8.moveTo(0.128*a7,0.41*bd+0.074*bd);a8.lineTo(0.128*a7,0.41*bd);a8.lineTo(0.128*a7+0.744*a7,0.41*bd);a8.stroke();a8.beginPath();a8.moveTo(0.128*a7,0.516*bd+0.074*bd);a8.lineTo(0.128*a7,0.516*bd);a8.lineTo(0.128*a7+0.744*a7,0.516*bd);a8.stroke();a8.strokeStyle="rgba(255, 255, 255, 0.3)";a8.beginPath();a8.moveTo(0.128*a7+0.744*a7,0.41*bd);a8.lineTo(0.128*a7+0.744*a7,0.41*bd+0.074*bd);a8.lineTo(0.128*a7,0.41*bd+0.074*bd);a8.stroke();a8.beginPath();a8.moveTo(0.128*a7+0.744*a7,0.516*bd);a8.lineTo(0.128*a7+0.744*a7,0.516*bd+0.074*bd);a8.lineTo(0.128*a7,0.516*bd+0.074*bd);a8.stroke()}else{be=a8.createRadialGradient(0.5*a7,0.5*bd,0,0.5*a7,0.5*bd,0.7*a7);be.addColorStop(0,U(D.coronaColor,0).color);be.addColorStop(0.5,U(D.coronaColor,0.3).color);be.addColorStop(0.7,U(D.coronaColor,0.2).color);be.addColorStop(0.8,U(D.coronaColor,0.1).color);be.addColorStop(0.85,U(D.coronaColor,0.05).color);be.addColorStop(1,U(D.coronaColor,0).color);a8.fillStyle=be;a8.beginPath();a8.arc(0.5*a7,0.5*bd,0.7*a7,0,Math.PI*2,true);a8.closePath();a8.fill()}};var a5=function(){D=a6[2];if(bc.state==="down"){be=a8.createRadialGradient(0.5*a7,0.8*bd,0,0.5*a7,0.8*bd,0.5*a7);be.addColorStop(0,D.innerColor1_ON);be.addColorStop(0.2,D.innerColor2_ON);be.addColorStop(1,D.outerColor_ON)}else{be=a8.createLinearGradient(0,0.63*bd,0,bd);be.addColorStop(0,"#323232");be.addColorStop(1,"#5c5c5c")}a8.beginPath();a8.fillStyle=be;a8.moveTo(0.5*a7,bd);a8.lineTo(a7,0.8*bd);a8.lineTo(0.725*a7,0.8*bd);a8.lineTo(0.725*a7,0.63*bd);a8.lineTo(0.252*a7,0.63*bd);a8.lineTo(0.252*a7,0.8*bd);a8.lineTo(0,0.8*bd);a8.closePath();a8.fill();if(bc.state!=="down"){a8.strokeStyle="rgba(0, 0, 0, 0.4)";a8.beginPath();a8.moveTo(0,0.8*bd);a8.lineTo(0.252*a7,0.8*bd);a8.moveTo(0.252*a7,0.63*bd);a8.lineTo(0.752*a7,0.63*bd);a8.stroke();a8.beginPath();a8.moveTo(0.752*a7,0.8*bd);a8.lineTo(a7,0.8*bd);a8.stroke();a8.strokeStyle="rgba(255, 255, 255, 0.3)";a8.beginPath();a8.moveTo(0,0.8*bd);a8.lineTo(0.5*a7,bd);a8.lineTo(a7,0.8*bd);a8.stroke();a8.beginPath();a8.moveTo(0.752*a7,0.8*bd);a8.lineTo(0.752*a7,0.63*bd);a8.stroke()}else{be=a8.createRadialGradient(0.5*a7,0.8*bd,0,0.5*a7,0.8*bd,0.7*a7);be.addColorStop(0,U(D.coronaColor,0).color);be.addColorStop(0.5,U(D.coronaColor,0.3).color);be.addColorStop(0.7,U(D.coronaColor,0.2).color);be.addColorStop(0.8,U(D.coronaColor,0.1).color);be.addColorStop(0.85,U(D.coronaColor,0.05).color);be.addColorStop(1,U(D.coronaColor,0).color);a8.fillStyle=be;a8.beginPath();a8.arc(0.5*a7,0.8*bd,0.7*a7,0,Math.PI*2,true);a8.closePath();a8.fill()}};a8.save();a8.translate(a7*0.5,a7*0.5);switch(bc.state){case"up":a5();bb();ba();break;case"steady":a5();ba();bb();break;case"down":default:ba();bb();a5();break}return a9};var au=function(be,ba,a8,a5,a9,bb,a6,bc,bd,a7){a7=(undefined===a7?a7=steelseries.GaugeType.TYPE1:a7);be.save();be.textAlign=(bc?"center":"left");be.textBaseline="middle";be.strokeStyle=bb.labelColor.getRgbaColor();be.fillStyle=bb.labelColor.getRgbaColor();if(bc){be.font=0.046728*ba+"px sans-serif";be.fillText(a5,ba/2,a8*0.3,ba*0.3);be.fillText(a9,ba/2,a8*0.38,ba*0.3)}else{if(a6){be.font=0.1*ba+"px sans-serif";be.save();be.translate(0.671428*ba,0.1375*a8);be.rotate(1.570796);be.fillText(a5,0,0);be.translate(-0.671428*ba,-0.1375*a8);be.restore();be.font=0.071428*ba+"px sans-serif";if(bd){if(a7.type==="type2"){be.textAlign="right";be.fillText(a9,0.36*ba,a8*0.79,ba*0.25)}else{be.fillText(a9,0.63*ba,a8*0.85,ba*0.2)}}else{be.textAlign="center";if(a7.type==="type2"){be.fillText(a9,ba/2,a8*0.92,ba*0.2)}else{be.fillText(a9,ba/2,a8*0.89,ba*0.2)}}}else{be.font=0.035*ba+"px sans-serif";be.fillText(a5,ba*0.15,a8*0.25,ba*0.3);be.font=0.025*ba+"px sans-serif";be.fillText(a9,ba*0.0625,a8*0.7,ba*0.07)}}be.restore()};var k=r(12,12,function(bh){var bd=bh.canvas.width;var bb=bh.canvas.height;var ba=0;var a8=0;bh.save();bh.save();bh.beginPath();bh.rect(0,0,bd*0.5,bb*0.5);bh.closePath();bh.restore();var bc=bh.createLinearGradient(0,a8*bb,0,0.5*bb+a8*bb);bc.addColorStop(0,"rgb(35, 35, 35)");bc.addColorStop(1,"rgb(23, 23, 23)");bh.fillStyle=bc;bh.fill();bh.save();bh.beginPath();bh.rect(bd*0.083333,0,bd*0.333333,bb*0.416666);bh.closePath();bh.restore();ba=0.083333;a8=0;var a9=bh.createLinearGradient(0,a8*bb,0,0.416666*bb+a8*bb);a9.addColorStop(0,"rgb(38, 38, 38)");a9.addColorStop(1,"rgb(30, 30, 30)");bh.fillStyle=a9;bh.fill();bh.save();bh.beginPath();bh.rect(bd*0.5,bb*0.5,bd*0.5,bb*0.5);bh.closePath();bh.restore();ba=0.5;a8=0.5;var a6=bh.createLinearGradient(0,a8*bb,0,0.5*bb+a8*bb);a6.addColorStop(0,"rgb(35, 35, 35)");a6.addColorStop(1,"rgb(23, 23, 23)");bh.fillStyle=a6;bh.fill();bh.save();bh.beginPath();bh.rect(bd*0.583333,bb*0.5,bd*0.333333,bb*0.416666);bh.closePath();bh.restore();ba=0.583333;a8=0.5;var be=bh.createLinearGradient(0,a8*bb,0,0.416666*bb+a8*bb);be.addColorStop(0,"rgb(38, 38, 38)");be.addColorStop(1,"rgb(30, 30, 30)");bh.fillStyle=be;bh.fill();bh.save();bh.beginPath();bh.rect(bd*0.5,0,bd*0.5,bb*0.5);bh.closePath();bh.restore();ba=0.5;a8=0;var a5=bh.createLinearGradient(0,a8*bb,0,0.5*bb+a8*bb);a5.addColorStop(0,"#303030");a5.addColorStop(1,"rgb(40, 40, 40)");bh.fillStyle=a5;bh.fill();bh.save();bh.beginPath();bh.rect(bd*0.583333,bb*0.083333,bd*0.333333,bb*0.416666);bh.closePath();bh.restore();ba=0.583333;a8=0.083333;var bg=bh.createLinearGradient(0,a8*bb,0,0.416666*bb+a8*bb);bg.addColorStop(0,"rgb(53, 53, 53)");bg.addColorStop(1,"rgb(45, 45, 45)");bh.fillStyle=bg;bh.fill();bh.save();bh.beginPath();bh.rect(0,bb*0.5,bd*0.5,bb*0.5);bh.closePath();bh.restore();ba=0;a8=0.5;var bf=bh.createLinearGradient(0,a8*bb,0,0.5*bb+a8*bb);bf.addColorStop(0,"#303030");bf.addColorStop(1,"#282828");bh.fillStyle=bf;bh.fill();bh.save();bh.beginPath();bh.rect(bd*0.083333,bb*0.583333,bd*0.333333,bb*0.416666);bh.closePath();bh.restore();ba=0.083333;a8=0.583333;var a7=bh.createLinearGradient(0,a8*bb,0,0.416666*bb+a8*bb);a7.addColorStop(0,"#353535");a7.addColorStop(1,"#2d2d2d");bh.fillStyle=a7;bh.fill();bh.restore()});var ax=r(15,15,function(a7){var a9=a7.canvas.width;var a5=a7.canvas.height;a7.save();a7.save();a7.beginPath();a7.rect(0,0,a9,a5);a7.closePath();a7.restore();var a8="#1D2123";a7.fillStyle=a8;a7.fill();a7.save();a7.beginPath();a7.moveTo(0,a5*0.266666);a7.bezierCurveTo(0,a5*0.4,a9*0.066666,a5*0.466666,a9*0.2,a5*0.466666);a7.bezierCurveTo(a9*0.333333,a5*0.466666,a9*0.4,a5*0.4,a9*0.4,a5*0.266666);a7.bezierCurveTo(a9*0.4,a5*0.133333,a9*0.333333,a5*0.066666,a9*0.2,a5*0.066666);a7.bezierCurveTo(a9*0.066666,a5*0.066666,0,a5*0.133333,0,a5*0.266666);a7.closePath();var a6=a7.createLinearGradient(0,0.066666*a5,0,0.466666*a5);a6.addColorStop(0,"#000000");a6.addColorStop(1,"#444444");a7.fillStyle=a6;a7.fill();a7.save();a7.beginPath();a7.moveTo(0,a5*0.2);a7.bezierCurveTo(0,a5*0.333333,a9*0.066666,a5*0.4,a9*0.2,a5*0.4);a7.bezierCurveTo(a9*0.333333,a5*0.4,a9*0.4,a5*0.333333,a9*0.4,a5*0.2);a7.bezierCurveTo(a9*0.4,a5*0.066666,a9*0.333333,0,a9*0.2,0);a7.bezierCurveTo(a9*0.066666,0,0,a5*0.066666,0,a5*0.2);a7.closePath();var bc="#050506";a7.fillStyle=bc;a7.fill();a7.save();a7.beginPath();a7.moveTo(a9*0.466666,a5*0.733333);a7.bezierCurveTo(a9*0.466666,a5*0.866666,a9*0.533333,a5*0.933333,a9*0.666666,a5*0.933333);a7.bezierCurveTo(a9*0.8,a5*0.933333,a9*0.866666,a5*0.866666,a9*0.866666,a5*0.733333);a7.bezierCurveTo(a9*0.866666,a5*0.6,a9*0.8,a5*0.533333,a9*0.666666,a5*0.533333);a7.bezierCurveTo(a9*0.533333,a5*0.533333,a9*0.466666,a5*0.6,a9*0.466666,a5*0.733333);a7.closePath();var bb=a7.createLinearGradient(0,0.533333*a5,0,0.933333*a5);bb.addColorStop(0,"#000000");bb.addColorStop(1,"#444444");a7.fillStyle=bb;a7.fill();a7.save();a7.beginPath();a7.moveTo(a9*0.466666,a5*0.666666);a7.bezierCurveTo(a9*0.466666,a5*0.8,a9*0.533333,a5*0.866666,a9*0.666666,a5*0.866666);a7.bezierCurveTo(a9*0.8,a5*0.866666,a9*0.866666,a5*0.8,a9*0.866666,a5*0.666666);a7.bezierCurveTo(a9*0.866666,a5*0.533333,a9*0.8,a5*0.466666,a9*0.666666,a5*0.466666);a7.bezierCurveTo(a9*0.533333,a5*0.466666,a9*0.466666,a5*0.533333,a9*0.466666,a5*0.666666);a7.closePath();var ba="#050506";a7.fillStyle=ba;a7.fill();a7.restore()});var u=function(a7,a6,a8,a5,bc){this.fill=function(bB,bz,bg,be){bB=Math.floor(bB);bz=Math.floor(bz);bg=Math.ceil(bg);be=Math.ceil(be);var bw=bg-bB;var bs=be-bz;var bD=P(bw,bs);var bi=bD.getContext("2d");var bm=bi.createImageData(bw,bs);var bl=bi.createImageData(bw,bs);var bh=255;var bk=(a7>>16)&255;var br=(a7>>8)&255;var bd=a7&255;var bv=0;var bC=255*a8;if(bc!=0){var bt=[];for(var by=0;by<bw;by++){bt[by]=(255*bc*Math.sin(by/bw*Math.PI))|0}}for(var bp=0;bp<bs;bp++){if(a6!=0){var bo=0;var bu=0;var bx=0}for(var bq=0;bq<bw;bq++){var bE=(bp*bw*4)+(bq*4);var bf=bk;var bj=br;var bn=bd;if(bc!=0){var bA=bt[bq];bf+=bA;bj+=bA;bn+=bA}if(a5){bv=((2*Math.random()-1)*bC)|0;bm.data[bE]=ba(bf+bv);bm.data[bE+1]=ba(bj+bv);bm.data[bE+2]=ba(bn+bv);bm.data[bE+3]=bh}else{bm.data[bE]=a9(bf,bC);bm.data[bE+1]=a9(bj,bC);bm.data[bE+2]=a9(bn,bC);bm.data[bE+3]=bh}}}if(a6>0){bb(bm,bl,bw,bs,a6,bh);bi.putImageData(bl,bB,bz)}else{bi.putImageData(bm,bB,bz)}return bD};function a9(bd,be){bd+=((2*Math.random()-1)*be)|0;return(bd<0?0:(bd>255?255:bd))}function ba(bd){return(bd<0?0:(bd>255?255:bd))}function bb(bo,be,bd,bp,bk,bg){if(bk>=bd){bk=bd-1}var bf=1/(bk*2+1);var bj=0;for(var bm=0;bm<bp;bm++){var bq=0;var bi=0;var bl=0;for(var bn=0;bn<bk;bn++){var bh=(bj+bn)*4;bq+=bo.data[bh];bi+=bo.data[bh+1];bl+=bo.data[bh+2]}for(var bn=0;bn<bd;bn++){if(bn>bk){var bh=(bj-bk-1)*4;bq-=bo.data[bh];bi-=bo.data[bh+1];bl-=bo.data[bh+2]}if(bn+bk<bd){var bh=(bj+bk)*4;bq+=bo.data[bh];bi+=bo.data[bh+1];bl+=bo.data[bh+2]}var bh=bj*4;be.data[bh]=(bq*bf)|0;be.data[bh+1]=(bi*bf)|0;be.data[bh+2]=(bl*bf)|0;be.data[bh+3]=bg;bj++}}}return this};var Q=function(a5,ba,bb,bc){var a7;var a9;var bd;var a8;if(arguments.length===1){bb=parseInt(a5.substr(5,2),16);ba=parseInt(a5.substr(3,2),16);a5=parseInt(a5.substr(1,2),16);bc=1}else{if(arguments.length===3){bc=1}}a6();function a6(){a7=0>a5?0:a5;a7=255<a5?255:a5;a9=0>ba?0:ba;a9=255<ba?255:ba;bd=0>bb?0:bb;bd=255<bb?255:bb;a8=0>bc?0:bc;a8=1<bc?1:bc}this.getRed=function(){return a7};this.setRed=function(be){a7=0>be?0:be;a7=255<be?255:be};this.getGreen=function(){return a9};this.setGreen=function(be){a9=0>be?0:be;a9=255<be?255:be};this.getBlue=function(){return bd};this.setBlue=function(be){bd=0>be?0:be;bd=255<be?255:be};this.getAlpha=function(){return a8};this.setAlpha=function(be){a8=0>be?0:be;a8=1<be?1:be};this.getRgbaColor=function(){return"rgba("+a7+", "+a9+", "+bd+", "+a8+")"};this.getRgbColor=function(){return"rgb("+a7+", "+a9+", "+bd+")"};this.getHexColor=function(){return"#"+a7.toString(16)+a9.toString(16)+bd.toString(16)}};var aw=function(a7,a6,a5){a5=(a5===undefined?-Math.PI/2:a5);this.fill=function(bk,bc,bb,be,a8){var ba=2*Math.PI;var bh;var bf;var bi=180/Math.PI;var bg=be+(a8-be)*0.5;var bj=ba/Math.max(360,a8*2.2);bk.save();bk.lineWidth=1.5;bk.translate(bc,bb);bk.rotate(a5);bk.translate(-bc,-bb);for(var bd=0,bl=a7.length-1;bd<bl;bd++){bh=ba*a7[bd];bf=ba*a7[bd+1];range=bf-bh;startColor=a6[bd];stopColor=a6[bd+1];for(var a9=bh;a9<bf;a9+=bj){bk.beginPath();bk.fillStyle=aX(startColor,stopColor,range,(a9-bh)).getRgbaColor();bk.strokeStyle=bk.fillStyle;if(be>0){bk.arc(bc,bb,be,a9+bj,a9,true)}else{bk.moveTo(bc,bb)}bk.arc(bc,bb,a8,a9,a9+bj);bk.fill();bk.stroke()}}bk.restore()}};var M=function(a8,a6,a7,a5){this.getColorAt=function(be){be=(be<0?0:(be>1?1:be));var bd=0;var bg=0;var bc=1;var bf=1;var a9=0;var bb;for(bb=0;bb<a7.length;bb++){if(a7[bb]<be&&bd<a7[bb]){bd=a7[bb];bg=bb}if(a7[bb]==be){return a5[bb]}if(a7[bb]>be&&bc>=a7[bb]){bc=a7[bb];bf=bb}}var ba=(be-bd)/(bc-bd);return aX(a5[bg],a5[bf],1,ba)};this.getStart=function(){return a8};this.getEnd=function(){return a6}};function U(a7,ba){var a6=("#"===a7.charAt(0))?a7.substring(1,7):a7;var a9=parseInt((a6).substring(0,2),16);var a8=parseInt((a6).substring(2,4),16);var a5=parseInt((a6).substring(4,6),16);this.color="rgba("+a9+","+a8+","+a5+","+ba+")";return this}function aX(a9,bd,bb,bk){var be=1/255;var bh=a9.getRed();var ba=a9.getGreen();var bi=a9.getBlue();var a8=a9.getAlpha();var bl=bd.getRed()-a9.getRed();var a6=bd.getGreen()-a9.getGreen();var a7=bd.getBlue()-a9.getBlue();var a5=bd.getAlpha()*be-a9.getAlpha()*be;var bc=bl/bb;var bg=a6/bb;var bj=a7/bb;var bf=a5/bb;return new Q((bh+bc*bk).toFixed(0),(ba+bg*bk).toFixed(0),(bi+bj*bk).toFixed(0),a8+bf*bk)}function aG(a7,a6,a5){return{start:a7,stop:a6,color:a5}}Math.log10=function(a5){return(Math.log(a5)/Math.LN10)};function l(a6,a5){var a9=Math.floor(Math.log10(a6));var a8=a6/Math.pow(10,a9);var a7;if(a5){if(1.5>a8){a7=1}else{if(3>a8){a7=2}else{if(7>a8){a7=5}else{a7=10}}}}else{if(1>=a8){a7=1}else{if(2>=a8){a7=2}else{if(5>=a8){a7=5}else{a7=10}}}}return a7*Math.pow(10,a9)}function V(a9,a7,bc,a8,ba,a6){var bb=a7+a8;var a5=bc+ba;a9.beginPath();a9.moveTo(a7+a6,bc);a9.lineTo(bb-a6,bc);a9.quadraticCurveTo(bb,bc,bb,bc+a6);a9.lineTo(bb,bc+ba-a6);a9.quadraticCurveTo(bb,a5,bb-a6,a5);a9.lineTo(a7+a6,a5);a9.quadraticCurveTo(a7,a5,a7,a5-a6);a9.lineTo(a7,bc+a6);a9.quadraticCurveTo(a7,bc,a7+a6,bc);a9.closePath();a9.stroke()}function P(a7,a5){var a6=H.createElement("canvas");a6.width=a7;a6.height=a5;return a6}function r(a7,a5,a8){var a6=H.createElement("canvas");a6.width=a7;a6.height=a5;a8(a6.getContext("2d"));return a6}function aI(a5){return GLOBAL_getColorValues(a5)}function x(a9){var a6;var bc;var a7;var ba;var bb;var a8=aI(a9);var a5=new Q(a8[0],a8[1],a8[2],a8[3]);a6=aY(a5,0.32);bc=aY(a5,0.62);a7=aD(a5,0.84);ba=aD(a5,0.94);bb=aD(a5,1);return new z(a6,bc,a5,a7,ba,bb)}function az(a5,a6,bb){a5/=255;a6/=255;bb/=255;var ba=Math.max(a5,a6,bb);var a7=Math.min(a5,a6,bb);var a9;var a8;var bd=(ba+a7)/2;if(ba===a7){a9=a8=0}else{var bc=ba-a7;a8=bd>0.5?bc/(2-ba-a7):bc/(ba+a7);switch(ba){case a5:a9=(a6-bb)/bc+(a6<bb?6:0);break;case a6:a9=(bb-a5)/bc+2;break;case bb:a9=(a5-a6)/bc+4;break}a9/=6}return[a9,a8,bd]}function n(bb,ba,bd){var a8;var a9;var bc;function a7(bg,bf,be){if(be<0){be+=1}if(be>1){be-=1}if(be<1/6){return bg+(bf-bg)*6*be}if(be<1/2){return bf}if(be<2/3){return bg+(bf-bg)*(2/3-be)*6}return bg}if(ba===0){a8=a9=bc=bd}else{var a5=(bd<0.5?bd*(1+ba):bd+ba-bd*ba);var a6=2*bd-a5;a8=a7(a6,a5,bb+1/3);a9=a7(a6,a5,bb);bc=a7(a6,a5,bb-1/3)}return[Math.floor(a8*255),Math.floor(a9*255),Math.floor(bc*255)]}function aR(a5,a6,a7){var a8=(a7-a6)/2;a8=(a8>1?1:(a8<0?0:a8));return[a5,a6,a8]}function Z(a5,a6,a8){var a7=(a8*2)+a6;return[a5,a6,a7]}function O(bb,a9,bd){var a5,ba,be;var a8=Math.floor(bb*6);var bc=bb*6-a8;var a7=bd*(1-a9);var a6=bd*(1-bc*a9);var bf=bd*(1-(1-bc)*a9);switch(a8%6){case 0:a5=bd;ba=bf;be=a7;break;case 1:a5=a6;ba=bd;be=a7;break;case 2:a5=a7;ba=bd;be=bf;break;case 3:a5=a7;ba=a6;be=bd;break;case 4:a5=bf;ba=a7;be=bd;break;case 5:a5=bd;ba=a7;be=a6;break}return[Math.floor(a5*255),Math.floor(ba*255),Math.floor(be*255)]}function aE(a5,a8,bb){a5=a5/255;a8=a8/255;bb=bb/255;var bc=Math.max(a5,a8,bb);var a6=Math.min(a5,a8,bb);var a9;var a7;var ba=bc;var bd=bc-a6;a7=bc==0?0:bd/bc;if(bc==a6){a9=0}else{switch(bc){case a5:a9=(a8-bb)/bd+(a8<bb?6:0);break;case a8:a9=(bb-a5)/bd+2;break;case bb:a9=(a5-a8)/bd+4;break}a9/=6}return[a9,a7,ba]}function aY(a6,a7){var a9=Math.floor(a6.getRed()*(1-a7));var a8=Math.floor(a6.getGreen()*(1-a7));var a5=Math.floor(a6.getBlue()*(1-a7));a9=(a9<0?0:(a9>255?255:a9));a8=(a8<0?0:(a9>255?255:a8));a5=(a5<0?0:(a5>255?255:a5));return new Q(a9,a8,a5,a6.getAlpha())}function aD(a6,a7){var a9=Math.round(a6.getRed()*(1+a7));var a8=Math.round(a6.getGreen()*(1+a7));var a5=Math.round(a6.getBlue()*(1+a7));a9=(a9<0?0:(a9>255?255:a9));a8=(a8<0?0:(a9>255?255:a8));a5=(a5<0?0:(a5>255?255:a5));return new Q(a9,a8,a5,a6.getAlpha())}function s(a7,a5,a6){if(a6<=a5){throw"Rotary bounds are of negative or zero size"}var a9=a6-a5;var a8=Math.floor((a7-a5)/a9);return a7-(a8*a9)}function ap(a6,a5){return s((a5-a6),-180,180)}function al(bf,be,bb,a5){bf.save();var a6=P(be,bb);var bk=a6.getContext("2d");var bc;var ba;for(var bg=0;bg<2;bg++){bc=bf.getImageData(0,0,(bg===0?be:bb),(bg===0?bb:be));ba=bf.createImageData((bg===0?be:bb),(bg===0?bb:be));if(bg===0){if(a5>=be){a5=be-1}}else{if(a5>=bb){a5=bb-1}}var bl=1/(a5*2+1);var bm=0;for(var a8=0;a8<(bg===0?bb:be);a8++){var a7=0;var bd=0;var bi=0;var bj=0;for(var a9=0;a9<a5;a9++){var bh=(bm+a9)*4;a7+=bc.data[bh];bd+=bc.data[bh+1];bi+=bc.data[bh+2];bj+=bc.data[bh+3]}for(var a9=0;a9<(bg===0?be:bb);a9++){if(a9>a5){var bh=(bm-a5-1)*4;a7-=bc.data[bh];bd-=bc.data[bh+1];bi-=bc.data[bh+2];bj-=bc.data[bh+3]}if(a9+a5<be){var bh=(bm+a5)*4;a7+=bc.data[bh];bd+=bc.data[bh+1];bi+=bc.data[bh+2];bj+=bc.data[bh+3]}var bh=bm*4;ba.data[bh]=(a7*bl)|0;ba.data[bh+1]=(bd*bl)|0;ba.data[bh+2]=(bi*bl)|0;ba.data[bh+3]=(bj*bl)|0;bm++}}bk.clearRect(0,0,be,bb);bk.putImageData(ba,0,0);if(bg===0){bf.clearRect(0,0,be,bb);bf.translate(be/2,bb/2);bf.rotate(Math.PI/2);bf.translate(-be/2,-bb/2);bf.drawImage(a6,0,0)}}bf.translate(be/2,bb/2);bf.rotate(-Math.PI);bf.translate(-be/2,-bb/2);bf.clearRect(0,0,be,bb);bf.drawImage(a6,0,0);bf.restore()}var d;(function(){d=function(a9,a7,a5,a8,a6){this.gradientStart=a9;this.gradientFraction=a7;this.gradientStop=a5;this.labelColor=a8;this.symbolColor=a6}}());var q;(function(){q=function(a5,a8,a7,a6,ba,a9){this.gradientStartColor=a5;this.gradientFraction1Color=a8;this.gradientFraction2Color=a7;this.gradientFraction3Color=a6;this.gradientStopColor=ba;this.textColor=a9}}());var z;(function(){z=function(ba,a9,a7,a6,a5,a8){this.veryDark=ba;this.dark=a9;this.medium=a7;this.light=a6;this.lighter=a5;this.veryLight=a8}}());var B;(function(){B=function(a7,a5,bb,a9,a8,a6,ba){this.innerColor1_ON=a7;this.innerColor2_ON=a5;this.outerColor_ON=bb;this.coronaColor=a9;this.innerColor1_OFF=a8;this.innerColor2_OFF=a6;this.outerColor_OFF=ba}}());var ar;(function(){ar=function(a5){this.type=a5}}());var aT;(function(){aT=function(a5){this.type=a5}}());var ai;(function(){ai=function(a5){this.type=a5}}());var aL;(function(){aL=function(a5){this.style=a5}}());var a;(function(){a=function(a5){this.design=a5}}());var aK;(function(){aK=function(a5){this.type=a5}}());var e;(function(){e=function(a5){this.type=a5}}());var a0;(function(){a0=function(a5){this.format=a5}}());var c;(function(){c=function(a5){this.type=a5}}());var m;(function(){m=function(a5){this.state=a5}}());var y={DARK_GRAY:new d(new Q(0,0,0,1),new Q(51,51,51,1),new Q(153,153,153,1),new Q(255,255,255,1),new Q(180,180,180,1)),SATIN_GRAY:new d(new Q(45,57,57,1),new Q(45,57,57,1),new Q(45,57,57,1),new Q(167,184,180,1),new Q(137,154,150,1)),LIGHT_GRAY:new d(new Q(130,130,130,1),new Q(181,181,181,1),new Q(253,253,253,1),new Q(0,0,0,1),new Q(80,80,80,1)),WHITE:new d(new Q(255,255,255,1),new Q(255,255,255,1),new Q(255,255,255,1),new Q(0,0,0,1),new Q(80,80,80,1)),BLACK:new d(new Q(0,0,0,1),new Q(0,0,0,1),new Q(0,0,0,1),new Q(255,255,255,1),new Q(150,150,150,1)),BEIGE:new d(new Q(178,172,150,1),new Q(204,205,184,1),new Q(231,231,214,1),new Q(0,0,0,1),new Q(80,80,80,1)),BROWN:new d(new Q(245,225,193,1),new Q(245,225,193,1),new Q(255,250,240,1),new Q(109,73,47,1),new Q(89,53,27,1)),RED:new d(new Q(198,93,95,1),new Q(212,132,134,1),new Q(242,218,218,1),new Q(0,0,0,1),new Q(90,0,0,1)),GREEN:new d(new Q(65,120,40,1),new Q(129,171,95,1),new Q(218,237,202,1),new Q(0,0,0,1),new Q(0,90,0,1)),BLUE:new d(new Q(45,83,122,1),new Q(115,144,170,1),new Q(227,234,238,1),new Q(0,0,0,1),new Q(0,0,90,1)),ANTHRACITE:new d(new Q(50,50,54,1),new Q(47,47,51,1),new Q(69,69,74,1),new Q(250,250,250,1),new Q(180,180,180,1)),MUD:new d(new Q(80,86,82,1),new Q(70,76,72,1),new Q(57,62,58,1),new Q(255,255,240,1),new Q(225,225,210,1)),PUNCHED_SHEET:new d(new Q(50,50,54,1),new Q(47,47,51,1),new Q(69,69,74,1),new Q(255,255,255,1),new Q(180,180,180,1)),CARBON:new d(new Q(50,50,54,1),new Q(47,47,51,1),new Q(69,69,74,1),new Q(255,255,255,1),new Q(180,180,180,1)),STAINLESS:new d(new Q(130,130,130,1),new Q(181,181,181,1),new Q(253,253,253,1),new Q(0,0,0,1),new Q(80,80,80,1)),BRUSHED_METAL:new d(new Q(50,50,54,1),new Q(47,47,51,1),new Q(69,69,74,1),new Q(0,0,0,1),new Q(80,80,80,1)),BRUSHED_STAINLESS:new d(new Q(50,50,54,1),new Q(47,47,51,1),new Q(110,110,112,1),new Q(0,0,0,1),new Q(80,80,80,1)),TURNED:new d(new Q(130,130,130,1),new Q(181,181,181,1),new Q(253,253,253,1),new Q(0,0,0,1),new Q(80,80,80,1))};var av={BEIGE:new q("#c8c8b1","rgb(241, 237, 207)","rgb(234, 230, 194)","rgb(225, 220, 183)","rgb(237, 232, 191)","#000000"),BLUE:new q("#ffffff","rgb(231, 246, 255)","rgb(170, 224, 255)","rgb(136, 212, 255)","rgb(192, 232, 255)","#124564"),ORANGE:new q("#ffffff","rgb(255, 245, 225)","rgb(255, 217, 147)","rgb(255, 201, 104)","rgb(255, 227, 173)","#503700"),RED:new q("#ffffff","rgb(255, 225, 225)","rgb(253, 152, 152)","rgb(252, 114, 115)","rgb(254, 178, 178)","#4f0c0e"),YELLOW:new q("#ffffff","rgb(245, 255, 186)","rgb(210, 255, 0)","rgb(158, 205, 0)","rgb(210, 255, 0)","#405300"),WHITE:new q("#ffffff","#ffffff","rgb(241, 246, 242)","rgb(229, 239, 244)","#ffffff","#000000"),GRAY:new q("#414141","rgb(117, 117, 117)","rgb(87, 87, 87)","#414141","rgb(81, 81, 81)","#ffffff"),BLACK:new q("#414141","#666666","#333333","#000000","#333333","#cccccc"),GREEN:new q("rgb(33, 67, 67)","rgb(33, 67, 67)","rgb(29, 58, 58)","rgb(28, 57, 57)","rgb(23, 46, 46)","rgba(0, 185, 165, 255)"),BLUE2:new q("rgb(0, 68, 103)","rgb(8, 109, 165)","rgb(0, 72, 117)","rgb(0, 72, 117)","rgb(0, 68, 103)","rgb(111, 182, 228)"),BLUE_BLACK:new q("rgb(22, 125, 212)","rgb(3, 162, 254)","rgb(3, 162, 254)","rgb(3, 162, 254)","rgb(11, 172, 244)","#000000"),BLUE_DARKBLUE:new q("rgb(18, 33, 88)","rgb(18, 33, 88)","rgb(19, 30, 90)","rgb(17, 31, 94)","rgb(21, 25, 90)","rgb(23, 99, 221)"),BLUE_GRAY:new q("rgb(135, 174, 255)","rgb(101, 159, 255)","rgb(44, 93, 255)","rgb(27, 65, 254)","rgb(12, 50, 255)","#b2b4ed"),STANDARD:new q("rgb(131, 133, 119)","rgb(176, 183, 167)","rgb(165, 174, 153)","rgb(166, 175, 156)","rgb(175, 184, 165)","rgb(35, 42, 52)"),STANDARD_GREEN:new q("#ffffff","rgb(219, 230, 220)","rgb(179, 194, 178)","rgb(153, 176, 151)","rgb(114, 138, 109)","#080C06"),BLUE_BLUE:new q("rgb(100, 168, 253)","rgb(100, 168, 253)","rgb(95, 160, 250)","rgb(80, 144, 252)","rgb(74, 134, 255)","#002cbb"),RED_DARKRED:new q("rgb(72, 36, 50)","rgb(185, 111, 110)","rgb(148, 66, 72)","rgb(83, 19, 20)","rgb(7, 6, 14)","#FE8B92"),DARKBLUE:new q("rgb(14, 24, 31)","rgb(46, 105, 144)","rgb(19, 64, 96)","rgb(6, 20, 29)","rgb(8, 9, 10)","#3DB3FF"),LILA:new q("rgb(175, 164, 255)","rgb(188, 168, 253)","rgb(176, 159, 255)","rgb(174, 147, 252)","rgb(168, 136, 233)","#076148"),BLACKRED:new q("rgb(8, 12, 11)","rgb(10, 11, 13)","rgb(11, 10, 15)","rgb(7, 13, 9)","rgb(9, 13, 14)","#B50026"),DARKGREEN:new q("rgb(25, 85, 0)","rgb(47, 154, 0)","rgb(30, 101, 0)","rgb(30, 101, 0)","rgb(25, 85, 0)","#233123"),AMBER:new q("rgb(182, 71, 0)","rgb(236, 155, 25)","rgb(212, 93, 5)","rgb(212, 93, 5)","rgb(182, 71, 0)","#593A0A"),LIGHTBLUE:new q("rgb(125, 146, 184)","rgb(197, 212, 231)","rgb(138, 155, 194)","rgb(138, 155, 194)","rgb(125, 146, 184)","#090051"),SECTIONS:new q("#b2b2b2","#ffffff","#c4c4c4","#c4c4c4","#b2b2b2","#000000")};var v={RED:new z(new Q(82,0,0,1),new Q(158,0,19,1),new Q(213,0,25,1),new Q(240,82,88,1),new Q(255,171,173,1),new Q(255,217,218,1)),GREEN:new z(new Q(8,54,4,1),new Q(0,107,14,1),new Q(15,148,0,1),new Q(121,186,37,1),new Q(190,231,141,1),new Q(234,247,218,1)),BLUE:new z(new Q(0,11,68,1),new Q(0,73,135,1),new Q(0,108,201,1),new Q(0,141,242,1),new Q(122,200,255,1),new Q(204,236,255,1)),ORANGE:new z(new Q(118,83,30,1),new Q(215,67,0,1),new Q(240,117,0,1),new Q(255,166,0,1),new Q(255,255,128,1),new Q(255,247,194,1)),YELLOW:new z(new Q(41,41,0,1),new Q(102,102,0,1),new Q(177,165,0,1),new Q(255,242,0,1),new Q(255,250,153,1),new Q(255,252,204,1)),CYAN:new z(new Q(15,109,109,1),new Q(0,109,144,1),new Q(0,144,191,1),new Q(0,174,239,1),new Q(153,223,249,1),new Q(204,239,252,1)),MAGENTA:new z(new Q(98,0,114,1),new Q(128,24,72,1),new Q(191,36,107,1),new Q(255,48,143,1),new Q(255,172,210,1),new Q(255,214,23,1)),WHITE:new z(new Q(210,210,210,1),new Q(220,220,220,1),new Q(235,235,235,1),new Q(255,255,255,1),new Q(255,255,255,1),new Q(255,255,255,1)),GRAY:new z(new Q(25,25,25,1),new Q(51,51,51,1),new Q(76,76,76,1),new Q(128,128,128,1),new Q(204,204,204,1),new Q(243,243,243,1)),BLACK:new z(new Q(0,0,0,1),new Q(5,5,5,1),new Q(10,10,10,1),new Q(15,15,15,1),new Q(20,20,20,1),new Q(25,25,25,1)),RAITH:new z(new Q(0,32,65,1),new Q(0,65,125,1),new Q(0,106,172,1),new Q(130,180,214,1),new Q(148,203,242,1),new Q(191,229,255,1)),GREEN_LCD:new z(new Q(0,55,45,1),new Q(15,109,93,1),new Q(0,185,165,1),new Q(48,255,204,1),new Q(153,255,227,1),new Q(204,255,241,1)),JUG_GREEN:new z(new Q(0,56,0,1),new Q(32,69,36,1),new Q(50,161,0,1),new Q(129,206,0,1),new Q(190,231,141,1),new Q(234,247,218,1))};var D={RED_LED:new B("#FF9A89","#FF9A89","#FF3300","#FF8D70","#7E1C00","#7E1C00","#641B00"),GREEN_LED:new B("#9AFF89","#9AFF89","#59FF2A","#A5FF00","#1C7E00","#1C7E00","#1B6400"),BLUE_LED:new B("#899AFF","#899AFF","#0033FF","#708DFF","#001C7E","#001C7E","#001B64"),ORANGE_LED:new B("#FEA23F","#FEA23F","#FD6C00","#FD6C00","#592800","#592800","#421F00"),YELLOW_LED:new B("#FFFF62","#FFFF62","#FFFF00","#FFFF00","#6B6D00","#6B6D00","#515300"),CYAN_LED:new B("#00FFFF","#00FFFF","#1BC3C3","#00FFFF","#083B3B","#083B3B","#052727"),MAGENTA_LED:new B("#D300FF","#D300FF","#8600CB","#C300FF","#38004B","#38004B","#280035")};var R={TYPE1:new ar("type1"),TYPE2:new ar("type2"),TYPE3:new ar("type3"),TYPE4:new ar("type4"),TYPE5:new ar("type5")};var aF={NORTH:new aT("north"),SOUTH:new aT("south"),EAST:new aT("east"),WEST:new aT("west")};var aU={STANDARD_KNOB:new ai("standardKnob"),METAL_KNOB:new ai("metalKnob")};var aa={BLACK:new aL("black"),BRASS:new aL("brass"),SILVER:new aL("silver")};var aV={BLACK_METAL:new a("blackMetal"),METAL:new a("metal"),SHINY_METAL:new a("shinyMetal"),BRASS:new a("brass"),STEEL:new a("steel"),CHROME:new a("chrome"),GOLD:new a("gold"),ANTHRACITE:new a("anthracite"),TILTED_GRAY:new a("tiltedGray"),TILTED_BLACK:new a("tiltedBlack"),GLOSSY_METAL:new a("glossyMetal")};var aB={TYPE1:new aK("type1"),TYPE2:new aK("type2"),TYPE3:new aK("type3"),TYPE4:new aK("type4"),TYPE5:new aK("type5"),TYPE6:new aK("type6"),TYPE7:new aK("type7"),TYPE8:new aK("type8"),TYPE9:new aK("type9"),TYPE10:new aK("type10"),TYPE11:new aK("type11"),TYPE12:new aK("type12"),TYPE13:new aK("type13"),TYPE14:new aK("type14"),TYPE15:new aK("type15"),TYPE16:new aK("type16")};var aQ={TYPE1:new e("type1"),TYPE2:new e("type2"),TYPE3:new e("type3"),TYPE4:new e("type4"),TYPE5:new e("type5")};var A={STANDARD:new a0("standard"),FRACTIONAL:new a0("fractional"),SCIENTIFIC:new a0("scientific")};var af={NORMAL:new c("normal"),HORIZONTAL:new c("horizontal"),TANGENT:new c("tangent")};var aP={UP:new m("up"),STEADY:new m("steady"),DOWN:new m("down"),OFF:new m("off")};return{FrameDesignDef:a,CarbonBuffer:k,PunchedSheetBuffer:ax,BrushedMetalTexture:u,Radial:ac,RadialBargraph:E,RadialVertical:ah,Linear:S,LinearBargraph:F,DisplaySingle:o,DisplayMulti:X,Level:at,Compass:aA,WindDirection:N,Horizon:an,Led:ay,Clock:f,Battery:ag,StopWatch:ak,Altimeter:a4,TrafficLight:aO,LightBulb:T,Odometer:aJ,drawFrame:g,drawBackground:a2,drawForeground:G,rgbaColor:Q,conicalGradient:aw,setAlpha:U,getColorFromFraction:aX,gradientWrapper:M,BackgroundColor:y,LcdColor:av,ColorDef:v,LedColor:D,GaugeType:R,Orientation:aF,FrameDesign:aV,PointerType:aB,ForegroundType:aQ,KnobType:aU,KnobStyle:aa,LabelNumberFormat:A,TickLabelOrientation:af,TrendState:aP,Section:aG}}();