/* FakeOptionsInput.js
 * 	Based on OptionsInput.js
 * 
 * 	Used to provide CheckBoxGroup & RadioButtonGroup widgets a similar interface to that of DropDownSelect
 *  (Specifically to ease InlineEdit / SmartInput creation)
 *  
 *  NOTE: 08/10/2012 RadioButtonGroup 
 *  
 */

define([
	"dojo/_base/declare",
	"davinci/ve/input/SmartInput",
	"davinci/ve/commands/ModifyCommand",
	"davinci/ve/commands/RemoveCommand",
	"davinci/ve/widget"
], function(
	declare,
	SmartInput,
	ModifyCommand,
	RemoveCommand,
	Widget
) {

return declare(SmartInput, {
	// SmartInput properties
	property: "labels", // was value
	displayOnCreate: "true",
	multiLine: "true",
	format: "rows",
	
	serialize: function(widget, updateEditBoxValue, value) {
		var data = widget.getData(),
		    children = data.children,
		    result = [],
			type = widget.dijitWidget.declaredClass.match(/CheckBoxGroup/) ? "checkboxgroup" : "radiobuttongroup";
		
		if (type == "checkboxgroup") {
			for (var i = 0; i < children.length; i++) {
				var child = children[i];
				
				var text = child.label; // SGE: NEW: cbg specific!!! (was child)
				var selected = child.selected || false; // SGE: NEW: cbg specifc!!! (was widget.dijitWidget.values[i])
				
				text = dojox.html.entities.decode(text);
				var selText = selected ? "+" : "";
				
				result.push(selText + text);
				//result.push({ text: selText + text, selected: selected });
			}
			
		} else { // radiobuttongroup
			for (var i = 0; i < children.length; i++) {
				var child = children[i];
				
				var text = dojox.html.entities.decode(child.label);
				var selected = child.selected || false;
				
				result.push(text);
				
				//if (selected) widget.dijitWidget.set("selection", i); // ?
			}
		}
		
		result = this.serializeItems(result);

		updateEditBoxValue(result);
	},
	
	parse: function(input) {
		var value = this.parseItems(input),
		    type = this._widget.dijitWidget.declaredClass.match(/CheckBoxGroup/) ? "checkboxgroup" : "radiobuttongroup";

		for (var x = 0; x < value.length; x++) {
			value[x].text = dojox.html.entities.encode(value[x].text);

			if (value[x].selected) {
				if (type == "checkboxgroup") {
					this._widget.dijitWidget._changeCheckedState(x, true);
					
				} else { // radiobuttongroup
					this._widget.dijitWidget.set("selection", x);
				}
			}
		}

		return value;
	},

/* ********************************************
 * See CheckBoxInput.js and/or RadioBoxInput.js
 * 
 *	getProperties: function(widget, values) {
 *		return this.inherited(arguments);
 *	},
 * ********************************************/
	
	update: function(widget, values) {
		var data = widget.getData(),
		    children = data.children,
		    newLabels = [],
		    newValues = []
		;
		
		for (var i=0; i<values.length;i++) {
			newLabels.push(dojox.html.entities.decode( values[i].text) );
			newValues.push(values[i].selected);
		}
		
		widget.dijitWidget.set("labels", newLabels);
		widget.dijitWidget.set("values", newValues);

		var command = new ModifyCommand(widget, this.getProperties(widget, values), children);
		this._getContext().getCommandStack().execute(command);

		return command.newWidget;
	},

	_getEditor: function() {
		return top.davinci && top.davinci.Runtime && top.davinci.Runtime.currentEditor;
	},
	
	_getContext: function() {
		var editor = this._getEditor();
		return editor && (editor.getContext && editor.getContext() || editor.context);
	}

});

});