define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"davinci/ve/input/SmartInput",
	"davinci/ve/commands/ModifyCommand",
	"davinci/ve/commands/RemoveCommand",
	"davinci/ve/widget",
	"gc/dijit/libs/tools"
], function(
	declare,
	lang,
	SmartInput,
	ModifyCommand,
	RemoveCommand,
	Widget,
	tools
) {

return declare(SmartInput, {

	property: "labels",
	
	displayOnCreate: "true",
	
	multiLine: "true",
	
	format: "rows",
	
	serialize: function(widget, updateEditBoxValue, value) {
		var result;
		if(tools.isArray(value))
			result=value;
		else
			result=value.split(",");
		result = this.serializeItems(result);
		updateEditBoxValue(result); 
	},
	
	
	update: function(widget, values) {
		var labels=values.replace(/\n/g,",");
		var command = new ModifyCommand(widget, {labels:labels});
		this._getContext().getCommandStack().execute(command);
		return command.newWidget;
	},

	_getEditor: function() {
		return top.davinci && top.davinci.Runtime && top.davinci.Runtime.currentEditor;
	},
	
	_getContext: function() {
		var editor = this._getEditor();
		return editor && (editor.getContext && editor.getContext() || editor.context);
	}

});

});