define([
	"dojo/_base/declare",
	"./FakeOptionsInput",
	"dojo/i18n!./nls/dijit"
], function(
	declare,
	FakeOptionsInput,
	dijitNls
) {

return declare(FakeOptionsInput, {
	supportsHTML: false,
	helpText: "Enter a label for each RadioButton to be added, one per line.",
	
	constructor : function() {
		//this.helpText = dijitNls.selectInputHelp;
	},
	
	getProperties: function(widget, options) {
		var r = {
		    labels: [],
		    selection: 0
		};

		for (var i=0; i<options.length; i++) {
			r.labels.push( dojox.html.entities.decode(options[i].text) );
			if (options[i].selected) r.selection = i;
		}
		
		return r;
	}
});

});