//*****************************************************************************
//
// hello.c - Simple hello world example.
//
// Copyright (c) 2013-2014 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.1.0.12573 of the EK-TM4C1294XL Firmware Package.
//
//*****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "drivers/pinout.h"
#include "driverlib/pin_map.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "utils/uartstdio.h"
#include "string.h"


void load_params_to_string(void);

//*****************************************************************************
//
//! \addtogroup example_list
//! <h1>Hello World (hello)</h1>
//!
//! A very simple ``hello world'' example.  It simply displays ``Hello World!''
//! on the UART and is a starting point for more complicated applications.
//!
//! Open a terminal with 115,200 8-N-1 to see the output for this demo.
//
//*****************************************************************************

//*****************************************************************************
//
// System clock rate in Hz.
//
//*****************************************************************************
uint32_t g_ui32SysClock;
long long int length;
char r[]="ewewewtyrtf",r1[]="123",a[]="     ";
uint8_t len;

//*****************************************************************************
//
// The error routine that is called if the driver library encounters an error.
//
//*****************************************************************************
#ifdef DEBUG
void
__error__(char *pcFilename, uint32_t ui32Line)
{
}
#endif

//*****************************************************************************
//
// Configure the UART and its pins.  This must be called before UARTprintf().
//
//*****************************************************************************
void
ConfigureUART(void)
{
    //
    // Enable the GPIO Peripheral used by the UART.
    //
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

    //
    // Enable UART0
    //
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);

    //
    // Configure GPIO Pins for UART mode.
    //
    ROM_GPIOPinConfigure(GPIO_PA0_U0RX);
    ROM_GPIOPinConfigure(GPIO_PA1_U0TX);
    ROM_GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

    //
    // Initialize the UART for console I/O.
    //
    UARTStdioConfig(0, 115200, g_ui32SysClock);
}


//****************************************************************************

int n_tu(int number, int count)
{
 int result=1;
 while(count-- > 0)
 result *=number;

 return result;
 }


void float_to_string(double f, char *ch)
{
	long long int  length2, i, number, position, sign;
	double number2;

	sign=-1;   // -1 == positive number
	if (f <0)
	{
	sign='-';
	f *= -1;
	}


	number2=f;
	number=f;
	length=0;  // size of decimal part
	length2=0; //  size of tenth




	/* calculate length2 tenth part*/
	while( (number2 - (double)number) != 0.0  && !((number2 - (double)number) < 0.0) )
	{

	number2= f * (n_tu(10.0,length2+1));
	number=number2;

	length2++;

	}

	 /* calculate length decimal part*/
	for(length=(f> 1) ? 0 : 1; f > 1; length++)
			  f /= 10;

	position=length;

	 length=length+1+length2;
	 number=number2;

   //  UARTprintf("\n length:: %d",(length+'0'));

	 if(sign=='-')
	 {
	 length++;
	 position++;
	 }
	 position=length-position;

	 number=number2;
	 if(length2==0)
	 {
		 length++;
		 number=number*10;
		 position++;
	 }

	 for(i=0; i <= length ; i++)
	 {
	  if(i== (0)){
		*ch ='|';

	}else if(i==(position)){
		*ch='.';

	}else if(sign=='-' && i==length){
		*ch='-';

	}else
	{
		*ch= (number % 10)+'0';
	  number /=10;

	}
	   *ch++;

	}
	 len=length;
	 return(len);
}


void reverse(char *ch)
{
   int length, c;
   char *begin, *end, temp;

   length = string_length(ch);//strlen(ch);
   begin  = ch;
   end    = ch;

   for (c = 0; c < length - 1; c++)
      end++;

   for (c = 0; c < length/2; c++)
   {
      temp   = *end;
      *end   = *begin;
      *begin = temp;

      begin++;
      end--;
   }
}

int string_length(char *pointer)
{
   int c = 0;

   while( *(pointer + c) != '\0' )
      c++;

   return c;
}

void load_Params_to_String(void)
{

}


//*****************************************************************************
//
// Print "Hello World!" to the UART on the Intelligent UART Module.
//
//*****************************************************************************
int
main(void)
{


    //
    // Run from the PLL at 120 MHz.
    //
    g_ui32SysClock = MAP_SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ |
                SYSCTL_OSC_MAIN | SYSCTL_USE_PLL |
                SYSCTL_CFG_VCO_480), 120000000);

    //
    // Configure the device pins.
    //
    PinoutSet(false, false);

    //
    // Enable the GPIO pins for the LED D1 (PN1).
    //
    ROM_GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_1);

    //
    // Initialize the UART.
    //
    ConfigureUART();

    UARTprintf("\033[2J\033[H");
    //
    // Hello!
    //
    UARTprintf("Hello, world!\n");

    //
    // We are finished.  Hang around flashing D1.
    //
      // UARTprintf("1");

  /*  char *ch2 = &r;
    float_to_string(76543210.01234567,ch2) ;
    reverse(ch2);
    *ch2 = &r;
   // UARTprintf("ch2::%s",r);
    strncat(ch,ch2,len-1);*/
    //UARTprintf("0");
   // *ch++;

/*    *ch2 = &r;
    float_to_string(-20.52,ch2) ;
    reverse(ch2);
    len= strlen(ch2);
    strncat(ch,ch2,len);
    *ch++;
    UARTprintf("3");
*/
    /**ch++;
    *ch='}';
    *ch++;
    *ch='}';
    *ch++;
    *ch='\0';*/
//***********************************************************************************

   char *json_sensor = &r;


   // strncat(json_sensor,'[',1); *json_sensor='[';
  //  *json_sensor++;

    int i;
    for(i=0; i<50; i++){
    	//*json_sensor='{';
    	//*json_sensor++;

    	 strncat(json_sensor,"jhgf1",5);
  //  	*json_sensor= i +'1';
	//	*json_sensor++;


	      //  int j;
		/*	*json_sensor='$'+0;
    		*json_sensor++;


    	/*	int val=(3)*10;
    		int val1=val;
    		for(length=(val> 1) ? 0 : 1; val *> 1; length++)
    		  val /= 10;

    		for(j=0;j<=length;j++)
    		{
    			a[j]=(val1 % 10);
    			val1 /=10;
    			//	UARTprintf("val:%d",a[j]);
    		}

    		for(j=length-1;j>=0;j--)
    		{
    			*json_sensor=a[j];
    			*json_sensor++;
    			//*UARTprintf("val:%d",a[j]);
    		}


			*json_sensor='|';
  			*json_sensor++;
    		 char *ch = &r1;
    		// UARTprintf("range::%d",sensParams[i].sensorRange[0]);

    		 float_to_string(4,ch) ;
    		 reverse(ch);
    		// UARTprintf("range::%s",ch);
    		 *ch = &r1;

    		 strncat(json_sensor,ch,len-1);
    		 *json_sensor++;


    		*ch = &r1;
    		float_to_string(20,ch) ;
    		reverse(ch);
    		// UARTprintf("range::%s",ch);

    		*ch = &r1;
    		strncat(json_sensor,ch,len-1);
    		*json_sensor++;


    		for(j=3;j>=0;j--)
    		{
    			*json_sensor='A';
    			*json_sensor++;
    		}*/
     	//*json_sensor='}';
    	//*json_sensor++;
    	UARTprintf("\n 11Json_sensor::::%s",r);
    }
  //  *json_sensor=']';
  //  *json_sensor++;
 //   *json_sensor='\0';
 //   free(*ch);
 //   free(*json_sensor);
    UARTprintf("\n Json_sensor::::%s",r);

 //*********************************************************************************

     while(1)
    {
        //
        // Turn on D1.
        //

        LEDWrite(CLP_D1, 1);
       // UARTprintf("LED ON");

        //
        // Delay for a bit.
        //
     //  SysCtlDelay((g_ui32SysClock)/10);
      // UARTprintf("\nch:: ff");
        //
        // Turn off D1.
        //
     //  LEDWrite(CLP_D1, 0);
      // UARTprintf("LED OFF");

        //
        // Delay for a bit.
        //
     //  SysCtlDelay((g_ui32SysClock));

    }
}
