#include <stdint.h>
#include <assert.h>

#define SIZE 64

typedef union mask_t mask_t;

union mask_t
{
    uint8_t   _u8[SIZE / 8];
    uint16_t _u16[SIZE / 16];
    uint32_t _u32[SIZE / 32];
    uint64_t _u64[SIZE / 64];
};

typedef enum
{
    ENUM_VALUE_UNDEF = 0xFF,
    ENUM_VALUE_LL = 0,
    ENUM_VALUE_L = 12,
    ENUM_VALUE_N = 13,
    ENUM_VALUE_H = 14,
    ENUM_VALUE_HH = 15,
} ENUM_VALUE;

typedef uint32_t value_t;

static inline void mask_zero(mask_t* mask)
{
    mask->_u32[0] = 0;
    mask->_u32[1] = 0;
}

static inline void mask_set(int id, mask_t* mask)
{
    if(id < 32)
    {
        mask->_u32[1] |= ((uint32_t)1 << id);
    }
    else
    {
        mask->_u32[0] |= ((uint32_t)1 << (id - 32) );
    }
}


struct SInternalStruct
{
    mask_t  maskValue;
    value_t value;
};


int id()
{
    return 1;
}

void doSomething(SInternalStruct param)
{
    if (param.value != ENUM_VALUE_N)
    {
        assert(0);
    }
    
    return;
}

void fun()
{
    mask_t mask;
    mask_zero(&mask);
    mask_set(id(), &mask);

    SInternalStruct config = { mask, ENUM_VALUE_N };
    
    // The issue could be visible in runtime here.
    
    doSomething(config);
}

int main()
{
    fun();
}

