/*******************************************************************
*                                                                  *
* This file is a generic include file controlled by                *
* compiler/assembler IDE generated defines                         *
*                                                                  *
*******************************************************************/



/* ============================================================================ */
/* Copyright (c) 2017, Texas Instruments Incorporated                           */
/*  All rights reserved.                                                        */
/*                                                                              */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  *  Redistributions of source code must retain the above copyright           */
/*     notice, this list of conditions and the following disclaimer.            */
/*                                                                              */
/*  *  Redistributions in binary form must reproduce the above copyright        */
/*     notice, this list of conditions and the following disclaimer in the      */
/*     documentation and/or other materials provided with the distribution.     */
/*                                                                              */
/*  *  Neither the name of Texas Instruments Incorporated nor the names of      */
/*     its contributors may be used to endorse or promote products derived      */
/*     from this software without specific prior written permission.            */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" */
/*  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,       */
/*  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR      */
/*  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR            */
/*  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,       */
/*  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         */
/*  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; */
/*  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,    */
/*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR     */
/*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,              */
/*  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                          */
/* ============================================================================ */

/********************************************************************
*
* Standard register and bit definitions for the Texas Instruments
* MSP430 microcontroller.
*
* This file supports assembler and C development for
* MSP430FR5969 devices.
*
* Texas Instruments, Version 1.4
*
* Rev. 1.0, Setup
* Rev. 1.1  updated PxSELC register address to offset 0x16 (instead of 0x10)
*           replaced Comperator B with Comperator E
* Rev. 1.2  fixed typo in SYSRSTIV_MPUSEG defintions
*           replaced COMP_B with COMP_E
* Rev. 1.3  removed not available PxDS Register definitions
* Rev. 1.4  replaced NACCESSx with NWAITSx
*
********************************************************************/






/*----------------------------------------------------------------------------*/
/* PERIPHERAL FILE MAP                                                        */
/*----------------------------------------------------------------------------*/

/* External references resolved by a device-specific linker command file */
//#define SFR_20BIT(address)  extern volatile unsigned int address
typedef void (* __SFR_FARPTR)();



/************************************************************
* STANDARD BITS
************************************************************/


/************************************************************
* STATUS REGISTER BITS
************************************************************/


/* Low Power Modes coded with Bits 4-7 in SR */


/* ============================================================================ */
/* Copyright (c) 2013, Texas Instruments Incorporated                           */
/*  All rights reserved.                                                        */
/*                                                                              */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  *  Redistributions of source code must retain the above copyright           */
/*     notice, this list of conditions and the following disclaimer.            */
/*                                                                              */
/*  *  Redistributions in binary form must reproduce the above copyright        */
/*     notice, this list of conditions and the following disclaimer in the      */
/*     documentation and/or other materials provided with the distribution.     */
/*                                                                              */
/*  *  Neither the name of Texas Instruments Incorporated nor the names of      */
/*     its contributors may be used to endorse or promote products derived      */
/*     from this software without specific prior written permission.            */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" */
/*  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,       */
/*  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR      */
/*  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR            */
/*  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,       */
/*  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         */
/*  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; */
/*  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,    */
/*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR     */
/*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,              */
/*  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                          */
/* ============================================================================ */

/*----------------------------------------------------------------------------*/
/* INTRINSIC MAPPING FOR IAR V1.XX                                            */
/*----------------------------------------------------------------------------*/


/*****************************************************************************/
/*  INTRINSICS.H v17.9.0                                                     */
/*                                                                           */
/* Copyright (c) 2005-2017 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


/*---------------------------------------------------------------------------*/
/* Handle legacy conflicts                                                   */
/*---------------------------------------------------------------------------*/
/*****************************************************************************/
/*  INTRINSICS_LEGACY_UNDEFS.H v17.9.0                                       */
/*                                                                           */
/* Copyright (c) 2005-2017 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


/*---------------------------------------------------------------------------*/
/* Handle in430.h conflicts with legacy intrinsic names                      */
/*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*/
/* General MSP Intrinsics                                                    */
/*---------------------------------------------------------------------------*/
void           __no_operation(void);

unsigned short __bic_SR_register         (unsigned short mask);
unsigned short __bic_SR_register_on_exit (unsigned short mask);
unsigned short __bis_SR_register         (unsigned short mask);
unsigned short __bis_SR_register_on_exit (unsigned short mask);
unsigned short __get_SR_register         (void);
unsigned short __get_SR_register_on_exit (void);

unsigned short __get_SP_register(void);
void           __set_SP_register(unsigned short value);

void           __delay_cycles(unsigned long cycles);

unsigned int   __even_in_range(unsigned int val, unsigned int range);

void           __op_code(unsigned short op);

/*---------------------------------------------------------------------------*/
/* General MSP Macros                                                        */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* MSP430/430X Intrinsics                                                    */
/*---------------------------------------------------------------------------*/
void             __disable_interrupt(void);
void             __enable_interrupt(void);
void             __set_interrupt_state(unsigned short state);

unsigned short   __get_R4_register(void);
void             __set_R4_register(unsigned short value);
unsigned short   __get_R5_register(void);
void             __set_R5_register(unsigned short value);

unsigned short   __bcd_add_short(unsigned short, unsigned short);
unsigned long    __bcd_add_long(unsigned long, unsigned long);

/*---------------------------------------------------------------------------*/
/* MSP430/430X Macros                                                        */
/*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*/
/* MSP430X Intrinsics                                                        */
/*---------------------------------------------------------------------------*/
void           __data16_write_addr(unsigned short, unsigned long);
unsigned long  __data16_read_addr(unsigned short);
void           __data20_write_char(unsigned long, unsigned char);
void           __data20_write_short(unsigned long, unsigned short);
void           __data20_write_long(unsigned long, unsigned long);
unsigned char  __data20_read_char(unsigned long);
unsigned short __data20_read_short(unsigned long);
unsigned long  __data20_read_long(unsigned long);


/*---------------------------------------------------------------------------*/
/* Legacy Macros                                                             */
/*---------------------------------------------------------------------------*/




/************************************************************
* PERIPHERAL FILE MAP
************************************************************/

/************************************************************
* ADC12_B
************************************************************/

extern volatile unsigned int ADC12CTL0;                         /* ADC12 B Control 0 */
extern volatile unsigned char ADC12CTL0_L;                        /* ADC12 B Control 0 */
extern volatile unsigned char ADC12CTL0_H;                        /* ADC12 B Control 0 */
extern volatile unsigned int ADC12CTL1;                         /* ADC12 B Control 1 */
extern volatile unsigned char ADC12CTL1_L;                        /* ADC12 B Control 1 */
extern volatile unsigned char ADC12CTL1_H;                        /* ADC12 B Control 1 */
extern volatile unsigned int ADC12CTL2;                         /* ADC12 B Control 2 */
extern volatile unsigned char ADC12CTL2_L;                        /* ADC12 B Control 2 */
extern volatile unsigned char ADC12CTL2_H;                        /* ADC12 B Control 2 */
extern volatile unsigned int ADC12CTL3;                         /* ADC12 B Control 3 */
extern volatile unsigned char ADC12CTL3_L;                        /* ADC12 B Control 3 */
extern volatile unsigned char ADC12CTL3_H;                        /* ADC12 B Control 3 */
extern volatile unsigned int ADC12LO;                           /* ADC12 B Window Comparator High Threshold */
extern volatile unsigned char ADC12LO_L;                          /* ADC12 B Window Comparator High Threshold */
extern volatile unsigned char ADC12LO_H;                          /* ADC12 B Window Comparator High Threshold */
extern volatile unsigned int ADC12HI;                           /* ADC12 B Window Comparator High Threshold */
extern volatile unsigned char ADC12HI_L;                          /* ADC12 B Window Comparator High Threshold */
extern volatile unsigned char ADC12HI_H;                          /* ADC12 B Window Comparator High Threshold */
extern volatile unsigned int ADC12IFGR0;                        /* ADC12 B Interrupt Flag 0 */
extern volatile unsigned char ADC12IFGR0_L;                       /* ADC12 B Interrupt Flag 0 */
extern volatile unsigned char ADC12IFGR0_H;                       /* ADC12 B Interrupt Flag 0 */
extern volatile unsigned int ADC12IFGR1;                        /* ADC12 B Interrupt Flag 1 */
extern volatile unsigned char ADC12IFGR1_L;                       /* ADC12 B Interrupt Flag 1 */
extern volatile unsigned char ADC12IFGR1_H;                       /* ADC12 B Interrupt Flag 1 */
extern volatile unsigned int ADC12IFGR2;                        /* ADC12 B Interrupt Flag 2 */
extern volatile unsigned char ADC12IFGR2_L;                       /* ADC12 B Interrupt Flag 2 */
extern volatile unsigned char ADC12IFGR2_H;                       /* ADC12 B Interrupt Flag 2 */
extern volatile unsigned int ADC12IER0;                         /* ADC12 B Interrupt Enable 0 */
extern volatile unsigned char ADC12IER0_L;                        /* ADC12 B Interrupt Enable 0 */
extern volatile unsigned char ADC12IER0_H;                        /* ADC12 B Interrupt Enable 0 */
extern volatile unsigned int ADC12IER1;                         /* ADC12 B Interrupt Enable 1 */
extern volatile unsigned char ADC12IER1_L;                        /* ADC12 B Interrupt Enable 1 */
extern volatile unsigned char ADC12IER1_H;                        /* ADC12 B Interrupt Enable 1 */
extern volatile unsigned int ADC12IER2;                         /* ADC12 B Interrupt Enable 2 */
extern volatile unsigned char ADC12IER2_L;                        /* ADC12 B Interrupt Enable 2 */
extern volatile unsigned char ADC12IER2_H;                        /* ADC12 B Interrupt Enable 2 */
extern volatile unsigned int ADC12IV;                           /* ADC12 B Interrupt Vector Word */
extern volatile unsigned char ADC12IV_L;                          /* ADC12 B Interrupt Vector Word */
extern volatile unsigned char ADC12IV_H;                          /* ADC12 B Interrupt Vector Word */

extern volatile unsigned int ADC12MCTL0;                        /* ADC12 Memory Control 0 */
extern volatile unsigned char ADC12MCTL0_L;                       /* ADC12 Memory Control 0 */
extern volatile unsigned char ADC12MCTL0_H;                       /* ADC12 Memory Control 0 */
extern volatile unsigned int ADC12MCTL1;                        /* ADC12 Memory Control 1 */
extern volatile unsigned char ADC12MCTL1_L;                       /* ADC12 Memory Control 1 */
extern volatile unsigned char ADC12MCTL1_H;                       /* ADC12 Memory Control 1 */
extern volatile unsigned int ADC12MCTL2;                        /* ADC12 Memory Control 2 */
extern volatile unsigned char ADC12MCTL2_L;                       /* ADC12 Memory Control 2 */
extern volatile unsigned char ADC12MCTL2_H;                       /* ADC12 Memory Control 2 */
extern volatile unsigned int ADC12MCTL3;                        /* ADC12 Memory Control 3 */
extern volatile unsigned char ADC12MCTL3_L;                       /* ADC12 Memory Control 3 */
extern volatile unsigned char ADC12MCTL3_H;                       /* ADC12 Memory Control 3 */
extern volatile unsigned int ADC12MCTL4;                        /* ADC12 Memory Control 4 */
extern volatile unsigned char ADC12MCTL4_L;                       /* ADC12 Memory Control 4 */
extern volatile unsigned char ADC12MCTL4_H;                       /* ADC12 Memory Control 4 */
extern volatile unsigned int ADC12MCTL5;                        /* ADC12 Memory Control 5 */
extern volatile unsigned char ADC12MCTL5_L;                       /* ADC12 Memory Control 5 */
extern volatile unsigned char ADC12MCTL5_H;                       /* ADC12 Memory Control 5 */
extern volatile unsigned int ADC12MCTL6;                        /* ADC12 Memory Control 6 */
extern volatile unsigned char ADC12MCTL6_L;                       /* ADC12 Memory Control 6 */
extern volatile unsigned char ADC12MCTL6_H;                       /* ADC12 Memory Control 6 */
extern volatile unsigned int ADC12MCTL7;                        /* ADC12 Memory Control 7 */
extern volatile unsigned char ADC12MCTL7_L;                       /* ADC12 Memory Control 7 */
extern volatile unsigned char ADC12MCTL7_H;                       /* ADC12 Memory Control 7 */
extern volatile unsigned int ADC12MCTL8;                        /* ADC12 Memory Control 8 */
extern volatile unsigned char ADC12MCTL8_L;                       /* ADC12 Memory Control 8 */
extern volatile unsigned char ADC12MCTL8_H;                       /* ADC12 Memory Control 8 */
extern volatile unsigned int ADC12MCTL9;                        /* ADC12 Memory Control 9 */
extern volatile unsigned char ADC12MCTL9_L;                       /* ADC12 Memory Control 9 */
extern volatile unsigned char ADC12MCTL9_H;                       /* ADC12 Memory Control 9 */
extern volatile unsigned int ADC12MCTL10;                       /* ADC12 Memory Control 10 */
extern volatile unsigned char ADC12MCTL10_L;                      /* ADC12 Memory Control 10 */
extern volatile unsigned char ADC12MCTL10_H;                      /* ADC12 Memory Control 10 */
extern volatile unsigned int ADC12MCTL11;                       /* ADC12 Memory Control 11 */
extern volatile unsigned char ADC12MCTL11_L;                      /* ADC12 Memory Control 11 */
extern volatile unsigned char ADC12MCTL11_H;                      /* ADC12 Memory Control 11 */
extern volatile unsigned int ADC12MCTL12;                       /* ADC12 Memory Control 12 */
extern volatile unsigned char ADC12MCTL12_L;                      /* ADC12 Memory Control 12 */
extern volatile unsigned char ADC12MCTL12_H;                      /* ADC12 Memory Control 12 */
extern volatile unsigned int ADC12MCTL13;                       /* ADC12 Memory Control 13 */
extern volatile unsigned char ADC12MCTL13_L;                      /* ADC12 Memory Control 13 */
extern volatile unsigned char ADC12MCTL13_H;                      /* ADC12 Memory Control 13 */
extern volatile unsigned int ADC12MCTL14;                       /* ADC12 Memory Control 14 */
extern volatile unsigned char ADC12MCTL14_L;                      /* ADC12 Memory Control 14 */
extern volatile unsigned char ADC12MCTL14_H;                      /* ADC12 Memory Control 14 */
extern volatile unsigned int ADC12MCTL15;                       /* ADC12 Memory Control 15 */
extern volatile unsigned char ADC12MCTL15_L;                      /* ADC12 Memory Control 15 */
extern volatile unsigned char ADC12MCTL15_H;                      /* ADC12 Memory Control 15 */
extern volatile unsigned int ADC12MCTL16;                       /* ADC12 Memory Control 16 */
extern volatile unsigned char ADC12MCTL16_L;                      /* ADC12 Memory Control 16 */
extern volatile unsigned char ADC12MCTL16_H;                      /* ADC12 Memory Control 16 */
extern volatile unsigned int ADC12MCTL17;                       /* ADC12 Memory Control 17 */
extern volatile unsigned char ADC12MCTL17_L;                      /* ADC12 Memory Control 17 */
extern volatile unsigned char ADC12MCTL17_H;                      /* ADC12 Memory Control 17 */
extern volatile unsigned int ADC12MCTL18;                       /* ADC12 Memory Control 18 */
extern volatile unsigned char ADC12MCTL18_L;                      /* ADC12 Memory Control 18 */
extern volatile unsigned char ADC12MCTL18_H;                      /* ADC12 Memory Control 18 */
extern volatile unsigned int ADC12MCTL19;                       /* ADC12 Memory Control 19 */
extern volatile unsigned char ADC12MCTL19_L;                      /* ADC12 Memory Control 19 */
extern volatile unsigned char ADC12MCTL19_H;                      /* ADC12 Memory Control 19 */
extern volatile unsigned int ADC12MCTL20;                       /* ADC12 Memory Control 20 */
extern volatile unsigned char ADC12MCTL20_L;                      /* ADC12 Memory Control 20 */
extern volatile unsigned char ADC12MCTL20_H;                      /* ADC12 Memory Control 20 */
extern volatile unsigned int ADC12MCTL21;                       /* ADC12 Memory Control 21 */
extern volatile unsigned char ADC12MCTL21_L;                      /* ADC12 Memory Control 21 */
extern volatile unsigned char ADC12MCTL21_H;                      /* ADC12 Memory Control 21 */
extern volatile unsigned int ADC12MCTL22;                       /* ADC12 Memory Control 22 */
extern volatile unsigned char ADC12MCTL22_L;                      /* ADC12 Memory Control 22 */
extern volatile unsigned char ADC12MCTL22_H;                      /* ADC12 Memory Control 22 */
extern volatile unsigned int ADC12MCTL23;                       /* ADC12 Memory Control 23 */
extern volatile unsigned char ADC12MCTL23_L;                      /* ADC12 Memory Control 23 */
extern volatile unsigned char ADC12MCTL23_H;                      /* ADC12 Memory Control 23 */
extern volatile unsigned int ADC12MCTL24;                       /* ADC12 Memory Control 24 */
extern volatile unsigned char ADC12MCTL24_L;                      /* ADC12 Memory Control 24 */
extern volatile unsigned char ADC12MCTL24_H;                      /* ADC12 Memory Control 24 */
extern volatile unsigned int ADC12MCTL25;                       /* ADC12 Memory Control 25 */
extern volatile unsigned char ADC12MCTL25_L;                      /* ADC12 Memory Control 25 */
extern volatile unsigned char ADC12MCTL25_H;                      /* ADC12 Memory Control 25 */
extern volatile unsigned int ADC12MCTL26;                       /* ADC12 Memory Control 26 */
extern volatile unsigned char ADC12MCTL26_L;                      /* ADC12 Memory Control 26 */
extern volatile unsigned char ADC12MCTL26_H;                      /* ADC12 Memory Control 26 */
extern volatile unsigned int ADC12MCTL27;                       /* ADC12 Memory Control 27 */
extern volatile unsigned char ADC12MCTL27_L;                      /* ADC12 Memory Control 27 */
extern volatile unsigned char ADC12MCTL27_H;                      /* ADC12 Memory Control 27 */
extern volatile unsigned int ADC12MCTL28;                       /* ADC12 Memory Control 28 */
extern volatile unsigned char ADC12MCTL28_L;                      /* ADC12 Memory Control 28 */
extern volatile unsigned char ADC12MCTL28_H;                      /* ADC12 Memory Control 28 */
extern volatile unsigned int ADC12MCTL29;                       /* ADC12 Memory Control 29 */
extern volatile unsigned char ADC12MCTL29_L;                      /* ADC12 Memory Control 29 */
extern volatile unsigned char ADC12MCTL29_H;                      /* ADC12 Memory Control 29 */
extern volatile unsigned int ADC12MCTL30;                       /* ADC12 Memory Control 30 */
extern volatile unsigned char ADC12MCTL30_L;                      /* ADC12 Memory Control 30 */
extern volatile unsigned char ADC12MCTL30_H;                      /* ADC12 Memory Control 30 */
extern volatile unsigned int ADC12MCTL31;                       /* ADC12 Memory Control 31 */
extern volatile unsigned char ADC12MCTL31_L;                      /* ADC12 Memory Control 31 */
extern volatile unsigned char ADC12MCTL31_H;                      /* ADC12 Memory Control 31 */

extern volatile unsigned int ADC12MEM0;                         /* ADC12 Conversion Memory 0 */
extern volatile unsigned char ADC12MEM0_L;                        /* ADC12 Conversion Memory 0 */
extern volatile unsigned char ADC12MEM0_H;                        /* ADC12 Conversion Memory 0 */
extern volatile unsigned int ADC12MEM1;                         /* ADC12 Conversion Memory 1 */
extern volatile unsigned char ADC12MEM1_L;                        /* ADC12 Conversion Memory 1 */
extern volatile unsigned char ADC12MEM1_H;                        /* ADC12 Conversion Memory 1 */
extern volatile unsigned int ADC12MEM2;                         /* ADC12 Conversion Memory 2 */
extern volatile unsigned char ADC12MEM2_L;                        /* ADC12 Conversion Memory 2 */
extern volatile unsigned char ADC12MEM2_H;                        /* ADC12 Conversion Memory 2 */
extern volatile unsigned int ADC12MEM3;                         /* ADC12 Conversion Memory 3 */
extern volatile unsigned char ADC12MEM3_L;                        /* ADC12 Conversion Memory 3 */
extern volatile unsigned char ADC12MEM3_H;                        /* ADC12 Conversion Memory 3 */
extern volatile unsigned int ADC12MEM4;                         /* ADC12 Conversion Memory 4 */
extern volatile unsigned char ADC12MEM4_L;                        /* ADC12 Conversion Memory 4 */
extern volatile unsigned char ADC12MEM4_H;                        /* ADC12 Conversion Memory 4 */
extern volatile unsigned int ADC12MEM5;                         /* ADC12 Conversion Memory 5 */
extern volatile unsigned char ADC12MEM5_L;                        /* ADC12 Conversion Memory 5 */
extern volatile unsigned char ADC12MEM5_H;                        /* ADC12 Conversion Memory 5 */
extern volatile unsigned int ADC12MEM6;                         /* ADC12 Conversion Memory 6 */
extern volatile unsigned char ADC12MEM6_L;                        /* ADC12 Conversion Memory 6 */
extern volatile unsigned char ADC12MEM6_H;                        /* ADC12 Conversion Memory 6 */
extern volatile unsigned int ADC12MEM7;                         /* ADC12 Conversion Memory 7 */
extern volatile unsigned char ADC12MEM7_L;                        /* ADC12 Conversion Memory 7 */
extern volatile unsigned char ADC12MEM7_H;                        /* ADC12 Conversion Memory 7 */
extern volatile unsigned int ADC12MEM8;                         /* ADC12 Conversion Memory 8 */
extern volatile unsigned char ADC12MEM8_L;                        /* ADC12 Conversion Memory 8 */
extern volatile unsigned char ADC12MEM8_H;                        /* ADC12 Conversion Memory 8 */
extern volatile unsigned int ADC12MEM9;                         /* ADC12 Conversion Memory 9 */
extern volatile unsigned char ADC12MEM9_L;                        /* ADC12 Conversion Memory 9 */
extern volatile unsigned char ADC12MEM9_H;                        /* ADC12 Conversion Memory 9 */
extern volatile unsigned int ADC12MEM10;                        /* ADC12 Conversion Memory 10 */
extern volatile unsigned char ADC12MEM10_L;                       /* ADC12 Conversion Memory 10 */
extern volatile unsigned char ADC12MEM10_H;                       /* ADC12 Conversion Memory 10 */
extern volatile unsigned int ADC12MEM11;                        /* ADC12 Conversion Memory 11 */
extern volatile unsigned char ADC12MEM11_L;                       /* ADC12 Conversion Memory 11 */
extern volatile unsigned char ADC12MEM11_H;                       /* ADC12 Conversion Memory 11 */
extern volatile unsigned int ADC12MEM12;                        /* ADC12 Conversion Memory 12 */
extern volatile unsigned char ADC12MEM12_L;                       /* ADC12 Conversion Memory 12 */
extern volatile unsigned char ADC12MEM12_H;                       /* ADC12 Conversion Memory 12 */
extern volatile unsigned int ADC12MEM13;                        /* ADC12 Conversion Memory 13 */
extern volatile unsigned char ADC12MEM13_L;                       /* ADC12 Conversion Memory 13 */
extern volatile unsigned char ADC12MEM13_H;                       /* ADC12 Conversion Memory 13 */
extern volatile unsigned int ADC12MEM14;                        /* ADC12 Conversion Memory 14 */
extern volatile unsigned char ADC12MEM14_L;                       /* ADC12 Conversion Memory 14 */
extern volatile unsigned char ADC12MEM14_H;                       /* ADC12 Conversion Memory 14 */
extern volatile unsigned int ADC12MEM15;                        /* ADC12 Conversion Memory 15 */
extern volatile unsigned char ADC12MEM15_L;                       /* ADC12 Conversion Memory 15 */
extern volatile unsigned char ADC12MEM15_H;                       /* ADC12 Conversion Memory 15 */
extern volatile unsigned int ADC12MEM16;                        /* ADC12 Conversion Memory 16 */
extern volatile unsigned char ADC12MEM16_L;                       /* ADC12 Conversion Memory 16 */
extern volatile unsigned char ADC12MEM16_H;                       /* ADC12 Conversion Memory 16 */
extern volatile unsigned int ADC12MEM17;                        /* ADC12 Conversion Memory 17 */
extern volatile unsigned char ADC12MEM17_L;                       /* ADC12 Conversion Memory 17 */
extern volatile unsigned char ADC12MEM17_H;                       /* ADC12 Conversion Memory 17 */
extern volatile unsigned int ADC12MEM18;                        /* ADC12 Conversion Memory 18 */
extern volatile unsigned char ADC12MEM18_L;                       /* ADC12 Conversion Memory 18 */
extern volatile unsigned char ADC12MEM18_H;                       /* ADC12 Conversion Memory 18 */
extern volatile unsigned int ADC12MEM19;                        /* ADC12 Conversion Memory 19 */
extern volatile unsigned char ADC12MEM19_L;                       /* ADC12 Conversion Memory 19 */
extern volatile unsigned char ADC12MEM19_H;                       /* ADC12 Conversion Memory 19 */
extern volatile unsigned int ADC12MEM20;                        /* ADC12 Conversion Memory 20 */
extern volatile unsigned char ADC12MEM20_L;                       /* ADC12 Conversion Memory 20 */
extern volatile unsigned char ADC12MEM20_H;                       /* ADC12 Conversion Memory 20 */
extern volatile unsigned int ADC12MEM21;                        /* ADC12 Conversion Memory 21 */
extern volatile unsigned char ADC12MEM21_L;                       /* ADC12 Conversion Memory 21 */
extern volatile unsigned char ADC12MEM21_H;                       /* ADC12 Conversion Memory 21 */
extern volatile unsigned int ADC12MEM22;                        /* ADC12 Conversion Memory 22 */
extern volatile unsigned char ADC12MEM22_L;                       /* ADC12 Conversion Memory 22 */
extern volatile unsigned char ADC12MEM22_H;                       /* ADC12 Conversion Memory 22 */
extern volatile unsigned int ADC12MEM23;                        /* ADC12 Conversion Memory 23 */
extern volatile unsigned char ADC12MEM23_L;                       /* ADC12 Conversion Memory 23 */
extern volatile unsigned char ADC12MEM23_H;                       /* ADC12 Conversion Memory 23 */
extern volatile unsigned int ADC12MEM24;                        /* ADC12 Conversion Memory 24 */
extern volatile unsigned char ADC12MEM24_L;                       /* ADC12 Conversion Memory 24 */
extern volatile unsigned char ADC12MEM24_H;                       /* ADC12 Conversion Memory 24 */
extern volatile unsigned int ADC12MEM25;                        /* ADC12 Conversion Memory 25 */
extern volatile unsigned char ADC12MEM25_L;                       /* ADC12 Conversion Memory 25 */
extern volatile unsigned char ADC12MEM25_H;                       /* ADC12 Conversion Memory 25 */
extern volatile unsigned int ADC12MEM26;                        /* ADC12 Conversion Memory 26 */
extern volatile unsigned char ADC12MEM26_L;                       /* ADC12 Conversion Memory 26 */
extern volatile unsigned char ADC12MEM26_H;                       /* ADC12 Conversion Memory 26 */
extern volatile unsigned int ADC12MEM27;                        /* ADC12 Conversion Memory 27 */
extern volatile unsigned char ADC12MEM27_L;                       /* ADC12 Conversion Memory 27 */
extern volatile unsigned char ADC12MEM27_H;                       /* ADC12 Conversion Memory 27 */
extern volatile unsigned int ADC12MEM28;                        /* ADC12 Conversion Memory 28 */
extern volatile unsigned char ADC12MEM28_L;                       /* ADC12 Conversion Memory 28 */
extern volatile unsigned char ADC12MEM28_H;                       /* ADC12 Conversion Memory 28 */
extern volatile unsigned int ADC12MEM29;                        /* ADC12 Conversion Memory 29 */
extern volatile unsigned char ADC12MEM29_L;                       /* ADC12 Conversion Memory 29 */
extern volatile unsigned char ADC12MEM29_H;                       /* ADC12 Conversion Memory 29 */
extern volatile unsigned int ADC12MEM30;                        /* ADC12 Conversion Memory 30 */
extern volatile unsigned char ADC12MEM30_L;                       /* ADC12 Conversion Memory 30 */
extern volatile unsigned char ADC12MEM30_H;                       /* ADC12 Conversion Memory 30 */
extern volatile unsigned int ADC12MEM31;                        /* ADC12 Conversion Memory 31 */
extern volatile unsigned char ADC12MEM31_L;                       /* ADC12 Conversion Memory 31 */
extern volatile unsigned char ADC12MEM31_H;                       /* ADC12 Conversion Memory 31 */

/* ADC12CTL0 Control Bits */

/* ADC12CTL0 Control Bits */

/* ADC12CTL0 Control Bits */



/* ADC12CTL1 Control Bits */

/* ADC12CTL1 Control Bits */

/* ADC12CTL1 Control Bits */






/* ADC12CTL2 Control Bits */

/* ADC12CTL2 Control Bits */



/* ADC12CTL3 Control Bits */

/* ADC12CTL3 Control Bits */

/* ADC12CTL3 Control Bits */


/* ADC12MCTLx Control Bits */

/* ADC12MCTLx Control Bits */

/* ADC12MCTLx Control Bits */



/* ADC12HI Control Bits */

/* ADC12LO Control Bits */

/* ADC12IER0 Control Bits */

/* ADC12IER0 Control Bits */

/* ADC12IER0 Control Bits */

/* ADC12IER1 Control Bits */

/* ADC12IER1 Control Bits */

/* ADC12IER1 Control Bits */

/* ADC12IER2 Control Bits */

/* ADC12IER2 Control Bits */

/* ADC12IFGR0 Control Bits */

/* ADC12IFGR0 Control Bits */

/* ADC12IFGR0 Control Bits */

/* ADC12IFGR1 Control Bits */

/* ADC12IFGR1 Control Bits */

/* ADC12IFGR1 Control Bits */

/* ADC12IFGR2 Control Bits */

/* ADC12IFGR2 Control Bits */

/* ADC12IV Definitions */


/************************************************************
* AES256 Accelerator
************************************************************/

extern volatile unsigned int AESACTL0;                          /* AES accelerator control register 0 */
extern volatile unsigned char AESACTL0_L;                         /* AES accelerator control register 0 */
extern volatile unsigned char AESACTL0_H;                         /* AES accelerator control register 0 */
extern volatile unsigned int AESACTL1;                          /* AES accelerator control register 1 */
extern volatile unsigned char AESACTL1_L;                         /* AES accelerator control register 1 */
extern volatile unsigned char AESACTL1_H;                         /* AES accelerator control register 1 */
extern volatile unsigned int AESASTAT;                          /* AES accelerator status register */
extern volatile unsigned char AESASTAT_L;                         /* AES accelerator status register */
extern volatile unsigned char AESASTAT_H;                         /* AES accelerator status register */
extern volatile unsigned int AESAKEY;                           /* AES accelerator key register */
extern volatile unsigned char AESAKEY_L;                          /* AES accelerator key register */
extern volatile unsigned char AESAKEY_H;                          /* AES accelerator key register */
extern volatile unsigned int AESADIN;                           /* AES accelerator data in register */
extern volatile unsigned char AESADIN_L;                          /* AES accelerator data in register */
extern volatile unsigned char AESADIN_H;                          /* AES accelerator data in register */
extern volatile unsigned int AESADOUT;                          /* AES accelerator data out register  */
extern volatile unsigned char AESADOUT_L;                         /* AES accelerator data out register  */
extern volatile unsigned char AESADOUT_H;                         /* AES accelerator data out register  */
extern volatile unsigned int AESAXDIN;                          /* AES accelerator XORed data in register */
extern volatile unsigned char AESAXDIN_L;                         /* AES accelerator XORed data in register */
extern volatile unsigned char AESAXDIN_H;                         /* AES accelerator XORed data in register */
extern volatile unsigned int AESAXIN;                           /* AES accelerator XORed data in register (no trigger)  */
extern volatile unsigned char AESAXIN_L;                          /* AES accelerator XORed data in register (no trigger)  */
extern volatile unsigned char AESAXIN_H;                          /* AES accelerator XORed data in register (no trigger)  */

/* AESACTL0 Control Bits */

/* AESACTL0 Control Bits */

/* AESACTL0 Control Bits */




/* AESACTL1 Control Bits */

/* AESACTL1 Control Bits */

/* AESASTAT Control Bits */

/* AESASTAT Control Bits */

/* AESASTAT Control Bits */

/************************************************************
* Capacitive_Touch_IO 0
************************************************************/

extern volatile unsigned int CAPTIO0CTL;                        /* Capacitive_Touch_IO 0 control register */
extern volatile unsigned char CAPTIO0CTL_L;                       /* Capacitive_Touch_IO 0 control register */
extern volatile unsigned char CAPTIO0CTL_H;                       /* Capacitive_Touch_IO 0 control register */


/************************************************************
* Capacitive_Touch_IO 1
************************************************************/

extern volatile unsigned int CAPTIO1CTL;                        /* Capacitive_Touch_IO 1 control register */
extern volatile unsigned char CAPTIO1CTL_L;                       /* Capacitive_Touch_IO 1 control register */
extern volatile unsigned char CAPTIO1CTL_H;                       /* Capacitive_Touch_IO 1 control register */


/* CAPTIOxCTL Control Bits */

/* CAPTIOxCTL Control Bits */

/* CAPTIOxCTL Control Bits */

/* Legacy defines */

/************************************************************
* Comparator E
************************************************************/

extern volatile unsigned int CECTL0;                            /* Comparator E Control Register 0 */
extern volatile unsigned char CECTL0_L;                           /* Comparator E Control Register 0 */
extern volatile unsigned char CECTL0_H;                           /* Comparator E Control Register 0 */
extern volatile unsigned int CECTL1;                            /* Comparator E Control Register 1 */
extern volatile unsigned char CECTL1_L;                           /* Comparator E Control Register 1 */
extern volatile unsigned char CECTL1_H;                           /* Comparator E Control Register 1 */
extern volatile unsigned int CECTL2;                            /* Comparator E Control Register 2 */
extern volatile unsigned char CECTL2_L;                           /* Comparator E Control Register 2 */
extern volatile unsigned char CECTL2_H;                           /* Comparator E Control Register 2 */
extern volatile unsigned int CECTL3;                            /* Comparator E Control Register 3 */
extern volatile unsigned char CECTL3_L;                           /* Comparator E Control Register 3 */
extern volatile unsigned char CECTL3_H;                           /* Comparator E Control Register 3 */
extern volatile unsigned int CEINT;                             /* Comparator E Interrupt Register */
extern volatile unsigned char CEINT_L;                            /* Comparator E Interrupt Register */
extern volatile unsigned char CEINT_H;                            /* Comparator E Interrupt Register */
extern volatile unsigned int CEIV;                              /* Comparator E Interrupt Vector Word */
extern volatile unsigned char CEIV_L;                             /* Comparator E Interrupt Vector Word */
extern volatile unsigned char CEIV_H;                             /* Comparator E Interrupt Vector Word */

/* CECTL0 Control Bits */
//#define RESERVED            (0x0010)  /* Comp. E */
//#define RESERVED            (0x0020)  /* Comp. E */
//#define RESERVED            (0x0040)  /* Comp. E */
//#define RESERVED            (0x1000)  /* Comp. E */
//#define RESERVED            (0x2000)  /* Comp. E */
//#define RESERVED            (0x4000)  /* Comp. E */

/* CECTL0 Control Bits */
//#define RESERVED            (0x0010)  /* Comp. E */
//#define RESERVED            (0x0020)  /* Comp. E */
//#define RESERVED            (0x0040)  /* Comp. E */
//#define RESERVED            (0x1000)  /* Comp. E */
//#define RESERVED            (0x2000)  /* Comp. E */
//#define RESERVED            (0x4000)  /* Comp. E */

/* CECTL0 Control Bits */
//#define RESERVED            (0x0010)  /* Comp. E */
//#define RESERVED            (0x0020)  /* Comp. E */
//#define RESERVED            (0x0040)  /* Comp. E */
//#define RESERVED            (0x1000)  /* Comp. E */
//#define RESERVED            (0x2000)  /* Comp. E */
//#define RESERVED            (0x4000)  /* Comp. E */



/* CECTL1 Control Bits */
//#define RESERVED            (0x2000)  /* Comp. E */
//#define RESERVED            (0x4000)  /* Comp. E */
//#define RESERVED            (0x8000)  /* Comp. E */

/* CECTL1 Control Bits */
//#define RESERVED            (0x2000)  /* Comp. E */
//#define RESERVED            (0x4000)  /* Comp. E */
//#define RESERVED            (0x8000)  /* Comp. E */

/* CECTL1 Control Bits */
//#define RESERVED            (0x2000)  /* Comp. E */
//#define RESERVED            (0x4000)  /* Comp. E */
//#define RESERVED            (0x8000)  /* Comp. E */



/* CECTL2 Control Bits */

/* CECTL2 Control Bits */

/* CECTL2 Control Bits */








/* CEINT Control Bits */
//#define RESERVED             (0x0004)  /* Comp. E */
//#define RESERVED             (0x0008)  /* Comp. E */
//#define RESERVED             (0x0020)  /* Comp. E */
//#define RESERVED             (0x0040)  /* Comp. E */
//#define RESERVED             (0x0080)  /* Comp. E */
//#define RESERVED             (0x0400)  /* Comp. E */
//#define RESERVED             (0x0800)  /* Comp. E */
//#define RESERVED             (0x2000)  /* Comp. E */
//#define RESERVED             (0x4000)  /* Comp. E */
//#define RESERVED             (0x8000)  /* Comp. E */

/* CEINT Control Bits */
//#define RESERVED             (0x0004)  /* Comp. E */
//#define RESERVED             (0x0008)  /* Comp. E */
//#define RESERVED             (0x0020)  /* Comp. E */
//#define RESERVED             (0x0040)  /* Comp. E */
//#define RESERVED             (0x0080)  /* Comp. E */
//#define RESERVED             (0x0400)  /* Comp. E */
//#define RESERVED             (0x0800)  /* Comp. E */
//#define RESERVED             (0x2000)  /* Comp. E */
//#define RESERVED             (0x4000)  /* Comp. E */
//#define RESERVED             (0x8000)  /* Comp. E */

/* CEINT Control Bits */
//#define RESERVED             (0x0004)  /* Comp. E */
//#define RESERVED             (0x0008)  /* Comp. E */
//#define RESERVED             (0x0020)  /* Comp. E */
//#define RESERVED             (0x0040)  /* Comp. E */
//#define RESERVED             (0x0080)  /* Comp. E */
//#define RESERVED             (0x0400)  /* Comp. E */
//#define RESERVED             (0x0800)  /* Comp. E */
//#define RESERVED             (0x2000)  /* Comp. E */
//#define RESERVED             (0x4000)  /* Comp. E */
//#define RESERVED             (0x8000)  /* Comp. E */

/* CEIV Definitions */

/*************************************************************
* CRC Module
*************************************************************/

extern volatile unsigned int CRCDI;                             /* CRC Data In Register */
extern volatile unsigned char CRCDI_L;                            /* CRC Data In Register */
extern volatile unsigned char CRCDI_H;                            /* CRC Data In Register */
extern volatile unsigned int CRCDIRB;                           /* CRC data in reverse byte Register */
extern volatile unsigned char CRCDIRB_L;                          /* CRC data in reverse byte Register */
extern volatile unsigned char CRCDIRB_H;                          /* CRC data in reverse byte Register */
extern volatile unsigned int CRCINIRES;                         /* CRC Initialisation Register and Result Register */
extern volatile unsigned char CRCINIRES_L;                        /* CRC Initialisation Register and Result Register */
extern volatile unsigned char CRCINIRES_H;                        /* CRC Initialisation Register and Result Register */
extern volatile unsigned int CRCRESR;                           /* CRC reverse result Register */
extern volatile unsigned char CRCRESR_L;                          /* CRC reverse result Register */
extern volatile unsigned char CRCRESR_H;                          /* CRC reverse result Register */

/************************************************************
* CLOCK SYSTEM
************************************************************/

extern volatile unsigned int CSCTL0;                            /* CS Control Register 0 */
extern volatile unsigned char CSCTL0_L;                           /* CS Control Register 0 */
extern volatile unsigned char CSCTL0_H;                           /* CS Control Register 0 */
extern volatile unsigned int CSCTL1;                            /* CS Control Register 1 */
extern volatile unsigned char CSCTL1_L;                           /* CS Control Register 1 */
extern volatile unsigned char CSCTL1_H;                           /* CS Control Register 1 */
extern volatile unsigned int CSCTL2;                            /* CS Control Register 2 */
extern volatile unsigned char CSCTL2_L;                           /* CS Control Register 2 */
extern volatile unsigned char CSCTL2_H;                           /* CS Control Register 2 */
extern volatile unsigned int CSCTL3;                            /* CS Control Register 3 */
extern volatile unsigned char CSCTL3_L;                           /* CS Control Register 3 */
extern volatile unsigned char CSCTL3_H;                           /* CS Control Register 3 */
extern volatile unsigned int CSCTL4;                            /* CS Control Register 4 */
extern volatile unsigned char CSCTL4_L;                           /* CS Control Register 4 */
extern volatile unsigned char CSCTL4_H;                           /* CS Control Register 4 */
extern volatile unsigned int CSCTL5;                            /* CS Control Register 5 */
extern volatile unsigned char CSCTL5_L;                           /* CS Control Register 5 */
extern volatile unsigned char CSCTL5_H;                           /* CS Control Register 5 */
extern volatile unsigned int CSCTL6;                            /* CS Control Register 6 */
extern volatile unsigned char CSCTL6_L;                           /* CS Control Register 6 */
extern volatile unsigned char CSCTL6_H;                           /* CS Control Register 6 */

/* CSCTL0 Control Bits */


/* CSCTL1 Control Bits */

/* CSCTL1 Control Bits */


/* CSCTL2 Control Bits */
//#define RESERVED            (0x0004)    /* RESERVED */
//#define RESERVED            (0x0008)    /* RESERVED */
//#define RESERVED            (0x0040)    /* RESERVED */
//#define RESERVED            (0x0080)    /* RESERVED */
//#define RESERVED            (0x0400)    /* RESERVED */
//#define RESERVED            (0x0800)    /* RESERVED */
//#define RESERVED            (0x1000)    /* RESERVED */
//#define RESERVED            (0x2000)    /* RESERVED */
//#define RESERVED            (0x4000)    /* RESERVED */
//#define RESERVED            (0x8000)    /* RESERVED */

/* CSCTL2 Control Bits */
//#define RESERVED            (0x0004)    /* RESERVED */
//#define RESERVED            (0x0008)    /* RESERVED */
//#define RESERVED            (0x0040)    /* RESERVED */
//#define RESERVED            (0x0080)    /* RESERVED */
//#define RESERVED            (0x0400)    /* RESERVED */
//#define RESERVED            (0x0800)    /* RESERVED */
//#define RESERVED            (0x1000)    /* RESERVED */
//#define RESERVED            (0x2000)    /* RESERVED */
//#define RESERVED            (0x4000)    /* RESERVED */
//#define RESERVED            (0x8000)    /* RESERVED */

/* CSCTL2 Control Bits */
//#define RESERVED            (0x0004)    /* RESERVED */
//#define RESERVED            (0x0008)    /* RESERVED */
//#define RESERVED            (0x0040)    /* RESERVED */
//#define RESERVED            (0x0080)    /* RESERVED */
//#define RESERVED            (0x0400)    /* RESERVED */
//#define RESERVED            (0x0800)    /* RESERVED */
//#define RESERVED            (0x1000)    /* RESERVED */
//#define RESERVED            (0x2000)    /* RESERVED */
//#define RESERVED            (0x4000)    /* RESERVED */
//#define RESERVED            (0x8000)    /* RESERVED */




/* CSCTL3 Control Bits */
//#define RESERVED            (0x0004)    /* RESERVED */
//#define RESERVED            (0x0008)    /* RESERVED */
//#define RESERVED            (0x0040)    /* RESERVED */
//#define RESERVED            (0x0080)    /* RESERVED */
//#define RESERVED            (0x0400)    /* RESERVED */
//#define RESERVED            (0x0800)    /* RESERVED */
//#define RESERVED            (0x1000)    /* RESERVED */
//#define RESERVED            (0x2000)    /* RESERVED */
//#define RESERVED            (0x4000)    /* RESERVED */
//#define RESERVED            (0x8000)    /* RESERVED */

/* CSCTL3 Control Bits */
//#define RESERVED            (0x0004)    /* RESERVED */
//#define RESERVED            (0x0008)    /* RESERVED */
//#define RESERVED            (0x0040)    /* RESERVED */
//#define RESERVED            (0x0080)    /* RESERVED */
//#define RESERVED            (0x0400)    /* RESERVED */
//#define RESERVED            (0x0800)    /* RESERVED */
//#define RESERVED            (0x1000)    /* RESERVED */
//#define RESERVED            (0x2000)    /* RESERVED */
//#define RESERVED            (0x4000)    /* RESERVED */
//#define RESERVED            (0x8000)    /* RESERVED */

/* CSCTL3 Control Bits */
//#define RESERVED            (0x0004)    /* RESERVED */
//#define RESERVED            (0x0008)    /* RESERVED */
//#define RESERVED            (0x0040)    /* RESERVED */
//#define RESERVED            (0x0080)    /* RESERVED */
//#define RESERVED            (0x0400)    /* RESERVED */
//#define RESERVED            (0x0800)    /* RESERVED */
//#define RESERVED            (0x1000)    /* RESERVED */
//#define RESERVED            (0x2000)    /* RESERVED */
//#define RESERVED            (0x4000)    /* RESERVED */
//#define RESERVED            (0x8000)    /* RESERVED */




/* CSCTL4 Control Bits */

/* CSCTL4 Control Bits */

/* CSCTL4 Control Bits */




/* CSCTL5 Control Bits */

/* CSCTL5 Control Bits */

/* CSCTL6 Control Bits */

/* CSCTL6 Control Bits */

/************************************************************
* DMA_X
************************************************************/

extern volatile unsigned int DMACTL0;                           /* DMA Module Control 0 */
extern volatile unsigned char DMACTL0_L;                          /* DMA Module Control 0 */
extern volatile unsigned char DMACTL0_H;                          /* DMA Module Control 0 */
extern volatile unsigned int DMACTL1;                           /* DMA Module Control 1 */
extern volatile unsigned char DMACTL1_L;                          /* DMA Module Control 1 */
extern volatile unsigned char DMACTL1_H;                          /* DMA Module Control 1 */
extern volatile unsigned int DMACTL2;                           /* DMA Module Control 2 */
extern volatile unsigned char DMACTL2_L;                          /* DMA Module Control 2 */
extern volatile unsigned char DMACTL2_H;                          /* DMA Module Control 2 */
extern volatile unsigned int DMACTL3;                           /* DMA Module Control 3 */
extern volatile unsigned char DMACTL3_L;                          /* DMA Module Control 3 */
extern volatile unsigned char DMACTL3_H;                          /* DMA Module Control 3 */
extern volatile unsigned int DMACTL4;                           /* DMA Module Control 4 */
extern volatile unsigned char DMACTL4_L;                          /* DMA Module Control 4 */
extern volatile unsigned char DMACTL4_H;                          /* DMA Module Control 4 */
extern volatile unsigned int DMAIV;                             /* DMA Interrupt Vector Word */
extern volatile unsigned char DMAIV_L;                            /* DMA Interrupt Vector Word */
extern volatile unsigned char DMAIV_H;                            /* DMA Interrupt Vector Word */

extern volatile unsigned int DMA0CTL;                           /* DMA Channel 0 Control */
extern volatile unsigned char DMA0CTL_L;                          /* DMA Channel 0 Control */
extern volatile unsigned char DMA0CTL_H;                          /* DMA Channel 0 Control */
extern __SFR_FARPTR DMA0SA;                            /* DMA Channel 0 Source Address */
extern volatile unsigned int DMA0SAL;                           /* DMA Channel 0 Source Address */
extern volatile unsigned int DMA0SAH;                           /* DMA Channel 0 Source Address */
extern __SFR_FARPTR DMA0DA;                            /* DMA Channel 0 Destination Address */
extern volatile unsigned int DMA0DAL;                           /* DMA Channel 0 Destination Address */
extern volatile unsigned int DMA0DAH;                           /* DMA Channel 0 Destination Address */
extern volatile unsigned int DMA0SZ;                            /* DMA Channel 0 Transfer Size */

extern volatile unsigned int DMA1CTL;                           /* DMA Channel 1 Control */
extern volatile unsigned char DMA1CTL_L;                          /* DMA Channel 1 Control */
extern volatile unsigned char DMA1CTL_H;                          /* DMA Channel 1 Control */
extern __SFR_FARPTR DMA1SA;                            /* DMA Channel 1 Source Address */
extern volatile unsigned int DMA1SAL;                           /* DMA Channel 1 Source Address */
extern volatile unsigned int DMA1SAH;                           /* DMA Channel 1 Source Address */
extern __SFR_FARPTR DMA1DA;                            /* DMA Channel 1 Destination Address */
extern volatile unsigned int DMA1DAL;                           /* DMA Channel 1 Destination Address */
extern volatile unsigned int DMA1DAH;                           /* DMA Channel 1 Destination Address */
extern volatile unsigned int DMA1SZ;                            /* DMA Channel 1 Transfer Size */

extern volatile unsigned int DMA2CTL;                           /* DMA Channel 2 Control */
extern volatile unsigned char DMA2CTL_L;                          /* DMA Channel 2 Control */
extern volatile unsigned char DMA2CTL_H;                          /* DMA Channel 2 Control */
extern __SFR_FARPTR DMA2SA;                            /* DMA Channel 2 Source Address */
extern volatile unsigned int DMA2SAL;                           /* DMA Channel 2 Source Address */
extern volatile unsigned int DMA2SAH;                           /* DMA Channel 2 Source Address */
extern __SFR_FARPTR DMA2DA;                            /* DMA Channel 2 Destination Address */
extern volatile unsigned int DMA2DAL;                           /* DMA Channel 2 Destination Address */
extern volatile unsigned int DMA2DAH;                           /* DMA Channel 2 Destination Address */
extern volatile unsigned int DMA2SZ;                            /* DMA Channel 2 Transfer Size */

/* DMACTL0 Control Bits */

/* DMACTL0 Control Bits */

/* DMACTL0 Control Bits */

/* DMACTL01 Control Bits */

/* DMACTL01 Control Bits */

/* DMACTL4 Control Bits */

/* DMACTL4 Control Bits */

/* DMAxCTL Control Bits */

/* DMAxCTL Control Bits */

/* DMAxCTL Control Bits */





/* DMAIV Definitions */







/*************************************************************
* FRAM Memory
*************************************************************/

extern volatile unsigned int FRCTL0;                            /* FRAM Controller Control 0 */
extern volatile unsigned char FRCTL0_L;                           /* FRAM Controller Control 0 */
extern volatile unsigned char FRCTL0_H;                           /* FRAM Controller Control 0 */
extern volatile unsigned int GCCTL0;                            /* General Control 0 */
extern volatile unsigned char GCCTL0_L;                           /* General Control 0 */
extern volatile unsigned char GCCTL0_H;                           /* General Control 0 */
extern volatile unsigned int GCCTL1;                            /* General Control 1 */
extern volatile unsigned char GCCTL1_L;                           /* General Control 1 */
extern volatile unsigned char GCCTL1_H;                           /* General Control 1 */


/* FRCTL0 Control Bits */
//#define RESERVED            (0x0001)  /* RESERVED */
//#define RESERVED            (0x0002)  /* RESERVED */
//#define RESERVED            (0x0004)  /* RESERVED */
//#define RESERVED            (0x0080)  /* RESERVED */

/* FRCTL0 Control Bits */
//#define RESERVED            (0x0001)  /* RESERVED */
//#define RESERVED            (0x0002)  /* RESERVED */
//#define RESERVED            (0x0004)  /* RESERVED */
//#define RESERVED            (0x0080)  /* RESERVED */


/* Legacy Defines */

/* GCCTL0 Control Bits */
//#define RESERVED            (0x0001)  /* RESERVED */
//#define RESERVED            (0x0010)  /* RESERVED */

/* GCCTL0 Control Bits */
//#define RESERVED            (0x0001)  /* RESERVED */
//#define RESERVED            (0x0010)  /* RESERVED */

/* GCCTL1 Control Bits */
//#define RESERVED            (0x0001)  /* RESERVED */

/* GCCTL1 Control Bits */
//#define RESERVED            (0x0001)  /* RESERVED */

/************************************************************
* Memory Protection Unit
************************************************************/

extern volatile unsigned int MPUCTL0;                           /* MPU Control Register 0 */
extern volatile unsigned char MPUCTL0_L;                          /* MPU Control Register 0 */
extern volatile unsigned char MPUCTL0_H;                          /* MPU Control Register 0 */
extern volatile unsigned int MPUCTL1;                           /* MPU Control Register 1 */
extern volatile unsigned char MPUCTL1_L;                          /* MPU Control Register 1 */
extern volatile unsigned char MPUCTL1_H;                          /* MPU Control Register 1 */
extern volatile unsigned int MPUSEGB2;                          /* MPU Segmentation Border 2 Register */
extern volatile unsigned char MPUSEGB2_L;                         /* MPU Segmentation Border 2 Register */
extern volatile unsigned char MPUSEGB2_H;                         /* MPU Segmentation Border 2 Register */
extern volatile unsigned int MPUSEGB1;                          /* MPU Segmentation Border 1 Register */
extern volatile unsigned char MPUSEGB1_L;                         /* MPU Segmentation Border 1 Register */
extern volatile unsigned char MPUSEGB1_H;                         /* MPU Segmentation Border 1 Register */
extern volatile unsigned int MPUSAM;                            /* MPU Access Management Register */
extern volatile unsigned char MPUSAM_L;                           /* MPU Access Management Register */
extern volatile unsigned char MPUSAM_H;                           /* MPU Access Management Register */
extern volatile unsigned int MPUIPC0;                           /* MPU IP Control 0 Register */
extern volatile unsigned char MPUIPC0_L;                          /* MPU IP Control 0 Register */
extern volatile unsigned char MPUIPC0_H;                          /* MPU IP Control 0 Register */
extern volatile unsigned int MPUIPSEGB2;                        /* MPU IP Segment Border 2 Register */
extern volatile unsigned char MPUIPSEGB2_L;                       /* MPU IP Segment Border 2 Register */
extern volatile unsigned char MPUIPSEGB2_H;                       /* MPU IP Segment Border 2 Register */
extern volatile unsigned int MPUIPSEGB1;                        /* MPU IP Segment Border 1 Register */
extern volatile unsigned char MPUIPSEGB1_L;                       /* MPU IP Segment Border 1 Register */
extern volatile unsigned char MPUIPSEGB1_H;                       /* MPU IP Segment Border 1 Register */

/* MPUCTL0 Control Bits */

/* MPUCTL0 Control Bits */


/* MPUCTL1 Control Bits */

/* MPUCTL1 Control Bits */

/* MPUSEGB2 Control Bits */

/* MPUSEGB2 Control Bits */

/* MPUSEGB2 Control Bits */

/* MPUSEGB1 Control Bits */

/* MPUSEGB1 Control Bits */

/* MPUSEGB1 Control Bits */

/* MPUSAM Control Bits */

/* MPUSAM Control Bits */

/* MPUSAM Control Bits */

/* MPUIPC0 Control Bits */

/* MPUIPC0 Control Bits */

/* MPUIPSEGB2 Control Bits */

/* MPUIPSEGB2 Control Bits */

/* MPUIPSEGB2 Control Bits */

/* MPUIPSEGB1 Control Bits */

/* MPUIPSEGB1 Control Bits */

/* MPUIPSEGB1 Control Bits */

/************************************************************
* HARDWARE MULTIPLIER 32Bit
************************************************************/

extern volatile unsigned int MPY;                               /* Multiply Unsigned/Operand 1 */
extern volatile unsigned char MPY_L;                              /* Multiply Unsigned/Operand 1 */
extern volatile unsigned char MPY_H;                              /* Multiply Unsigned/Operand 1 */
extern volatile unsigned int MPYS;                              /* Multiply Signed/Operand 1 */
extern volatile unsigned char MPYS_L;                             /* Multiply Signed/Operand 1 */
extern volatile unsigned char MPYS_H;                             /* Multiply Signed/Operand 1 */
extern volatile unsigned int MAC;                               /* Multiply Unsigned and Accumulate/Operand 1 */
extern volatile unsigned char MAC_L;                              /* Multiply Unsigned and Accumulate/Operand 1 */
extern volatile unsigned char MAC_H;                              /* Multiply Unsigned and Accumulate/Operand 1 */
extern volatile unsigned int MACS;                              /* Multiply Signed and Accumulate/Operand 1 */
extern volatile unsigned char MACS_L;                             /* Multiply Signed and Accumulate/Operand 1 */
extern volatile unsigned char MACS_H;                             /* Multiply Signed and Accumulate/Operand 1 */
extern volatile unsigned int OP2;                               /* Operand 2 */
extern volatile unsigned char OP2_L;                              /* Operand 2 */
extern volatile unsigned char OP2_H;                              /* Operand 2 */
extern volatile unsigned int RESLO;                             /* Result Low Word */
extern volatile unsigned char RESLO_L;                            /* Result Low Word */
extern volatile unsigned char RESLO_H;                            /* Result Low Word */
extern volatile unsigned int RESHI;                             /* Result High Word */
extern volatile unsigned char RESHI_L;                            /* Result High Word */
extern volatile unsigned char RESHI_H;                            /* Result High Word */
extern volatile unsigned int SUMEXT;                            /* Sum Extend */
extern volatile unsigned char SUMEXT_L;                           /* Sum Extend */
extern volatile unsigned char SUMEXT_H;                           /* Sum Extend */

extern volatile unsigned int MPY32L;                            /* 32-bit operand 1 - multiply - low word */
extern volatile unsigned char MPY32L_L;                           /* 32-bit operand 1 - multiply - low word */
extern volatile unsigned char MPY32L_H;                           /* 32-bit operand 1 - multiply - low word */
extern volatile unsigned int MPY32H;                            /* 32-bit operand 1 - multiply - high word */
extern volatile unsigned char MPY32H_L;                           /* 32-bit operand 1 - multiply - high word */
extern volatile unsigned char MPY32H_H;                           /* 32-bit operand 1 - multiply - high word */
extern volatile unsigned int MPYS32L;                           /* 32-bit operand 1 - signed multiply - low word */
extern volatile unsigned char MPYS32L_L;                          /* 32-bit operand 1 - signed multiply - low word */
extern volatile unsigned char MPYS32L_H;                          /* 32-bit operand 1 - signed multiply - low word */
extern volatile unsigned int MPYS32H;                           /* 32-bit operand 1 - signed multiply - high word */
extern volatile unsigned char MPYS32H_L;                          /* 32-bit operand 1 - signed multiply - high word */
extern volatile unsigned char MPYS32H_H;                          /* 32-bit operand 1 - signed multiply - high word */
extern volatile unsigned int MAC32L;                            /* 32-bit operand 1 - multiply accumulate - low word */
extern volatile unsigned char MAC32L_L;                           /* 32-bit operand 1 - multiply accumulate - low word */
extern volatile unsigned char MAC32L_H;                           /* 32-bit operand 1 - multiply accumulate - low word */
extern volatile unsigned int MAC32H;                            /* 32-bit operand 1 - multiply accumulate - high word */
extern volatile unsigned char MAC32H_L;                           /* 32-bit operand 1 - multiply accumulate - high word */
extern volatile unsigned char MAC32H_H;                           /* 32-bit operand 1 - multiply accumulate - high word */
extern volatile unsigned int MACS32L;                           /* 32-bit operand 1 - signed multiply accumulate - low word */
extern volatile unsigned char MACS32L_L;                          /* 32-bit operand 1 - signed multiply accumulate - low word */
extern volatile unsigned char MACS32L_H;                          /* 32-bit operand 1 - signed multiply accumulate - low word */
extern volatile unsigned int MACS32H;                           /* 32-bit operand 1 - signed multiply accumulate - high word */
extern volatile unsigned char MACS32H_L;                          /* 32-bit operand 1 - signed multiply accumulate - high word */
extern volatile unsigned char MACS32H_H;                          /* 32-bit operand 1 - signed multiply accumulate - high word */
extern volatile unsigned int OP2L;                              /* 32-bit operand 2 - low word */
extern volatile unsigned char OP2L_L;                             /* 32-bit operand 2 - low word */
extern volatile unsigned char OP2L_H;                             /* 32-bit operand 2 - low word */
extern volatile unsigned int OP2H;                              /* 32-bit operand 2 - high word */
extern volatile unsigned char OP2H_L;                             /* 32-bit operand 2 - high word */
extern volatile unsigned char OP2H_H;                             /* 32-bit operand 2 - high word */
extern volatile unsigned int RES0;                              /* 32x32-bit result 0 - least significant word */
extern volatile unsigned char RES0_L;                             /* 32x32-bit result 0 - least significant word */
extern volatile unsigned char RES0_H;                             /* 32x32-bit result 0 - least significant word */
extern volatile unsigned int RES1;                              /* 32x32-bit result 1 */
extern volatile unsigned char RES1_L;                             /* 32x32-bit result 1 */
extern volatile unsigned char RES1_H;                             /* 32x32-bit result 1 */
extern volatile unsigned int RES2;                              /* 32x32-bit result 2 */
extern volatile unsigned char RES2_L;                             /* 32x32-bit result 2 */
extern volatile unsigned char RES2_H;                             /* 32x32-bit result 2 */
extern volatile unsigned int RES3;                              /* 32x32-bit result 3 - most significant word */
extern volatile unsigned char RES3_L;                             /* 32x32-bit result 3 - most significant word */
extern volatile unsigned char RES3_H;                             /* 32x32-bit result 3 - most significant word */
extern volatile unsigned int MPY32CTL0;                         /* MPY32 Control Register 0 */
extern volatile unsigned char MPY32CTL0_L;                        /* MPY32 Control Register 0 */
extern volatile unsigned char MPY32CTL0_H;                        /* MPY32 Control Register 0 */


/* MPY32CTL0 Control Bits */
//#define RESERVED            (0x0002)  /* Reserved */

/* MPY32CTL0 Control Bits */
//#define RESERVED            (0x0002)  /* Reserved */

/* MPY32CTL0 Control Bits */
//#define RESERVED            (0x0002)  /* Reserved */


/************************************************************
* PMM - Power Management System for FRAM
************************************************************/

extern volatile unsigned int PMMCTL0;                           /* PMM Control 0 */
extern volatile unsigned char PMMCTL0_L;                          /* PMM Control 0 */
extern volatile unsigned char PMMCTL0_H;                          /* PMM Control 0 */
extern volatile unsigned int PMMIFG;                            /* PMM Interrupt Flag */
extern volatile unsigned char PMMIFG_L;                           /* PMM Interrupt Flag */
extern volatile unsigned char PMMIFG_H;                           /* PMM Interrupt Flag */
extern volatile unsigned int PM5CTL0;                           /* PMM Power Mode 5 Control Register 0 */
extern volatile unsigned char PM5CTL0_L;                          /* PMM Power Mode 5 Control Register 0 */
extern volatile unsigned char PM5CTL0_H;                          /* PMM Power Mode 5 Control Register 0 */


/* PMMCTL0 Control Bits */

/* PMMCTL0 Control Bits */

/* PMMIFG Control Bits */

/* PMMIFG Control Bits */

/* PM5CTL0 Power Mode 5 Control Bits */

/* PM5CTL0 Power Mode 5 Control Bits */


/************************************************************
* DIGITAL I/O Port1/2 Pull up / Pull down Resistors
************************************************************/

extern volatile unsigned int PAIN;                              /* Port A Input */
extern volatile unsigned char PAIN_L;                             /* Port A Input */
extern volatile unsigned char PAIN_H;                             /* Port A Input */
extern volatile unsigned int PAOUT;                             /* Port A Output */
extern volatile unsigned char PAOUT_L;                            /* Port A Output */
extern volatile unsigned char PAOUT_H;                            /* Port A Output */
extern volatile unsigned int PADIR;                             /* Port A Direction */
extern volatile unsigned char PADIR_L;                            /* Port A Direction */
extern volatile unsigned char PADIR_H;                            /* Port A Direction */
extern volatile unsigned int PAREN;                             /* Port A Resistor Enable */
extern volatile unsigned char PAREN_L;                            /* Port A Resistor Enable */
extern volatile unsigned char PAREN_H;                            /* Port A Resistor Enable */
extern volatile unsigned int PASEL0;                            /* Port A Selection 0 */
extern volatile unsigned char PASEL0_L;                           /* Port A Selection 0 */
extern volatile unsigned char PASEL0_H;                           /* Port A Selection 0 */
extern volatile unsigned int PASEL1;                            /* Port A Selection 1 */
extern volatile unsigned char PASEL1_L;                           /* Port A Selection 1 */
extern volatile unsigned char PASEL1_H;                           /* Port A Selection 1 */
extern volatile unsigned int PASELC;                            /* Port A Complement Selection */
extern volatile unsigned char PASELC_L;                           /* Port A Complement Selection */
extern volatile unsigned char PASELC_H;                           /* Port A Complement Selection */
extern volatile unsigned int PAIES;                             /* Port A Interrupt Edge Select */
extern volatile unsigned char PAIES_L;                            /* Port A Interrupt Edge Select */
extern volatile unsigned char PAIES_H;                            /* Port A Interrupt Edge Select */
extern volatile unsigned int PAIE;                              /* Port A Interrupt Enable */
extern volatile unsigned char PAIE_L;                             /* Port A Interrupt Enable */
extern volatile unsigned char PAIE_H;                             /* Port A Interrupt Enable */
extern volatile unsigned int PAIFG;                             /* Port A Interrupt Flag */
extern volatile unsigned char PAIFG_L;                            /* Port A Interrupt Flag */
extern volatile unsigned char PAIFG_H;                            /* Port A Interrupt Flag */


extern volatile unsigned int P1IV;                              /* Port 1 Interrupt Vector Word */
extern volatile unsigned int P2IV;                              /* Port 2 Interrupt Vector Word */

//Definitions for P1IV


//Definitions for P2IV


/************************************************************
* DIGITAL I/O Port3/4 Pull up / Pull down Resistors
************************************************************/

extern volatile unsigned int PBIN;                              /* Port B Input */
extern volatile unsigned char PBIN_L;                             /* Port B Input */
extern volatile unsigned char PBIN_H;                             /* Port B Input */
extern volatile unsigned int PBOUT;                             /* Port B Output */
extern volatile unsigned char PBOUT_L;                            /* Port B Output */
extern volatile unsigned char PBOUT_H;                            /* Port B Output */
extern volatile unsigned int PBDIR;                             /* Port B Direction */
extern volatile unsigned char PBDIR_L;                            /* Port B Direction */
extern volatile unsigned char PBDIR_H;                            /* Port B Direction */
extern volatile unsigned int PBREN;                             /* Port B Resistor Enable */
extern volatile unsigned char PBREN_L;                            /* Port B Resistor Enable */
extern volatile unsigned char PBREN_H;                            /* Port B Resistor Enable */
extern volatile unsigned int PBSEL0;                            /* Port B Selection 0 */
extern volatile unsigned char PBSEL0_L;                           /* Port B Selection 0 */
extern volatile unsigned char PBSEL0_H;                           /* Port B Selection 0 */
extern volatile unsigned int PBSEL1;                            /* Port B Selection 1 */
extern volatile unsigned char PBSEL1_L;                           /* Port B Selection 1 */
extern volatile unsigned char PBSEL1_H;                           /* Port B Selection 1 */
extern volatile unsigned int PBSELC;                            /* Port B Complement Selection */
extern volatile unsigned char PBSELC_L;                           /* Port B Complement Selection */
extern volatile unsigned char PBSELC_H;                           /* Port B Complement Selection */
extern volatile unsigned int PBIES;                             /* Port B Interrupt Edge Select */
extern volatile unsigned char PBIES_L;                            /* Port B Interrupt Edge Select */
extern volatile unsigned char PBIES_H;                            /* Port B Interrupt Edge Select */
extern volatile unsigned int PBIE;                              /* Port B Interrupt Enable */
extern volatile unsigned char PBIE_L;                             /* Port B Interrupt Enable */
extern volatile unsigned char PBIE_H;                             /* Port B Interrupt Enable */
extern volatile unsigned int PBIFG;                             /* Port B Interrupt Flag */
extern volatile unsigned char PBIFG_L;                            /* Port B Interrupt Flag */
extern volatile unsigned char PBIFG_H;                            /* Port B Interrupt Flag */


extern volatile unsigned int P3IV;                              /* Port 3 Interrupt Vector Word */
extern volatile unsigned int P4IV;                              /* Port 4 Interrupt Vector Word */

//Definitions for P3IV


//Definitions for P4IV


/************************************************************
* DIGITAL I/O PortJ Pull up / Pull down Resistors
************************************************************/

extern volatile unsigned int PJIN;                              /* Port J Input */
extern volatile unsigned char PJIN_L;                             /* Port J Input */
extern volatile unsigned char PJIN_H;                             /* Port J Input */
extern volatile unsigned int PJOUT;                             /* Port J Output */
extern volatile unsigned char PJOUT_L;                            /* Port J Output */
extern volatile unsigned char PJOUT_H;                            /* Port J Output */
extern volatile unsigned int PJDIR;                             /* Port J Direction */
extern volatile unsigned char PJDIR_L;                            /* Port J Direction */
extern volatile unsigned char PJDIR_H;                            /* Port J Direction */
extern volatile unsigned int PJREN;                             /* Port J Resistor Enable */
extern volatile unsigned char PJREN_L;                            /* Port J Resistor Enable */
extern volatile unsigned char PJREN_H;                            /* Port J Resistor Enable */
extern volatile unsigned int PJSEL0;                            /* Port J Selection 0 */
extern volatile unsigned char PJSEL0_L;                           /* Port J Selection 0 */
extern volatile unsigned char PJSEL0_H;                           /* Port J Selection 0 */
extern volatile unsigned int PJSEL1;                            /* Port J Selection 1 */
extern volatile unsigned char PJSEL1_L;                           /* Port J Selection 1 */
extern volatile unsigned char PJSEL1_H;                           /* Port J Selection 1 */
extern volatile unsigned int PJSELC;                            /* Port J Complement Selection */
extern volatile unsigned char PJSELC_L;                           /* Port J Complement Selection */
extern volatile unsigned char PJSELC_H;                           /* Port J Complement Selection */

/************************************************************
* Shared Reference
************************************************************/

extern volatile unsigned int REFCTL0;                           /* REF Shared Reference control register 0 */
extern volatile unsigned char REFCTL0_L;                          /* REF Shared Reference control register 0 */
extern volatile unsigned char REFCTL0_H;                          /* REF Shared Reference control register 0 */

/* REFCTL0 Control Bits */
//#define RESERVED            (0x0004)  /* Reserved */
//#define RESERVED            (0x4000)  /* Reserved */
//#define RESERVED            (0x8000)  /* Reserved */

/* REFCTL0 Control Bits */
//#define RESERVED            (0x0004)  /* Reserved */
//#define RESERVED            (0x4000)  /* Reserved */
//#define RESERVED            (0x8000)  /* Reserved */

/* REFCTL0 Control Bits */
//#define RESERVED            (0x0004)  /* Reserved */
//#define RESERVED            (0x4000)  /* Reserved */
//#define RESERVED            (0x8000)  /* Reserved */


/************************************************************
* Real Time Clock
************************************************************/

extern volatile unsigned int RTCCTL01;                          /* Real Timer Control 0/1 */
extern volatile unsigned char RTCCTL01_L;                         /* Real Timer Control 0/1 */
extern volatile unsigned char RTCCTL01_H;                         /* Real Timer Control 0/1 */
extern volatile unsigned int RTCCTL23;                          /* Real Timer Control 2/3 */
extern volatile unsigned char RTCCTL23_L;                         /* Real Timer Control 2/3 */
extern volatile unsigned char RTCCTL23_H;                         /* Real Timer Control 2/3 */
extern volatile unsigned int RTCPS0CTL;                         /* Real Timer Prescale Timer 0 Control */
extern volatile unsigned char RTCPS0CTL_L;                        /* Real Timer Prescale Timer 0 Control */
extern volatile unsigned char RTCPS0CTL_H;                        /* Real Timer Prescale Timer 0 Control */
extern volatile unsigned int RTCPS1CTL;                         /* Real Timer Prescale Timer 1 Control */
extern volatile unsigned char RTCPS1CTL_L;                        /* Real Timer Prescale Timer 1 Control */
extern volatile unsigned char RTCPS1CTL_H;                        /* Real Timer Prescale Timer 1 Control */
extern volatile unsigned int RTCPS;                             /* Real Timer Prescale Timer Control */
extern volatile unsigned char RTCPS_L;                            /* Real Timer Prescale Timer Control */
extern volatile unsigned char RTCPS_H;                            /* Real Timer Prescale Timer Control */
extern volatile unsigned int RTCIV;                             /* Real Time Clock Interrupt Vector */
extern volatile unsigned int RTCTIM0;                           /* Real Time Clock Time 0 */
extern volatile unsigned char RTCTIM0_L;                          /* Real Time Clock Time 0 */
extern volatile unsigned char RTCTIM0_H;                          /* Real Time Clock Time 0 */
extern volatile unsigned int RTCTIM1;                           /* Real Time Clock Time 1 */
extern volatile unsigned char RTCTIM1_L;                          /* Real Time Clock Time 1 */
extern volatile unsigned char RTCTIM1_H;                          /* Real Time Clock Time 1 */
extern volatile unsigned int RTCDATE;                           /* Real Time Clock Date */
extern volatile unsigned char RTCDATE_L;                          /* Real Time Clock Date */
extern volatile unsigned char RTCDATE_H;                          /* Real Time Clock Date */
extern volatile unsigned int RTCYEAR;                           /* Real Time Clock Year */
extern volatile unsigned char RTCYEAR_L;                          /* Real Time Clock Year */
extern volatile unsigned char RTCYEAR_H;                          /* Real Time Clock Year */
extern volatile unsigned int RTCAMINHR;                         /* Real Time Clock Alarm Min/Hour */
extern volatile unsigned char RTCAMINHR_L;                        /* Real Time Clock Alarm Min/Hour */
extern volatile unsigned char RTCAMINHR_H;                        /* Real Time Clock Alarm Min/Hour */
extern volatile unsigned int RTCADOWDAY;                        /* Real Time Clock Alarm day of week/day */
extern volatile unsigned char RTCADOWDAY_L;                       /* Real Time Clock Alarm day of week/day */
extern volatile unsigned char RTCADOWDAY_H;                       /* Real Time Clock Alarm day of week/day */
extern volatile unsigned int BIN2BCD;                           /* Real Time Binary-to-BCD conversion register */
extern volatile unsigned int BCD2BIN;                           /* Real Time BCD-to-binary conversion register */


/* RTCCTL01 Control Bits */
//#define RESERVED            (0x2000)     /* RESERVED */
//#define RESERVED            (0x0800)     /* RESERVED */
//#define RESERVED            (0x0400)     /* RESERVED */

/* RTCCTL01 Control Bits */
//#define RESERVED            (0x2000)     /* RESERVED */
//#define RESERVED            (0x0800)     /* RESERVED */
//#define RESERVED            (0x0400)     /* RESERVED */

/* RTCCTL01 Control Bits */
//#define RESERVED            (0x2000)     /* RESERVED */
//#define RESERVED            (0x0800)     /* RESERVED */
//#define RESERVED            (0x0400)     /* RESERVED */


/* RTCCTL23 Control Bits */
//#define Reserved          (0x0040)

/* RTCCTL23 Control Bits */
//#define Reserved          (0x0040)

/* RTCCTL23 Control Bits */
//#define Reserved          (0x0040)



/* RTCPS0CTL Control Bits */
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)

/* RTCPS0CTL Control Bits */
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)



/* RTCPS1CTL Control Bits */
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)

/* RTCPS1CTL Control Bits */
//#define Reserved          (0x0080)
//#define Reserved          (0x0040)
//#define Reserved          (0x0020)



/* RTC Definitions */

/* Legacy Definitions */

/************************************************************
* SFR - Special Function Register Module
************************************************************/

extern volatile unsigned int SFRIE1;                            /* Interrupt Enable 1 */
extern volatile unsigned char SFRIE1_L;                           /* Interrupt Enable 1 */
extern volatile unsigned char SFRIE1_H;                           /* Interrupt Enable 1 */

/* SFRIE1 Control Bits */
//#define Reserved          (0x0004)

//#define Reserved          (0x0004)

extern volatile unsigned int SFRIFG1;                           /* Interrupt Flag 1 */
extern volatile unsigned char SFRIFG1_L;                          /* Interrupt Flag 1 */
extern volatile unsigned char SFRIFG1_H;                          /* Interrupt Flag 1 */
/* SFRIFG1 Control Bits */
//#define Reserved          (0x0004)
//#define Reserved          (0x0020)

//#define Reserved          (0x0004)
//#define Reserved          (0x0020)

extern volatile unsigned int SFRRPCR;                           /* RESET Pin Control Register */
extern volatile unsigned char SFRRPCR_L;                          /* RESET Pin Control Register */
extern volatile unsigned char SFRRPCR_H;                          /* RESET Pin Control Register */
/* SFRRPCR Control Bits */


/************************************************************
* SYS - System Module
************************************************************/

extern volatile unsigned int SYSCTL;                            /* System control */
extern volatile unsigned char SYSCTL_L;                           /* System control */
extern volatile unsigned char SYSCTL_H;                           /* System control */
extern volatile unsigned int SYSJMBC;                           /* JTAG mailbox control */
extern volatile unsigned char SYSJMBC_L;                          /* JTAG mailbox control */
extern volatile unsigned char SYSJMBC_H;                          /* JTAG mailbox control */
extern volatile unsigned int SYSJMBI0;                          /* JTAG mailbox input 0 */
extern volatile unsigned char SYSJMBI0_L;                         /* JTAG mailbox input 0 */
extern volatile unsigned char SYSJMBI0_H;                         /* JTAG mailbox input 0 */
extern volatile unsigned int SYSJMBI1;                          /* JTAG mailbox input 1 */
extern volatile unsigned char SYSJMBI1_L;                         /* JTAG mailbox input 1 */
extern volatile unsigned char SYSJMBI1_H;                         /* JTAG mailbox input 1 */
extern volatile unsigned int SYSJMBO0;                          /* JTAG mailbox output 0 */
extern volatile unsigned char SYSJMBO0_L;                         /* JTAG mailbox output 0 */
extern volatile unsigned char SYSJMBO0_H;                         /* JTAG mailbox output 0 */
extern volatile unsigned int SYSJMBO1;                          /* JTAG mailbox output 1 */
extern volatile unsigned char SYSJMBO1_L;                         /* JTAG mailbox output 1 */
extern volatile unsigned char SYSJMBO1_H;                         /* JTAG mailbox output 1 */

extern volatile unsigned int SYSUNIV;                           /* User NMI vector generator */
extern volatile unsigned char SYSUNIV_L;                          /* User NMI vector generator */
extern volatile unsigned char SYSUNIV_H;                          /* User NMI vector generator */
extern volatile unsigned int SYSSNIV;                           /* System NMI vector generator */
extern volatile unsigned char SYSSNIV_L;                          /* System NMI vector generator */
extern volatile unsigned char SYSSNIV_H;                          /* System NMI vector generator */
extern volatile unsigned int SYSRSTIV;                          /* Reset vector generator */
extern volatile unsigned char SYSRSTIV_L;                         /* Reset vector generator */
extern volatile unsigned char SYSRSTIV_H;                         /* Reset vector generator */

/* SYSCTL Control Bits */
//#define RESERVED            (0x0002)  /* SYS - Reserved */
//#define RESERVED            (0x0008)  /* SYS - Reserved */
//#define RESERVED            (0x0040)  /* SYS - Reserved */
//#define RESERVED            (0x0080)  /* SYS - Reserved */
//#define RESERVED            (0x0100)  /* SYS - Reserved */
//#define RESERVED            (0x0200)  /* SYS - Reserved */
//#define RESERVED            (0x0400)  /* SYS - Reserved */
//#define RESERVED            (0x0800)  /* SYS - Reserved */
//#define RESERVED            (0x1000)  /* SYS - Reserved */
//#define RESERVED            (0x2000)  /* SYS - Reserved */
//#define RESERVED            (0x4000)  /* SYS - Reserved */
//#define RESERVED            (0x8000)  /* SYS - Reserved */

/* SYSCTL Control Bits */
//#define RESERVED            (0x0002)  /* SYS - Reserved */
//#define RESERVED            (0x0008)  /* SYS - Reserved */
//#define RESERVED            (0x0040)  /* SYS - Reserved */
//#define RESERVED            (0x0080)  /* SYS - Reserved */
//#define RESERVED            (0x0100)  /* SYS - Reserved */
//#define RESERVED            (0x0200)  /* SYS - Reserved */
//#define RESERVED            (0x0400)  /* SYS - Reserved */
//#define RESERVED            (0x0800)  /* SYS - Reserved */
//#define RESERVED            (0x1000)  /* SYS - Reserved */
//#define RESERVED            (0x2000)  /* SYS - Reserved */
//#define RESERVED            (0x4000)  /* SYS - Reserved */
//#define RESERVED            (0x8000)  /* SYS - Reserved */

/* SYSJMBC Control Bits */
//#define RESERVED            (0x0020)  /* SYS - Reserved */
//#define RESERVED            (0x0100)  /* SYS - Reserved */
//#define RESERVED            (0x0200)  /* SYS - Reserved */
//#define RESERVED            (0x0400)  /* SYS - Reserved */
//#define RESERVED            (0x0800)  /* SYS - Reserved */
//#define RESERVED            (0x1000)  /* SYS - Reserved */
//#define RESERVED            (0x2000)  /* SYS - Reserved */
//#define RESERVED            (0x4000)  /* SYS - Reserved */
//#define RESERVED            (0x8000)  /* SYS - Reserved */

/* SYSJMBC Control Bits */
//#define RESERVED            (0x0020)  /* SYS - Reserved */
//#define RESERVED            (0x0100)  /* SYS - Reserved */
//#define RESERVED            (0x0200)  /* SYS - Reserved */
//#define RESERVED            (0x0400)  /* SYS - Reserved */
//#define RESERVED            (0x0800)  /* SYS - Reserved */
//#define RESERVED            (0x1000)  /* SYS - Reserved */
//#define RESERVED            (0x2000)  /* SYS - Reserved */
//#define RESERVED            (0x4000)  /* SYS - Reserved */
//#define RESERVED            (0x8000)  /* SYS - Reserved */


/* SYSUNIV Definitions */

/* SYSSNIV Definitions */

/* SYSRSTIV Definitions */

/************************************************************
* Timer0_A3
************************************************************/

extern volatile unsigned int TA0CTL;                            /* Timer0_A3 Control */
extern volatile unsigned int TA0CCTL0;                          /* Timer0_A3 Capture/Compare Control 0 */
extern volatile unsigned int TA0CCTL1;                          /* Timer0_A3 Capture/Compare Control 1 */
extern volatile unsigned int TA0CCTL2;                          /* Timer0_A3 Capture/Compare Control 2 */
extern volatile unsigned int TA0R;                              /* Timer0_A3 */
extern volatile unsigned int TA0CCR0;                           /* Timer0_A3 Capture/Compare 0 */
extern volatile unsigned int TA0CCR1;                           /* Timer0_A3 Capture/Compare 1 */
extern volatile unsigned int TA0CCR2;                           /* Timer0_A3 Capture/Compare 2 */
extern volatile unsigned int TA0IV;                             /* Timer0_A3 Interrupt Vector Word */
extern volatile unsigned int TA0EX0;                            /* Timer0_A3 Expansion Register 0 */

/* TAxCTL Control Bits */


/* TAxCCTLx Control Bits */


/* TAxEX0 Control Bits */


/* T0A3IV Definitions */

/* Legacy Defines */

/************************************************************
* Timer1_A3
************************************************************/

extern volatile unsigned int TA1CTL;                            /* Timer1_A3 Control */
extern volatile unsigned int TA1CCTL0;                          /* Timer1_A3 Capture/Compare Control 0 */
extern volatile unsigned int TA1CCTL1;                          /* Timer1_A3 Capture/Compare Control 1 */
extern volatile unsigned int TA1CCTL2;                          /* Timer1_A3 Capture/Compare Control 2 */
extern volatile unsigned int TA1R;                              /* Timer1_A3 */
extern volatile unsigned int TA1CCR0;                           /* Timer1_A3 Capture/Compare 0 */
extern volatile unsigned int TA1CCR1;                           /* Timer1_A3 Capture/Compare 1 */
extern volatile unsigned int TA1CCR2;                           /* Timer1_A3 Capture/Compare 2 */
extern volatile unsigned int TA1IV;                             /* Timer1_A3 Interrupt Vector Word */
extern volatile unsigned int TA1EX0;                            /* Timer1_A3 Expansion Register 0 */

/* Bits are already defined within the Timer0_Ax */

/* TA1IV Definitions */

/* Legacy Defines */

/************************************************************
* Timer2_A2
************************************************************/

extern volatile unsigned int TA2CTL;                            /* Timer2_A2 Control */
extern volatile unsigned int TA2CCTL0;                          /* Timer2_A2 Capture/Compare Control 0 */
extern volatile unsigned int TA2CCTL1;                          /* Timer2_A2 Capture/Compare Control 1 */
extern volatile unsigned int TA2R;                              /* Timer2_A2 */
extern volatile unsigned int TA2CCR0;                           /* Timer2_A2 Capture/Compare 0 */
extern volatile unsigned int TA2CCR1;                           /* Timer2_A2 Capture/Compare 1 */
extern volatile unsigned int TA2IV;                             /* Timer2_A2 Interrupt Vector Word */
extern volatile unsigned int TA2EX0;                            /* Timer2_A2 Expansion Register 0 */

/* Bits are already defined within the Timer0_Ax */

/* TA2IV Definitions */

/* Legacy Defines */

/************************************************************
* Timer3_A2
************************************************************/

extern volatile unsigned int TA3CTL;                            /* Timer3_A2 Control */
extern volatile unsigned int TA3CCTL0;                          /* Timer3_A2 Capture/Compare Control 0 */
extern volatile unsigned int TA3CCTL1;                          /* Timer3_A2 Capture/Compare Control 1 */
extern volatile unsigned int TA3R;                              /* Timer3_A2 */
extern volatile unsigned int TA3CCR0;                           /* Timer3_A2 Capture/Compare 0 */
extern volatile unsigned int TA3CCR1;                           /* Timer3_A2 Capture/Compare 1 */
extern volatile unsigned int TA3IV;                             /* Timer3_A2 Interrupt Vector Word */
extern volatile unsigned int TA3EX0;                            /* Timer3_A2 Expansion Register 0 */

/* Bits are already defined within the Timer0_Ax */

/* TA3IV Definitions */

/* Legacy Defines */

/************************************************************
* Timer0_B7
************************************************************/

extern volatile unsigned int TB0CTL;                            /* Timer0_B7 Control */
extern volatile unsigned int TB0CCTL0;                          /* Timer0_B7 Capture/Compare Control 0 */
extern volatile unsigned int TB0CCTL1;                          /* Timer0_B7 Capture/Compare Control 1 */
extern volatile unsigned int TB0CCTL2;                          /* Timer0_B7 Capture/Compare Control 2 */
extern volatile unsigned int TB0CCTL3;                          /* Timer0_B7 Capture/Compare Control 3 */
extern volatile unsigned int TB0CCTL4;                          /* Timer0_B7 Capture/Compare Control 4 */
extern volatile unsigned int TB0CCTL5;                          /* Timer0_B7 Capture/Compare Control 5 */
extern volatile unsigned int TB0CCTL6;                          /* Timer0_B7 Capture/Compare Control 6 */
extern volatile unsigned int TB0R;                              /* Timer0_B7 */
extern volatile unsigned int TB0CCR0;                           /* Timer0_B7 Capture/Compare 0 */
extern volatile unsigned int TB0CCR1;                           /* Timer0_B7 Capture/Compare 1 */
extern volatile unsigned int TB0CCR2;                           /* Timer0_B7 Capture/Compare 2 */
extern volatile unsigned int TB0CCR3;                           /* Timer0_B7 Capture/Compare 3 */
extern volatile unsigned int TB0CCR4;                           /* Timer0_B7 Capture/Compare 4 */
extern volatile unsigned int TB0CCR5;                           /* Timer0_B7 Capture/Compare 5 */
extern volatile unsigned int TB0CCR6;                           /* Timer0_B7 Capture/Compare 6 */
extern volatile unsigned int TB0EX0;                            /* Timer0_B7 Expansion Register 0 */
extern volatile unsigned int TB0IV;                             /* Timer0_B7 Interrupt Vector Word */

/* Legacy Type Definitions for TimerB */

/* TBxCTL Control Bits */



/* Additional Timer B Control Register bits are defined in Timer A */
/* TBxCCTLx Control Bits */




/* TBxEX0 Control Bits */


/* TB0IV Definitions */

/* Legacy Defines */


/************************************************************
* USCI A0
************************************************************/

extern volatile unsigned int UCA0CTLW0;                         /* USCI A0 Control Word Register 0 */
extern volatile unsigned char UCA0CTLW0_L;                        /* USCI A0 Control Word Register 0 */
extern volatile unsigned char UCA0CTLW0_H;                        /* USCI A0 Control Word Register 0 */
extern volatile unsigned int UCA0CTLW1;                         /* USCI A0 Control Word Register 1 */
extern volatile unsigned char UCA0CTLW1_L;                        /* USCI A0 Control Word Register 1 */
extern volatile unsigned char UCA0CTLW1_H;                        /* USCI A0 Control Word Register 1 */
extern volatile unsigned int UCA0BRW;                           /* USCI A0 Baud Word Rate 0 */
extern volatile unsigned char UCA0BRW_L;                          /* USCI A0 Baud Word Rate 0 */
extern volatile unsigned char UCA0BRW_H;                          /* USCI A0 Baud Word Rate 0 */
extern volatile unsigned int UCA0MCTLW;                         /* USCI A0 Modulation Control */
extern volatile unsigned char UCA0MCTLW_L;                        /* USCI A0 Modulation Control */
extern volatile unsigned char UCA0MCTLW_H;                        /* USCI A0 Modulation Control */
extern volatile unsigned char UCA0STATW;                          /* USCI A0 Status Register */
extern volatile unsigned int UCA0RXBUF;                         /* USCI A0 Receive Buffer */
extern volatile unsigned char UCA0RXBUF_L;                        /* USCI A0 Receive Buffer */
extern volatile unsigned char UCA0RXBUF_H;                        /* USCI A0 Receive Buffer */
extern volatile unsigned int UCA0TXBUF;                         /* USCI A0 Transmit Buffer */
extern volatile unsigned char UCA0TXBUF_L;                        /* USCI A0 Transmit Buffer */
extern volatile unsigned char UCA0TXBUF_H;                        /* USCI A0 Transmit Buffer */
extern volatile unsigned char UCA0ABCTL;                          /* USCI A0 LIN Control */
extern volatile unsigned int UCA0IRCTL;                         /* USCI A0 IrDA Transmit Control */
extern volatile unsigned char UCA0IRCTL_L;                        /* USCI A0 IrDA Transmit Control */
extern volatile unsigned char UCA0IRCTL_H;                        /* USCI A0 IrDA Transmit Control */
extern volatile unsigned int UCA0IE;                            /* USCI A0 Interrupt Enable Register */
extern volatile unsigned char UCA0IE_L;                           /* USCI A0 Interrupt Enable Register */
extern volatile unsigned char UCA0IE_H;                           /* USCI A0 Interrupt Enable Register */
extern volatile unsigned int UCA0IFG;                           /* USCI A0 Interrupt Flags Register */
extern volatile unsigned char UCA0IFG_L;                          /* USCI A0 Interrupt Flags Register */
extern volatile unsigned char UCA0IFG_H;                          /* USCI A0 Interrupt Flags Register */
extern volatile unsigned int UCA0IV;                            /* USCI A0 Interrupt Vector Register */


/************************************************************
* USCI A1
************************************************************/

extern volatile unsigned int UCA1CTLW0;                         /* USCI A1 Control Word Register 0 */
extern volatile unsigned char UCA1CTLW0_L;                        /* USCI A1 Control Word Register 0 */
extern volatile unsigned char UCA1CTLW0_H;                        /* USCI A1 Control Word Register 0 */
extern volatile unsigned int UCA1CTLW1;                         /* USCI A1 Control Word Register 1 */
extern volatile unsigned char UCA1CTLW1_L;                        /* USCI A1 Control Word Register 1 */
extern volatile unsigned char UCA1CTLW1_H;                        /* USCI A1 Control Word Register 1 */
extern volatile unsigned int UCA1BRW;                           /* USCI A1 Baud Word Rate 0 */
extern volatile unsigned char UCA1BRW_L;                          /* USCI A1 Baud Word Rate 0 */
extern volatile unsigned char UCA1BRW_H;                          /* USCI A1 Baud Word Rate 0 */
extern volatile unsigned int UCA1MCTLW;                         /* USCI A1 Modulation Control */
extern volatile unsigned char UCA1MCTLW_L;                        /* USCI A1 Modulation Control */
extern volatile unsigned char UCA1MCTLW_H;                        /* USCI A1 Modulation Control */
extern volatile unsigned char UCA1STATW;                          /* USCI A1 Status Register */
extern volatile unsigned int UCA1RXBUF;                         /* USCI A1 Receive Buffer */
extern volatile unsigned char UCA1RXBUF_L;                        /* USCI A1 Receive Buffer */
extern volatile unsigned char UCA1RXBUF_H;                        /* USCI A1 Receive Buffer */
extern volatile unsigned int UCA1TXBUF;                         /* USCI A1 Transmit Buffer */
extern volatile unsigned char UCA1TXBUF_L;                        /* USCI A1 Transmit Buffer */
extern volatile unsigned char UCA1TXBUF_H;                        /* USCI A1 Transmit Buffer */
extern volatile unsigned char UCA1ABCTL;                          /* USCI A1 LIN Control */
extern volatile unsigned int UCA1IRCTL;                         /* USCI A1 IrDA Transmit Control */
extern volatile unsigned char UCA1IRCTL_L;                        /* USCI A1 IrDA Transmit Control */
extern volatile unsigned char UCA1IRCTL_H;                        /* USCI A1 IrDA Transmit Control */
extern volatile unsigned int UCA1IE;                            /* USCI A1 Interrupt Enable Register */
extern volatile unsigned char UCA1IE_L;                           /* USCI A1 Interrupt Enable Register */
extern volatile unsigned char UCA1IE_H;                           /* USCI A1 Interrupt Enable Register */
extern volatile unsigned int UCA1IFG;                           /* USCI A1 Interrupt Flags Register */
extern volatile unsigned char UCA1IFG_L;                          /* USCI A1 Interrupt Flags Register */
extern volatile unsigned char UCA1IFG_H;                          /* USCI A1 Interrupt Flags Register */
extern volatile unsigned int UCA1IV;                            /* USCI A1 Interrupt Vector Register */


/************************************************************
* USCI B0
************************************************************/


extern volatile unsigned int UCB0CTLW0;                         /* USCI B0 Control Word Register 0 */
extern volatile unsigned char UCB0CTLW0_L;                        /* USCI B0 Control Word Register 0 */
extern volatile unsigned char UCB0CTLW0_H;                        /* USCI B0 Control Word Register 0 */
extern volatile unsigned int UCB0CTLW1;                         /* USCI B0 Control Word Register 1 */
extern volatile unsigned char UCB0CTLW1_L;                        /* USCI B0 Control Word Register 1 */
extern volatile unsigned char UCB0CTLW1_H;                        /* USCI B0 Control Word Register 1 */
extern volatile unsigned int UCB0BRW;                           /* USCI B0 Baud Word Rate 0 */
extern volatile unsigned char UCB0BRW_L;                          /* USCI B0 Baud Word Rate 0 */
extern volatile unsigned char UCB0BRW_H;                          /* USCI B0 Baud Word Rate 0 */
extern volatile unsigned int UCB0STATW;                         /* USCI B0 Status Word Register */
extern volatile unsigned char UCB0STATW_L;                        /* USCI B0 Status Word Register */
extern volatile unsigned char UCB0STATW_H;                        /* USCI B0 Status Word Register */
extern volatile unsigned int UCB0TBCNT;                         /* USCI B0 Byte Counter Threshold Register */
extern volatile unsigned char UCB0TBCNT_L;                        /* USCI B0 Byte Counter Threshold Register */
extern volatile unsigned char UCB0TBCNT_H;                        /* USCI B0 Byte Counter Threshold Register */
extern volatile unsigned int UCB0RXBUF;                         /* USCI B0 Receive Buffer */
extern volatile unsigned char UCB0RXBUF_L;                        /* USCI B0 Receive Buffer */
extern volatile unsigned char UCB0RXBUF_H;                        /* USCI B0 Receive Buffer */
extern volatile unsigned int UCB0TXBUF;                         /* USCI B0 Transmit Buffer */
extern volatile unsigned char UCB0TXBUF_L;                        /* USCI B0 Transmit Buffer */
extern volatile unsigned char UCB0TXBUF_H;                        /* USCI B0 Transmit Buffer */
extern volatile unsigned int UCB0I2COA0;                        /* USCI B0 I2C Own Address 0 */
extern volatile unsigned char UCB0I2COA0_L;                       /* USCI B0 I2C Own Address 0 */
extern volatile unsigned char UCB0I2COA0_H;                       /* USCI B0 I2C Own Address 0 */
extern volatile unsigned int UCB0I2COA1;                        /* USCI B0 I2C Own Address 1 */
extern volatile unsigned char UCB0I2COA1_L;                       /* USCI B0 I2C Own Address 1 */
extern volatile unsigned char UCB0I2COA1_H;                       /* USCI B0 I2C Own Address 1 */
extern volatile unsigned int UCB0I2COA2;                        /* USCI B0 I2C Own Address 2 */
extern volatile unsigned char UCB0I2COA2_L;                       /* USCI B0 I2C Own Address 2 */
extern volatile unsigned char UCB0I2COA2_H;                       /* USCI B0 I2C Own Address 2 */
extern volatile unsigned int UCB0I2COA3;                        /* USCI B0 I2C Own Address 3 */
extern volatile unsigned char UCB0I2COA3_L;                       /* USCI B0 I2C Own Address 3 */
extern volatile unsigned char UCB0I2COA3_H;                       /* USCI B0 I2C Own Address 3 */
extern volatile unsigned int UCB0ADDRX;                         /* USCI B0 Received Address Register */
extern volatile unsigned char UCB0ADDRX_L;                        /* USCI B0 Received Address Register */
extern volatile unsigned char UCB0ADDRX_H;                        /* USCI B0 Received Address Register */
extern volatile unsigned int UCB0ADDMASK;                       /* USCI B0 Address Mask Register */
extern volatile unsigned char UCB0ADDMASK_L;                      /* USCI B0 Address Mask Register */
extern volatile unsigned char UCB0ADDMASK_H;                      /* USCI B0 Address Mask Register */
extern volatile unsigned int UCB0I2CSA;                         /* USCI B0 I2C Slave Address */
extern volatile unsigned char UCB0I2CSA_L;                        /* USCI B0 I2C Slave Address */
extern volatile unsigned char UCB0I2CSA_H;                        /* USCI B0 I2C Slave Address */
extern volatile unsigned int UCB0IE;                            /* USCI B0 Interrupt Enable Register */
extern volatile unsigned char UCB0IE_L;                           /* USCI B0 Interrupt Enable Register */
extern volatile unsigned char UCB0IE_H;                           /* USCI B0 Interrupt Enable Register */
extern volatile unsigned int UCB0IFG;                           /* USCI B0 Interrupt Flags Register */
extern volatile unsigned char UCB0IFG_L;                          /* USCI B0 Interrupt Flags Register */
extern volatile unsigned char UCB0IFG_H;                          /* USCI B0 Interrupt Flags Register */
extern volatile unsigned int UCB0IV;                            /* USCI B0 Interrupt Vector Register */

// UCAxCTLW0 UART-Mode Control Bits

// UCAxCTLW0 UART-Mode Control Bits

// UCAxCTLW0 UART-Mode Control Bits

// UCxxCTLW0 SPI-Mode Control Bits
//#define res               (0x0020)    /* reserved */
//#define res               (0x0010)    /* reserved */
//#define res               (0x0008)    /* reserved */
//#define res               (0x0004)    /* reserved */

// UCBxCTLW0 I2C-Mode Control Bits
//#define res               (0x1000)    /* reserved */
//#define res               (0x0100)    /* reserved */

// UCBxCTLW0 I2C-Mode Control Bits
//#define res               (0x1000)    /* reserved */
//#define res               (0x0100)    /* reserved */

// UCBxCTLW0 I2C-Mode Control Bits
//#define res               (0x1000)    /* reserved */
//#define res               (0x0100)    /* reserved */



// UCAxCTLW1 UART-Mode Control Bits

// UCAxCTLW1 UART-Mode Control Bits

// UCBxCTLW1 I2C-Mode Control Bits

// UCBxCTLW1 I2C-Mode Control Bits

// UCBxCTLW1 I2C-Mode Control Bits




/* UCAxMCTLW Control Bits */

/* UCAxMCTLW Control Bits */

/* UCAxMCTLW Control Bits */


/* UCAxSTATW Control Bits */

/* UCBxSTATW I2C Control Bits */

/* UCBxTBCNT I2C Control Bits */

/* UCAxIRCTL Control Bits */

/* UCAxIRCTL Control Bits */

/* UCAxIRCTL Control Bits */

/* UCAxABCTL Control Bits */
//#define res               (0x80)    /* reserved */
//#define res               (0x40)    /* reserved */
//#define res               (0x02)    /* reserved */

/* UCBxI2COA0 Control Bits */

/* UCBxI2COA0 Control Bits */

/* UCBxI2COA0 Control Bits */

/* UCBxI2COAx Control Bits */

/* UCBxI2COAx Control Bits */

/* UCBxI2COAx Control Bits */

/* UCBxADDRX Control Bits */

/* UCBxADDRX Control Bits */

/* UCBxADDRX Control Bits */

/* UCBxADDMASK Control Bits */

/* UCBxADDMASK Control Bits */

/* UCBxADDMASK Control Bits */

/* UCBxI2CSA Control Bits */

/* UCBxI2CSA Control Bits */

/* UCBxI2CSA Control Bits */

/* UCAxIE UART Control Bits */

/* UCAxIE/UCBxIE SPI Control Bits */

/* UCBxIE I2C Control Bits */

/* UCAxIFG UART Control Bits */

/* UCAxIFG/UCBxIFG SPI Control Bits */

/* UCBxIFG Control Bits */

/* USCI Interrupt Vector UART Definitions */

/* USCI Interrupt Vector SPI Definitions */

/* USCI Interrupt Vector I2C Definitions */

/************************************************************
* WATCHDOG TIMER A
************************************************************/

extern volatile unsigned int WDTCTL;                            /* Watchdog Timer Control */
extern volatile unsigned char WDTCTL_L;                           /* Watchdog Timer Control */
extern volatile unsigned char WDTCTL_H;                           /* Watchdog Timer Control */
/* The bit names have been prefixed with "WDT" */
/* WDTCTL Control Bits */

/* WDTCTL Control Bits */




/* WDT-interval times [1ms] coded with Bits 0-2 */
/* WDT is clocked by fSMCLK (assumed 1MHz) */
/* WDT is clocked by fACLK (assumed 32KHz) */
/* Watchdog mode -> reset after expired time */
/* WDT is clocked by fSMCLK (assumed 1MHz) */
/* WDT is clocked by fACLK (assumed 32KHz) */


/************************************************************
* TLV Descriptors
************************************************************/



/************************************************************
* Interrupt Vectors (offset from 0xFF80 + 0x10 for Password)
************************************************************/

#pragma diag_suppress 1107



/************************************************************
* End of Modules
************************************************************/






/*****************************************************************************/
/* STDINT.H v17.9.0                                                          */
/*                                                                           */
/* Copyright (c) 2002-2017 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/

/* 7.18.1.1 Exact-width integer types */

    typedef   signed char    int8_t;
    typedef unsigned char   uint8_t;
    typedef          int    int16_t;
    typedef unsigned int   uint16_t;
    typedef          long   int32_t;
    typedef unsigned long  uint32_t;


    typedef          long long  int64_t;
    typedef unsigned long long uint64_t;

/* 7.18.1.2 Minimum-width integer types */

    typedef  int8_t   int_least8_t;
    typedef uint8_t  uint_least8_t;

    typedef  int16_t  int_least16_t;
    typedef uint16_t uint_least16_t;
    typedef  int32_t  int_least32_t;
    typedef uint32_t uint_least32_t;


    typedef  int64_t  int_least64_t;
    typedef uint64_t uint_least64_t;

/* 7.18.1.3 Fastest minimum-width integer types */

    typedef  int16_t  int_fast8_t;
    typedef uint16_t uint_fast8_t;
    typedef  int16_t  int_fast16_t;
    typedef uint16_t uint_fast16_t;

    typedef  int32_t  int_fast32_t;
    typedef uint32_t uint_fast32_t;


    typedef  int64_t  int_fast64_t;
    typedef uint64_t uint_fast64_t;

/* 7.18.1.4 Integer types capable of holding object pointers */
    typedef          long intptr_t;
    typedef unsigned long uintptr_t;

/* 7.18.1.5 Greatest-width integer types */
    typedef          long long intmax_t;
    typedef unsigned long long uintmax_t;

/* 
   According to footnotes in the 1999 C standard, "C++ implementations
   should define these macros only when __STDC_LIMIT_MACROS is defined
   before <stdint.h> is included." 
*/

/* 7.18.2 Limits of specified width integer types */
















/* 7.18.3 Limits of other integer types */







/* 7.18.4.1 Macros for minimum-width integer constants */

/*
   There is a defect report filed against the C99 standard concerning how 
   the (U)INTN_C macros should be implemented.  Please refer to --
   http://wwwold.dkuug.dk/JTC1/SC22/WG14/www/docs/dr_209.htm 
   for more information.  These macros are implemented according to the
   suggestion given at this web site.
*/




/* 7.18.4.2 Macros for greatest-width integer constants */





int16_t Temp_Integral(int16_t total, uint16_t value, uint16_t setpoint, uint16_t max);

/**
 * main.c
 */
int main(void)
{
	WDTCTL = (0x5A00) | (0x0080);	// stop watchdog timer
    Temp_Integral(0, 4096, 4100,32);
	return 0;
}

#pragma FUNC_CANNOT_INLINE(Temp_Integral)

int16_t Temp_Integral(int16_t total, uint16_t value, uint16_t setpoint, uint16_t max){
    int32_t volatile tempmin=-0x7FFE;
    int32_t volatile foo;
    int32_t volatile diff=0;
    /*
     * Negative roll-over-check
     */
    if(((int32_t) value-setpoint)<tempmin){
        return total;
    }
    diff=(int32_t) value-(int32_t) setpoint;
    foo=total+diff;
    if(foo<tempmin){
        return total;
    }

    /*
     * Wind-up limit
     */
    if((total+diff)>max){
        return max;
    }
    return total+diff;
}
