/*
 * Author: Davis Landry
 * Started Work: 9/18/18
 * Driver class to implement the TI XWR1642 board capabilities in c++ using the
 * built in API
 */
#include <iostream>
#define SOC_XWR16XX
#include <ti/control/mmwave/mmwave.h>
#include <ti/drivers/uart/UART.h>


//using namespace std;

void mmwaveInit()
{
    MMWave_InitCfg ptrCtrlInitCfg;
    int32_t errCode;
    SOC_Cfg socCfg;

    socCfg.clockCfg = SOC_SysClock_INIT;
    ptrCtrlInitCfg.domain = MMWave_Domain_MSS;
    ptrCtrlInitCfg.socHandle = SOC_init(&socCfg, &errCode);
//    ptrCtrlInitCfg.eventFxn = ;
    ptrCtrlInitCfg.linkCRCCfg.useCRCDriver = 1U;
    ptrCtrlInitCfg.linkCRCCfg.crcChannel = CRC_Channel_CH1;
    ptrCtrlInitCfg.cfgMode = MMWave_ConfigurationMode_FULL;

    MMWave_init(&ptrCtrlInitCfg, &errCode);
}

void mmwaveUART()
{
    UART_Handle handle;
    UART_Params params;

    UART_Params_init(&params);
    params.baudRate = 92600;
    params.writeDataMode = UART_DATA_BINARY;
    params.readDataMode = UART_DATA_BINARY;
    params.readReturnMode = UART_RETURN_FULL;
    params.readEcho = UART_ECHO_OFF;
    UART_init();
    handle = UART_open(1, &params);
    if (!handle)
    {
       // cout << "Error: Unable to open the UART" << endl;
    }
}

int main()
{
    mmwaveInit();
}
