/*
 * File: my_efk.c
 *
 * Code generated for Simulink model 'kalmanFiter'.
 *
 * Model version                  : 1.914
 * Simulink Coder version         : 8.9 (R2015b) 13-Aug-2015
 * C/C++ source code generated on : Fri Mar 17 19:25:18 2017
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives:
 *    1. Execution efficiency
 *    2. RAM efficiency
 * Validation result: Not run
 */

/*
 * File: my_efk.h
 *
 * Code generated for Simulink model 'kalmanFiter'.
 *
 * Model version                  : 1.914
 * Simulink Coder version         : 8.9 (R2015b) 13-Aug-2015
 * C/C++ source code generated on : Fri Mar 17 19:25:18 2017
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives:
 *    1. Execution efficiency
 *    2. RAM efficiency
 * Validation result: Not run
 */

/*****************************************************************************/
/* math.h     v6.4.12                                                        */
/*                                                                           */
/* Copyright (c) 1996-2017 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/



/*****************************************************************************/
/* linkage.h   v6.4.12                                                        */
/*                                                                           */
/* Copyright (c) 1998-2017 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push
#pragma CHECK_MISRA("-19.4") /* macros required for implementation */

/* No modifiers needed to access code */


/*--------------------------------------------------------------------------*/
/* Define _DATA_ACCESS ==> how to access RTS global or static data          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Define _OPTIMIZE_FOR_SPACE ==> Always optimize for space.                */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Define _IDECL ==> how inline functions are declared                      */
/*--------------------------------------------------------------------------*/

#pragma diag_pop


#pragma diag_push
#pragma CHECK_MISRA("-6.3") /* standard types required for standard headers */
#pragma CHECK_MISRA("-8.5") /* need to define inline function */
#pragma CHECK_MISRA("-8.11") /* need to use __inline as is */
#pragma CHECK_MISRA("-19.7") /* macros required for implementation */
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */
#pragma CHECK_MISRA("-20.2") /* standard headers must define standard names */



/* simplistic isinf and isnan */

/***************************************************************/
/* TMU SUPPORT AND RELAXED MODE: USE INSTRINSICS.              */
/***************************************************************/


/***************************************************************/
/* FUNCTION DEFINITIONS.                                       */
/***************************************************************/
         double modf(double x, double *y); 
         double far_modf(double x, double *y); 
         double asin(double x);
         double acos(double x);
         double atan(double x);
         double atan2(double y, double x);

__inline double ceil(double x);
__inline double ceil(double x)
         {
             double ceil_result;
             double ceil_y;
#pragma diag_push
#pragma diag_suppress 551 /* must be uninitialized to work around bug */
#pragma CHECK_MISRA("-9.1") /* must be uninitialized to work around bug */
#pragma CHECK_MISRA("-10.2") /* false positive on pointer-to-double param */
             if(modf(x, &ceil_y) > 0.)
#pragma diag_pop
             {
                 ceil_result = ceil_y + 1.;
             }
             else
             {
                 ceil_result = ceil_y;
             }
             return ceil_result;
         }

         double cos(double x);
         double cosh(double x);
         double exp(double x);
#pragma diag_push
#pragma CHECK_MISRA("-16.4") /* false positives due to builtin declarations */
         double fabs(double x);
#pragma diag_pop

__inline double floor(double x);
__inline double floor(double x)
         {
             double floor_result;
             double floor_y;
#pragma diag_push
#pragma diag_suppress 551 /* must be uninitialized to work around bug */
#pragma CHECK_MISRA("-9.1") /* must be uninitialized to work around bug */
#pragma CHECK_MISRA("-10.2") /* false positive on pointer-to-double param */
             if(modf(x, &floor_y) < 0.)
#pragma diag_pop
             {
                 floor_result = floor_y - 1.;
             }
             else
             {
                 floor_result = floor_y;
             }
             return floor_result;
         }

         double fmod(double x, double y);
         double frexp(double x, int *_exp);
         double far_frexp(double x, int *_exp);
         double ldexp(double x, int _exp);
         double log(double x);
         double log10(double x);
         double pow(double x, double y);
         double sin(double x);
         double sinh(double x);
         double tan(double x);
         double tanh(double x);
         double sqrt(double x);


#pragma diag_pop

/******************************************************************************/
/*  Overloaded version of math functions for float and long double removed    */
/*  from here, and include in cmath instead (see Section 26.5 of C++ standard */
/*  for details). Thus cpp_inline_math.h is now included in cmath .           */
/******************************************************************************/

#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop
/*****************************************************************************/
/* string.h   v6.4.12                                                        */
/*                                                                           */
/* Copyright (c) 1993-2017 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/



#pragma diag_push
#pragma CHECK_MISRA("-6.3") /* standard types required for standard headers */
#pragma CHECK_MISRA("-19.1") /* #includes required for implementation */

 

typedef unsigned long size_t;


#pragma diag_push
#pragma CHECK_MISRA("-19.4") /* macros required for implementation */


#pragma diag_pop

 size_t  strlen(const char *string);

 char *strcpy(char *dest, const char *src);
 char *strncpy(char *dest, const char *src, size_t n);
 char *strcat(char *string1, const char *string2);
 char *strncat(char *dest, const char *src, size_t n);
 char *strchr(const char *string, int c);
 char *strrchr(const char *string, int c);

 int  strcmp(const char *string1, const char *string2);
 int  strncmp(const char *string1, const char *string2, size_t n);

 int     strcoll(const char *string1, const char *_string2);
 size_t  strxfrm(char *to, const char *from, size_t n);
 char   *strpbrk(const char *string, const char *chs);
 size_t  strspn(const char *string, const char *chs);
 size_t  strcspn(const char *string, const char *chs);
 char   *strstr(const char *string1, const char *string2);
 char   *strtok(char *str1, const char *str2);
 char   *strerror(int _errno);
 char   *strdup(const char *string);


 void   *memmove(void *s1, const void *s2, size_t n);
#pragma diag_push
#pragma CHECK_MISRA("-16.4") /* false positives due to builtin declarations */
 void   *memcpy(void *s1, const void *s2, size_t n);
#pragma diag_pop

 int     memcmp(const void *cs, const void *ct, size_t n);
 void   *memchr(const void *cs, int c, size_t n);

   void   *memset(void *mem, int ch, size_t length);



#pragma diag_push

/* keep macros as direct #defines and not function-like macros or function
   names surrounded by parentheses to support all original supported use cases
   including taking their address through the macros and prefixing with
   namespace macros */
#pragma CHECK_MISRA("-19.4")

#pragma diag_pop

size_t    far_strlen(const char *s);
char     *strcpy_nf(char *s1, const char *s2);
char *strcpy_fn(char *s1, const char *s2);
char *strcpy_ff(char *s1, const char *s2);
char *far_strncpy(char *s1, const char *s2, size_t n);
char *far_strcat(char *s1, const char *s2);
char *far_strncat(char *s1, const char *s2, size_t n);
char *far_strchr(const char *s, int c);
char *far_strrchr(const char *s, int c);
int       far_strcmp(const char *s1, const char *s2);
int       far_strncmp(const char *s1, const char *s2, size_t n);
int       far_strcoll(const char *s1, const char *s2);
size_t    far_strxfrm(char *s1, const char *s2, size_t n);
char *far_strpbrk(const char *s1, const char *s2);
size_t    far_strspn(const char *s1, const char *s2);
size_t    far_strcspn(const char *s1, const char *s2);
char *far_strstr(const char *s1, const char *s2);
char *far_strtok(char *s1, const char *s2);
char *far_strerror(int _errno);
void *far_memmove(void *s1, const void *s2, size_t n);
void     *__memcpy_nf (void *_s1, const void *_s2, size_t _n);
void *__memcpy_fn (void *_s1, const void *_s2, size_t _n);
void *__memcpy_ff (void *_s1, const void *_s2, size_t _n);
int       far_memcmp(const void *s1, const void *s2, size_t n);
void *far_memchr(const void *s, int c, size_t n);
void *far_memset(void *s, int c, size_t n);
void *far_memlcpy(void *to, const void *from,
                        unsigned long n);
void *far_memlmove(void *to, const void *from,
                         unsigned long n);




#pragma diag_pop


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop
/*
 * File: rtwtypes.h
 *
 * Code generated for Simulink model 'kalmanFiter'.
 *
 * Model version                  : 1.914
 * Simulink Coder version         : 8.9 (R2015b) 13-Aug-2015
 * C/C++ source code generated on : Fri Mar 17 19:25:18 2017
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives:
 *    1. Execution efficiency
 *    2. RAM efficiency
 * Validation result: Not run
 */


/* Logical type definitions */


/*=======================================================================*
 * Target hardware information
 *   Device type: Texas Instruments->C2000
 *   Number of bits:     char:  16    short:   16    int:  16
 *                       long:  32    long long:  64
 *                       native word size:  16
 *   Byte ordering: LittleEndian
 *   Signed integer division rounds to: Zero
 *   Shift right on a signed integer as arithmetic shift: on
 *=======================================================================*/

/*=======================================================================*
 * Fixed width word size data types:                                     *
 *   int8_T, int16_T, int32_T     - signed 8, 16, or 32 bit integers     *
 *   uint8_T, uint16_T, uint32_T  - unsigned 8, 16, or 32 bit integers   *
 *   real32_T, real64_T           - 32 and 64 bit floating point numbers *
 *                                                                       *
 *                                                                       *
 *   Note:  Because the specified hardware does not have native support  *
 *          for all data sizes, some data types are actually typedef'ed  *
 *          from larger native data sizes.  The following data types are *
 *          not in the ideal native data types:                          *
 *                                                                       *
 *          int8_T, uint8_T                                              *
 *=======================================================================*/
typedef int int8_T;
typedef unsigned int uint8_T;
typedef int int16_T;
typedef unsigned int uint16_T;
typedef long int32_T;
typedef unsigned long uint32_T;
typedef long long int64_T;
typedef unsigned long long uint64_T;
typedef float real32_T;
typedef double real64_T;

/*===========================================================================*
 * Generic type definitions: real_T, time_T, boolean_T, int_T, uint_T,       *
 *                           ulong_T, char_T , ulonglong_T and byte_T.       *
 *===========================================================================*/
typedef double real_T;
typedef double time_T;
typedef unsigned int boolean_T;
typedef int int_T;
typedef unsigned int uint_T;
typedef unsigned long ulong_T;
typedef unsigned long long ulonglong_T;
typedef char char_T;
typedef unsigned char uchar_T;
typedef char_T byte_T;

/*===========================================================================*
 * Complex number type definitions                                           *
 *===========================================================================*/

typedef struct {
  real32_T re;
  real32_T im;
} creal32_T;

typedef struct {
  real64_T re;
  real64_T im;
} creal64_T;

typedef struct {
  real_T re;
  real_T im;
} creal_T;


typedef struct {
  int8_T re;
  int8_T im;
} cint8_T;


typedef struct {
  uint8_T re;
  uint8_T im;
} cuint8_T;


typedef struct {
  int16_T re;
  int16_T im;
} cint16_T;


typedef struct {
  uint16_T re;
  uint16_T im;
} cuint16_T;


typedef struct {
  int32_T re;
  int32_T im;
} cint32_T;


typedef struct {
  uint32_T re;
  uint32_T im;
} cuint32_T;


typedef struct {
  int64_T re;
  int64_T im;
} cint64_T;


typedef struct {
  uint64_T re;
  uint64_T im;
} cuint64_T;

/*=======================================================================*
 * Min and Max:                                                          *
 *   int8_T, int16_T, int32_T     - signed 8, 16, or 32 bit integers     *
 *   uint8_T, uint16_T, uint32_T  - unsigned 8, 16, or 32 bit integers   *
 *=======================================================================*/

/* Block D-Work pointer type */
typedef void * pointer_T;


/*
 * File trailer for generated code.
 *
 * [EOF]
 */

/*
 * File: kalmanFiter_types.h
 *
 * Code generated for Simulink model 'kalmanFiter'.
 *
 * Model version                  : 1.914
 * Simulink Coder version         : 8.9 (R2015b) 13-Aug-2015
 * C/C++ source code generated on : Fri Mar 17 19:25:18 2017
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives:
 *    1. Execution efficiency
 *    2. RAM efficiency
 * Validation result: Not run
 */


/* Forward declaration for rtModel */
typedef struct tag_RTM RT_MODEL;


/*
 * File trailer for generated code.
 *
 * [EOF]
 */

/* Block signals and states (auto storage) for system '<Root>/kalmanFiter' */
typedef struct {
  real_T index;                        /* '<S1>/Store States' */
  real32_T earthRateNED[3];            /* '<S2>/Embedded MATLAB Function' */
  real32_T covariance[256];            /* '<S2>/Embedded MATLAB Function' */
  real32_T FixPtUnitDelay1_DSTATE[16]; /* '<S10>/FixPt Unit Delay1' */
  real32_T FixPtUnitDelay1_DSTATE_d[256];/* '<S11>/FixPt Unit Delay1' */
  real32_T statesStore[800];           /* '<S1>/Store States' */
  real32_T statesForFusion[16];        /* '<S1>/Recall States3' */
  real32_T statesForFusion_m[16];      /* '<S1>/Recall States2' */
  real32_T statesForFusion_i[16];      /* '<S1>/Recall States1' */
  real32_T Tbn[9];                     /* '<S1>/Predict States' */
  real32_T storedDelAng[3];            /* '<S1>/Predict Covariance' */
  real32_T storedDelVel[3];            /* '<S1>/Predict Covariance' */
  real32_T dt;                         /* '<S1>/Predict Covariance' */
  uint32_T msecStore[50];              /* '<S1>/Store States' */
  uint32_T velFailCount;               /* '<S1>/Fuse Vel Pos Measurements' */
  uint32_T posFailCount;               /* '<S1>/Fuse Vel Pos Measurements' */
  uint32_T hgtFailCount;               /* '<S1>/Fuse Vel Pos Measurements' */
  uint16_T FixPtUnitDelay2_DSTATE;     /* '<S10>/FixPt Unit Delay2' */
  uint16_T FixPtUnitDelay2_DSTATE_n;   /* '<S11>/FixPt Unit Delay2' */
  boolean_T Tbn_not_empty;             /* '<S1>/Predict States' */
} DW_my_EKF;

extern void my_EKF_Init(DW_my_EKF *localDW);
extern void my_EKF(boolean_T rtu_reset, const real32_T rtu_statesInit[16],
                   real_T rtu_time, boolean_T rtu_gpsDataArrived, const real32_T
                   rtu_dAngIMU[3], const real32_T rtu_VelNED[3], const real32_T
                   rtu_dVelIMU[3], const real32_T rtu_PosNE[2], real32_T
                   rtu_dtIMU, real32_T rtu_HgtMea, boolean_T rtu_hgtDataArrived,
                   real32_T rtu_latDeg, real32_T rty_nextStates[16], real32_T
                   rty_nextP[256], real32_T rty_innovation[6], real32_T
                   rty_varInnov[6], DW_my_EKF *localDW);


/*
 * File trailer for generated code.
 *
 * [EOF]
 */

/* Include model header file for global data */
/*
 * File: kalmanFiter.h
 *
 * Code generated for Simulink model 'kalmanFiter'.
 *
 * Model version                  : 1.914
 * Simulink Coder version         : 8.9 (R2015b) 13-Aug-2015
 * C/C++ source code generated on : Fri Mar 17 19:25:18 2017
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives:
 *    1. Execution efficiency
 *    2. RAM efficiency
 * Validation result: Not run
 */



/* Child system includes */

/* Macros for accessing real-time model data structure */


/* Block signals and states (auto storage) for system '<Root>' */
typedef struct {
  DW_my_EKF kalmanFiter_d;             /* '<Root>/kalmanFiter' */
} DW;

/* External inputs (root inport signals with auto storage) */
typedef struct {
  boolean_T reset;                     /* '<Root>/reset' */
  real32_T statesInit[16];             /* '<Root>/statesInit' */
  real_T time;                         /* '<Root>/time' */
  boolean_T gpsDataArrived;            /* '<Root>/gpsDataArrived' */
  real32_T delAngIMU[3];               /* '<Root>/dAngIMU' */
  real32_T VelNED[3];                  /* '<Root>/VelNED' */
  real32_T delVelIMU[3];               /* '<Root>/dVelIMU' */
  real32_T PosNE[2];                   /* '<Root>/PosNE' */
  real32_T dtIMU;                      /* '<Root>/dtIMU' */
  real32_T HgtMea;                     /* '<Root>/HgtMea' */
  boolean_T hgtDataArrived;            /* '<Root>/hgtDataArrived' */
  real32_T latDeg;                     /* '<Root>/latDeg' */
} ExtU;

/* External outputs (root outports fed by signals with auto storage) */
typedef struct {
  real32_T nextStates[16];             /* '<Root>/nextStates' */
  real32_T nextP[256];                 /* '<Root>/nextP' */
  real32_T innovation[6];              /* '<Root>/innovation' */
  real32_T varInnov[6];                /* '<Root>/varInnov' */
} ExtY;

/* Real-time Model Data Structure */
struct tag_RTM {
  const char_T * volatile errorStatus;
};

/* Block signals and states (auto storage) */
extern DW rtDW;

/* External inputs (root inport signals with auto storage) */
extern ExtU rtU;

/* External outputs (root outports fed by signals with auto storage) */
extern ExtY rtY;

/* Model entry point functions */
extern void kalmanFiter_initialize(void);
extern void kalmanFiter_step(void);

/* Real-time Model object */
extern RT_MODEL *const rtM;

/*-
 * These blocks were eliminated from the model due to optimizations:
 *
 * Block '<S10>/FixPt Data Type Duplicate1' : Unused code path elimination
 * Block '<S11>/FixPt Data Type Duplicate1' : Unused code path elimination
 */

/*-
 * The generated code includes comments that allow you to trace directly
 * back to the appropriate location in the model.  The basic format
 * is <system>/block_name, where system is the system number (uniquely
 * assigned by Simulink) and block_name is the name of the block.
 *
 * Note that this particular code originates from a subsystem build,
 * and has its own system numbers different from the parent model.
 * Refer to the system hierarchy for this subsystem below, and use the
 * MATLAB hilite_system command to trace the generated code back
 * to the parent model.  For example,
 *
 * hilite_system('NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter')    - opens subsystem NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter
 * hilite_system('NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Kp') - opens and selects block Kp
 *
 * Here is the system hierarchy for this model
 *
 * '<Root>' : 'NavFilterTestHarness16_changed/InertialNavFilter'
 * '<S1>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter'
 * '<S2>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Calc Initial Parameters'
 * '<S3>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Fuse Vel Pos Measurements'
 * '<S4>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Predict Covariance'
 * '<S5>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Predict States'
 * '<S6>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Recall States1'
 * '<S7>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Recall States2'
 * '<S8>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Recall States3'
 * '<S9>'   : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Store States'
 * '<S10>'  : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Unit Delay Resettable External IC'
 * '<S11>'  : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Unit Delay Resettable External IC1'
 * '<S12>'  : 'NavFilterTestHarness16_changed/InertialNavFilter/kalmanFiter/Calc Initial Parameters/Embedded MATLAB Function'
 */

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
/*
 * File: kalmanFiter_private.h
 *
 * Code generated for Simulink model 'kalmanFiter'.
 *
 * Model version                  : 1.914
 * Simulink Coder version         : 8.9 (R2015b) 13-Aug-2015
 * C/C++ source code generated on : Fri Mar 17 19:25:18 2017
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives:
 *    1. Execution efficiency
 *    2. RAM efficiency
 * Validation result: Not run
 */


extern real_T rt_roundd(real_T u);


/*
 * File trailer for generated code.
 *
 * [EOF]
 */

/* Forward declaration for local functions */
static void power(const real32_T a[16], real32_T y[16]);
real_T rt_roundd(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

/* Function for MATLAB Function: '<S1>/Predict Covariance' */
static void power(const real32_T a[16], real32_T y[16])
{
  int16_T k;
  for (k = 0; k < 16; k++) {
    y[k] = a[k] * a[k];
  }
}

/* Initial conditions for atomic system: '<Root>/kalmanFiter' */
void my_EKF_Init(DW_my_EKF *localDW)
{
  /* InitializeConditions for UnitDelay: '<S10>/FixPt Unit Delay2' */
  localDW->FixPtUnitDelay2_DSTATE = 1U;

  /* InitializeConditions for UnitDelay: '<S11>/FixPt Unit Delay2' */
  localDW->FixPtUnitDelay2_DSTATE_n = 1U;

  /* InitializeConditions for MATLAB Function: '<S1>/Store States' */
  localDW->index = 1.0;
}

/* Output and update for atomic system: '<Root>/kalmanFiter' */
void my_EKF(boolean_T rtu_reset, const real32_T rtu_statesInit[16], real_T
            rtu_time, boolean_T rtu_gpsDataArrived, const real32_T rtu_dAngIMU[3],
            const real32_T rtu_VelNED[3], const real32_T rtu_dVelIMU[3], const
            real32_T rtu_PosNE[2], real32_T rtu_dtIMU, real32_T rtu_HgtMea,
            boolean_T rtu_hgtDataArrived, real32_T rtu_latDeg, real32_T
            rty_nextStates[16], real32_T rty_nextP[256], real32_T
            rty_innovation[6], real32_T rty_varInnov[6], DW_my_EKF *localDW)
{
  real32_T rotationMag;
  real32_T delVelNav[3];
  real32_T lastVelocity[3];
  int16_T I[9];
  static const real32_T c[3] = { 0.0F, 0.0F, 9.80665F };

  real32_T dAngBiasSigma;
  real32_T processNoise[16];
  real32_T g_y;
  real32_T h_y;
  real32_T i_y;
  real32_T e_c;
  real32_T f_c;
  real32_T g_c;
  real32_T h_c;
  int16_T bestTimeDelta;
  int16_T bestStoreIndex;
  int32_T timeDelta;
  int16_T posHealth;
  real32_T R_OBS[6];
  real32_T observation[6];
  int16_T fuseData[6];
  real32_T K[16];
  real32_T KHP[256];
  int16_T colIndex;
  static const real32_T v[16] = { 0.0F, 0.0F, 0.0F, 0.0F, 0.48999998F,
    0.48999998F, 0.48999998F, 225.0F, 225.0F, 25.0F, 1.21846966E-9F,
    1.21846966E-9F, 1.21846966E-9F, 4.00000044E-6F, 4.00000044E-6F,
    4.00000044E-6F };

  static const real32_T quatCov[16] = { 0.0F, 0.0F, 0.0F, 0.0F, 0.0F,
    7.61543561E-5F, 0.0F, 0.0F, 0.0F, 0.0F, 7.61543561E-5F, 0.0F, 0.0F, 0.0F,
    0.0F, 0.0076154354F };

  real32_T rtb_Init[16];
  real32_T rtb_correctedDelAng[3];
  real32_T rtb_correctedDelVel[3];
  real32_T rtb_Init_p[256];
  int16_T i;
  real32_T tmp[16];
  int16_T rowIndex;
  real32_T SPP_idx_3;
  real32_T SPP_idx_2;
  real32_T SPP_idx_1;
  real32_T deltaQuat_idx_0;
  real32_T deltaQuat_idx_2;
  real32_T deltaQuat_idx_1;
  real32_T qUpdated_idx_2;
  real32_T qUpdated_idx_3;
  real32_T SF_idx_0;
  real32_T SF_idx_1;
  real32_T SF_idx_2;
  real32_T SF_idx_3;
  real32_T SF_idx_4;
  real32_T SF_idx_5;
  real32_T SF_idx_6;
  real32_T SF_idx_7;
  real32_T SF_idx_8;
  real32_T SF_idx_9;
  real32_T SF_idx_10;
  real32_T SF_idx_11;
  real32_T SF_idx_16;
  real32_T SG_idx_0;
  real32_T SG_idx_5;
  real32_T SG_idx_6;
  real32_T SG_idx_7;
  real32_T SQ_idx_0;
  real32_T SQ_idx_1;
  real32_T SQ_idx_2;
  real32_T SQ_idx_3;
  real32_T SQ_idx_4;
  real32_T SQ_idx_5;
  real32_T SQ_idx_6;
  real32_T SQ_idx_7;
  real32_T SQ_idx_8;
  real32_T SPP_idx_0;
  real32_T SPP_idx_4;
  real32_T SPP_idx_8;
  real32_T SPP_idx_9;
  real32_T SPP_idx_10;
  real32_T SPP_idx_11;
  uint64_T tmp_0;
  real_T tmp_1;
  int64_T tmp_2;
  uint32_T tmp_3;

  /* Outputs for Enabled SubSystem: '<S1>/Calc Initial Parameters' incorporates:
   *  EnablePort: '<S2>/Enable'
   */
  if (rtu_reset) {
    /* MATLAB Function: '<S2>/Embedded MATLAB Function' */
    /* MATLAB Function 'kalmanFiter/Calc Initial Parameters/Embedded MATLAB Function': '<S12>:1' */
    /*  degrees to to radians conversion */
    /* '<S12>:1:5' */
    /*  Define the initial Euler angle covariance (Phi, Theta, Psi) */
    /*  Define the transformation vector from a 321 sequence Euler rotation vector to a q0,...,q3 quaternion vector */
    /*  linearised around a level orientation (roll,pitch = 0,0) */
    /*  Form the covariance matrix for the intial Euler angle coordinates */
    /*  Transform the Euler angle covariances into the equivalent quaternion covariances */
    /* '<S12>:1:22' */
    /*  define the state covariances with the exception of the quaternion covariances */
    /*  1 sigma uncertainty in horizontal velocity components */
    /*  1 sigma uncertainty in vertical velocity */
    /*  1 sigma uncertainty in horizontal position components */
    /*  1 sigma uncertainty in vertical position */
    /*  1 Sigma uncertainty in delta angle bias */
    /*  1 Sigma uncertainty in delta velocity bias */
    /* '<S12>:1:31' */
    memset(&localDW->covariance[0L], 0, sizeof(real32_T) << 8U);
    for (bestStoreIndex = 0; bestStoreIndex < 16; bestStoreIndex++) {
      localDW->covariance[bestStoreIndex + (bestStoreIndex << 4U)] =
        v[bestStoreIndex];
    }

    /* ⿴һ */
    /*  Add the quaternion covariances */
    /* '<S12>:1:34' */
    for (rowIndex = 0; rowIndex < 4; rowIndex++) {
      localDW->covariance[rowIndex << 4U] = quatCov[rowIndex << 2U];
      localDW->covariance[1 + (rowIndex << 4U)] = quatCov[(rowIndex << 2U) + 1];
      localDW->covariance[2 + (rowIndex << 4U)] = quatCov[(rowIndex << 2U) + 2];
      localDW->covariance[3 + (rowIndex << 4U)] = quatCov[(rowIndex << 2U) + 3];
    }

    /* Define Earth rotation vector in the NED navigation frame */
    /* '<S12>:1:37' */
    /* '<S12>:1:38' */
    localDW->earthRateNED[0] = (real32_T)cos(rtu_latDeg * 0.0174532924F) *
      7.2921E-5F;
    localDW->earthRateNED[1] = 0.0F;
    localDW->earthRateNED[2] = -(real32_T)sin(rtu_latDeg * 0.0174532924F) *
      7.2921E-5F;

    /* End of MATLAB Function: '<S2>/Embedded MATLAB Function' */
  }

  /* End of Outputs for SubSystem: '<S1>/Calc Initial Parameters' */

  /* Logic: '<S10>/FixPt Logical Operator' incorporates:
   *  UnitDelay: '<S10>/FixPt Unit Delay2'
   */
  bestStoreIndex = (rtu_reset || (localDW->FixPtUnitDelay2_DSTATE != 0U));

  /* Switch: '<S10>/Init' incorporates:
   *  UnitDelay: '<S10>/FixPt Unit Delay1'
   */
  for (i = 0; i < 16; i++) {
    if ((uint16_T)bestStoreIndex != 0U) {
      rtb_Init[i] = rtu_statesInit[i];
    } else {
      rtb_Init[i] = localDW->FixPtUnitDelay1_DSTATE[i];
    }
  }

  /* End of Switch: '<S10>/Init' */

  /* MATLAB Function: '<S1>/Predict States' */
  /* MATLAB Function 'kalmanFiter/Predict States': '<S5>:1' */
  /*  define persistent variables for previous delta angle and velocity which */
  /*  are required for sculling and coning error corrections */
  if (!localDW->Tbn_not_empty) {
    /* '<S5>:1:16' */
    /* '<S5>:1:17' */
    for (rowIndex = 0; rowIndex < 9; rowIndex++) {
      I[rowIndex] = 0;
    }

    I[0] = 1;
    I[4] = 1;
    I[8] = 1;
    for (rowIndex = 0; rowIndex < 9; rowIndex++) {
      localDW->Tbn[rowIndex] = I[rowIndex];
    }

    localDW->Tbn_not_empty = (1U);
  }

  /*  Remove sensor bias errors */
  /* '<S5>:1:23' */
  /* '<S5>:1:24' */
  /*  Save current measurements */
  /* '<S5>:1:27' */
  /*  Apply corrections for earths rotation rate and coning errors */
  /* '<S5>:1:30' */
  for (i = 0; i < 3; i++) {
    rtb_correctedDelAng[i] = rtu_dAngIMU[i] - rtb_Init[i + 10];
    rtb_correctedDelVel[i] = rtu_dVelIMU[i] - rtb_Init[i + 13];
    delVelNav[i] = localDW->Tbn[3 * i + 2] * localDW->earthRateNED[2] +
      (localDW->Tbn[3 * i + 1] * localDW->earthRateNED[1] + localDW->Tbn[3 * i] *
       localDW->earthRateNED[0]);
  }

  SF_idx_10 = rtb_correctedDelAng[0];
  rotationMag = rtb_correctedDelAng[0];
  dAngBiasSigma = rtb_correctedDelAng[1];
  rtb_correctedDelAng[0] = (rtb_correctedDelAng[1] * rtu_dAngIMU[2] -
    rtb_correctedDelAng[2] * rtu_dAngIMU[1]) * 0.0833333358F +
    (rtb_correctedDelAng[0] - delVelNav[0] * rtu_dtIMU);
  rtb_correctedDelAng[1] = (rtb_correctedDelAng[2] * rtu_dAngIMU[0] - SF_idx_10 *
    rtu_dAngIMU[2]) * 0.0833333358F + (rtb_correctedDelAng[1] - delVelNav[1] *
    rtu_dtIMU);
  SF_idx_10 = (rotationMag * rtu_dAngIMU[1] - dAngBiasSigma * rtu_dAngIMU[0]) *
    0.0833333358F + (rtb_correctedDelAng[2] - delVelNav[2] * rtu_dtIMU);

  /*  Initialise the updated state vector */
  /* '<S5>:1:33' */
  for (i = 0; i < 16; i++) {
    rty_nextStates[i] = rtb_Init[i];
  }

  /*  Convert the rotation vector to its equivalent quaternion */
  /* '<S5>:1:36' */
  rotationMag = (real32_T)sqrt((rtb_correctedDelAng[0] * rtb_correctedDelAng[0]
    + rtb_correctedDelAng[1] * rtb_correctedDelAng[1]) + SF_idx_10 * SF_idx_10);
  if (rotationMag < 1.0E-12) {
    /* '<S5>:1:37' */
    /* '<S5>:1:38' */
    deltaQuat_idx_0 = 1.0F;
    deltaQuat_idx_1 = 0.0F;
    deltaQuat_idx_2 = 0.0F;
    rotationMag = 0.0F;
  } else {
    /* '<S5>:1:40' */
    dAngBiasSigma = (real32_T)sin(0.5F * rotationMag);
    deltaQuat_idx_0 = (real32_T)cos(0.5F * rotationMag);
    deltaQuat_idx_1 = rtb_correctedDelAng[0] / rotationMag * dAngBiasSigma;
    deltaQuat_idx_2 = rtb_correctedDelAng[1] / rotationMag * dAngBiasSigma;
    rotationMag = SF_idx_10 / rotationMag * dAngBiasSigma;
  }

  /*  Update the quaternions by rotating from the previous attitude through */
  /*  the delta angle rotation quaternion */
  /* '<S5>:1:45' */
  dAngBiasSigma = (rtb_Init[0] * deltaQuat_idx_1 + deltaQuat_idx_0 * rtb_Init[1])
    + (rtb_Init[2] * rotationMag - rtb_Init[3] * deltaQuat_idx_2);
  qUpdated_idx_2 = (rtb_Init[0] * deltaQuat_idx_2 + deltaQuat_idx_0 * rtb_Init[2])
    + (rtb_Init[3] * deltaQuat_idx_1 - rtb_Init[1] * rotationMag);
  qUpdated_idx_3 = (rtb_Init[0] * rotationMag + deltaQuat_idx_0 * rtb_Init[3]) +
    (rtb_Init[1] * deltaQuat_idx_2 - rtb_Init[2] * deltaQuat_idx_1);
  deltaQuat_idx_0 = rtb_Init[0] * deltaQuat_idx_0 - ((rtb_Init[1] *
    deltaQuat_idx_1 + rtb_Init[2] * deltaQuat_idx_2) + rtb_Init[3] * rotationMag);

  /*  Normalise the quaternions and update the quaternion states */
  /* '<S5>:1:48' */
  rotationMag = (real32_T)sqrt(((deltaQuat_idx_0 * deltaQuat_idx_0 +
    dAngBiasSigma * dAngBiasSigma) + qUpdated_idx_2 * qUpdated_idx_2) +
    qUpdated_idx_3 * qUpdated_idx_3);
  if (rotationMag < 1.0E-16) {
    /* '<S5>:1:49' */
    /* '<S5>:1:50' */
    rty_nextStates[0] = deltaQuat_idx_0;
    rty_nextStates[1] = dAngBiasSigma;
    rty_nextStates[2] = qUpdated_idx_2;
    rty_nextStates[3] = qUpdated_idx_3;
  } else {
    /* '<S5>:1:52' */
    rty_nextStates[0] = deltaQuat_idx_0 / rotationMag;
    rty_nextStates[1] = dAngBiasSigma / rotationMag;
    rty_nextStates[2] = qUpdated_idx_2 / rotationMag;
    rty_nextStates[3] = qUpdated_idx_3 / rotationMag;
  }

  /*  Calculate the body to nav cosine matrix */
  /* '<S5>:1:56' */
  localDW->Tbn[0] = ((rty_nextStates[0] * rty_nextStates[0] + rty_nextStates[1] *
                      rty_nextStates[1]) - rty_nextStates[2] * rty_nextStates[2])
    - rty_nextStates[3] * rty_nextStates[3];
  localDW->Tbn[3] = (rty_nextStates[1] * rty_nextStates[2] - rty_nextStates[0] *
                     rty_nextStates[3]) * 2.0F;
  localDW->Tbn[6] = (rty_nextStates[1] * rty_nextStates[3] + rty_nextStates[0] *
                     rty_nextStates[2]) * 2.0F;
  localDW->Tbn[1] = (rty_nextStates[1] * rty_nextStates[2] + rty_nextStates[0] *
                     rty_nextStates[3]) * 2.0F;
  localDW->Tbn[4] = ((rty_nextStates[0] * rty_nextStates[0] - rty_nextStates[1] *
                      rty_nextStates[1]) + rty_nextStates[2] * rty_nextStates[2])
    - rty_nextStates[3] * rty_nextStates[3];
  localDW->Tbn[7] = (rty_nextStates[2] * rty_nextStates[3] - rty_nextStates[0] *
                     rty_nextStates[1]) * 2.0F;
  localDW->Tbn[2] = (rty_nextStates[1] * rty_nextStates[3] - rty_nextStates[0] *
                     rty_nextStates[2]) * 2.0F;
  localDW->Tbn[5] = (rty_nextStates[2] * rty_nextStates[3] + rty_nextStates[0] *
                     rty_nextStates[1]) * 2.0F;
  localDW->Tbn[8] = ((rty_nextStates[0] * rty_nextStates[0] - rty_nextStates[1] *
                      rty_nextStates[1]) - rty_nextStates[2] * rty_nextStates[2])
    + rty_nextStates[3] * rty_nextStates[3];

  /*  transform body delta velocities to delta velocities in the nav frame */
  /* '<S5>:1:61' */
  /*  calculate the magnitude of the nav acceleration (required for GPS */
  /*  variance estimation) */
  /* '<S5>:1:65' */
  for (i = 0; i < 3; i++) {
    rotationMag = ((localDW->Tbn[i + 3] * rtb_correctedDelVel[1] + localDW->
                    Tbn[i] * rtb_correctedDelVel[0]) + localDW->Tbn[i + 6] *
                   rtb_correctedDelVel[2]) + c[i] * rtu_dtIMU;
    lastVelocity[i] = rty_nextStates[i + 4];
    rty_nextStates[i + 4] = rtb_Init[i + 4] + rotationMag;
    delVelNav[i] = rotationMag;
  }

  rotationMag = (real32_T)sqrt((delVelNav[0] * delVelNav[0] + delVelNav[1] *
    delVelNav[1]) + delVelNav[2] * delVelNav[2]) / rtu_dtIMU;

  /*  If calculating position save previous velocity */
  /* '<S5>:1:68' */
  /*  Sum delta velocities to get velocity after removing gravitational skew and correcting for transport rate */
  /* '<S5>:1:71' */
  /*  If calculating postions, do a trapezoidal integration for position */
  /* '<S5>:1:75' */
  rty_nextStates[7] = (rty_nextStates[4] + lastVelocity[0]) * 0.5F * rtu_dtIMU +
    rtb_Init[7];
  rty_nextStates[8] = (rty_nextStates[5] + lastVelocity[1]) * 0.5F * rtu_dtIMU +
    rtb_Init[8];
  rty_nextStates[9] = (rty_nextStates[6] + lastVelocity[2]) * 0.5F * rtu_dtIMU +
    rtb_Init[9];

  /*  Copy the remaining states across */
  /* '<S5>:1:78' */
  for (i = 0; i < 6; i++) {
    rty_nextStates[i + 10] = rtb_Init[i + 10];
  }

  /* End of MATLAB Function: '<S1>/Predict States' */

  /* Logic: '<S11>/FixPt Logical Operator' incorporates:
   *  UnitDelay: '<S11>/FixPt Unit Delay2'
   */
  bestStoreIndex = (rtu_reset || (localDW->FixPtUnitDelay2_DSTATE_n != 0U));

  /* Switch: '<S11>/Init' incorporates:
   *  UnitDelay: '<S11>/FixPt Unit Delay1'
   */
  if ((uint16_T)bestStoreIndex != 0U) {
    memcpy(&rtb_Init_p[0], &localDW->covariance[0], sizeof(real32_T) << 8U);
  } else {
    memcpy(&rtb_Init_p[0], &localDW->FixPtUnitDelay1_DSTATE_d[0], sizeof
           (real32_T) << 8U);
  }

  /* End of Switch: '<S11>/Init' */

  /* MATLAB Function: '<S1>/Predict Covariance' */
  /* MATLAB Function 'kalmanFiter/Predict Covariance': '<S4>:1' */
  /*   % Previous state covariance matrix */
  /*  Boolean to indicate when on ground */
  /* '<S4>:1:9' */
  /*  time between covariance prediction updates */
  /* '<S4>:1:28' */
  /* '<S4>:1:29' */
  localDW->storedDelAng[0] += rtb_correctedDelAng[0];
  localDW->storedDelVel[0] += rtb_correctedDelVel[0];
  localDW->storedDelAng[1] += rtb_correctedDelAng[1];
  localDW->storedDelVel[1] += rtb_correctedDelVel[1];
  localDW->storedDelAng[2] += SF_idx_10;
  localDW->storedDelVel[2] += rtb_correctedDelVel[2];

  /* '<S4>:1:30' */
  localDW->dt += rtu_dtIMU;
  if (localDW->dt >= 0.0F) {
    /* '<S4>:1:32' */
    /*  Set the filter process noise - this consists of a very small amount to */
    /*  cover processing errors. IMU errors are already built into the */
    /*  equations */
    /*  It  includes the process noise required for evolution of the IMU bias */
    /*  errors, wind velocity and magnetic field states */
    /* '<S4>:1:39' */
    dAngBiasSigma = localDW->dt * 0.05F / 3600.0F * 3.14159274F / 180.0F;

    /* '<S4>:1:40' */
    deltaQuat_idx_0 = localDW->dt * 0.01F / 60.0F;

    /* '<S4>:1:41' */
    for (rowIndex = 0; rowIndex < 10; rowIndex++) {
      tmp[rowIndex] = 1.0E-9F;
    }

    tmp[10] = dAngBiasSigma;
    tmp[13] = deltaQuat_idx_0;
    tmp[11] = dAngBiasSigma;
    tmp[14] = deltaQuat_idx_0;
    tmp[12] = dAngBiasSigma;
    tmp[15] = deltaQuat_idx_0;
    power(tmp, processNoise);

    /*  Specify the estimated errors on the delta angles and delta velocities */
    /* '<S4>:1:44' */
    dAngBiasSigma = localDW->dt * 25.0F / 60.0F * 3.14159274F / 180.0F;
    deltaQuat_idx_1 = dAngBiasSigma * dAngBiasSigma;

    /* '<S4>:1:45' */
    dAngBiasSigma = localDW->dt * 25.0F / 60.0F * 3.14159274F / 180.0F;
    deltaQuat_idx_2 = dAngBiasSigma * dAngBiasSigma;

    /* '<S4>:1:46' */
    dAngBiasSigma = localDW->dt * 25.0F / 60.0F * 3.14159274F / 180.0F;
    qUpdated_idx_2 = dAngBiasSigma * dAngBiasSigma;

    /* '<S4>:1:47' */
    dAngBiasSigma = localDW->dt * 0.5F;
    dAngBiasSigma *= dAngBiasSigma;

    /* '<S4>:1:48' */
    deltaQuat_idx_0 = localDW->dt * 0.5F;
    deltaQuat_idx_0 *= deltaQuat_idx_0;

    /* '<S4>:1:49' */
    qUpdated_idx_3 = localDW->dt * 0.5F;
    qUpdated_idx_3 *= qUpdated_idx_3;

    /* '<S4>:1:51' */
    /* '<S4>:1:52' */
    /* '<S4>:1:53' */
    /* '<S4>:1:54' */
    /* '<S4>:1:55' */
    /* '<S4>:1:56' */
    /* '<S4>:1:58' */
    /* '<S4>:1:59' */
    /* '<S4>:1:60' */
    /* '<S4>:1:61' */
    /* '<S4>:1:71' */
    /* '<S4>:1:72' */
    /* '<S4>:1:73' */
    /* '<S4>:1:75' */
    /* '<S4>:1:76' */
    /* '<S4>:1:77' */
    /*  Predicted covariance */
    /* '<S4>:1:81' */
    /* '<S4>:1:82' */
    SF_idx_0 = rtb_correctedDelVel[2] - rtb_Init[15];

    /* '<S4>:1:83' */
    SF_idx_1 = rtb_correctedDelVel[1] - rtb_Init[14];

    /* '<S4>:1:84' */
    SF_idx_2 = rtb_correctedDelVel[0] - rtb_Init[13];

    /* '<S4>:1:85' */
    SF_idx_3 = (2.0F * rtb_Init[1] * SF_idx_2 + 2.0F * rtb_Init[2] * SF_idx_1) +
      2.0F * rtb_Init[3] * SF_idx_0;

    /* '<S4>:1:86' */
    SF_idx_4 = (2.0F * rtb_Init[0] * SF_idx_1 - 2.0F * rtb_Init[1] * SF_idx_0) +
      2.0F * rtb_Init[3] * SF_idx_2;

    /* '<S4>:1:87' */
    SF_idx_5 = (2.0F * rtb_Init[0] * SF_idx_2 + 2.0F * rtb_Init[2] * SF_idx_0) -
      2.0F * rtb_Init[3] * SF_idx_1;

    /* '<S4>:1:88' */
    SF_idx_6 = rtb_correctedDelAng[1] / 2.0F - rtb_Init[11] / 2.0F;

    /* '<S4>:1:89' */
    SF_idx_7 = SF_idx_10 / 2.0F - rtb_Init[12] / 2.0F;

    /* '<S4>:1:90' */
    SF_idx_8 = rtb_correctedDelAng[0] / 2.0F - rtb_Init[10] / 2.0F;

    /* '<S4>:1:91' */
    SF_idx_9 = rtb_Init[10] / 2.0F - rtb_correctedDelAng[0] / 2.0F;

    /* '<S4>:1:92' */
    SF_idx_10 = rtb_Init[12] / 2.0F - SF_idx_10 / 2.0F;

    /* '<S4>:1:93' */
    SF_idx_11 = rtb_Init[11] / 2.0F - rtb_correctedDelAng[1] / 2.0F;

    /* '<S4>:1:94' */
    /* '<S4>:1:95' */
    /* '<S4>:1:96' */
    g_y = rtb_Init[1] / 2.0F;

    /* '<S4>:1:97' */
    h_y = rtb_Init[2] / 2.0F;

    /* '<S4>:1:98' */
    SF_idx_16 = rtb_Init[3] / 2.0F;

    /* '<S4>:1:99' */
    SPP_idx_3 = rtb_Init[3] * rtb_Init[3];

    /* '<S4>:1:100' */
    SPP_idx_4 = rtb_Init[2] * rtb_Init[2];

    /* '<S4>:1:101' */
    SPP_idx_8 = rtb_Init[1] * rtb_Init[1];

    /* '<S4>:1:102' */
    SPP_idx_9 = rtb_Init[0] * rtb_Init[0];

    /* '<S4>:1:105' */
    i_y = rtb_Init[0] / 2.0F;
    SG_idx_0 = rtb_Init[0] / 2.0F;

    /* '<S4>:1:106' */
    e_c = rtb_Init[3] * rtb_Init[3];

    /* '<S4>:1:107' */
    f_c = rtb_Init[2] * rtb_Init[2];

    /* '<S4>:1:108' */
    g_c = rtb_Init[1] * rtb_Init[1];

    /* '<S4>:1:109' */
    h_c = rtb_Init[0] * rtb_Init[0];

    /* '<S4>:1:110' */
    SG_idx_5 = 2.0F * rtb_Init[2] * rtb_Init[3];

    /* '<S4>:1:111' */
    SG_idx_6 = 2.0F * rtb_Init[1] * rtb_Init[3];

    /* '<S4>:1:112' */
    SG_idx_7 = 2.0F * rtb_Init[1] * rtb_Init[2];

    /* '<S4>:1:114' */
    /* '<S4>:1:115' */
    SQ_idx_0 = ((SG_idx_5 - 2.0F * rtb_Init[0] * rtb_Init[1]) * qUpdated_idx_3 *
                (((e_c - f_c) - g_c) + h_c) - (2.0F * rtb_Init[0] * rtb_Init[1]
      + SG_idx_5) * deltaQuat_idx_0 * (((e_c - f_c) + g_c) - h_c)) + (SG_idx_6 -
      2.0F * rtb_Init[0] * rtb_Init[2]) * dAngBiasSigma * (2.0F * rtb_Init[0] *
      rtb_Init[3] + SG_idx_7);

    /* '<S4>:1:116' */
    SQ_idx_1 = ((2.0F * rtb_Init[0] * rtb_Init[2] + SG_idx_6) * qUpdated_idx_3 *
                (((e_c - f_c) - g_c) + h_c) - (SG_idx_6 - 2.0F * rtb_Init[0] *
      rtb_Init[2]) * dAngBiasSigma * (((e_c + f_c) - g_c) - h_c)) + (2.0F *
      rtb_Init[0] * rtb_Init[1] + SG_idx_5) * deltaQuat_idx_0 * (SG_idx_7 - 2.0F
      * rtb_Init[0] * rtb_Init[3]);

    /* '<S4>:1:117' */
    SQ_idx_2 = ((SG_idx_5 - 2.0F * rtb_Init[0] * rtb_Init[1]) * qUpdated_idx_3 *
                (2.0F * rtb_Init[0] * rtb_Init[2] + SG_idx_6) - (SG_idx_7 - 2.0F
      * rtb_Init[0] * rtb_Init[3]) * deltaQuat_idx_0 * (((e_c - f_c) + g_c) -
      h_c)) - (2.0F * rtb_Init[0] * rtb_Init[3] + SG_idx_7) * dAngBiasSigma *
      (((e_c + f_c) - g_c) - h_c);

    /* '<S4>:1:118' */
    SQ_idx_3 = (deltaQuat_idx_2 * rtb_Init[1] * i_y / 2.0F - qUpdated_idx_2 *
                rtb_Init[1] * i_y / 2.0F) - deltaQuat_idx_1 * rtb_Init[2] *
      rtb_Init[3] / 4.0F;

    /* '<S4>:1:119' */
    SQ_idx_4 = (qUpdated_idx_2 * rtb_Init[2] * i_y / 2.0F - deltaQuat_idx_1 *
                rtb_Init[2] * i_y / 2.0F) - deltaQuat_idx_2 * rtb_Init[1] *
      rtb_Init[3] / 4.0F;

    /* '<S4>:1:120' */
    SQ_idx_5 = (deltaQuat_idx_1 * rtb_Init[3] * i_y / 2.0F - deltaQuat_idx_2 *
                rtb_Init[3] * i_y / 2.0F) - qUpdated_idx_2 * rtb_Init[1] *
      rtb_Init[2] / 4.0F;

    /* '<S4>:1:121' */
    SQ_idx_6 = (deltaQuat_idx_1 * rtb_Init[1] * rtb_Init[2] / 4.0F -
                qUpdated_idx_2 * rtb_Init[3] * i_y / 2.0F) - deltaQuat_idx_2 *
      rtb_Init[1] * rtb_Init[2] / 4.0F;

    /* '<S4>:1:122' */
    SQ_idx_7 = (qUpdated_idx_2 * rtb_Init[1] * rtb_Init[3] / 4.0F -
                deltaQuat_idx_1 * rtb_Init[1] * rtb_Init[3] / 4.0F) -
      deltaQuat_idx_2 * rtb_Init[2] * i_y / 2.0F;

    /* '<S4>:1:123' */
    SQ_idx_8 = (deltaQuat_idx_2 * rtb_Init[2] * rtb_Init[3] / 4.0F -
                deltaQuat_idx_1 * rtb_Init[1] * i_y / 2.0F) - qUpdated_idx_2 *
      rtb_Init[2] * rtb_Init[3] / 4.0F;

    /* '<S4>:1:124' */
    i_y = SG_idx_0 * SG_idx_0;

    /* '<S4>:1:125' */
    SG_idx_0 = rtb_Init[1] * rtb_Init[1];

    /* '<S4>:1:127' */
    /* '<S4>:1:128' */
    SPP_idx_0 = (2.0F * rtb_Init[1] * SF_idx_1 + 2.0F * rtb_Init[0] * SF_idx_0)
      - 2.0F * rtb_Init[2] * SF_idx_2;

    /* '<S4>:1:129' */
    SPP_idx_1 = ((SPP_idx_3 - SPP_idx_4) - SPP_idx_8) + SPP_idx_9;

    /* '<S4>:1:130' */
    SPP_idx_2 = ((SPP_idx_3 - SPP_idx_4) + SPP_idx_8) - SPP_idx_9;

    /* '<S4>:1:131' */
    SPP_idx_3 = ((SPP_idx_3 + SPP_idx_4) - SPP_idx_8) - SPP_idx_9;

    /* '<S4>:1:132' */
    SPP_idx_4 = (2.0F * rtb_Init[0] * SF_idx_2 + 2.0F * rtb_Init[2] * SF_idx_0)
      - 2.0F * rtb_Init[3] * SF_idx_1;

    /* '<S4>:1:133' */
    SF_idx_0 = (2.0F * rtb_Init[0] * SF_idx_1 - 2.0F * rtb_Init[1] * SF_idx_0) +
      2.0F * rtb_Init[3] * SF_idx_2;

    /* '<S4>:1:134' */
    SF_idx_1 = 2.0F * rtb_Init[0] * rtb_Init[2] - 2.0F * rtb_Init[1] * rtb_Init
      [3];

    /* '<S4>:1:135' */
    SF_idx_2 = 2.0F * rtb_Init[0] * rtb_Init[1] - 2.0F * rtb_Init[2] * rtb_Init
      [3];

    /* '<S4>:1:136' */
    SPP_idx_8 = 2.0F * rtb_Init[0] * rtb_Init[3] - 2.0F * rtb_Init[1] *
      rtb_Init[2];

    /* '<S4>:1:137' */
    SPP_idx_9 = 2.0F * rtb_Init[0] * rtb_Init[1] + 2.0F * rtb_Init[2] *
      rtb_Init[3];

    /* '<S4>:1:138' */
    SPP_idx_10 = 2.0F * rtb_Init[0] * rtb_Init[3] + 2.0F * rtb_Init[1] *
      rtb_Init[2];

    /* '<S4>:1:139' */
    SPP_idx_11 = 2.0F * rtb_Init[0] * rtb_Init[2] + 2.0F * rtb_Init[1] *
      rtb_Init[3];

    /* '<S4>:1:140' */
    /* '<S4>:1:142' */
    /* '<S4>:1:143' */
    rty_nextP[0] = ((((((((((((((rtb_Init_p[1] * SF_idx_9 + rtb_Init_p[0]) +
      rtb_Init_p[2] * SF_idx_11) + rtb_Init_p[3] * SF_idx_10) + rtb_Init_p[10] *
      g_y) + rtb_Init_p[11] * h_y) + rtb_Init_p[12] * SF_idx_16) +
      deltaQuat_idx_1 * SG_idx_0 / 4.0F) + ((((((rtb_Init_p[17] * SF_idx_9 +
      rtb_Init_p[16]) + rtb_Init_p[18] * SF_idx_11) + rtb_Init_p[19] * SF_idx_10)
      + rtb_Init_p[26] * g_y) + rtb_Init_p[27] * h_y) + rtb_Init_p[28] *
      SF_idx_16) * SF_idx_9) + ((((((rtb_Init_p[33] * SF_idx_9 + rtb_Init_p[32])
      + rtb_Init_p[34] * SF_idx_11) + rtb_Init_p[35] * SF_idx_10) + rtb_Init_p
      [42] * g_y) + rtb_Init_p[43] * h_y) + rtb_Init_p[44] * SF_idx_16) *
                         SF_idx_11) + ((((((rtb_Init_p[49] * SF_idx_9 +
      rtb_Init_p[48]) + rtb_Init_p[50] * SF_idx_11) + rtb_Init_p[51] * SF_idx_10)
      + rtb_Init_p[58] * g_y) + rtb_Init_p[59] * h_y) + rtb_Init_p[60] *
      SF_idx_16) * SF_idx_10) + ((((((rtb_Init_p[161] * SF_idx_9 + rtb_Init_p
      [160]) + rtb_Init_p[162] * SF_idx_11) + rtb_Init_p[163] * SF_idx_10) +
      rtb_Init_p[170] * g_y) + rtb_Init_p[171] * h_y) + rtb_Init_p[172] *
      SF_idx_16) * g_y) + ((((((rtb_Init_p[177] * SF_idx_9 + rtb_Init_p[176]) +
      rtb_Init_p[178] * SF_idx_11) + rtb_Init_p[179] * SF_idx_10) + rtb_Init_p
      [186] * g_y) + rtb_Init_p[187] * h_y) + rtb_Init_p[188] * SF_idx_16) * h_y)
                     + ((((((rtb_Init_p[193] * SF_idx_9 + rtb_Init_p[192]) +
      rtb_Init_p[194] * SF_idx_11) + rtb_Init_p[195] * SF_idx_10) + rtb_Init_p
                          [202] * g_y) + rtb_Init_p[203] * h_y) + rtb_Init_p[204]
                        * SF_idx_16) * SF_idx_16) + rtb_Init[2] * rtb_Init[2] *
                    deltaQuat_idx_2 / 4.0F) + rtb_Init[3] * rtb_Init[3] *
      qUpdated_idx_2 / 4.0F;

    /* '<S4>:1:144' */
    rty_nextP[16] = (((((((((((rtb_Init_p[1] * SF_idx_9 + rtb_Init_p[0]) +
      rtb_Init_p[2] * SF_idx_11) + rtb_Init_p[3] * SF_idx_10) + rtb_Init_p[10] *
      g_y) + rtb_Init_p[11] * h_y) + rtb_Init_p[12] * SF_idx_16) * SF_idx_8 +
                         (((((((rtb_Init_p[16] + SQ_idx_8) + rtb_Init_p[17] *
      SF_idx_9) + rtb_Init_p[18] * SF_idx_11) + rtb_Init_p[19] * SF_idx_10) +
      rtb_Init_p[26] * g_y) + rtb_Init_p[27] * h_y) + rtb_Init_p[28] * SF_idx_16))
                        + ((((((rtb_Init_p[33] * SF_idx_9 + rtb_Init_p[32]) +
      rtb_Init_p[34] * SF_idx_11) + rtb_Init_p[35] * SF_idx_10) + rtb_Init_p[42]
      * g_y) + rtb_Init_p[43] * h_y) + rtb_Init_p[44] * SF_idx_16) * SF_idx_7) +
                       ((((((rtb_Init_p[49] * SF_idx_9 + rtb_Init_p[48]) +
      rtb_Init_p[50] * SF_idx_11) + rtb_Init_p[51] * SF_idx_10) + rtb_Init_p[58]
                          * g_y) + rtb_Init_p[59] * h_y) + rtb_Init_p[60] *
                        SF_idx_16) * SF_idx_11) - ((((((rtb_Init_p[193] *
      SF_idx_9 + rtb_Init_p[192]) + rtb_Init_p[194] * SF_idx_11) + rtb_Init_p
      [195] * SF_idx_10) + rtb_Init_p[202] * g_y) + rtb_Init_p[203] * h_y) +
      rtb_Init_p[204] * SF_idx_16) * h_y) + ((((((rtb_Init_p[177] * SF_idx_9 +
      rtb_Init_p[176]) + rtb_Init_p[178] * SF_idx_11) + rtb_Init_p[179] *
      SF_idx_10) + rtb_Init_p[186] * g_y) + rtb_Init_p[187] * h_y) + rtb_Init_p
      [188] * SF_idx_16) * SF_idx_16) - ((((((rtb_Init_p[161] * SF_idx_9 +
      rtb_Init_p[160]) + rtb_Init_p[162] * SF_idx_11) + rtb_Init_p[163] *
      SF_idx_10) + rtb_Init_p[170] * g_y) + rtb_Init_p[171] * h_y) + rtb_Init_p
      [172] * SF_idx_16) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:145' */
    rty_nextP[32] = (((((((((((rtb_Init_p[1] * SF_idx_9 + rtb_Init_p[0]) +
      rtb_Init_p[2] * SF_idx_11) + rtb_Init_p[3] * SF_idx_10) + rtb_Init_p[10] *
      g_y) + rtb_Init_p[11] * h_y) + rtb_Init_p[12] * SF_idx_16) * SF_idx_6 +
                         (((((((rtb_Init_p[32] + SQ_idx_7) + rtb_Init_p[33] *
      SF_idx_9) + rtb_Init_p[34] * SF_idx_11) + rtb_Init_p[35] * SF_idx_10) +
      rtb_Init_p[42] * g_y) + rtb_Init_p[43] * h_y) + rtb_Init_p[44] * SF_idx_16))
                        + ((((((rtb_Init_p[17] * SF_idx_9 + rtb_Init_p[16]) +
      rtb_Init_p[18] * SF_idx_11) + rtb_Init_p[19] * SF_idx_10) + rtb_Init_p[26]
      * g_y) + rtb_Init_p[27] * h_y) + rtb_Init_p[28] * SF_idx_16) * SF_idx_10)
                       + ((((((rtb_Init_p[49] * SF_idx_9 + rtb_Init_p[48]) +
      rtb_Init_p[50] * SF_idx_11) + rtb_Init_p[51] * SF_idx_10) + rtb_Init_p[58]
      * g_y) + rtb_Init_p[59] * h_y) + rtb_Init_p[60] * SF_idx_16) * SF_idx_8) +
                      ((((((rtb_Init_p[193] * SF_idx_9 + rtb_Init_p[192]) +
      rtb_Init_p[194] * SF_idx_11) + rtb_Init_p[195] * SF_idx_10) + rtb_Init_p
                         [202] * g_y) + rtb_Init_p[203] * h_y) + rtb_Init_p[204]
                       * SF_idx_16) * g_y) - ((((((rtb_Init_p[161] * SF_idx_9 +
      rtb_Init_p[160]) + rtb_Init_p[162] * SF_idx_11) + rtb_Init_p[163] *
      SF_idx_10) + rtb_Init_p[170] * g_y) + rtb_Init_p[171] * h_y) + rtb_Init_p
      [172] * SF_idx_16) * SF_idx_16) - ((((((rtb_Init_p[177] * SF_idx_9 +
      rtb_Init_p[176]) + rtb_Init_p[178] * SF_idx_11) + rtb_Init_p[179] *
      SF_idx_10) + rtb_Init_p[186] * g_y) + rtb_Init_p[187] * h_y) + rtb_Init_p
      [188] * SF_idx_16) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:146' */
    rty_nextP[48] = (((((((((((rtb_Init_p[1] * SF_idx_9 + rtb_Init_p[0]) +
      rtb_Init_p[2] * SF_idx_11) + rtb_Init_p[3] * SF_idx_10) + rtb_Init_p[10] *
      g_y) + rtb_Init_p[11] * h_y) + rtb_Init_p[12] * SF_idx_16) * SF_idx_7 +
                         (((((((rtb_Init_p[48] + SQ_idx_6) + rtb_Init_p[49] *
      SF_idx_9) + rtb_Init_p[50] * SF_idx_11) + rtb_Init_p[51] * SF_idx_10) +
      rtb_Init_p[58] * g_y) + rtb_Init_p[59] * h_y) + rtb_Init_p[60] * SF_idx_16))
                        + ((((((rtb_Init_p[17] * SF_idx_9 + rtb_Init_p[16]) +
      rtb_Init_p[18] * SF_idx_11) + rtb_Init_p[19] * SF_idx_10) + rtb_Init_p[26]
      * g_y) + rtb_Init_p[27] * h_y) + rtb_Init_p[28] * SF_idx_16) * SF_idx_6) +
                       ((((((rtb_Init_p[33] * SF_idx_9 + rtb_Init_p[32]) +
      rtb_Init_p[34] * SF_idx_11) + rtb_Init_p[35] * SF_idx_10) + rtb_Init_p[42]
                          * g_y) + rtb_Init_p[43] * h_y) + rtb_Init_p[44] *
                        SF_idx_16) * SF_idx_9) + ((((((rtb_Init_p[161] *
      SF_idx_9 + rtb_Init_p[160]) + rtb_Init_p[162] * SF_idx_11) + rtb_Init_p
      [163] * SF_idx_10) + rtb_Init_p[170] * g_y) + rtb_Init_p[171] * h_y) +
      rtb_Init_p[172] * SF_idx_16) * h_y) - ((((((rtb_Init_p[177] * SF_idx_9 +
      rtb_Init_p[176]) + rtb_Init_p[178] * SF_idx_11) + rtb_Init_p[179] *
      SF_idx_10) + rtb_Init_p[186] * g_y) + rtb_Init_p[187] * h_y) + rtb_Init_p
      [188] * SF_idx_16) * g_y) - ((((((rtb_Init_p[193] * SF_idx_9 + rtb_Init_p
      [192]) + rtb_Init_p[194] * SF_idx_11) + rtb_Init_p[195] * SF_idx_10) +
      rtb_Init_p[202] * g_y) + rtb_Init_p[203] * h_y) + rtb_Init_p[204] *
      SF_idx_16) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:147' */
    rty_nextP[64] = ((((((((((((rtb_Init_p[1] * SF_idx_9 + rtb_Init_p[0]) +
      rtb_Init_p[2] * SF_idx_11) + rtb_Init_p[3] * SF_idx_10) + rtb_Init_p[10] *
      g_y) + rtb_Init_p[11] * h_y) + rtb_Init_p[12] * SF_idx_16) * SF_idx_5 +
                          ((((((rtb_Init_p[65] * SF_idx_9 + rtb_Init_p[64]) +
      rtb_Init_p[66] * SF_idx_11) + rtb_Init_p[67] * SF_idx_10) + rtb_Init_p[74]
      * g_y) + rtb_Init_p[75] * h_y) + rtb_Init_p[76] * SF_idx_16)) +
                         ((((((rtb_Init_p[17] * SF_idx_9 + rtb_Init_p[16]) +
      rtb_Init_p[18] * SF_idx_11) + rtb_Init_p[19] * SF_idx_10) + rtb_Init_p[26]
      * g_y) + rtb_Init_p[27] * h_y) + rtb_Init_p[28] * SF_idx_16) * SF_idx_3) +
                        ((((((rtb_Init_p[33] * SF_idx_9 + rtb_Init_p[32]) +
      rtb_Init_p[34] * SF_idx_11) + rtb_Init_p[35] * SF_idx_10) + rtb_Init_p[42]
      * g_y) + rtb_Init_p[43] * h_y) + rtb_Init_p[44] * SF_idx_16) * SPP_idx_0)
                       - ((((((rtb_Init_p[49] * SF_idx_9 + rtb_Init_p[48]) +
      rtb_Init_p[50] * SF_idx_11) + rtb_Init_p[51] * SF_idx_10) + rtb_Init_p[58]
      * g_y) + rtb_Init_p[59] * h_y) + rtb_Init_p[60] * SF_idx_16) * SF_idx_0) +
                      ((((((rtb_Init_p[209] * SF_idx_9 + rtb_Init_p[208]) +
      rtb_Init_p[210] * SF_idx_11) + rtb_Init_p[211] * SF_idx_10) + rtb_Init_p
                         [218] * g_y) + rtb_Init_p[219] * h_y) + rtb_Init_p[220]
                       * SF_idx_16) * SPP_idx_3) - ((((((rtb_Init_p[241] *
      SF_idx_9 + rtb_Init_p[240]) + rtb_Init_p[242] * SF_idx_11) + rtb_Init_p
      [243] * SF_idx_10) + rtb_Init_p[250] * g_y) + rtb_Init_p[251] * h_y) +
      rtb_Init_p[252] * SF_idx_16) * SPP_idx_11) + ((((((rtb_Init_p[225] *
      SF_idx_9 + rtb_Init_p[224]) + rtb_Init_p[226] * SF_idx_11) + rtb_Init_p
      [227] * SF_idx_10) + rtb_Init_p[234] * g_y) + rtb_Init_p[235] * h_y) +
      rtb_Init_p[236] * SF_idx_16) * (2.0F * rtb_Init[0] * rtb_Init[3] - 2.0F *
      rtb_Init[1] * rtb_Init[2]);

    /* '<S4>:1:148' */
    rty_nextP[80] = ((((((((((((rtb_Init_p[1] * SF_idx_9 + rtb_Init_p[0]) +
      rtb_Init_p[2] * SF_idx_11) + rtb_Init_p[3] * SF_idx_10) + rtb_Init_p[10] *
      g_y) + rtb_Init_p[11] * h_y) + rtb_Init_p[12] * SF_idx_16) * SF_idx_4 +
                          ((((((rtb_Init_p[81] * SF_idx_9 + rtb_Init_p[80]) +
      rtb_Init_p[82] * SF_idx_11) + rtb_Init_p[83] * SF_idx_10) + rtb_Init_p[90]
      * g_y) + rtb_Init_p[91] * h_y) + rtb_Init_p[92] * SF_idx_16)) +
                         ((((((rtb_Init_p[33] * SF_idx_9 + rtb_Init_p[32]) +
      rtb_Init_p[34] * SF_idx_11) + rtb_Init_p[35] * SF_idx_10) + rtb_Init_p[42]
      * g_y) + rtb_Init_p[43] * h_y) + rtb_Init_p[44] * SF_idx_16) * SF_idx_3) +
                        ((((((rtb_Init_p[49] * SF_idx_9 + rtb_Init_p[48]) +
      rtb_Init_p[50] * SF_idx_11) + rtb_Init_p[51] * SF_idx_10) + rtb_Init_p[58]
      * g_y) + rtb_Init_p[59] * h_y) + rtb_Init_p[60] * SF_idx_16) * SF_idx_5) -
                       ((((((rtb_Init_p[17] * SF_idx_9 + rtb_Init_p[16]) +
      rtb_Init_p[18] * SF_idx_11) + rtb_Init_p[19] * SF_idx_10) + rtb_Init_p[26]
                          * g_y) + rtb_Init_p[27] * h_y) + rtb_Init_p[28] *
                        SF_idx_16) * SPP_idx_0) + ((((((rtb_Init_p[225] *
      SF_idx_9 + rtb_Init_p[224]) + rtb_Init_p[226] * SF_idx_11) + rtb_Init_p
      [227] * SF_idx_10) + rtb_Init_p[234] * g_y) + rtb_Init_p[235] * h_y) +
      rtb_Init_p[236] * SF_idx_16) * SPP_idx_2) - ((((((rtb_Init_p[209] *
      SF_idx_9 + rtb_Init_p[208]) + rtb_Init_p[210] * SF_idx_11) + rtb_Init_p
      [211] * SF_idx_10) + rtb_Init_p[218] * g_y) + rtb_Init_p[219] * h_y) +
      rtb_Init_p[220] * SF_idx_16) * SPP_idx_10) + ((((((rtb_Init_p[241] *
      SF_idx_9 + rtb_Init_p[240]) + rtb_Init_p[242] * SF_idx_11) + rtb_Init_p
      [243] * SF_idx_10) + rtb_Init_p[250] * g_y) + rtb_Init_p[251] * h_y) +
      rtb_Init_p[252] * SF_idx_16) * (2.0F * rtb_Init[0] * rtb_Init[1] - 2.0F *
      rtb_Init[2] * rtb_Init[3]);

    /* '<S4>:1:149' */
    rty_nextP[96] = ((((((((((((rtb_Init_p[17] * SF_idx_9 + rtb_Init_p[16]) +
      rtb_Init_p[18] * SF_idx_11) + rtb_Init_p[19] * SF_idx_10) + rtb_Init_p[26]
      * g_y) + rtb_Init_p[27] * h_y) + rtb_Init_p[28] * SF_idx_16) * SF_idx_4 +
                          ((((((rtb_Init_p[97] * SF_idx_9 + rtb_Init_p[96]) +
      rtb_Init_p[98] * SF_idx_11) + rtb_Init_p[99] * SF_idx_10) + rtb_Init_p[106]
      * g_y) + rtb_Init_p[107] * h_y) + rtb_Init_p[108] * SF_idx_16)) +
                         ((((((rtb_Init_p[49] * SF_idx_9 + rtb_Init_p[48]) +
      rtb_Init_p[50] * SF_idx_11) + rtb_Init_p[51] * SF_idx_10) + rtb_Init_p[58]
      * g_y) + rtb_Init_p[59] * h_y) + rtb_Init_p[60] * SF_idx_16) * SF_idx_3) +
                        ((((((rtb_Init_p[1] * SF_idx_9 + rtb_Init_p[0]) +
      rtb_Init_p[2] * SF_idx_11) + rtb_Init_p[3] * SF_idx_10) + rtb_Init_p[10] *
      g_y) + rtb_Init_p[11] * h_y) + rtb_Init_p[12] * SF_idx_16) * SPP_idx_0) -
                       ((((((rtb_Init_p[33] * SF_idx_9 + rtb_Init_p[32]) +
      rtb_Init_p[34] * SF_idx_11) + rtb_Init_p[35] * SF_idx_10) + rtb_Init_p[42]
                          * g_y) + rtb_Init_p[43] * h_y) + rtb_Init_p[44] *
                        SF_idx_16) * SPP_idx_4) + ((((((rtb_Init_p[209] *
      SF_idx_9 + rtb_Init_p[208]) + rtb_Init_p[210] * SF_idx_11) + rtb_Init_p
      [211] * SF_idx_10) + rtb_Init_p[218] * g_y) + rtb_Init_p[219] * h_y) +
      rtb_Init_p[220] * SF_idx_16) * SF_idx_1) - ((((((rtb_Init_p[241] *
      SF_idx_9 + rtb_Init_p[240]) + rtb_Init_p[242] * SF_idx_11) + rtb_Init_p
      [243] * SF_idx_10) + rtb_Init_p[250] * g_y) + rtb_Init_p[251] * h_y) +
      rtb_Init_p[252] * SF_idx_16) * SPP_idx_1) - ((((((rtb_Init_p[225] *
      SF_idx_9 + rtb_Init_p[224]) + rtb_Init_p[226] * SF_idx_11) + rtb_Init_p
      [227] * SF_idx_10) + rtb_Init_p[234] * g_y) + rtb_Init_p[235] * h_y) +
      rtb_Init_p[236] * SF_idx_16) * SPP_idx_9;

    /* '<S4>:1:150' */
    rty_nextP[112] = ((((((rtb_Init_p[65] * SF_idx_9 + rtb_Init_p[64]) +
                          rtb_Init_p[66] * SF_idx_11) + rtb_Init_p[67] *
                         SF_idx_10) + rtb_Init_p[74] * g_y) + rtb_Init_p[75] *
                       h_y) + rtb_Init_p[76] * SF_idx_16) * localDW->dt +
      ((((((rtb_Init_p[113] * SF_idx_9 + rtb_Init_p[112]) + rtb_Init_p[114] *
           SF_idx_11) + rtb_Init_p[115] * SF_idx_10) + rtb_Init_p[122] * g_y) +
        rtb_Init_p[123] * h_y) + rtb_Init_p[124] * SF_idx_16);

    /* '<S4>:1:151' */
    rty_nextP[128] = ((((((rtb_Init_p[81] * SF_idx_9 + rtb_Init_p[80]) +
                          rtb_Init_p[82] * SF_idx_11) + rtb_Init_p[83] *
                         SF_idx_10) + rtb_Init_p[90] * g_y) + rtb_Init_p[91] *
                       h_y) + rtb_Init_p[92] * SF_idx_16) * localDW->dt +
      ((((((rtb_Init_p[129] * SF_idx_9 + rtb_Init_p[128]) + rtb_Init_p[130] *
           SF_idx_11) + rtb_Init_p[131] * SF_idx_10) + rtb_Init_p[138] * g_y) +
        rtb_Init_p[139] * h_y) + rtb_Init_p[140] * SF_idx_16);

    /* '<S4>:1:152' */
    rty_nextP[144] = ((((((rtb_Init_p[97] * SF_idx_9 + rtb_Init_p[96]) +
                          rtb_Init_p[98] * SF_idx_11) + rtb_Init_p[99] *
                         SF_idx_10) + rtb_Init_p[106] * g_y) + rtb_Init_p[107] *
                       h_y) + rtb_Init_p[108] * SF_idx_16) * localDW->dt +
      ((((((rtb_Init_p[145] * SF_idx_9 + rtb_Init_p[144]) + rtb_Init_p[146] *
           SF_idx_11) + rtb_Init_p[147] * SF_idx_10) + rtb_Init_p[154] * g_y) +
        rtb_Init_p[155] * h_y) + rtb_Init_p[156] * SF_idx_16);

    /* '<S4>:1:153' */
    rty_nextP[160] = (((((rtb_Init_p[161] * SF_idx_9 + rtb_Init_p[160]) +
                         rtb_Init_p[162] * SF_idx_11) + rtb_Init_p[163] *
                        SF_idx_10) + rtb_Init_p[170] * g_y) + rtb_Init_p[171] *
                      h_y) + rtb_Init_p[172] * SF_idx_16;

    /* '<S4>:1:154' */
    rty_nextP[176] = (((((rtb_Init_p[177] * SF_idx_9 + rtb_Init_p[176]) +
                         rtb_Init_p[178] * SF_idx_11) + rtb_Init_p[179] *
                        SF_idx_10) + rtb_Init_p[186] * g_y) + rtb_Init_p[187] *
                      h_y) + rtb_Init_p[188] * SF_idx_16;

    /* '<S4>:1:155' */
    rty_nextP[192] = (((((rtb_Init_p[193] * SF_idx_9 + rtb_Init_p[192]) +
                         rtb_Init_p[194] * SF_idx_11) + rtb_Init_p[195] *
                        SF_idx_10) + rtb_Init_p[202] * g_y) + rtb_Init_p[203] *
                      h_y) + rtb_Init_p[204] * SF_idx_16;

    /* '<S4>:1:156' */
    rty_nextP[208] = (((((rtb_Init_p[209] * SF_idx_9 + rtb_Init_p[208]) +
                         rtb_Init_p[210] * SF_idx_11) + rtb_Init_p[211] *
                        SF_idx_10) + rtb_Init_p[218] * g_y) + rtb_Init_p[219] *
                      h_y) + rtb_Init_p[220] * SF_idx_16;

    /* '<S4>:1:157' */
    rty_nextP[224] = (((((rtb_Init_p[225] * SF_idx_9 + rtb_Init_p[224]) +
                         rtb_Init_p[226] * SF_idx_11) + rtb_Init_p[227] *
                        SF_idx_10) + rtb_Init_p[234] * g_y) + rtb_Init_p[235] *
                      h_y) + rtb_Init_p[236] * SF_idx_16;

    /* '<S4>:1:158' */
    rty_nextP[240] = (((((rtb_Init_p[241] * SF_idx_9 + rtb_Init_p[240]) +
                         rtb_Init_p[242] * SF_idx_11) + rtb_Init_p[243] *
                        SF_idx_10) + rtb_Init_p[250] * g_y) + rtb_Init_p[251] *
                      h_y) + rtb_Init_p[252] * SF_idx_16;

    /* '<S4>:1:159' */
    rty_nextP[1] = (((((((((((rtb_Init_p[16] * SF_idx_8 + rtb_Init_p[17]) +
      rtb_Init_p[18] * SF_idx_7) + rtb_Init_p[19] * SF_idx_11) - rtb_Init_p[28] *
      h_y) + rtb_Init_p[27] * SF_idx_16) - rtb_Init_p[26] * rtb_Init[0] / 2.0F) *
                        SF_idx_9 + (((((((rtb_Init_p[1] + SQ_idx_8) +
      rtb_Init_p[0] * SF_idx_8) + rtb_Init_p[2] * SF_idx_7) + rtb_Init_p[3] *
      SF_idx_11) - rtb_Init_p[12] * h_y) + rtb_Init_p[11] * SF_idx_16) -
      rtb_Init_p[10] * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[32] * SF_idx_8 +
      rtb_Init_p[33]) + rtb_Init_p[34] * SF_idx_7) + rtb_Init_p[35] * SF_idx_11)
      - rtb_Init_p[44] * h_y) + rtb_Init_p[43] * SF_idx_16) - rtb_Init_p[42] *
      rtb_Init[0] / 2.0F) * SF_idx_11) + ((((((rtb_Init_p[48] * SF_idx_8 +
      rtb_Init_p[49]) + rtb_Init_p[50] * SF_idx_7) + rtb_Init_p[51] * SF_idx_11)
      - rtb_Init_p[60] * h_y) + rtb_Init_p[59] * SF_idx_16) - rtb_Init_p[58] *
      rtb_Init[0] / 2.0F) * SF_idx_10) + ((((((rtb_Init_p[160] * SF_idx_8 +
      rtb_Init_p[161]) + rtb_Init_p[162] * SF_idx_7) + rtb_Init_p[163] *
      SF_idx_11) - rtb_Init_p[172] * h_y) + rtb_Init_p[171] * SF_idx_16) -
      rtb_Init_p[170] * rtb_Init[0] / 2.0F) * g_y) + ((((((rtb_Init_p[176] *
      SF_idx_8 + rtb_Init_p[177]) + rtb_Init_p[178] * SF_idx_7) + rtb_Init_p[179]
      * SF_idx_11) - rtb_Init_p[188] * h_y) + rtb_Init_p[187] * SF_idx_16) -
      rtb_Init_p[186] * rtb_Init[0] / 2.0F) * h_y) + ((((((rtb_Init_p[192] *
      SF_idx_8 + rtb_Init_p[193]) + rtb_Init_p[194] * SF_idx_7) + rtb_Init_p[195]
      * SF_idx_11) - rtb_Init_p[204] * h_y) + rtb_Init_p[203] * SF_idx_16) -
      rtb_Init_p[202] * rtb_Init[0] / 2.0F) * SF_idx_16;

    /* '<S4>:1:160' */
    rty_nextP[17] = ((((((((((((((rtb_Init_p[16] * SF_idx_8 + rtb_Init_p[17]) +
      rtb_Init_p[18] * SF_idx_7) + rtb_Init_p[19] * SF_idx_11) - rtb_Init_p[28] *
      h_y) + rtb_Init_p[27] * SF_idx_16) + deltaQuat_idx_1 * i_y) - rtb_Init_p
      [26] * rtb_Init[0] / 2.0F) + ((((((rtb_Init_p[0] * SF_idx_8 + rtb_Init_p[1])
      + rtb_Init_p[2] * SF_idx_7) + rtb_Init_p[3] * SF_idx_11) - rtb_Init_p[12] *
      h_y) + rtb_Init_p[11] * SF_idx_16) - rtb_Init_p[10] * rtb_Init[0] / 2.0F) *
      SF_idx_8) + ((((((rtb_Init_p[32] * SF_idx_8 + rtb_Init_p[33]) +
                       rtb_Init_p[34] * SF_idx_7) + rtb_Init_p[35] * SF_idx_11)
                     - rtb_Init_p[44] * h_y) + rtb_Init_p[43] * SF_idx_16) -
                   rtb_Init_p[42] * rtb_Init[0] / 2.0F) * SF_idx_7) +
                         ((((((rtb_Init_p[48] * SF_idx_8 + rtb_Init_p[49]) +
      rtb_Init_p[50] * SF_idx_7) + rtb_Init_p[51] * SF_idx_11) - rtb_Init_p[60] *
      h_y) + rtb_Init_p[59] * SF_idx_16) - rtb_Init_p[58] * rtb_Init[0] / 2.0F) *
                         SF_idx_11) - ((((((rtb_Init_p[192] * SF_idx_8 +
      rtb_Init_p[193]) + rtb_Init_p[194] * SF_idx_7) + rtb_Init_p[195] *
      SF_idx_11) - rtb_Init_p[204] * h_y) + rtb_Init_p[203] * SF_idx_16) -
      rtb_Init_p[202] * rtb_Init[0] / 2.0F) * h_y) + ((((((rtb_Init_p[176] *
      SF_idx_8 + rtb_Init_p[177]) + rtb_Init_p[178] * SF_idx_7) + rtb_Init_p[179]
      * SF_idx_11) - rtb_Init_p[188] * h_y) + rtb_Init_p[187] * SF_idx_16) -
      rtb_Init_p[186] * rtb_Init[0] / 2.0F) * SF_idx_16) + rtb_Init[3] *
                      rtb_Init[3] * deltaQuat_idx_2 / 4.0F) + rtb_Init[2] *
                     rtb_Init[2] * qUpdated_idx_2 / 4.0F) - ((((((rtb_Init_p[160]
      * SF_idx_8 + rtb_Init_p[161]) + rtb_Init_p[162] * SF_idx_7) + rtb_Init_p
      [163] * SF_idx_11) - rtb_Init_p[172] * h_y) + rtb_Init_p[171] * SF_idx_16)
      - rtb_Init_p[170] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:161' */
    rty_nextP[33] = (((((((((((rtb_Init_p[0] * SF_idx_8 + rtb_Init_p[1]) +
      rtb_Init_p[2] * SF_idx_7) + rtb_Init_p[3] * SF_idx_11) - rtb_Init_p[12] *
      h_y) + rtb_Init_p[11] * SF_idx_16) - rtb_Init_p[10] * rtb_Init[0] / 2.0F) *
                         SF_idx_6 + (((((((rtb_Init_p[33] + SQ_idx_5) +
      rtb_Init_p[32] * SF_idx_8) + rtb_Init_p[34] * SF_idx_7) + rtb_Init_p[35] *
      SF_idx_11) - rtb_Init_p[44] * h_y) + rtb_Init_p[43] * SF_idx_16) -
      rtb_Init_p[42] * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[16] * SF_idx_8 +
      rtb_Init_p[17]) + rtb_Init_p[18] * SF_idx_7) + rtb_Init_p[19] * SF_idx_11)
      - rtb_Init_p[28] * h_y) + rtb_Init_p[27] * SF_idx_16) - rtb_Init_p[26] *
      rtb_Init[0] / 2.0F) * SF_idx_10) + ((((((rtb_Init_p[48] * SF_idx_8 +
      rtb_Init_p[49]) + rtb_Init_p[50] * SF_idx_7) + rtb_Init_p[51] * SF_idx_11)
      - rtb_Init_p[60] * h_y) + rtb_Init_p[59] * SF_idx_16) - rtb_Init_p[58] *
      rtb_Init[0] / 2.0F) * SF_idx_8) + ((((((rtb_Init_p[192] * SF_idx_8 +
      rtb_Init_p[193]) + rtb_Init_p[194] * SF_idx_7) + rtb_Init_p[195] *
      SF_idx_11) - rtb_Init_p[204] * h_y) + rtb_Init_p[203] * SF_idx_16) -
      rtb_Init_p[202] * rtb_Init[0] / 2.0F) * g_y) - ((((((rtb_Init_p[160] *
      SF_idx_8 + rtb_Init_p[161]) + rtb_Init_p[162] * SF_idx_7) + rtb_Init_p[163]
      * SF_idx_11) - rtb_Init_p[172] * h_y) + rtb_Init_p[171] * SF_idx_16) -
      rtb_Init_p[170] * rtb_Init[0] / 2.0F) * SF_idx_16) - ((((((rtb_Init_p[176]
      * SF_idx_8 + rtb_Init_p[177]) + rtb_Init_p[178] * SF_idx_7) + rtb_Init_p
      [179] * SF_idx_11) - rtb_Init_p[188] * h_y) + rtb_Init_p[187] * SF_idx_16)
      - rtb_Init_p[186] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:162' */
    rty_nextP[49] = (((((((((((rtb_Init_p[0] * SF_idx_8 + rtb_Init_p[1]) +
      rtb_Init_p[2] * SF_idx_7) + rtb_Init_p[3] * SF_idx_11) - rtb_Init_p[12] *
      h_y) + rtb_Init_p[11] * SF_idx_16) - rtb_Init_p[10] * rtb_Init[0] / 2.0F) *
                         SF_idx_7 + (((((((rtb_Init_p[49] + SQ_idx_4) +
      rtb_Init_p[48] * SF_idx_8) + rtb_Init_p[50] * SF_idx_7) + rtb_Init_p[51] *
      SF_idx_11) - rtb_Init_p[60] * h_y) + rtb_Init_p[59] * SF_idx_16) -
      rtb_Init_p[58] * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[16] * SF_idx_8 +
      rtb_Init_p[17]) + rtb_Init_p[18] * SF_idx_7) + rtb_Init_p[19] * SF_idx_11)
      - rtb_Init_p[28] * h_y) + rtb_Init_p[27] * SF_idx_16) - rtb_Init_p[26] *
      rtb_Init[0] / 2.0F) * SF_idx_6) + ((((((rtb_Init_p[32] * SF_idx_8 +
      rtb_Init_p[33]) + rtb_Init_p[34] * SF_idx_7) + rtb_Init_p[35] * SF_idx_11)
      - rtb_Init_p[44] * h_y) + rtb_Init_p[43] * SF_idx_16) - rtb_Init_p[42] *
      rtb_Init[0] / 2.0F) * SF_idx_9) + ((((((rtb_Init_p[160] * SF_idx_8 +
      rtb_Init_p[161]) + rtb_Init_p[162] * SF_idx_7) + rtb_Init_p[163] *
      SF_idx_11) - rtb_Init_p[172] * h_y) + rtb_Init_p[171] * SF_idx_16) -
      rtb_Init_p[170] * rtb_Init[0] / 2.0F) * h_y) - ((((((rtb_Init_p[176] *
      SF_idx_8 + rtb_Init_p[177]) + rtb_Init_p[178] * SF_idx_7) + rtb_Init_p[179]
      * SF_idx_11) - rtb_Init_p[188] * h_y) + rtb_Init_p[187] * SF_idx_16) -
      rtb_Init_p[186] * rtb_Init[0] / 2.0F) * g_y) - ((((((rtb_Init_p[192] *
      SF_idx_8 + rtb_Init_p[193]) + rtb_Init_p[194] * SF_idx_7) + rtb_Init_p[195]
      * SF_idx_11) - rtb_Init_p[204] * h_y) + rtb_Init_p[203] * SF_idx_16) -
      rtb_Init_p[202] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:163' */
    rty_nextP[65] = ((((((((((((rtb_Init_p[0] * SF_idx_8 + rtb_Init_p[1]) +
      rtb_Init_p[2] * SF_idx_7) + rtb_Init_p[3] * SF_idx_11) - rtb_Init_p[12] *
      h_y) + rtb_Init_p[11] * SF_idx_16) - rtb_Init_p[10] * rtb_Init[0] / 2.0F) *
                          SF_idx_5 + ((((((rtb_Init_p[64] * SF_idx_8 +
      rtb_Init_p[65]) + rtb_Init_p[66] * SF_idx_7) + rtb_Init_p[67] * SF_idx_11)
      - rtb_Init_p[76] * h_y) + rtb_Init_p[75] * SF_idx_16) - rtb_Init_p[74] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[16] * SF_idx_8 + rtb_Init_p[17]) +
      rtb_Init_p[18] * SF_idx_7) + rtb_Init_p[19] * SF_idx_11) - rtb_Init_p[28] *
      h_y) + rtb_Init_p[27] * SF_idx_16) - rtb_Init_p[26] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[32] * SF_idx_8 +
      rtb_Init_p[33]) + rtb_Init_p[34] * SF_idx_7) + rtb_Init_p[35] * SF_idx_11)
      - rtb_Init_p[44] * h_y) + rtb_Init_p[43] * SF_idx_16) - rtb_Init_p[42] *
      rtb_Init[0] / 2.0F) * SPP_idx_0) - ((((((rtb_Init_p[48] * SF_idx_8 +
      rtb_Init_p[49]) + rtb_Init_p[50] * SF_idx_7) + rtb_Init_p[51] * SF_idx_11)
      - rtb_Init_p[60] * h_y) + rtb_Init_p[59] * SF_idx_16) - rtb_Init_p[58] *
      rtb_Init[0] / 2.0F) * SF_idx_0) + ((((((rtb_Init_p[208] * SF_idx_8 +
      rtb_Init_p[209]) + rtb_Init_p[210] * SF_idx_7) + rtb_Init_p[211] *
      SF_idx_11) - rtb_Init_p[220] * h_y) + rtb_Init_p[219] * SF_idx_16) -
      rtb_Init_p[218] * rtb_Init[0] / 2.0F) * SPP_idx_3) + ((((((rtb_Init_p[224]
      * SF_idx_8 + rtb_Init_p[225]) + rtb_Init_p[226] * SF_idx_7) + rtb_Init_p
      [227] * SF_idx_11) - rtb_Init_p[236] * h_y) + rtb_Init_p[235] * SF_idx_16)
      - rtb_Init_p[234] * rtb_Init[0] / 2.0F) * SPP_idx_8) - ((((((rtb_Init_p
      [240] * SF_idx_8 + rtb_Init_p[241]) + rtb_Init_p[242] * SF_idx_7) +
      rtb_Init_p[243] * SF_idx_11) - rtb_Init_p[252] * h_y) + rtb_Init_p[251] *
      SF_idx_16) - rtb_Init_p[250] * rtb_Init[0] / 2.0F) * SPP_idx_11;

    /* '<S4>:1:164' */
    rty_nextP[81] = ((((((((((((rtb_Init_p[0] * SF_idx_8 + rtb_Init_p[1]) +
      rtb_Init_p[2] * SF_idx_7) + rtb_Init_p[3] * SF_idx_11) - rtb_Init_p[12] *
      h_y) + rtb_Init_p[11] * SF_idx_16) - rtb_Init_p[10] * rtb_Init[0] / 2.0F) *
                          SF_idx_4 + ((((((rtb_Init_p[80] * SF_idx_8 +
      rtb_Init_p[81]) + rtb_Init_p[82] * SF_idx_7) + rtb_Init_p[83] * SF_idx_11)
      - rtb_Init_p[92] * h_y) + rtb_Init_p[91] * SF_idx_16) - rtb_Init_p[90] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[32] * SF_idx_8 + rtb_Init_p[33]) +
      rtb_Init_p[34] * SF_idx_7) + rtb_Init_p[35] * SF_idx_11) - rtb_Init_p[44] *
      h_y) + rtb_Init_p[43] * SF_idx_16) - rtb_Init_p[42] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[48] * SF_idx_8 +
      rtb_Init_p[49]) + rtb_Init_p[50] * SF_idx_7) + rtb_Init_p[51] * SF_idx_11)
      - rtb_Init_p[60] * h_y) + rtb_Init_p[59] * SF_idx_16) - rtb_Init_p[58] *
      rtb_Init[0] / 2.0F) * SF_idx_5) - ((((((rtb_Init_p[16] * SF_idx_8 +
      rtb_Init_p[17]) + rtb_Init_p[18] * SF_idx_7) + rtb_Init_p[19] * SF_idx_11)
      - rtb_Init_p[28] * h_y) + rtb_Init_p[27] * SF_idx_16) - rtb_Init_p[26] *
      rtb_Init[0] / 2.0F) * SPP_idx_0) + ((((((rtb_Init_p[224] * SF_idx_8 +
      rtb_Init_p[225]) + rtb_Init_p[226] * SF_idx_7) + rtb_Init_p[227] *
      SF_idx_11) - rtb_Init_p[236] * h_y) + rtb_Init_p[235] * SF_idx_16) -
      rtb_Init_p[234] * rtb_Init[0] / 2.0F) * SPP_idx_2) - ((((((rtb_Init_p[208]
      * SF_idx_8 + rtb_Init_p[209]) + rtb_Init_p[210] * SF_idx_7) + rtb_Init_p
      [211] * SF_idx_11) - rtb_Init_p[220] * h_y) + rtb_Init_p[219] * SF_idx_16)
      - rtb_Init_p[218] * rtb_Init[0] / 2.0F) * SPP_idx_10) + ((((((rtb_Init_p
      [240] * SF_idx_8 + rtb_Init_p[241]) + rtb_Init_p[242] * SF_idx_7) +
      rtb_Init_p[243] * SF_idx_11) - rtb_Init_p[252] * h_y) + rtb_Init_p[251] *
      SF_idx_16) - rtb_Init_p[250] * rtb_Init[0] / 2.0F) * SF_idx_2;

    /* '<S4>:1:165' */
    rty_nextP[97] = ((((((((((((rtb_Init_p[16] * SF_idx_8 + rtb_Init_p[17]) +
      rtb_Init_p[18] * SF_idx_7) + rtb_Init_p[19] * SF_idx_11) - rtb_Init_p[28] *
      h_y) + rtb_Init_p[27] * SF_idx_16) - rtb_Init_p[26] * rtb_Init[0] / 2.0F) *
                          SF_idx_4 + ((((((rtb_Init_p[96] * SF_idx_8 +
      rtb_Init_p[97]) + rtb_Init_p[98] * SF_idx_7) + rtb_Init_p[99] * SF_idx_11)
      - rtb_Init_p[108] * h_y) + rtb_Init_p[107] * SF_idx_16) - rtb_Init_p[106] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[48] * SF_idx_8 + rtb_Init_p[49]) +
      rtb_Init_p[50] * SF_idx_7) + rtb_Init_p[51] * SF_idx_11) - rtb_Init_p[60] *
      h_y) + rtb_Init_p[59] * SF_idx_16) - rtb_Init_p[58] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[0] * SF_idx_8 +
      rtb_Init_p[1]) + rtb_Init_p[2] * SF_idx_7) + rtb_Init_p[3] * SF_idx_11) -
      rtb_Init_p[12] * h_y) + rtb_Init_p[11] * SF_idx_16) - rtb_Init_p[10] *
      rtb_Init[0] / 2.0F) * SPP_idx_0) - ((((((rtb_Init_p[32] * SF_idx_8 +
      rtb_Init_p[33]) + rtb_Init_p[34] * SF_idx_7) + rtb_Init_p[35] * SF_idx_11)
      - rtb_Init_p[44] * h_y) + rtb_Init_p[43] * SF_idx_16) - rtb_Init_p[42] *
      rtb_Init[0] / 2.0F) * SPP_idx_4) + ((((((rtb_Init_p[208] * SF_idx_8 +
      rtb_Init_p[209]) + rtb_Init_p[210] * SF_idx_7) + rtb_Init_p[211] *
      SF_idx_11) - rtb_Init_p[220] * h_y) + rtb_Init_p[219] * SF_idx_16) -
      rtb_Init_p[218] * rtb_Init[0] / 2.0F) * SF_idx_1) - ((((((rtb_Init_p[240] *
      SF_idx_8 + rtb_Init_p[241]) + rtb_Init_p[242] * SF_idx_7) + rtb_Init_p[243]
      * SF_idx_11) - rtb_Init_p[252] * h_y) + rtb_Init_p[251] * SF_idx_16) -
      rtb_Init_p[250] * rtb_Init[0] / 2.0F) * SPP_idx_1) - ((((((rtb_Init_p[224]
      * SF_idx_8 + rtb_Init_p[225]) + rtb_Init_p[226] * SF_idx_7) + rtb_Init_p
      [227] * SF_idx_11) - rtb_Init_p[236] * h_y) + rtb_Init_p[235] * SF_idx_16)
      - rtb_Init_p[234] * rtb_Init[0] / 2.0F) * SPP_idx_9;

    /* '<S4>:1:166' */
    rty_nextP[113] = ((((((rtb_Init_p[64] * SF_idx_8 + rtb_Init_p[65]) +
                          rtb_Init_p[66] * SF_idx_7) + rtb_Init_p[67] *
                         SF_idx_11) - rtb_Init_p[76] * h_y) + rtb_Init_p[75] *
                       SF_idx_16) - rtb_Init_p[74] * rtb_Init[0] / 2.0F) *
      localDW->dt + ((((((rtb_Init_p[112] * SF_idx_8 + rtb_Init_p[113]) +
                         rtb_Init_p[114] * SF_idx_7) + rtb_Init_p[115] *
                        SF_idx_11) - rtb_Init_p[124] * h_y) + rtb_Init_p[123] *
                      SF_idx_16) - rtb_Init_p[122] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:167' */
    rty_nextP[129] = ((((((rtb_Init_p[80] * SF_idx_8 + rtb_Init_p[81]) +
                          rtb_Init_p[82] * SF_idx_7) + rtb_Init_p[83] *
                         SF_idx_11) - rtb_Init_p[92] * h_y) + rtb_Init_p[91] *
                       SF_idx_16) - rtb_Init_p[90] * rtb_Init[0] / 2.0F) *
      localDW->dt + ((((((rtb_Init_p[128] * SF_idx_8 + rtb_Init_p[129]) +
                         rtb_Init_p[130] * SF_idx_7) + rtb_Init_p[131] *
                        SF_idx_11) - rtb_Init_p[140] * h_y) + rtb_Init_p[139] *
                      SF_idx_16) - rtb_Init_p[138] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:168' */
    rty_nextP[145] = ((((((rtb_Init_p[96] * SF_idx_8 + rtb_Init_p[97]) +
                          rtb_Init_p[98] * SF_idx_7) + rtb_Init_p[99] *
                         SF_idx_11) - rtb_Init_p[108] * h_y) + rtb_Init_p[107] *
                       SF_idx_16) - rtb_Init_p[106] * rtb_Init[0] / 2.0F) *
      localDW->dt + ((((((rtb_Init_p[144] * SF_idx_8 + rtb_Init_p[145]) +
                         rtb_Init_p[146] * SF_idx_7) + rtb_Init_p[147] *
                        SF_idx_11) - rtb_Init_p[156] * h_y) + rtb_Init_p[155] *
                      SF_idx_16) - rtb_Init_p[154] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:169' */
    rty_nextP[161] = (((((rtb_Init_p[160] * SF_idx_8 + rtb_Init_p[161]) +
                         rtb_Init_p[162] * SF_idx_7) + rtb_Init_p[163] *
                        SF_idx_11) - rtb_Init_p[172] * h_y) + rtb_Init_p[171] *
                      SF_idx_16) - rtb_Init_p[170] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:170' */
    rty_nextP[177] = (((((rtb_Init_p[176] * SF_idx_8 + rtb_Init_p[177]) +
                         rtb_Init_p[178] * SF_idx_7) + rtb_Init_p[179] *
                        SF_idx_11) - rtb_Init_p[188] * h_y) + rtb_Init_p[187] *
                      SF_idx_16) - rtb_Init_p[186] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:171' */
    rty_nextP[193] = (((((rtb_Init_p[192] * SF_idx_8 + rtb_Init_p[193]) +
                         rtb_Init_p[194] * SF_idx_7) + rtb_Init_p[195] *
                        SF_idx_11) - rtb_Init_p[204] * h_y) + rtb_Init_p[203] *
                      SF_idx_16) - rtb_Init_p[202] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:172' */
    rty_nextP[209] = (((((rtb_Init_p[208] * SF_idx_8 + rtb_Init_p[209]) +
                         rtb_Init_p[210] * SF_idx_7) + rtb_Init_p[211] *
                        SF_idx_11) - rtb_Init_p[220] * h_y) + rtb_Init_p[219] *
                      SF_idx_16) - rtb_Init_p[218] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:173' */
    rty_nextP[225] = (((((rtb_Init_p[224] * SF_idx_8 + rtb_Init_p[225]) +
                         rtb_Init_p[226] * SF_idx_7) + rtb_Init_p[227] *
                        SF_idx_11) - rtb_Init_p[236] * h_y) + rtb_Init_p[235] *
                      SF_idx_16) - rtb_Init_p[234] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:174' */
    rty_nextP[241] = (((((rtb_Init_p[240] * SF_idx_8 + rtb_Init_p[241]) +
                         rtb_Init_p[242] * SF_idx_7) + rtb_Init_p[243] *
                        SF_idx_11) - rtb_Init_p[252] * h_y) + rtb_Init_p[251] *
                      SF_idx_16) - rtb_Init_p[250] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:175' */
    rty_nextP[2] = (((((((((((rtb_Init_p[16] * SF_idx_6 + rtb_Init_p[18]) +
      rtb_Init_p[17] * SF_idx_10) + rtb_Init_p[19] * SF_idx_8) + rtb_Init_p[28] *
      g_y) - rtb_Init_p[26] * SF_idx_16) - rtb_Init_p[27] * rtb_Init[0] / 2.0F) *
                        SF_idx_9 + (((((((rtb_Init_p[2] + SQ_idx_7) +
      rtb_Init_p[0] * SF_idx_6) + rtb_Init_p[1] * SF_idx_10) + rtb_Init_p[3] *
      SF_idx_8) + rtb_Init_p[12] * g_y) - rtb_Init_p[10] * SF_idx_16) -
      rtb_Init_p[11] * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[32] * SF_idx_6 +
      rtb_Init_p[34]) + rtb_Init_p[33] * SF_idx_10) + rtb_Init_p[35] * SF_idx_8)
      + rtb_Init_p[44] * g_y) - rtb_Init_p[42] * SF_idx_16) - rtb_Init_p[43] *
      rtb_Init[0] / 2.0F) * SF_idx_11) + ((((((rtb_Init_p[48] * SF_idx_6 +
      rtb_Init_p[50]) + rtb_Init_p[49] * SF_idx_10) + rtb_Init_p[51] * SF_idx_8)
      + rtb_Init_p[60] * g_y) - rtb_Init_p[58] * SF_idx_16) - rtb_Init_p[59] *
      rtb_Init[0] / 2.0F) * SF_idx_10) + ((((((rtb_Init_p[160] * SF_idx_6 +
      rtb_Init_p[162]) + rtb_Init_p[161] * SF_idx_10) + rtb_Init_p[163] *
      SF_idx_8) + rtb_Init_p[172] * g_y) - rtb_Init_p[170] * SF_idx_16) -
      rtb_Init_p[171] * rtb_Init[0] / 2.0F) * g_y) + ((((((rtb_Init_p[176] *
      SF_idx_6 + rtb_Init_p[178]) + rtb_Init_p[177] * SF_idx_10) + rtb_Init_p
      [179] * SF_idx_8) + rtb_Init_p[188] * g_y) - rtb_Init_p[186] * SF_idx_16)
      - rtb_Init_p[187] * rtb_Init[0] / 2.0F) * h_y) + ((((((rtb_Init_p[192] *
      SF_idx_6 + rtb_Init_p[194]) + rtb_Init_p[193] * SF_idx_10) + rtb_Init_p
      [195] * SF_idx_8) + rtb_Init_p[204] * g_y) - rtb_Init_p[202] * SF_idx_16)
      - rtb_Init_p[203] * rtb_Init[0] / 2.0F) * SF_idx_16;

    /* '<S4>:1:176' */
    rty_nextP[18] = (((((((((((rtb_Init_p[0] * SF_idx_6 + rtb_Init_p[2]) +
      rtb_Init_p[1] * SF_idx_10) + rtb_Init_p[3] * SF_idx_8) + rtb_Init_p[12] *
      g_y) - rtb_Init_p[10] * SF_idx_16) - rtb_Init_p[11] * rtb_Init[0] / 2.0F) *
                         SF_idx_8 + (((((((rtb_Init_p[18] + SQ_idx_5) +
      rtb_Init_p[16] * SF_idx_6) + rtb_Init_p[17] * SF_idx_10) + rtb_Init_p[19] *
      SF_idx_8) + rtb_Init_p[28] * g_y) - rtb_Init_p[26] * SF_idx_16) -
      rtb_Init_p[27] * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[32] * SF_idx_6 +
      rtb_Init_p[34]) + rtb_Init_p[33] * SF_idx_10) + rtb_Init_p[35] * SF_idx_8)
      + rtb_Init_p[44] * g_y) - rtb_Init_p[42] * SF_idx_16) - rtb_Init_p[43] *
      rtb_Init[0] / 2.0F) * SF_idx_7) + ((((((rtb_Init_p[48] * SF_idx_6 +
      rtb_Init_p[50]) + rtb_Init_p[49] * SF_idx_10) + rtb_Init_p[51] * SF_idx_8)
      + rtb_Init_p[60] * g_y) - rtb_Init_p[58] * SF_idx_16) - rtb_Init_p[59] *
      rtb_Init[0] / 2.0F) * SF_idx_11) - ((((((rtb_Init_p[192] * SF_idx_6 +
      rtb_Init_p[194]) + rtb_Init_p[193] * SF_idx_10) + rtb_Init_p[195] *
      SF_idx_8) + rtb_Init_p[204] * g_y) - rtb_Init_p[202] * SF_idx_16) -
      rtb_Init_p[203] * rtb_Init[0] / 2.0F) * h_y) + ((((((rtb_Init_p[176] *
      SF_idx_6 + rtb_Init_p[178]) + rtb_Init_p[177] * SF_idx_10) + rtb_Init_p
      [179] * SF_idx_8) + rtb_Init_p[188] * g_y) - rtb_Init_p[186] * SF_idx_16)
      - rtb_Init_p[187] * rtb_Init[0] / 2.0F) * SF_idx_16) - ((((((rtb_Init_p
      [160] * SF_idx_6 + rtb_Init_p[162]) + rtb_Init_p[161] * SF_idx_10) +
      rtb_Init_p[163] * SF_idx_8) + rtb_Init_p[172] * g_y) - rtb_Init_p[170] *
      SF_idx_16) - rtb_Init_p[171] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:177' */
    rty_nextP[34] = ((((((((((((((rtb_Init_p[32] * SF_idx_6 + rtb_Init_p[34]) +
      rtb_Init_p[33] * SF_idx_10) + rtb_Init_p[35] * SF_idx_8) + rtb_Init_p[44] *
      g_y) - rtb_Init_p[42] * SF_idx_16) + deltaQuat_idx_2 * i_y) +
      qUpdated_idx_2 * SG_idx_0 / 4.0F) - rtb_Init_p[43] * rtb_Init[0] / 2.0F) +
                          ((((((rtb_Init_p[0] * SF_idx_6 + rtb_Init_p[2]) +
      rtb_Init_p[1] * SF_idx_10) + rtb_Init_p[3] * SF_idx_8) + rtb_Init_p[12] *
      g_y) - rtb_Init_p[10] * SF_idx_16) - rtb_Init_p[11] * rtb_Init[0] / 2.0F) *
                          SF_idx_6) + ((((((rtb_Init_p[16] * SF_idx_6 +
      rtb_Init_p[18]) + rtb_Init_p[17] * SF_idx_10) + rtb_Init_p[19] * SF_idx_8)
      + rtb_Init_p[28] * g_y) - rtb_Init_p[26] * SF_idx_16) - rtb_Init_p[27] *
      rtb_Init[0] / 2.0F) * SF_idx_10) + ((((((rtb_Init_p[48] * SF_idx_6 +
      rtb_Init_p[50]) + rtb_Init_p[49] * SF_idx_10) + rtb_Init_p[51] * SF_idx_8)
      + rtb_Init_p[60] * g_y) - rtb_Init_p[58] * SF_idx_16) - rtb_Init_p[59] *
      rtb_Init[0] / 2.0F) * SF_idx_8) + ((((((rtb_Init_p[192] * SF_idx_6 +
      rtb_Init_p[194]) + rtb_Init_p[193] * SF_idx_10) + rtb_Init_p[195] *
      SF_idx_8) + rtb_Init_p[204] * g_y) - rtb_Init_p[202] * SF_idx_16) -
      rtb_Init_p[203] * rtb_Init[0] / 2.0F) * g_y) - ((((((rtb_Init_p[160] *
      SF_idx_6 + rtb_Init_p[162]) + rtb_Init_p[161] * SF_idx_10) + rtb_Init_p
      [163] * SF_idx_8) + rtb_Init_p[172] * g_y) - rtb_Init_p[170] * SF_idx_16)
      - rtb_Init_p[171] * rtb_Init[0] / 2.0F) * SF_idx_16) + rtb_Init[3] *
                     rtb_Init[3] * deltaQuat_idx_1 / 4.0F) - ((((((rtb_Init_p
      [176] * SF_idx_6 + rtb_Init_p[178]) + rtb_Init_p[177] * SF_idx_10) +
      rtb_Init_p[179] * SF_idx_8) + rtb_Init_p[188] * g_y) - rtb_Init_p[186] *
      SF_idx_16) - rtb_Init_p[187] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:178' */
    rty_nextP[50] = (((((((((((rtb_Init_p[0] * SF_idx_6 + rtb_Init_p[2]) +
      rtb_Init_p[1] * SF_idx_10) + rtb_Init_p[3] * SF_idx_8) + rtb_Init_p[12] *
      g_y) - rtb_Init_p[10] * SF_idx_16) - rtb_Init_p[11] * rtb_Init[0] / 2.0F) *
                         SF_idx_7 + (((((((rtb_Init_p[50] + SQ_idx_3) +
      rtb_Init_p[48] * SF_idx_6) + rtb_Init_p[49] * SF_idx_10) + rtb_Init_p[51] *
      SF_idx_8) + rtb_Init_p[60] * g_y) - rtb_Init_p[58] * SF_idx_16) -
      rtb_Init_p[59] * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[16] * SF_idx_6 +
      rtb_Init_p[18]) + rtb_Init_p[17] * SF_idx_10) + rtb_Init_p[19] * SF_idx_8)
      + rtb_Init_p[28] * g_y) - rtb_Init_p[26] * SF_idx_16) - rtb_Init_p[27] *
      rtb_Init[0] / 2.0F) * SF_idx_6) + ((((((rtb_Init_p[32] * SF_idx_6 +
      rtb_Init_p[34]) + rtb_Init_p[33] * SF_idx_10) + rtb_Init_p[35] * SF_idx_8)
      + rtb_Init_p[44] * g_y) - rtb_Init_p[42] * SF_idx_16) - rtb_Init_p[43] *
      rtb_Init[0] / 2.0F) * SF_idx_9) + ((((((rtb_Init_p[160] * SF_idx_6 +
      rtb_Init_p[162]) + rtb_Init_p[161] * SF_idx_10) + rtb_Init_p[163] *
      SF_idx_8) + rtb_Init_p[172] * g_y) - rtb_Init_p[170] * SF_idx_16) -
      rtb_Init_p[171] * rtb_Init[0] / 2.0F) * h_y) - ((((((rtb_Init_p[176] *
      SF_idx_6 + rtb_Init_p[178]) + rtb_Init_p[177] * SF_idx_10) + rtb_Init_p
      [179] * SF_idx_8) + rtb_Init_p[188] * g_y) - rtb_Init_p[186] * SF_idx_16)
      - rtb_Init_p[187] * rtb_Init[0] / 2.0F) * g_y) - ((((((rtb_Init_p[192] *
      SF_idx_6 + rtb_Init_p[194]) + rtb_Init_p[193] * SF_idx_10) + rtb_Init_p
      [195] * SF_idx_8) + rtb_Init_p[204] * g_y) - rtb_Init_p[202] * SF_idx_16)
      - rtb_Init_p[203] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:179' */
    rty_nextP[66] = ((((((((((((rtb_Init_p[0] * SF_idx_6 + rtb_Init_p[2]) +
      rtb_Init_p[1] * SF_idx_10) + rtb_Init_p[3] * SF_idx_8) + rtb_Init_p[12] *
      g_y) - rtb_Init_p[10] * SF_idx_16) - rtb_Init_p[11] * rtb_Init[0] / 2.0F) *
                          SF_idx_5 + ((((((rtb_Init_p[64] * SF_idx_6 +
      rtb_Init_p[66]) + rtb_Init_p[65] * SF_idx_10) + rtb_Init_p[67] * SF_idx_8)
      + rtb_Init_p[76] * g_y) - rtb_Init_p[74] * SF_idx_16) - rtb_Init_p[75] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[16] * SF_idx_6 + rtb_Init_p[18]) +
      rtb_Init_p[17] * SF_idx_10) + rtb_Init_p[19] * SF_idx_8) + rtb_Init_p[28] *
      g_y) - rtb_Init_p[26] * SF_idx_16) - rtb_Init_p[27] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[32] * SF_idx_6 +
      rtb_Init_p[34]) + rtb_Init_p[33] * SF_idx_10) + rtb_Init_p[35] * SF_idx_8)
      + rtb_Init_p[44] * g_y) - rtb_Init_p[42] * SF_idx_16) - rtb_Init_p[43] *
      rtb_Init[0] / 2.0F) * SPP_idx_0) - ((((((rtb_Init_p[48] * SF_idx_6 +
      rtb_Init_p[50]) + rtb_Init_p[49] * SF_idx_10) + rtb_Init_p[51] * SF_idx_8)
      + rtb_Init_p[60] * g_y) - rtb_Init_p[58] * SF_idx_16) - rtb_Init_p[59] *
      rtb_Init[0] / 2.0F) * SF_idx_0) + ((((((rtb_Init_p[208] * SF_idx_6 +
      rtb_Init_p[210]) + rtb_Init_p[209] * SF_idx_10) + rtb_Init_p[211] *
      SF_idx_8) + rtb_Init_p[220] * g_y) - rtb_Init_p[218] * SF_idx_16) -
      rtb_Init_p[219] * rtb_Init[0] / 2.0F) * SPP_idx_3) + ((((((rtb_Init_p[224]
      * SF_idx_6 + rtb_Init_p[226]) + rtb_Init_p[225] * SF_idx_10) + rtb_Init_p
      [227] * SF_idx_8) + rtb_Init_p[236] * g_y) - rtb_Init_p[234] * SF_idx_16)
      - rtb_Init_p[235] * rtb_Init[0] / 2.0F) * SPP_idx_8) - ((((((rtb_Init_p
      [240] * SF_idx_6 + rtb_Init_p[242]) + rtb_Init_p[241] * SF_idx_10) +
      rtb_Init_p[243] * SF_idx_8) + rtb_Init_p[252] * g_y) - rtb_Init_p[250] *
      SF_idx_16) - rtb_Init_p[251] * rtb_Init[0] / 2.0F) * SPP_idx_11;

    /* '<S4>:1:180' */
    rty_nextP[82] = ((((((((((((rtb_Init_p[0] * SF_idx_6 + rtb_Init_p[2]) +
      rtb_Init_p[1] * SF_idx_10) + rtb_Init_p[3] * SF_idx_8) + rtb_Init_p[12] *
      g_y) - rtb_Init_p[10] * SF_idx_16) - rtb_Init_p[11] * rtb_Init[0] / 2.0F) *
                          SF_idx_4 + ((((((rtb_Init_p[80] * SF_idx_6 +
      rtb_Init_p[82]) + rtb_Init_p[81] * SF_idx_10) + rtb_Init_p[83] * SF_idx_8)
      + rtb_Init_p[92] * g_y) - rtb_Init_p[90] * SF_idx_16) - rtb_Init_p[91] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[32] * SF_idx_6 + rtb_Init_p[34]) +
      rtb_Init_p[33] * SF_idx_10) + rtb_Init_p[35] * SF_idx_8) + rtb_Init_p[44] *
      g_y) - rtb_Init_p[42] * SF_idx_16) - rtb_Init_p[43] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[48] * SF_idx_6 +
      rtb_Init_p[50]) + rtb_Init_p[49] * SF_idx_10) + rtb_Init_p[51] * SF_idx_8)
      + rtb_Init_p[60] * g_y) - rtb_Init_p[58] * SF_idx_16) - rtb_Init_p[59] *
      rtb_Init[0] / 2.0F) * SF_idx_5) - ((((((rtb_Init_p[16] * SF_idx_6 +
      rtb_Init_p[18]) + rtb_Init_p[17] * SF_idx_10) + rtb_Init_p[19] * SF_idx_8)
      + rtb_Init_p[28] * g_y) - rtb_Init_p[26] * SF_idx_16) - rtb_Init_p[27] *
      rtb_Init[0] / 2.0F) * SPP_idx_0) + ((((((rtb_Init_p[224] * SF_idx_6 +
      rtb_Init_p[226]) + rtb_Init_p[225] * SF_idx_10) + rtb_Init_p[227] *
      SF_idx_8) + rtb_Init_p[236] * g_y) - rtb_Init_p[234] * SF_idx_16) -
      rtb_Init_p[235] * rtb_Init[0] / 2.0F) * SPP_idx_2) - ((((((rtb_Init_p[208]
      * SF_idx_6 + rtb_Init_p[210]) + rtb_Init_p[209] * SF_idx_10) + rtb_Init_p
      [211] * SF_idx_8) + rtb_Init_p[220] * g_y) - rtb_Init_p[218] * SF_idx_16)
      - rtb_Init_p[219] * rtb_Init[0] / 2.0F) * SPP_idx_10) + ((((((rtb_Init_p
      [240] * SF_idx_6 + rtb_Init_p[242]) + rtb_Init_p[241] * SF_idx_10) +
      rtb_Init_p[243] * SF_idx_8) + rtb_Init_p[252] * g_y) - rtb_Init_p[250] *
      SF_idx_16) - rtb_Init_p[251] * rtb_Init[0] / 2.0F) * SF_idx_2;

    /* '<S4>:1:181' */
    rty_nextP[98] = ((((((((((((rtb_Init_p[16] * SF_idx_6 + rtb_Init_p[18]) +
      rtb_Init_p[17] * SF_idx_10) + rtb_Init_p[19] * SF_idx_8) + rtb_Init_p[28] *
      g_y) - rtb_Init_p[26] * SF_idx_16) - rtb_Init_p[27] * rtb_Init[0] / 2.0F) *
                          SF_idx_4 + ((((((rtb_Init_p[96] * SF_idx_6 +
      rtb_Init_p[98]) + rtb_Init_p[97] * SF_idx_10) + rtb_Init_p[99] * SF_idx_8)
      + rtb_Init_p[108] * g_y) - rtb_Init_p[106] * SF_idx_16) - rtb_Init_p[107] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[48] * SF_idx_6 + rtb_Init_p[50]) +
      rtb_Init_p[49] * SF_idx_10) + rtb_Init_p[51] * SF_idx_8) + rtb_Init_p[60] *
      g_y) - rtb_Init_p[58] * SF_idx_16) - rtb_Init_p[59] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[0] * SF_idx_6 +
      rtb_Init_p[2]) + rtb_Init_p[1] * SF_idx_10) + rtb_Init_p[3] * SF_idx_8) +
      rtb_Init_p[12] * g_y) - rtb_Init_p[10] * SF_idx_16) - rtb_Init_p[11] *
      rtb_Init[0] / 2.0F) * SPP_idx_0) - ((((((rtb_Init_p[32] * SF_idx_6 +
      rtb_Init_p[34]) + rtb_Init_p[33] * SF_idx_10) + rtb_Init_p[35] * SF_idx_8)
      + rtb_Init_p[44] * g_y) - rtb_Init_p[42] * SF_idx_16) - rtb_Init_p[43] *
      rtb_Init[0] / 2.0F) * SPP_idx_4) + ((((((rtb_Init_p[208] * SF_idx_6 +
      rtb_Init_p[210]) + rtb_Init_p[209] * SF_idx_10) + rtb_Init_p[211] *
      SF_idx_8) + rtb_Init_p[220] * g_y) - rtb_Init_p[218] * SF_idx_16) -
      rtb_Init_p[219] * rtb_Init[0] / 2.0F) * SF_idx_1) - ((((((rtb_Init_p[240] *
      SF_idx_6 + rtb_Init_p[242]) + rtb_Init_p[241] * SF_idx_10) + rtb_Init_p
      [243] * SF_idx_8) + rtb_Init_p[252] * g_y) - rtb_Init_p[250] * SF_idx_16)
      - rtb_Init_p[251] * rtb_Init[0] / 2.0F) * SPP_idx_1) - ((((((rtb_Init_p
      [224] * SF_idx_6 + rtb_Init_p[226]) + rtb_Init_p[225] * SF_idx_10) +
      rtb_Init_p[227] * SF_idx_8) + rtb_Init_p[236] * g_y) - rtb_Init_p[234] *
      SF_idx_16) - rtb_Init_p[235] * rtb_Init[0] / 2.0F) * SPP_idx_9;

    /* '<S4>:1:182' */
    rty_nextP[114] = ((((((rtb_Init_p[64] * SF_idx_6 + rtb_Init_p[66]) +
                          rtb_Init_p[65] * SF_idx_10) + rtb_Init_p[67] *
                         SF_idx_8) + rtb_Init_p[76] * g_y) - rtb_Init_p[74] *
                       SF_idx_16) - rtb_Init_p[75] * rtb_Init[0] / 2.0F) *
      localDW->dt + ((((((rtb_Init_p[112] * SF_idx_6 + rtb_Init_p[114]) +
                         rtb_Init_p[113] * SF_idx_10) + rtb_Init_p[115] *
                        SF_idx_8) + rtb_Init_p[124] * g_y) - rtb_Init_p[122] *
                      SF_idx_16) - rtb_Init_p[123] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:183' */
    rty_nextP[130] = ((((((rtb_Init_p[80] * SF_idx_6 + rtb_Init_p[82]) +
                          rtb_Init_p[81] * SF_idx_10) + rtb_Init_p[83] *
                         SF_idx_8) + rtb_Init_p[92] * g_y) - rtb_Init_p[90] *
                       SF_idx_16) - rtb_Init_p[91] * rtb_Init[0] / 2.0F) *
      localDW->dt + ((((((rtb_Init_p[128] * SF_idx_6 + rtb_Init_p[130]) +
                         rtb_Init_p[129] * SF_idx_10) + rtb_Init_p[131] *
                        SF_idx_8) + rtb_Init_p[140] * g_y) - rtb_Init_p[138] *
                      SF_idx_16) - rtb_Init_p[139] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:184' */
    rty_nextP[146] = ((((((rtb_Init_p[96] * SF_idx_6 + rtb_Init_p[98]) +
                          rtb_Init_p[97] * SF_idx_10) + rtb_Init_p[99] *
                         SF_idx_8) + rtb_Init_p[108] * g_y) - rtb_Init_p[106] *
                       SF_idx_16) - rtb_Init_p[107] * rtb_Init[0] / 2.0F) *
      localDW->dt + ((((((rtb_Init_p[144] * SF_idx_6 + rtb_Init_p[146]) +
                         rtb_Init_p[145] * SF_idx_10) + rtb_Init_p[147] *
                        SF_idx_8) + rtb_Init_p[156] * g_y) - rtb_Init_p[154] *
                      SF_idx_16) - rtb_Init_p[155] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:185' */
    rty_nextP[162] = (((((rtb_Init_p[160] * SF_idx_6 + rtb_Init_p[162]) +
                         rtb_Init_p[161] * SF_idx_10) + rtb_Init_p[163] *
                        SF_idx_8) + rtb_Init_p[172] * g_y) - rtb_Init_p[170] *
                      SF_idx_16) - rtb_Init_p[171] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:186' */
    rty_nextP[178] = (((((rtb_Init_p[176] * SF_idx_6 + rtb_Init_p[178]) +
                         rtb_Init_p[177] * SF_idx_10) + rtb_Init_p[179] *
                        SF_idx_8) + rtb_Init_p[188] * g_y) - rtb_Init_p[186] *
                      SF_idx_16) - rtb_Init_p[187] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:187' */
    rty_nextP[194] = (((((rtb_Init_p[192] * SF_idx_6 + rtb_Init_p[194]) +
                         rtb_Init_p[193] * SF_idx_10) + rtb_Init_p[195] *
                        SF_idx_8) + rtb_Init_p[204] * g_y) - rtb_Init_p[202] *
                      SF_idx_16) - rtb_Init_p[203] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:188' */
    rty_nextP[210] = (((((rtb_Init_p[208] * SF_idx_6 + rtb_Init_p[210]) +
                         rtb_Init_p[209] * SF_idx_10) + rtb_Init_p[211] *
                        SF_idx_8) + rtb_Init_p[220] * g_y) - rtb_Init_p[218] *
                      SF_idx_16) - rtb_Init_p[219] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:189' */
    rty_nextP[226] = (((((rtb_Init_p[224] * SF_idx_6 + rtb_Init_p[226]) +
                         rtb_Init_p[225] * SF_idx_10) + rtb_Init_p[227] *
                        SF_idx_8) + rtb_Init_p[236] * g_y) - rtb_Init_p[234] *
                      SF_idx_16) - rtb_Init_p[235] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:190' */
    rty_nextP[242] = (((((rtb_Init_p[240] * SF_idx_6 + rtb_Init_p[242]) +
                         rtb_Init_p[241] * SF_idx_10) + rtb_Init_p[243] *
                        SF_idx_8) + rtb_Init_p[252] * g_y) - rtb_Init_p[250] *
                      SF_idx_16) - rtb_Init_p[251] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:191' */
    rty_nextP[3] = (((((((((((rtb_Init_p[16] * SF_idx_7 + rtb_Init_p[19]) +
      rtb_Init_p[17] * SF_idx_6) + rtb_Init_p[18] * SF_idx_9) + rtb_Init_p[26] *
      h_y) - rtb_Init_p[27] * g_y) - rtb_Init_p[28] * rtb_Init[0] / 2.0F) *
                        SF_idx_9 + (((((((rtb_Init_p[3] + SQ_idx_6) +
      rtb_Init_p[0] * SF_idx_7) + rtb_Init_p[1] * SF_idx_6) + rtb_Init_p[2] *
      SF_idx_9) + rtb_Init_p[10] * h_y) - rtb_Init_p[11] * g_y) - rtb_Init_p[12]
      * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[32] * SF_idx_7 + rtb_Init_p[35])
      + rtb_Init_p[33] * SF_idx_6) + rtb_Init_p[34] * SF_idx_9) + rtb_Init_p[42]
      * h_y) - rtb_Init_p[43] * g_y) - rtb_Init_p[44] * rtb_Init[0] / 2.0F) *
                       SF_idx_11) + ((((((rtb_Init_p[48] * SF_idx_7 +
      rtb_Init_p[51]) + rtb_Init_p[49] * SF_idx_6) + rtb_Init_p[50] * SF_idx_9)
      + rtb_Init_p[58] * h_y) - rtb_Init_p[59] * g_y) - rtb_Init_p[60] *
      rtb_Init[0] / 2.0F) * SF_idx_10) + ((((((rtb_Init_p[160] * SF_idx_7 +
      rtb_Init_p[163]) + rtb_Init_p[161] * SF_idx_6) + rtb_Init_p[162] *
      SF_idx_9) + rtb_Init_p[170] * h_y) - rtb_Init_p[171] * g_y) - rtb_Init_p
      [172] * rtb_Init[0] / 2.0F) * g_y) + ((((((rtb_Init_p[176] * SF_idx_7 +
      rtb_Init_p[179]) + rtb_Init_p[177] * SF_idx_6) + rtb_Init_p[178] *
      SF_idx_9) + rtb_Init_p[186] * h_y) - rtb_Init_p[187] * g_y) - rtb_Init_p
      [188] * rtb_Init[0] / 2.0F) * h_y) + ((((((rtb_Init_p[192] * SF_idx_7 +
      rtb_Init_p[195]) + rtb_Init_p[193] * SF_idx_6) + rtb_Init_p[194] *
      SF_idx_9) + rtb_Init_p[202] * h_y) - rtb_Init_p[203] * g_y) - rtb_Init_p
      [204] * rtb_Init[0] / 2.0F) * SF_idx_16;

    /* '<S4>:1:192' */
    rty_nextP[19] = (((((((((((rtb_Init_p[0] * SF_idx_7 + rtb_Init_p[3]) +
      rtb_Init_p[1] * SF_idx_6) + rtb_Init_p[2] * SF_idx_9) + rtb_Init_p[10] *
      h_y) - rtb_Init_p[11] * g_y) - rtb_Init_p[12] * rtb_Init[0] / 2.0F) *
                         SF_idx_8 + (((((((rtb_Init_p[19] + SQ_idx_4) +
      rtb_Init_p[16] * SF_idx_7) + rtb_Init_p[17] * SF_idx_6) + rtb_Init_p[18] *
      SF_idx_9) + rtb_Init_p[26] * h_y) - rtb_Init_p[27] * g_y) - rtb_Init_p[28]
      * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[32] * SF_idx_7 + rtb_Init_p[35])
      + rtb_Init_p[33] * SF_idx_6) + rtb_Init_p[34] * SF_idx_9) + rtb_Init_p[42]
      * h_y) - rtb_Init_p[43] * g_y) - rtb_Init_p[44] * rtb_Init[0] / 2.0F) *
                        SF_idx_7) + ((((((rtb_Init_p[48] * SF_idx_7 +
      rtb_Init_p[51]) + rtb_Init_p[49] * SF_idx_6) + rtb_Init_p[50] * SF_idx_9)
      + rtb_Init_p[58] * h_y) - rtb_Init_p[59] * g_y) - rtb_Init_p[60] *
      rtb_Init[0] / 2.0F) * SF_idx_11) - ((((((rtb_Init_p[192] * SF_idx_7 +
      rtb_Init_p[195]) + rtb_Init_p[193] * SF_idx_6) + rtb_Init_p[194] *
      SF_idx_9) + rtb_Init_p[202] * h_y) - rtb_Init_p[203] * g_y) - rtb_Init_p
      [204] * rtb_Init[0] / 2.0F) * h_y) + ((((((rtb_Init_p[176] * SF_idx_7 +
      rtb_Init_p[179]) + rtb_Init_p[177] * SF_idx_6) + rtb_Init_p[178] *
      SF_idx_9) + rtb_Init_p[186] * h_y) - rtb_Init_p[187] * g_y) - rtb_Init_p
      [188] * rtb_Init[0] / 2.0F) * SF_idx_16) - ((((((rtb_Init_p[160] *
      SF_idx_7 + rtb_Init_p[163]) + rtb_Init_p[161] * SF_idx_6) + rtb_Init_p[162]
      * SF_idx_9) + rtb_Init_p[170] * h_y) - rtb_Init_p[171] * g_y) -
      rtb_Init_p[172] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:193' */
    rty_nextP[35] = (((((((((((rtb_Init_p[0] * SF_idx_7 + rtb_Init_p[3]) +
      rtb_Init_p[1] * SF_idx_6) + rtb_Init_p[2] * SF_idx_9) + rtb_Init_p[10] *
      h_y) - rtb_Init_p[11] * g_y) - rtb_Init_p[12] * rtb_Init[0] / 2.0F) *
                         SF_idx_6 + (((((((rtb_Init_p[35] + SQ_idx_3) +
      rtb_Init_p[32] * SF_idx_7) + rtb_Init_p[33] * SF_idx_6) + rtb_Init_p[34] *
      SF_idx_9) + rtb_Init_p[42] * h_y) - rtb_Init_p[43] * g_y) - rtb_Init_p[44]
      * rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[16] * SF_idx_7 + rtb_Init_p[19])
      + rtb_Init_p[17] * SF_idx_6) + rtb_Init_p[18] * SF_idx_9) + rtb_Init_p[26]
      * h_y) - rtb_Init_p[27] * g_y) - rtb_Init_p[28] * rtb_Init[0] / 2.0F) *
                        SF_idx_10) + ((((((rtb_Init_p[48] * SF_idx_7 +
      rtb_Init_p[51]) + rtb_Init_p[49] * SF_idx_6) + rtb_Init_p[50] * SF_idx_9)
      + rtb_Init_p[58] * h_y) - rtb_Init_p[59] * g_y) - rtb_Init_p[60] *
      rtb_Init[0] / 2.0F) * SF_idx_8) + ((((((rtb_Init_p[192] * SF_idx_7 +
      rtb_Init_p[195]) + rtb_Init_p[193] * SF_idx_6) + rtb_Init_p[194] *
      SF_idx_9) + rtb_Init_p[202] * h_y) - rtb_Init_p[203] * g_y) - rtb_Init_p
      [204] * rtb_Init[0] / 2.0F) * g_y) - ((((((rtb_Init_p[160] * SF_idx_7 +
      rtb_Init_p[163]) + rtb_Init_p[161] * SF_idx_6) + rtb_Init_p[162] *
      SF_idx_9) + rtb_Init_p[170] * h_y) - rtb_Init_p[171] * g_y) - rtb_Init_p
      [172] * rtb_Init[0] / 2.0F) * SF_idx_16) - ((((((rtb_Init_p[176] *
      SF_idx_7 + rtb_Init_p[179]) + rtb_Init_p[177] * SF_idx_6) + rtb_Init_p[178]
      * SF_idx_9) + rtb_Init_p[186] * h_y) - rtb_Init_p[187] * g_y) -
      rtb_Init_p[188] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:194' */
    rty_nextP[51] = ((((((((((((((rtb_Init_p[48] * SF_idx_7 + rtb_Init_p[51]) +
      rtb_Init_p[49] * SF_idx_6) + rtb_Init_p[50] * SF_idx_9) + rtb_Init_p[58] *
      h_y) - rtb_Init_p[59] * g_y) + deltaQuat_idx_2 * SG_idx_0 / 4.0F) +
      qUpdated_idx_2 * i_y) - rtb_Init_p[60] * rtb_Init[0] / 2.0F) +
                          ((((((rtb_Init_p[0] * SF_idx_7 + rtb_Init_p[3]) +
      rtb_Init_p[1] * SF_idx_6) + rtb_Init_p[2] * SF_idx_9) + rtb_Init_p[10] *
      h_y) - rtb_Init_p[11] * g_y) - rtb_Init_p[12] * rtb_Init[0] / 2.0F) *
                          SF_idx_7) + ((((((rtb_Init_p[16] * SF_idx_7 +
      rtb_Init_p[19]) + rtb_Init_p[17] * SF_idx_6) + rtb_Init_p[18] * SF_idx_9)
      + rtb_Init_p[26] * h_y) - rtb_Init_p[27] * g_y) - rtb_Init_p[28] *
      rtb_Init[0] / 2.0F) * SF_idx_6) + ((((((rtb_Init_p[32] * SF_idx_7 +
      rtb_Init_p[35]) + rtb_Init_p[33] * SF_idx_6) + rtb_Init_p[34] * SF_idx_9)
      + rtb_Init_p[42] * h_y) - rtb_Init_p[43] * g_y) - rtb_Init_p[44] *
      rtb_Init[0] / 2.0F) * SF_idx_9) + ((((((rtb_Init_p[160] * SF_idx_7 +
      rtb_Init_p[163]) + rtb_Init_p[161] * SF_idx_6) + rtb_Init_p[162] *
      SF_idx_9) + rtb_Init_p[170] * h_y) - rtb_Init_p[171] * g_y) - rtb_Init_p
      [172] * rtb_Init[0] / 2.0F) * h_y) - ((((((rtb_Init_p[176] * SF_idx_7 +
      rtb_Init_p[179]) + rtb_Init_p[177] * SF_idx_6) + rtb_Init_p[178] *
      SF_idx_9) + rtb_Init_p[186] * h_y) - rtb_Init_p[187] * g_y) - rtb_Init_p
      [188] * rtb_Init[0] / 2.0F) * g_y) + rtb_Init[2] * rtb_Init[2] *
                     deltaQuat_idx_1 / 4.0F) - ((((((rtb_Init_p[192] * SF_idx_7
      + rtb_Init_p[195]) + rtb_Init_p[193] * SF_idx_6) + rtb_Init_p[194] *
      SF_idx_9) + rtb_Init_p[202] * h_y) - rtb_Init_p[203] * g_y) - rtb_Init_p
      [204] * rtb_Init[0] / 2.0F) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:195' */
    rty_nextP[67] = ((((((((((((rtb_Init_p[0] * SF_idx_7 + rtb_Init_p[3]) +
      rtb_Init_p[1] * SF_idx_6) + rtb_Init_p[2] * SF_idx_9) + rtb_Init_p[10] *
      h_y) - rtb_Init_p[11] * g_y) - rtb_Init_p[12] * rtb_Init[0] / 2.0F) *
                          SF_idx_5 + ((((((rtb_Init_p[64] * SF_idx_7 +
      rtb_Init_p[67]) + rtb_Init_p[65] * SF_idx_6) + rtb_Init_p[66] * SF_idx_9)
      + rtb_Init_p[74] * h_y) - rtb_Init_p[75] * g_y) - rtb_Init_p[76] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[16] * SF_idx_7 + rtb_Init_p[19]) +
      rtb_Init_p[17] * SF_idx_6) + rtb_Init_p[18] * SF_idx_9) + rtb_Init_p[26] *
      h_y) - rtb_Init_p[27] * g_y) - rtb_Init_p[28] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[32] * SF_idx_7 +
      rtb_Init_p[35]) + rtb_Init_p[33] * SF_idx_6) + rtb_Init_p[34] * SF_idx_9)
      + rtb_Init_p[42] * h_y) - rtb_Init_p[43] * g_y) - rtb_Init_p[44] *
      rtb_Init[0] / 2.0F) * SPP_idx_0) - ((((((rtb_Init_p[48] * SF_idx_7 +
      rtb_Init_p[51]) + rtb_Init_p[49] * SF_idx_6) + rtb_Init_p[50] * SF_idx_9)
      + rtb_Init_p[58] * h_y) - rtb_Init_p[59] * g_y) - rtb_Init_p[60] *
      rtb_Init[0] / 2.0F) * SF_idx_0) + ((((((rtb_Init_p[208] * SF_idx_7 +
      rtb_Init_p[211]) + rtb_Init_p[209] * SF_idx_6) + rtb_Init_p[210] *
      SF_idx_9) + rtb_Init_p[218] * h_y) - rtb_Init_p[219] * g_y) - rtb_Init_p
      [220] * rtb_Init[0] / 2.0F) * SPP_idx_3) + ((((((rtb_Init_p[224] *
      SF_idx_7 + rtb_Init_p[227]) + rtb_Init_p[225] * SF_idx_6) + rtb_Init_p[226]
      * SF_idx_9) + rtb_Init_p[234] * h_y) - rtb_Init_p[235] * g_y) -
      rtb_Init_p[236] * rtb_Init[0] / 2.0F) * SPP_idx_8) - ((((((rtb_Init_p[240]
      * SF_idx_7 + rtb_Init_p[243]) + rtb_Init_p[241] * SF_idx_6) + rtb_Init_p
      [242] * SF_idx_9) + rtb_Init_p[250] * h_y) - rtb_Init_p[251] * g_y) -
      rtb_Init_p[252] * rtb_Init[0] / 2.0F) * SPP_idx_11;

    /* '<S4>:1:196' */
    rty_nextP[83] = ((((((((((((rtb_Init_p[0] * SF_idx_7 + rtb_Init_p[3]) +
      rtb_Init_p[1] * SF_idx_6) + rtb_Init_p[2] * SF_idx_9) + rtb_Init_p[10] *
      h_y) - rtb_Init_p[11] * g_y) - rtb_Init_p[12] * rtb_Init[0] / 2.0F) *
                          SF_idx_4 + ((((((rtb_Init_p[80] * SF_idx_7 +
      rtb_Init_p[83]) + rtb_Init_p[81] * SF_idx_6) + rtb_Init_p[82] * SF_idx_9)
      + rtb_Init_p[90] * h_y) - rtb_Init_p[91] * g_y) - rtb_Init_p[92] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[32] * SF_idx_7 + rtb_Init_p[35]) +
      rtb_Init_p[33] * SF_idx_6) + rtb_Init_p[34] * SF_idx_9) + rtb_Init_p[42] *
      h_y) - rtb_Init_p[43] * g_y) - rtb_Init_p[44] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[48] * SF_idx_7 +
      rtb_Init_p[51]) + rtb_Init_p[49] * SF_idx_6) + rtb_Init_p[50] * SF_idx_9)
      + rtb_Init_p[58] * h_y) - rtb_Init_p[59] * g_y) - rtb_Init_p[60] *
      rtb_Init[0] / 2.0F) * SF_idx_5) - ((((((rtb_Init_p[16] * SF_idx_7 +
      rtb_Init_p[19]) + rtb_Init_p[17] * SF_idx_6) + rtb_Init_p[18] * SF_idx_9)
      + rtb_Init_p[26] * h_y) - rtb_Init_p[27] * g_y) - rtb_Init_p[28] *
      rtb_Init[0] / 2.0F) * SPP_idx_0) + ((((((rtb_Init_p[224] * SF_idx_7 +
      rtb_Init_p[227]) + rtb_Init_p[225] * SF_idx_6) + rtb_Init_p[226] *
      SF_idx_9) + rtb_Init_p[234] * h_y) - rtb_Init_p[235] * g_y) - rtb_Init_p
      [236] * rtb_Init[0] / 2.0F) * SPP_idx_2) - ((((((rtb_Init_p[208] *
      SF_idx_7 + rtb_Init_p[211]) + rtb_Init_p[209] * SF_idx_6) + rtb_Init_p[210]
      * SF_idx_9) + rtb_Init_p[218] * h_y) - rtb_Init_p[219] * g_y) -
      rtb_Init_p[220] * rtb_Init[0] / 2.0F) * SPP_idx_10) + ((((((rtb_Init_p[240]
      * SF_idx_7 + rtb_Init_p[243]) + rtb_Init_p[241] * SF_idx_6) + rtb_Init_p
      [242] * SF_idx_9) + rtb_Init_p[250] * h_y) - rtb_Init_p[251] * g_y) -
      rtb_Init_p[252] * rtb_Init[0] / 2.0F) * SF_idx_2;

    /* '<S4>:1:197' */
    rty_nextP[99] = ((((((((((((rtb_Init_p[16] * SF_idx_7 + rtb_Init_p[19]) +
      rtb_Init_p[17] * SF_idx_6) + rtb_Init_p[18] * SF_idx_9) + rtb_Init_p[26] *
      h_y) - rtb_Init_p[27] * g_y) - rtb_Init_p[28] * rtb_Init[0] / 2.0F) *
                          SF_idx_4 + ((((((rtb_Init_p[96] * SF_idx_7 +
      rtb_Init_p[99]) + rtb_Init_p[97] * SF_idx_6) + rtb_Init_p[98] * SF_idx_9)
      + rtb_Init_p[106] * h_y) - rtb_Init_p[107] * g_y) - rtb_Init_p[108] *
      rtb_Init[0] / 2.0F)) + ((((((rtb_Init_p[48] * SF_idx_7 + rtb_Init_p[51]) +
      rtb_Init_p[49] * SF_idx_6) + rtb_Init_p[50] * SF_idx_9) + rtb_Init_p[58] *
      h_y) - rtb_Init_p[59] * g_y) - rtb_Init_p[60] * rtb_Init[0] / 2.0F) *
                         SF_idx_3) + ((((((rtb_Init_p[0] * SF_idx_7 +
      rtb_Init_p[3]) + rtb_Init_p[1] * SF_idx_6) + rtb_Init_p[2] * SF_idx_9) +
      rtb_Init_p[10] * h_y) - rtb_Init_p[11] * g_y) - rtb_Init_p[12] * rtb_Init
      [0] / 2.0F) * SPP_idx_0) - ((((((rtb_Init_p[32] * SF_idx_7 + rtb_Init_p[35])
      + rtb_Init_p[33] * SF_idx_6) + rtb_Init_p[34] * SF_idx_9) + rtb_Init_p[42]
      * h_y) - rtb_Init_p[43] * g_y) - rtb_Init_p[44] * rtb_Init[0] / 2.0F) *
                       SPP_idx_4) + ((((((rtb_Init_p[208] * SF_idx_7 +
      rtb_Init_p[211]) + rtb_Init_p[209] * SF_idx_6) + rtb_Init_p[210] *
      SF_idx_9) + rtb_Init_p[218] * h_y) - rtb_Init_p[219] * g_y) - rtb_Init_p
      [220] * rtb_Init[0] / 2.0F) * SF_idx_1) - ((((((rtb_Init_p[240] * SF_idx_7
      + rtb_Init_p[243]) + rtb_Init_p[241] * SF_idx_6) + rtb_Init_p[242] *
      SF_idx_9) + rtb_Init_p[250] * h_y) - rtb_Init_p[251] * g_y) - rtb_Init_p
      [252] * rtb_Init[0] / 2.0F) * SPP_idx_1) - ((((((rtb_Init_p[224] *
      SF_idx_7 + rtb_Init_p[227]) + rtb_Init_p[225] * SF_idx_6) + rtb_Init_p[226]
      * SF_idx_9) + rtb_Init_p[234] * h_y) - rtb_Init_p[235] * g_y) -
      rtb_Init_p[236] * rtb_Init[0] / 2.0F) * SPP_idx_9;

    /* '<S4>:1:198' */
    rty_nextP[115] = ((((((rtb_Init_p[64] * SF_idx_7 + rtb_Init_p[67]) +
                          rtb_Init_p[65] * SF_idx_6) + rtb_Init_p[66] * SF_idx_9)
                        + rtb_Init_p[74] * h_y) - rtb_Init_p[75] * g_y) -
                      rtb_Init_p[76] * rtb_Init[0] / 2.0F) * localDW->dt +
      ((((((rtb_Init_p[112] * SF_idx_7 + rtb_Init_p[115]) + rtb_Init_p[113] *
           SF_idx_6) + rtb_Init_p[114] * SF_idx_9) + rtb_Init_p[122] * h_y) -
        rtb_Init_p[123] * g_y) - rtb_Init_p[124] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:199' */
    rty_nextP[131] = ((((((rtb_Init_p[80] * SF_idx_7 + rtb_Init_p[83]) +
                          rtb_Init_p[81] * SF_idx_6) + rtb_Init_p[82] * SF_idx_9)
                        + rtb_Init_p[90] * h_y) - rtb_Init_p[91] * g_y) -
                      rtb_Init_p[92] * rtb_Init[0] / 2.0F) * localDW->dt +
      ((((((rtb_Init_p[128] * SF_idx_7 + rtb_Init_p[131]) + rtb_Init_p[129] *
           SF_idx_6) + rtb_Init_p[130] * SF_idx_9) + rtb_Init_p[138] * h_y) -
        rtb_Init_p[139] * g_y) - rtb_Init_p[140] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:200' */
    rty_nextP[147] = ((((((rtb_Init_p[96] * SF_idx_7 + rtb_Init_p[99]) +
                          rtb_Init_p[97] * SF_idx_6) + rtb_Init_p[98] * SF_idx_9)
                        + rtb_Init_p[106] * h_y) - rtb_Init_p[107] * g_y) -
                      rtb_Init_p[108] * rtb_Init[0] / 2.0F) * localDW->dt +
      ((((((rtb_Init_p[144] * SF_idx_7 + rtb_Init_p[147]) + rtb_Init_p[145] *
           SF_idx_6) + rtb_Init_p[146] * SF_idx_9) + rtb_Init_p[154] * h_y) -
        rtb_Init_p[155] * g_y) - rtb_Init_p[156] * rtb_Init[0] / 2.0F);

    /* '<S4>:1:201' */
    rty_nextP[163] = (((((rtb_Init_p[160] * SF_idx_7 + rtb_Init_p[163]) +
                         rtb_Init_p[161] * SF_idx_6) + rtb_Init_p[162] *
                        SF_idx_9) + rtb_Init_p[170] * h_y) - rtb_Init_p[171] *
                      g_y) - rtb_Init_p[172] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:202' */
    rty_nextP[179] = (((((rtb_Init_p[176] * SF_idx_7 + rtb_Init_p[179]) +
                         rtb_Init_p[177] * SF_idx_6) + rtb_Init_p[178] *
                        SF_idx_9) + rtb_Init_p[186] * h_y) - rtb_Init_p[187] *
                      g_y) - rtb_Init_p[188] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:203' */
    rty_nextP[195] = (((((rtb_Init_p[192] * SF_idx_7 + rtb_Init_p[195]) +
                         rtb_Init_p[193] * SF_idx_6) + rtb_Init_p[194] *
                        SF_idx_9) + rtb_Init_p[202] * h_y) - rtb_Init_p[203] *
                      g_y) - rtb_Init_p[204] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:204' */
    rty_nextP[211] = (((((rtb_Init_p[208] * SF_idx_7 + rtb_Init_p[211]) +
                         rtb_Init_p[209] * SF_idx_6) + rtb_Init_p[210] *
                        SF_idx_9) + rtb_Init_p[218] * h_y) - rtb_Init_p[219] *
                      g_y) - rtb_Init_p[220] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:205' */
    rty_nextP[227] = (((((rtb_Init_p[224] * SF_idx_7 + rtb_Init_p[227]) +
                         rtb_Init_p[225] * SF_idx_6) + rtb_Init_p[226] *
                        SF_idx_9) + rtb_Init_p[234] * h_y) - rtb_Init_p[235] *
                      g_y) - rtb_Init_p[236] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:206' */
    rty_nextP[243] = (((((rtb_Init_p[240] * SF_idx_7 + rtb_Init_p[243]) +
                         rtb_Init_p[241] * SF_idx_6) + rtb_Init_p[242] *
                        SF_idx_9) + rtb_Init_p[250] * h_y) - rtb_Init_p[251] *
                      g_y) - rtb_Init_p[252] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:207' */
    rty_nextP[4] = ((((((((((((rtb_Init_p[16] * SF_idx_5 + rtb_Init_p[20]) +
      rtb_Init_p[17] * SF_idx_3) + rtb_Init_p[18] * SPP_idx_0) - rtb_Init_p[19] *
      SF_idx_0) + rtb_Init_p[29] * SPP_idx_3) + rtb_Init_p[30] * SPP_idx_8) -
                         rtb_Init_p[31] * SPP_idx_11) * SF_idx_9 +
                        (((((((rtb_Init_p[0] * SF_idx_5 + rtb_Init_p[4]) +
      rtb_Init_p[1] * SF_idx_3) + rtb_Init_p[2] * SPP_idx_0) - rtb_Init_p[3] *
      SF_idx_0) + rtb_Init_p[13] * SPP_idx_3) + rtb_Init_p[14] * SPP_idx_8) -
                         rtb_Init_p[15] * SPP_idx_11)) + (((((((rtb_Init_p[32] *
      SF_idx_5 + rtb_Init_p[36]) + rtb_Init_p[33] * SF_idx_3) + rtb_Init_p[34] *
      SPP_idx_0) - rtb_Init_p[35] * SF_idx_0) + rtb_Init_p[45] * SPP_idx_3) +
      rtb_Init_p[46] * SPP_idx_8) - rtb_Init_p[47] * SPP_idx_11) * SF_idx_11) +
                      (((((((rtb_Init_p[48] * SF_idx_5 + rtb_Init_p[52]) +
      rtb_Init_p[49] * SF_idx_3) + rtb_Init_p[50] * SPP_idx_0) - rtb_Init_p[51] *
                          SF_idx_0) + rtb_Init_p[61] * SPP_idx_3) + rtb_Init_p
                        [62] * SPP_idx_8) - rtb_Init_p[63] * SPP_idx_11) *
                      SF_idx_10) + (((((((rtb_Init_p[160] * SF_idx_5 +
      rtb_Init_p[164]) + rtb_Init_p[161] * SF_idx_3) + rtb_Init_p[162] *
      SPP_idx_0) - rtb_Init_p[163] * SF_idx_0) + rtb_Init_p[173] * SPP_idx_3) +
      rtb_Init_p[174] * SPP_idx_8) - rtb_Init_p[175] * SPP_idx_11) * g_y) +
                    (((((((rtb_Init_p[176] * SF_idx_5 + rtb_Init_p[180]) +
                          rtb_Init_p[177] * SF_idx_3) + rtb_Init_p[178] *
                         SPP_idx_0) - rtb_Init_p[179] * SF_idx_0) + rtb_Init_p
                       [189] * SPP_idx_3) + rtb_Init_p[190] * SPP_idx_8) -
                     rtb_Init_p[191] * SPP_idx_11) * h_y) + (((((((rtb_Init_p
      [192] * SF_idx_5 + rtb_Init_p[196]) + rtb_Init_p[193] * SF_idx_3) +
      rtb_Init_p[194] * SPP_idx_0) - rtb_Init_p[195] * SF_idx_0) + rtb_Init_p
      [205] * SPP_idx_3) + rtb_Init_p[206] * SPP_idx_8) - rtb_Init_p[207] *
      SPP_idx_11) * SF_idx_16;

    /* '<S4>:1:208' */
    rty_nextP[20] = ((((((((((((rtb_Init_p[0] * SF_idx_5 + rtb_Init_p[4]) +
      rtb_Init_p[1] * SF_idx_3) + rtb_Init_p[2] * SPP_idx_0) - rtb_Init_p[3] *
      SF_idx_0) + rtb_Init_p[13] * SPP_idx_3) + rtb_Init_p[14] * SPP_idx_8) -
                          rtb_Init_p[15] * SPP_idx_11) * SF_idx_8 +
                         (((((((rtb_Init_p[16] * SF_idx_5 + rtb_Init_p[20]) +
      rtb_Init_p[17] * SF_idx_3) + rtb_Init_p[18] * SPP_idx_0) - rtb_Init_p[19] *
      SF_idx_0) + rtb_Init_p[29] * SPP_idx_3) + rtb_Init_p[30] * SPP_idx_8) -
                          rtb_Init_p[31] * SPP_idx_11)) + (((((((rtb_Init_p[32] *
      SF_idx_5 + rtb_Init_p[36]) + rtb_Init_p[33] * SF_idx_3) + rtb_Init_p[34] *
      SPP_idx_0) - rtb_Init_p[35] * SF_idx_0) + rtb_Init_p[45] * SPP_idx_3) +
      rtb_Init_p[46] * SPP_idx_8) - rtb_Init_p[47] * SPP_idx_11) * SF_idx_7) +
                       (((((((rtb_Init_p[48] * SF_idx_5 + rtb_Init_p[52]) +
      rtb_Init_p[49] * SF_idx_3) + rtb_Init_p[50] * SPP_idx_0) - rtb_Init_p[51] *
      SF_idx_0) + rtb_Init_p[61] * SPP_idx_3) + rtb_Init_p[62] * SPP_idx_8) -
                        rtb_Init_p[63] * SPP_idx_11) * SF_idx_11) -
                      (((((((rtb_Init_p[192] * SF_idx_5 + rtb_Init_p[196]) +
      rtb_Init_p[193] * SF_idx_3) + rtb_Init_p[194] * SPP_idx_0) - rtb_Init_p
                          [195] * SF_idx_0) + rtb_Init_p[205] * SPP_idx_3) +
                        rtb_Init_p[206] * SPP_idx_8) - rtb_Init_p[207] *
                       SPP_idx_11) * h_y) + (((((((rtb_Init_p[176] * SF_idx_5 +
      rtb_Init_p[180]) + rtb_Init_p[177] * SF_idx_3) + rtb_Init_p[178] *
      SPP_idx_0) - rtb_Init_p[179] * SF_idx_0) + rtb_Init_p[189] * SPP_idx_3) +
      rtb_Init_p[190] * SPP_idx_8) - rtb_Init_p[191] * SPP_idx_11) * SF_idx_16)
      - (((((((rtb_Init_p[160] * SF_idx_5 + rtb_Init_p[164]) + rtb_Init_p[161] *
              SF_idx_3) + rtb_Init_p[162] * SPP_idx_0) - rtb_Init_p[163] *
            SF_idx_0) + rtb_Init_p[173] * SPP_idx_3) + rtb_Init_p[174] *
          SPP_idx_8) - rtb_Init_p[175] * SPP_idx_11) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:209' */
    rty_nextP[36] = ((((((((((((rtb_Init_p[0] * SF_idx_5 + rtb_Init_p[4]) +
      rtb_Init_p[1] * SF_idx_3) + rtb_Init_p[2] * SPP_idx_0) - rtb_Init_p[3] *
      SF_idx_0) + rtb_Init_p[13] * SPP_idx_3) + rtb_Init_p[14] * SPP_idx_8) -
                          rtb_Init_p[15] * SPP_idx_11) * SF_idx_6 +
                         (((((((rtb_Init_p[32] * SF_idx_5 + rtb_Init_p[36]) +
      rtb_Init_p[33] * SF_idx_3) + rtb_Init_p[34] * SPP_idx_0) - rtb_Init_p[35] *
      SF_idx_0) + rtb_Init_p[45] * SPP_idx_3) + rtb_Init_p[46] * SPP_idx_8) -
                          rtb_Init_p[47] * SPP_idx_11)) + (((((((rtb_Init_p[16] *
      SF_idx_5 + rtb_Init_p[20]) + rtb_Init_p[17] * SF_idx_3) + rtb_Init_p[18] *
      SPP_idx_0) - rtb_Init_p[19] * SF_idx_0) + rtb_Init_p[29] * SPP_idx_3) +
      rtb_Init_p[30] * SPP_idx_8) - rtb_Init_p[31] * SPP_idx_11) * SF_idx_10) +
                       (((((((rtb_Init_p[48] * SF_idx_5 + rtb_Init_p[52]) +
      rtb_Init_p[49] * SF_idx_3) + rtb_Init_p[50] * SPP_idx_0) - rtb_Init_p[51] *
      SF_idx_0) + rtb_Init_p[61] * SPP_idx_3) + rtb_Init_p[62] * SPP_idx_8) -
                        rtb_Init_p[63] * SPP_idx_11) * SF_idx_8) +
                      (((((((rtb_Init_p[192] * SF_idx_5 + rtb_Init_p[196]) +
      rtb_Init_p[193] * SF_idx_3) + rtb_Init_p[194] * SPP_idx_0) - rtb_Init_p
                          [195] * SF_idx_0) + rtb_Init_p[205] * SPP_idx_3) +
                        rtb_Init_p[206] * SPP_idx_8) - rtb_Init_p[207] *
                       SPP_idx_11) * g_y) - (((((((rtb_Init_p[160] * SF_idx_5 +
      rtb_Init_p[164]) + rtb_Init_p[161] * SF_idx_3) + rtb_Init_p[162] *
      SPP_idx_0) - rtb_Init_p[163] * SF_idx_0) + rtb_Init_p[173] * SPP_idx_3) +
      rtb_Init_p[174] * SPP_idx_8) - rtb_Init_p[175] * SPP_idx_11) * SF_idx_16)
      - (((((((rtb_Init_p[176] * SF_idx_5 + rtb_Init_p[180]) + rtb_Init_p[177] *
              SF_idx_3) + rtb_Init_p[178] * SPP_idx_0) - rtb_Init_p[179] *
            SF_idx_0) + rtb_Init_p[189] * SPP_idx_3) + rtb_Init_p[190] *
          SPP_idx_8) - rtb_Init_p[191] * SPP_idx_11) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:210' */
    rty_nextP[52] = ((((((((((((rtb_Init_p[0] * SF_idx_5 + rtb_Init_p[4]) +
      rtb_Init_p[1] * SF_idx_3) + rtb_Init_p[2] * SPP_idx_0) - rtb_Init_p[3] *
      SF_idx_0) + rtb_Init_p[13] * SPP_idx_3) + rtb_Init_p[14] * SPP_idx_8) -
                          rtb_Init_p[15] * SPP_idx_11) * SF_idx_7 +
                         (((((((rtb_Init_p[48] * SF_idx_5 + rtb_Init_p[52]) +
      rtb_Init_p[49] * SF_idx_3) + rtb_Init_p[50] * SPP_idx_0) - rtb_Init_p[51] *
      SF_idx_0) + rtb_Init_p[61] * SPP_idx_3) + rtb_Init_p[62] * SPP_idx_8) -
                          rtb_Init_p[63] * SPP_idx_11)) + (((((((rtb_Init_p[16] *
      SF_idx_5 + rtb_Init_p[20]) + rtb_Init_p[17] * SF_idx_3) + rtb_Init_p[18] *
      SPP_idx_0) - rtb_Init_p[19] * SF_idx_0) + rtb_Init_p[29] * SPP_idx_3) +
      rtb_Init_p[30] * SPP_idx_8) - rtb_Init_p[31] * SPP_idx_11) * SF_idx_6) +
                       (((((((rtb_Init_p[32] * SF_idx_5 + rtb_Init_p[36]) +
      rtb_Init_p[33] * SF_idx_3) + rtb_Init_p[34] * SPP_idx_0) - rtb_Init_p[35] *
      SF_idx_0) + rtb_Init_p[45] * SPP_idx_3) + rtb_Init_p[46] * SPP_idx_8) -
                        rtb_Init_p[47] * SPP_idx_11) * SF_idx_9) +
                      (((((((rtb_Init_p[160] * SF_idx_5 + rtb_Init_p[164]) +
      rtb_Init_p[161] * SF_idx_3) + rtb_Init_p[162] * SPP_idx_0) - rtb_Init_p
                          [163] * SF_idx_0) + rtb_Init_p[173] * SPP_idx_3) +
                        rtb_Init_p[174] * SPP_idx_8) - rtb_Init_p[175] *
                       SPP_idx_11) * h_y) - (((((((rtb_Init_p[176] * SF_idx_5 +
      rtb_Init_p[180]) + rtb_Init_p[177] * SF_idx_3) + rtb_Init_p[178] *
      SPP_idx_0) - rtb_Init_p[179] * SF_idx_0) + rtb_Init_p[189] * SPP_idx_3) +
      rtb_Init_p[190] * SPP_idx_8) - rtb_Init_p[191] * SPP_idx_11) * g_y) -
      (((((((rtb_Init_p[192] * SF_idx_5 + rtb_Init_p[196]) + rtb_Init_p[193] *
            SF_idx_3) + rtb_Init_p[194] * SPP_idx_0) - rtb_Init_p[195] *
          SF_idx_0) + rtb_Init_p[205] * SPP_idx_3) + rtb_Init_p[206] * SPP_idx_8)
       - rtb_Init_p[207] * SPP_idx_11) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:211' */
    deltaQuat_idx_1 = SG_idx_7 - 2.0F * rtb_Init[0] * rtb_Init[3];
    deltaQuat_idx_2 = 2.0F * rtb_Init[0] * rtb_Init[2] + SG_idx_6;
    qUpdated_idx_2 = ((e_c + f_c) - g_c) - h_c;
    rty_nextP[68] = ((((((((((((((((rtb_Init_p[64] * SF_idx_5 + rtb_Init_p[68])
      + rtb_Init_p[65] * SF_idx_3) + rtb_Init_p[66] * SPP_idx_0) - rtb_Init_p[67]
      * SF_idx_0) + rtb_Init_p[77] * SPP_idx_3) + rtb_Init_p[78] * SPP_idx_8) -
      rtb_Init_p[79] * SPP_idx_11) + deltaQuat_idx_1 * deltaQuat_idx_1 *
      deltaQuat_idx_0) + deltaQuat_idx_2 * deltaQuat_idx_2 * qUpdated_idx_3) +
      (((((((rtb_Init_p[0] * SF_idx_5 + rtb_Init_p[4]) + rtb_Init_p[1] *
            SF_idx_3) + rtb_Init_p[2] * SPP_idx_0) - rtb_Init_p[3] * SF_idx_0) +
         rtb_Init_p[13] * SPP_idx_3) + rtb_Init_p[14] * SPP_idx_8) - rtb_Init_p
       [15] * SPP_idx_11) * SF_idx_5) + (((((((rtb_Init_p[16] * SF_idx_5 +
      rtb_Init_p[20]) + rtb_Init_p[17] * SF_idx_3) + rtb_Init_p[18] * SPP_idx_0)
      - rtb_Init_p[19] * SF_idx_0) + rtb_Init_p[29] * SPP_idx_3) + rtb_Init_p[30]
      * SPP_idx_8) - rtb_Init_p[31] * SPP_idx_11) * SF_idx_3) +
                         (((((((rtb_Init_p[32] * SF_idx_5 + rtb_Init_p[36]) +
      rtb_Init_p[33] * SF_idx_3) + rtb_Init_p[34] * SPP_idx_0) - rtb_Init_p[35] *
      SF_idx_0) + rtb_Init_p[45] * SPP_idx_3) + rtb_Init_p[46] * SPP_idx_8) -
                          rtb_Init_p[47] * SPP_idx_11) * SPP_idx_0) -
                        (((((((rtb_Init_p[48] * SF_idx_5 + rtb_Init_p[52]) +
      rtb_Init_p[49] * SF_idx_3) + rtb_Init_p[50] * SPP_idx_0) - rtb_Init_p[51] *
      SF_idx_0) + rtb_Init_p[61] * SPP_idx_3) + rtb_Init_p[62] * SPP_idx_8) -
                         rtb_Init_p[63] * SPP_idx_11) * SF_idx_0) +
                       (((((((rtb_Init_p[208] * SF_idx_5 + rtb_Init_p[212]) +
      rtb_Init_p[209] * SF_idx_3) + rtb_Init_p[210] * SPP_idx_0) - rtb_Init_p
      [211] * SF_idx_0) + rtb_Init_p[221] * SPP_idx_3) + rtb_Init_p[222] *
                         SPP_idx_8) - rtb_Init_p[223] * SPP_idx_11) * SPP_idx_3)
                      + (((((((rtb_Init_p[224] * SF_idx_5 + rtb_Init_p[228]) +
      rtb_Init_p[225] * SF_idx_3) + rtb_Init_p[226] * SPP_idx_0) - rtb_Init_p
      [227] * SF_idx_0) + rtb_Init_p[237] * SPP_idx_3) + rtb_Init_p[238] *
                          SPP_idx_8) - rtb_Init_p[239] * SPP_idx_11) * SPP_idx_8)
                     - (((((((rtb_Init_p[240] * SF_idx_5 + rtb_Init_p[244]) +
      rtb_Init_p[241] * SF_idx_3) + rtb_Init_p[242] * SPP_idx_0) - rtb_Init_p
      [243] * SF_idx_0) + rtb_Init_p[253] * SPP_idx_3) + rtb_Init_p[254] *
                         SPP_idx_8) - rtb_Init_p[255] * SPP_idx_11) * SPP_idx_11)
      + qUpdated_idx_2 * qUpdated_idx_2 * dAngBiasSigma;

    /* '<S4>:1:212' */
    rty_nextP[84] = (((((((((((((rtb_Init_p[0] * SF_idx_5 + rtb_Init_p[4]) +
      rtb_Init_p[1] * SF_idx_3) + rtb_Init_p[2] * SPP_idx_0) - rtb_Init_p[3] *
      SF_idx_0) + rtb_Init_p[13] * SPP_idx_3) + rtb_Init_p[14] * SPP_idx_8) -
      rtb_Init_p[15] * SPP_idx_11) * SF_idx_4 + ((((((((rtb_Init_p[84] +
      SQ_idx_2) + rtb_Init_p[80] * SF_idx_5) + rtb_Init_p[81] * SF_idx_3) +
      rtb_Init_p[82] * SPP_idx_0) - rtb_Init_p[83] * SF_idx_0) + rtb_Init_p[93] *
      SPP_idx_3) + rtb_Init_p[94] * SPP_idx_8) - rtb_Init_p[95] * SPP_idx_11)) +
                         (((((((rtb_Init_p[32] * SF_idx_5 + rtb_Init_p[36]) +
      rtb_Init_p[33] * SF_idx_3) + rtb_Init_p[34] * SPP_idx_0) - rtb_Init_p[35] *
      SF_idx_0) + rtb_Init_p[45] * SPP_idx_3) + rtb_Init_p[46] * SPP_idx_8) -
                          rtb_Init_p[47] * SPP_idx_11) * SF_idx_3) +
                        (((((((rtb_Init_p[48] * SF_idx_5 + rtb_Init_p[52]) +
      rtb_Init_p[49] * SF_idx_3) + rtb_Init_p[50] * SPP_idx_0) - rtb_Init_p[51] *
      SF_idx_0) + rtb_Init_p[61] * SPP_idx_3) + rtb_Init_p[62] * SPP_idx_8) -
                         rtb_Init_p[63] * SPP_idx_11) * SF_idx_5) -
                       (((((((rtb_Init_p[16] * SF_idx_5 + rtb_Init_p[20]) +
      rtb_Init_p[17] * SF_idx_3) + rtb_Init_p[18] * SPP_idx_0) - rtb_Init_p[19] *
      SF_idx_0) + rtb_Init_p[29] * SPP_idx_3) + rtb_Init_p[30] * SPP_idx_8) -
                        rtb_Init_p[31] * SPP_idx_11) * SPP_idx_0) +
                      (((((((rtb_Init_p[224] * SF_idx_5 + rtb_Init_p[228]) +
      rtb_Init_p[225] * SF_idx_3) + rtb_Init_p[226] * SPP_idx_0) - rtb_Init_p
                          [227] * SF_idx_0) + rtb_Init_p[237] * SPP_idx_3) +
                        rtb_Init_p[238] * SPP_idx_8) - rtb_Init_p[239] *
                       SPP_idx_11) * SPP_idx_2) - (((((((rtb_Init_p[208] *
      SF_idx_5 + rtb_Init_p[212]) + rtb_Init_p[209] * SF_idx_3) + rtb_Init_p[210]
      * SPP_idx_0) - rtb_Init_p[211] * SF_idx_0) + rtb_Init_p[221] * SPP_idx_3)
      + rtb_Init_p[222] * SPP_idx_8) - rtb_Init_p[223] * SPP_idx_11) *
                     SPP_idx_10) + (((((((rtb_Init_p[240] * SF_idx_5 +
      rtb_Init_p[244]) + rtb_Init_p[241] * SF_idx_3) + rtb_Init_p[242] *
      SPP_idx_0) - rtb_Init_p[243] * SF_idx_0) + rtb_Init_p[253] * SPP_idx_3) +
      rtb_Init_p[254] * SPP_idx_8) - rtb_Init_p[255] * SPP_idx_11) * SF_idx_2;

    /* '<S4>:1:213' */
    rty_nextP[100] = (((((((((((((rtb_Init_p[16] * SF_idx_5 + rtb_Init_p[20]) +
      rtb_Init_p[17] * SF_idx_3) + rtb_Init_p[18] * SPP_idx_0) - rtb_Init_p[19] *
      SF_idx_0) + rtb_Init_p[29] * SPP_idx_3) + rtb_Init_p[30] * SPP_idx_8) -
      rtb_Init_p[31] * SPP_idx_11) * SF_idx_4 + ((((((((rtb_Init_p[100] +
      SQ_idx_1) + rtb_Init_p[96] * SF_idx_5) + rtb_Init_p[97] * SF_idx_3) +
      rtb_Init_p[98] * SPP_idx_0) - rtb_Init_p[99] * SF_idx_0) + rtb_Init_p[109]
      * SPP_idx_3) + rtb_Init_p[110] * SPP_idx_8) - rtb_Init_p[111] * SPP_idx_11))
                          + (((((((rtb_Init_p[48] * SF_idx_5 + rtb_Init_p[52]) +
      rtb_Init_p[49] * SF_idx_3) + rtb_Init_p[50] * SPP_idx_0) - rtb_Init_p[51] *
      SF_idx_0) + rtb_Init_p[61] * SPP_idx_3) + rtb_Init_p[62] * SPP_idx_8) -
      rtb_Init_p[63] * SPP_idx_11) * SF_idx_3) + (((((((rtb_Init_p[0] * SF_idx_5
      + rtb_Init_p[4]) + rtb_Init_p[1] * SF_idx_3) + rtb_Init_p[2] * SPP_idx_0)
      - rtb_Init_p[3] * SF_idx_0) + rtb_Init_p[13] * SPP_idx_3) + rtb_Init_p[14]
      * SPP_idx_8) - rtb_Init_p[15] * SPP_idx_11) * SPP_idx_0) -
                        (((((((rtb_Init_p[32] * SF_idx_5 + rtb_Init_p[36]) +
      rtb_Init_p[33] * SF_idx_3) + rtb_Init_p[34] * SPP_idx_0) - rtb_Init_p[35] *
      SF_idx_0) + rtb_Init_p[45] * SPP_idx_3) + rtb_Init_p[46] * SPP_idx_8) -
                         rtb_Init_p[47] * SPP_idx_11) * SPP_idx_4) +
                       (((((((rtb_Init_p[208] * SF_idx_5 + rtb_Init_p[212]) +
      rtb_Init_p[209] * SF_idx_3) + rtb_Init_p[210] * SPP_idx_0) - rtb_Init_p
      [211] * SF_idx_0) + rtb_Init_p[221] * SPP_idx_3) + rtb_Init_p[222] *
                         SPP_idx_8) - rtb_Init_p[223] * SPP_idx_11) * SF_idx_1)
                      - (((((((rtb_Init_p[240] * SF_idx_5 + rtb_Init_p[244]) +
      rtb_Init_p[241] * SF_idx_3) + rtb_Init_p[242] * SPP_idx_0) - rtb_Init_p
      [243] * SF_idx_0) + rtb_Init_p[253] * SPP_idx_3) + rtb_Init_p[254] *
                          SPP_idx_8) - rtb_Init_p[255] * SPP_idx_11) * SPP_idx_1)
      - (((((((rtb_Init_p[224] * SF_idx_5 + rtb_Init_p[228]) + rtb_Init_p[225] *
              SF_idx_3) + rtb_Init_p[226] * SPP_idx_0) - rtb_Init_p[227] *
            SF_idx_0) + rtb_Init_p[237] * SPP_idx_3) + rtb_Init_p[238] *
          SPP_idx_8) - rtb_Init_p[239] * SPP_idx_11) * SPP_idx_9;

    /* '<S4>:1:214' */
    rty_nextP[116] = (((((((rtb_Init_p[64] * SF_idx_5 + rtb_Init_p[68]) +
      rtb_Init_p[65] * SF_idx_3) + rtb_Init_p[66] * SPP_idx_0) - rtb_Init_p[67] *
                         SF_idx_0) + rtb_Init_p[77] * SPP_idx_3) + rtb_Init_p[78]
                       * SPP_idx_8) - rtb_Init_p[79] * SPP_idx_11) * localDW->dt
      + (((((((rtb_Init_p[112] * SF_idx_5 + rtb_Init_p[116]) + rtb_Init_p[113] *
              SF_idx_3) + rtb_Init_p[114] * SPP_idx_0) - rtb_Init_p[115] *
            SF_idx_0) + rtb_Init_p[125] * SPP_idx_3) + rtb_Init_p[126] *
          SPP_idx_8) - rtb_Init_p[127] * SPP_idx_11);

    /* '<S4>:1:215' */
    rty_nextP[132] = (((((((rtb_Init_p[80] * SF_idx_5 + rtb_Init_p[84]) +
      rtb_Init_p[81] * SF_idx_3) + rtb_Init_p[82] * SPP_idx_0) - rtb_Init_p[83] *
                         SF_idx_0) + rtb_Init_p[93] * SPP_idx_3) + rtb_Init_p[94]
                       * SPP_idx_8) - rtb_Init_p[95] * SPP_idx_11) * localDW->dt
      + (((((((rtb_Init_p[128] * SF_idx_5 + rtb_Init_p[132]) + rtb_Init_p[129] *
              SF_idx_3) + rtb_Init_p[130] * SPP_idx_0) - rtb_Init_p[131] *
            SF_idx_0) + rtb_Init_p[141] * SPP_idx_3) + rtb_Init_p[142] *
          SPP_idx_8) - rtb_Init_p[143] * SPP_idx_11);

    /* '<S4>:1:216' */
    rty_nextP[148] = (((((((rtb_Init_p[96] * SF_idx_5 + rtb_Init_p[100]) +
      rtb_Init_p[97] * SF_idx_3) + rtb_Init_p[98] * SPP_idx_0) - rtb_Init_p[99] *
                         SF_idx_0) + rtb_Init_p[109] * SPP_idx_3) + rtb_Init_p
                       [110] * SPP_idx_8) - rtb_Init_p[111] * SPP_idx_11) *
      localDW->dt + (((((((rtb_Init_p[144] * SF_idx_5 + rtb_Init_p[148]) +
                          rtb_Init_p[145] * SF_idx_3) + rtb_Init_p[146] *
                         SPP_idx_0) - rtb_Init_p[147] * SF_idx_0) + rtb_Init_p
                       [157] * SPP_idx_3) + rtb_Init_p[158] * SPP_idx_8) -
                     rtb_Init_p[159] * SPP_idx_11);

    /* '<S4>:1:217' */
    rty_nextP[164] = ((((((rtb_Init_p[160] * SF_idx_5 + rtb_Init_p[164]) +
                          rtb_Init_p[161] * SF_idx_3) + rtb_Init_p[162] *
                         SPP_idx_0) - rtb_Init_p[163] * SF_idx_0) + rtb_Init_p
                       [173] * SPP_idx_3) + rtb_Init_p[174] * SPP_idx_8) -
      rtb_Init_p[175] * SPP_idx_11;

    /* '<S4>:1:218' */
    rty_nextP[180] = ((((((rtb_Init_p[176] * SF_idx_5 + rtb_Init_p[180]) +
                          rtb_Init_p[177] * SF_idx_3) + rtb_Init_p[178] *
                         SPP_idx_0) - rtb_Init_p[179] * SF_idx_0) + rtb_Init_p
                       [189] * SPP_idx_3) + rtb_Init_p[190] * SPP_idx_8) -
      rtb_Init_p[191] * SPP_idx_11;

    /* '<S4>:1:219' */
    rty_nextP[196] = ((((((rtb_Init_p[192] * SF_idx_5 + rtb_Init_p[196]) +
                          rtb_Init_p[193] * SF_idx_3) + rtb_Init_p[194] *
                         SPP_idx_0) - rtb_Init_p[195] * SF_idx_0) + rtb_Init_p
                       [205] * SPP_idx_3) + rtb_Init_p[206] * SPP_idx_8) -
      rtb_Init_p[207] * SPP_idx_11;

    /* '<S4>:1:220' */
    rty_nextP[212] = ((((((rtb_Init_p[208] * SF_idx_5 + rtb_Init_p[212]) +
                          rtb_Init_p[209] * SF_idx_3) + rtb_Init_p[210] *
                         SPP_idx_0) - rtb_Init_p[211] * SF_idx_0) + rtb_Init_p
                       [221] * SPP_idx_3) + rtb_Init_p[222] * SPP_idx_8) -
      rtb_Init_p[223] * SPP_idx_11;

    /* '<S4>:1:221' */
    rty_nextP[228] = ((((((rtb_Init_p[224] * SF_idx_5 + rtb_Init_p[228]) +
                          rtb_Init_p[225] * SF_idx_3) + rtb_Init_p[226] *
                         SPP_idx_0) - rtb_Init_p[227] * SF_idx_0) + rtb_Init_p
                       [237] * SPP_idx_3) + rtb_Init_p[238] * SPP_idx_8) -
      rtb_Init_p[239] * SPP_idx_11;

    /* '<S4>:1:222' */
    rty_nextP[244] = ((((((rtb_Init_p[240] * SF_idx_5 + rtb_Init_p[244]) +
                          rtb_Init_p[241] * SF_idx_3) + rtb_Init_p[242] *
                         SPP_idx_0) - rtb_Init_p[243] * SF_idx_0) + rtb_Init_p
                       [253] * SPP_idx_3) + rtb_Init_p[254] * SPP_idx_8) -
      rtb_Init_p[255] * SPP_idx_11;

    /* '<S4>:1:223' */
    rty_nextP[5] = ((((((((((((rtb_Init_p[16] * SF_idx_4 + rtb_Init_p[21]) +
      rtb_Init_p[18] * SF_idx_3) + rtb_Init_p[19] * SF_idx_5) - rtb_Init_p[17] *
      SPP_idx_0) - rtb_Init_p[29] * SPP_idx_10) + rtb_Init_p[30] * SPP_idx_2) +
                         rtb_Init_p[31] * SF_idx_2) * SF_idx_9 +
                        (((((((rtb_Init_p[0] * SF_idx_4 + rtb_Init_p[5]) +
      rtb_Init_p[2] * SF_idx_3) + rtb_Init_p[3] * SF_idx_5) - rtb_Init_p[1] *
      SPP_idx_0) - rtb_Init_p[13] * SPP_idx_10) + rtb_Init_p[14] * SPP_idx_2) +
                         rtb_Init_p[15] * SF_idx_2)) + (((((((rtb_Init_p[32] *
      SF_idx_4 + rtb_Init_p[37]) + rtb_Init_p[34] * SF_idx_3) + rtb_Init_p[35] *
      SF_idx_5) - rtb_Init_p[33] * SPP_idx_0) - rtb_Init_p[45] * SPP_idx_10) +
      rtb_Init_p[46] * SPP_idx_2) + rtb_Init_p[47] * SF_idx_2) * SF_idx_11) +
                      (((((((rtb_Init_p[48] * SF_idx_4 + rtb_Init_p[53]) +
      rtb_Init_p[50] * SF_idx_3) + rtb_Init_p[51] * SF_idx_5) - rtb_Init_p[49] *
                          SPP_idx_0) - rtb_Init_p[61] * SPP_idx_10) +
                        rtb_Init_p[62] * SPP_idx_2) + rtb_Init_p[63] * SF_idx_2)
                      * SF_idx_10) + (((((((rtb_Init_p[160] * SF_idx_4 +
      rtb_Init_p[165]) + rtb_Init_p[162] * SF_idx_3) + rtb_Init_p[163] *
      SF_idx_5) - rtb_Init_p[161] * SPP_idx_0) - rtb_Init_p[173] * SPP_idx_10) +
      rtb_Init_p[174] * SPP_idx_2) + rtb_Init_p[175] * SF_idx_2) * g_y) +
                    (((((((rtb_Init_p[176] * SF_idx_4 + rtb_Init_p[181]) +
                          rtb_Init_p[178] * SF_idx_3) + rtb_Init_p[179] *
                         SF_idx_5) - rtb_Init_p[177] * SPP_idx_0) - rtb_Init_p
                       [189] * SPP_idx_10) + rtb_Init_p[190] * SPP_idx_2) +
                     rtb_Init_p[191] * SF_idx_2) * h_y) + (((((((rtb_Init_p[192]
      * SF_idx_4 + rtb_Init_p[197]) + rtb_Init_p[194] * SF_idx_3) + rtb_Init_p
      [195] * SF_idx_5) - rtb_Init_p[193] * SPP_idx_0) - rtb_Init_p[205] *
      SPP_idx_10) + rtb_Init_p[206] * SPP_idx_2) + rtb_Init_p[207] * SF_idx_2) *
      SF_idx_16;

    /* '<S4>:1:224' */
    rty_nextP[21] = ((((((((((((rtb_Init_p[0] * SF_idx_4 + rtb_Init_p[5]) +
      rtb_Init_p[2] * SF_idx_3) + rtb_Init_p[3] * SF_idx_5) - rtb_Init_p[1] *
      SPP_idx_0) - rtb_Init_p[13] * SPP_idx_10) + rtb_Init_p[14] * SPP_idx_2) +
                          rtb_Init_p[15] * SF_idx_2) * SF_idx_8 +
                         (((((((rtb_Init_p[16] * SF_idx_4 + rtb_Init_p[21]) +
      rtb_Init_p[18] * SF_idx_3) + rtb_Init_p[19] * SF_idx_5) - rtb_Init_p[17] *
      SPP_idx_0) - rtb_Init_p[29] * SPP_idx_10) + rtb_Init_p[30] * SPP_idx_2) +
                          rtb_Init_p[31] * SF_idx_2)) + (((((((rtb_Init_p[32] *
      SF_idx_4 + rtb_Init_p[37]) + rtb_Init_p[34] * SF_idx_3) + rtb_Init_p[35] *
      SF_idx_5) - rtb_Init_p[33] * SPP_idx_0) - rtb_Init_p[45] * SPP_idx_10) +
      rtb_Init_p[46] * SPP_idx_2) + rtb_Init_p[47] * SF_idx_2) * SF_idx_7) +
                       (((((((rtb_Init_p[48] * SF_idx_4 + rtb_Init_p[53]) +
      rtb_Init_p[50] * SF_idx_3) + rtb_Init_p[51] * SF_idx_5) - rtb_Init_p[49] *
      SPP_idx_0) - rtb_Init_p[61] * SPP_idx_10) + rtb_Init_p[62] * SPP_idx_2) +
                        rtb_Init_p[63] * SF_idx_2) * SF_idx_11) -
                      (((((((rtb_Init_p[192] * SF_idx_4 + rtb_Init_p[197]) +
      rtb_Init_p[194] * SF_idx_3) + rtb_Init_p[195] * SF_idx_5) - rtb_Init_p[193]
                          * SPP_idx_0) - rtb_Init_p[205] * SPP_idx_10) +
                        rtb_Init_p[206] * SPP_idx_2) + rtb_Init_p[207] *
                       SF_idx_2) * h_y) + (((((((rtb_Init_p[176] * SF_idx_4 +
      rtb_Init_p[181]) + rtb_Init_p[178] * SF_idx_3) + rtb_Init_p[179] *
      SF_idx_5) - rtb_Init_p[177] * SPP_idx_0) - rtb_Init_p[189] * SPP_idx_10) +
      rtb_Init_p[190] * SPP_idx_2) + rtb_Init_p[191] * SF_idx_2) * SF_idx_16) -
      (((((((rtb_Init_p[160] * SF_idx_4 + rtb_Init_p[165]) + rtb_Init_p[162] *
            SF_idx_3) + rtb_Init_p[163] * SF_idx_5) - rtb_Init_p[161] *
          SPP_idx_0) - rtb_Init_p[173] * SPP_idx_10) + rtb_Init_p[174] *
        SPP_idx_2) + rtb_Init_p[175] * SF_idx_2) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:225' */
    rty_nextP[37] = ((((((((((((rtb_Init_p[0] * SF_idx_4 + rtb_Init_p[5]) +
      rtb_Init_p[2] * SF_idx_3) + rtb_Init_p[3] * SF_idx_5) - rtb_Init_p[1] *
      SPP_idx_0) - rtb_Init_p[13] * SPP_idx_10) + rtb_Init_p[14] * SPP_idx_2) +
                          rtb_Init_p[15] * SF_idx_2) * SF_idx_6 +
                         (((((((rtb_Init_p[32] * SF_idx_4 + rtb_Init_p[37]) +
      rtb_Init_p[34] * SF_idx_3) + rtb_Init_p[35] * SF_idx_5) - rtb_Init_p[33] *
      SPP_idx_0) - rtb_Init_p[45] * SPP_idx_10) + rtb_Init_p[46] * SPP_idx_2) +
                          rtb_Init_p[47] * SF_idx_2)) + (((((((rtb_Init_p[16] *
      SF_idx_4 + rtb_Init_p[21]) + rtb_Init_p[18] * SF_idx_3) + rtb_Init_p[19] *
      SF_idx_5) - rtb_Init_p[17] * SPP_idx_0) - rtb_Init_p[29] * SPP_idx_10) +
      rtb_Init_p[30] * SPP_idx_2) + rtb_Init_p[31] * SF_idx_2) * SF_idx_10) +
                       (((((((rtb_Init_p[48] * SF_idx_4 + rtb_Init_p[53]) +
      rtb_Init_p[50] * SF_idx_3) + rtb_Init_p[51] * SF_idx_5) - rtb_Init_p[49] *
      SPP_idx_0) - rtb_Init_p[61] * SPP_idx_10) + rtb_Init_p[62] * SPP_idx_2) +
                        rtb_Init_p[63] * SF_idx_2) * SF_idx_8) +
                      (((((((rtb_Init_p[192] * SF_idx_4 + rtb_Init_p[197]) +
      rtb_Init_p[194] * SF_idx_3) + rtb_Init_p[195] * SF_idx_5) - rtb_Init_p[193]
                          * SPP_idx_0) - rtb_Init_p[205] * SPP_idx_10) +
                        rtb_Init_p[206] * SPP_idx_2) + rtb_Init_p[207] *
                       SF_idx_2) * g_y) - (((((((rtb_Init_p[160] * SF_idx_4 +
      rtb_Init_p[165]) + rtb_Init_p[162] * SF_idx_3) + rtb_Init_p[163] *
      SF_idx_5) - rtb_Init_p[161] * SPP_idx_0) - rtb_Init_p[173] * SPP_idx_10) +
      rtb_Init_p[174] * SPP_idx_2) + rtb_Init_p[175] * SF_idx_2) * SF_idx_16) -
      (((((((rtb_Init_p[176] * SF_idx_4 + rtb_Init_p[181]) + rtb_Init_p[178] *
            SF_idx_3) + rtb_Init_p[179] * SF_idx_5) - rtb_Init_p[177] *
          SPP_idx_0) - rtb_Init_p[189] * SPP_idx_10) + rtb_Init_p[190] *
        SPP_idx_2) + rtb_Init_p[191] * SF_idx_2) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:226' */
    rty_nextP[53] = ((((((((((((rtb_Init_p[0] * SF_idx_4 + rtb_Init_p[5]) +
      rtb_Init_p[2] * SF_idx_3) + rtb_Init_p[3] * SF_idx_5) - rtb_Init_p[1] *
      SPP_idx_0) - rtb_Init_p[13] * SPP_idx_10) + rtb_Init_p[14] * SPP_idx_2) +
                          rtb_Init_p[15] * SF_idx_2) * SF_idx_7 +
                         (((((((rtb_Init_p[48] * SF_idx_4 + rtb_Init_p[53]) +
      rtb_Init_p[50] * SF_idx_3) + rtb_Init_p[51] * SF_idx_5) - rtb_Init_p[49] *
      SPP_idx_0) - rtb_Init_p[61] * SPP_idx_10) + rtb_Init_p[62] * SPP_idx_2) +
                          rtb_Init_p[63] * SF_idx_2)) + (((((((rtb_Init_p[16] *
      SF_idx_4 + rtb_Init_p[21]) + rtb_Init_p[18] * SF_idx_3) + rtb_Init_p[19] *
      SF_idx_5) - rtb_Init_p[17] * SPP_idx_0) - rtb_Init_p[29] * SPP_idx_10) +
      rtb_Init_p[30] * SPP_idx_2) + rtb_Init_p[31] * SF_idx_2) * SF_idx_6) +
                       (((((((rtb_Init_p[32] * SF_idx_4 + rtb_Init_p[37]) +
      rtb_Init_p[34] * SF_idx_3) + rtb_Init_p[35] * SF_idx_5) - rtb_Init_p[33] *
      SPP_idx_0) - rtb_Init_p[45] * SPP_idx_10) + rtb_Init_p[46] * SPP_idx_2) +
                        rtb_Init_p[47] * SF_idx_2) * SF_idx_9) +
                      (((((((rtb_Init_p[160] * SF_idx_4 + rtb_Init_p[165]) +
      rtb_Init_p[162] * SF_idx_3) + rtb_Init_p[163] * SF_idx_5) - rtb_Init_p[161]
                          * SPP_idx_0) - rtb_Init_p[173] * SPP_idx_10) +
                        rtb_Init_p[174] * SPP_idx_2) + rtb_Init_p[175] *
                       SF_idx_2) * h_y) - (((((((rtb_Init_p[176] * SF_idx_4 +
      rtb_Init_p[181]) + rtb_Init_p[178] * SF_idx_3) + rtb_Init_p[179] *
      SF_idx_5) - rtb_Init_p[177] * SPP_idx_0) - rtb_Init_p[189] * SPP_idx_10) +
      rtb_Init_p[190] * SPP_idx_2) + rtb_Init_p[191] * SF_idx_2) * g_y) -
      (((((((rtb_Init_p[192] * SF_idx_4 + rtb_Init_p[197]) + rtb_Init_p[194] *
            SF_idx_3) + rtb_Init_p[195] * SF_idx_5) - rtb_Init_p[193] *
          SPP_idx_0) - rtb_Init_p[205] * SPP_idx_10) + rtb_Init_p[206] *
        SPP_idx_2) + rtb_Init_p[207] * SF_idx_2) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:227' */
    rty_nextP[69] = (((((((((((((rtb_Init_p[0] * SF_idx_4 + rtb_Init_p[5]) +
      rtb_Init_p[2] * SF_idx_3) + rtb_Init_p[3] * SF_idx_5) - rtb_Init_p[1] *
      SPP_idx_0) - rtb_Init_p[13] * SPP_idx_10) + rtb_Init_p[14] * SPP_idx_2) +
      rtb_Init_p[15] * SF_idx_2) * SF_idx_5 + ((((((((rtb_Init_p[69] + SQ_idx_2)
      + rtb_Init_p[64] * SF_idx_4) + rtb_Init_p[66] * SF_idx_3) + rtb_Init_p[67]
      * SF_idx_5) - rtb_Init_p[65] * SPP_idx_0) - rtb_Init_p[77] * SPP_idx_10) +
      rtb_Init_p[78] * SPP_idx_2) + rtb_Init_p[79] * SF_idx_2)) +
                         (((((((rtb_Init_p[16] * SF_idx_4 + rtb_Init_p[21]) +
      rtb_Init_p[18] * SF_idx_3) + rtb_Init_p[19] * SF_idx_5) - rtb_Init_p[17] *
      SPP_idx_0) - rtb_Init_p[29] * SPP_idx_10) + rtb_Init_p[30] * SPP_idx_2) +
                          rtb_Init_p[31] * SF_idx_2) * SF_idx_3) +
                        (((((((rtb_Init_p[32] * SF_idx_4 + rtb_Init_p[37]) +
      rtb_Init_p[34] * SF_idx_3) + rtb_Init_p[35] * SF_idx_5) - rtb_Init_p[33] *
      SPP_idx_0) - rtb_Init_p[45] * SPP_idx_10) + rtb_Init_p[46] * SPP_idx_2) +
                         rtb_Init_p[47] * SF_idx_2) * SPP_idx_0) -
                       (((((((rtb_Init_p[48] * SF_idx_4 + rtb_Init_p[53]) +
      rtb_Init_p[50] * SF_idx_3) + rtb_Init_p[51] * SF_idx_5) - rtb_Init_p[49] *
      SPP_idx_0) - rtb_Init_p[61] * SPP_idx_10) + rtb_Init_p[62] * SPP_idx_2) +
                        rtb_Init_p[63] * SF_idx_2) * SF_idx_0) +
                      (((((((rtb_Init_p[208] * SF_idx_4 + rtb_Init_p[213]) +
      rtb_Init_p[210] * SF_idx_3) + rtb_Init_p[211] * SF_idx_5) - rtb_Init_p[209]
                          * SPP_idx_0) - rtb_Init_p[221] * SPP_idx_10) +
                        rtb_Init_p[222] * SPP_idx_2) + rtb_Init_p[223] *
                       SF_idx_2) * SPP_idx_3) + (((((((rtb_Init_p[224] *
      SF_idx_4 + rtb_Init_p[229]) + rtb_Init_p[226] * SF_idx_3) + rtb_Init_p[227]
      * SF_idx_5) - rtb_Init_p[225] * SPP_idx_0) - rtb_Init_p[237] * SPP_idx_10)
      + rtb_Init_p[238] * SPP_idx_2) + rtb_Init_p[239] * SF_idx_2) * SPP_idx_8)
      - (((((((rtb_Init_p[240] * SF_idx_4 + rtb_Init_p[245]) + rtb_Init_p[242] *
              SF_idx_3) + rtb_Init_p[243] * SF_idx_5) - rtb_Init_p[241] *
            SPP_idx_0) - rtb_Init_p[253] * SPP_idx_10) + rtb_Init_p[254] *
          SPP_idx_2) + rtb_Init_p[255] * SF_idx_2) * SPP_idx_11;

    /* '<S4>:1:228' */
    deltaQuat_idx_1 = 2.0F * rtb_Init[0] * rtb_Init[3] + SG_idx_7;
    deltaQuat_idx_2 = SG_idx_5 - 2.0F * rtb_Init[0] * rtb_Init[1];
    qUpdated_idx_2 = ((e_c - f_c) + g_c) - h_c;
    rty_nextP[85] = ((((((((((((((((rtb_Init_p[80] * SF_idx_4 + rtb_Init_p[85])
      + rtb_Init_p[82] * SF_idx_3) + rtb_Init_p[83] * SF_idx_5) - rtb_Init_p[81]
      * SPP_idx_0) - rtb_Init_p[93] * SPP_idx_10) + rtb_Init_p[94] * SPP_idx_2)
      + rtb_Init_p[95] * SF_idx_2) + deltaQuat_idx_1 * deltaQuat_idx_1 *
      dAngBiasSigma) + deltaQuat_idx_2 * deltaQuat_idx_2 * qUpdated_idx_3) +
      (((((((rtb_Init_p[0] * SF_idx_4 + rtb_Init_p[5]) + rtb_Init_p[2] *
            SF_idx_3) + rtb_Init_p[3] * SF_idx_5) - rtb_Init_p[1] * SPP_idx_0) -
         rtb_Init_p[13] * SPP_idx_10) + rtb_Init_p[14] * SPP_idx_2) +
       rtb_Init_p[15] * SF_idx_2) * SF_idx_4) + (((((((rtb_Init_p[32] * SF_idx_4
      + rtb_Init_p[37]) + rtb_Init_p[34] * SF_idx_3) + rtb_Init_p[35] * SF_idx_5)
      - rtb_Init_p[33] * SPP_idx_0) - rtb_Init_p[45] * SPP_idx_10) + rtb_Init_p
      [46] * SPP_idx_2) + rtb_Init_p[47] * SF_idx_2) * SF_idx_3) +
                         (((((((rtb_Init_p[48] * SF_idx_4 + rtb_Init_p[53]) +
      rtb_Init_p[50] * SF_idx_3) + rtb_Init_p[51] * SF_idx_5) - rtb_Init_p[49] *
      SPP_idx_0) - rtb_Init_p[61] * SPP_idx_10) + rtb_Init_p[62] * SPP_idx_2) +
                          rtb_Init_p[63] * SF_idx_2) * SF_idx_5) -
                        (((((((rtb_Init_p[16] * SF_idx_4 + rtb_Init_p[21]) +
      rtb_Init_p[18] * SF_idx_3) + rtb_Init_p[19] * SF_idx_5) - rtb_Init_p[17] *
      SPP_idx_0) - rtb_Init_p[29] * SPP_idx_10) + rtb_Init_p[30] * SPP_idx_2) +
                         rtb_Init_p[31] * SF_idx_2) * SPP_idx_0) +
                       (((((((rtb_Init_p[224] * SF_idx_4 + rtb_Init_p[229]) +
      rtb_Init_p[226] * SF_idx_3) + rtb_Init_p[227] * SF_idx_5) - rtb_Init_p[225]
      * SPP_idx_0) - rtb_Init_p[237] * SPP_idx_10) + rtb_Init_p[238] * SPP_idx_2)
                        + rtb_Init_p[239] * SF_idx_2) * SPP_idx_2) -
                      (((((((rtb_Init_p[208] * SF_idx_4 + rtb_Init_p[213]) +
      rtb_Init_p[210] * SF_idx_3) + rtb_Init_p[211] * SF_idx_5) - rtb_Init_p[209]
                          * SPP_idx_0) - rtb_Init_p[221] * SPP_idx_10) +
                        rtb_Init_p[222] * SPP_idx_2) + rtb_Init_p[223] *
                       SF_idx_2) * SPP_idx_10) + (((((((rtb_Init_p[240] *
      SF_idx_4 + rtb_Init_p[245]) + rtb_Init_p[242] * SF_idx_3) + rtb_Init_p[243]
      * SF_idx_5) - rtb_Init_p[241] * SPP_idx_0) - rtb_Init_p[253] * SPP_idx_10)
      + rtb_Init_p[254] * SPP_idx_2) + rtb_Init_p[255] * SF_idx_2) * SF_idx_2) +
      qUpdated_idx_2 * qUpdated_idx_2 * deltaQuat_idx_0;

    /* '<S4>:1:229' */
    rty_nextP[101] = (((((((((((((rtb_Init_p[16] * SF_idx_4 + rtb_Init_p[21]) +
      rtb_Init_p[18] * SF_idx_3) + rtb_Init_p[19] * SF_idx_5) - rtb_Init_p[17] *
      SPP_idx_0) - rtb_Init_p[29] * SPP_idx_10) + rtb_Init_p[30] * SPP_idx_2) +
      rtb_Init_p[31] * SF_idx_2) * SF_idx_4 + ((((((((rtb_Init_p[101] + SQ_idx_0)
      + rtb_Init_p[96] * SF_idx_4) + rtb_Init_p[98] * SF_idx_3) + rtb_Init_p[99]
      * SF_idx_5) - rtb_Init_p[97] * SPP_idx_0) - rtb_Init_p[109] * SPP_idx_10)
      + rtb_Init_p[110] * SPP_idx_2) + rtb_Init_p[111] * SF_idx_2)) +
                          (((((((rtb_Init_p[48] * SF_idx_4 + rtb_Init_p[53]) +
      rtb_Init_p[50] * SF_idx_3) + rtb_Init_p[51] * SF_idx_5) - rtb_Init_p[49] *
      SPP_idx_0) - rtb_Init_p[61] * SPP_idx_10) + rtb_Init_p[62] * SPP_idx_2) +
      rtb_Init_p[63] * SF_idx_2) * SF_idx_3) + (((((((rtb_Init_p[0] * SF_idx_4 +
      rtb_Init_p[5]) + rtb_Init_p[2] * SF_idx_3) + rtb_Init_p[3] * SF_idx_5) -
      rtb_Init_p[1] * SPP_idx_0) - rtb_Init_p[13] * SPP_idx_10) + rtb_Init_p[14]
      * SPP_idx_2) + rtb_Init_p[15] * SF_idx_2) * SPP_idx_0) -
                        (((((((rtb_Init_p[32] * SF_idx_4 + rtb_Init_p[37]) +
      rtb_Init_p[34] * SF_idx_3) + rtb_Init_p[35] * SF_idx_5) - rtb_Init_p[33] *
      SPP_idx_0) - rtb_Init_p[45] * SPP_idx_10) + rtb_Init_p[46] * SPP_idx_2) +
                         rtb_Init_p[47] * SF_idx_2) * SPP_idx_4) +
                       (((((((rtb_Init_p[208] * SF_idx_4 + rtb_Init_p[213]) +
      rtb_Init_p[210] * SF_idx_3) + rtb_Init_p[211] * SF_idx_5) - rtb_Init_p[209]
      * SPP_idx_0) - rtb_Init_p[221] * SPP_idx_10) + rtb_Init_p[222] * SPP_idx_2)
                        + rtb_Init_p[223] * SF_idx_2) * SF_idx_1) -
                      (((((((rtb_Init_p[240] * SF_idx_4 + rtb_Init_p[245]) +
      rtb_Init_p[242] * SF_idx_3) + rtb_Init_p[243] * SF_idx_5) - rtb_Init_p[241]
                          * SPP_idx_0) - rtb_Init_p[253] * SPP_idx_10) +
                        rtb_Init_p[254] * SPP_idx_2) + rtb_Init_p[255] *
                       SF_idx_2) * SPP_idx_1) - (((((((rtb_Init_p[224] *
      SF_idx_4 + rtb_Init_p[229]) + rtb_Init_p[226] * SF_idx_3) + rtb_Init_p[227]
      * SF_idx_5) - rtb_Init_p[225] * SPP_idx_0) - rtb_Init_p[237] * SPP_idx_10)
      + rtb_Init_p[238] * SPP_idx_2) + rtb_Init_p[239] * SF_idx_2) * SPP_idx_9;

    /* '<S4>:1:230' */
    rty_nextP[117] = (((((((rtb_Init_p[64] * SF_idx_4 + rtb_Init_p[69]) +
      rtb_Init_p[66] * SF_idx_3) + rtb_Init_p[67] * SF_idx_5) - rtb_Init_p[65] *
                         SPP_idx_0) - rtb_Init_p[77] * SPP_idx_10) + rtb_Init_p
                       [78] * SPP_idx_2) + rtb_Init_p[79] * SF_idx_2) *
      localDW->dt + (((((((rtb_Init_p[112] * SF_idx_4 + rtb_Init_p[117]) +
                          rtb_Init_p[114] * SF_idx_3) + rtb_Init_p[115] *
                         SF_idx_5) - rtb_Init_p[113] * SPP_idx_0) - rtb_Init_p
                       [125] * SPP_idx_10) + rtb_Init_p[126] * SPP_idx_2) +
                     rtb_Init_p[127] * SF_idx_2);

    /* '<S4>:1:231' */
    rty_nextP[133] = (((((((rtb_Init_p[80] * SF_idx_4 + rtb_Init_p[85]) +
      rtb_Init_p[82] * SF_idx_3) + rtb_Init_p[83] * SF_idx_5) - rtb_Init_p[81] *
                         SPP_idx_0) - rtb_Init_p[93] * SPP_idx_10) + rtb_Init_p
                       [94] * SPP_idx_2) + rtb_Init_p[95] * SF_idx_2) *
      localDW->dt + (((((((rtb_Init_p[128] * SF_idx_4 + rtb_Init_p[133]) +
                          rtb_Init_p[130] * SF_idx_3) + rtb_Init_p[131] *
                         SF_idx_5) - rtb_Init_p[129] * SPP_idx_0) - rtb_Init_p
                       [141] * SPP_idx_10) + rtb_Init_p[142] * SPP_idx_2) +
                     rtb_Init_p[143] * SF_idx_2);

    /* '<S4>:1:232' */
    rty_nextP[149] = (((((((rtb_Init_p[96] * SF_idx_4 + rtb_Init_p[101]) +
      rtb_Init_p[98] * SF_idx_3) + rtb_Init_p[99] * SF_idx_5) - rtb_Init_p[97] *
                         SPP_idx_0) - rtb_Init_p[109] * SPP_idx_10) +
                       rtb_Init_p[110] * SPP_idx_2) + rtb_Init_p[111] * SF_idx_2)
      * localDW->dt + (((((((rtb_Init_p[144] * SF_idx_4 + rtb_Init_p[149]) +
      rtb_Init_p[146] * SF_idx_3) + rtb_Init_p[147] * SF_idx_5) - rtb_Init_p[145]
                          * SPP_idx_0) - rtb_Init_p[157] * SPP_idx_10) +
                        rtb_Init_p[158] * SPP_idx_2) + rtb_Init_p[159] *
                       SF_idx_2);

    /* '<S4>:1:233' */
    rty_nextP[165] = ((((((rtb_Init_p[160] * SF_idx_4 + rtb_Init_p[165]) +
                          rtb_Init_p[162] * SF_idx_3) + rtb_Init_p[163] *
                         SF_idx_5) - rtb_Init_p[161] * SPP_idx_0) - rtb_Init_p
                       [173] * SPP_idx_10) + rtb_Init_p[174] * SPP_idx_2) +
      rtb_Init_p[175] * SF_idx_2;

    /* '<S4>:1:234' */
    rty_nextP[181] = ((((((rtb_Init_p[176] * SF_idx_4 + rtb_Init_p[181]) +
                          rtb_Init_p[178] * SF_idx_3) + rtb_Init_p[179] *
                         SF_idx_5) - rtb_Init_p[177] * SPP_idx_0) - rtb_Init_p
                       [189] * SPP_idx_10) + rtb_Init_p[190] * SPP_idx_2) +
      rtb_Init_p[191] * SF_idx_2;

    /* '<S4>:1:235' */
    rty_nextP[197] = ((((((rtb_Init_p[192] * SF_idx_4 + rtb_Init_p[197]) +
                          rtb_Init_p[194] * SF_idx_3) + rtb_Init_p[195] *
                         SF_idx_5) - rtb_Init_p[193] * SPP_idx_0) - rtb_Init_p
                       [205] * SPP_idx_10) + rtb_Init_p[206] * SPP_idx_2) +
      rtb_Init_p[207] * SF_idx_2;

    /* '<S4>:1:236' */
    rty_nextP[213] = ((((((rtb_Init_p[208] * SF_idx_4 + rtb_Init_p[213]) +
                          rtb_Init_p[210] * SF_idx_3) + rtb_Init_p[211] *
                         SF_idx_5) - rtb_Init_p[209] * SPP_idx_0) - rtb_Init_p
                       [221] * SPP_idx_10) + rtb_Init_p[222] * SPP_idx_2) +
      rtb_Init_p[223] * SF_idx_2;

    /* '<S4>:1:237' */
    rty_nextP[229] = ((((((rtb_Init_p[224] * SF_idx_4 + rtb_Init_p[229]) +
                          rtb_Init_p[226] * SF_idx_3) + rtb_Init_p[227] *
                         SF_idx_5) - rtb_Init_p[225] * SPP_idx_0) - rtb_Init_p
                       [237] * SPP_idx_10) + rtb_Init_p[238] * SPP_idx_2) +
      rtb_Init_p[239] * SF_idx_2;

    /* '<S4>:1:238' */
    rty_nextP[245] = ((((((rtb_Init_p[240] * SF_idx_4 + rtb_Init_p[245]) +
                          rtb_Init_p[242] * SF_idx_3) + rtb_Init_p[243] *
                         SF_idx_5) - rtb_Init_p[241] * SPP_idx_0) - rtb_Init_p
                       [253] * SPP_idx_10) + rtb_Init_p[254] * SPP_idx_2) +
      rtb_Init_p[255] * SF_idx_2;

    /* '<S4>:1:239' */
    rty_nextP[6] = ((((((((((((rtb_Init_p[17] * SF_idx_4 + rtb_Init_p[22]) +
      rtb_Init_p[19] * SF_idx_3) + rtb_Init_p[16] * SPP_idx_0) - rtb_Init_p[18] *
      SPP_idx_4) + rtb_Init_p[29] * SF_idx_1) - rtb_Init_p[30] * SPP_idx_9) -
                         rtb_Init_p[31] * SPP_idx_1) * SF_idx_9 +
                        (((((((rtb_Init_p[1] * SF_idx_4 + rtb_Init_p[6]) +
      rtb_Init_p[3] * SF_idx_3) + rtb_Init_p[0] * SPP_idx_0) - rtb_Init_p[2] *
      SPP_idx_4) + rtb_Init_p[13] * SF_idx_1) - rtb_Init_p[14] * SPP_idx_9) -
                         rtb_Init_p[15] * SPP_idx_1)) + (((((((rtb_Init_p[33] *
      SF_idx_4 + rtb_Init_p[38]) + rtb_Init_p[35] * SF_idx_3) + rtb_Init_p[32] *
      SPP_idx_0) - rtb_Init_p[34] * SPP_idx_4) + rtb_Init_p[45] * SF_idx_1) -
      rtb_Init_p[46] * SPP_idx_9) - rtb_Init_p[47] * SPP_idx_1) * SF_idx_11) +
                      (((((((rtb_Init_p[49] * SF_idx_4 + rtb_Init_p[54]) +
      rtb_Init_p[51] * SF_idx_3) + rtb_Init_p[48] * SPP_idx_0) - rtb_Init_p[50] *
                          SPP_idx_4) + rtb_Init_p[61] * SF_idx_1) - rtb_Init_p
                        [62] * SPP_idx_9) - rtb_Init_p[63] * SPP_idx_1) *
                      SF_idx_10) + (((((((rtb_Init_p[161] * SF_idx_4 +
      rtb_Init_p[166]) + rtb_Init_p[163] * SF_idx_3) + rtb_Init_p[160] *
      SPP_idx_0) - rtb_Init_p[162] * SPP_idx_4) + rtb_Init_p[173] * SF_idx_1) -
      rtb_Init_p[174] * SPP_idx_9) - rtb_Init_p[175] * SPP_idx_1) * g_y) +
                    (((((((rtb_Init_p[177] * SF_idx_4 + rtb_Init_p[182]) +
                          rtb_Init_p[179] * SF_idx_3) + rtb_Init_p[176] *
                         SPP_idx_0) - rtb_Init_p[178] * SPP_idx_4) + rtb_Init_p
                       [189] * SF_idx_1) - rtb_Init_p[190] * SPP_idx_9) -
                     rtb_Init_p[191] * SPP_idx_1) * h_y) + (((((((rtb_Init_p[193]
      * SF_idx_4 + rtb_Init_p[198]) + rtb_Init_p[195] * SF_idx_3) + rtb_Init_p
      [192] * SPP_idx_0) - rtb_Init_p[194] * SPP_idx_4) + rtb_Init_p[205] *
      SF_idx_1) - rtb_Init_p[206] * SPP_idx_9) - rtb_Init_p[207] * SPP_idx_1) *
      SF_idx_16;

    /* '<S4>:1:240' */
    rty_nextP[22] = ((((((((((((rtb_Init_p[1] * SF_idx_4 + rtb_Init_p[6]) +
      rtb_Init_p[3] * SF_idx_3) + rtb_Init_p[0] * SPP_idx_0) - rtb_Init_p[2] *
      SPP_idx_4) + rtb_Init_p[13] * SF_idx_1) - rtb_Init_p[14] * SPP_idx_9) -
                          rtb_Init_p[15] * SPP_idx_1) * SF_idx_8 +
                         (((((((rtb_Init_p[17] * SF_idx_4 + rtb_Init_p[22]) +
      rtb_Init_p[19] * SF_idx_3) + rtb_Init_p[16] * SPP_idx_0) - rtb_Init_p[18] *
      SPP_idx_4) + rtb_Init_p[29] * SF_idx_1) - rtb_Init_p[30] * SPP_idx_9) -
                          rtb_Init_p[31] * SPP_idx_1)) + (((((((rtb_Init_p[33] *
      SF_idx_4 + rtb_Init_p[38]) + rtb_Init_p[35] * SF_idx_3) + rtb_Init_p[32] *
      SPP_idx_0) - rtb_Init_p[34] * SPP_idx_4) + rtb_Init_p[45] * SF_idx_1) -
      rtb_Init_p[46] * SPP_idx_9) - rtb_Init_p[47] * SPP_idx_1) * SF_idx_7) +
                       (((((((rtb_Init_p[49] * SF_idx_4 + rtb_Init_p[54]) +
      rtb_Init_p[51] * SF_idx_3) + rtb_Init_p[48] * SPP_idx_0) - rtb_Init_p[50] *
      SPP_idx_4) + rtb_Init_p[61] * SF_idx_1) - rtb_Init_p[62] * SPP_idx_9) -
                        rtb_Init_p[63] * SPP_idx_1) * SF_idx_11) -
                      (((((((rtb_Init_p[193] * SF_idx_4 + rtb_Init_p[198]) +
      rtb_Init_p[195] * SF_idx_3) + rtb_Init_p[192] * SPP_idx_0) - rtb_Init_p
                          [194] * SPP_idx_4) + rtb_Init_p[205] * SF_idx_1) -
                        rtb_Init_p[206] * SPP_idx_9) - rtb_Init_p[207] *
                       SPP_idx_1) * h_y) + (((((((rtb_Init_p[177] * SF_idx_4 +
      rtb_Init_p[182]) + rtb_Init_p[179] * SF_idx_3) + rtb_Init_p[176] *
      SPP_idx_0) - rtb_Init_p[178] * SPP_idx_4) + rtb_Init_p[189] * SF_idx_1) -
      rtb_Init_p[190] * SPP_idx_9) - rtb_Init_p[191] * SPP_idx_1) * SF_idx_16) -
      (((((((rtb_Init_p[161] * SF_idx_4 + rtb_Init_p[166]) + rtb_Init_p[163] *
            SF_idx_3) + rtb_Init_p[160] * SPP_idx_0) - rtb_Init_p[162] *
          SPP_idx_4) + rtb_Init_p[173] * SF_idx_1) - rtb_Init_p[174] * SPP_idx_9)
       - rtb_Init_p[175] * SPP_idx_1) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:241' */
    rty_nextP[38] = ((((((((((((rtb_Init_p[1] * SF_idx_4 + rtb_Init_p[6]) +
      rtb_Init_p[3] * SF_idx_3) + rtb_Init_p[0] * SPP_idx_0) - rtb_Init_p[2] *
      SPP_idx_4) + rtb_Init_p[13] * SF_idx_1) - rtb_Init_p[14] * SPP_idx_9) -
                          rtb_Init_p[15] * SPP_idx_1) * SF_idx_6 +
                         (((((((rtb_Init_p[33] * SF_idx_4 + rtb_Init_p[38]) +
      rtb_Init_p[35] * SF_idx_3) + rtb_Init_p[32] * SPP_idx_0) - rtb_Init_p[34] *
      SPP_idx_4) + rtb_Init_p[45] * SF_idx_1) - rtb_Init_p[46] * SPP_idx_9) -
                          rtb_Init_p[47] * SPP_idx_1)) + (((((((rtb_Init_p[17] *
      SF_idx_4 + rtb_Init_p[22]) + rtb_Init_p[19] * SF_idx_3) + rtb_Init_p[16] *
      SPP_idx_0) - rtb_Init_p[18] * SPP_idx_4) + rtb_Init_p[29] * SF_idx_1) -
      rtb_Init_p[30] * SPP_idx_9) - rtb_Init_p[31] * SPP_idx_1) * SF_idx_10) +
                       (((((((rtb_Init_p[49] * SF_idx_4 + rtb_Init_p[54]) +
      rtb_Init_p[51] * SF_idx_3) + rtb_Init_p[48] * SPP_idx_0) - rtb_Init_p[50] *
      SPP_idx_4) + rtb_Init_p[61] * SF_idx_1) - rtb_Init_p[62] * SPP_idx_9) -
                        rtb_Init_p[63] * SPP_idx_1) * SF_idx_8) +
                      (((((((rtb_Init_p[193] * SF_idx_4 + rtb_Init_p[198]) +
      rtb_Init_p[195] * SF_idx_3) + rtb_Init_p[192] * SPP_idx_0) - rtb_Init_p
                          [194] * SPP_idx_4) + rtb_Init_p[205] * SF_idx_1) -
                        rtb_Init_p[206] * SPP_idx_9) - rtb_Init_p[207] *
                       SPP_idx_1) * g_y) - (((((((rtb_Init_p[161] * SF_idx_4 +
      rtb_Init_p[166]) + rtb_Init_p[163] * SF_idx_3) + rtb_Init_p[160] *
      SPP_idx_0) - rtb_Init_p[162] * SPP_idx_4) + rtb_Init_p[173] * SF_idx_1) -
      rtb_Init_p[174] * SPP_idx_9) - rtb_Init_p[175] * SPP_idx_1) * SF_idx_16) -
      (((((((rtb_Init_p[177] * SF_idx_4 + rtb_Init_p[182]) + rtb_Init_p[179] *
            SF_idx_3) + rtb_Init_p[176] * SPP_idx_0) - rtb_Init_p[178] *
          SPP_idx_4) + rtb_Init_p[189] * SF_idx_1) - rtb_Init_p[190] * SPP_idx_9)
       - rtb_Init_p[191] * SPP_idx_1) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:242' */
    rty_nextP[54] = ((((((((((((rtb_Init_p[1] * SF_idx_4 + rtb_Init_p[6]) +
      rtb_Init_p[3] * SF_idx_3) + rtb_Init_p[0] * SPP_idx_0) - rtb_Init_p[2] *
      SPP_idx_4) + rtb_Init_p[13] * SF_idx_1) - rtb_Init_p[14] * SPP_idx_9) -
                          rtb_Init_p[15] * SPP_idx_1) * SF_idx_7 +
                         (((((((rtb_Init_p[49] * SF_idx_4 + rtb_Init_p[54]) +
      rtb_Init_p[51] * SF_idx_3) + rtb_Init_p[48] * SPP_idx_0) - rtb_Init_p[50] *
      SPP_idx_4) + rtb_Init_p[61] * SF_idx_1) - rtb_Init_p[62] * SPP_idx_9) -
                          rtb_Init_p[63] * SPP_idx_1)) + (((((((rtb_Init_p[17] *
      SF_idx_4 + rtb_Init_p[22]) + rtb_Init_p[19] * SF_idx_3) + rtb_Init_p[16] *
      SPP_idx_0) - rtb_Init_p[18] * SPP_idx_4) + rtb_Init_p[29] * SF_idx_1) -
      rtb_Init_p[30] * SPP_idx_9) - rtb_Init_p[31] * SPP_idx_1) * SF_idx_6) +
                       (((((((rtb_Init_p[33] * SF_idx_4 + rtb_Init_p[38]) +
      rtb_Init_p[35] * SF_idx_3) + rtb_Init_p[32] * SPP_idx_0) - rtb_Init_p[34] *
      SPP_idx_4) + rtb_Init_p[45] * SF_idx_1) - rtb_Init_p[46] * SPP_idx_9) -
                        rtb_Init_p[47] * SPP_idx_1) * SF_idx_9) +
                      (((((((rtb_Init_p[161] * SF_idx_4 + rtb_Init_p[166]) +
      rtb_Init_p[163] * SF_idx_3) + rtb_Init_p[160] * SPP_idx_0) - rtb_Init_p
                          [162] * SPP_idx_4) + rtb_Init_p[173] * SF_idx_1) -
                        rtb_Init_p[174] * SPP_idx_9) - rtb_Init_p[175] *
                       SPP_idx_1) * h_y) - (((((((rtb_Init_p[177] * SF_idx_4 +
      rtb_Init_p[182]) + rtb_Init_p[179] * SF_idx_3) + rtb_Init_p[176] *
      SPP_idx_0) - rtb_Init_p[178] * SPP_idx_4) + rtb_Init_p[189] * SF_idx_1) -
      rtb_Init_p[190] * SPP_idx_9) - rtb_Init_p[191] * SPP_idx_1) * g_y) -
      (((((((rtb_Init_p[193] * SF_idx_4 + rtb_Init_p[198]) + rtb_Init_p[195] *
            SF_idx_3) + rtb_Init_p[192] * SPP_idx_0) - rtb_Init_p[194] *
          SPP_idx_4) + rtb_Init_p[205] * SF_idx_1) - rtb_Init_p[206] * SPP_idx_9)
       - rtb_Init_p[207] * SPP_idx_1) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:243' */
    rty_nextP[70] = (((((((((((((rtb_Init_p[1] * SF_idx_4 + rtb_Init_p[6]) +
      rtb_Init_p[3] * SF_idx_3) + rtb_Init_p[0] * SPP_idx_0) - rtb_Init_p[2] *
      SPP_idx_4) + rtb_Init_p[13] * SF_idx_1) - rtb_Init_p[14] * SPP_idx_9) -
      rtb_Init_p[15] * SPP_idx_1) * SF_idx_5 + ((((((((rtb_Init_p[70] + SQ_idx_1)
      + rtb_Init_p[65] * SF_idx_4) + rtb_Init_p[67] * SF_idx_3) + rtb_Init_p[64]
      * SPP_idx_0) - rtb_Init_p[66] * SPP_idx_4) + rtb_Init_p[77] * SF_idx_1) -
      rtb_Init_p[78] * SPP_idx_9) - rtb_Init_p[79] * SPP_idx_1)) +
                         (((((((rtb_Init_p[17] * SF_idx_4 + rtb_Init_p[22]) +
      rtb_Init_p[19] * SF_idx_3) + rtb_Init_p[16] * SPP_idx_0) - rtb_Init_p[18] *
      SPP_idx_4) + rtb_Init_p[29] * SF_idx_1) - rtb_Init_p[30] * SPP_idx_9) -
                          rtb_Init_p[31] * SPP_idx_1) * SF_idx_3) +
                        (((((((rtb_Init_p[33] * SF_idx_4 + rtb_Init_p[38]) +
      rtb_Init_p[35] * SF_idx_3) + rtb_Init_p[32] * SPP_idx_0) - rtb_Init_p[34] *
      SPP_idx_4) + rtb_Init_p[45] * SF_idx_1) - rtb_Init_p[46] * SPP_idx_9) -
                         rtb_Init_p[47] * SPP_idx_1) * SPP_idx_0) -
                       (((((((rtb_Init_p[49] * SF_idx_4 + rtb_Init_p[54]) +
      rtb_Init_p[51] * SF_idx_3) + rtb_Init_p[48] * SPP_idx_0) - rtb_Init_p[50] *
      SPP_idx_4) + rtb_Init_p[61] * SF_idx_1) - rtb_Init_p[62] * SPP_idx_9) -
                        rtb_Init_p[63] * SPP_idx_1) * SF_idx_0) +
                      (((((((rtb_Init_p[209] * SF_idx_4 + rtb_Init_p[214]) +
      rtb_Init_p[211] * SF_idx_3) + rtb_Init_p[208] * SPP_idx_0) - rtb_Init_p
                          [210] * SPP_idx_4) + rtb_Init_p[221] * SF_idx_1) -
                        rtb_Init_p[222] * SPP_idx_9) - rtb_Init_p[223] *
                       SPP_idx_1) * SPP_idx_3) + (((((((rtb_Init_p[225] *
      SF_idx_4 + rtb_Init_p[230]) + rtb_Init_p[227] * SF_idx_3) + rtb_Init_p[224]
      * SPP_idx_0) - rtb_Init_p[226] * SPP_idx_4) + rtb_Init_p[237] * SF_idx_1)
      - rtb_Init_p[238] * SPP_idx_9) - rtb_Init_p[239] * SPP_idx_1) * SPP_idx_8)
      - (((((((rtb_Init_p[241] * SF_idx_4 + rtb_Init_p[246]) + rtb_Init_p[243] *
              SF_idx_3) + rtb_Init_p[240] * SPP_idx_0) - rtb_Init_p[242] *
            SPP_idx_4) + rtb_Init_p[253] * SF_idx_1) - rtb_Init_p[254] *
          SPP_idx_9) - rtb_Init_p[255] * SPP_idx_1) * SPP_idx_11;

    /* '<S4>:1:244' */
    rty_nextP[86] = (((((((((((((rtb_Init_p[1] * SF_idx_4 + rtb_Init_p[6]) +
      rtb_Init_p[3] * SF_idx_3) + rtb_Init_p[0] * SPP_idx_0) - rtb_Init_p[2] *
      SPP_idx_4) + rtb_Init_p[13] * SF_idx_1) - rtb_Init_p[14] * SPP_idx_9) -
      rtb_Init_p[15] * SPP_idx_1) * SF_idx_4 + ((((((((rtb_Init_p[86] + SQ_idx_0)
      + rtb_Init_p[81] * SF_idx_4) + rtb_Init_p[83] * SF_idx_3) + rtb_Init_p[80]
      * SPP_idx_0) - rtb_Init_p[82] * SPP_idx_4) + rtb_Init_p[93] * SF_idx_1) -
      rtb_Init_p[94] * SPP_idx_9) - rtb_Init_p[95] * SPP_idx_1)) +
                         (((((((rtb_Init_p[33] * SF_idx_4 + rtb_Init_p[38]) +
      rtb_Init_p[35] * SF_idx_3) + rtb_Init_p[32] * SPP_idx_0) - rtb_Init_p[34] *
      SPP_idx_4) + rtb_Init_p[45] * SF_idx_1) - rtb_Init_p[46] * SPP_idx_9) -
                          rtb_Init_p[47] * SPP_idx_1) * SF_idx_3) +
                        (((((((rtb_Init_p[49] * SF_idx_4 + rtb_Init_p[54]) +
      rtb_Init_p[51] * SF_idx_3) + rtb_Init_p[48] * SPP_idx_0) - rtb_Init_p[50] *
      SPP_idx_4) + rtb_Init_p[61] * SF_idx_1) - rtb_Init_p[62] * SPP_idx_9) -
                         rtb_Init_p[63] * SPP_idx_1) * SF_idx_5) -
                       (((((((rtb_Init_p[17] * SF_idx_4 + rtb_Init_p[22]) +
      rtb_Init_p[19] * SF_idx_3) + rtb_Init_p[16] * SPP_idx_0) - rtb_Init_p[18] *
      SPP_idx_4) + rtb_Init_p[29] * SF_idx_1) - rtb_Init_p[30] * SPP_idx_9) -
                        rtb_Init_p[31] * SPP_idx_1) * SPP_idx_0) +
                      (((((((rtb_Init_p[225] * SF_idx_4 + rtb_Init_p[230]) +
      rtb_Init_p[227] * SF_idx_3) + rtb_Init_p[224] * SPP_idx_0) - rtb_Init_p
                          [226] * SPP_idx_4) + rtb_Init_p[237] * SF_idx_1) -
                        rtb_Init_p[238] * SPP_idx_9) - rtb_Init_p[239] *
                       SPP_idx_1) * SPP_idx_2) - (((((((rtb_Init_p[209] *
      SF_idx_4 + rtb_Init_p[214]) + rtb_Init_p[211] * SF_idx_3) + rtb_Init_p[208]
      * SPP_idx_0) - rtb_Init_p[210] * SPP_idx_4) + rtb_Init_p[221] * SF_idx_1)
      - rtb_Init_p[222] * SPP_idx_9) - rtb_Init_p[223] * SPP_idx_1) * SPP_idx_10)
      + (((((((rtb_Init_p[241] * SF_idx_4 + rtb_Init_p[246]) + rtb_Init_p[243] *
              SF_idx_3) + rtb_Init_p[240] * SPP_idx_0) - rtb_Init_p[242] *
            SPP_idx_4) + rtb_Init_p[253] * SF_idx_1) - rtb_Init_p[254] *
          SPP_idx_9) - rtb_Init_p[255] * SPP_idx_1) * SF_idx_2;

    /* '<S4>:1:245' */
    deltaQuat_idx_1 = SG_idx_6 - 2.0F * rtb_Init[0] * rtb_Init[2];
    deltaQuat_idx_2 = 2.0F * rtb_Init[0] * rtb_Init[1] + SG_idx_5;
    e_c = ((e_c - f_c) - g_c) + h_c;
    rty_nextP[102] = ((((((((((((((((rtb_Init_p[97] * SF_idx_4 + rtb_Init_p[102])
      + rtb_Init_p[99] * SF_idx_3) + rtb_Init_p[96] * SPP_idx_0) - rtb_Init_p[98]
      * SPP_idx_4) + rtb_Init_p[109] * SF_idx_1) - rtb_Init_p[110] * SPP_idx_9)
      - rtb_Init_p[111] * SPP_idx_1) + deltaQuat_idx_1 * deltaQuat_idx_1 *
      dAngBiasSigma) + deltaQuat_idx_2 * deltaQuat_idx_2 * deltaQuat_idx_0) +
      (((((((rtb_Init_p[17] * SF_idx_4 + rtb_Init_p[22]) + rtb_Init_p[19] *
            SF_idx_3) + rtb_Init_p[16] * SPP_idx_0) - rtb_Init_p[18] * SPP_idx_4)
         + rtb_Init_p[29] * SF_idx_1) - rtb_Init_p[30] * SPP_idx_9) -
       rtb_Init_p[31] * SPP_idx_1) * SF_idx_4) + (((((((rtb_Init_p[49] *
      SF_idx_4 + rtb_Init_p[54]) + rtb_Init_p[51] * SF_idx_3) + rtb_Init_p[48] *
      SPP_idx_0) - rtb_Init_p[50] * SPP_idx_4) + rtb_Init_p[61] * SF_idx_1) -
      rtb_Init_p[62] * SPP_idx_9) - rtb_Init_p[63] * SPP_idx_1) * SF_idx_3) +
                          (((((((rtb_Init_p[1] * SF_idx_4 + rtb_Init_p[6]) +
      rtb_Init_p[3] * SF_idx_3) + rtb_Init_p[0] * SPP_idx_0) - rtb_Init_p[2] *
      SPP_idx_4) + rtb_Init_p[13] * SF_idx_1) - rtb_Init_p[14] * SPP_idx_9) -
      rtb_Init_p[15] * SPP_idx_1) * SPP_idx_0) - (((((((rtb_Init_p[33] *
      SF_idx_4 + rtb_Init_p[38]) + rtb_Init_p[35] * SF_idx_3) + rtb_Init_p[32] *
      SPP_idx_0) - rtb_Init_p[34] * SPP_idx_4) + rtb_Init_p[45] * SF_idx_1) -
      rtb_Init_p[46] * SPP_idx_9) - rtb_Init_p[47] * SPP_idx_1) * SPP_idx_4) +
                        (((((((rtb_Init_p[209] * SF_idx_4 + rtb_Init_p[214]) +
      rtb_Init_p[211] * SF_idx_3) + rtb_Init_p[208] * SPP_idx_0) - rtb_Init_p
      [210] * SPP_idx_4) + rtb_Init_p[221] * SF_idx_1) - rtb_Init_p[222] *
                          SPP_idx_9) - rtb_Init_p[223] * SPP_idx_1) * SF_idx_1)
                       - (((((((rtb_Init_p[241] * SF_idx_4 + rtb_Init_p[246]) +
      rtb_Init_p[243] * SF_idx_3) + rtb_Init_p[240] * SPP_idx_0) - rtb_Init_p
      [242] * SPP_idx_4) + rtb_Init_p[253] * SF_idx_1) - rtb_Init_p[254] *
      SPP_idx_9) - rtb_Init_p[255] * SPP_idx_1) * SPP_idx_1) -
                      (((((((rtb_Init_p[225] * SF_idx_4 + rtb_Init_p[230]) +
      rtb_Init_p[227] * SF_idx_3) + rtb_Init_p[224] * SPP_idx_0) - rtb_Init_p
                          [226] * SPP_idx_4) + rtb_Init_p[237] * SF_idx_1) -
                        rtb_Init_p[238] * SPP_idx_9) - rtb_Init_p[239] *
                       SPP_idx_1) * SPP_idx_9) + e_c * e_c * qUpdated_idx_3;

    /* '<S4>:1:246' */
    rty_nextP[118] = (((((((rtb_Init_p[65] * SF_idx_4 + rtb_Init_p[70]) +
      rtb_Init_p[67] * SF_idx_3) + rtb_Init_p[64] * SPP_idx_0) - rtb_Init_p[66] *
                         SPP_idx_4) + rtb_Init_p[77] * SF_idx_1) - rtb_Init_p[78]
                       * SPP_idx_9) - rtb_Init_p[79] * SPP_idx_1) * localDW->dt
      + (((((((rtb_Init_p[113] * SF_idx_4 + rtb_Init_p[118]) + rtb_Init_p[115] *
              SF_idx_3) + rtb_Init_p[112] * SPP_idx_0) - rtb_Init_p[114] *
            SPP_idx_4) + rtb_Init_p[125] * SF_idx_1) - rtb_Init_p[126] *
          SPP_idx_9) - rtb_Init_p[127] * SPP_idx_1);

    /* '<S4>:1:247' */
    rty_nextP[134] = (((((((rtb_Init_p[81] * SF_idx_4 + rtb_Init_p[86]) +
      rtb_Init_p[83] * SF_idx_3) + rtb_Init_p[80] * SPP_idx_0) - rtb_Init_p[82] *
                         SPP_idx_4) + rtb_Init_p[93] * SF_idx_1) - rtb_Init_p[94]
                       * SPP_idx_9) - rtb_Init_p[95] * SPP_idx_1) * localDW->dt
      + (((((((rtb_Init_p[129] * SF_idx_4 + rtb_Init_p[134]) + rtb_Init_p[131] *
              SF_idx_3) + rtb_Init_p[128] * SPP_idx_0) - rtb_Init_p[130] *
            SPP_idx_4) + rtb_Init_p[141] * SF_idx_1) - rtb_Init_p[142] *
          SPP_idx_9) - rtb_Init_p[143] * SPP_idx_1);

    /* '<S4>:1:248' */
    rty_nextP[150] = (((((((rtb_Init_p[97] * SF_idx_4 + rtb_Init_p[102]) +
      rtb_Init_p[99] * SF_idx_3) + rtb_Init_p[96] * SPP_idx_0) - rtb_Init_p[98] *
                         SPP_idx_4) + rtb_Init_p[109] * SF_idx_1) - rtb_Init_p
                       [110] * SPP_idx_9) - rtb_Init_p[111] * SPP_idx_1) *
      localDW->dt + (((((((rtb_Init_p[145] * SF_idx_4 + rtb_Init_p[150]) +
                          rtb_Init_p[147] * SF_idx_3) + rtb_Init_p[144] *
                         SPP_idx_0) - rtb_Init_p[146] * SPP_idx_4) + rtb_Init_p
                       [157] * SF_idx_1) - rtb_Init_p[158] * SPP_idx_9) -
                     rtb_Init_p[159] * SPP_idx_1);

    /* '<S4>:1:249' */
    rty_nextP[166] = ((((((rtb_Init_p[161] * SF_idx_4 + rtb_Init_p[166]) +
                          rtb_Init_p[163] * SF_idx_3) + rtb_Init_p[160] *
                         SPP_idx_0) - rtb_Init_p[162] * SPP_idx_4) + rtb_Init_p
                       [173] * SF_idx_1) - rtb_Init_p[174] * SPP_idx_9) -
      rtb_Init_p[175] * SPP_idx_1;

    /* '<S4>:1:250' */
    rty_nextP[182] = ((((((rtb_Init_p[177] * SF_idx_4 + rtb_Init_p[182]) +
                          rtb_Init_p[179] * SF_idx_3) + rtb_Init_p[176] *
                         SPP_idx_0) - rtb_Init_p[178] * SPP_idx_4) + rtb_Init_p
                       [189] * SF_idx_1) - rtb_Init_p[190] * SPP_idx_9) -
      rtb_Init_p[191] * SPP_idx_1;

    /* '<S4>:1:251' */
    rty_nextP[198] = ((((((rtb_Init_p[193] * SF_idx_4 + rtb_Init_p[198]) +
                          rtb_Init_p[195] * SF_idx_3) + rtb_Init_p[192] *
                         SPP_idx_0) - rtb_Init_p[194] * SPP_idx_4) + rtb_Init_p
                       [205] * SF_idx_1) - rtb_Init_p[206] * SPP_idx_9) -
      rtb_Init_p[207] * SPP_idx_1;

    /* '<S4>:1:252' */
    rty_nextP[214] = ((((((rtb_Init_p[209] * SF_idx_4 + rtb_Init_p[214]) +
                          rtb_Init_p[211] * SF_idx_3) + rtb_Init_p[208] *
                         SPP_idx_0) - rtb_Init_p[210] * SPP_idx_4) + rtb_Init_p
                       [221] * SF_idx_1) - rtb_Init_p[222] * SPP_idx_9) -
      rtb_Init_p[223] * SPP_idx_1;

    /* '<S4>:1:253' */
    rty_nextP[230] = ((((((rtb_Init_p[225] * SF_idx_4 + rtb_Init_p[230]) +
                          rtb_Init_p[227] * SF_idx_3) + rtb_Init_p[224] *
                         SPP_idx_0) - rtb_Init_p[226] * SPP_idx_4) + rtb_Init_p
                       [237] * SF_idx_1) - rtb_Init_p[238] * SPP_idx_9) -
      rtb_Init_p[239] * SPP_idx_1;

    /* '<S4>:1:254' */
    rty_nextP[246] = ((((((rtb_Init_p[241] * SF_idx_4 + rtb_Init_p[246]) +
                          rtb_Init_p[243] * SF_idx_3) + rtb_Init_p[240] *
                         SPP_idx_0) - rtb_Init_p[242] * SPP_idx_4) + rtb_Init_p
                       [253] * SF_idx_1) - rtb_Init_p[254] * SPP_idx_9) -
      rtb_Init_p[255] * SPP_idx_1;

    /* '<S4>:1:255' */
    rty_nextP[7] = ((((((rtb_Init_p[20] * localDW->dt + rtb_Init_p[23]) *
                        SF_idx_9 + (rtb_Init_p[4] * localDW->dt + rtb_Init_p[7]))
                       + (rtb_Init_p[36] * localDW->dt + rtb_Init_p[39]) *
                       SF_idx_11) + (rtb_Init_p[52] * localDW->dt + rtb_Init_p
      [55]) * SF_idx_10) + (rtb_Init_p[164] * localDW->dt + rtb_Init_p[167]) *
                     g_y) + (rtb_Init_p[180] * localDW->dt + rtb_Init_p[183]) *
                    h_y) + (rtb_Init_p[196] * localDW->dt + rtb_Init_p[199]) *
      SF_idx_16;

    /* '<S4>:1:256' */
    rty_nextP[23] = ((((((rtb_Init_p[4] * localDW->dt + rtb_Init_p[7]) *
                         SF_idx_8 + (rtb_Init_p[20] * localDW->dt + rtb_Init_p
      [23])) + (rtb_Init_p[36] * localDW->dt + rtb_Init_p[39]) * SF_idx_7) +
                       (rtb_Init_p[52] * localDW->dt + rtb_Init_p[55]) *
                       SF_idx_11) - (rtb_Init_p[196] * localDW->dt + rtb_Init_p
      [199]) * h_y) + (rtb_Init_p[180] * localDW->dt + rtb_Init_p[183]) *
                     SF_idx_16) - (rtb_Init_p[164] * localDW->dt + rtb_Init_p
      [167]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:257' */
    rty_nextP[39] = ((((((rtb_Init_p[4] * localDW->dt + rtb_Init_p[7]) *
                         SF_idx_6 + (rtb_Init_p[36] * localDW->dt + rtb_Init_p
      [39])) + (rtb_Init_p[20] * localDW->dt + rtb_Init_p[23]) * SF_idx_10) +
                       (rtb_Init_p[52] * localDW->dt + rtb_Init_p[55]) *
                       SF_idx_8) + (rtb_Init_p[196] * localDW->dt + rtb_Init_p
      [199]) * g_y) - (rtb_Init_p[164] * localDW->dt + rtb_Init_p[167]) *
                     SF_idx_16) - (rtb_Init_p[180] * localDW->dt + rtb_Init_p
      [183]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:258' */
    rty_nextP[55] = ((((((rtb_Init_p[4] * localDW->dt + rtb_Init_p[7]) *
                         SF_idx_7 + (rtb_Init_p[52] * localDW->dt + rtb_Init_p
      [55])) + (rtb_Init_p[20] * localDW->dt + rtb_Init_p[23]) * SF_idx_6) +
                       (rtb_Init_p[36] * localDW->dt + rtb_Init_p[39]) *
                       SF_idx_9) + (rtb_Init_p[164] * localDW->dt + rtb_Init_p
      [167]) * h_y) - (rtb_Init_p[180] * localDW->dt + rtb_Init_p[183]) * g_y) -
      (rtb_Init_p[196] * localDW->dt + rtb_Init_p[199]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:259' */
    rty_nextP[71] = (((((((rtb_Init_p[20] * localDW->dt + rtb_Init_p[23]) *
                          SF_idx_3 + (rtb_Init_p[68] * localDW->dt + rtb_Init_p
      [71])) + (rtb_Init_p[4] * localDW->dt + rtb_Init_p[7]) * SF_idx_5) +
                        (rtb_Init_p[36] * localDW->dt + rtb_Init_p[39]) *
                        SPP_idx_0) - (rtb_Init_p[52] * localDW->dt + rtb_Init_p
      [55]) * SF_idx_0) + (rtb_Init_p[212] * localDW->dt + rtb_Init_p[215]) *
                      SPP_idx_3) + (rtb_Init_p[228] * localDW->dt + rtb_Init_p
      [231]) * SPP_idx_8) - (rtb_Init_p[244] * localDW->dt + rtb_Init_p[247]) *
      SPP_idx_11;

    /* '<S4>:1:260' */
    rty_nextP[87] = (((((((rtb_Init_p[4] * localDW->dt + rtb_Init_p[7]) *
                          SF_idx_4 + (rtb_Init_p[84] * localDW->dt + rtb_Init_p
      [87])) + (rtb_Init_p[36] * localDW->dt + rtb_Init_p[39]) * SF_idx_3) +
                        (rtb_Init_p[52] * localDW->dt + rtb_Init_p[55]) *
                        SF_idx_5) - (rtb_Init_p[20] * localDW->dt + rtb_Init_p
      [23]) * SPP_idx_0) + (rtb_Init_p[228] * localDW->dt + rtb_Init_p[231]) *
                      SPP_idx_2) - (rtb_Init_p[212] * localDW->dt + rtb_Init_p
      [215]) * SPP_idx_10) + (rtb_Init_p[244] * localDW->dt + rtb_Init_p[247]) *
      SF_idx_2;

    /* '<S4>:1:261' */
    rty_nextP[103] = (((((((rtb_Init_p[20] * localDW->dt + rtb_Init_p[23]) *
      SF_idx_4 + (rtb_Init_p[100] * localDW->dt + rtb_Init_p[103])) +
                          (rtb_Init_p[52] * localDW->dt + rtb_Init_p[55]) *
                          SF_idx_3) + (rtb_Init_p[4] * localDW->dt + rtb_Init_p
      [7]) * SPP_idx_0) - (rtb_Init_p[36] * localDW->dt + rtb_Init_p[39]) *
                        SPP_idx_4) - (rtb_Init_p[244] * localDW->dt +
      rtb_Init_p[247]) * SPP_idx_1) + (rtb_Init_p[212] * localDW->dt +
      rtb_Init_p[215]) * SF_idx_1) - (rtb_Init_p[228] * localDW->dt +
      rtb_Init_p[231]) * SPP_idx_9;

    /* '<S4>:1:262' */
    rty_nextP[119] = (rtb_Init_p[68] * localDW->dt + rtb_Init_p[71]) *
      localDW->dt + (rtb_Init_p[116] * localDW->dt + rtb_Init_p[119]);

    /* '<S4>:1:263' */
    rty_nextP[135] = (rtb_Init_p[84] * localDW->dt + rtb_Init_p[87]) *
      localDW->dt + (rtb_Init_p[132] * localDW->dt + rtb_Init_p[135]);

    /* '<S4>:1:264' */
    rty_nextP[151] = (rtb_Init_p[100] * localDW->dt + rtb_Init_p[103]) *
      localDW->dt + (rtb_Init_p[148] * localDW->dt + rtb_Init_p[151]);

    /* '<S4>:1:265' */
    rty_nextP[167] = rtb_Init_p[164] * localDW->dt + rtb_Init_p[167];

    /* '<S4>:1:266' */
    rty_nextP[183] = rtb_Init_p[180] * localDW->dt + rtb_Init_p[183];

    /* '<S4>:1:267' */
    rty_nextP[199] = rtb_Init_p[196] * localDW->dt + rtb_Init_p[199];

    /* '<S4>:1:268' */
    rty_nextP[215] = rtb_Init_p[212] * localDW->dt + rtb_Init_p[215];

    /* '<S4>:1:269' */
    rty_nextP[231] = rtb_Init_p[228] * localDW->dt + rtb_Init_p[231];

    /* '<S4>:1:270' */
    rty_nextP[247] = rtb_Init_p[244] * localDW->dt + rtb_Init_p[247];

    /* '<S4>:1:271' */
    rty_nextP[8] = ((((((rtb_Init_p[21] * localDW->dt + rtb_Init_p[24]) *
                        SF_idx_9 + (rtb_Init_p[5] * localDW->dt + rtb_Init_p[8]))
                       + (rtb_Init_p[37] * localDW->dt + rtb_Init_p[40]) *
                       SF_idx_11) + (rtb_Init_p[53] * localDW->dt + rtb_Init_p
      [56]) * SF_idx_10) + (rtb_Init_p[165] * localDW->dt + rtb_Init_p[168]) *
                     g_y) + (rtb_Init_p[181] * localDW->dt + rtb_Init_p[184]) *
                    h_y) + (rtb_Init_p[197] * localDW->dt + rtb_Init_p[200]) *
      SF_idx_16;

    /* '<S4>:1:272' */
    rty_nextP[24] = ((((((rtb_Init_p[5] * localDW->dt + rtb_Init_p[8]) *
                         SF_idx_8 + (rtb_Init_p[21] * localDW->dt + rtb_Init_p
      [24])) + (rtb_Init_p[37] * localDW->dt + rtb_Init_p[40]) * SF_idx_7) +
                       (rtb_Init_p[53] * localDW->dt + rtb_Init_p[56]) *
                       SF_idx_11) - (rtb_Init_p[197] * localDW->dt + rtb_Init_p
      [200]) * h_y) + (rtb_Init_p[181] * localDW->dt + rtb_Init_p[184]) *
                     SF_idx_16) - (rtb_Init_p[165] * localDW->dt + rtb_Init_p
      [168]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:273' */
    rty_nextP[40] = ((((((rtb_Init_p[5] * localDW->dt + rtb_Init_p[8]) *
                         SF_idx_6 + (rtb_Init_p[37] * localDW->dt + rtb_Init_p
      [40])) + (rtb_Init_p[21] * localDW->dt + rtb_Init_p[24]) * SF_idx_10) +
                       (rtb_Init_p[53] * localDW->dt + rtb_Init_p[56]) *
                       SF_idx_8) + (rtb_Init_p[197] * localDW->dt + rtb_Init_p
      [200]) * g_y) - (rtb_Init_p[165] * localDW->dt + rtb_Init_p[168]) *
                     SF_idx_16) - (rtb_Init_p[181] * localDW->dt + rtb_Init_p
      [184]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:274' */
    rty_nextP[56] = ((((((rtb_Init_p[5] * localDW->dt + rtb_Init_p[8]) *
                         SF_idx_7 + (rtb_Init_p[53] * localDW->dt + rtb_Init_p
      [56])) + (rtb_Init_p[21] * localDW->dt + rtb_Init_p[24]) * SF_idx_6) +
                       (rtb_Init_p[37] * localDW->dt + rtb_Init_p[40]) *
                       SF_idx_9) + (rtb_Init_p[165] * localDW->dt + rtb_Init_p
      [168]) * h_y) - (rtb_Init_p[181] * localDW->dt + rtb_Init_p[184]) * g_y) -
      (rtb_Init_p[197] * localDW->dt + rtb_Init_p[200]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:275' */
    rty_nextP[72] = (((((((rtb_Init_p[21] * localDW->dt + rtb_Init_p[24]) *
                          SF_idx_3 + (rtb_Init_p[69] * localDW->dt + rtb_Init_p
      [72])) + (rtb_Init_p[5] * localDW->dt + rtb_Init_p[8]) * SF_idx_5) +
                        (rtb_Init_p[37] * localDW->dt + rtb_Init_p[40]) *
                        SPP_idx_0) - (rtb_Init_p[53] * localDW->dt + rtb_Init_p
      [56]) * SF_idx_0) + (rtb_Init_p[213] * localDW->dt + rtb_Init_p[216]) *
                      SPP_idx_3) + (rtb_Init_p[229] * localDW->dt + rtb_Init_p
      [232]) * SPP_idx_8) - (rtb_Init_p[245] * localDW->dt + rtb_Init_p[248]) *
      SPP_idx_11;

    /* '<S4>:1:276' */
    rty_nextP[88] = (((((((rtb_Init_p[5] * localDW->dt + rtb_Init_p[8]) *
                          SF_idx_4 + (rtb_Init_p[85] * localDW->dt + rtb_Init_p
      [88])) + (rtb_Init_p[37] * localDW->dt + rtb_Init_p[40]) * SF_idx_3) +
                        (rtb_Init_p[53] * localDW->dt + rtb_Init_p[56]) *
                        SF_idx_5) - (rtb_Init_p[21] * localDW->dt + rtb_Init_p
      [24]) * SPP_idx_0) + (rtb_Init_p[229] * localDW->dt + rtb_Init_p[232]) *
                      SPP_idx_2) - (rtb_Init_p[213] * localDW->dt + rtb_Init_p
      [216]) * SPP_idx_10) + (rtb_Init_p[245] * localDW->dt + rtb_Init_p[248]) *
      SF_idx_2;

    /* '<S4>:1:277' */
    rty_nextP[104] = (((((((rtb_Init_p[21] * localDW->dt + rtb_Init_p[24]) *
      SF_idx_4 + (rtb_Init_p[101] * localDW->dt + rtb_Init_p[104])) +
                          (rtb_Init_p[53] * localDW->dt + rtb_Init_p[56]) *
                          SF_idx_3) + (rtb_Init_p[5] * localDW->dt + rtb_Init_p
      [8]) * SPP_idx_0) - (rtb_Init_p[37] * localDW->dt + rtb_Init_p[40]) *
                        SPP_idx_4) - (rtb_Init_p[245] * localDW->dt +
      rtb_Init_p[248]) * SPP_idx_1) + (rtb_Init_p[213] * localDW->dt +
      rtb_Init_p[216]) * SF_idx_1) - (rtb_Init_p[229] * localDW->dt +
      rtb_Init_p[232]) * SPP_idx_9;

    /* '<S4>:1:278' */
    rty_nextP[120] = (rtb_Init_p[69] * localDW->dt + rtb_Init_p[72]) *
      localDW->dt + (rtb_Init_p[117] * localDW->dt + rtb_Init_p[120]);

    /* '<S4>:1:279' */
    rty_nextP[136] = (rtb_Init_p[85] * localDW->dt + rtb_Init_p[88]) *
      localDW->dt + (rtb_Init_p[133] * localDW->dt + rtb_Init_p[136]);

    /* '<S4>:1:280' */
    rty_nextP[152] = (rtb_Init_p[101] * localDW->dt + rtb_Init_p[104]) *
      localDW->dt + (rtb_Init_p[149] * localDW->dt + rtb_Init_p[152]);

    /* '<S4>:1:281' */
    rty_nextP[168] = rtb_Init_p[165] * localDW->dt + rtb_Init_p[168];

    /* '<S4>:1:282' */
    rty_nextP[184] = rtb_Init_p[181] * localDW->dt + rtb_Init_p[184];

    /* '<S4>:1:283' */
    rty_nextP[200] = rtb_Init_p[197] * localDW->dt + rtb_Init_p[200];

    /* '<S4>:1:284' */
    rty_nextP[216] = rtb_Init_p[213] * localDW->dt + rtb_Init_p[216];

    /* '<S4>:1:285' */
    rty_nextP[232] = rtb_Init_p[229] * localDW->dt + rtb_Init_p[232];

    /* '<S4>:1:286' */
    rty_nextP[248] = rtb_Init_p[245] * localDW->dt + rtb_Init_p[248];

    /* '<S4>:1:287' */
    rty_nextP[9] = ((((((rtb_Init_p[22] * localDW->dt + rtb_Init_p[25]) *
                        SF_idx_9 + (rtb_Init_p[6] * localDW->dt + rtb_Init_p[9]))
                       + (rtb_Init_p[38] * localDW->dt + rtb_Init_p[41]) *
                       SF_idx_11) + (rtb_Init_p[54] * localDW->dt + rtb_Init_p
      [57]) * SF_idx_10) + (rtb_Init_p[166] * localDW->dt + rtb_Init_p[169]) *
                     g_y) + (rtb_Init_p[182] * localDW->dt + rtb_Init_p[185]) *
                    h_y) + (rtb_Init_p[198] * localDW->dt + rtb_Init_p[201]) *
      SF_idx_16;

    /* '<S4>:1:288' */
    rty_nextP[25] = ((((((rtb_Init_p[6] * localDW->dt + rtb_Init_p[9]) *
                         SF_idx_8 + (rtb_Init_p[22] * localDW->dt + rtb_Init_p
      [25])) + (rtb_Init_p[38] * localDW->dt + rtb_Init_p[41]) * SF_idx_7) +
                       (rtb_Init_p[54] * localDW->dt + rtb_Init_p[57]) *
                       SF_idx_11) - (rtb_Init_p[198] * localDW->dt + rtb_Init_p
      [201]) * h_y) + (rtb_Init_p[182] * localDW->dt + rtb_Init_p[185]) *
                     SF_idx_16) - (rtb_Init_p[166] * localDW->dt + rtb_Init_p
      [169]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:289' */
    rty_nextP[41] = ((((((rtb_Init_p[6] * localDW->dt + rtb_Init_p[9]) *
                         SF_idx_6 + (rtb_Init_p[38] * localDW->dt + rtb_Init_p
      [41])) + (rtb_Init_p[22] * localDW->dt + rtb_Init_p[25]) * SF_idx_10) +
                       (rtb_Init_p[54] * localDW->dt + rtb_Init_p[57]) *
                       SF_idx_8) + (rtb_Init_p[198] * localDW->dt + rtb_Init_p
      [201]) * g_y) - (rtb_Init_p[166] * localDW->dt + rtb_Init_p[169]) *
                     SF_idx_16) - (rtb_Init_p[182] * localDW->dt + rtb_Init_p
      [185]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:290' */
    rty_nextP[57] = ((((((rtb_Init_p[6] * localDW->dt + rtb_Init_p[9]) *
                         SF_idx_7 + (rtb_Init_p[54] * localDW->dt + rtb_Init_p
      [57])) + (rtb_Init_p[22] * localDW->dt + rtb_Init_p[25]) * SF_idx_6) +
                       (rtb_Init_p[38] * localDW->dt + rtb_Init_p[41]) *
                       SF_idx_9) + (rtb_Init_p[166] * localDW->dt + rtb_Init_p
      [169]) * h_y) - (rtb_Init_p[182] * localDW->dt + rtb_Init_p[185]) * g_y) -
      (rtb_Init_p[198] * localDW->dt + rtb_Init_p[201]) * rtb_Init[0] / 2.0F;

    /* '<S4>:1:291' */
    rty_nextP[73] = (((((((rtb_Init_p[22] * localDW->dt + rtb_Init_p[25]) *
                          SF_idx_3 + (rtb_Init_p[70] * localDW->dt + rtb_Init_p
      [73])) + (rtb_Init_p[6] * localDW->dt + rtb_Init_p[9]) * SF_idx_5) +
                        (rtb_Init_p[38] * localDW->dt + rtb_Init_p[41]) *
                        SPP_idx_0) - (rtb_Init_p[54] * localDW->dt + rtb_Init_p
      [57]) * SF_idx_0) + (rtb_Init_p[214] * localDW->dt + rtb_Init_p[217]) *
                      SPP_idx_3) + (rtb_Init_p[230] * localDW->dt + rtb_Init_p
      [233]) * SPP_idx_8) - (rtb_Init_p[246] * localDW->dt + rtb_Init_p[249]) *
      SPP_idx_11;

    /* '<S4>:1:292' */
    rty_nextP[89] = (((((((rtb_Init_p[6] * localDW->dt + rtb_Init_p[9]) *
                          SF_idx_4 + (rtb_Init_p[86] * localDW->dt + rtb_Init_p
      [89])) + (rtb_Init_p[38] * localDW->dt + rtb_Init_p[41]) * SF_idx_3) +
                        (rtb_Init_p[54] * localDW->dt + rtb_Init_p[57]) *
                        SF_idx_5) - (rtb_Init_p[22] * localDW->dt + rtb_Init_p
      [25]) * SPP_idx_0) + (rtb_Init_p[230] * localDW->dt + rtb_Init_p[233]) *
                      SPP_idx_2) - (rtb_Init_p[214] * localDW->dt + rtb_Init_p
      [217]) * SPP_idx_10) + (rtb_Init_p[246] * localDW->dt + rtb_Init_p[249]) *
      SF_idx_2;

    /* '<S4>:1:293' */
    rty_nextP[105] = (((((((rtb_Init_p[22] * localDW->dt + rtb_Init_p[25]) *
      SF_idx_4 + (rtb_Init_p[102] * localDW->dt + rtb_Init_p[105])) +
                          (rtb_Init_p[54] * localDW->dt + rtb_Init_p[57]) *
                          SF_idx_3) + (rtb_Init_p[6] * localDW->dt + rtb_Init_p
      [9]) * SPP_idx_0) - (rtb_Init_p[38] * localDW->dt + rtb_Init_p[41]) *
                        SPP_idx_4) - (rtb_Init_p[246] * localDW->dt +
      rtb_Init_p[249]) * SPP_idx_1) + (rtb_Init_p[214] * localDW->dt +
      rtb_Init_p[217]) * SF_idx_1) - (rtb_Init_p[230] * localDW->dt +
      rtb_Init_p[233]) * SPP_idx_9;

    /* '<S4>:1:294' */
    rty_nextP[121] = (rtb_Init_p[70] * localDW->dt + rtb_Init_p[73]) *
      localDW->dt + (rtb_Init_p[118] * localDW->dt + rtb_Init_p[121]);

    /* '<S4>:1:295' */
    rty_nextP[137] = (rtb_Init_p[86] * localDW->dt + rtb_Init_p[89]) *
      localDW->dt + (rtb_Init_p[134] * localDW->dt + rtb_Init_p[137]);

    /* '<S4>:1:296' */
    rty_nextP[153] = (rtb_Init_p[102] * localDW->dt + rtb_Init_p[105]) *
      localDW->dt + (rtb_Init_p[150] * localDW->dt + rtb_Init_p[153]);

    /* '<S4>:1:297' */
    rty_nextP[169] = rtb_Init_p[166] * localDW->dt + rtb_Init_p[169];

    /* '<S4>:1:298' */
    rty_nextP[185] = rtb_Init_p[182] * localDW->dt + rtb_Init_p[185];

    /* '<S4>:1:299' */
    rty_nextP[201] = rtb_Init_p[198] * localDW->dt + rtb_Init_p[201];

    /* '<S4>:1:300' */
    rty_nextP[217] = rtb_Init_p[214] * localDW->dt + rtb_Init_p[217];

    /* '<S4>:1:301' */
    rty_nextP[233] = rtb_Init_p[230] * localDW->dt + rtb_Init_p[233];

    /* '<S4>:1:302' */
    rty_nextP[249] = rtb_Init_p[246] * localDW->dt + rtb_Init_p[249];

    /* '<S4>:1:303' */
    rty_nextP[10] = (((((rtb_Init_p[26] * SF_idx_9 + rtb_Init_p[10]) +
                        rtb_Init_p[42] * SF_idx_11) + rtb_Init_p[58] * SF_idx_10)
                      + rtb_Init_p[170] * g_y) + rtb_Init_p[186] * h_y) +
      rtb_Init_p[202] * SF_idx_16;

    /* '<S4>:1:304' */
    rty_nextP[26] = (((((rtb_Init_p[10] * SF_idx_8 + rtb_Init_p[26]) +
                        rtb_Init_p[42] * SF_idx_7) + rtb_Init_p[58] * SF_idx_11)
                      - rtb_Init_p[202] * h_y) + rtb_Init_p[186] * SF_idx_16) -
      rtb_Init_p[170] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:305' */
    rty_nextP[42] = (((((rtb_Init_p[10] * SF_idx_6 + rtb_Init_p[42]) +
                        rtb_Init_p[26] * SF_idx_10) + rtb_Init_p[58] * SF_idx_8)
                      + rtb_Init_p[202] * g_y) - rtb_Init_p[170] * SF_idx_16) -
      rtb_Init_p[186] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:306' */
    rty_nextP[58] = (((((rtb_Init_p[10] * SF_idx_7 + rtb_Init_p[58]) +
                        rtb_Init_p[26] * SF_idx_6) + rtb_Init_p[42] * SF_idx_9)
                      + rtb_Init_p[170] * h_y) - rtb_Init_p[186] * g_y) -
      rtb_Init_p[202] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:307' */
    rty_nextP[74] = ((((((rtb_Init_p[26] * SF_idx_3 + rtb_Init_p[74]) +
                         rtb_Init_p[10] * SF_idx_5) + rtb_Init_p[42] * SPP_idx_0)
                       - rtb_Init_p[58] * SF_idx_0) + rtb_Init_p[218] *
                      SPP_idx_3) + rtb_Init_p[234] * SPP_idx_8) - rtb_Init_p[250]
      * SPP_idx_11;

    /* '<S4>:1:308' */
    rty_nextP[90] = ((((((rtb_Init_p[10] * SF_idx_4 + rtb_Init_p[90]) +
                         rtb_Init_p[42] * SF_idx_3) + rtb_Init_p[58] * SF_idx_5)
                       - rtb_Init_p[26] * SPP_idx_0) + rtb_Init_p[234] *
                      SPP_idx_2) + rtb_Init_p[250] * SF_idx_2) - rtb_Init_p[218]
      * SPP_idx_10;

    /* '<S4>:1:309' */
    rty_nextP[106] = ((((((rtb_Init_p[26] * SF_idx_4 + rtb_Init_p[106]) +
                          rtb_Init_p[58] * SF_idx_3) + rtb_Init_p[10] *
                         SPP_idx_0) - rtb_Init_p[42] * SPP_idx_4) - rtb_Init_p
                       [250] * SPP_idx_1) + rtb_Init_p[218] * SF_idx_1) -
      rtb_Init_p[234] * SPP_idx_9;

    /* '<S4>:1:310' */
    rty_nextP[122] = rtb_Init_p[74] * localDW->dt + rtb_Init_p[122];

    /* '<S4>:1:311' */
    rty_nextP[138] = rtb_Init_p[90] * localDW->dt + rtb_Init_p[138];

    /* '<S4>:1:312' */
    rty_nextP[154] = rtb_Init_p[106] * localDW->dt + rtb_Init_p[154];

    /* '<S4>:1:313' */
    rty_nextP[170] = rtb_Init_p[170];

    /* '<S4>:1:314' */
    rty_nextP[186] = rtb_Init_p[186];

    /* '<S4>:1:315' */
    rty_nextP[202] = rtb_Init_p[202];

    /* '<S4>:1:316' */
    rty_nextP[218] = rtb_Init_p[218];

    /* '<S4>:1:317' */
    rty_nextP[234] = rtb_Init_p[234];

    /* '<S4>:1:318' */
    rty_nextP[250] = rtb_Init_p[250];

    /* '<S4>:1:319' */
    rty_nextP[11] = (((((rtb_Init_p[27] * SF_idx_9 + rtb_Init_p[11]) +
                        rtb_Init_p[43] * SF_idx_11) + rtb_Init_p[59] * SF_idx_10)
                      + rtb_Init_p[171] * g_y) + rtb_Init_p[187] * h_y) +
      rtb_Init_p[203] * SF_idx_16;

    /* '<S4>:1:320' */
    rty_nextP[27] = (((((rtb_Init_p[11] * SF_idx_8 + rtb_Init_p[27]) +
                        rtb_Init_p[43] * SF_idx_7) + rtb_Init_p[59] * SF_idx_11)
                      - rtb_Init_p[203] * h_y) + rtb_Init_p[187] * SF_idx_16) -
      rtb_Init_p[171] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:321' */
    rty_nextP[43] = (((((rtb_Init_p[11] * SF_idx_6 + rtb_Init_p[43]) +
                        rtb_Init_p[27] * SF_idx_10) + rtb_Init_p[59] * SF_idx_8)
                      + rtb_Init_p[203] * g_y) - rtb_Init_p[171] * SF_idx_16) -
      rtb_Init_p[187] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:322' */
    rty_nextP[59] = (((((rtb_Init_p[11] * SF_idx_7 + rtb_Init_p[59]) +
                        rtb_Init_p[27] * SF_idx_6) + rtb_Init_p[43] * SF_idx_9)
                      + rtb_Init_p[171] * h_y) - rtb_Init_p[187] * g_y) -
      rtb_Init_p[203] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:323' */
    rty_nextP[75] = ((((((rtb_Init_p[27] * SF_idx_3 + rtb_Init_p[75]) +
                         rtb_Init_p[11] * SF_idx_5) + rtb_Init_p[43] * SPP_idx_0)
                       - rtb_Init_p[59] * SF_idx_0) + rtb_Init_p[219] *
                      SPP_idx_3) + rtb_Init_p[235] * SPP_idx_8) - rtb_Init_p[251]
      * SPP_idx_11;

    /* '<S4>:1:324' */
    rty_nextP[91] = ((((((rtb_Init_p[11] * SF_idx_4 + rtb_Init_p[91]) +
                         rtb_Init_p[43] * SF_idx_3) + rtb_Init_p[59] * SF_idx_5)
                       - rtb_Init_p[27] * SPP_idx_0) + rtb_Init_p[235] *
                      SPP_idx_2) + rtb_Init_p[251] * SF_idx_2) - rtb_Init_p[219]
      * SPP_idx_10;

    /* '<S4>:1:325' */
    rty_nextP[107] = ((((((rtb_Init_p[27] * SF_idx_4 + rtb_Init_p[107]) +
                          rtb_Init_p[59] * SF_idx_3) + rtb_Init_p[11] *
                         SPP_idx_0) - rtb_Init_p[43] * SPP_idx_4) - rtb_Init_p
                       [251] * SPP_idx_1) + rtb_Init_p[219] * SF_idx_1) -
      rtb_Init_p[235] * SPP_idx_9;

    /* '<S4>:1:326' */
    rty_nextP[123] = rtb_Init_p[75] * localDW->dt + rtb_Init_p[123];

    /* '<S4>:1:327' */
    rty_nextP[139] = rtb_Init_p[91] * localDW->dt + rtb_Init_p[139];

    /* '<S4>:1:328' */
    rty_nextP[155] = rtb_Init_p[107] * localDW->dt + rtb_Init_p[155];

    /* '<S4>:1:329' */
    rty_nextP[171] = rtb_Init_p[171];

    /* '<S4>:1:330' */
    rty_nextP[187] = rtb_Init_p[187];

    /* '<S4>:1:331' */
    rty_nextP[203] = rtb_Init_p[203];

    /* '<S4>:1:332' */
    rty_nextP[219] = rtb_Init_p[219];

    /* '<S4>:1:333' */
    rty_nextP[235] = rtb_Init_p[235];

    /* '<S4>:1:334' */
    rty_nextP[251] = rtb_Init_p[251];

    /* '<S4>:1:335' */
    rty_nextP[12] = (((((rtb_Init_p[28] * SF_idx_9 + rtb_Init_p[12]) +
                        rtb_Init_p[44] * SF_idx_11) + rtb_Init_p[60] * SF_idx_10)
                      + rtb_Init_p[172] * g_y) + rtb_Init_p[188] * h_y) +
      rtb_Init_p[204] * SF_idx_16;

    /* '<S4>:1:336' */
    rty_nextP[28] = (((((rtb_Init_p[12] * SF_idx_8 + rtb_Init_p[28]) +
                        rtb_Init_p[44] * SF_idx_7) + rtb_Init_p[60] * SF_idx_11)
                      - rtb_Init_p[204] * h_y) + rtb_Init_p[188] * SF_idx_16) -
      rtb_Init_p[172] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:337' */
    rty_nextP[44] = (((((rtb_Init_p[12] * SF_idx_6 + rtb_Init_p[44]) +
                        rtb_Init_p[28] * SF_idx_10) + rtb_Init_p[60] * SF_idx_8)
                      + rtb_Init_p[204] * g_y) - rtb_Init_p[172] * SF_idx_16) -
      rtb_Init_p[188] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:338' */
    rty_nextP[60] = (((((rtb_Init_p[12] * SF_idx_7 + rtb_Init_p[60]) +
                        rtb_Init_p[28] * SF_idx_6) + rtb_Init_p[44] * SF_idx_9)
                      + rtb_Init_p[172] * h_y) - rtb_Init_p[188] * g_y) -
      rtb_Init_p[204] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:339' */
    rty_nextP[76] = ((((((rtb_Init_p[28] * SF_idx_3 + rtb_Init_p[76]) +
                         rtb_Init_p[12] * SF_idx_5) + rtb_Init_p[44] * SPP_idx_0)
                       - rtb_Init_p[60] * SF_idx_0) + rtb_Init_p[220] *
                      SPP_idx_3) + rtb_Init_p[236] * SPP_idx_8) - rtb_Init_p[252]
      * SPP_idx_11;

    /* '<S4>:1:340' */
    rty_nextP[92] = ((((((rtb_Init_p[12] * SF_idx_4 + rtb_Init_p[92]) +
                         rtb_Init_p[44] * SF_idx_3) + rtb_Init_p[60] * SF_idx_5)
                       - rtb_Init_p[28] * SPP_idx_0) + rtb_Init_p[236] *
                      SPP_idx_2) + rtb_Init_p[252] * SF_idx_2) - rtb_Init_p[220]
      * SPP_idx_10;

    /* '<S4>:1:341' */
    rty_nextP[108] = ((((((rtb_Init_p[28] * SF_idx_4 + rtb_Init_p[108]) +
                          rtb_Init_p[60] * SF_idx_3) + rtb_Init_p[12] *
                         SPP_idx_0) - rtb_Init_p[44] * SPP_idx_4) - rtb_Init_p
                       [252] * SPP_idx_1) + rtb_Init_p[220] * SF_idx_1) -
      rtb_Init_p[236] * SPP_idx_9;

    /* '<S4>:1:342' */
    rty_nextP[124] = rtb_Init_p[76] * localDW->dt + rtb_Init_p[124];

    /* '<S4>:1:343' */
    rty_nextP[140] = rtb_Init_p[92] * localDW->dt + rtb_Init_p[140];

    /* '<S4>:1:344' */
    rty_nextP[156] = rtb_Init_p[108] * localDW->dt + rtb_Init_p[156];

    /* '<S4>:1:345' */
    rty_nextP[172] = rtb_Init_p[172];

    /* '<S4>:1:346' */
    rty_nextP[188] = rtb_Init_p[188];

    /* '<S4>:1:347' */
    rty_nextP[204] = rtb_Init_p[204];

    /* '<S4>:1:348' */
    rty_nextP[220] = rtb_Init_p[220];

    /* '<S4>:1:349' */
    rty_nextP[236] = rtb_Init_p[236];

    /* '<S4>:1:350' */
    rty_nextP[252] = rtb_Init_p[252];

    /* '<S4>:1:351' */
    rty_nextP[13] = (((((rtb_Init_p[29] * SF_idx_9 + rtb_Init_p[13]) +
                        rtb_Init_p[45] * SF_idx_11) + rtb_Init_p[61] * SF_idx_10)
                      + rtb_Init_p[173] * g_y) + rtb_Init_p[189] * h_y) +
      rtb_Init_p[205] * SF_idx_16;

    /* '<S4>:1:352' */
    rty_nextP[29] = (((((rtb_Init_p[13] * SF_idx_8 + rtb_Init_p[29]) +
                        rtb_Init_p[45] * SF_idx_7) + rtb_Init_p[61] * SF_idx_11)
                      - rtb_Init_p[205] * h_y) + rtb_Init_p[189] * SF_idx_16) -
      rtb_Init_p[173] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:353' */
    rty_nextP[45] = (((((rtb_Init_p[13] * SF_idx_6 + rtb_Init_p[45]) +
                        rtb_Init_p[29] * SF_idx_10) + rtb_Init_p[61] * SF_idx_8)
                      + rtb_Init_p[205] * g_y) - rtb_Init_p[173] * SF_idx_16) -
      rtb_Init_p[189] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:354' */
    rty_nextP[61] = (((((rtb_Init_p[13] * SF_idx_7 + rtb_Init_p[61]) +
                        rtb_Init_p[29] * SF_idx_6) + rtb_Init_p[45] * SF_idx_9)
                      + rtb_Init_p[173] * h_y) - rtb_Init_p[189] * g_y) -
      rtb_Init_p[205] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:355' */
    rty_nextP[77] = ((((((rtb_Init_p[29] * SF_idx_3 + rtb_Init_p[77]) +
                         rtb_Init_p[13] * SF_idx_5) + rtb_Init_p[45] * SPP_idx_0)
                       - rtb_Init_p[61] * SF_idx_0) + rtb_Init_p[221] *
                      SPP_idx_3) + rtb_Init_p[237] * SPP_idx_8) - rtb_Init_p[253]
      * SPP_idx_11;

    /* '<S4>:1:356' */
    rty_nextP[93] = ((((((rtb_Init_p[13] * SF_idx_4 + rtb_Init_p[93]) +
                         rtb_Init_p[45] * SF_idx_3) + rtb_Init_p[61] * SF_idx_5)
                       - rtb_Init_p[29] * SPP_idx_0) + rtb_Init_p[237] *
                      SPP_idx_2) + rtb_Init_p[253] * SF_idx_2) - rtb_Init_p[221]
      * SPP_idx_10;

    /* '<S4>:1:357' */
    rty_nextP[109] = ((((((rtb_Init_p[29] * SF_idx_4 + rtb_Init_p[109]) +
                          rtb_Init_p[61] * SF_idx_3) + rtb_Init_p[13] *
                         SPP_idx_0) - rtb_Init_p[45] * SPP_idx_4) - rtb_Init_p
                       [253] * SPP_idx_1) + rtb_Init_p[221] * SF_idx_1) -
      rtb_Init_p[237] * SPP_idx_9;

    /* '<S4>:1:358' */
    rty_nextP[125] = rtb_Init_p[77] * localDW->dt + rtb_Init_p[125];

    /* '<S4>:1:359' */
    rty_nextP[141] = rtb_Init_p[93] * localDW->dt + rtb_Init_p[141];

    /* '<S4>:1:360' */
    rty_nextP[157] = rtb_Init_p[109] * localDW->dt + rtb_Init_p[157];

    /* '<S4>:1:361' */
    rty_nextP[173] = rtb_Init_p[173];

    /* '<S4>:1:362' */
    rty_nextP[189] = rtb_Init_p[189];

    /* '<S4>:1:363' */
    rty_nextP[205] = rtb_Init_p[205];

    /* '<S4>:1:364' */
    rty_nextP[221] = rtb_Init_p[221];

    /* '<S4>:1:365' */
    rty_nextP[237] = rtb_Init_p[237];

    /* '<S4>:1:366' */
    rty_nextP[253] = rtb_Init_p[253];

    /* '<S4>:1:367' */
    rty_nextP[14] = (((((rtb_Init_p[30] * SF_idx_9 + rtb_Init_p[14]) +
                        rtb_Init_p[46] * SF_idx_11) + rtb_Init_p[62] * SF_idx_10)
                      + rtb_Init_p[174] * g_y) + rtb_Init_p[190] * h_y) +
      rtb_Init_p[206] * SF_idx_16;

    /* '<S4>:1:368' */
    rty_nextP[30] = (((((rtb_Init_p[14] * SF_idx_8 + rtb_Init_p[30]) +
                        rtb_Init_p[46] * SF_idx_7) + rtb_Init_p[62] * SF_idx_11)
                      - rtb_Init_p[206] * h_y) + rtb_Init_p[190] * SF_idx_16) -
      rtb_Init_p[174] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:369' */
    rty_nextP[46] = (((((rtb_Init_p[14] * SF_idx_6 + rtb_Init_p[46]) +
                        rtb_Init_p[30] * SF_idx_10) + rtb_Init_p[62] * SF_idx_8)
                      + rtb_Init_p[206] * g_y) - rtb_Init_p[174] * SF_idx_16) -
      rtb_Init_p[190] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:370' */
    rty_nextP[62] = (((((rtb_Init_p[14] * SF_idx_7 + rtb_Init_p[62]) +
                        rtb_Init_p[30] * SF_idx_6) + rtb_Init_p[46] * SF_idx_9)
                      + rtb_Init_p[174] * h_y) - rtb_Init_p[190] * g_y) -
      rtb_Init_p[206] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:371' */
    rty_nextP[78] = ((((((rtb_Init_p[30] * SF_idx_3 + rtb_Init_p[78]) +
                         rtb_Init_p[14] * SF_idx_5) + rtb_Init_p[46] * SPP_idx_0)
                       - rtb_Init_p[62] * SF_idx_0) + rtb_Init_p[222] *
                      SPP_idx_3) + rtb_Init_p[238] * SPP_idx_8) - rtb_Init_p[254]
      * SPP_idx_11;

    /* '<S4>:1:372' */
    rty_nextP[94] = ((((((rtb_Init_p[14] * SF_idx_4 + rtb_Init_p[94]) +
                         rtb_Init_p[46] * SF_idx_3) + rtb_Init_p[62] * SF_idx_5)
                       - rtb_Init_p[30] * SPP_idx_0) + rtb_Init_p[238] *
                      SPP_idx_2) + rtb_Init_p[254] * SF_idx_2) - rtb_Init_p[222]
      * SPP_idx_10;

    /* '<S4>:1:373' */
    rty_nextP[110] = ((((((rtb_Init_p[30] * SF_idx_4 + rtb_Init_p[110]) +
                          rtb_Init_p[62] * SF_idx_3) + rtb_Init_p[14] *
                         SPP_idx_0) - rtb_Init_p[46] * SPP_idx_4) - rtb_Init_p
                       [254] * SPP_idx_1) + rtb_Init_p[222] * SF_idx_1) -
      rtb_Init_p[238] * SPP_idx_9;

    /* '<S4>:1:374' */
    rty_nextP[126] = rtb_Init_p[78] * localDW->dt + rtb_Init_p[126];

    /* '<S4>:1:375' */
    rty_nextP[142] = rtb_Init_p[94] * localDW->dt + rtb_Init_p[142];

    /* '<S4>:1:376' */
    rty_nextP[158] = rtb_Init_p[110] * localDW->dt + rtb_Init_p[158];

    /* '<S4>:1:377' */
    rty_nextP[174] = rtb_Init_p[174];

    /* '<S4>:1:378' */
    rty_nextP[190] = rtb_Init_p[190];

    /* '<S4>:1:379' */
    rty_nextP[206] = rtb_Init_p[206];

    /* '<S4>:1:380' */
    rty_nextP[222] = rtb_Init_p[222];

    /* '<S4>:1:381' */
    rty_nextP[238] = rtb_Init_p[238];

    /* '<S4>:1:382' */
    rty_nextP[254] = rtb_Init_p[254];

    /* '<S4>:1:383' */
    rty_nextP[15] = (((((rtb_Init_p[31] * SF_idx_9 + rtb_Init_p[15]) +
                        rtb_Init_p[47] * SF_idx_11) + rtb_Init_p[63] * SF_idx_10)
                      + rtb_Init_p[175] * g_y) + rtb_Init_p[191] * h_y) +
      rtb_Init_p[207] * SF_idx_16;

    /* '<S4>:1:384' */
    rty_nextP[31] = (((((rtb_Init_p[15] * SF_idx_8 + rtb_Init_p[31]) +
                        rtb_Init_p[47] * SF_idx_7) + rtb_Init_p[63] * SF_idx_11)
                      - rtb_Init_p[207] * h_y) + rtb_Init_p[191] * SF_idx_16) -
      rtb_Init_p[175] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:385' */
    rty_nextP[47] = (((((rtb_Init_p[15] * SF_idx_6 + rtb_Init_p[47]) +
                        rtb_Init_p[31] * SF_idx_10) + rtb_Init_p[63] * SF_idx_8)
                      + rtb_Init_p[207] * g_y) - rtb_Init_p[175] * SF_idx_16) -
      rtb_Init_p[191] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:386' */
    rty_nextP[63] = (((((rtb_Init_p[15] * SF_idx_7 + rtb_Init_p[63]) +
                        rtb_Init_p[31] * SF_idx_6) + rtb_Init_p[47] * SF_idx_9)
                      + rtb_Init_p[175] * h_y) - rtb_Init_p[191] * g_y) -
      rtb_Init_p[207] * rtb_Init[0] / 2.0F;

    /* '<S4>:1:387' */
    rty_nextP[79] = ((((((rtb_Init_p[31] * SF_idx_3 + rtb_Init_p[79]) +
                         rtb_Init_p[15] * SF_idx_5) + rtb_Init_p[47] * SPP_idx_0)
                       - rtb_Init_p[63] * SF_idx_0) + rtb_Init_p[223] *
                      SPP_idx_3) + rtb_Init_p[239] * SPP_idx_8) - rtb_Init_p[255]
      * SPP_idx_11;

    /* '<S4>:1:388' */
    rty_nextP[95] = ((((((rtb_Init_p[15] * SF_idx_4 + rtb_Init_p[95]) +
                         rtb_Init_p[47] * SF_idx_3) + rtb_Init_p[63] * SF_idx_5)
                       - rtb_Init_p[31] * SPP_idx_0) + rtb_Init_p[239] *
                      SPP_idx_2) + rtb_Init_p[255] * SF_idx_2) - rtb_Init_p[223]
      * SPP_idx_10;

    /* '<S4>:1:389' */
    rty_nextP[111] = ((((((rtb_Init_p[31] * SF_idx_4 + rtb_Init_p[111]) +
                          rtb_Init_p[63] * SF_idx_3) + rtb_Init_p[15] *
                         SPP_idx_0) - rtb_Init_p[47] * SPP_idx_4) - rtb_Init_p
                       [255] * SPP_idx_1) + rtb_Init_p[223] * SF_idx_1) -
      rtb_Init_p[239] * SPP_idx_9;

    /* '<S4>:1:390' */
    rty_nextP[127] = rtb_Init_p[79] * localDW->dt + rtb_Init_p[127];

    /* '<S4>:1:391' */
    rty_nextP[143] = rtb_Init_p[95] * localDW->dt + rtb_Init_p[143];

    /* '<S4>:1:392' */
    rty_nextP[159] = rtb_Init_p[111] * localDW->dt + rtb_Init_p[159];

    /* '<S4>:1:393' */
    rty_nextP[175] = rtb_Init_p[175];

    /* '<S4>:1:394' */
    rty_nextP[191] = rtb_Init_p[191];

    /* '<S4>:1:395' */
    rty_nextP[207] = rtb_Init_p[207];

    /* '<S4>:1:396' */
    rty_nextP[223] = rtb_Init_p[223];

    /* '<S4>:1:397' */
    rty_nextP[239] = rtb_Init_p[239];

    /* '<S4>:1:398' */
    rty_nextP[255] = rtb_Init_p[255];

    /*  Add the process noise */
    /* '<S4>:1:403' */
    for (posHealth = 0; posHealth < 16; posHealth++) {
      /* '<S4>:1:403' */
      /* '<S4>:1:404' */
      rty_nextP[posHealth + (posHealth << 4U)] += processNoise[posHealth];

      /* '<S4>:1:403' */
    }

    /*  If the total position variance exceds 1E6 (1000m), then stop covariance */
    /*  growth by setting the predicted to the previous values */
    /*  This prevent an ill conditioned matrix from occurring for long periods */
    /*  without GPS */
    if (rtb_Init_p[119] + rtb_Init_p[136] > 1.0E+6F) {
      /* '<S4>:1:412' */
      /* '<S4>:1:413' */
      for (rowIndex = 0; rowIndex < 16; rowIndex++) {
        rty_nextP[7 + (rowIndex << 4U)] = rtb_Init_p[(rowIndex << 4U) + 7];
        rty_nextP[8 + (rowIndex << 4U)] = rtb_Init_p[(rowIndex << 4U) + 8];
      }

      /* '<S4>:1:414' */
      for (rowIndex = 0; rowIndex < 2; rowIndex++) {
        for (bestStoreIndex = 0; bestStoreIndex < 16; bestStoreIndex++) {
          rty_nextP[bestStoreIndex + ((7 + rowIndex) << 4U)] = rtb_Init_p[((7 +
            rowIndex) << 4U) + bestStoreIndex];
        }
      }
    }

    /*  Force symmetry on the covariance matrix to prevent ill-conditioning */
    /*  of the matrix which would cause the filter to blow-up */
    /* '<S4>:1:419' */
    for (posHealth = 0; posHealth < 15; posHealth++) {
      /* '<S4>:1:419' */
      /* '<S4>:1:420' */
      for (bestStoreIndex = 0; bestStoreIndex <= posHealth; bestStoreIndex++) {
        /* '<S4>:1:420' */
        /* '<S4>:1:421' */
        dAngBiasSigma = (rty_nextP[((bestStoreIndex << 4U) + posHealth) + 1] +
                         rty_nextP[((posHealth + 1) << 4U) + bestStoreIndex]) *
          0.5F;

        /* '<S4>:1:422' */
        rty_nextP[(posHealth + (bestStoreIndex << 4U)) + 1] = dAngBiasSigma;

        /* '<S4>:1:423' */
        rty_nextP[bestStoreIndex + ((posHealth + 1) << 4U)] = dAngBiasSigma;

        /* '<S4>:1:420' */
      }

      /* '<S4>:1:419' */
    }

    /*  reset the accumulated values */
    /* '<S4>:1:428' */
    /* '<S4>:1:429' */
    localDW->storedDelAng[0] = 0.0F;
    localDW->storedDelVel[0] = 0.0F;
    localDW->storedDelAng[1] = 0.0F;
    localDW->storedDelVel[1] = 0.0F;
    localDW->storedDelAng[2] = 0.0F;
    localDW->storedDelVel[2] = 0.0F;

    /* '<S4>:1:430' */
    localDW->dt = 0.0F;
  } else {
    /* '<S4>:1:433' */
    memcpy(&rty_nextP[0], &rtb_Init_p[0], sizeof(real32_T) << 8U);
  }

  /* End of MATLAB Function: '<S1>/Predict Covariance' */

  /* MATLAB Function: '<S1>/Store States' */
  /* MATLAB Function 'kalmanFiter/Store States': '<S9>:1' */
  if (localDW->index > 50.0) {
    /* '<S9>:1:20' */
    /* '<S9>:1:21' */
    localDW->index = 1.0;
  }

  /* '<S9>:1:23' */
  for (posHealth = 0; posHealth < 16; posHealth++) {
    /* '<S9>:1:23' */
    /* '<S9>:1:24' */
    localDW->statesStore[posHealth + (((int16_T)localDW->index - 1) << 4U)] =
      rtb_Init[posHealth];

    /* '<S9>:1:23' */
  }

  /* '<S9>:1:26' */
  tmp_1 = rt_roundd(rt_roundd(rtu_time * 1000.0));
  if (tmp_1 < 4.294967296E+9) {
    if (tmp_1 >= 0.0) {
      localDW->msecStore[(int16_T)localDW->index - 1] = (uint32_T)tmp_1;
    } else {
      localDW->msecStore[(int16_T)localDW->index - 1] = 0UL;
    }
  } else {
    localDW->msecStore[(int16_T)localDW->index - 1] = ((uint32_T)(0xFFFFFFFFU));
  }

  /* '<S9>:1:27' */
  localDW->index++;

  /* MATLAB Function: '<S1>/Recall States1' incorporates:
   *  Constant: '<S1>/delay1'
   *  MATLAB Function: '<S1>/Store States'
   */
  /* '<S9>:1:29' */
  /* '<S9>:1:30' */
  /* MATLAB Function 'kalmanFiter/Recall States1': '<S6>:1' */
  /* '<S6>:1:7' */
  bestTimeDelta = 300;

  /* '<S6>:1:8' */
  bestStoreIndex = 0;
  if (rtu_gpsDataArrived) {
    /* '<S6>:1:9' */
    /* '<S6>:1:10' */
    for (posHealth = 0; posHealth < 50; posHealth++) {
      /* '<S6>:1:10' */
      /* '<S6>:1:11' */
      tmp_1 = rt_roundd(rtu_time * 1000.0);
      if (tmp_1 < 2.147483648E+9) {
        if (tmp_1 >= -2.147483648E+9) {
          timeDelta = (int32_T)tmp_1;
        } else {
          timeDelta = ((int32_T)(-2147483647-1));
        }
      } else {
        timeDelta = ((int32_T)(2147483647));
      }

      tmp_2 = timeDelta - 300LL;
      if (tmp_2 > 2147483647LL) {
        tmp_2 = 2147483647LL;
      } else {
        if (tmp_2 < -2147483648LL) {
          tmp_2 = -2147483648LL;
        }
      }

      tmp_3 = localDW->msecStore[posHealth];
      if (localDW->msecStore[posHealth] > 2147483647UL) {
        tmp_3 = 2147483647UL;
      }

      tmp_2 = (int64_T)(int32_T)tmp_2 - tmp_3;
      if (tmp_2 > 2147483647LL) {
        tmp_2 = 2147483647LL;
      } else {
        if (tmp_2 < -2147483648LL) {
          tmp_2 = -2147483648LL;
        }
      }

      timeDelta = (int32_T)tmp_2;
      if (timeDelta < 0L) {
        /* '<S6>:1:12' */
        /* '<S6>:1:13' */
        if (timeDelta <= ((int32_T)(-2147483647-1))) {
          timeDelta = ((int32_T)(2147483647));
        } else {
          timeDelta = -timeDelta;
        }
      }

      if ((uint32_T)timeDelta < (uint32_T)bestTimeDelta) {
        /* '<S6>:1:15' */
        /* '<S6>:1:16' */
        bestStoreIndex = posHealth;

        /* '<S6>:1:17' */
        bestTimeDelta = (int16_T)timeDelta;
      }

      /* '<S6>:1:10' */
    }

    if (bestTimeDelta < 300) {
      /* '<S6>:1:20' */
      /*  only output stored state if time accuracy better than just outputtting current states */
      /* '<S6>:1:21' */
      for (posHealth = 0; posHealth < 16; posHealth++) {
        /* '<S6>:1:21' */
        /* '<S6>:1:22' */
        localDW->statesForFusion_i[posHealth] = localDW->statesStore
          [(bestStoreIndex << 4U) + posHealth];

        /* '<S6>:1:21' */
      }
    } else {
      /*  otherwise output current state */
      /* '<S6>:1:25' */
      for (posHealth = 0; posHealth < 16; posHealth++) {
        /* '<S6>:1:25' */
        /* '<S6>:1:26' */
        localDW->statesForFusion_i[posHealth] = rty_nextStates[posHealth];

        /* '<S6>:1:25' */
      }
    }
  }

  /* MATLAB Function: '<S1>/Recall States2' incorporates:
   *  Constant: '<S1>/delay2'
   *  MATLAB Function: '<S1>/Store States'
   */
  /* '<S6>:1:30' */
  /* '<S6>:1:31' */
  /* MATLAB Function 'kalmanFiter/Recall States2': '<S7>:1' */
  /* '<S7>:1:7' */
  bestTimeDelta = 300;

  /* '<S7>:1:8' */
  bestStoreIndex = 0;
  if (rtu_gpsDataArrived) {
    /* '<S7>:1:9' */
    /* '<S7>:1:10' */
    for (posHealth = 0; posHealth < 50; posHealth++) {
      /* '<S7>:1:10' */
      /* '<S7>:1:11' */
      tmp_1 = rt_roundd(rtu_time * 1000.0);
      if (tmp_1 < 2.147483648E+9) {
        if (tmp_1 >= -2.147483648E+9) {
          timeDelta = (int32_T)tmp_1;
        } else {
          timeDelta = ((int32_T)(-2147483647-1));
        }
      } else {
        timeDelta = ((int32_T)(2147483647));
      }

      tmp_2 = timeDelta - 300LL;
      if (tmp_2 > 2147483647LL) {
        tmp_2 = 2147483647LL;
      } else {
        if (tmp_2 < -2147483648LL) {
          tmp_2 = -2147483648LL;
        }
      }

      tmp_3 = localDW->msecStore[posHealth];
      if (localDW->msecStore[posHealth] > 2147483647UL) {
        tmp_3 = 2147483647UL;
      }

      tmp_2 = (int64_T)(int32_T)tmp_2 - tmp_3;
      if (tmp_2 > 2147483647LL) {
        tmp_2 = 2147483647LL;
      } else {
        if (tmp_2 < -2147483648LL) {
          tmp_2 = -2147483648LL;
        }
      }

      timeDelta = (int32_T)tmp_2;
      if (timeDelta < 0L) {
        /* '<S7>:1:12' */
        /* '<S7>:1:13' */
        if (timeDelta <= ((int32_T)(-2147483647-1))) {
          timeDelta = ((int32_T)(2147483647));
        } else {
          timeDelta = -timeDelta;
        }
      }

      if ((uint32_T)timeDelta < (uint32_T)bestTimeDelta) {
        /* '<S7>:1:15' */
        /* '<S7>:1:16' */
        bestStoreIndex = posHealth;

        /* '<S7>:1:17' */
        bestTimeDelta = (int16_T)timeDelta;
      }

      /* '<S7>:1:10' */
    }

    if (bestTimeDelta < 300) {
      /* '<S7>:1:20' */
      /*  only output stored state if time accuracy better than just outputtting current states */
      /* '<S7>:1:21' */
      for (posHealth = 0; posHealth < 16; posHealth++) {
        /* '<S7>:1:21' */
        /* '<S7>:1:22' */
        localDW->statesForFusion_m[posHealth] = localDW->statesStore
          [(bestStoreIndex << 4U) + posHealth];

        /* '<S7>:1:21' */
      }
    } else {
      /*  otherwise output current state */
      /* '<S7>:1:25' */
      for (posHealth = 0; posHealth < 16; posHealth++) {
        /* '<S7>:1:25' */
        /* '<S7>:1:26' */
        localDW->statesForFusion_m[posHealth] = rty_nextStates[posHealth];

        /* '<S7>:1:25' */
      }
    }
  }

  /* MATLAB Function: '<S1>/Recall States3' incorporates:
   *  Constant: '<S1>/delay3'
   *  MATLAB Function: '<S1>/Store States'
   */
  /* '<S7>:1:30' */
  /* '<S7>:1:31' */
  /* MATLAB Function 'kalmanFiter/Recall States3': '<S8>:1' */
  /* '<S8>:1:7' */
  bestTimeDelta = 420;

  /* '<S8>:1:8' */
  bestStoreIndex = 0;
  if (rtu_hgtDataArrived) {
    /* '<S8>:1:9' */
    /* '<S8>:1:10' */
    for (posHealth = 0; posHealth < 50; posHealth++) {
      /* '<S8>:1:10' */
      /* '<S8>:1:11' */
      tmp_1 = rt_roundd(rtu_time * 1000.0);
      if (tmp_1 < 2.147483648E+9) {
        if (tmp_1 >= -2.147483648E+9) {
          timeDelta = (int32_T)tmp_1;
        } else {
          timeDelta = ((int32_T)(-2147483647-1));
        }
      } else {
        timeDelta = ((int32_T)(2147483647));
      }

      tmp_2 = timeDelta - 420LL;
      if (tmp_2 > 2147483647LL) {
        tmp_2 = 2147483647LL;
      } else {
        if (tmp_2 < -2147483648LL) {
          tmp_2 = -2147483648LL;
        }
      }

      tmp_3 = localDW->msecStore[posHealth];
      if (localDW->msecStore[posHealth] > 2147483647UL) {
        tmp_3 = 2147483647UL;
      }

      tmp_2 = (int64_T)(int32_T)tmp_2 - tmp_3;
      if (tmp_2 > 2147483647LL) {
        tmp_2 = 2147483647LL;
      } else {
        if (tmp_2 < -2147483648LL) {
          tmp_2 = -2147483648LL;
        }
      }

      timeDelta = (int32_T)tmp_2;
      if (timeDelta < 0L) {
        /* '<S8>:1:12' */
        /* '<S8>:1:13' */
        if (timeDelta <= ((int32_T)(-2147483647-1))) {
          timeDelta = ((int32_T)(2147483647));
        } else {
          timeDelta = -timeDelta;
        }
      }

      if ((uint32_T)timeDelta < (uint32_T)bestTimeDelta) {
        /* '<S8>:1:15' */
        /* '<S8>:1:16' */
        bestStoreIndex = posHealth;

        /* '<S8>:1:17' */
        bestTimeDelta = (int16_T)timeDelta;
      }

      /* '<S8>:1:10' */
    }

    if (bestTimeDelta < 420) {
      /* '<S8>:1:20' */
      /*  only output stored state if time accuracy better than just outputtting current states */
      /* '<S8>:1:21' */
      for (posHealth = 0; posHealth < 16; posHealth++) {
        /* '<S8>:1:21' */
        /* '<S8>:1:22' */
        localDW->statesForFusion[posHealth] = localDW->statesStore
          [(bestStoreIndex << 4U) + posHealth];

        /* '<S8>:1:21' */
      }
    } else {
      /*  otherwise output current state */
      /* '<S8>:1:25' */
      for (posHealth = 0; posHealth < 16; posHealth++) {
        /* '<S8>:1:25' */
        /* '<S8>:1:26' */
        localDW->statesForFusion[posHealth] = rty_nextStates[posHealth];

        /* '<S8>:1:25' */
      }
    }
  }

  /* MATLAB Function: '<S1>/Fuse Vel Pos Measurements' incorporates:
   *  MATLAB Function: '<S1>/Recall States1'
   *  MATLAB Function: '<S1>/Recall States2'
   *  MATLAB Function: '<S1>/Recall States3'
   */
  /* '<S8>:1:30' */
  /* '<S8>:1:31' */
  for (i = 0; i < 16; i++) {
    rtb_Init[i] = rty_nextStates[i];
  }

  memcpy(&rtb_Init_p[0], &rty_nextP[0], sizeof(real32_T) << 8U);

  /* MATLAB Function 'kalmanFiter/Fuse Vel Pos Measurements': '<S3>:1' */
  /*  % state vector after fusion of measurements (q0, ... , q3, VelN,E,D, PosN,E,D, WindN,E, P0, camera roll pitch yaw misalignment) */
  /*  % state covariance matrix after fusion of corrections */
  /*  % NED velocity and NED position innovations (m/s, m) */
  /*  % NED velocity and NED position innovation variance ((m/s)^2, m^2) */
  /*  % predicted states from the INS (q0, ... , q3, VelN,E,D, PosN,E,D, WindN,E, P0, camera roll pitch yaw misalignment) */
  /*  % predicted covariance */
  /*  % magnitude of rate of change of velocity in navigation frame (m/s^2) */
  /*  % Boolean to initiate fusion of velocity measurements */
  /*  % NED velocity measurements (m/s) */
  /*  % States captured at GPs measurement time */
  /*  % Boolean to initiate fusion of position measurements */
  /*  % NE position measurements (m) */
  /*  % States captured at GPs measurement time */
  /*  % Boolean to initiate fusion of height measurements */
  /*  % D position measurement (m) */
  /*  States captured at height measurement time */
  /*  define persistent variables */
  /*  initialise measurement health flags to false */
  /* '<S3>:1:37' */
  bestStoreIndex = 0;

  /* '<S3>:1:38' */
  posHealth = 0;

  /* '<S3>:1:39' */
  bestTimeDelta = 0;

  /*  Specify GPS velocity induced error */
  /* '<S3>:1:42' */
  dAngBiasSigma = 0.15F * rotationMag;

  /* '<S3>:1:43' */
  rotationMag *= 0.15F;

  /*  Specify the GPS and height measurement variances. */
  /* '<S3>:1:45' */
  R_OBS[0] = dAngBiasSigma * dAngBiasSigma + 0.01F;
  R_OBS[1] = dAngBiasSigma * dAngBiasSigma + 0.01F;
  R_OBS[2] = dAngBiasSigma * dAngBiasSigma + 0.01F;
  R_OBS[3] = rotationMag * rotationMag + 4.0F;
  R_OBS[4] = rotationMag * rotationMag + 4.0F;
  R_OBS[5] = 4.0F;

  /*  Specify the count before forcing use of GPS or height data after invalid */
  /*  data. We need to force GPS again sooner without */
  /*  airspeed data as the nav velocities will be unconstrained. */
  /* '<S3>:1:53' */
  /* '<S3>:1:55' */
  /*  initialise the innovation vector */
  /* '<S3>:1:58' */
  /*  initialise the innovation variance vector */
  /* '<S3>:1:61' */
  for (i = 0; i < 6; i++) {
    rty_innovation[i] = 0.0F;
    rty_varInnov[i] = 0.0F;
  }

  /*  Define the observation vector */
  /* '<S3>:1:64' */
  observation[0] = rtu_VelNED[0];
  observation[1] = rtu_VelNED[1];
  observation[2] = rtu_VelNED[2];
  observation[3] = rtu_PosNE[0];
  observation[4] = rtu_PosNE[1];
  observation[5] = -rtu_HgtMea;

  /*  Perform sequential fusion of GPS and height measurements. This assumes that the */
  /*  errors in the dfferent velocity and position componenets are */
  /*  uncorrelated which is not true, however in the absence of covariance */
  /*  data from the GPS receiver it is the only assumption we can make */
  /*  so we might as well take advantage of the computational efficiencies */
  /*  associated with sequential fusion */
  if (rtu_gpsDataArrived || rtu_hgtDataArrived) {
    /* '<S3>:1:72' */
    /*  calculate innovation variances */
    /* '<S3>:1:74' */
    for (i = 0; i < 6; i++) {
      /* '<S3>:1:74' */
      /* '<S3>:1:75' */
      /* '<S3>:1:76' */
      rty_varInnov[i] = rty_nextP[(((4 + i) << 4U) + i) + 4] + R_OBS[i];

      /* '<S3>:1:74' */
    }

    /*  calculate innovations and check validity against limits */
    if (rtu_gpsDataArrived) {
      /* '<S3>:1:79' */
      /* '<S3>:1:80' */
      rtb_correctedDelAng[0] = localDW->statesForFusion_i[4] - rtu_VelNED[0];
      rtb_correctedDelAng[1] = localDW->statesForFusion_i[5] - rtu_VelNED[1];
      rtb_correctedDelAng[2] = localDW->statesForFusion_i[6] - rtu_VelNED[2];
      if (((rtb_correctedDelAng[0] * rtb_correctedDelAng[0] +
            rtb_correctedDelAng[1] * rtb_correctedDelAng[1]) +
           rtb_correctedDelAng[2] * rtb_correctedDelAng[2] < ((rty_varInnov[0] +
             rty_varInnov[1]) + rty_varInnov[2]) * 25.0F) ||
          (localDW->velFailCount > 250UL)) {
        /* '<S3>:1:81' */
        /* '<S3>:1:82' */
        /* '<S3>:1:83' */
        bestStoreIndex = 1;

        /* '<S3>:1:84' */
        localDW->velFailCount = 0UL;
      } else {
        /* '<S3>:1:86' */
        /* '<S3>:1:87' */
        tmp_0 = localDW->velFailCount + 1ULL;
        if (tmp_0 > 4294967295ULL) {
          tmp_0 = 4294967295ULL;
        }

        localDW->velFailCount = (uint32_T)tmp_0;
      }

      /* '<S3>:1:90' */
      /* '<S3>:1:91' */
      rotationMag = localDW->statesForFusion_m[7] - rtu_PosNE[0];
      dAngBiasSigma = localDW->statesForFusion_m[8] - rtu_PosNE[1];
      if ((rotationMag * rotationMag + dAngBiasSigma * dAngBiasSigma <
           (rty_varInnov[3] + rty_varInnov[4]) * 100.0F) ||
          (localDW->posFailCount > 250UL)) {
        /* '<S3>:1:92' */
        /* '<S3>:1:93' */
        /* '<S3>:1:94' */
        posHealth = 1;

        /* '<S3>:1:95' */
        localDW->posFailCount = 0UL;
      } else {
        /* '<S3>:1:97' */
        /* '<S3>:1:98' */
        tmp_0 = localDW->posFailCount + 1ULL;
        if (tmp_0 > 4294967295ULL) {
          tmp_0 = 4294967295ULL;
        }

        localDW->posFailCount = (uint32_T)tmp_0;
      }

      /* '<S3>:1:101' */
      /* '<S3>:1:102' */
      rotationMag = localDW->statesForFusion[9] + rtu_HgtMea;
      if ((rotationMag * rotationMag < 25.0F * rty_varInnov[5]) ||
          (localDW->hgtFailCount > 1500UL)) {
        /* '<S3>:1:103' */
        /* '<S3>:1:104' */
        /* '<S3>:1:105' */
        bestTimeDelta = 1;

        /* '<S3>:1:106' */
        localDW->hgtFailCount = 0UL;
      } else {
        /* '<S3>:1:108' */
        /* '<S3>:1:109' */
        tmp_0 = localDW->hgtFailCount + 1ULL;
        if (tmp_0 > 4294967295ULL) {
          tmp_0 = 4294967295ULL;
        }

        localDW->hgtFailCount = (uint32_T)tmp_0;
      }
    }

    /*  Set range for sequential fusion of velocity and position measurements */
    /* '<S3>:1:113' */
    for (rowIndex = 0; rowIndex < 6; rowIndex++) {
      fuseData[rowIndex] = 0;
    }

    if (rtu_gpsDataArrived) {
      /* '<S3>:1:114' */
      /* '<S3>:1:115' */
      fuseData[0] = 1;

      /* '<S3>:1:116' */
      fuseData[1] = 1;

      /* '<S3>:1:117' */
      fuseData[2] = 1;

      /* '<S3>:1:119' */
      /* '<S3>:1:120' */
      fuseData[3] = 1;

      /* '<S3>:1:121' */
      fuseData[4] = 1;
    }

    if (rtu_hgtDataArrived) {
      /* '<S3>:1:123' */
      /* '<S3>:1:124' */
      fuseData[5] = 1;
    }

    /*  Fuse measurements sequentially */
    /* '<S3>:1:127' */
    for (i = 0; i < 6; i++) {
      /* '<S3>:1:127' */
      if ((fuseData[i] != 0) && (((bestStoreIndex != 0) && (1 + i <= 3)) ||
           ((posHealth != 0) && ((1 + i == 4) || (1 + i == 5))) ||
           ((bestTimeDelta != 0) && (1 + i == 6)))) {
        /*  Apply data health checks */
        /*  If no airspeed data, start using GPS data after x seconds */
        /* '<S3>:1:131' */
        /* '<S3>:1:132' */
        /* '<S3>:1:133' */
        /* '<S3>:1:134' */
        /*  Calculate the measurement innovation, using states from the */
        /*  appropriate time coordinate */
        /* '<S3>:1:137' */
        if (1 + i <= 3) {
          /* '<S3>:1:137' */
          /* '<S3>:1:138' */
          rty_innovation[i] = localDW->statesForFusion_i[4 + i] - observation[i];
        } else if ((1 + i == 4) || (1 + i == 5)) {
          /* '<S3>:1:139' */
          /* '<S3>:1:140' */
          rty_innovation[i] = localDW->statesForFusion_m[4 + i] - observation[i];
        } else if (1 + i == 6) {
          /* '<S3>:1:141' */
          /* '<S3>:1:142' */
          rty_innovation[i] = localDW->statesForFusion[4 + i] - observation[i];
        } else {
          /* '<S3>:1:144' */
          rty_innovation[i] = 0.0F;
        }

        /*  Calculate the Kalman Gain */
        /* '<S3>:1:148' */
        rty_varInnov[i] = rtb_Init_p[(((4 + i) << 4U) + i) + 4] + R_OBS[i];

        /*  data logging only */
        /* '<S3>:1:149' */
        rotationMag = 1.0F / rty_varInnov[i];

        /* '<S3>:1:150' */
        /*  Calculate state corrections */
        /* '<S3>:1:152' */
        /*  Update the covariance - take advantage of direct observation of a */
        /*  single state at stateIndex */
        /* P = (I - K*H)*P; */
        /* '<S3>:1:156' */
        /* '<S3>:1:157' */
        for (rowIndex = 0; rowIndex < 16; rowIndex++) {
          K[rowIndex] = rtb_Init_p[((i + 4) << 4U) + rowIndex] * rotationMag;

          /* '<S3>:1:157' */
          /* '<S3>:1:158' */
          for (colIndex = 0; colIndex < 16; colIndex++) {
            /* '<S3>:1:158' */
            /* '<S3>:1:159' */
            KHP[rowIndex + (colIndex << 4U)] = rtb_Init_p[((colIndex << 4U) + i)
              + 4] * K[rowIndex];

            /* '<S3>:1:158' */
          }

          /* '<S3>:1:157' */
        }

        /* '<S3>:1:162' */
        for (rowIndex = 0; rowIndex < 256; rowIndex++) {
          rtb_Init_p[rowIndex] -= KHP[rowIndex];
        }

        /*  Apply the state corrections and re-normaliase the quaternions */
        /* '<S3>:1:164' */
        rotationMag = rty_innovation[i];
        for (rowIndex = 0; rowIndex < 16; rowIndex++) {
          rtb_Init[rowIndex] -= K[rowIndex] * rotationMag;
        }

        /*  Normalise the quaternion states */
        /* '<S3>:1:166' */
        rotationMag = (real32_T)sqrt(((rtb_Init[0] * rtb_Init[0] + rtb_Init[1] *
          rtb_Init[1]) + rtb_Init[2] * rtb_Init[2]) + rtb_Init[3] * rtb_Init[3]);
        if (rotationMag > 1.0E-12) {
          /* '<S3>:1:167' */
          /* '<S3>:1:168' */
          rtb_Init[0] /= rotationMag;
          rtb_Init[1] /= rotationMag;
          rtb_Init[2] /= rotationMag;
          rtb_Init[3] /= rotationMag;
        }
      }

      /* '<S3>:1:127' */
    }
  }

  /* End of MATLAB Function: '<S1>/Fuse Vel Pos Measurements' */

  /* Update for UnitDelay: '<S10>/FixPt Unit Delay2' incorporates:
   *  Constant: '<S10>/FixPt Constant'
   */
  /*  Output covariance matrix and state vector */
  /* '<S3>:1:175' */
  /* '<S3>:1:176' */
  localDW->FixPtUnitDelay2_DSTATE = 0U;

  /* Update for UnitDelay: '<S10>/FixPt Unit Delay1' */
  for (i = 0; i < 16; i++) {
    /* Switch: '<S10>/Reset' */
    if (rtu_reset) {
      localDW->FixPtUnitDelay1_DSTATE[i] = rtu_statesInit[i];
    } else {
      localDW->FixPtUnitDelay1_DSTATE[i] = rtb_Init[i];
    }

    /* End of Switch: '<S10>/Reset' */
  }

  /* End of Update for UnitDelay: '<S10>/FixPt Unit Delay1' */

  /* Update for UnitDelay: '<S11>/FixPt Unit Delay2' incorporates:
   *  Constant: '<S11>/FixPt Constant'
   */
  localDW->FixPtUnitDelay2_DSTATE_n = 0U;

  /* Switch: '<S11>/Reset' */
  if (rtu_reset) {
    /* Update for UnitDelay: '<S11>/FixPt Unit Delay1' */
    memcpy(&localDW->FixPtUnitDelay1_DSTATE_d[0], &localDW->covariance[0],
           sizeof(real32_T) << 8U);
  } else {
    /* Update for UnitDelay: '<S11>/FixPt Unit Delay1' */
    memcpy(&localDW->FixPtUnitDelay1_DSTATE_d[0], &rtb_Init_p[0], sizeof
           (real32_T) << 8U);
  }

  /* End of Switch: '<S11>/Reset' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
