#include <stdio.h>
#include <string.h>
#include <xdc/std.h>    // MultiProc.h needs the type definitions
#include <c6x.h>  // required for DNUM - see http://e2e.ti.com/support/dsp/c6000_multi-core_dsps/f/439/t/128906.aspx
#include <ti/ipc/MultiProc.h>
#include <ti/sysbios/hal/Cache.h>

/**
 * hello.c
 */
int main(int argc, char *argv[])
{
	printf("Hello World!\n");
	
	return 0;
}

Void setMyId()
{
    UInt16 procId;
    Char procName[6];

    // This section of code ensures that we are setting the core names as CORE0, CORE1, etc
    // in the .cfg file. See ti/sdo/utils/MultiProc.xdc in index.html cdoc file for your IPC version.

    /* Determine the procName from DNUM */
    strcpy (procName, "CORE0");
    // Set the "name" of the Core.
    procName[4] += DNUM;        // CORE0 becomes CORE1, ...2, ...3, etc.

    /* Translate from a procName to a procId */
    procId = MultiProc_getId(procName);

    if(MultiProc_getNumProcessors() <= DNUM)
    {
#if 0
        // DNUM should always be less than 8 for the C6678, 4 for the C6674, 6 for the C6472
        strcpy((char*)gErrorInfo.fileName, __FILE__);
        gErrorInfo.lineNum = __LINE__;
        gErrorInfo.errorType = ERROR_TYPE_IPC_CREATE_ERR;
        gErrorInfo.arg = DNUM;
        Cache_wbInv(&gErrorInfo, sizeof(SpDsp_ErrorInfo), Cache_Type_ALL, TRUE);
#endif
        while(1);
    }

    // Check for a name match error with the namelist created by Multiproc.setConfig in the .cfg file.
    // Since SRIO is not setup at this point, we cannot inform
    // the CPU that there is a problem. This is NOT an issue since an error in the .cfg file will
    // be caught during the compile-build-test phase. Once the error is corrected in the .cfg file,
    // the error will not occur at production time.
    // WARNING: An assert here does not work because we have not entered main yet. We must
    // write to the error stucture directly.
    if(procId != (Uint16)DNUM)
    {
#if 0
        strcpy((char*)gErrorInfo.fileName, __FILE__);
        gErrorInfo.lineNum = __LINE__;
        gErrorInfo.errorType = ERROR_TYPE_IPC_CREATE_ERR;
        gErrorInfo.arg = procId;
        Cache_wbInv(&gErrorInfo, sizeof(SpDsp_ErrorInfo), Cache_Type_ALL, TRUE);
#endif
        while(1);
    }

    // Set processor ID based on DNUM (do this just in case we run into the synchronous breakpoint
    // issue discovered by EJP (see history below). If the synchronous breakpoint problem pleagues you,
    // Comment out the assert until you are ready to release. Then reboot CCS and your board. Hopefully
    // the problem will go away.
    MultiProc_setLocalId(DNUM);
}
