#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "platform.h"

#include "math.h"

#define DEVICE_REG32_W(x,y)   *(volatile uint32_t *)(x)=(y)
#define DEVICE_REG32_R(x)    (*(volatile uint32_t *)(x))

#define CHIP_LEVEL_REG  0x02620000
#define KICK0           (CHIP_LEVEL_REG + 0x0038)
#define KICK1           (CHIP_LEVEL_REG + 0x003C)

/* Magic address RBL is polling */
#define MAGIC_ADDR          0x87fffc

#define BOOT_MAGIC_ADDR(x)  (MAGIC_ADDR + (1<<28) + (x<<24))
#define IPCGR(x)            (0x02620240 + x*4)

extern far uint32_t _c_int00;

volatile double ddr_test[1000];
#pragma DATA_SECTION(ddr_test, ".data_in_DDR3")
#pragma DATA_ALIGN(ddr_test, 64);


unsigned int i, j, k, int_temp;
#pragma DATA_SECTION(i, ".data_in_L2")
#pragma DATA_ALIGN(i, 64);

double x_floor;
#pragma DATA_SECTION(x_floor, ".data_in_L2")
#pragma DATA_ALIGN(x_floor, 64);

char string_for_integer_number[10];
#pragma DATA_SECTION(string_for_integer_number, ".data_in_L2")
#pragma DATA_ALIGN(string_for_integer_number, 64);

#define BOOT_UART_BAUDRATE         115200


char version[] = "Test of function  ============ (60_22_29_3) \r\n";


// OSAL functions for Platform Library
uint8_t *Osal_platformMalloc (uint32_t num_bytes, uint32_t alignment)
{
	return malloc(num_bytes);
}

void Osal_platformFree (uint8_t *dataPtr, uint32_t num_bytes)
{
    // Free up the memory
    if (dataPtr)
    {
        free(dataPtr);
    }
}

void Osal_platformSpiCsEnter(void)
{
    return;
}

void Osal_platformSpiCsExit (void)
{
    return;
}

//------------------------------------------
// Function:    print_platform_errno
//------------------------------------------
void
print_platform_errno
(
    void
)
{
    printf ("Returned platform error number is %d\n", platform_errno);
}

//--------------------------------------------
// Function:    write_uart
//--------------------------------------------
void
write_uart
(
    char*      msg
)
{
    uint32_t i;
    uint32_t msg_len = strlen(msg);

    // Write the message to the UART
    for (i = 0; i < msg_len; i++)
    {
        platform_uart_write(msg[i]);
    }
}


void itoa(int n, char s[])
{
    int i, sign, j;
    char c;
    //int temp;

    if ((sign = n) < 0)
        n = -n;
    i = 0;
    do {
        s[i++] = n % 10 + '0';
    } while ((n /= 10) > 0);
    if (sign < 0)
        s[i++] = '-';
    s[i] = '\0';

    for (i = 0, j = strlen(s)-1; i<j; i++, j--)
    {
        c = s[i];
        s[i] = s[j];
        s[j] = c;
    }
}

#include <c6x.h>

void start_boot(void)
{
    void                (*exit)();
    uint32_t            entry_addr;

    while(1)
    {
        entry_addr = DEVICE_REG32_R(BOOT_MAGIC_ADDR(0));
        if (entry_addr != 0)
        {
            /* jump to the exit point, which will be the entry point for the full IBL */
            exit = (void (*)())entry_addr;
            (*exit)();
        }
        platform_delay(1);
    }
}


/******************************************************************************
 * Function:    main
 ******************************************************************************/
void main ()
{
 TSCL = 0;

 if (DNUM == 0)
 {
			// Initialize UART
	platform_uart_init();
	platform_uart_set_baudrate(BOOT_UART_BAUDRATE);
	write_uart("\r\n\r\n  _[CORE0]_  ==  Version of the Project == ");
	write_uart(version);
	write_uart("\r\n");

    memcpy((void*)(0x11840000), (void*)0x00840000, 0x20000);

	// Unlock the chip registers
	DEVICE_REG32_W(KICK0, 0x83e70b13);
	DEVICE_REG32_W(KICK1, 0x95a4f1e0);

	DEVICE_REG32_W(BOOT_MAGIC_ADDR(1), (uint32_t)&_c_int00);
	platform_delay(1);
	DEVICE_REG32_W(IPCGR(1), 1);
	platform_delay(1000);


  x_floor = floor(3.14);

	int_temp=x_floor;
	write_uart("_[CORE0]_  x_floor = ");
	itoa(int_temp,string_for_integer_number);
	write_uart(string_for_integer_number);
	write_uart("\r\n");

 }

 if (DNUM == 1)
 {
   for(i=0; i<10000; i++) for(j=0; j<100000; j++) k=i-j;  // cycle for the delay

  x_floor = floor(3.14);

	int_temp=x_floor;
	write_uart("_[CORE1]_  x_floor = ");
	itoa(int_temp,string_for_integer_number);
	write_uart(string_for_integer_number);
	write_uart("\r\n");

  	   write_uart("_[CORE1]_  THE END     \r\n");
 }

}







