#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "platform.h"

#include "math.h"


unsigned int i, j, k, int_temp;
#pragma DATA_SECTION(i, ".data_in_L2")
#pragma DATA_ALIGN(i, 64);

double x_floor;
#pragma DATA_SECTION(x_floor, ".data_in_L2")
#pragma DATA_ALIGN(x_floor, 64);

char string_for_integer_number[10];
#pragma DATA_SECTION(string_for_integer_number, ".data_in_L2")
#pragma DATA_ALIGN(string_for_integer_number, 64);

#define BOOT_UART_BAUDRATE         115200

char version[] = "Test of function  ============ (60_22_29_4) \r\n";


// OSAL functions for Platform Library
uint8_t *Osal_platformMalloc (uint32_t num_bytes, uint32_t alignment)
{
	return malloc(num_bytes);
}

void Osal_platformFree (uint8_t *dataPtr, uint32_t num_bytes)
{
    // Free up the memory
    if (dataPtr)
    {
        free(dataPtr);
    }
}

void Osal_platformSpiCsEnter(void)
{
    return;
}

void Osal_platformSpiCsExit (void)
{
    return;
}

//------------------------------------------
// Function:    print_platform_errno
//------------------------------------------
void
print_platform_errno
(
    void
)
{
    printf ("Returned platform error number is %d\n", platform_errno);
}

//--------------------------------------------
// Function:    write_uart
//--------------------------------------------
void
write_uart
(
    char*      msg
)
{
    uint32_t i;
    uint32_t msg_len = strlen(msg);

    // Write the message to the UART
    for (i = 0; i < msg_len; i++)
    {
        platform_uart_write(msg[i]);
    }
}


void itoa(int n, char s[])
{
    int i, sign, j;
    char c;
    //int temp;

    if ((sign = n) < 0)
        n = -n;
    i = 0;
    do {
        s[i++] = n % 10 + '0';
    } while ((n /= 10) > 0);
    if (sign < 0)
        s[i++] = '-';
    s[i] = '\0';

    for (i = 0, j = strlen(s)-1; i<j; i++, j--)
    {
        c = s[i];
        s[i] = s[j];
        s[j] = c;
    }
}

#include <c6x.h>

/******************************************************************************
 * Function:    main
 ******************************************************************************/
void main ()
{
 TSCL = 0;

 if (DNUM == 0)
 {
			// Initialize UART
	platform_uart_init();
	platform_uart_set_baudrate(BOOT_UART_BAUDRATE);
	write_uart("\r\n\r\n  _[CORE0]_  ==  Version of the Project == ");
	write_uart(version);
	write_uart("\r\n");

  x_floor = floor(3.14);

	int_temp=x_floor;
	write_uart("_[CORE0]_  x_floor = ");
	itoa(int_temp,string_for_integer_number);
	write_uart(string_for_integer_number);
	write_uart("\r\n");
 }


}







