//---------------------------------------------------------------------------
#ifndef typeDefsH
#define typeDefsH
//---------------------------------------------------------------------------

typedef char            I8;
typedef unsigned char   U8;
typedef int             I16;
typedef unsigned short  U16;
typedef unsigned int    dword;
typedef long            I32;
typedef unsigned long   U32;
typedef float           F32;
typedef double          F64;

typedef unsigned char byte;
typedef unsigned int word;
typedef char          *I8Ptr;

typedef unsigned char *bytePtr;
typedef unsigned char *U8Ptr;
typedef unsigned int  *wordPtr;
typedef unsigned char *byteFarPtr;
typedef unsigned char *U8FarPtr;
typedef unsigned int  *wordFarPtr;
typedef unsigned int  *U16FarPtr;
typedef unsigned long *longFarPtr;
typedef unsigned long *U32FarPtr;
typedef char          *charFarPtr;
typedef char          *I8FarPtr;


// PORT BUS DEFINITIONS

// misc command programming
typedef struct MISC_CMD_S
{
  U8   swo:  1;      // switchover control                                              
  U8   hvso: 1;      // high voltage on/off control for omni (transceiver power supply) 
  U8   sp0:  1; 
  U8   hvsr: 1;      // high voltage on/off control for RDT (transmitter power supply)     
  U8   hvsh: 1;      // half voltage on/off control                                        
  U8   mcmp: 1;      // set the compatibility multiplexer                                 
} miscCmd;

union MISC_CMD_U
{
  U8  offset;
  struct MISC_CMD_S miscCmd;
};

typedef enum
{
  ATREN = 0x01,
  CPSW  = 0x10,
  DXBSC = 0x20,
  RTEN  = 0x40,
  TOENA = 0x80,
} INTERFACE_COMMANDS_T;

typedef enum
{
  SWO   = 0x01,    
  HVSO  = 0x02,
  SLENA = 0x04,
  HVSR  = 0x08,    
  HVSH  = 0x10,    
  MCMP  = 0x20     
} MISCELLANIOUS_CONTROL_T;

typedef struct SEQUENCE_S
{
  U8    Dir3    :  2;
  U8    Dir2    :  2;
  U8    Dir1    :  2;
  U8    Dir0    :  2;
} seqNum; 

union SEQUENCE_U
{
  U8    offset;
  struct SEQUENCE_S seqNum;
};

typedef enum
{
  GREEN_LED,
  RED_LED,
//  BLACK_LED,
//  YELLOW_LED
} color;

typedef struct LED_CONTROL_S
{
  U8    Sfr     :  1;
  U8    Sfrl    :  1;
  U8    Wtc     :  1;
  U8    nWsl    :  1;
  U8    Dbgl1   :  1;
  U8    Xmbgl   :  1;
  U8    wdCntrl :  1;
  U8    wdClock :  1;
} ledCntrl; 

union LED_CONTROL_U
{
  U8    offset;
  struct LED_CONTROL_S ledCntrl;
};

typedef struct SYS_CONFIGURATION_S
{
  U8  OVLD    : 1;   // xmitter overload
  U8  XBGS    : 1;   // = 0 xmitter box present
  U8  NVSEL   : 1;   // = 0 new motherboard
  U8  SFRSW   : 1;   // mode selection switch 0
  U8  SLENA   : 1;   // serial line enabled
  U8  SWSEL   : 1;   // mode selection switch 1
  U8  RES0    : 1;   // reserved 0
  U8  RES1    : 1;   // reserved 1
} sysConfiguration;

union SYS_CONFIGURATION_U
{
  U8  offset;
  struct SYS_CONFIGURATION_S sysConfiguration;
};

typedef struct DIRECTION_S
{
  U8    tilt    :  7;
  U8    dirExt  :  1;
} order;

union XMIT_ORDER_U
{
  U8   offset;
  struct DIRECTION_S order;
};

typedef struct LED_STATE_S
{
	U8    led0State : 1;
	U8    led1State : 1;
	U8    led2State : 1;
	U8    led3State : 1;
	U8    led4State : 1;
 	U8    led5State : 1;
	U8    led6State : 1;
} ledState;
/* ********************** Debug Structure ***********************/
typedef struct MESSAGE_BUFFER_S
{
  I8    tilt;
  I8    roll;
  I8    pitch;
  U16   base;
  U16   offset;
  U8    padding;
} messageBuffer;

//typedef enum BOOLEAN_S
//{
//  hamis,
//  igaz
//} boolean;


typedef enum 
{
  OMNI_PC,   // base system mode
  OMNI64_PC, // extended system omni mode
  RDT_PC,    // extended system RDT mode
  RDTS_PC,   // extended system RDT Stabilized Pulse Count mode
  OBS_PC,    // base new system OBS mode
  OBSE_PC    // extended system OBS mode
} pulseCountModes_E;

typedef enum 
{
  NEW_MOTHERBOARD_TYPE         = 1,
  STABILIZED_MOTHERBOARD_TYPE  = 2,
  DOUBLE_TRANSFER_SPEED        = 4,
  ERROR0 =- 1
} firstHeaderBits;

typedef enum 
{
  XDCR_ATTACHED                = 1,
  XMIT_BOX0_ATTACHED           = 2,
  XMIT_BOX1_ATTACHED           = 4,
  ERROR1 =- 1
} secondHeaderBits;
/*
typedef enum 
{
  NO_XDUCER_PRESENT,
  RDT_CAPABLE_XDCR,
  OBS_CAPABLE_XDCR,
  STABILIZED_XDCR,
  ERROR2 =- 1
} quint_state;
*/
typedef enum
{
  NO_XDUCER_PRESENT,
  XDCR_CONNECTED,
  STABILIZED_XDCR,
  ERROR2 =- 1
} quint_state;


enum xdcrType_E
{
  x22kHz,
  x45kHz,
  x90kHz,
  x60kHz
};


typedef enum
{
//  OLD_MOTHERBOARD             = 0x00,
//  NEW_MOTHERBOARD             = 0x01,
  NO_XMIT_BOX                 = 0x00,
  NO_XDCR                     = 0x01,
  STAB_MOTHERBOARD            = 0x02,
  XMIT_BOX0                   = 0x04,
  XMIT_BOX1                   = 0x08,              // was 32
//  STAB_XDCR                   = 0x10,
  RDT_XDCR                    = 0x20,
  OMNI_STABILIZED_SYSTEM      = 0x40,   // was   FULLY_STABILIZED_SYSTEM = 16
  FULLY_STABILIZED_SYSTEM     = 0x80,   // was   RP_PARTIAL_SYSTEM       = 13
//  OBS_XDCR                    = 0x40,
//  PARTIAL_STABILIZED_SYSTEM   = 32,   // was   RP_STABILIZED_SYSTEM    = 12
  ERROR3 =- 1
} sysConfig_E;	

typedef enum 
{
  OMNI16_MODE,            // 0
  OMNI16N_MODE,           // 1
  OMNI64_MODE,            // 2
  RDT64_MODE,             // 3
  OBS32_MODE,             // 4
  OBS128_MODE,            // 5
  OBS_RDT64_MODE,         // 6
  OMNI_XMIT_MODE,         // 7    was   RDT_STABILIZED_MODE,    // 7                                 
  PARTIAL_XMIT_MODE,      // 8    was   PARTIAL_OMNI_MODE,      // 8 two channels connected together 
  STABILIZED_XMIT_MODE,   // 9    was   STABILIZED_OMNI_MODE,   // 9                                 
  RDT_STABILIZED_MODE,    // 10
  QUARTER_STABILIZED_TRANSMIT, // 11
  ERROR4 =- 1
} tiltDriverModes_E;

typedef enum
{
  SFR_BIT    = 0x01,         // 0
  TRTO_BIT   = 0x02,         // 1
  FMX_BIT    = 0x04,         // 2
  OVLD_BIT   = 0x08,         // 3
  MXB0_BIT   = 0x10,         // 4
  MXB1_BIT   = 0x20,         // 5
  STAB_BIT   = 0x40,         // 6
  XSTAB_BIT  = 0x80,         // 7
  ERROR5     = -1,
} hardwareStatus_E;

typedef enum
{
  OMNI_MODE,
  OBS_MODE,
  FM_MODE,
  FMS_MODE,
  RDT_MODE,
  STABILIZATION_MODE,
  STAB_TEST_MODE,
  ERROR_MODE
} modeCommands_E;

typedef enum 
{
  down,
  unchanged,
  up
} key_state;

typedef enum
{
  NO_STABILIZATION,
  OMNI_STABILIZATION,         // for STAB_MB, no XMB
  PARTIAL_STABILIZATION,      //     STAB_MB,    XMB0
  FULL_STABILIZATION,         //     STAB_MB,    XMB0, XMB1
} stabilizationMode_E;
//  HALF_CIRCLE_STABILIZATION, removed from stabilizationMode_E 2017.02.12

  typedef enum
  {
    tldT    =   0,
    tldrT   =   1, // 1
    tren0T  =   2, // 2
    tren1T  =   3, // 3
    rren0T  =   4, // 4
    rren1T  =   5, // 5
    trfrT   =   6, // 6
    recfrT  =   7, // 7
    gldT    =   8, // 8
    retrT   =   9, // 9
    ressnT  =  10, // A
    clksnT  =  11, // B
    sttltT  =  12, // C
    indT    =  13, // D
    cmdT    =  14, // E
    nLdckT  =  15  // F
  } iomapTypedefs_E;





typedef struct rb
{ U16 rrsrv;     /*   reserved         */
  U16 rvpc;      /*   vector PC        */
  U16 rpsw;      /*   PSW storage      */
  U16 rpc;       /*   PC storage       */
  U16 rds;       /*   DS or DS0        */
  U16 rss;       /*   SS               */
  U16 rps;       /*   PS               */
  U16 res;       /*   ES or DS1        */
  U16 riy;       /*   IY               */
  U16 rix;       /*   IX               */
  U16 rbp;       /*   BP               */
  U16 rsp;       /*   SP               */
  U16 rbw;       /*   BW               */
  U16 rdw;       /*   DW               */
  U16 rcw;       /*   CW               */
  U16 raw;       /*   AW               */
} rrb, *sprb;

typedef struct ms
{ U8 msc;
  U8 sfrp;
  U8 schr;
  U8 res;
  U16 msp;
  U16 mss;
} msc, *p_msc;

typedef struct
{ 
  U8 hdrb;          /*   write header                                 */
  U8 rngh;          /*   write ring number high U8                    */
  U8 rngl;          /*   write ring number low U8                     */
  U8 _01[4];
  U8 dtrd;          /*   read register (for testing)                  */
} fifo, *pf;

typedef struct
{ U16 offs;
  U16 segm;
} *vect;


#define itemDistance 15
#ifdef STRUCT_DEFINITION
typedef struct
{
    byte tldr;     /*   00 - load tilt values into counter              */
    byte _02[15];
    byte tch0;     /*   1x - load tilt values                           */
    byte tch1;
    byte tch2;
    byte tch3;
    byte tch4;
    byte tch5;
    byte tch6;
    byte tch7;
    byte tch8;
    byte tch9;
    byte tch10;
    byte tch11;
    byte tch12;
    byte tch13;
    byte tch14;
    byte tch15;
    byte tren0;    /*   20 - transmit ring enable 1                     */
    byte _03[15];
    byte tren1;    /*   30 - transmit ring enable 2                     */
    byte _04[15];
    byte rren0;    /*   40 - receive ring enable 1                      */
    byte _05[15];
    byte rren1;    /*   50 - receive ring enable 2                      */
    byte _06[15];
    byte trfr;     /*   60 - transmit frequency                         */
    byte _07[15];
    byte recfr0;   /*   70 - receive frequency                          */
    byte recfr1;   /*   71 - receive frequency for 22kHz over +6.5%     */
    byte _08[14];
    byte gld;      /*   80 - gain load                                  */
    byte _09[15];
    byte retr;     /*   90 -                                            */
    byte _10[15];
    byte ressn;    /*   A0 - reset serial number                        */
    byte _11[15];
    byte clksn;    /*   B0 - read serial number                         */
    byte _12[15];
    byte vchk;     /*   C0 - check frequency on the interface board     */
    byte _13[15];
    byte gnlm;     /*   D0 -                                            */
    byte _14[15];
		byte cmd;      /*   E0 - write data into misc_cmd latch             */
    byte _15[15];
    byte nLdck;    /*   F0 -                                            */
  } cmd_dec, *cd;
#else
  enum commands
  {
    tldrE,    // 0
    tldE,     // 1
    tren0E,   // 2
    tren1E,   // 3
    rren0E,   // 4
    rren1E,   // 5
    trfrE,    // 6
    recfrE,   // 7
    gldE,     // 8
    retrE,    // 9
    ressnE,   // A
    clksnE,   // B
    sttltE,   // C
    indE,     // D
    cmdE,     // E
    nLdckE    // F
  };


#define ITEM_LENGTH 16
#define REVISION_COUNT 1
#endif









#ifndef USING_POINTERS
typedef struct
{
  U8 tldr;
  U8 _02[63];
  U8 tch0;     /*   1x - load tilt values                             */
  U8 tch1;
  U8 tch2;
  U8 tch3;
  U8 tch4;
  U8 tch5;
  U8 tch6;
  U8 tch7;
  U8 tch8;
  U8 tch9;
  U8 tch10;
  U8 tch11;
  U8 tch12;
  U8 tch13;
  U8 tch14;
  U8 tch15;
  U8 tch16;
  U8 tch17;
  U8 tch18;
  U8 tch19;
  U8 tch20;
  U8 tch21;
  U8 tch22;
  U8 tch23;
  U8 tch24;
  U8 tch25;
  U8 tch26;
  U8 tch27;
  U8 tch28;
  U8 tch29;
  U8 tch30;
  U8 tch31;
  U8 tch32;
  U8 tch33;
  U8 tch34;
  U8 tch35;
  U8 tch36;
  U8 tch37;
  U8 tch38;
  U8 tch39;
  U8 tch40;
  U8 tch41;
  U8 tch42;
  U8 tch43;
  U8 tch44;
  U8 tch45;
  U8 tch46;
  U8 tch47;
  U8 tch48;
  U8 tch49;
  U8 tch50;
  U8 tch51;
  U8 tch52;
  U8 tch53;
  U8 tch54;
  U8 tch55;
  U8 tch56;
  U8 tch57;
  U8 tch58;
  U8 tch59;
  U8 tch60;
  U8 tch61;
  U8 tch62;
  U8 tch63;
  U8 tren0;    /*   20 - transmit ring enable 0                       */
  U8 tren1;    /*   21 - transmit ring enable 1                       */
  U8 tren2;    /*   22 - transmit ring enable 2                       */
  U8 tren3;    /*   23 - transmit ring enable 3                       */

  U8 _03[60];
  U8 tren4;    /*   30 - transmit ring enable 4                       */
  U8 tren5;    /*   31 - transmit ring enable 5                       */
  U8 tren6;    /*   32 - transmit ring enable 6                       */
  U8 tren7;    /*   33 - transmit ring enable 7                       */
  U8 _04[60];
  U8 rren0;    /*   40 - receive ring enable 1                        */
  U8 _05[63];
  U8 rren1;    /*   50 - receive ring enable 2                        */
  U8 _06[63];
  U8 trfr;     /*   60 - transmit frequency                           */
  U8 _07[63];
  U8 recfr0;   /*   70 - receive frequency                            */
  U8 recfr1;   /*   71 - receive frequency for 22kHz over +6.5%       */
  U8 _08[62];
  U8 gld;      /*   80 - gain load                                    */
  U8 _09[63];
  U8 retr;     /*   90 - not used                                     */
  U8 _10[63];
  U8 ressn;    /*   A0 - not used                                     */
  U8 _11[63];
  U8 clksn;    /*   B0 - not used                                     */
  U8 _12[63];
  U8 vchk;     /*   C0 - not used                                     */
  U8 _13[63];
  U8 gnlm;     /*   D0 - not used                                     */
  U8 _14[63];
  U8 cmd;      /*   E0 - write data into misc_cmd latch               */
  U8 _15[63];
  U8 nLdck;    /*   F0 - not used                                     */
} cmd_dec, *cd;


#endif

#ifdef UNUSED
//#else

typedef struct
{
    byte tldr0;     /*   00 - load tilt values into counter              */
    byte tldr1;
    byte _02[14];
    byte tch0;     /*   1x - load tilt values                           */
    byte tch1;
    byte tch2;
    byte tch3;
    byte tch4;
    byte tch5;
    byte tch6;
    byte tch7;
    byte tch8;
    byte tch9;
    byte tch10;
    byte tch11;
    byte tch12;
    byte tch13;
    byte tch14;
    byte tch15;
    byte tren0;    /*   20 - transmit ring enable 1                     */
    byte _03[15];
    byte tren1;    /*   30 - transmit ring enable 2                     */
    byte _04[15];
    byte rren0;    /*   40 - receive ring enable 1                      */
    byte _05[15];
    byte rren1;    /*   50 - receive ring enable 2                      */
    byte _06[15];
    byte trfr;     /*   60 - transmit frequency                         */
    byte _07[15];
    byte recfr0;   /*   70 - receive frequency                          */
    byte recfr1;   /*   71 - receive frequency for 22kHz over +6.5%     */
    byte _08[14];
    byte gld;      /*   80 - gain load                                  */
    byte _09[15];
    byte retr;     /*   90 -                                            */
    byte _10[15];
    byte ressn;    /*   A0 - reset serial number                        */
    byte _11[15];
    byte clksn;    /*   B0 - read serial number                         */
    byte _12[15];
    byte vchk;     /*   C0 - check frequency on the interface board     */
    byte _13[15];
    byte gnlm;     /*   D0 -                                            */
    byte _14[15];
    byte cmd;      /*   E0 - write data into misc_cmd latch             */
    byte _15[15];
    byte nLdck;    /*   F0 -                                            */
} cmd_dec,far *cd;
#endif


typedef struct
{
  U8 xdcr_sn;  /*   00 - load xducer's serial number                */
  U8 intf_sn;  /*   01 - load interface board's serial number       */
  U8 pwrs_sn;  /*   02 - load power supply's serial number          */
  U8 tlt0_sn;  /*   03 - load tilt 0 board's serial_number          */
  U8 tlt1_sn;  /*   04 - load tilt 1 board's serial_number          */
  U8 mux_sn;   /*   05 - load mux board's serial_number             */
  U8 rec0_sn;  /*   06 - load receiver 0 board's serial_number      */
  U8 rec1_sn;  /*   07 - load receiver 1 board's serial_number      */
  U8 tr0_sn;   /*   08 - load transmitter 0 board's serial_number   */
  U8 tr1_sn;   /*   09 - load transmitter 1 board's serial_number   */
  U8 sn9;
  U8 sn10;
  U8 sn11;
  U8 sn12;
  U8 sn13;
  U8 sn14;
  U8 sn15;
} sn_rd, *psn_rd;

typedef struct
{
  U8    p0;
  U8    pm0;
  U8    pmc0 ;
  U8    _01[5] ;

  U8    p1 ;
  U8    pm1 ;
  U8    pmc1 ;
  U8    _02[5] ;

  U8    p2 ;
  U8    pm2 ;
  U8    pmc2 ;
  U8    _03[37] ;

  U8    pt ;
  U8    _04[2] ;
  U8    pmt ;
  U8    _05[4] ;

  U8    intm ;
  U8    _06[3] ;

  U8    ems0 ;
  U8    ems1 ;
  U8    ems2 ;
  U8    _07[5] ;

  U8    exic0 ;
  U8    exic1 ;
  U8    exic2 ;
  U8    _08[17] ;

  U8    rxb0 ;
  U8    _09[1] ;
  U8    txb0 ;
  U8    _10[2] ;

  U8    srms0 ;
  U8    stms0 ;
  U8    _11[1] ;

  U8    scm0 ;
  U8    scc0 ;

  U8    brg0 ;
  U8    sce0 ;

  U8    seic0 ;
  U8    sric0 ;
  U8    stic0 ;
  U8    _12[1] ;

  U8    rxb1 ;
  U8    _13[1] ;
  U8    txb1 ;
  U8    _14[2] ;

  U8    srms1 ;
  U8    stms1 ;
  U8    _15[1] ;

  U8    scm1 ;
  U8    scc1 ;

  U8    brg1 ;
  U8    sce1 ;

  U8    seic1 ;
  U8    sric1 ;
  U8    stic1 ;
  U8    _16[1] ;

  U16    tm0 ;
  U16    md0 ;
  U16    _17[2] ;
  U16    tm1 ;
  U16    md1 ;
  U16    _18[2] ;

  U8    tmc0 ;
  U8    tmc1 ;
  U8    _19[2] ;

  U8    tmms0 ;
  U8    tmms1 ;
  U8    tmms2 ;
  U8    _20[5] ;

  U8    tmic0 ;
  U8    tmic1 ;
  U8    tmic2 ;
  U8    _21[1] ;

  U8    dmac0 ;
  U8    dmam0 ;
  U8    dmac1 ;
  U8    dmam1 ;
  U8    _22[8] ;

  U8    dic0 ;
  U8    dic1 ;
  U8    _23[50] ;

  U8    stbc ;
  U8    rfm ;
  U8    _24[6] ;

  U16    wtc ;

  U8    flag ;
  U8    prc ;
  U8    tbic ;
  U8    _25[2] ;
  U8    irqs;
  U8    _26[12] ;
  U8    ispr ;
  U8    _27[2] ;
  U8    idb ;
}  SFR,  *SFRP ;          /* Special function register layout */

typedef struct
{
  U8 rrng[2][2];
  U8 tlt[3];
}v_beam,*pv_beam;


//---------------------------------------------------------------------------
#endif

//PortA
/*
enum portAbits_E
{
  sedtBit  0,
  seclBit  1,
  sewpBit  2,
  msctBit  3,
  ind0Bit  4,
  ind1Bit  5,
  ind2Bit  6
};

#define PMC1_DATA 0x63 //  0110 0011

enum portBbits_E
{
  rdwsBit  1,   // HW interrupt from measurement control
  trtoBit  2,   // time out interrupt request from INTF board
  sext1Bit 4,   // output only 
  swslBit  5,   // INPUT  old/new jumper
  nvselBit 6,   // INPUT  old/new signal on the motherboard (J1.C4)
  nwslBit  7    // OUTPUT drives the old/new LED
};

#define PMC2_DATA 0x42 //0100 0010

enum portCbits_E
{
  sfrlBit  0,   // OUTPUT drives the single/double speed LED
  sfrsBit  1,   // INPUT  from single/double switch
  ldmsBit  2,   // OUTPUT drives the Message LED
  i2ccBit  3,   // I/O    I2C clock
  i2cdBit  4,   // I/O    I2C data bit
  sext3Bit 5,
  xmbinBit 6,   // INPUT  indicates existence (= L) of the xmitter box
  sext5Bit 7
};  

*/

