/*
 *  ======== ti_drivers_config.h ========
 *  Configured TI-Drivers module declarations
 *
 *  The macros defines herein are intended for use by applications which
 *  directly include this header. These macros should NOT be hard coded or
 *  copied into library source code.
 *
 *  Symbols declared as const are intended for use with libraries.
 *  Library source code must extern the correct symbol--which is resolved
 *  when the application is linked.
 *
 *  DO NOT EDIT - This file is generated for the CC26X2R1_LAUNCHXL
 *  by the SysConfig tool.
 */
#ifndef ti_drivers_config_h
#define ti_drivers_config_h

#define CONFIG_SYSCONFIG_PREVIEW

#define CONFIG_CC26X2R1_LAUNCHXL
#ifndef DeviceFamily_CC26X2
#define DeviceFamily_CC26X2
#endif

#include <ti/devices/DeviceFamily.h>

#include <stdint.h>

/* support C++ sources */
#ifdef __cplusplus
extern "C" {
#endif


/*
 *  ======== AESCCM ========
 */

extern const uint_least8_t          CONFIG_AESCCM0_CONST;
#define CONFIG_AESCCM0              0


/*
 *  ======== AESCTR ========
 */

extern const uint_least8_t          CONFIG_AESCTR_0_CONST;
#define CONFIG_AESCTR_0             0


/*
 *  ======== AESCTRDRBG ========
 */

extern const uint_least8_t          CONFIG_AESCTRDRBG_0_CONST;
#define CONFIG_AESCTRDRBG_0         0


/*
 *  ======== AESECB ========
 */

extern const uint_least8_t          CONFIG_AESECB0_CONST;
#define CONFIG_AESECB0              0


/*
 *  ======== ECDH ========
 */

extern const uint_least8_t          CONFIG_ECDH0_CONST;
#define CONFIG_ECDH0                0


/*
 *  ======== GPIO ========
 */

/* DIO13, LaunchPad Button BTN-1 (Left) */
extern const uint_least8_t          CONFIG_GPIO_BTN1_CONST;
#define CONFIG_GPIO_BTN1            0
/* DIO14, LaunchPad Button BTN-2 (Right) */
extern const uint_least8_t          CONFIG_GPIO_BTN2_CONST;
#define CONFIG_GPIO_BTN2            1

/* LEDs are active high */
#define CONFIG_GPIO_LED_ON  (1)
#define CONFIG_GPIO_LED_OFF (0)

#define CONFIG_LED_ON  (CONFIG_GPIO_LED_ON)
#define CONFIG_LED_OFF (CONFIG_GPIO_LED_OFF)


/*
 *  ======== NVS ========
 */

extern const uint_least8_t          CONFIG_NVSINTERNAL_CONST;
#define CONFIG_NVSINTERNAL          0


/*
 *  ======== PIN ========
 */
#include <ti/drivers/PIN.h>

extern const PIN_Config BoardGpioInitTable[];

/* XDS110 UART, Parent Signal: CONFIG_DISPLAY_UART TX, (DIO3) */
#define CONFIG_PIN_UART_TX    0x00000003
/* XDS110 UART, Parent Signal: CONFIG_DISPLAY_UART RX, (DIO2) */
#define CONFIG_PIN_UART_RX    0x00000002
/* LaunchPad Button BTN-1 (Left), Parent Signal: CONFIG_GPIO_BTN1 GPIO Pin, (DIO13) */
#define CONFIG_PIN_BTN1    0x0000000d
/* LaunchPad Button BTN-2 (Right), Parent Signal: CONFIG_GPIO_BTN2 GPIO Pin, (DIO14) */
#define CONFIG_PIN_BTN2    0x0000000e




/*
 *  ======== TRNG ========
 */

extern const uint_least8_t          CONFIG_TRNG_0_CONST;
#define CONFIG_TRNG_0               0


/*
 *  ======== UART ========
 */

/*
 *  TX: DIO3
 *  RX: DIO2
 *  XDS110 UART
 */
extern const uint_least8_t          CONFIG_DISPLAY_UART_CONST;
#define CONFIG_DISPLAY_UART         0


/*
 *  ======== Board_init ========
 *  Perform all required TI-Drivers initialization
 *
 *  This function should be called once at a point before any use of
 *  TI-Drivers.
 */
extern void Board_init(void);

/*
 *  ======== Board_initGeneral ========
 *  (deprecated)
 *
 *  Board_initGeneral() is defined purely for backward compatibility.
 *
 *  All new code should use Board_init() to do any required TI-Drivers
 *  initialization _and_ use <Driver>_init() for only where specific drivers
 *  are explicitly referenced by the application.  <Driver>_init() functions
 *  are idempotent.
 */
#define Board_initGeneral Board_init

#ifdef __cplusplus
}
#endif

#endif /* include guard */
