/** \mainpage Driver Overview
  *
  * \section section_drv_info Driver Information
  * This Sensor Controller Interface driver has been generated by the Texas Instruments Sensor Controller
  * Studio tool:
  * - <b>Project name</b>:     ADC Data Streamer for LaunchPad
  * - <b>Project file</b>:     C:/Users/a0132649/Documents/Texas Instruments/Sensor Controller Studio/examples/adc_data_streamer_launchpad/adc_data_streamer_launchpad.scp
  * - <b>Code prefix</b>:      -
  * - <b>Operating system</b>: TI-RTOS
  * - <b>Tool version</b>:     2.6.0.132
  * - <b>Tool patches</b>:     None
  * - <b>Target chip</b>:      CC2652P1F, package QFN48 7x7 RGZ, revision E (2.1)
  * - <b>Created</b>:          2020-06-18 11:56:24.298
  * - <b>Computer</b>:         LT5CD9287GXH
  * - <b>User</b>:             a0132649
  *
  * The following user-provided resource definition(s) were used to generate this driver
  * - <b>USB Emulator</b>: C:/Users/a0132649/Documents/Texas Instruments/Sensor Controller Studio/resource_defs/usb_emulator.red
  *
  * The following user-provided procedure definition(s) were used to generate this driver
  * - <b>usbEmulator()</b>: C:/Users/a0132649/Documents/Texas Instruments/Sensor Controller Studio/proc_defs/usb_emulator.prd
  *
  * Do not edit the generated source code files other than temporarily for debug purposes. Any
  * modifications will be overwritten by the Sensor Controller Studio when generating new output.
  *
  * \section section_drv_modules Driver Modules
  * The driver is divided into three modules:
  * - \ref module_scif_generic_interface, providing the API for:
  *     - Initializing and uninitializing the driver
  *     - Task control (for starting, stopping and executing Sensor Controller tasks)
  *     - Task data exchange (for producing input data to and consume output data from Sensor Controller
  *       tasks)
  * - \ref module_scif_driver_setup, containing:
  *     - The AUX RAM image (Sensor Controller code and data)
  *     - I/O mapping information
  *     - Task data structure information
  *     - Driver setup data, to be used in the driver initialization
  *     - Project-specific functionality
  * - \ref module_scif_osal, for flexible OS support:
  *     - Interfaces with the selected operating system
  *
  * It is possible to use output from multiple Sensor Controller Studio projects in one application. Only
  * one driver setup may be active at a time, but it is possible to switch between these setups. When
  * using this option, there is one instance of the \ref module_scif_generic_interface and
  * \ref module_scif_osal modules, and multiple instances of the \ref module_scif_driver_setup module.
  * This requires that:
  * - The outputs must be generated using the same version of Sensor Controller Studio
  * - The outputs must use the same operating system
  * - The outputs must use different source code prefixes (inserted into all globals of the
  *   \ref module_scif_driver_setup)
  *
  *
  * \section section_project_info Project Description
  * Demonstrates high-rate ADC sampling with storage in a circular buffer.
  * The ADC input is by default DIO23 on the LaunchPad. This signal can easily be strapped to GND or 3V3
  * with a jumper to verify that the ADC is operational.
  * 
  * The Sensor Controller wakes up the System CPU application when the sample buffer is half full.
  * The System CPU application takes blocks of 64 samples and and transfers the sum of all these samples
  * over UART, so that the data can be logged and processed on the PC.
  * 
  * See the header in the application source file ("main.c" or similar) for further details and
  * instructions. This file is located in the source code output directory.
  *
  *
  * \subsection section_io_mapping I/O Mapping
  * Task I/O functions are mapped to the following pins:
  * - ADC Data Streamer:
  *     - <b>A: Analog sensor output</b>: DIO23
  *     - <b>O: d</b>: DIO6
  *
  *
  * \section section_task_info Task Description(s)
  * This driver supports the following task(s):
  *
  *
  * \subsection section_task_desc_adc_data_streamer ADC Data Streamer
  * Samples a single ADC channel at high rate, and stores the values in a circular buffer. The System CPU
  * application is notified when the buffer is half full.
  * The task runs continuously until the System CPU application sets state.exit, using
  * fwGenQuickAlertInterrupt() for ALERT interrupt generation.
  * 
  * The System CPU application must wake up on ALERT interrupt and process available samples from
  * output.pSamples[]. The application must maintain the state.tail index variable, which indicates the
  * next sample to be read.
  *
  */




/** \addtogroup module_scif_driver_setup Driver Setup
  *
  * \section section_driver_setup_overview Overview
  *
  * This driver setup instance has been generated for:
  * - <b>Project name</b>:     ADC Data Streamer for LaunchPad
  * - <b>Code prefix</b>:      -
  *
  * The driver setup module contains the generated output from the Sensor Controller Studio project:
  * - Location of task control and scheduling data structures in AUX RAM
  * - The AUX RAM image, and the size the image
  * - Task data structure information (location, size and buffer count)
  * - I/O pin mapping translation table
  * - Task resource initialization and uninitialization functions
  * - Hooks for run-time logging
  *
  * @{
  */
#ifndef SCIF_H
#define SCIF_H

#include <stdint.h>
#include <stdbool.h>
#include "scif_framework.h"
#include "scif_osal_tirtos.h"


/// Target chip name
#define SCIF_TARGET_CHIP_NAME_CC2652P1F
/// Target chip package
#define SCIF_TARGET_CHIP_PACKAGE_QFN48_7X7_RGZ

/// Number of tasks implemented by this driver
#define SCIF_TASK_COUNT 1

/// ADC Data Streamer: Task ID
#define SCIF_ADC_DATA_STREAMER_TASK_ID 0


/// ADC Data Streamer: ADC sample buffer size
#define SCIF_ADC_DATA_STREAMER_BUFFER_SIZE 768
/// ADC Data Streamer I/O mapping: Analog sensor output
#define SCIF_ADC_DATA_STREAMER_DIO_A_SENSOR_OUTPUT 23
/// ADC Data Streamer I/O mapping: d
#define SCIF_ADC_DATA_STREAMER_DIO_O_GLED 6


// All shared data structures in AUX RAM need to be packed
#pragma pack(push, 2)


/// ADC Data Streamer: Task configuration structure
typedef struct {
    uint16_t alertThr; ///< ALERT interrupt generation threshold
} SCIF_ADC_DATA_STREAMER_CFG_T;


/// ADC Data Streamer: Task output data structure
typedef struct {
    uint16_t pSamples[768]; ///< ADC sample buffer
} SCIF_ADC_DATA_STREAMER_OUTPUT_T;


/// ADC Data Streamer: Task state structure
typedef struct {
    uint16_t alertEnabled; ///< Is ALERT interrupt generation enabled?
    uint16_t exit;         ///< Set to exit the ADC data streamer
    uint16_t head;         ///< ADC sample buffer (input) head index
    uint16_t tail;         ///< ADC sample buffer (output) tail index
} SCIF_ADC_DATA_STREAMER_STATE_T;


/// Sensor Controller task data (configuration, input buffer(s), output buffer(s) and internal state)
typedef struct {
    struct {
        SCIF_ADC_DATA_STREAMER_CFG_T cfg;
        SCIF_ADC_DATA_STREAMER_OUTPUT_T output;
        SCIF_ADC_DATA_STREAMER_STATE_T state;
    } adcDataStreamer;
} SCIF_TASK_DATA_T;

/// Sensor Controller task generic control (located in AUX RAM)
#define scifTaskData    (*((volatile SCIF_TASK_DATA_T*) 0x400E015C))


// Initialized internal driver data, to be used in the call to \ref scifInit()
extern const SCIF_DATA_T scifDriverSetup;


// Restore previous struct packing setting
#pragma pack(pop)


// AUX I/O re-initialization functions
void scifReinitTaskIo(uint32_t bvTaskIds);


// No task-specific API available


#endif
//@}


// Generated by LT5CD9287GXH at 2020-06-18 11:56:24.298
