/*
 *  main.c - goal of this sample app is to call a variety of
 *  RTS fxns...some from ROM, some from RAM.
 *  Check that e.g. if we access a fxn from ROM it truly comes from ROM
 *  and not RAM.
 */

#include <stdio.h>
#include <math.h>


char buf[10];
const char buf2[10] = {0, 2, 4, 6};
const double log10_tst = 1000.0;


void main()
{
  int i;
  double x;
  
  memset(buf, 0, sizeof(buf));    // memset should come from ROM
  memcpy(buf, buf2, sizeof(buf)); // memcpy should come from ROM
  
  // math fxns
  // log10 has some cinit -> .far hence good test
  x = log10(log10_tst);
  printf("x = %lf\n", x);

  for (i=0; i< sizeof(buf)/sizeof(char); i++) { 
    printf("buf[%d] : %d\t", i, buf[i]);   // printf & friends from RAM
  }
  printf("\n");
  
}

