#!/usr/bin/env perl
#=============================================================================
# POD Documentation First ...
#=============================================================================

=head1 NAME

elim_bss.pl

=head1 SYNOPSIS

Given an input file with a list of ALL symbols in a library, and
a 2nd input file with a list of all files which contain .bss references, this
script simply chops out all symbols from the first list if a file matches.

For example if we detect that RTS lib's trgmsg.obj has .bss contents then we
should eliminate ALL its functions from a ROM candidates list. bss is a problem
(on c6x and some other targets) because its not splittable - references
to bss from ROM need to be at fixed locations making it difficult to
merge with the user's bss.

This is a bit of a sledgehammer - if we could find a way to determine which
functions *reference* bss we could shorten the removal list. But that's tricky
so sledgehammer is used.

=head1 USAGE

perl elim_bss.pl <all_syms_file> <bss_containing_files>

=head1 PERL VERSION DETAILS

This script was written using Perl version 5.8.3.  It may not work
with earlier revisions of Perl.

=cut


use strict;
use warnings;

{ 
    my $all_syms_file = $ARGV[0] || "";
    my $bss_syms_file = $ARGV[1] || "";

    die "Error: must pass all_symbols file and bss file as args\n" if (scalar(@ARGV) < 2);
    
    open (ALL_SYMS, "<$all_syms_file") or die "Cannot open $all_syms_file: $!"; 
    my @all_syms = <ALL_SYMS>;
    close ALL_SYMS;
    
    open (BSS_SYMS, "<$bss_syms_file") or die "Cannot open $bss_syms_file: $!"; 
    my @bss_syms_info = <BSS_SYMS>;
    close BSS_SYMS;

    # if we match a bss-containing filename eliminate that file's syms/functions
    foreach my $bss_file (@bss_syms_info) {
        chomp($bss_file);
        foreach my $sym (@all_syms) {
            $sym = "\n" if ($sym =~ $bss_file);
        }
        
    }
    print @all_syms;    # all lib global symbols minus those that reference .bss
}