// This demo shows how to use the dipswitches, the push buttons and the 
// user customizable leds present on the PADK. This demo can be splitted
// into three different steps.
//
// The first step of the demo sets the LEDs DS7 to DS14 according to the 
// state of a corresponding dipswitch from the S5 array.
// The correspondences are the following:
//      DS7  - S5.1
//      DS8  - S5.2
//      DS9  - S5.3
//      DS10 - S5.4
//      DS11 - S5.5
//      DS12 - S5.6
//      DS13 - S5.7
//      DS14 - S5.8
//
// The second step sets the segments of the BCD display DS15
// according to the state of a corresponding dipswitch from the S5 array. 
// The correspondences are the following:
//      DS15.a  - S5.1
//      DS15.b  - S5.2
//      DS15.c  - S5.3
//      DS15.d  - S5.4
//      DS15.e  - S5.5
//      DS15.f  - S5.6
//      DS15.g  - S5.7
//      DS15.dp - S5.8
//
// The third step sets the LEDs bound to the UART and MIDI chips depending
// on the state of the push buttons S1 and S2.
// The correspondences are the following:
// 		S1      - DS1 and DS3
// 		S2      - DS2 and DS4
//

// CSL Modules
#include <soc.h>
#include <csl_chip.h>

// PADK Library
#include "PADK.h"

#include <stdio.h>
#include <stdlib.h>

//
//  Main Function
//
int main( int argc, char *argv[] )
{
	int i;

    /*---------------------------------------------------------------*/
    /* Chip Initialization                                           */
    /*---------------------------------------------------------------*/
	CSL_chipInit( NULL );

    /*---------------------------------------------------------------*/
    /* Reset LEDs and switches to their default values               */
    /*---------------------------------------------------------------*/
	GPIO_Reset();

    /*---------------------------------------------------------------*/
    /* Poll continuously the dipswitches and buttons states and set  */
    /* the LEDs and the BCD display depending on their state.        */
    /*---------------------------------------------------------------*/
    while(1)
    {
		// Set the LEDs DS7 to DS14 depending on the state of the 
		// dipswitches on S5
		for( i=0; i<8; i++ )
			GPIO_EnableLed( i, GPIO_GetDIPSwitch(i) );

		// Set the BCD segments depending on the state of the
		// dipswitches on S5
		GPIO_SetBCD( ( GPIO_GetDIPSwitch(7) << 7 )
					|( GPIO_GetDIPSwitch(6) << 6 )
					|( GPIO_GetDIPSwitch(5) << 5 )
					|( GPIO_GetDIPSwitch(4) << 4 )
					|( GPIO_GetDIPSwitch(3) << 3 )
					|( GPIO_GetDIPSwitch(2) << 2 )
					|( GPIO_GetDIPSwitch(1) << 1 )
					|( GPIO_GetDIPSwitch(0) << 0 ) );

		// Read the status of the 2 buttons S1 and S2 and set the
		// status of the UART and MIDI LEDs accordingly
		UART_EnableLed1( GPIO_GetPushButton(1) );
		MIDI_EnableLed1( GPIO_GetPushButton(1) );
		UART_EnableLed2( GPIO_GetPushButton(2) );
		MIDI_EnableLed2( GPIO_GetPushButton(2) );
    }
}
