/**============================================================================
*@file flashBurn.c
*@path $(CSLPATH)
*@desc This file contains the code that implements a secondary boot load
*      for Antara device.
*
*==============================================================================
* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
* Use of this software us controlled by the terms and conditions found in the
* license agreement under which this software has been supplied
*=============================================================================*/
#include <stdio.h>
#include "PADK.h"

unsigned int convert(char *hexChar);

FILE *aisIn;
char *Filename = "C:\\Lyrtech\\PADK\\dsp\\demos\\TMS320C672xxBootUtils\\Examples\\chibesa_may_22\\SwitchesandLeds\\Debug\\SwitchesandLeds_far_sdram.ais";
unsigned int AisStream[0x2000];
unsigned int count;
char value[20];
char dummy[80];
unsigned int readBack = 0x000000;
int error, errorCnt;
int offset;
int ndx;

void main(void) {
   
   aisIn = fopen(Filename, "r");
   count = 0;
   offset = 0;
   errorCnt = 0;
   error = 0;

      *(unsigned int *)(0xF0000010) = 0x40A60531;

   if (aisIn) {
       printf ("Opened AIS file, %s\n", Filename);
       while ((fgets(dummy, 80 , aisIn)!= NULL) && (errorCnt == 0)) {
           AisStream[count] = convert(dummy);
		   if (count < 10) {
		      printf("AisStream[%d] = 0x%08X\n",count, AisStream[count]);
		   }
		   count++;
           if (count >= 0x1FFF) {
		      printf ("Writing Page of FLASH\n");
		      error = FLASH_Write( offset, (unsigned char *)&AisStream[0], count * 4 );
              if (!error) {
                 FLASH_Read( offset, (unsigned char *)&readBack, 4 );
                 if (readBack != AisStream[0]) {
				     errorCnt++;
                 }   

              } else {
			    errorCnt++;
              }
			
			 offset += count * 4;
			 count = 0;
		  }
      }

   
      if (count !=0 ) {
         printf ("Writing Last Segment to FLASH, AisStream[0] = 0x%08X, count = 0x%08X\n",AisStream[0], count);
         error = FLASH_Write( offset, (unsigned char *)&AisStream[0], count * 4 );
         if (!error) {
             FLASH_Read( offset, (unsigned char *)&readBack, 4 );
             if (readBack != AisStream[0]) {
   	            errorCnt++;
             }   
          } else {
	         errorCnt++;
          }
      }

      if (errorCnt == 0) {
          printf ("FLASH Programming Complete\n");
      } else {
         printf ("Error writing to FLASH, error code = %d\n", error);
      }
  } else {
	  printf ("Couldn't open file, %s\n",Filename);
  }
  fclose(aisIn);
}

unsigned int convert(char *hexChar) {
  unsigned short i;
  unsigned char ch;
  unsigned int value = 0;
  char *localPtr;
  char localString[16];


  // Skip first two chars (0x)
  sscanf(hexChar, "%s", &localString);
//  printf("localString :%s:\n",localString);
  localPtr = &localString[0];
  ++localPtr;
  ++localPtr;
  for(i = 0; i< 8; ++i) {
    ch = *(unsigned char *)localPtr;
	if ((ch >= 'A') && (ch <= 'F')) {
	   value = (value << 4) + 10 + (unsigned int) (ch - 'A');
	} else {
	   value = (value << 4) + (unsigned int) (ch - '0');
	}
    ++localPtr;
  }
  return value;
 }  

  
