// This is a modified version of the Switches and Leds Demo provided
// with Lyrtech PADK.
//
// This demo Blinks LED 1
//
/*===========================================================================*/
/* This software is provided under the following                             */
/* License Agreement:                                                        */
/*===========================================================================*/
/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
/* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
/* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
/* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
/* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
/* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
/* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
/* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
/* YOUR USE OF THE PROGRAM.                                                  */
/*                                                                           */
/* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
/* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
/* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
/* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
/* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
/* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
/* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
/* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
/* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
/* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
/* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
/* (U.S.$500).                                                               */
/*                                                                           */
/* Unless otherwise stated, the Program written and copyrighted              */
/* by Texas Instruments is distributed as "freeware".  You may,              */
/* only under TI's copyright in the Program, use and modify the              */
/* Program without any charge or restriction.  You may                       */
/* distribute to third parties, provided that you transfer a                 */
/* copy of this license to the third party and the third party               */
/* agrees to these terms by its first use of the Program. You                */
/* must reproduce the copyright notice and any other legend of               */
/* ownership on each copy or partial copy, of the Program.                   */
/*                                                                           */
/* You acknowledge and agree that the Program contains                       */
/* copyrighted material, trade secrets and other TI proprietary              */
/* information and is protected by copyright laws,                           */
/* international copyright treaties, and trade secret laws, as               */
/* well as other intellectual property laws.  To protect TI's                */
/* rights in the Program, you agree not to decompile, reverse                */
/* engineer, disassemble or otherwise translate any object code              */
/* versions of the Program to a human-readable form.  You agree              */
/* that in no event will you alter, remove or destroy any                    */
/* copyright notice included in the Program.  TI reserves all                */
/* rights not specifically granted under this license. Except                */
/* as specifically provided herein, nothing in this agreement                */
/* shall be construed as conferring by implication, estoppel,                */
/* or otherwise, upon you, any license or other right under any              */
/* TI patents, copyrights or trade secrets.                                  */
/*                                                                           */
/* You may not use the Program in non-TI devices.                            */
/*===========================================================================*/
// CSL Modules
#include <soc.h>
#include <csl_chip.h>
#include <csl_i2c.h>

// PADK Library
#include "PADK.h"

#include <stdio.h>
#include <stdlib.h>

/****************************************************************************
 *                             Local constants                              *
 ****************************************************************************/
static CSL_I2cHandle hI2c = NULL;
static CSL_I2cObj i2cObj;

/* 
 *  I2cDefaultClkSetup
 */
static CSL_I2cClkSetup I2cDefaultClkSetup = 
{ 
	0x0002,	// Prescalar to the input clock
//	0x00F4,	// Low time period of the clock
	0x0120,	// Low time period of the clock
	0x00F4	// High time period of the clock
//	0x01F4	// High time period of the clock
};

/* 
 *  I2cDefaultHwSetup
 */
static CSL_I2cHwSetup I2cDefaultHwSetup = 
{ 
    CSL_I2C_MODE_SLAVE,			// Master or Slave Mode
    CSL_I2C_DIR_RECEIVE,		// Transmitter Mode or Receiver Mode
	CSL_I2C_ADDRSZ_SEVEN,		// Addressing Mode
	CSL_I2C_STB_DISABLE,		// Start Byte Mode
	0x7f,	                	// Address of the own device
	CSL_I2C_ACK_ENABLE,	    	// NACK mode while receiver
	CSL_I2C_FREE_MODE_DISABLE,	// Run mode of I2C
	CSL_I2C_REPEAT_MODE_DISABLE,// Repeat Mode of I2C
	CSL_I2C_DLB_DISABLE,		// LoopBack mode of I2C (master tx-er only)
	CSL_I2C_FDF_DISABLE,		// Free Data Format of I2C
	CSL_I2C_IRS_ENABLE,	    	// I2C Reset Mode
	CSL_I2C_BCM_DISABLE,		// I2C Backward Compatibility Mode
	0x0,						// Interrupt Enable mask
	&I2cDefaultClkSetup			// Prescalar, Clock Low/High Time for Clock Setup
};


/****************************************************************************
 *                           Forward Declarations                           *
 ****************************************************************************/
static int PADK_I2cInit();
static void PADK_I2cRreset();


/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/





/****************************************************************************
 *                             Local constants                              *
 ****************************************************************************/
#define LED_I2C_ADDR    0x20
#define DIP_I2C_ADDR    0x21
#define BCD_I2C_ADDR    0x22
static unsigned char led_stat;

//
//  Main Function
//
int main( int argc, char *argv[] )
{
	int i;

	/*---------------------------------------------------------------*/
    /* Chip Initialization                                           */
    /*---------------------------------------------------------------*/
	CSL_chipInit( NULL );

	/*---------------------------------------------------------------*/
    /* Reset LEDs and switches to their default values               */
    /*---------------------------------------------------------------*/
	GPIO_Reset();


	/*---------------------------------------------------------------*/
    /* Poll continuously the dipswitches and buttons states and set  */
	/* the LEDs and the BCD display depending on their state.        */
    /*---------------------------------------------------------------*/
    while(1)
    {
    	// Toggle LED 1 // 
		GPIO_EnableLed( 1, 1 );
		for(i=0;i<500000;++i) {
		   asm("\t nop 5");
		}
		
		GPIO_EnableLed(1, 0);
		for(i=0;i<500000;++i) {
		   asm("\t nop 5");
		}			
    }
}


/**************************************************************************** 
 *
 * NAME  
 *      GPIO_EnableLeds
 *
 * PURPOSE:
 *		Enable/Disable one of the LEDs.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *		int GPIO_EnableLed( int led, int enable ) 
 *
 *      led    - (i) led number [0-7]
 *      enable - (i) 1->enable, 0->disable
 *
 * RETURN VALUE
 *		status
 *
 * REFERENCE
 *
 * NOTE     
 * 		
 ****************************************************************************/ 
far int GPIO_EnableLed( int led, int enable ) 
{
	led_stat |= (1<<led);
    if (enable) led_stat &= ~(1<<led);

    if ( I2C_WriteVal(LED_I2C_ADDR, led_stat) < 0 ) return -1;
    return 0;
}

/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

/**************************************************************************** 
 *
 * NAME  
 *      GPIO_Reset
 *
 * PURPOSE:
 *		Initialises all the GPIO pins needed to access the PADK peripherals.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *		int GPIO_Reset() 
 *
 * RETURN VALUE
 *		status
 *
 * REFERENCE
 *
 * NOTE     
 * 		
 ****************************************************************************/ 
far int GPIO_Reset()
{
    int res = 0;
	led_stat = 0xFF;
	res |= GPIO_EnableLed( 1, 0 );
	
    return res;
}


/**************************************************************************** 
 *
 * NAME  
 *     	I2C_WriteVal
 *
 * PURPOSE:
 *      This function send a byte to the specified device using the I2C bus.
 * 		
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *		int I2C_WriteVal( int devAddr, unsigned char val ); 
 *
 *		devAddr	- (i)	Id of the device to write to
 *		val     - (i)   Value
 *
 * RETURN VALUE
 *		-1 for failure, 0 for success
 *      
 * REFERENCE
 *
 ****************************************************************************/	
far int I2C_WriteVal( int devAddr, unsigned char val )
{
	int retry;

	for ( retry=0; retry<10; retry++ )
	{
		// First, verify if the I2C is initialized
		if ( hI2c == NULL )
		{
			if ( PADK_I2cInit() ) return -1; 
		}

		// Check for Bus busy 
	    while ( hI2c->regs->ICSTR & CSL_I2C_ICSTR_BB_MASK );

		// Wait for Master mode cleared
		while ( hI2c->regs->ICMDR & CSL_I2C_ICMDR_MST_MASK );

		// Set slave address
	    hI2c->regs->ICSAR = devAddr;

		// Set the data count for TX
		hI2c->regs->ICCNT = 0x1;

		// Wait ready to TX
		while ( !(hI2c->regs->ICSTR & CSL_I2C_ICSTR_ICXRDY_MASK) );

		// Set first word of data to send	
		hI2c->regs->ICDXR = val;	

	    // Switch to master-transmit mode
		hI2c->regs->ICMDR = 	  CSL_I2C_ICMDR_STT_MASK	// Gen start cond
								| CSL_I2C_ICMDR_MST_MASK	// Master 
								| CSL_I2C_ICMDR_TRX_MASK	// Transmit
								| CSL_I2C_ICMDR_IRS_MASK;	// Out of reset

		// Wait for the transfer to complete
		while ( !(hI2c->regs->ICSTR & CSL_I2C_ICSTR_ARDY_MASK) );

		// Verify if ACK return
		if ( !(hI2c->regs->ICSTR & CSL_I2C_ICSTR_NACK_MASK) )
		{
			// Generate STOP
        	hI2c->regs->ICMDR |= CSL_I2C_ICMDR_STP_MASK;

        	// Check for Bus busy 
            while ( hI2c->regs->ICSTR & CSL_I2C_ICSTR_BB_MASK );
        	return 0;
		}

		// Generate STOP
		hI2c->regs->ICMDR |= CSL_I2C_ICMDR_STP_MASK;

	    // Close I2C Port
	    CSL_i2cClose( hI2c );
		hI2c = NULL;
	}

	return -1;
}




/****************************************************************************
 *                             Local Functions                              *
 ****************************************************************************/

/**************************************************************************** 
 *
 * NAME  
 *     	PADK_I2cInit
 *
 * PURPOSE:
 *      Initialise the I2C interface.
 * 		
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *		int PADK_I2cInit(); 
 *      
 * RETURN VALUE
 *		Error code
 *
 * REFERENCE
 *
 * NOTE     
 * 		
 ****************************************************************************/	
static int PADK_I2cInit()
{    
    Uint16     response;
	CSL_Status status = CSL_SOK;

    /* Clear local data structures */
    memset( &i2cObj, 0, sizeof(CSL_I2cObj) );

    /* Initialize I2C module */
    status = CSL_i2cInit( NULL );    
    hI2c = CSL_i2cOpen( &i2cObj, CSL_I2C_1, NULL, &status );
    if ( (status != CSL_SOK) || (hI2c == NULL) ) 
    {
		// Failed to open I2C interface
		return -1;
	}

    /* Reset I2C Registers */
    PADK_I2cRreset();
	status = CSL_i2cHwSetup( hI2c, &I2cDefaultHwSetup );
    if ( status != CSL_SOK ) 
    {
		// Failed to configure the I2C
		CSL_i2cClose( hI2c );
		hI2c = NULL; 
		return -1;
	}

    /* Enable I2C */
    status = CSL_i2cHwControl( hI2c, CSL_I2C_CMD_ENABLE, NULL );
    if ( status != CSL_SOK ) 
    {
		// Error while controling the I2C
		CSL_i2cClose( hI2c );
		hI2c = NULL; 
		return -1;
    }

     /* Waiting for hwcontrol command to get executed */
    do 
    {
        CSL_i2cGetHwStatus( hI2c, CSL_I2C_QUERY_RDONE, &response );

    } while( response != CSL_I2C_RESET_DONE ); 

	return 0;
}


/**************************************************************************** 
 *
 * NAME  
 *     	PADK_I2cRreset
 *
 * PURPOSE:
 *      Reset the I2C engine
 * 		
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *		void PADK_I2cRreset(); 
 *
 * RETURN VALUE
 *		none
 *
 * REFERENCE
 *
 * NOTE     
 * 		
 ****************************************************************************/	
static void PADK_I2cRreset()
{
	CSL_I2cConfig config = CSL_I2C_CONFIG_DEFAULTS;

    /* for configuring clk registers */
    CSL_i2cHwControl( hI2c, CSL_I2C_CMD_RESET, NULL );

    /* i2c registers set to default values */
    CSL_i2cHwSetupRaw( hI2c, &config );  

}
