//===================================================================//
// Boot Configuration File :                                         //
//    C:/Lyrtech/PADK/dsp/demos/TMS320C672xxBootUtils/Examples/Padk_ //
//    i2cMastercfg.c                                                 //
// Date: Thursday August 17,2006  10:44:20                           //
//===================================================================//


#include <TISecondaryBoot.h>


//===================================================================//
// Function Prototypes                                               //
//===================================================================//
far void TIBootI2cClkCfg(void);


//===================================================================//
// Boot Confguration Setup Function                                  //
//    This code along with PLL Configuration, SDRAM Configuration    //
//    ASYC RAM Configuration, I2C Clock Configuration, will be       //
//    loaded first. A branch wil then be executed after load of      //
//     all boot configuration code to the bootSetup function.        //
//     After the boot setup has been performed, normal AIS           //
//     processing will continue at that point.                       //
//===================================================================//
                                                                       
#pragma CODE_SECTION(TIBootSetup,".TIBoot")
void TIBootSetup(void) {

   TIBootI2cClkCfg();
}

//===================================================================//
// I2c Clock Configuration                                           //
//    I2c Clock Prescale Register:                                   //
//        register mask: 0x00000004                                  //
//                                                                   //
//    I2C ICCLKH Register                                            //
//        register mask: 0x00000005                                  //
//                                                                   //
//    I2C ICCLKL Register                                            //
//        register mask: 0x00000004                                  //
//===================================================================//

#pragma CODE_SECTION(TIBootI2cClkCfg,".TIBoot")
void TIBootI2cClkCfg()
{
   // Make sure I2C device is held in reset
   *(volatile unsigned int *)TIBOOT_I2C1_ICMDR &= ~(0x00000020);
   *(volatile unsigned int *)TIBOOT_I2C1_ICPSC = 0x00000004u;
   *(volatile unsigned int *)TIBOOT_I2C1_ICCLKH = 0x00000005u;
   *(volatile unsigned int *)TIBOOT_I2C1_ICCLKL = 0x00000004u;
   // Now Release I2C from Reset
   *(volatile unsigned int *)TIBOOT_I2C1_ICMDR |= (0x00000020);
}




