/*===========================================================================*/
/* This software is provided under the following                             */
/* License Agreement:                                                        */
/*===========================================================================*/
/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
/* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
/* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
/* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
/* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
/* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
/* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
/* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
/* YOUR USE OF THE PROGRAM.                                                  */
/*                                                                           */
/* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
/* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
/* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
/* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
/* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
/* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
/* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
/* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
/* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
/* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
/* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
/* (U.S.$500).                                                               */
/*                                                                           */
/* Unless otherwise stated, the Program written and copyrighted              */
/* by Texas Instruments is distributed as "freeware".  You may,              */
/* only under TI's copyright in the Program, use and modify the              */
/* Program without any charge or restriction.  You may                       */
/* distribute to third parties, provided that you transfer a                 */
/* copy of this license to the third party and the third party               */
/* agrees to these terms by its first use of the Program. You                */
/* must reproduce the copyright notice and any other legend of               */
/* ownership on each copy or partial copy, of the Program.                   */
/*                                                                           */
/* You acknowledge and agree that the Program contains                       */
/* copyrighted material, trade secrets and other TI proprietary              */
/* information and is protected by copyright laws,                           */
/* international copyright treaties, and trade secret laws, as               */
/* well as other intellectual property laws.  To protect TI's                */
/* rights in the Program, you agree not to decompile, reverse                */
/* engineer, disassemble or otherwise translate any object code              */
/* versions of the Program to a human-readable form.  You agree              */
/* that in no event will you alter, remove or destroy any                    */
/* copyright notice included in the Program.  TI reserves all                */
/* rights not specifically granted under this license. Except                */
/* as specifically provided herein, nothing in this agreement                */
/* shall be construed as conferring by implication, estoppel,                */
/* or otherwise, upon you, any license or other right under any              */
/* TI patents, copyrights or trade secrets.                                  */
/*                                                                           */
/* You may not use the Program in non-TI devices.                            */
/*===========================================================================*/

/**============================================================================
*@file progI2C.c
*@desc This file contains code to program the Atmel 24LC64 I2C on PADK with
*      data generated by TMS320C672xx bootloader genAIS utility.
*
*      genAis -i SwitchesandLeds.out -o SwitchesandLeds.ais -bootmode i2cmaster -otype ascii
*
*==============================================================================
* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
* Use of this software us controlled by the terms and conditions found in the
* license agreement under which this software has been supplied
*=============================================================================*/

#include <stdio.h>
#include <PADK_I2C.h>

/*=============================================================================
* Global Symbol Declarations
*   aisIn      - File pointer to AIS data created by genAIS utility
*   fileName   - name of AIS input file
*   i2cObj     - I2C object containing pointers to instance data for opened
*                I2C peripheral
*   hI2c1      - pointer to initialized instance object created by call to
*                CSL_I2cOpen function
*   i2cStatus  - status flag to track status of I2C thru CSL functions
*   i2cSetup   - structure with setup parameters for I2C transmit
*=============================================================================*/

FILE    *aisIn;
char    *fileName = "..\\..\\blinkled1\\blinkled1.ais";
unsigned int   writeVal;
unsigned int   readVal;
char           ch;
unsigned short eepromAddr;
int            eepromDevAddr;
unsigned int   firstTen[10];
unsigned char  *chPtr;
int            status;
unsigned int   byteCount;
unsigned int   wordCount;
int errCnt;

void main(void) {
    	
	/* Open AIS file for reading */		
	aisIn = fopen(fileName,"r");
	eepromDevAddr = 0x50;
	/*===================================================
	* If I2C status is OKAY and input file is open
	* read data from file and write to I2C
	*===================================================*/
	if (aisIn != NULL) { 
	   eepromAddr = 0;
	   wordCount = 0;
	   status = 0;
	   errCnt = 0;
	   printf ("Programming I2C Device\n");

	   while ((fscanf(aisIn, "%x", &writeVal)!=EOF)) {
	      chPtr = (unsigned char *)&writeVal;
 
          I2C_WriteMem(eepromDevAddr, eepromAddr, chPtr, 1);
          ++chPtr;
          ++eepromAddr;
          I2C_WriteMem(eepromDevAddr, eepromAddr, chPtr, 1);
          ++chPtr;
          ++eepromAddr;
          I2C_WriteMem(eepromDevAddr, eepromAddr, chPtr, 1);
          ++chPtr;
          ++eepromAddr;
          status = I2C_WriteMem(eepromDevAddr, eepromAddr, chPtr, 1);
		  ++eepromAddr;
		  if (status == 0){
		     if (wordCount < 10) {
		       firstTen[wordCount] = writeVal;
			 }
			 ++wordCount;
		  }
		  
	   }			 

   }

   if (wordCount > 2000) {
      printf ("File too large to fit in EEPROM, data may wrap in address space\n");
   }

   printf ("Programming complete, eepromAddr = 0x%08X, count = %d\n",
           eepromAddr, wordCount);
   fclose(aisIn);

   wordCount = 0;
   eepromAddr = 0;
	  
   while (wordCount < 10) {
	  I2C_ReadMem( eepromDevAddr, eepromAddr, (unsigned char *)&readVal, 4);
	  if (readVal != firstTen[wordCount]) {
	     printf ("Error writing to EEPROM\n");
		 printf ("Expected value = 0x%08X, Value read = 0x%08X\n",
		          firstTen[wordCount], readVal);
         errCnt++;
	  }
      eepromAddr += 4;
      ++wordCount;
   }

   if (errCnt == 0) {
      printf ("Done\n");
   }
}
