//===================================================================//
// Boot Configuration File :                                         //
//    C:/Lyrtech/PADK/dsp/demos/TMS320C672xxBootUtils/Examples/Padk_ //
//    blinkLed4cfg.c                                                 //
// Date: Wednesday October 5 ,2005  14:19:20                         //
//===================================================================//


#include <TISecondaryBoot.h>


//===================================================================//
// Function Prototypes                                               //
//===================================================================//
far void TIBootPllCfg(void);


//===================================================================//
// Boot Confguration Setup Function                                  //
//    This code along with PLL Configuration, SDRAM Configuration    //
//    ASYC RAM Configuration, I2C Clock Configuration, will be       //
//    loaded first. A branch wil then be executed after load of      //
//     all boot configuration code to the bootSetup function.        //
//     After the boot setup has been performed, normal AIS           //
//     processing will continue at that point.                       //
//===================================================================//
                                                                       
#pragma CODE_SECTION(TIBootSetup,".TIBoot")
void TIBootSetup(void) {

   TIBootPllCfg();
}

//===================================================================//
// PLL Configuration                                                 //
//    Input Oscillator Frequency:  25.00                             //
//    Cpu Clock Frequency       :  75.00                             //
//    Emif Clock Frequency      :  25.00                             //
//                      PLLM    : 24                                 //
//                      DIV0    : 0                                  //
//                      DIV1    : 7                                  //
//                      DIV2    : 15                                 //
//                      DIV3    : 23                                 //
//===================================================================//
#pragma CODE_SECTION(TIBootPllCfg, ".TIBoot")
far void TIBootPllCfg(void)
{
   int i;
// configure the PLL  //

// Make sure SDRAM is in Self-Refresh mode before setting PLL //
// By setting SR bit in EMIF SDCR register to 1               //

   *(unsigned char *)TIBOOT_EMIF_SDCR = 0x8;

// 1. In PLLCSR, write PLLEN = 0 (bypass mode) //
*(volatile unsigned int *)TIBOOT_PLL_PLLCSR = TIBOOT_PLLDISABLE;

// 2. Wait 4 cycles of the slowest of PLLOUT or reference// clock source (CLKIN or OSCIN)
   asm("	 nop 4");

// 3. In PLLCSR, write PLLRST = 1 (PLL is reset) 
   *(volatile unsigned int *)TIBOOT_PLL_PLLCSR = TIBOOT_PLLDISABLE | TIBOOT_PLLRESET;

// 4. If necessary, program PLLDIV0 and PLLM 
// DIV0 - Before PLL(set to/1)               
   *(volatile unsigned int *)TIBOOT_PLL_PLLDIV0 = TIBOOT_DIVENABLED | 0x00000000;
   *(volatile unsigned int *)TIBOOT_PLL_PLLM = 0x00000018;

// 5. If necessary, program PLLDIV1-n. Note that you must apply the GO operation to
//   change these dividers to new ratios. 
//   DIV1 - After PLL- SYSCLK1 DSP Core
//   DIV2 - After PLL- SYSCLK2 PERIPHS (Always twice DIV3)
//   DIV3 - After PLL- SYSCLK3 EMIF CLOCK
   *(volatile unsigned int *)TIBOOT_PLL_PLLDIV1 = TIBOOT_DIVENABLED | 0x00000007;
   asm("	 nop 4");
   asm("	 nop 4");

   *(volatile unsigned int *)TIBOOT_PLL_PLLDIV2 = TIBOOT_DIVENABLED | 0x0000000F;
   asm("	 nop 4");
   asm("	 nop 4");

   *(volatile unsigned int *)TIBOOT_PLL_PLLDIV3 = TIBOOT_DIVENABLED | 0x00000017;

// Enable PLL Align control.
   *(volatile unsigned int *)TIBOOT_PLL_PLLALNCTL = TIBOOT_PLLALN1 | TIBOOT_PLLALN2 | TIBOOT_PLLALN3;
   *(volatile unsigned int *)TIBOOT_PLL_PLLCMD = TIBOOT_PLLGOSET;

   while (*(volatile unsigned int *)TIBOOT_PLL_PLLSTAT == TIBOOT_PLLGOWAIT){
      *(volatile unsigned int *)TIBOOT_PLL_PLLCMD = TIBOOT_PLLGOCLR;
   }

	// 6. Wait for PLL to properly reset
 //    Reset wait time is 125 ns
     for(i=0; i< 8;++i) {};

// 7. In PLLCSR, write PLLRST = 0 to bring PLL out of reset
   *(volatile unsigned int *)TIBOOT_PLL_PLLCSR = TIBOOT_PLLDISABLE | TIBOOT_PLLRESETRELEASE;
// 8. Wait for PLL to lock 
    for(i=0; i< 4787;++i) {};

// 9. In PLLCSR, write PLLEN = 1 to enable PLL mode 
   *(volatile unsigned int *)TIBOOT_PLL_PLLCSR = TIBOOT_PLLENABLE | TIBOOT_PLLRESETRELEASE;
    for(i=0; i < 4787; ++i) {};

// 10. Wait for Lock bit to become 1 
   while ( ((*(volatile unsigned int *)TIBOOT_PLL_PLLCSR) & TIBOOT_PLLLOCKED) == 0 )
   {
   }

// ---- done PLL Programation ---- 

// take CFG bridge out of reset
   *(volatile unsigned int *)TIBOOT_CFGBRIDGE_REGISTER |= 1;
   asm("	nop 9");
   *(volatile unsigned int *)TIBOOT_CFGBRIDGE_REGISTER &= 0xFFFFFFFE;

// Make sure SDRAM exits Self-Refesh Mode
// By setting SR bit in EMIF SDCR register to 0

   *(volatile unsigned char *)TIBOOT_EMIF_SDCR = 0x0;
}




