L 1 "setPllcfg.c"
N//===================================================================//
N// Boot Configuration File :                                         //
N//    C:/Lyrtech/PADK/dsp/demos/TMS320C672xxBootUtils/Padk_examples/ //
N//    setPllcfg.c                                                    //
N// Date: Monday October 10,2005  13:54:58                            //
N//===================================================================//
N
N
N#include <TISecondaryBoot.h>
L 1 "../../../../bootUtilities/inc/TISecondaryBoot.h" 1
N/**===========================================================================
N*@file TIBootCfg.h
N*@path $(CSLPATH)
N*@desc This file contains data type declarations and pre-defined constants
N*      used for seoncdayr boot loader.
N*=============================================================================
N* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
N* Use of this software us controlled by the terms and conditions found in the
N* license agreement under which this software has been supplied
N*=============================================================================*/
N#ifndef __TISecondaryBootH
N#define __TISecondaryBootH
N/*==================================================================*/
N/* Enumerated Constants                                             */
N/*==================================================================*/
N typedef enum { OR = 1,
N                AND,
N                XOR,
N                WRITE
N } TIBootMaskType;
N 
N/**=========================================================================
N*@name TISecondaryBootPinSetupObj
N*@desc  .
N*@field regPtr
N*       pointer to register to be modified.
N*@field mask
N*       mask to use in modifying register value.
N*@field mode
N*       modification mode (or, and, write, etc.)
N*===========================================================================*/
N 
Ntypedef struct {
N	unsigned int *regPtr;
N	unsigned int mask;
N	unsigned int mode;
N}TISecondaryBootPinSetupObj;
N                
N/**=========================================================================
N*@name TISecondaryBootStatusObj
N*@desc  Objects contains all data necessary to copy application code to
N*       run destination and branch to start of application.
N*@field pkgType
N*       Describes device package type (BGA or TQFP).
N*@field maxAddressPins
N*       Maximum number of configured address pins.
N*@field useAddressLatch
N*       GPIO Pin configured as address latch for extended FLASH addresses
N*@field genCrc
N*       generate CRC for check of section loads
N*@field aisStreamPtr
N*       current pointer to AIS command
N*@field bootErr
N*       boot Error flag
N*@field currentAisCmd
N*       current AIS command being processed
N*@field lasAisCmd
N*       previously processed AIS command
N*@field bootCrc
N*       currently calculated CRC value
N*@field expectedCrc
N*       CRC value calculated by AIS generation Tool 
N*@field crcErr
N*       error in CRC flag
N*@field ix
N*       generic index counter
N*@field sec_address
N*       section address where raw data is to be loaded in C672x
N*@field sec_size
N*       size in 32 bit words of section
N*@field lastValidAisCmdOffset
N*       negative offset to last valid AIS command (CRC rror recovery point)
N*@field tmpPinSetup
N*       array of pin configurations to enable use of GPIO's as address pin
N*       extensions for parallel FLASH boot
N*===========================================================================*/
N
Ntypedef struct {
N	unsigned short pkgType;
N	unsigned short maxAddressPins;
N	unsigned short useAddressLatch;
N	unsigned short genCrc;
N	unsigned int *aisStreamPtr;
N    unsigned int  bootErr;
N    unsigned int currentAisCmd;
N    unsigned int lastAisCmd;
N    unsigned int bootCRC;
N    unsigned int expectedCrc;
N    unsigned int crcErr;	
N	unsigned int ix;
N    unsigned int *sec_address;
N    unsigned int sec_size; 
N    unsigned int lastValidAisCmdOffset;  
N    TISecondaryBootPinSetupObj tmpPinSetup[48];    
N}TISecondaryBootStatusObj;
N
N
N
N/**=========================================================================
N*@name TIBootAsyncCfgObj
N*@desc  Objects contains EMIF configuration for Async memory
N*@field a1cr
N*       Mask for EMIF's A1CR control register
N*@field awccr
N*       Mask for EMIF'a Extended Wait Control Register AWCCR.
N*===========================================================================*/
Ntypedef struct {
N	unsigned int asyncCfg;
N	unsigned int a1cr;
N	unsigned int awccr;
N}TIBootAsyncCfgObj;
N
N/**=========================================================================
N*@name TIBootAsyncCfgObj
N*@desc  Objects contains EMIF configuration for Async memory
N*@field pllm
N*       PLL Multiplier -  OSC IN Multiplier.
N*@field plldiv0
N*       PLL Clock Prescaler.
N*@feild plldiv1
N*       Divide down for CPU clock.
N*@field plldiv2
N*       Divide down for EMIF clock.
N*@field plldiv3
N*       Divide down for Peripheral clock
N*===========================================================================*/
Ntypedef struct {
N	unsigned int pllCfg;
N	unsigned int pllm;
N	unsigned int plldiv0;
N	unsigned int plldiv1;
N	unsigned int plldiv2;
N	unsigned int plldiv3;
N}TIBootPllCfgObj;
N
N/**=========================================================================
N*@name TIBootSdramCfgObj
N*@desc  Objects contains EMIF configuration for SDRAM memory
N*@field sdcr
N*       Mask for SDRAM Configuration Register.
N*@field sdrcr
N*       Mask for SDRAM Refresh Configuration Register.
N*@feild sdtimr
N*       Mask for SDRAM Timing Register.
N*@field sdsretr
N*       Mask for SDRAM Exit Self-Refresh Timing Register
N*===========================================================================*/
Ntypedef struct {
N	unsigned int sdCfg;
N	unsigned int sdcr;
N	unsigned int sdrcr;
N	unsigned int sdtimr;
N	unsigned int sdsretr;
N}TIBootSdramCfgObj;
N
N
N/**=========================================================================
N*@name TIBootAddressPinObj
N*@desc  Object contains necesary information for enable, set, clr, disable
N*       of GPIO pins that are being used as address pins to extend the
N*       reachable FLASH address space.
N*@field pinEnableRegister
N*       Address of register to write to , to enable this GPIO pin
N*@field pinEnableMask
N*       Mask to write to pin Enable Register to enable this pin.
N*@field pinSetRegister
N*       Addrss of register to write to to drive this pin.
N*@field pinSetMask
N*       Mask to writ e to the pin Set register to drive this pin.
N*@field pinClrRegister
N*       Addrss of register to write to clear this pin.
N*@field pinClrMask
N*       Mask to writ e to the pin Set register to clear this pin.
N*@field pinDisableRegister
N*       Address of register to write to , to disnable this GPIO pin
N*@field pinDisableMask
N*       Mask to write to pin Enable Register to disnable this pin.
N*===========================================================================*/
N
Ntypedef struct {
N     unsigned int pinEnableRegister;
N     unsigned int pinEnableMask;
N     unsigned int pinEnableMaskMode;
N     unsigned int pinDirectionRegister;
N     unsigned int pinDirectionMask;
N     unsigned int pinDirectionMaskMode;
N     unsigned int pinSetRegister;
N     unsigned int pinSetMask;
N     unsigned int pinSetMaskMode;
N     unsigned int pinClearRegister;
N     unsigned int pinClearMask;
N     unsigned int pinClearMaskMode;
N     unsigned int pinDisableRegister;
N     unsigned int pinDisableMask;
N     unsigned int pinDisableMaskMode;
N} TIBootAddressPinObj;
N
N
N/*==================================================================*/
N/* External Global Symbols                                          */
N/*==================================================================*/ 
Nextern unsigned int TISecondaryBootCRC;
Nextern void TIBootSetup(void);
N
N/*==================================================================*/
N/*  Global Constant Defines                                         */
N/*==================================================================*/ 
N#define TIBOOT_PKGTYPE_BGA              (1)
N#define TIBOOT_PKGTYPE_RFP              (0)
N#define TIBOOT_AIS_STREAM_START_ADDRESS (0x90000800u)
N#define TIBOOT_EMIF_START_ADDRESS       (0x90000000u)
N#define TIBOOT_CFGBRIDGE_REGISTER       (0x40000024u)
N
N/* SDRAM Memory Map */
N
N#define TIBOOT_EMIF_REGS_BASE_ADDR      (0xF0000000u)
N#define TIBOOT_EMIF_AWCCR               (TIBOOT_EMIF_REGS_BASE_ADDR + 0x4)
N#define TIBOOT_EMIF_SDCR                (TIBOOT_EMIF_REGS_BASE_ADDR + 0x8)
N#define TIBOOT_EMIF_SDRCR               (TIBOOT_EMIF_REGS_BASE_ADDR + 0xC)
N#define TIBOOT_EMIF_A1CR                (TIBOOT_EMIF_REGS_BASE_ADDR + 0x10)
N#define TIBOOT_EMIF_SDTIMR              (TIBOOT_EMIF_REGS_BASE_ADDR + 0x20)
N#define TIBOOT_EMIF_SDSRETR             (TIBOOT_EMIF_REGS_BASE_ADDR + 0x3C)
N
N/* PLL Memory Map */
N
N#define TIBOOT_PLL_REG_BASE_ADDR        (0x41000000u)
N#define TIBOOT_PLL_PLLCSR               (TIBOOT_PLL_REG_BASE_ADDR + 0x100u)
N#define TIBOOT_PLL_PLLM                 (TIBOOT_PLL_REG_BASE_ADDR + 0x110u)
N#define TIBOOT_PLL_PLLDIV0              (TIBOOT_PLL_REG_BASE_ADDR + 0x114u)
N#define TIBOOT_PLL_PLLDIV1              (TIBOOT_PLL_REG_BASE_ADDR + 0x118u)
N#define TIBOOT_PLL_PLLDIV2              (TIBOOT_PLL_REG_BASE_ADDR + 0x11Cu)
N#define TIBOOT_PLL_PLLDIV3              (TIBOOT_PLL_REG_BASE_ADDR + 0x120u)
N#define TIBOOT_PLL_PLLCMD               (TIBOOT_PLL_REG_BASE_ADDR + 0x138u)
N#define TIBOOT_PLL_PLLSTAT              (TIBOOT_PLL_REG_BASE_ADDR + 0x13Cu)
N#define TIBOOT_PLL_PLLALNCTL            (TIBOOT_PLL_REG_BASE_ADDR + 0x140u)
N
N/* I2C Memory Map */
N
N#define TIBOOT_I2C1_REG_BASE_ADDR       (0x4A000000u)
N#define TIBOOT_I2C1_ICMDR               (TIBOOT_I2C1_REG_BASE_ADDR + 0x024u)
N#define TIBOOT_I2C1_ICPSC               (TIBOOT_I2C1_REG_BASE_ADDR + 0x030u)
N#define TIBOOT_I2C1_ICCLKL              (TIBOOT_I2C1_REG_BASE_ADDR + 0x00Cu)
N#define TIBOOT_I2C1_ICCLKH              (TIBOOT_I2C1_REG_BASE_ADDR + 0x010u)
N
N#define SECTION_LOAD_COMMAND            (0x58535901u)
N#define REQUEST_CRC_COMMAND             (0x58535902u)
N#define ENABLE_CRC_COMMAND              (0x58535903u)
N#define SECTION_FILL_COMMAND            (0x5853590au)
N#define JUMP_COMMAND                    (0x58535905u)
N#define JUMP_CLOSE_COMMAND              (0x58535906u)
N#define DEVICE_CFG_COMMAND              (0x585359F0u)
N#define PAGE_SWAP_COMMAND               (0x585359F1u)
N#define LATCH_ADDRESS                   (0x585359F2u)
N
N#define PATTERN_32BIT                   (3u)
N
N#define TIBOOT_ERR_CRC                  (0xFF00u)
N#define TIBOOT_ERR_INVALID_AIS_CMD      (0xFF01u)
N
N#define TIBOOT_PLLENABLE                (0x01u)
N#define TIBOOT_PLLDISABLE               (0x00u)
N#define TIBOOT_PLLPWRDN                 (0x02u)
N#define TIBOOT_PLLPWRUP                 (0x00u)
N#define TIBOOT_PLLOSCPWRDN              (0x04u)
N#define TIBOOT_PLLOSCPWRUP              (0x00u)
N#define TIBOOT_PLLRESET                 (0x08u)
N#define TIBOOT_PLLRESETRELEASE          (0x00u)
N#define TIBOOT_PLLSTABLE                (0x40u)
N#define TIBOOT_PLLUNSTABLE              (0x00u)
N#define TIBOOT_PLLLOCKED                (0x20u)
N#define TIBOOT_PLLNOTLOCKED             (0x00u)
N
N
N/* FOR PLLCMD */
N#define TIBOOT_PLLGOCLR                 (0x0000u)
N#define TIBOOT_PLLGOSET                 (0x0001u)
N
N/* FOR PLLSTAT */
N#define TIBOOT_PLLGODONE                (0x0000u)
N#define TIBOOT_PLLGOWAIT                (0x0001u)
N
N/* FOR ALNCTL */
N#define TIBOOT_PLLALN1                  (0x0001u)
N#define TIBOOT_PLLALN2                  (0x0002u)
N#define TIBOOT_PLLALN3                  (0x0004u)
N
N/* FOR PLLDIV0,1,2,3 and OSCDIV1 */
N#define TIBOOT_DIVENABLED               (0x8000u)
N#endif
L 10 "setPllcfg.c" 2
N
N
N//===================================================================//
N// Function Prototypes                                               //
N//===================================================================//
Nfar void TIBootPllCfg(void);
N
N
N//===================================================================//
N// Boot Confguration Setup Function                                  //
N//    This code along with PLL Configuration, SDRAM Configuration    //
N//    ASYC RAM Configuration, I2C Clock Configuration, will be       //
N//    loaded first. A branch wil then be executed after load of      //
N//     all boot configuration code to the bootSetup function.        //
N//     After the boot setup has been performed, normal AIS           //
N//     processing will continue at that point.                       //
N//===================================================================//
N                                                                       
N#pragma CODE_SECTION(TIBootSetup,".TIBoot")
Nvoid TIBootSetup(void) {
N
N   TIBootPllCfg();
N}
N
N//===================================================================//
N// PLL Configuration                                                 //
N//    Input Oscillator Frequency:  25.00                             //
N//    Cpu Clock Frequency       :  25.00                             //
N//    Emif Clock Frequency      :  10.00                             //
N//                      PLLM    : 24                                 //
N//                      DIV0    : 1                                  //
N//                      DIV1    : 11                                 //
N//                      DIV2    : 23                                 //
N//                      DIV3    : 29                                 //
N//===================================================================//
N#pragma CODE_SECTION(TIBootPllCfg, ".TIBoot")
Nfar void TIBootPllCfg(void)
N{
N   int i;
N// configure the PLL  //
N
N// Make sure SDRAM is in Self-Refresh mode before setting PLL //
N// By setting SR bit in EMIF SDCR register to 1               //
N
N   *(unsigned char *)TIBOOT_EMIF_SDCR = 0x8;
X   *(unsigned char *)((0xF0000000u) + 0x8) = 0x8;
N
N// 1. In PLLCSR, write PLLEN = 0 (bypass mode) //
N*(volatile unsigned int *)TIBOOT_PLL_PLLCSR = TIBOOT_PLLDISABLE;
X*(volatile unsigned int *)((0x41000000u) + 0x100u) = (0x00u);
N
N// 2. Wait 4 cycles of the slowest of PLLOUT or reference// clock source (CLKIN or OSCIN)
N   asm("	 nop 4");
N
N// 3. In PLLCSR, write PLLRST = 1 (PLL is reset) 
N   *(volatile unsigned int *)TIBOOT_PLL_PLLCSR = TIBOOT_PLLDISABLE | TIBOOT_PLLRESET;
X   *(volatile unsigned int *)((0x41000000u) + 0x100u) = (0x00u) | (0x08u);
N
N// 4. If necessary, program PLLDIV0 and PLLM 
N// DIV0 - Before PLL(set to/1)               
N   *(volatile unsigned int *)TIBOOT_PLL_PLLDIV0 = TIBOOT_DIVENABLED | 0x00000001;
X   *(volatile unsigned int *)((0x41000000u) + 0x114u) = (0x8000u) | 0x00000001;
N   *(volatile unsigned int *)TIBOOT_PLL_PLLM = 0x00000018;
X   *(volatile unsigned int *)((0x41000000u) + 0x110u) = 0x00000018;
N
N// 5. If necessary, program PLLDIV1-n. Note that you must apply the GO operation to
N//   change these dividers to new ratios. 
N//   DIV1 - After PLL- SYSCLK1 DSP Core
N//   DIV2 - After PLL- SYSCLK2 PERIPHS (Always twice DIV3)
N//   DIV3 - After PLL- SYSCLK3 EMIF CLOCK
N   *(volatile unsigned int *)TIBOOT_PLL_PLLDIV1 = TIBOOT_DIVENABLED | 0x0000000B;
X   *(volatile unsigned int *)((0x41000000u) + 0x118u) = (0x8000u) | 0x0000000B;
N   asm("	 nop 4");
N   asm("	 nop 4");
N
N   *(volatile unsigned int *)TIBOOT_PLL_PLLDIV2 = TIBOOT_DIVENABLED | 0x00000017;
X   *(volatile unsigned int *)((0x41000000u) + 0x11Cu) = (0x8000u) | 0x00000017;
N   asm("	 nop 4");
N   asm("	 nop 4");
N
N   *(volatile unsigned int *)TIBOOT_PLL_PLLDIV3 = TIBOOT_DIVENABLED | 0x0000001D;
X   *(volatile unsigned int *)((0x41000000u) + 0x120u) = (0x8000u) | 0x0000001D;
N
N// Enable PLL Align control.
N   *(volatile unsigned int *)TIBOOT_PLL_PLLALNCTL = TIBOOT_PLLALN1 | TIBOOT_PLLALN2 | TIBOOT_PLLALN3;
X   *(volatile unsigned int *)((0x41000000u) + 0x140u) = (0x0001u) | (0x0002u) | (0x0004u);
N   *(volatile unsigned int *)TIBOOT_PLL_PLLCMD = TIBOOT_PLLGOSET;
X   *(volatile unsigned int *)((0x41000000u) + 0x138u) = (0x0001u);
N
N   while (*(volatile unsigned int *)TIBOOT_PLL_PLLSTAT == TIBOOT_PLLGOWAIT){
X   while (*(volatile unsigned int *)((0x41000000u) + 0x13Cu) == (0x0001u)){
N      *(volatile unsigned int *)TIBOOT_PLL_PLLCMD = TIBOOT_PLLGOCLR;
X      *(volatile unsigned int *)((0x41000000u) + 0x138u) = (0x0000u);
N   }
N
N	// 6. Wait for PLL to properly reset
N //    Reset wait time is 125 ns
N     for(i=0; i< 8;++i) {};
N
N// 7. In PLLCSR, write PLLRST = 0 to bring PLL out of reset
N   *(volatile unsigned int *)TIBOOT_PLL_PLLCSR = TIBOOT_PLLDISABLE | TIBOOT_PLLRESETRELEASE;
X   *(volatile unsigned int *)((0x41000000u) + 0x100u) = (0x00u) | (0x00u);
N// 8. Wait for PLL to lock 
N    for(i=0; i< 4787;++i) {};
N
N// 9. In PLLCSR, write PLLEN = 1 to enable PLL mode 
N   *(volatile unsigned int *)TIBOOT_PLL_PLLCSR = TIBOOT_PLLENABLE | TIBOOT_PLLRESETRELEASE;
X   *(volatile unsigned int *)((0x41000000u) + 0x100u) = (0x01u) | (0x00u);
N    for(i=0; i < 4787; ++i) {};
N
N// 10. Wait for Lock bit to become 1 
N   while ( ((*(volatile unsigned int *)TIBOOT_PLL_PLLCSR) & TIBOOT_PLLLOCKED) == 0 )
X   while ( ((*(volatile unsigned int *)((0x41000000u) + 0x100u)) & (0x20u)) == 0 )
N   {
N   }
N
N// ---- done PLL Programation ---- 
N
N// take CFG bridge out of reset
N   *(volatile unsigned int *)TIBOOT_CFGBRIDGE_REGISTER |= 1;
X   *(volatile unsigned int *)(0x40000024u) |= 1;
N   asm("	nop 9");
N   *(volatile unsigned int *)TIBOOT_CFGBRIDGE_REGISTER &= 0xFFFFFFFE;
X   *(volatile unsigned int *)(0x40000024u) &= 0xFFFFFFFE;
N
N// Make sure SDRAM exits Self-Refesh Mode
N// By setting SR bit in EMIF SDCR register to 0
N
N   *(volatile unsigned char *)TIBOOT_EMIF_SDCR = 0x0;
X   *(volatile unsigned char *)((0xF0000000u) + 0x8) = 0x0;
N}
N
N
N
N
