/*===========================================================================*/
/* This software is provided under the following                             */
/* License Agreement:                                                        */
/*===========================================================================*/
/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
/* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
/* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
/* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
/* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
/* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
/* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
/* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
/* YOUR USE OF THE PROGRAM.                                                  */
/*                                                                           */
/* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
/* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
/* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
/* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
/* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
/* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
/* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
/* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
/* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
/* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
/* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
/* (U.S.$500).                                                               */
/*                                                                           */
/* Unless otherwise stated, the Program written and copyrighted              */
/* by Texas Instruments is distributed as "freeware".  You may,              */
/* only under TI's copyright in the Program, use and modify the              */
/* Program without any charge or restriction.  You may                       */
/* distribute to third parties, provided that you transfer a                 */
/* copy of this license to the third party and the third party               */
/* agrees to these terms by its first use of the Program. You                */
/* must reproduce the copyright notice and any other legend of               */
/* ownership on each copy or partial copy, of the Program.                   */
/*                                                                           */
/* You acknowledge and agree that the Program contains                       */
/* copyrighted material, trade secrets and other TI proprietary              */
/* information and is protected by copyright laws,                           */
/* international copyright treaties, and trade secret laws, as               */
/* well as other intellectual property laws.  To protect TI's                */
/* rights in the Program, you agree not to decompile, reverse                */
/* engineer, disassemble or otherwise translate any object code              */
/* versions of the Program to a human-readable form.  You agree              */
/* that in no event will you alter, remove or destroy any                    */
/* copyright notice included in the Program.  TI reserves all                */
/* rights not specifically granted under this license. Except                */
/* as specifically provided herein, nothing in this agreement                */
/* shall be construed as conferring by implication, estoppel,                */
/* or otherwise, upon you, any license or other right under any              */
/* TI patents, copyrights or trade secrets.                                  */
/*                                                                           */
/* You may not use the Program in non-TI devices.                            */
/*===========================================================================*/

/**============================================================================
*@file progSpi.c
*@desc This file contains code to program the Atmel 25LC640 SPI Eeprom on PADK with
*      data generated by TMS320C672xx bootloader genAIS utility.
*
*      genAis -i blinkLed4.out -o blinkLed4.ais -bootmode spimaster -otype ascii
*
*==============================================================================
* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
* Use of this software us controlled by the terms and conditions found in the
* license agreement under which this software has been supplied
*=============================================================================*/

#include <stdio.h>
#include <csl.h>
#include <csl_spi.h>


/**============================================================================
 SPI Commands
*=============================================================================*/
 

#define SPI_WRITE_CMD  0x02   
#define SPI_WREN_CMD   0x06
#define SPI_READ_CMD   0x03
#define SPI_WRDI_CMD   0x04
#define SPI_RDSR_CMD   0x05

#define SPI_RXEMPTY       0x80000000
#define SPI_TXFULL        0x20000000
#define SPI_DATABITS      0x0000FFFF 
#define SPI_ENABLE        0x01000000
#define SPI_WRITE_MASK    0xFFFF
#define BITS_PER_SHOT     16


/**============================================================================
  Function prototypes
*=============================================================================*/

unsigned int spiReadStatus(CSL_SpiHandle  hSpi);
unsigned int spiReadWord(CSL_SpiHandle  hSpi, unsigned int *addr);
unsigned int spiWriteEnable(CSL_SpiHandle  hSpi);
unsigned int spiWriteDisable(CSL_SpiHandle  hSpi);
unsigned int spiWriteWord(CSL_SpiHandle  hSpi, unsigned int data, unsigned int addr);
extern void TIBootSetup(void);
/**============================================================================
  Global Symbol Declarations
*=============================================================================*/

FILE           *aisIn;
char           *fileName = "..\\..\\blinkLed4\\blinkLed4.ais";
unsigned int   writeVal;
unsigned short write_val;
unsigned int   readVal;

unsigned int   eepromAddr;
CSL_Status     status, status0, status1, status2;
unsigned short eepromCmd;
unsigned short wordCnt, errCnt;
unsigned int   readWord,writeVal;
unsigned int   spi_cmd;

unsigned int   aisData[2048];

CSL_SpiCptData bufData;
CSL_SpiObj     mySpiObj;
CSL_SpiHandle  hSpi;
CSL_SpiConfig  mySpiCfg = CSL_SPI_CONFIG_DEFAULTS;

void main(void) {
    int i;

	/* Configure PLL */

	TIBootSetup();

    /* CSL Initialization */
	CSL_chipInit(NULL);

	/* Initialize CSL SPi Module */
	CSL_spiInit(NULL);

	/* Open Resource for SPI0 */
	hSpi = CSL_spiOpen(&mySpiObj, CSL_SPI_0, NULL, &status);
	
	if (status == CSL_SOK) {
		/*=========================
		 * Configure SPI
		 * SPIPC0   = 0x00000E00
		 * SPIPC1   = 0x00000001
		 * SPIGCR1  = 0x00000003
		 * SPIFMT0  = 0x0002FF10
		 * SPIDELAY = 0x06021030
		 * SPIPC3   = 0x00000001
		 *========================*/     
		hSpi->regs->SPIGCR0 = 1;   
		hSpi->regs->SPIPC0 = 0x00000E00;
		                  // ((CSL_SPI_SPIPC0_SOMIFUN_SPI << CSL_SPI_SPIPC0_SOMIFUN_SHIFT) |
		                  // (CSL_SPI_SPIPC0_SIMOFUN_SPI << CSL_SPI_SPIPC0_SIMOFUN_SHIFT) |
		                  // (CSL_SPI_SPIPC0_CLKFUN_SPI << CSL_SPI_SPIPC0_CLKFUN_SHIFT));
		                  
		hSpi->regs->SPIPC1 =  0x00000001; 
		                   //(CSL_SPI_SPIPC1_SCSDIR0_OUT << CSL_SPI_SPIPC1_SCSDIR0_SHIFT);
		
		hSpi->regs->SPIGCR1 = 0x00000003;
		                    //((CSL_SPI_SPIGCR1_CLKMOD_INTERNAL << CSL_SPI_SPIGCR1_CLKMOD_SHIFT) |
		                    //(CSL_SPI_SPIGCR1_MASTER_YES << CSL_SPI_SPIGCR1_MASTER_SHIFT));
		                    
	    hSpi->regs->SPIFMT[0] = 0x0002FF10;
//	    hSpi->regs->SPIFMT[0] = 0x0002FF08;

		                      //((0x10 << CSL_SPI_SPIFMT_CHARLEN_SHIFT)|
		                      //(0XFF << CSL_SPI_SPIFMT_PRESCALE_SHIFT) |
		                      //(CSL_SPI_SPIFMT_POLARITY_INACTIVELO  << CSL_SPI_SPIFMT_POLARITY_SHIFT));
		                    
		hSpi->regs->SPIDELAY = 0x06021030;
		                      //((0x30 << CSL_SPI_SPIDELAY_C2EDELAY_SHIFT) |
		                      //(0x10 << CSL_SPI_SPIDELAY_T2EDELAY_SHIFT) |
		                      //(0x2 << CSL_SPI_SPIDELAY_T2CDELAY_SHIFT) |
		                      //(0x06 << CSL_SPI_SPIDELAY_C2TDELAY_SHIFT));
		                     
		hSpi->regs->SPIPC3 = 0x00000001;
		                     //CSL_SPI_SPIPC3_SCSDOUT0_HI << CSL_SPI_SPIPC3_SCSDOUT0_SHIFT;
		
		hSpi->regs->SPIGCR1 |= SPI_ENABLE;
		
		
		// Read SPI Status Word //
		eepromAddr = 0;
		errCnt = 1;
		
			/* Open AIS file for reading */		
	    aisIn = fopen(fileName,"r");
		            
	    if (aisIn != NULL) 
	    { 
	       eepromAddr = 0;
	       status = 0;
		   wordCnt = 0;
		   errCnt = 0;
	       printf ("Programming SPI Device\n");

	       while ((fscanf(aisIn, "%x", &writeVal)!=EOF)) 
	       {
		
		      aisData[wordCnt] = writeVal;
 
              status = spiWriteEnable(hSpi);
			  asm("\t nop 5"); 
			          
		      status = spiWriteWord(hSpi, writeVal, eepromAddr);
			

		      eepromAddr += 4;		 

			  ++wordCnt;
           }

           printf ("SPI Progamming complete\n");
		   spiWriteDisable(hSpi);

            eepromAddr = 0;

            printf ("\tVerifying .... \n");

            for(i=0;i<wordCnt;++i) 
            {
		       readWord = spiReadWord(hSpi, &eepromAddr);
			   if (readWord != aisData[i])
			   {
		           printf ("\t\tError at address[0x%08X], Wrote = 0x%08X, Read = 0x%08X\n", 
		                  eepromAddr, aisData[i], readWord);
						  errCnt++;
			   }
			   eepromAddr += 4;
		    }			   
              
       } 
       else 
       {
	       printf ("Could not open AIS file for reading\n");
       }
           
	   if (errCnt == 0) 
	   {
	     printf("Verification Complete - Program Successful\n");
	   } 
	   else
	   {
	     printf("!!!Warning : SPI Not Programmed\n");
	   }
	}
}


unsigned int spiReadStatus(CSL_SpiHandle  hSpi){

	unsigned int noElements = 1;
	unsigned int read_value=0;
	unsigned int count=0;
	unsigned int shiftWriteBits = 16;
	unsigned int spi_cmd;

    spi_cmd = SPI_RDSR_CMD << 24;
	
	while(noElements--)
	{

		hSpi->regs->SPIPC3 =  0x0; //Make chip select low

        write_val = (unsigned short)((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
		hSpi->regs->SPIDAT0 = write_val; //((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
		
		while(hSpi->regs->SPIBUF & SPI_RXEMPTY);  ////Wait      	
		hSpi->regs->SPIPC3 =  0x1;     // SCS is output pin     
		                	
		read_value |= ( ((hSpi->regs->SPIBUF) & SPI_DATABITS) & 0xff )<<(count);
		count+=8;			
		spi_cmd += 256;   //i.e. (1 << 8);					
	}
	
	return read_value;																																						
}


unsigned int spiReadWord(CSL_SpiHandle  hSpi, unsigned int *addr){

	unsigned int noElements = 4;
	unsigned int read_value=0;
	unsigned int count=0;
	unsigned int shiftWriteBits = 16;
	unsigned int spi_cmd;
	unsigned int spiAddr;

    spi_cmd = SPI_READ_CMD << 24;
	spiAddr = *addr;
	spi_cmd |= (spiAddr << 8);
	
	while(noElements--)
	{


		hSpi->regs->SPIPC3 =  0x0; //Make chip select low

        write_val = (unsigned short)((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
		hSpi->regs->SPIDAT0 = write_val; //((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
		
		while((hSpi->regs->SPIBUF) & SPI_TXFULL);

		while(hSpi->regs->SPIBUF & SPI_RXEMPTY);  ////Wait      	

        write_val = spi_cmd & 0xffff ;//| ((localData >> 24) & 0xFF);
		hSpi->regs->SPIDAT0 = write_val; // Write next data

		while(hSpi->regs->SPIBUF & SPI_RXEMPTY);  ////Wait      	
		hSpi->regs->SPIPC3 =  0x1;     // SCS is output pin     
		                	
		read_value |= ( ((hSpi->regs->SPIBUF) & SPI_DATABITS) & 0xff )<<(count);
		count+=8;			
		spi_cmd += 256;  //i.e. (1 << 8);					
	}
	
	return read_value;																																						
}

unsigned int spiWriteEnable(CSL_SpiHandle  hSpi){

	unsigned int shiftWriteBits = 16;
	unsigned int spi_cmd;

    spi_cmd = SPI_WREN_CMD << 24;
	

		hSpi->regs->SPIPC3 =  0x0; //Make chip select low

        write_val = (unsigned short)((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
		hSpi->regs->SPIDAT0 = write_val; //((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
		
		while((hSpi->regs->SPIBUF) & SPI_TXFULL);
		
		hSpi->regs->SPIDAT0 = spi_cmd & 0x0000ffff; // Write next data
		while(hSpi->regs->SPIBUF & SPI_RXEMPTY);  ////Wait      	
		hSpi->regs->SPIPC3 =  0x1;     // SCS is output pin     
		                						
	
	return 0;																																						
}


unsigned int spiWriteDisable(CSL_SpiHandle  hSpi){

	unsigned int shiftWriteBits = 16;
	unsigned int spi_cmd;

    spi_cmd = SPI_WRDI_CMD << 24;
	

		hSpi->regs->SPIPC3 =  0x0; //Make chip select low

        write_val = (unsigned short)((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
		hSpi->regs->SPIDAT0 = write_val; //((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
		
		while((hSpi->regs->SPIBUF) & SPI_TXFULL);
		
		hSpi->regs->SPIDAT0 = spi_cmd & 0x0000ffff; // Write next data
		while(hSpi->regs->SPIBUF & SPI_RXEMPTY);  ////Wait      	
		hSpi->regs->SPIPC3 =  0x1;     // SCS is output pin     
		                						
	
	return 0;																																						
}



unsigned int spiWriteWord(CSL_SpiHandle  hSpi, unsigned int data, unsigned int addr){

	unsigned int spiAddr;
	unsigned int localData;
	unsigned int i;

	spiAddr = addr;
	localData = data;

 	 
    for(i=0; i< 4; ++i)
	{
	  status = spiWriteEnable(hSpi);
	  asm("\t nop 5");  
	  
	  hSpi->regs->SPIPC3 =  0x0; //Make chip select low

      write_val = ((SPI_WRITE_CMD << 8) | ((spiAddr & 0xFF00) >> 8)) & 0xFFFF;
	  hSpi->regs->SPIDAT0 = write_val; //((spi_cmd >> shiftWriteBits) & SPI_WRITE_MASK );
	
	  while((hSpi->regs->SPIBUF) & SPI_TXFULL);
      while((hSpi->regs->SPIBUF) & SPI_RXEMPTY);
	
      write_val = (spiAddr & 0xff) << 8 | (localData & 0xff);//| ((localData >> 24) & 0xFF);
      hSpi->regs->SPIDAT0 = write_val; // Write next data

      while((hSpi->regs->SPIBUF) & SPI_RXEMPTY);

      write_val = (((spiAddr & 0xFF) << 8) | (localData & 0xff));//| ((localData >> 24) & 0xFF);
      hSpi->regs->SPIDAT0 = write_val; // Write next data

      asm ("\t nop 5");

	  hSpi->regs->SPIPC3 =  0x1;     // SCS is output pin

      asm ("\t nop 5");

      status2 = 1;
 		  
	  while(status2)
	  {
 	      status2 = spiReadStatus(hSpi);
	      status2 &= 1;
 	  }
			
      spiAddr += 1;
	  localData = localData >> 8;

    }		                			
	return 0;																																						
}
