//===================================================================//
// Boot Configuration File :                                         //
//    C:/Lyrtech/PADK/dsp/demos/TMS320C672xxBootUtils/Examples/gener //
//    docExamplecfg.c                                                //
// Date: Friday October 21,2005  10: 6: 9                            //
//===================================================================//


#include <TISecondaryBoot.h>


//===================================================================//
// Function Prototypes                                               //
//===================================================================//
far void TIBootAsyncRamCfg(void);


//===================================================================//
// Boot Confguration Setup Function                                  //
//    This code along with PLL Configuration, SDRAM Configuration    //
//    ASYC RAM Configuration, I2C Clock Configuration, will be       //
//    loaded first. A branch wil then be executed after load of      //
//     all boot configuration code to the bootSetup function.        //
//     After the boot setup has been performed, normal AIS           //
//     processing will continue at that point.                       //
//===================================================================//
                                                                       
#pragma CODE_SECTION(TIBootSetup,".TIBoot")
void TIBootSetup(void) {

   TIBootAsyncRamCfg();
}

//===================================================================//
// ASYNC Ram Configuration                                           //
//    Asynchrounous 1 Configuration Register:                        //
//        register mask: 0x1DF6EFFD                                  //
//                   SS: 0                                           //
//                   EW: 0                                           //
//              W_SETUP: 7                                           //
//             W_STROBE: 31                                          //
//               W_HOLD: 3                                           //
//              R_SETUP: 7                                           //
//             R_STROBE: 0                                           //
//               R_HOLD: -1                                          //
//                   TA: 3                                           //
//                ASIZE: 1                                           //
//                                                                   //
//    Asynchronous Wait Cycle Configuration Register                 //
//        register mask: 0x10000080                                  //
//                  WP0: 1                                           //
//                 MEWC: 128                                         //
//===================================================================//

#pragma CODE_SECTION(TIBootAsyncRamCfg,".TIBoot")
void TIBootAsyncRamCfg()
{
   *(volatile unsigned int *)TIBOOT_EMIF_AWCCR = 0x10000080u;
   *(volatile unsigned int *)TIBOOT_EMIF_A1CR = 0x1DF6EFFDu;
}




