/**============================================================================
*@file dspI2cMaster.c
*@desc This file contains source for example code setup I2C for transfer.
*
*==============================================================================
* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
* Use of this software us controlled by the terms and conditions found in the
* license agreement under which this software has been supplied
*=============================================================================*/

/*===========================================================================*/
/* This software is provided under the following                             */
/* License Agreement:                                                        */
/*===========================================================================*/
/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
/* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
/* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
/* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
/* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
/* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
/* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
/* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
/* YOUR USE OF THE PROGRAM.                                                  */
/*                                                                           */
/* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
/* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
/* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
/* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
/* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
/* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
/* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
/* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
/* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
/* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
/* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
/* (U.S.$500).                                                               */
/*                                                                           */
/* Unless otherwise stated, the Program written and copyrighted              */
/* by Texas Instruments is distributed as "freeware".  You may,              */
/* only under TI's copyright in the Program, use and modify the              */
/* Program without any charge or restriction.  You may                       */
/* distribute to third parties, provided that you transfer a                 */
/* copy of this license to the third party and the third party               */
/* agrees to these terms by its first use of the Program. You                */
/* must reproduce the copyright notice and any other legend of               */
/* ownership on each copy or partial copy, of the Program.                   */
/*                                                                           */
/* You acknowledge and agree that the Program contains                       */
/* copyrighted material, trade secrets and other TI proprietary              */
/* information and is protected by copyright laws,                           */
/* international copyright treaties, and trade secret laws, as               */
/* well as other intellectual property laws.  To protect TI's                */
/* rights in the Program, you agree not to decompile, reverse                */
/* engineer, disassemble or otherwise translate any object code              */
/* versions of the Program to a human-readable form.  You agree              */
/* that in no event will you alter, remove or destroy any                    */
/* copyright notice included in the Program.  TI reserves all                */
/* rights not specifically granted under this license. Except                */
/* as specifically provided herein, nothing in this agreement                */
/* shall be construed as conferring by implication, estoppel,                */
/* or otherwise, upon you, any license or other right under any              */
/* TI patents, copyrights or trade secrets.                                  */
/*                                                                           */
/* You may not use the Program in non-TI devices.                            */
/*===========================================================================*/




#ifdef BOOT_TEST
#define FPGA_I2C
#else
#undef FPGA_I2C
#endif

#ifndef FPGA_I2C

#define I2C_ICOAR0			0x01B40000	
#define I2C_ICIMR0			0x01B40004
#define I2C_ICSTR0			0x01B40008
#define I2C_ICCLKL0			0x01B4000C
#define I2C_ICCLKH0			0x01B40010
#define I2C_ICCNT0			0x01B40014
#define I2C_ICDRR0			0x01B40018
#define I2C_ICSAR0			0x01B4001C
#define I2C_ICDXR0			0x01B40020
#define I2C_ICMDR0			0x01B40024
#define I2C_ICIVR0			0x01B40028
#define I2C_ICGPIO0			0x01B4002C
#define I2C_ICPSC0			0x01B40030
#define I2C_ICPID10			0x01B40038
#define I2C_ICPID20			0x01B4003C

#define I2C_ICOAR1			0x01B44000	
#define I2C_ICIMR1			0x01B44004
#define I2C_ICSTR1			0x01B44008
#define I2C_ICCLKL1			0x01B4400C
#define I2C_ICCLKH1			0x01B44010
#define I2C_ICCNT1			0x01B44014
#define I2C_ICDRR1			0x01B44018
#define I2C_ICSAR1			0x01B4401C
#define I2C_ICDXR1			0x01B44020
#define I2C_ICMDR1			0x01B44024
#define I2C_ICIVR1			0x01B44028
#define I2C_ICGPIO1			0x01B4402C
#define I2C_ICPSC1			0x01B44030
#define I2C_ICPID11			0x01B44038
#define I2C_ICPID21			0x01B4403C

#else

#define I2C_ICOAR0			0x90210000	
#define I2C_ICIMR0			0x90210004
#define I2C_ICSTR0			0x90210008
#define I2C_ICCLKL0			0x9021000C
#define I2C_ICCLKH0			0x90210010
#define I2C_ICCNT0			0x90210014
#define I2C_ICDRR0			0x90210018
#define I2C_ICSAR0			0x9021001C
#define I2C_ICDXR0			0x90210020
#define I2C_ICMDR0			0x90210024
#define I2C_ICIVR0			0x90210028
#define I2C_ICGPIO0			0x9021002C
#define I2C_ICPSC0			0x90210030
#define I2C_ICPID10			0x90210038
#define I2C_ICPID20			0x9021003C

#define I2C_ICOAR1			0x90218000	
#define I2C_ICIMR1			0x90218004
#define I2C_ICSTR1			0x90218008
#define I2C_ICCLKL1			0x9021800C
#define I2C_ICCLKH1			0x90218010
#define I2C_ICCNT1			0x90218014
#define I2C_ICDRR1			0x90218018
#define I2C_ICSAR1			0x9021801C
#define I2C_ICDXR1			0x90218020
#define I2C_ICMDR1			0x90218024
#define I2C_ICIVR1			0x90218028
#define I2C_ICGPIO1			0x9021802C
#define I2C_ICPSC1			0x90218030
#define I2C_ICPID11			0x90218038
#define I2C_ICPID21			0x9021803C

#endif

#define HI2C_ICOAR0			( *((volatile unsigned short *)I2C_ICOAR0) )
#define HI2C_ICIMR0			( *((volatile unsigned char *)I2C_ICIMR0) )
#define HI2C_ICSTR0			( *((volatile unsigned short *)I2C_ICSTR0) )
#define HI2C_ICCLKL0		        ( *((volatile unsigned short *)I2C_ICCLKL0) )
#define HI2C_ICCLKH0		        ( *((volatile unsigned short *)I2C_ICCLKH0) )
#define HI2C_ICCNT0			        ( *((volatile unsigned short *)I2C_ICCNT0) )
#define HI2C_ICDRR0			        ( *((volatile unsigned char *)I2C_ICDRR0) )
#define HI2C_ICSAR0			        ( *((volatile unsigned short *)I2C_ICSAR0) )
#define HI2C_ICDXR0			        ( *((volatile unsigned char *)I2C_ICDXR0) )
#define HI2C_ICMDR0			        ( *((volatile unsigned short *)I2C_ICMDR0) )
#define HI2C_ICIVR0			        ( *((volatile unsigned char *)I2C_ICIVR0) )
#define HI2C_ICGPIO0		        ( *((volatile unsigned short *)I2C_ICGPIO0) )
#define HI2C_ICPSC0			        ( *((volatile unsigned char *)I2C_ICPSC0) )
#define HI2C_ICPID10		        ( *((volatile unsigned short *)I2C_ICPID10) )
#define HI2C_ICPID20		        ( *((volatile unsigned short *)I2C_ICPID20) )

#define HI2C_ICOAR1			        ( *((volatile unsigned short *)I2C_ICOAR1) )
#define HI2C_ICIMR1			        ( *((volatile unsigned char *)I2C_ICIMR1) )
#define HI2C_ICSTR1			        ( *((volatile unsigned short *)I2C_ICSTR1) )
#define HI2C_ICCLKL1		        ( *((volatile unsigned short *)I2C_ICCLKL1) )
#define HI2C_ICCLKH1		        ( *((volatile unsigned short *)I2C_ICCLKH1) )
#define HI2C_ICCNT1			        ( *((volatile unsigned short *)I2C_ICCNT1) )
#define HI2C_ICDRR1			        ( *((volatile unsigned char *)I2C_ICDRR1) )
#define HI2C_ICSAR1			        ( *((volatile unsigned short *)I2C_ICSAR1) )
#define HI2C_ICDXR1			        ( *((volatile unsigned char *)I2C_ICDXR1) )
#define HI2C_ICMDR1			        ( *((volatile unsigned short *)I2C_ICMDR1) )
#define HI2C_ICIVR1			        ( *((volatile unsigned char *)I2C_ICIVR1) )
#define HI2C_ICGPIO1		        ( *((volatile unsigned short *)I2C_ICGPIO1) )
#define HI2C_ICPSC1			        ( *((volatile unsigned char *)I2C_ICPSC1) )
#define HI2C_ICPID11		        ( *((volatile unsigned short *)I2C_ICPID11) )
#define HI2C_ICPID21		        ( *((volatile unsigned short *)I2C_ICPID21) )

/* Device Configuration register mapping for I2C1 */

#define DEVCFG_STATUS_REG_ADDR          (0x019C0200)
#define DEVCFG_STATUS_REG               *((volatile unsigned int*)DEVCFG_STATUS_REG_ADDR)
#define DEVCFG_ENABLE_I2C1()            DEVCFG_STATUS_REG = DEVCFG_STATUS_REG | ((unsigned int)1)               		                     
#define DEVCFG_DISABLE_I2C1()            DEVCFG_STATUS_REG = DEVCFG_STATUS_REG | ((unsigned int)0)               		                     

#ifdef MOZART_QT_TESTING
   #define DUMMY_COUNT 10000
#endif

void DIM_open(int iicNumber, int data_bits)
{

if(iicNumber == 0)
	{
	HI2C_ICMDR0 = 0;
        
        #ifdef MOZART_QT_TESTING
           HI2C_ICPSC0 = 0x4F;
       	   HI2C_ICCLKL0	= 0xFA;  
	   HI2C_ICCLKH0	= 0xFA;  
        #else  
           HI2C_ICPSC0 = 0xA;
	   HI2C_ICCLKL0= 0x64;  
	   HI2C_ICCLKH0	= 0x64;  
        #endif 

	}

if(iicNumber == 1)
	{
	DEVCFG_ENABLE_I2C1();
	HI2C_ICMDR1 = 0;
        

    HI2C_ICPSC1  = 0xA;
	HI2C_ICCLKL1 = 0x64;  
	HI2C_ICCLKH1 = 0x64;  

	}
}

void timeOutRegReset(int iicNumber)
{

   if(iicNumber == 0)
   {
        HI2C_ICSTR0 = HI2C_ICSTR0;
        HI2C_ICSTR0 =0x1410;  
        HI2C_ICMDR0 =0x800;
        HI2C_ICOAR0 =0x20;
   }

   if(iicNumber == 1)
   {
        HI2C_ICSTR1 = HI2C_ICSTR1;
        HI2C_ICSTR1 =0x1410;  
        HI2C_ICMDR1 =0x800;
        HI2C_ICOAR1 =0x20;
   }
}           

unsigned int DIM_readWord(int iicNumber, int data_bits)
{

 unsigned int data,len,count;
 
 
    len=data_bits/8;
    count=0;
    data=0;
    
	HI2C_ICMDR0 = 0xC20;	

	HI2C_ICCNT0 = len;	
	
	HI2C_ICOAR0 = 0x10;
	
	/* Specify the Slave Address */
	HI2C_ICSAR0 = 0x29;	
	    	
	/* Wait for Bus Busy */
	while(HI2C_ICSTR0 & 0x1000);
	
	/* Generate the Start Condition */
	HI2C_ICMDR0 |= 0x2000;
	
	while(!(HI2C_ICSTR0 & 0x1000) || (HI2C_ICSTR0 & 0x3) )
	{	
		if(HI2C_ICSTR0 & 0x3)
		{
		    timeOutRegReset(iicNumber);
		    goto top0;
		}	
	}

	count = 0;
	
	while(len--)
	{

	   while(!(HI2C_ICSTR0 & 0x8)  )
	  {
	     if (HI2C_ICSTR0 & 0x3)
	     { 
	        timeOutRegReset(iicNumber);	         
            goto top0;
	    }
	  }       
	   data |= HI2C_ICDRR0 << count;	
	   count+=8;
	}   
			
	/* Generate the Stop Condition */
        HI2C_ICMDR0 |= 0x800;
    
        /* Wait for Bus Busy to free */
	while(HI2C_ICSTR0 & 0x1000);
    
        HI2C_ICSTR0 = 0x1410;
        HI2C_ICMDR0 = 0x0;       
        HI2C_ICOAR0 = 0x20;
      


    
    #ifdef MOZART_QT_TESTING
        sw_delay(DUMMY_COUNT);
    #endif
    
    return(data);
}

unsigned int I2C_writeWord(unsigned int write_value, int iicNumber, int data_bits)
{
 unsigned int len = data_bits/8,count = 0;
 
  if(iicNumber == 0)
	{

	/* Enable the Xmt, Master Mode */
	HI2C_ICMDR0 = 0xE20;

	HI2C_ICCNT0 = len;	
	
	/* Specify the Slave Address */
	HI2C_ICSAR0 = 0x29;

        HI2C_ICOAR0 = 0x10;
   
	/* Wait for Bus Busy */
	while(HI2C_ICSTR0 & 0x1000);
  	    
	/* Wait for the Xmt Free */
	while(!(HI2C_ICSTR0 & 0x10));
	
	HI2C_ICDXR0= ( write_value & 0xFF );
	
	/* Generate the Start Condition */
	HI2C_ICMDR0 |= 0x2000;
	
	while( (!(HI2C_ICSTR0 & 0x1000)) || (HI2C_ICSTR0 & 0x3) )
	{
	      if (HI2C_ICSTR0 & 0x3)
	      { 
	        timeOutRegReset(iicNumber);
	        return(0);
	      }  
	      
	}    
				
	while(--len)
		{		
		count+=8;
		while((!(HI2C_ICSTR0 & 0x10)) || (HI2C_ICSTR0 & 0x3) )	/* Once we receive one byte */
		{
	            if( HI2C_ICSTR0 & 0x3 )
	            { 
	                 timeOutRegReset(iicNumber);
	                 return(0);
                    }  
		}
		HI2C_ICDXR0= (( write_value >> count ) &0xFF );

		}
	
	while(!(HI2C_ICSTR0 & 0x10));

    /* Wait for Bus Busy to free */
	while(HI2C_ICSTR0 & 0x1000)
	{
            if( HI2C_ICSTR0 & 0x3 )
            { 
                 timeOutRegReset(iicNumber);
                 return(0);
            }  
    } 	

    HI2C_ICOAR0 = 0x20;    
        while( (HI2C_ICMDR0 & 0x400) );
    HI2C_ICMDR0 = 0x0;  

    #ifdef MOZART_QT_TESTING
        sw_delay(DUMMY_COUNT);
    #endif
  }    
 

 if(iicNumber == 1)
	{

	/* Enable the Xmt, Master Mode */
	HI2C_ICMDR1 = 0xE20;

	HI2C_ICCNT1 = len;	
	
	/* Specify the Slave Address */
	HI2C_ICSAR1 = 0x29;

        HI2C_ICOAR1 = 0x10;
   
	/* Wait for Bus Busy */
	while(HI2C_ICSTR1 & 0x1000);
  	    
	/* Wait for the Xmt Free */
	while(!(HI2C_ICSTR1 & 0x10));
	
	HI2C_ICDXR1= ( write_value & 0xFF );
	
	/* Generate the Start Condition */
	HI2C_ICMDR1 |= 0x2000;
	
	while( (!(HI2C_ICSTR1 & 0x1000)) || (HI2C_ICSTR1 & 0x3) )
	{
	      if (HI2C_ICSTR1 & 0x3)
	      { 
	        timeOutRegReset(iicNumber);
	        return(0);
	      }  
	      
	}    
				
	while(--len)
		{		
		count+=8;
		while((!(HI2C_ICSTR1 & 0x10)) || (HI2C_ICSTR1 & 0x3) )	/* Once we receive one byte */
		{
	            if( HI2C_ICSTR1 & 0x3 )
	            { 
	                 timeOutRegReset(iicNumber);
	                 return(0);
                    }  
		}
		HI2C_ICDXR1= (( write_value >> count ) &0xFF );

		}
	
	while(!(HI2C_ICSTR1 & 0x10));

    /* Wait for Bus Busy to free */
	while(HI2C_ICSTR1 & 0x1000)
	{
            if( HI2C_ICSTR1 & 0x3 )
            { 
                 timeOutRegReset(iicNumber);
                 return(0);
            }  
    } 	

    HI2C_ICOAR1 = 0x20;    
       while( (HI2C_ICMDR1 & 0x400) );
    HI2C_ICMDR1 = 0x0;  

    #ifdef MOZART_QT_TESTING
        sw_delay(DUMMY_COUNT);
    #endif
    }    
    return(data_bits/8);
}

void DIM_close(int iicNumber)
{

if(iicNumber == 0)
	{
      HI2C_ICOAR0	 =	0x0;
      HI2C_ICIMR0	 =  0x0;
      HI2C_ICSTR0	 = 	0x410;
    //HI2C_ICCLKL0	 = 	0x0;
    //HI2C_ICCLKH0   = 	0x0;
      HI2C_ICCNT0	 =	0x0;
      HI2C_ICDRR0    =	0x0;
      HI2C_ICSAR0	 =	0x3FF;
      HI2C_ICDXR0	 =	0x0;
      HI2C_ICMDR0	 =	0x0;
      HI2C_ICIVR0	 =	0x0;      
    //HI2C_ICPSC0	 =	0x0;
	}


if(iicNumber == 1)
	{
	  DEVCFG_DISABLE_I2C1();
      HI2C_ICOAR1	 =	0x0;
      HI2C_ICIMR1	 =  0x0;
      HI2C_ICSTR1	 = 	0x410;
    //HI2C_ICCLKL1	 = 	0x0;
    //HI2C_ICCLKH1   = 	0x0;
      HI2C_ICCNT1	 =	0x0;
      HI2C_ICDRR1    =	0x0;
      HI2C_ICSAR1	 =	0x3FF;
      HI2C_ICDXR1	 =	0x0;
      HI2C_ICMDR1	 =	0x0;
      HI2C_ICIVR1	 =	0x0;      
    //HI2C_ICPSC1	 =	0x0;
	}
}

unsigned int DIM_writeWord(unsigned int write_value, int iicNumber, int data_bits)
{
  unsigned int return_value;
  do
  {
    return_value=I2C_writeWord(write_value,iicNumber,data_bits);
  }
  while(!return_value);  
  
  return(return_value);
}
