/**============================================================================
*@file dspSwSpiMaster.c
*@desc This file contains source for example code to implement SPI Master
*      protocol in SW.
*
*==============================================================================
* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
* Use of this software us controlled by the terms and conditions found in the
* license agreement under which this software has been supplied
*=============================================================================*/

/*===========================================================================*/
/* This software is provided under the following                             */
/* License Agreement:                                                        */
/*===========================================================================*/
/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
/* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
/* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
/* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
/* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
/* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
/* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
/* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
/* YOUR USE OF THE PROGRAM.                                                  */
/*                                                                           */
/* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
/* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
/* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
/* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
/* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
/* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
/* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
/* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
/* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
/* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
/* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
/* (U.S.$500).                                                               */
/*                                                                           */
/* Unless otherwise stated, the Program written and copyrighted              */
/* by Texas Instruments is distributed as "freeware".  You may,              */
/* only under TI's copyright in the Program, use and modify the              */
/* Program without any charge or restriction.  You may                       */
/* distribute to third parties, provided that you transfer a                 */
/* copy of this license to the third party and the third party               */
/* agrees to these terms by its first use of the Program. You                */
/* must reproduce the copyright notice and any other legend of               */
/* ownership on each copy or partial copy, of the Program.                   */
/*                                                                           */
/* You acknowledge and agree that the Program contains                       */
/* copyrighted material, trade secrets and other TI proprietary              */
/* information and is protected by copyright laws,                           */
/* international copyright treaties, and trade secret laws, as               */
/* well as other intellectual property laws.  To protect TI's                */
/* rights in the Program, you agree not to decompile, reverse                */
/* engineer, disassemble or otherwise translate any object code              */
/* versions of the Program to a human-readable form.  You agree              */
/* that in no event will you alter, remove or destroy any                    */
/* copyright notice included in the Program.  TI reserves all                */
/* rights not specifically granted under this license. Except                */
/* as specifically provided herein, nothing in this agreement                */
/* shall be construed as conferring by implication, estoppel,                */
/* or otherwise, upon you, any license or other right under any              */
/* TI patents, copyrights or trade secrets.                                  */
/*                                                                           */
/* You may not use the Program in non-TI devices.                            */
/*===========================================================================*/


#define CLOCK_ITERATIONS 20
#define CS_SETUP_ITERATIONS 5

void enablePins()
{
// Disable Both Xmt and receiver 
// *((unsigned int *)0x01900008) = 0;
// Make all Pins to be GPIO
*((unsigned int *)0x01900024) = 0x00003000;
// Make CLKX,FSX,DX Output and DR as Input
*((unsigned int *)0x01900024) |=0x00000A00;
}

/* Enable Chip Select */
void enableCS()
{
*((unsigned int *)0x01900024) |= 0x00000008;
}

/* Disable Chip Select */
void disableCS()
{
*((unsigned int *)0x01900024) &= ~0x00000008;
}

/* Set Clock Signal to High */
void clkHigh()
{
*((unsigned int *)0x01900024) |= 0x00000002;
}

/* Set Clock Signal to Low */
void clkLow()
{
*((unsigned int *)0x01900024) &= ~0x00000002;
}

/* Writes the specified value to the DI Pin */
void writeData(unsigned int val)
{
if(val)
	*((unsigned int *)0x01900024) |= 0x20;
else
	*((unsigned int *)0x01900024) &= ~0x20;
}

/* Reads the value in the DO Pin */
unsigned char readData()
{
return ((*((unsigned int *)0x01900024)) & 0x10 );
}

/* SPI Devices has Negative Logic Chip Select */
void enableSPICS()
{
/* disableCS(); */
*((unsigned int *)0x01900024) &= ~0x00000008;
}

void disableSPICS()
{
/* enableCS(); */
*((unsigned int *)0x01900024) |= 0x00000008;
}

void disablePins()
{
}

void ESM_open()
{
enablePins();
clkHigh();
disableSPICS();
}
	
unsigned int ESM_readWord( unsigned int data_bits)
{
unsigned int i;
unsigned int val;
val = 0;
enableSPICS();
sw_delay(CS_SETUP_ITERATIONS);	/* Chip Select Setup Time */
for(i=0;i<data_bits;i++)
	{
	clkLow();
	sw_delay(CLOCK_ITERATIONS);
	if(readData())
		val |=(1<<(data_bits-1-i));
	clkHigh();
	sw_delay(CLOCK_ITERATIONS);
	}
disableSPICS();
return val;
}

void ESM_writeWord(unsigned int write_value, int data_bits)
{
unsigned int mask,i;	
enableSPICS();
sw_delay(CS_SETUP_ITERATIONS);	/* Chip Select Setup Time */
mask = 1<<(data_bits-1);
for(i=0;i<data_bits;i++)
	{
	clkLow();
	writeData(write_value & (mask>>i));
	sw_delay(CLOCK_ITERATIONS);
	clkHigh();
	sw_delay(CLOCK_ITERATIONS);
	}
disableSPICS();
}

void ESM_close()
{
disablePins();
}

