//
// $Source: /cvsstl/ti/pa/b/util/em/bootProtocol.h,v $
// $Revision: 1.2 $
//
// External Master boot protocol definitions
//
// Copyright 2001, Texas Instruments India, Inc.  All rights reserved.
//
// $Log: bootProtocol.h,v $
// Revision 1.2  2003/07/17 22:31:04  dkapoor
// Divij: 3:36 IST 18/7/03
// Added definitions for supporting section pattern fill, device ping
//
// Revision 1.1  2003/07/15 15:43:55  dkapoor
// Divij: 20:49 IST 15/7/03
// External Master boot protocol definitions
//
//

/* Boot Protocol compile time variables */
/* Author:	Vinoth Kumar.A			Date:	March 5th 2002 */

#ifndef __BOOT_PROTOCOL_H
#define __BOOT_PROTOCOL_H

typedef enum BOOT_Type
{
	BOOT_TYPE_Byte,
	BOOT_TYPE_Short,
	BOOT_TYPE_Int,
	BOOT_TYPE_Field
}BOOT_Type;


/* Start Key Words */
#define BOOT_PROTOCOL_XMT_START32				(unsigned int)0x58535441		/* XSTA */
#define BOOT_PROTOCOL_RECV_START32				(unsigned int)0x52535454		/* RSTT */
#define BOOT_PROTOCOL_XMT_START16				(unsigned int)0x5853			/* XS */
#define BOOT_PROTOCOL_RECV_START16				(unsigned int)0x5253			/* RS */
#define BOOT_PROTOCOL_XMT_START8				(unsigned int)0x58				/* X */
#define BOOT_PROTOCOL_RECV_START8				(unsigned int)0x52				/* R */

#define BOOT_PROTOCOL_XMT_SYNC 					(unsigned int)0x58535900		/* XSY */
#define BOOT_PROTOCOL_RECV_SYNC					(unsigned int)0x52535900		/* RSY */

/* Boot Protocol Parameters */
#define BOOT_PROTOCOL_CRC_ERROR_TOLERENCE		2

/* Boot Protocol Sequences */
#define BOOT_PROTOCOL_SECTION_LOAD				1
#define BOOT_PROTOCOL_REQUEST_CRC				2
#define BOOT_PROTOCOL_ENABLE_CRC				3
#define BOOT_PROTOCOL_DISABLE_CRC				4
#define BOOT_PROTOCOL_JUMP						5
#define BOOT_PROTOCOL_JUMP_CLOSE				6
#define BOOT_PROTOCOL_BOOT_TABLE				7
#define BOOT_PROTOCOL_STARTOVER					8
#define BOOT_PROTOCOL_COMPSECTION_LOAD          9 
#define BOOT_PROTOCOL_SECTION_FILL             10
#define BOOT_PROTOCOL_PING_DEVICE              11

#endif
