//
// $Source: /cvsstl/ti/pa/b/util/em/dspSpiMaster.c,v $
// $Revision: 1.4 $
//
// DSP SPI Master Implementation
//
// Copyright 2001, Texas Instruments India, Inc.  All rights reserved.
//
// $Log: dspSpiMaster.c,v $
// Revision 1.4  2005/01/11 11:36:08  dkapoor
// Divij: 11/01/05 17:08 IST
// Added Comments
//
// Revision 1.3  2004/05/31 11:48:19  dkapoor
// Divij: 31/5/04 17:15 IST
// Added DSM_xferWord. This one reads does read as well as write
//
// Revision 1.2  2004/03/29 09:13:18  dkapoor
// Divij: 29/3/04 IST 14:43 IST
// For adding boottime bechmarking support for SPI protocols
//
// Revision 1.1  2003/07/15 15:41:45  dkapoor
// Divij: 20:47 IST 15/7/03
// DSP SPI Master Implementation
//
//


/* DSM 		DSP SPI Master Implementation */
/* Author : Vinoth Kumar.A		Date:	March 5th 2002 */

/* MCBSP Registers */
/* -----------------------------------------------------------------------------*/
/* MCBSP0				MCBSP1				Register Name 						*/
/* -----------------------------------------------------------------------------*/
/* 0x018C0000			0x01900000			Data Receive Register(DRR) 			*/
/* 0x018C0004			0x01900004			Data Transmit Register(DXR) 		*/
/* 0x018C0008			0x01900008			Serial Port Control Register(SPCR) 	*/
/* 0x018C000C			0x0190000C			Receive Control Register(RCR)		*/
/* 0x018C0010			0x01900010			Transmit Control Register(XCR)		*/
/* 0x018C0014			0x01900014			Sample Rate Generator Register(SRGR)*/
/* 0x018C0018			0x01900018			Multi Channel Control Register(MCR)	*/
/* 0x018C0024			0x01900024			Pint Control Register(PCR) 			*/
/* -----------------------------------------------------------------------------*/

/* MCBSP0 Registers and Handles */
#define MCBSP_DRR0 			0x018C0000
#define MCBSP_DXR0			0x018C0004
#define MCBSP_SPCR0			0x018C0008
#define MCBSP_RCR0			0x018C000C
#define MCBSP_XCR0			0x018C0010
#define MCBSP_SRGR0			0x018C0014
#define MCBSP_MCR0			0x018C0018
#define MCBSP_PCR0			0x018C0024

#define HMCBSP_DRR0			(*((volatile unsigned int *)MCBSP_DRR0))
#define HMCBSP_DXR0			(*((volatile unsigned int *)MCBSP_DXR0))
#define HMCBSP_SPCR0		(*((volatile unsigned int *)MCBSP_SPCR0))
#define HMCBSP_RCR0			(*((volatile unsigned int *)MCBSP_RCR0))
#define HMCBSP_XCR0			(*((volatile unsigned int *)MCBSP_XCR0))
#define HMCBSP_SRGR0		(*((volatile unsigned int *)MCBSP_SRGR0))
#define HMCBSP_MCR0			(*((volatile unsigned int *)MCBSP_MCR0))
#define HMCBSP_PCR0			(*((volatile unsigned int *)MCBSP_PCR0))

/* MCBSP1 Registers */
#define MCBSP_DRR1 			0x01900000
#define MCBSP_DXR1			0x01900004
#define MCBSP_SPCR1			0x01900008
#define MCBSP_RCR1			0x0190000C
#define MCBSP_XCR1			0x01900010
#define MCBSP_SRGR1			0x01900014
#define MCBSP_MCR1			0x01900018
#define MCBSP_PCR1			0x01900024

#define HMCBSP_DRR1			(*((volatile unsigned int *)MCBSP_DRR1))
#define HMCBSP_DXR1			(*((volatile unsigned int *)MCBSP_DXR1))
#define HMCBSP_SPCR1		(*((volatile unsigned int *)MCBSP_SPCR1))
#define HMCBSP_RCR1			(*((volatile unsigned int *)MCBSP_RCR1))
#define HMCBSP_XCR1			(*((volatile unsigned int *)MCBSP_XCR1))
#define HMCBSP_SRGR1		(*((volatile unsigned int *)MCBSP_SRGR1))
#define HMCBSP_MCR1			(*((volatile unsigned int *)MCBSP_MCR1))
#define HMCBSP_PCR1			(*((volatile unsigned int *)MCBSP_PCR1))

#define MCBSP_XRDY				0x00020000
#define MCBSP_XEMPTY			0x00040000
#define MCBSP_RRDY				0x00000002

//#define SNIFF
#ifdef SNIFF
	unsigned int *log_reg = (unsigned int *)0x80500000;
#endif


/* Open the DSP SPI Master Device */
void DSM_open(int bspNumber, int data_bits, int clkDivider)
{
	if(bspNumber==0)
	{		/* BSP0 is used */
		HMCBSP_SPCR0	= 0x0;		
		HMCBSP_MCR0		= 0x0;
		HMCBSP_PCR0		= 0x00000A0F;
		HMCBSP_SRGR0	=  0x20000000 | clkDivider;
	
		switch(data_bits)
		{
			case 8:
				HMCBSP_XCR0		= 0x00010000;
				HMCBSP_RCR0		= 0x00010000;
				break;
			case 16:
				HMCBSP_XCR0		= 0x00010040;
				HMCBSP_RCR0		= 0x00010040;
				break;
			case 32:
				HMCBSP_XCR0		= 0x000100A0;
				HMCBSP_RCR0		= 0x000100A0;
				break;
		}
	
		/* Enable Sample Rate Generator */
		HMCBSP_SPCR0	= 0x00400000;
		sw_delay(0xE1*2);
		/* Enable Transmitter, Receiver and Frame Sync */
		HMCBSP_SPCR0   |= 0x00011001;
	}
	else
	{		/* BSP1 is used */
		HMCBSP_SPCR1	= 0x0;		
		HMCBSP_MCR1		= 0x0;
		HMCBSP_PCR1		= 0x00000A0F;
		HMCBSP_SRGR1	= 0x20000000 | clkDivider;
		
		switch(data_bits)
		{
			case 8:
				HMCBSP_XCR1		= 0x00010000;
				HMCBSP_RCR1		= 0x00010000;
				break;
			case 16:
				HMCBSP_XCR1		= 0x00010040;
				HMCBSP_RCR1		= 0x00010040;
				break;
			case 32:
				HMCBSP_XCR1		= 0x000100A0;
				HMCBSP_RCR1		= 0x000100A0;
				break;
		}
		
		/* Enable Sample Rate Generator */
		HMCBSP_SPCR1	= 0x00400000;
		sw_delay(0xE1*2);
		/* Enable Transmitter, Receiver and Frame Sync */
		HMCBSP_SPCR1   |= 0x00011001;
	}	
}

/* Write and read 1 SPI element */
unsigned int DSM_xferWord(int bspNumber,unsigned int data, int data_bits)
{
unsigned int read_value;
if(bspNumber==0)
	{
	while(!(HMCBSP_SPCR0 & MCBSP_XRDY));
	while(HMCBSP_SPCR0 & MCBSP_XEMPTY);
	HMCBSP_DXR0=data;
	while(!(HMCBSP_SPCR0 & MCBSP_RRDY));
	read_value=HMCBSP_DRR0;
	}
if(bspNumber==1)
	{
	while(!(HMCBSP_SPCR1 & MCBSP_XRDY));
	while(HMCBSP_SPCR1 & MCBSP_XEMPTY);
	HMCBSP_DXR1=data;
	while(!(HMCBSP_SPCR1 & MCBSP_RRDY));
	read_value=HMCBSP_DRR1;
	#ifdef SNIFF
		*log_reg = 0xFFFFFFFF;	
		log_reg++;
		*log_reg = read_value;	
		log_reg++;
	#endif	
	}
return read_value;
}

/* Write 0xff.. and read 1 SPI element */
unsigned int DSM_readWord(int bspNumber, int data_bits)
{
	unsigned int read_value;
	
	if(bspNumber==0)
	{
		while(!(HMCBSP_SPCR0 & MCBSP_XRDY));
		while(HMCBSP_SPCR0 & MCBSP_XEMPTY);
		HMCBSP_DXR0=0xFFFFFFFF;
		while(!(HMCBSP_SPCR0 & MCBSP_RRDY));
		read_value=HMCBSP_DRR0;
	}
	
	if(bspNumber==1)
	{
		while(!(HMCBSP_SPCR1 & MCBSP_XRDY));
		while(HMCBSP_SPCR1 & MCBSP_XEMPTY);
		HMCBSP_DXR1=0xFFFFFFFF;
		while(!(HMCBSP_SPCR1 & MCBSP_RRDY));
		read_value=HMCBSP_DRR1;
		#ifdef SNIFF
			*log_reg = 0xFFFFFFFF;	
			log_reg++;
			*log_reg = read_value;	
			log_reg++;
			#endif	
	}
	
	return read_value;
}

/* Write the requested element (The read is done to clear the peripheral read buffer) */
unsigned int DSM_writeWord(unsigned int write_value, int bspNumber, int data_bits)
{
unsigned int read_value;
if(bspNumber==0)
	{
	/* We will come out of this polling loop when Transmitter is ready 
   	for data to be written to DXR. This guarantees us that DXR register
   	is empty. But not the XSR */
	while(!(HMCBSP_SPCR0 & MCBSP_XRDY));

	/* This Polling loop will ensure that XSR Register is empty */
	while(HMCBSP_SPCR0 & MCBSP_XEMPTY);
	/* Ensure that Nothing is there in any of the read registers */
	while(HMCBSP_SPCR0 & MCBSP_RRDY)
		read_value=HMCBSP_DRR0;
	HMCBSP_DXR0 = write_value;
	while(!(HMCBSP_SPCR0 & MCBSP_RRDY));
	read_value=HMCBSP_DRR0;
	}
if(bspNumber==1)
	{
	/* We will come out of this polling loop when Transmitter is ready 
   	for data to be written to DXR. This guarantees us that DXR register
   	is empty. But not the XSR */
	while(!(HMCBSP_SPCR1 & MCBSP_XRDY));

	/* This Polling loop will ensure that XSR Register is empty */
	while(HMCBSP_SPCR1 & MCBSP_XEMPTY);
	/* Ensure that Nothing is there in any of the read registers */
	while(HMCBSP_SPCR1 & MCBSP_RRDY)
		read_value=HMCBSP_DRR1;
	HMCBSP_DXR1 = write_value;
	while(!(HMCBSP_SPCR1 & MCBSP_RRDY));
	read_value=HMCBSP_DRR1;
	#ifdef SNIFF
		*log_reg = write_value;	
		log_reg++;
		*log_reg = read_value;	
		log_reg++;
	#endif	
			
	}
return read_value;
}

/* Close the DSP SPI Master Device */
void DSM_close(int bspNumber)
{
if(bspNumber==0)
	{		/* BSP0 is used */
	HMCBSP_SPCR0	= 0x0;		
	HMCBSP_MCR0		= 0x0;
	HMCBSP_PCR0		= 0x0;
	HMCBSP_SRGR0	= 0x0;
	HMCBSP_XCR0		= 0x0;
	HMCBSP_RCR0		= 0x0;
	}
else
	{		/* BSP1 is used */
	HMCBSP_SPCR1	= 0x0;		
	HMCBSP_MCR1		= 0x0;
	HMCBSP_PCR1		= 0x0;
	HMCBSP_SRGR1	= 0x0;
	HMCBSP_XCR1		= 0x0;
	HMCBSP_RCR1		= 0x0;
	}	
}

