//
// $Source: /cvsstl/ti/pa/b/util/em/em_main.c,v $
// $Revision: 1.3 $
//
// External Master Startup Code
//
// Copyright 2001, Texas Instruments India, Inc.  All rights reserved.
//
// $Log: em_main.c,v $
// Revision 1.3  2005/01/11 11:36:08  dkapoor
// Divij: 11/01/05 17:08 IST
// Added Comments
//
// Revision 1.2  2004/03/29 09:13:18  dkapoor
// Divij: 29/3/04 IST 14:43 IST
// For adding boottime bechmarking support for SPI protocols
//
// Revision 1.1  2003/07/15 15:42:48  dkapoor
// Divij: 20:48 IST 15/7/03
// External Master Startup Code
//
//


#include <stdio.h>
#include <em_protocol.h>
#include <ram_image.h>

#ifdef DSK6713
	#include <dsk6713.h>
	#include <dsk6713_led.h>	
#endif

#define DEVCFG            0x019C0200

#ifdef BOARD_M2
	#define MUX_CTRL      0x90200010
#endif

/* A crude way to achieve delay */
/* Should be substitued by an appropriate routine by the user*/
void sw_delay(int n)
{
	int i;
	for(i=0;i<n;i++);
}


/* External Master main() function routine */
/* Does board specific initialization, validating the signature in AIS image */
/* and finally transfers the control to the serial bootloading protocol implementation*/
int main()
{
	EM_Config fp;
	fp.baseAddress = (unsigned char *)&nvram_image;

#ifdef DSK6713	
	CSL_init();
	DSK6713_init();
	DSK6713_rset(DSK6713_MISC,MCBSP2SEL|MCBSP1SEL);
	DSK6713_LED_toggle(1);	
#endif	

#ifdef BOARD_M2
    *(int *)MUX_CTRL = 0x0D; /* McBSP1_MUX =1, AMUTE0_CTRL=1 (AMUTE0 controlled by PLD) */
    //*(int *)DEVCFG = 0x06;   /* enable TOUT1 and McBSP1 pins */
#endif
	
	/* Populate the Handle with the appropriate protocol details*/
	EM_init(&fp);

#ifdef DSK6711

	if(fp.device == EM_DEVICE_I2C_I2C0 || fp.device ==EM_DEVICE_I2C_I2C1 )
	{
		printf("I2C is not supported by 6711 DSK...\n");
		printf("Use 6713 DSK instead...\n");
		return 1;
	}

#endif

	/* Open the External Master Device */ 
	EM_open(&fp,0);

	/* Validate the AIS signature*/
	if(nvram_image[0]!='T' || nvram_image[1]!='I' || nvram_image[2]!='P' || nvram_image[3]!='A')
	{
		printf("Error in the Image Format\n");
		return 1;
	}
	
	/* Skip the first four bytes (containing the signature) in AIS */
	fp.baseAddress+=4;
	
	/* Call the AIS protocol implementing API */
	EM_protocolImplement(EM_STATE_XCHANGE_STARTWORD,&fp);
	return 0;
}

