//
// $Source: /cvsstl/ti/pa/b/util/em/em_protocol.h,v $
// $Revision: 1.3 $
//
// External Master Protocol/function/device definitions
//
// Copyright 2001, Texas Instruments India, Inc.  All rights reserved.
//
// $Log: em_protocol.h,v $
// Revision 1.3  2005/01/11 11:36:08  dkapoor
// Divij: 11/01/05 17:08 IST
// Added Comments
//
// Revision 1.2  2004/03/29 09:13:18  dkapoor
// Divij: 29/3/04 IST 14:43 IST
// For adding boottime bechmarking support for SPI protocols
//
// Revision 1.1  2003/07/15 15:44:14  dkapoor
// Divij: 20:49 IST 15/7/03
// External Master Protocol/function/device definitions
//
//

/* External Master Data Types */
/* Author:	Vinoth Kumar.A		Date:	March 05,2002 */

#ifndef __EM_PROTOCOL_H
#define __EM__PROTOCOL_H

typedef enum __EM_Device
{
EM_DEVICE_SPI_MCBSP0,
EM_DEVICE_SPI_MCBSP1,
EM_DEVICE_I2C_I2C0,
EM_DEVICE_I2C_I2C1,
EM_DEVICE_SPI_SW
}EM_Device;


typedef enum __EM_State
{
	EM_STATE_XCHANGE_STARTWORD = 1,
	EM_STATE_XCHANGE_SYNCWORD,
	EM_STATE_PROCESS_SYNCWORD,
	EM_STATE_PROCESS_OPCODE_SECTION_LOAD,
	EM_STATE_PROCESS_OPCODE_REQUEST_CRC,
	EM_STATE_SEND_OPCODE_STARTOVER,
	EM_STATE_XCHANGE_OPCODE_STARTOVER,
	EM_STATE_PROCESS_OPCODE_JUMP,
	EM_STATE_PROCESS_OPCODE_JUMP_CLOSE,
	EM_STATE_PROCESS_OPCODE_BOOT_TABLE,
	EM_STATE_PROCESS_OPCODE_COMPSECTION_LOAD,
	EM_STATE_PROCESS_OPCODE_SECTION_FILL,
	EM_STATE_PROCESS_OPCODE_PING_DEVICE
}EM_State;


typedef struct __EM_Config
{
EM_Device device;
unsigned char *baseAddress;
unsigned int data_bits;
unsigned int length;
}EM_Config;

void EM_open(EM_Config *fp,int pllConfigured);
unsigned int EM_readWord(EM_Config *fp);
void EM_writeWord(unsigned int write_value, EM_Config *fp);
unsigned int EM_readWriteWord(unsigned int write_value, EM_Config *fp);
void EM_implementProtocol(int state, EM_Config *fp);
void EM_close(EM_Config *fp);
unsigned int EM_littleEndianWord(unsigned char *address);
#endif

