/*===========================================================================*/
/* This software is provided under the following                             */
/* License Agreement:                                                        */
/*===========================================================================*/
/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
/* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
/* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
/* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
/* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
/* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
/* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
/* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
/* YOUR USE OF THE PROGRAM.                                                  */
/*                                                                           */
/* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
/* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
/* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
/* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
/* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
/* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
/* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
/* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
/* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
/* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
/* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
/* (U.S.$500).                                                               */
/*                                                                           */
/* Unless otherwise stated, the Program written and copyrighted              */
/* by Texas Instruments is distributed as "freeware".  You may,              */
/* only under TI's copyright in the Program, use and modify the              */
/* Program without any charge or restriction.  You may                       */
/* distribute to third parties, provided that you transfer a                 */
/* copy of this license to the third party and the third party               */
/* agrees to these terms by its first use of the Program. You                */
/* must reproduce the copyright notice and any other legend of               */
/* ownership on each copy or partial copy, of the Program.                   */
/*                                                                           */
/* You acknowledge and agree that the Program contains                       */
/* copyrighted material, trade secrets and other TI proprietary              */
/* information and is protected by copyright laws,                           */
/* international copyright treaties, and trade secret laws, as               */
/* well as other intellectual property laws.  To protect TI's                */
/* rights in the Program, you agree not to decompile, reverse                */
/* engineer, disassemble or otherwise translate any object code              */
/* versions of the Program to a human-readable form.  You agree              */
/* that in no event will you alter, remove or destroy any                    */
/* copyright notice included in the Program.  TI reserves all                */
/* rights not specifically granted under this license. Except                */
/* as specifically provided herein, nothing in this agreement                */
/* shall be construed as conferring by implication, estoppel,                */
/* or otherwise, upon you, any license or other right under any              */
/* TI patents, copyrights or trade secrets.                                  */
/*                                                                           */
/* You may not use the Program in non-TI devices.                            */
/*===========================================================================*/

/**============================================================================
*@file progSpi.c
*@desc This file contains code to program the Atmel 25LC640 SPI Eeprom on PADK with
*      data generated by TMS320C672xx bootloader genAIS utility.
*
*      genAis -i blinkLed4.out -o blinkLed4.ais -bootmode spimaster -otype ascii
*
*==============================================================================
* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
* Use of this software us controlled by the terms and conditions found in the
* license agreement under which this software has been supplied
*=============================================================================*/

#include <stdio.h>

/**============================================================================
  Function prototypes
*=============================================================================*/

/**============================================================================
  Global Symbol Declarations
*=============================================================================*/

FILE           *aisIn, *aisOut;
char           *fileName = "..\\..\\app\\app.ais";

unsigned int   aisInVal;

unsigned char   aisData[8172];
unsigned short  byteCnt;


void main(void) {
    int i;

	/* Open AIS file for reading */		
	    aisIn = fopen(fileName,"r");
		            
	    if (aisIn != NULL) 
	    { 
		   byteCnt = 0;
	       printf ("Converting AIS to char array\n");

	       while ((fscanf(aisIn, "%x", &aisInVal)!=EOF)) 
	       {
		
		      aisData[byteCnt] = aisInVal & 0xFF;
			  aisData[byteCnt+1] = ((aisInVal & 0xFF00) >> 8) & 0xFF;
			  aisData[byteCnt+2] = ((aisInVal &0xFF0000) >> 16) & 0xFF;
 			  aisData[byteCnt+3] = ((aisInVal &0xFF000000) >> 24) & 0xFF;

			  byteCnt += 4;
			  if (byteCnt > 8172) {
			    printf ("Array exceeds limits\n");
			  }
		   }


		   printf ("Creating AIS header file\n");
		   printf ("\tByte Count = %d\n",byteCnt);
		   
		   aisOut = fopen("..\\..\\app\\ram_image.h","w");

		   if (aisOut != NULL) 
		   {
		    
			  fprintf(aisOut,"unsigned char nvram_image[] = {\n");
		      for(i=0;i<(byteCnt-4); i+=4) 
		      {
			    fprintf(aisOut,"\t0x%02X, 0x%02X, 0x%02X, 0x%02X,\n",
			            aisData[i], aisData[i+1], aisData[i+2], aisData[i+3]);
			  }
			    fprintf(aisOut,"\t0x%02X, 0x%02X, 0x%02X, 0x%02X\n};\n",
			            aisData[i], aisData[i+1], aisData[i+2], aisData[i+3]);		   }
 
            printf("Header file creation complete\n");
	        fclose(aisIn);
	        fclose(aisOut);

	   } else {

          printf("Could not open AIS inpute file\n");
	   }


}


