//
// $Source: /cvsstl/ti/pa/b/util/em/dspSwSpiMaster.c,v $
// $Revision: 1.2 $
//
// DSP Software SPI Master Implementation
//
// Copyright 2001, Texas Instruments India, Inc.  All rights reserved.
//
// $Log: dspSwSpiMaster.c,v $
// Revision 1.2  2005/01/11 11:36:08  dkapoor
// Divij: 11/01/05 17:08 IST
// Added Comments
//
// Revision 1.1  2003/07/15 15:42:21  dkapoor
// Divij: 20:47 IST 15/7/03
// DSP Software SPI Master Implementation
//
//

/* External Master Implementation Using SW_SPI */
/* Author: Vinoth Kumar.A April 3rd 2002 */

#define CLOCK_ITERATIONS 20
#define CS_SETUP_ITERATIONS 5

void enablePins()
{
// Disable Both Xmt and receiver 
// *((unsigned int *)0x01900008) = 0;
// Make all Pins to be GPIO
*((unsigned int *)0x01900024) = 0x00003000;
// Make CLKX,FSX,DX Output and DR as Input
*((unsigned int *)0x01900024) |=0x00000A00;
}

/* Enable Chip Select */
void enableCS()
{
*((unsigned int *)0x01900024) |= 0x00000008;
}

/* Disable Chip Select */
void disableCS()
{
*((unsigned int *)0x01900024) &= ~0x00000008;
}

/* Set Clock Signal to High */
void clkHigh()
{
*((unsigned int *)0x01900024) |= 0x00000002;
}

/* Set Clock Signal to Low */
void clkLow()
{
*((unsigned int *)0x01900024) &= ~0x00000002;
}

/* Writes the specified value to the DI Pin */
void writeData(unsigned int val)
{
if(val)
	*((unsigned int *)0x01900024) |= 0x20;
else
	*((unsigned int *)0x01900024) &= ~0x20;
}

/* Reads the value in the DO Pin */
unsigned char readData()
{
return ((*((unsigned int *)0x01900024)) & 0x10 );
}

/* SPI Devices has Negative Logic Chip Select */
void enableSPICS()
{
/* disableCS(); */
*((unsigned int *)0x01900024) &= ~0x00000008;
}

void disableSPICS()
{
/* enableCS(); */
*((unsigned int *)0x01900024) |= 0x00000008;
}

void disablePins()
{
}

/*Open the Software SPI Master (McBsp1 pins used in GPIO mode) */
void ESM_open()
{
enablePins();
clkHigh();
disableSPICS();
}

/* Read data_bits no. of elements */	
unsigned int ESM_readWord( unsigned int data_bits)
{
unsigned int i;
unsigned int val;
val = 0;
enableSPICS();
sw_delay(CS_SETUP_ITERATIONS);	/* Chip Select Setup Time */
for(i=0;i<data_bits;i++)
	{
	clkLow();
	sw_delay(CLOCK_ITERATIONS);
	if(readData())
		val |=(1<<(data_bits-1-i));
	clkHigh();
	sw_delay(CLOCK_ITERATIONS);
	}
disableSPICS();
return val;
}

/*Write data_bits no of elements */
void ESM_writeWord(unsigned int write_value, int data_bits)
{
unsigned int mask,i;	
enableSPICS();
sw_delay(CS_SETUP_ITERATIONS);	/* Chip Select Setup Time */
mask = 1<<(data_bits-1);
for(i=0;i<data_bits;i++)
	{
	clkLow();
	writeData(write_value & (mask>>i));
	sw_delay(CLOCK_ITERATIONS);
	clkHigh();
	sw_delay(CLOCK_ITERATIONS);
	}
disableSPICS();
}

/* Close the Software SPI Master */
void ESM_close()
{
disablePins();
}

