/**============================================================================
*@file em_main.c
*@desc This file contains source for example code to illustrate host/master
*      code to drive SPI or I2C boot using AIS command/data stream for 
*      TMS320C672x devices.
*
*==============================================================================
* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
* Use of this software us controlled by the terms and conditions found in the
* license agreement under which this software has been supplied
*=============================================================================*/

/*===========================================================================*/
/* This software is provided under the following                             */
/* License Agreement:                                                        */
/*===========================================================================*/
/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
/* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
/* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
/* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
/* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
/* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
/* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
/* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
/* YOUR USE OF THE PROGRAM.                                                  */
/*                                                                           */
/* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
/* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
/* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
/* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
/* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
/* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
/* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
/* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
/* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
/* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
/* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
/* (U.S.$500).                                                               */
/*                                                                           */
/* Unless otherwise stated, the Program written and copyrighted              */
/* by Texas Instruments is distributed as "freeware".  You may,              */
/* only under TI's copyright in the Program, use and modify the              */
/* Program without any charge or restriction.  You may                       */
/* distribute to third parties, provided that you transfer a                 */
/* copy of this license to the third party and the third party               */
/* agrees to these terms by its first use of the Program. You                */
/* must reproduce the copyright notice and any other legend of               */
/* ownership on each copy or partial copy, of the Program.                   */
/*                                                                           */
/* You acknowledge and agree that the Program contains                       */
/* copyrighted material, trade secrets and other TI proprietary              */
/* information and is protected by copyright laws,                           */
/* international copyright treaties, and trade secret laws, as               */
/* well as other intellectual property laws.  To protect TI's                */
/* rights in the Program, you agree not to decompile, reverse                */
/* engineer, disassemble or otherwise translate any object code              */
/* versions of the Program to a human-readable form.  You agree              */
/* that in no event will you alter, remove or destroy any                    */
/* copyright notice included in the Program.  TI reserves all                */
/* rights not specifically granted under this license. Except                */
/* as specifically provided herein, nothing in this agreement                */
/* shall be construed as conferring by implication, estoppel,                */
/* or otherwise, upon you, any license or other right under any              */
/* TI patents, copyrights or trade secrets.                                  */
/*                                                                           */
/* You may not use the Program in non-TI devices.                            */
/*===========================================================================*/


#include <stdio.h>
#include <em_protocol.h>
#include <..\app\ram_image.h>

#ifdef DSK6713
	#include <dsk6713.h>
	#include <dsk6713_led.h>	
#endif

#define DEVCFG            0x019C0200

#ifdef BOARD_M2
	#define MUX_CTRL      0x90200010
#endif

/* A crude way to achieve delay */
/* Should be substitued by an appropriate routine by the user*/
void sw_delay(int n)
{
	int i;
	for(i=0;i<n;i++);
}


/* External Master main() function routine */
/* Does board specific initialization, validating the signature in AIS image */
/* and finally transfers the control to the serial bootloading protocol implementation*/
FILE *aisImage;


int main()
{
	EM_Config fp;
	fp.baseAddress = (unsigned char *)&nvram_image;

#ifdef DSK6713	
//	CSL_init();
	DSK6713_init();
	DSK6713_rset(DSK6713_MISC,MCBSP2SEL|MCBSP1SEL);
	DSK6713_LED_toggle(1);	
#endif	

#ifdef BOARD_M2
    *(int *)MUX_CTRL = 0x0D; /* McBSP1_MUX =1, AMUTE0_CTRL=1 (AMUTE0 controlled by PLD) */
    //*(int *)DEVCFG = 0x06;   /* enable TOUT1 and McBSP1 pins */
#endif
	
	/* Populate the Handle with the appropriate protocol details*/
	EM_init(&fp);

#ifdef DSK6711

	if(fp.device == EM_DEVICE_I2C_I2C0 || fp.device ==EM_DEVICE_I2C_I2C1 )
	{
		printf("I2C is not supported by 6711 DSK...\n");
		printf("Use 6713 DSK instead...\n");
		return 1;
	}

#endif

	/* Open the External Master Device */ 
	EM_open(&fp,0);

	/* Validate the AIS signature*/
	if(nvram_image[0]!='T' || nvram_image[1]!='I' || nvram_image[2]!='P' || nvram_image[3]!='A')
	{
		printf("Error in the Image Format\n");
		return 1;
	}
	
	/* Skip the first four bytes (containing the signature) in AIS */
	fp.baseAddress+=4;
	
	/* Call the AIS protocol implementing API */
	EM_protocolImplement(EM_STATE_XCHANGE_STARTWORD,&fp);
	return 0;
}

