/**===========================================================================
*@file TIBootCfg.h
*@path $(CSLPATH)
*@desc This file contains data type declarations and pre-defined constants
*      used for seoncdayr boot loader.
*=============================================================================
* Copyright (C) 2004-2005 Texas Instruments Incorporated. 
* Use of this software us controlled by the terms and conditions found in the
* license agreement under which this software has been supplied
*=============================================================================*/
#ifndef __TISecondaryBootH
#define __TISecondaryBootH
/*==================================================================*/
/* Enumerated Constants                                             */
/*==================================================================*/
 typedef enum { OR = 1,
                AND,
                XOR,
                WRITE
 } TIBootMaskType;
 
/**=========================================================================
*@name TISecondaryBootPinSetupObj
*@desc  .
*@field regPtr
*       pointer to register to be modified.
*@field mask
*       mask to use in modifying register value.
*@field mode
*       modification mode (or, and, write, etc.)
*===========================================================================*/
 
typedef struct {
	unsigned int *regPtr;
	unsigned int mask;
	unsigned int mode;
}TISecondaryBootPinSetupObj;
                
/**=========================================================================
*@name TISecondaryBootStatusObj
*@desc  Objects contains all data necessary to copy application code to
*       run destination and branch to start of application.
*@field pkgType
*       Describes device package type (BGA or TQFP).
*@field maxAddressPins
*       Maximum number of configured address pins.
*@field useAddressLatch
*       GPIO Pin configured as address latch for extended FLASH addresses
*@field genCrc
*       generate CRC for check of section loads
*@field aisStreamPtr
*       current pointer to AIS command
*@field bootErr
*       boot Error flag
*@field currentAisCmd
*       current AIS command being processed
*@field lasAisCmd
*       previously processed AIS command
*@field bootCrc
*       currently calculated CRC value
*@field expectedCrc
*       CRC value calculated by AIS generation Tool 
*@field crcErr
*       error in CRC flag
*@field ix
*       generic index counter
*@field sec_address
*       section address where raw data is to be loaded in C672x
*@field sec_size
*       size in 32 bit words of section
*@field lastValidAisCmdOffset
*       negative offset to last valid AIS command (CRC rror recovery point)
*@field tmpPinSetup
*       array of pin configurations to enable use of GPIO's as address pin
*       extensions for parallel FLASH boot
*===========================================================================*/

typedef struct {
	unsigned short pkgType;
	unsigned short maxAddressPins;
	unsigned short useAddressLatch;
	unsigned short genCrc;
	unsigned int *aisStreamPtr;
    unsigned int  bootErr;
    unsigned int currentAisCmd;
    unsigned int lastAisCmd;
    unsigned int bootCRC;
    unsigned int expectedCrc;
    unsigned int crcErr;	
	unsigned int ix;
    unsigned int *sec_address;
    unsigned int sec_size; 
    unsigned int lastValidAisCmdOffset;  
    TISecondaryBootPinSetupObj tmpPinSetup[48];    
}TISecondaryBootStatusObj;



/**=========================================================================
*@name TIBootAsyncCfgObj
*@desc  Objects contains EMIF configuration for Async memory
*@field a1cr
*       Mask for EMIF's A1CR control register
*@field awccr
*       Mask for EMIF'a Extended Wait Control Register AWCCR.
*===========================================================================*/
typedef struct {
	unsigned int asyncCfg;
	unsigned int a1cr;
	unsigned int awccr;
}TIBootAsyncCfgObj;

/**=========================================================================
*@name TIBootAsyncCfgObj
*@desc  Objects contains EMIF configuration for Async memory
*@field pllm
*       PLL Multiplier -  OSC IN Multiplier.
*@field plldiv0
*       PLL Clock Prescaler.
*@feild plldiv1
*       Divide down for CPU clock.
*@field plldiv2
*       Divide down for EMIF clock.
*@field plldiv3
*       Divide down for Peripheral clock
*===========================================================================*/
typedef struct {
	unsigned int pllCfg;
	unsigned int pllm;
	unsigned int plldiv0;
	unsigned int plldiv1;
	unsigned int plldiv2;
	unsigned int plldiv3;
}TIBootPllCfgObj;

/**=========================================================================
*@name TIBootSdramCfgObj
*@desc  Objects contains EMIF configuration for SDRAM memory
*@field sdcr
*       Mask for SDRAM Configuration Register.
*@field sdrcr
*       Mask for SDRAM Refresh Configuration Register.
*@feild sdtimr
*       Mask for SDRAM Timing Register.
*@field sdsretr
*       Mask for SDRAM Exit Self-Refresh Timing Register
*===========================================================================*/
typedef struct {
	unsigned int sdCfg;
	unsigned int sdcr;
	unsigned int sdrcr;
	unsigned int sdtimr;
	unsigned int sdsretr;
}TIBootSdramCfgObj;


/**=========================================================================
*@name TIBootAddressPinObj
*@desc  Object contains necesary information for enable, set, clr, disable
*       of GPIO pins that are being used as address pins to extend the
*       reachable FLASH address space.
*@field pinEnableRegister
*       Address of register to write to , to enable this GPIO pin
*@field pinEnableMask
*       Mask to write to pin Enable Register to enable this pin.
*@field pinSetRegister
*       Addrss of register to write to to drive this pin.
*@field pinSetMask
*       Mask to writ e to the pin Set register to drive this pin.
*@field pinClrRegister
*       Addrss of register to write to clear this pin.
*@field pinClrMask
*       Mask to writ e to the pin Set register to clear this pin.
*@field pinDisableRegister
*       Address of register to write to , to disnable this GPIO pin
*@field pinDisableMask
*       Mask to write to pin Enable Register to disnable this pin.
*===========================================================================*/

typedef struct {
     unsigned int pinEnableRegister;
     unsigned int pinEnableMask;
     unsigned int pinEnableMaskMode;
     unsigned int pinDirectionRegister;
     unsigned int pinDirectionMask;
     unsigned int pinDirectionMaskMode;
     unsigned int pinSetRegister;
     unsigned int pinSetMask;
     unsigned int pinSetMaskMode;
     unsigned int pinClearRegister;
     unsigned int pinClearMask;
     unsigned int pinClearMaskMode;
     unsigned int pinDisableRegister;
     unsigned int pinDisableMask;
     unsigned int pinDisableMaskMode;
} TIBootAddressPinObj;


/*==================================================================*/
/* External Global Symbols                                          */
/*==================================================================*/ 
extern unsigned int TISecondaryBootCRC;
extern void TIBootSetup(void);

/*==================================================================*/
/*  Global Constant Defines                                         */
/*==================================================================*/ 
#define TIBOOT_PKGTYPE_BGA              (1)
#define TIBOOT_PKGTYPE_RFP              (0)
#define TIBOOT_AIS_STREAM_START_ADDRESS (0x90000800u)
#define TIBOOT_EMIF_START_ADDRESS       (0x90000000u)
#define TIBOOT_CFGBRIDGE_REGISTER       (0x40000024u)

/* SDRAM Memory Map */

#define TIBOOT_EMIF_REGS_BASE_ADDR      (0xF0000000u)
#define TIBOOT_EMIF_AWCCR               (TIBOOT_EMIF_REGS_BASE_ADDR + 0x4)
#define TIBOOT_EMIF_SDCR                (TIBOOT_EMIF_REGS_BASE_ADDR + 0x8)
#define TIBOOT_EMIF_SDRCR               (TIBOOT_EMIF_REGS_BASE_ADDR + 0xC)
#define TIBOOT_EMIF_A1CR                (TIBOOT_EMIF_REGS_BASE_ADDR + 0x10)
#define TIBOOT_EMIF_SDTIMR              (TIBOOT_EMIF_REGS_BASE_ADDR + 0x20)
#define TIBOOT_EMIF_SDSRETR             (TIBOOT_EMIF_REGS_BASE_ADDR + 0x3C)

/* PLL Memory Map */

#define TIBOOT_PLL_REG_BASE_ADDR        (0x41000000u)
#define TIBOOT_PLL_PLLCSR               (TIBOOT_PLL_REG_BASE_ADDR + 0x100u)
#define TIBOOT_PLL_PLLM                 (TIBOOT_PLL_REG_BASE_ADDR + 0x110u)
#define TIBOOT_PLL_PLLDIV0              (TIBOOT_PLL_REG_BASE_ADDR + 0x114u)
#define TIBOOT_PLL_PLLDIV1              (TIBOOT_PLL_REG_BASE_ADDR + 0x118u)
#define TIBOOT_PLL_PLLDIV2              (TIBOOT_PLL_REG_BASE_ADDR + 0x11Cu)
#define TIBOOT_PLL_PLLDIV3              (TIBOOT_PLL_REG_BASE_ADDR + 0x120u)
#define TIBOOT_PLL_PLLCMD               (TIBOOT_PLL_REG_BASE_ADDR + 0x138u)
#define TIBOOT_PLL_PLLSTAT              (TIBOOT_PLL_REG_BASE_ADDR + 0x13Cu)
#define TIBOOT_PLL_PLLALNCTL            (TIBOOT_PLL_REG_BASE_ADDR + 0x140u)

/* I2C Memory Map */

#define TIBOOT_I2C1_REG_BASE_ADDR       (0x4A000000u)
#define TIBOOT_I2C1_ICMDR               (TIBOOT_I2C1_REG_BASE_ADDR + 0x024u)
#define TIBOOT_I2C1_ICPSC               (TIBOOT_I2C1_REG_BASE_ADDR + 0x030u)
#define TIBOOT_I2C1_ICCLKL              (TIBOOT_I2C1_REG_BASE_ADDR + 0x00Cu)
#define TIBOOT_I2C1_ICCLKH              (TIBOOT_I2C1_REG_BASE_ADDR + 0x010u)

#define SECTION_LOAD_COMMAND            (0x58535901u)
#define REQUEST_CRC_COMMAND             (0x58535902u)
#define ENABLE_CRC_COMMAND              (0x58535903u)
#define SECTION_FILL_COMMAND            (0x5853590au)
#define JUMP_COMMAND                    (0x58535905u)
#define JUMP_CLOSE_COMMAND              (0x58535906u)
#define DEVICE_CFG_COMMAND              (0x585359F0u)
#define PAGE_SWAP_COMMAND               (0x585359F1u)
#define LATCH_ADDRESS                   (0x585359F2u)

#define PATTERN_32BIT                   (3u)

#define TIBOOT_ERR_CRC                  (0xFF00u)
#define TIBOOT_ERR_INVALID_AIS_CMD      (0xFF01u)

#define TIBOOT_PLLENABLE                (0x01u)
#define TIBOOT_PLLDISABLE               (0x00u)
#define TIBOOT_PLLPWRDN                 (0x02u)
#define TIBOOT_PLLPWRUP                 (0x00u)
#define TIBOOT_PLLOSCPWRDN              (0x04u)
#define TIBOOT_PLLOSCPWRUP              (0x00u)
#define TIBOOT_PLLRESET                 (0x08u)
#define TIBOOT_PLLRESETRELEASE          (0x00u)
#define TIBOOT_PLLSTABLE                (0x40u)
#define TIBOOT_PLLUNSTABLE              (0x00u)
#define TIBOOT_PLLLOCKED                (0x20u)
#define TIBOOT_PLLNOTLOCKED             (0x00u)


/* FOR PLLCMD */
#define TIBOOT_PLLGOCLR                 (0x0000u)
#define TIBOOT_PLLGOSET                 (0x0001u)

/* FOR PLLSTAT */
#define TIBOOT_PLLGODONE                (0x0000u)
#define TIBOOT_PLLGOWAIT                (0x0001u)

/* FOR ALNCTL */
#define TIBOOT_PLLALN1                  (0x0001u)
#define TIBOOT_PLLALN2                  (0x0002u)
#define TIBOOT_PLLALN3                  (0x0004u)

/* FOR PLLDIV0,1,2,3 and OSCDIV1 */
#define TIBOOT_DIVENABLED               (0x8000u)
#endif
