/****************************************************************************/
/*  lnk.cmd   v#####                                                        */
/*  Copyright (c) 1996@%%%%  Texas Instruments Incorporated                 */
/*    Usage:  lnk6x <obj files...>    -o <out file> -m <map file> lnk.cmd   */
/*            cl6x  <src files...> -z -o <out file> -m <map file> lnk.cmd   */
/*                                                                          */
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the C compiler and  */
/*                 running the resulting .out file on a C672x               */
/*                 simulator.  Use it as a guideline.  You will want to     */
/*                 change the memory layout to match your specific C6xxx    */
/*                 target system.  You may want to change the allocation    */
/*                 scheme according to the size of your program.            */
/*                                                                          */
/*    Notes: (1)   You must specify a directory in which rts6x00.lib is     */
/*                 located.  either add a -i"<directory>" line to this      */
/*                 file or use the system environment variable C_DIR to     */
/*                 specify a search path for the libraries.                 */
/*                                                                          */
/*           (2)   If the run-time library you are using is not named       */
/*                 rts6200[e].lib, rts6400[e].lib, or rts6700[e].lib, be    */
/*                 sure to use the correct name here.                       */
/*                                                                          */
/****************************************************************************/
-x
-c
-heap  0x2000
-stack 0x800
-u _TISecondaryBoot_bootstart
-e int00

/* SPECIFY THE SYSTEM MEMORY MAP */

MEMORY
{
    IROM_BOOT:       o = 00000000h   l = 00020000h 
    IROM_DSPLIB:     o = 00020000h   l = 0000C000h 
    IROM_FASTRTS:    o = 0002C000h   l = 00004000h
    IROM_BIOS:       o = 00030000h   l = 00030000h       
    IRAM_BOOT:       o = 10000000h   l = 00001000h
    IRAM_BIOS:       o = 10001000h   l = 00000B00h
    IRAM_RESERVED:   o = 10001B00h   l = 00000100h
	IRAM_STACK:      o = 10001C00h   l = 00000800h
    VEC:             o = 10002400h   l = 00000A00h
	RAM:             o = 10002E00h   l = 00020000h
    ASYNC2:          o = 90000000h   l = 00008000h
    SDRAM:           o = 80000000h   l = 08000000h
}


SECTIONS
{
    

  /*-------------------------------------------------------------*/
  /* Sample allocation for Compiler generated sections that may  */
  /* be defined in application code.                             */
  /*-------------------------------------------------------------*/
    .TIBootStrap {.+= 4;} load = 0x10000000
	.TIBoot      { *(.TIBoot)
	               C:/data/antara/CatalogAntaraBootLoader/catalog_secondary_boot/utils/bin/padkExample/Debug/TISecondaryBootPadk.obj(.switch)} load = 0x10002E00, LOAD_SIZE(_TIBOOT_SEC_SIZE), RUN_START(_TIBOOT_SEC_RUN_ADDR)
    .stack       >       RAM
    .bss         >       RAM
    .cinit       >       RAM
    .pinit       >       RAM
    .cio         >       RAM 
    .const       >       RAM
    .data        >       RAM
    .switch      >       RAM 
    .sysmem      >       RAM
    .text        >       RAM
    .far         >       RAM

                              
}                             