#!/usr/local/bin/perl5.8.0
###############################################################################################
# Copyright 2004, All Rights Reserved, Texas Instruments Incorporate#
# PinCfg.pm
#
# This script is a Perl for describing the data required for properly setting
# a GPIO pin for use as an address pin. This is for use by boot configuration
# utilities for TMS320C672x devices.
#
# 10-Mar-2005
# - Created
#
###############################################################################################
# /*===========================================================================*/
# /* This software is provided under the following                             */
# /* License Agreement:                                                        */
# /*===========================================================================*/
# /* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
# /* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
# /* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
# /* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
# /* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
# /* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
# /* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
# /* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
# /* YOUR USE OF THE PROGRAM.                                                  */
# /*                                                                           */
# /* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
# /* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
# /* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
# /* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
# /* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
# /* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
# /* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
# /* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
# /* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
# /* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
# /* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
# /* (U.S.$500).                                                               */
# /*                                                                           */
# /* Unless otherwise stated, the Program written and copyrighted              */
# /* by Texas Instruments is distributed as "freeware".  You may,              */
# /* only under TI's copyright in the Program, use and modify the              */
# /* Program without any charge or restriction.  You may                       */
# /* distribute to third parties, provided that you transfer a                 */
# /* copy of this license to the third party and the third party               */
# /* agrees to these terms by its first use of the Program. You                */
# /* must reproduce the copyright notice and any other legend of               */
# /* ownership on each copy or partial copy, of the Program.                   */
# /*                                                                           */
# /* You acknowledge and agree that the Program contains                       */
# /* copyrighted material, trade secrets and other TI proprietary              */
# /* information and is protected by copyright laws,                           */
# /* international copyright treaties, and trade secret laws, as               */
# /* well as other intellectual property laws.  To protect TI's                */
# /* rights in the Program, you agree not to decompile, reverse                */
# /* engineer, disassemble or otherwise translate any object code              */
# /* versions of the Program to a human-readable form.  You agree              */
# /* that in no event will you alter, remove or destroy any                    */
# /* copyright notice included in the Program.  TI reserves all                */
# /* rights not specifically granted under this license. Except                */
# /* as specifically provided herein, nothing in this agreement                */
# /* shall be construed as conferring by implication, estoppel,                */
# /* or otherwise, upon you, any license or other right under any              */
# /* TI patents, copyrights or trade secrets.                                  */
# /*                                                                           */
# /* You may not use the Program in non-TI devices.                            */
# /*===========================================================================*/

#use strict qw(subs refs);
#use warnings qw(all);

package PinCfg;

use FindBin;
use lib "$FindBin::Bin/../lib";
use Symbol;
use Tk;
use Tk::Balloon;
use Tk::Checkbutton;
use Tk::FileSelect;
use Tk::Pane;
use Tk::Tiler;


###############################################################################
#  $pinCofiguration = new("periph", 
#                          "pinName", 
#                          pinEnableRgister,
#                          pinEnableMask,
#                          enableMaskMode,
#                          pinDirectionRegister,
#                          pinDirectionMask,
#                          directionMaskMode,
#                          pinSetRegister,
#                          pinSetMask,
#                          setMaskMode
#                          pinClearRegister,
#                          pinClearMask,
#                          clearMaskMode
#                          pinDisableRegister,
#                          pinDisableMask,
#                          disableMaskMode,
#                          pinGlobalEnableRegister,
#                          pinGlobalEnableMask,
#                          globalEnableMaskMode
#                         )
###############################################################################
sub new {

  my ($class) = shift(@_);
  my ($pinName) = shift(@_);
  my ($pinEnableRegister) = shift(@_);
  my ($pinEnableMask) = shift(@_);
  my ($enableMaskMode) = shift(@_);
  my ($pinDirectionRegister) = shift(@_);
  my ($pinDirectionMask) = shift(@_);
  my ($directionMaskMode) = shift(@_);  
  my ($pinSetRegister) = shift(@_);
  my ($pinSetMask) = shift(@_);
  my ($setMaskMode) = shift(@_);
  my ($pinClearRegister) = shift(@_);
  my ($pinClearMask) = shift(@_);
  my ($clearMaskMode) = shift(@_);
  my ($pinDisableRegister) = shift(@_);
  my ($pinDisableMask) = shift(@_);
  my ($disableMaskMode) = shift(@_);
  my ($globalSetupFlag)     = shift(@_);
  my ($globalSetup) = [];
#   my ($pinGlobalEnableRegister) = shift(@_);
#   my ($pinGlobalEnableMask) = shift(@_);
#   my ($globalEnableMaskMode) = shift(@_);
  my ($this) = {};
  my ($name,$path,$suffix,$binFile);
  bless($this, $class);


  $this->{'pinName'} = $pinName;
  $this->{'pinEnableRegister'} = $pinEnableRegister;
  $this->{'pinEnableMask'} = $pinEnableMask;
  $this->{'enableMaskMode'} = $enableMaskMode;
  $this->{'pinDirectionRegister'} = $pinDirectionRegister;
  $this->{'pinDirectionMask'} = $pinDirectionMask;
  $this->{'directionMaskMode'} = $directionMaskMode;  
  $this->{'pinSetRegister'} = $pinSetRegister;
  $this->{'pinSetMask'} = $pinSetMask;
  $this->{'setMaskMode'} = $setMaskMode;
  $this->{'pinClearRegister'} = $pinClearRegister;
  $this->{'pinClearMask'} = $pinClearMask;
  $this->{'clearMaskMode'} = $clearMaskMode;
  $this->{'pinDisableRegister'} = $pinDisableRegister;
  $this->{'pinDisableMask'} = $pinDisableMask;
  $this->{'disableMaskMode'} = $disableMaskMode;
  $this->{'globalSetupFlag'} = $globalSetupFlag;
  
  
  if ($globalSetupFlag) {
     for($i = 0; $i < $globalSetupFlag; ++$i) {
	     $this->{'globalSetup'}[$i]{'regAddr'} = shift(@_);
	     $this->{'globalSetup'}[$i]{'regVal'} = shift(@_);
	     $this->{'globalSetup'}[$i]{'regSetMode'} = shift(@_);
     }
  }

  return $this;
}


#----------------------------------------------------------------------------------------
sub delete {
  undef $_[1];
}

#########################################################################################
return 1;
#########################################################################################
