/****************************************************************************/
/*  patch.cmd   v#####                                                      */
/*  Copyright (c) 1996@%%%%  Texas Instruments Incorporated                 */
/*    Usage:  lnk6x <obj files...>    -o <out file> -m <map file> lnk.cmd   */
/*            cl6x  <src files...> -z -o <out file> -m <map file> lnk.cmd   */
/*                                                                          */
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the C compiler and  */
/*                 for applying the System patch.                           */
/*                                                                          */
/****************************************************************************/
-c
-heap  0x2000
-stack 0x4000

/* Include Objects and Library to apply the ROM Patch */
-l applySystemPatch.obj               
-l c672xSystemPatchV2_00_00.lib

/* SPECIFY THE SYSTEM MEMORY MAP */

MEMORY
{
    IROM_BOOT:       o = 00000000h   l = 00020000h 
    IROM_DSPLIB:     o = 00020000h   l = 0000C000h 
    IROM_FASTRTS:    o = 0002C000h   l = 00004000h
    IROM_BIOS:       o = 00030000h   l = 00030000h       
    IRAM_BOOT:       o = 10000000h   l = 00001000h
    IRAM_BIOS:       o = 10001000h   l = 00000B00h 
    IRAM_RESERVED:   o = 10001B00h   l = 00000100h /* Reserved only if using ROMed applications */
                                                      
    IRAM:            o = 10001C00h   l = 0003E400h
    BOOTSRAM:        o = 90000000h   l = 10000000h
    SDRAM:           o = 80000000h   l = 10000000h
}


SECTIONS
{
    

  /*-------------------------------------------------------------*/
  /* Sample allocation for Compiler generated sections that may  */
  /* be defined in application code.                             */
  /*-------------------------------------------------------------*/
    .text        >       IRAM
    .stack       >       IRAM
    .bss         >       IRAM
    .cinit       >       IRAM
    .pinit       >       IRAM
    .cio         >       IRAM 
    .const       >       IRAM
    .data        >       IRAM
    .switch      >       IRAM 
    .sysmem      >       IRAM
    .far         >       IRAM
                              
}                             