/* ======================================================================== */
/*  TEXAS INSTRUMENTS, INC.                                                 */
/*                                                                          */
/*  NAME                                                                    */
/*      sp_autocor -- Driver file for sp_autocor                            */
/*                                                                          */
/*  USAGE                                                                   */
/*      This code contains a driver program for testing the 'sp_autocor'    */
/*      kernel.  The function prototype appears below.  The driver itself   */
/*      is invoked as a standard C program, and results are reported on     */
/*      stdout.                                                             */
/*                                                                          */
/*      Building this with the "COMM_FLOW" and "RAND_DATA" macros set       */
/*      will build a driver which generates and tests with random data      */
/*      sets.  Otherwise, the driver will use a fixed test vector.          */
/* ------------------------------------------------------------------------ */
/*          Copyright (C) 2005 Texas Instruments, Incorporated.             */
/*                          All Rights Reserved.                            */
/* ======================================================================== */
#include <stdio.h>

#include "dspf_sp_autocor.h"

/* ======================================================================== */
/*  Kernel-specific alignments                                              */
/* ======================================================================== */
#pragma DATA_ALIGN(x, 8);

/* ======================================================================== */
/*  Parameters used for random vectors:                                     */
/* ======================================================================== */
#define NR   (16)
#define NX   (32)

float  r [NR];

float  x [NX+NR] = 
{
 
    0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
    0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,
    0.297100, 1.055500, 0.250500, 0.388300, 2.980300, 1.542700, 1.021400, 1.850100, 
    1.705000, 2.350600, 2.154300, 0.598100, 0.200000, 2.260100, 2.984300, 2.022100, 
    3.156900, 0.903900, 2.844500, 0.347500, 0.756500, 0.031200, 0.732600, 3.141300, 
    3.111000, 2.590700, 2.856400, 0.338100, 0.816600, 2.565300, 1.910100, 0.970500,  

};


/* ======================================================================== */
/*  MAIN -- Top level driver for the test.                                  */
/* ======================================================================== */
int main()
{   
   	printf("Running single precision autocor from C672x ROM ...\n\n");
    DSPF_sp_autocor(r, x, NX, NR);
	printf("Complete.\n");
}

/* ======================================================================== */
/*  End of file:  sp_autocor/sp_autocor_d.c                                 */
/* ------------------------------------------------------------------------ */
/*          Copyright (C) 2005 Texas Instruments, Incorporated.             */
/*                          All Rights Reserved.                            */
/* ======================================================================== */
