/* ======================================================================== */
/*  TEXAS INSTRUMENTS, INC.                                                 */
/*                                                                          */
/*  NAME                                                                    */
/*      sinsp -- Single Precision Sine                                      */
/*                                                                          */
/*S AUTHOR                                                                 S*/
/*S     Roshan Gummattira                                                  S*/
/*S                                                                        S*/
/*S REVISION HISTORY                                                       S*/
/*S     14-Oct-2002 Initial revision . . . . . . . . . . .  Autogen        S*/
/*S                                                                        S*/
/*  USAGE                                                                   */
/*      This function is C callable, and is called according to this        */
/*      C prototype:                                                        */
/*                                                                          */
/*      float sinf                                                          */
/*      (                                                                   */
/*        float a  // Argument 1   //                                       */
/*      );                                                                  */
/*                                                                          */
/*  DESCRIPTION                                                             */
/*      This kernel returns the single precision sine of the                */
/*      floating point argument a expressed in radians. The return          */
/*      value is in the range of [-1,+1].                                   */
/*                                                                          */
/*  TECHNIQUES                                                              */
/*                                                                          */
/*  SOURCE                                                                  */
/* ------------------------------------------------------------------------ */
/*            Copyright (c) 2002 Texas Instruments, Incorporated.           */
/*                           All Rights Reserved.                           */
/* ======================================================================== */
#ifndef SINSP_CN_H_
#define SINSP_CN_H_ 1

float sinsp_cn(float a);

#endif
/* ======================================================================== */
/*  End of file: sinsp_c.c                                                  */
/* ------------------------------------------------------------------------ */
/*          Copyright (C) 2002 Texas Instruments, Incorporated.             */
/*                          All Rights Reserved.                            */
/* ======================================================================== */
