#include "lib.hpp"

// Unless we force the compiler to instantiate the template in the executable
// project (TEMPLATE_AWARE >= 2) the linker complains about Dummy<int>::double_size()
// being undefined.
// When forcing an instantiation the linker updates main.obj (the application object)
// at link time to include the definition, but the library object (lib.obj) never has it.
// Note that in the case of Dummy<int>::size() which is defined in the struct's body this
// doesn't happen.

#define TEMPLATE_AWARE 2

#if TEMPLATE_AWARE > 0
#   include "template.hpp"

#   if TEMPLATE_AWARE > 1
typedef size_t dummy[sizeof(Dummy<int>)];
#   endif
#endif

int main()
{
    volatile size_t small = do_something_small(), big = do_something_big();

    return 0;
}
