#ifndef __ARK_DATA_TYPES_H__
#define __ARK_DATA_TYPES_H__

#ifdef __cplusplus
namespace ark{
#endif

#ifndef __cplusplus
# define bool char
#endif

#define dt_bool    bool
#define dt_logical bool

#include <ark_premitive_data_types.h>

// scalar data types
//#define dt_byte    char
//#define dt_int8    char
//#define dt_char    char
//#define dt_int16   short
//#define dt_int32   int
//#define dt_int     int
//#define dt_int64   long long
//#define dt_uint8   unsigned char
//#define dt_uint16  unsigned short
//#define dt_uint32  unsigned int
//#define dt_uint    unsigned int
//#define dt_uint64  unsigned long long
//#define dt_single  float
//#define dt_float   float
//#define dt_double  double
//#define dt_ldouble long double
//#define dt_real    double
//#define dt_real_   dt_real
//#define dt_enum    int

// scalar numeric conversion functions
inline dt_logical logical(const double & d)	{ return d != 0; }
inline dt_int8    int8(const double & d)	{ return (dt_int8)d; }
inline dt_int16   int16(const double & d)	{ return (dt_int16)d; }
inline dt_int32   int32(const double & d)	{ return (dt_int32)d; }
inline dt_int64   int64(const double & d)	{ return (dt_int64)d; }
inline dt_uint8   uint8(const double & d)	{ return (dt_uint8)d; }
inline dt_uint16  uint16(const double & d)	{ return (dt_uint16)d; }
inline dt_uint32  uint32(const double & d)	{ return (dt_uint32)d; }
inline dt_uint64  uint64(const double & d)	{ return (dt_uint64)d; }
inline dt_single  single(const double & d)	{ return (dt_single)d; }
inline dt_double  Double(const double & d)	{ return (dt_double)d; }
inline dt_ldouble ldouble(const double & d) { return (dt_ldouble)d; }
inline dt_real    real(const double & d)	{ return (dt_real)d; }

char _dt_logical_str[]	= "dt_logical";
char _dt_int8_str[]		= "dt_int8";
char _dt_int16_str[]	= "dt_int16";
char _dt_int32_str[]	= "dt_int32";
char _dt_int64_str[]	= "dt_int64";
char _dt_uint8_str[]	= "dt_uint8";
char _dt_uint16_str[]	= "dt_uint16";
char _dt_uint32_str[] 	= "dt_uint32";
char _dt_uint64_str[] 	= "dt_uint64";
char _dt_single_str[] 	= "dt_single";
char _dt_double_str[] 	= "dt_double";
char _dt_ldouble_str[] 	= "dt_ldouble";

inline char* typenameof(const dt_logical & v){ return _dt_logical_str; }
inline char* typenameof(const dt_int8 & v)	 { return _dt_int8_str; }
inline char* typenameof(const dt_int16 & v)	 { return _dt_int16_str; }
inline char* typenameof(const dt_int32 & v)	 { return _dt_int32_str; }
inline char* typenameof(const dt_int64 & v)	 { return _dt_int64_str; }
inline char* typenameof(const dt_uint8 & v)	 { return _dt_uint8_str; }
inline char* typenameof(const dt_uint16 & v) { return _dt_uint16_str; }
inline char* typenameof(const dt_uint32 & v) { return _dt_uint32_str; }
inline char* typenameof(const dt_uint64 & v) { return _dt_uint64_str; }
inline char* typenameof(const dt_single & v) { return _dt_single_str; }
inline char* typenameof(const dt_double & v) { return _dt_double_str; }
inline char* typenameof(const dt_ldouble & v){ return _dt_ldouble_str; }


#ifdef __cplusplus
} // end of namespace ark
#endif

#endif /* __ARK_DATA_TYPES_H__ */
