#ifndef __ARK_MATRIX_H__
#define __ARK_MATRIX_H__

#include<iostream>
#include <iomanip>
//#include<cstdio>
#include<cstdlib>
#include<cmath>
#include<ctime>

#include "ark_data_types.h"
#include "ark_data_consts.h"
//#include "imp.h"

#define DEBUG_VERBOSE(m)

#ifdef RUN_ON_DSP
#include "../ark_dsp_6678/ark_ipc_c6678.h"
int getProcId(){ return getCoreId(); }
#else
int getProcId(){ return 0; }
#endif // RUN_ON_DSP

namespace ark{
template <class V>
class matrix;
}

//namespace la{
//template<class V, class V1>
//bool cv_solve(const ark::matrix<V>& A, const ark::matrix<V1>& b,
//		ark::matrix<V>& x, int method = 4 );
//}

bool show_now;

namespace ark{

typedef struct _seprator{ } separator;
const separator _separator_ = {};


#define __	,ark::separator,
#define _	,ark::_separator_,

enum attribute{
	NONE = 0,  // no attributes set
    COMPLEX = 1,  SPARSE = 2,  UNUSED_1 = 4,   UNUSED_2 = 8,   // data type attributes
	DOT     = 16, LEFT   = 32, TEMPORARY = 64, UNUSED_3 = 128  // internal operational attributes
};


template <class V>
class matrix{
public:
	typedef V ElemType;
	static matrix<V> null_mat();
//	static matrix<dt_uint32> null_mat_uint32;
	enum __null_mat {null_mat_uint32=1};
	int nrows, ncols;
	char attribs;
	V* data;
	inline int numel() const {
	    return nrows*ncols;
	}
	inline int size(int i) const {
	    return (i == 1 ? nrows : ncols);
	}
	inline int isempty() const {
        return numel() == 0;
    }
	inline void minit(int nr, int nc, attribute attrs = NONE){
		nrows = nr;
		ncols = nc;
		attribs = (unsigned char)attrs;

		if(!isempty()){
			data  = new V[numel()];

			#ifdef MAT_MEM_PROFILE
			mem_profile_new(numel());
			#endif // MAT_MEM_PROFILE
		}else{
			data = (V*)(void *)0;
		}
	}
	inline void swap(matrix<V>* a, matrix<V>* b){
		int tmpi;
		tmpi = a->nrows; a->nrows = b->nrows; b->nrows = tmpi;
		tmpi = a->ncols; a->ncols = b->ncols; b->ncols = tmpi;

		V* tmpr;
		tmpr = a->data; a->data = b->data; b->data = tmpr;

		unsigned char tmpa;
        tmpa = a->attribs; a->attribs = b->attribs; b->attribs = tmpa;
	}

public:
	// default constructor
	matrix(){
		minit(0,0);
	}
	matrix(const V& val, attribute attrs = NONE){
	    DEBUG_VERBOSE("ctor matrix(V)");
		minit(1,1, attrs);
		csi0(0) = val;
	}
	matrix(int nr, int nc, attribute attrs = NONE){
	    DEBUG_VERBOSE("ctor matrix(int,int)");
		minit(nr,nc, attrs);
	}
	matrix(int nr, int nc, const V& val, attribute attrs = NONE){
	    DEBUG_VERBOSE("ctor matrix(int,int,V)");
		minit(nr,nc, attrs);
		for(int i = 0; i < numel() ; i++)
			csi0(i) = val;
	}
	template <class V1>
	matrix(int nr, int nc, const V1* vals, const dt_double& val, attribute attrs = NONE){
	    DEBUG_VERBOSE("ctor matrix(int,int,V1*)");
		minit(nr,nc, attrs);
		for(int i = 0; i < numel() ; i++)
			csi0(i) = /*(V)*/vals[i];
	}

	matrix(const matrix<V> & m){
	    DEBUG_VERBOSE("ctor matrix(matrix<V>)");
	    // copy constructor
//		if(m.get_attribute(TEMPORARY)){
//			// intelligent method for minimizing copywork
//            // m is temporary, so just capture its data
//            //   needs pointer casting to get around const& qualifier of m
//
//            // first init it, otherwise swap results in segmentation fault
//            minit(0,0,NONE);
// 			swap(this,(matrix<V>*)(void*)&m);
// 			//this->clear_attribute(TEMPORARY);
//		}else{
            minit(m.size(1), m.size(2), (attribute)m.attribs);

            for(int i = 0; i < numel(); i++)
                csi0(i) = m.csi0(i);

//		}
	}

	virtual ~matrix(){
	    DEBUG_VERBOSE("dtor ~matrix()");
		//if(!isempty()){
		if(data){
			delete [] data;

			#ifdef MAT_MEM_PROFILE
			mem_profile_del(numel());
			#endif // MAT_MEM_PROFILE

			nrows = ncols = 0;
		}
	}
	// elementary indexing functions for zero-based serial (1D) & 2D access to elements
	virtual inline V& cij0(int i , int j) const{
		// this definitions makes row-major (C-like) matrices
		//return data[i*ncols+j];

		// this definitions makes column-major matrices
		return data[i+j*nrows];
	}
	virtual inline V& csi0(int i) const{
		return data[i];
	}

	void print(std::ostream & out = std::cout) const{
		out << "matrix<" << typenameof(*data) << ">(" << nrows << "x" << ncols << ")" << std::endl;
		for(int i = 0; i < nrows; i++){
			for(int j = 0; j < ncols; j++){
				out << cij0(i,j);
				if(j<ncols-1)
					out << " ";
			}
			if(i < nrows-1)
				out << std::endl;
		}
		if(numel() == 0)
			std::cout << "[]";
		out << std::endl;
	}
	friend std::ostream & operator<<(std::ostream & os, const matrix<V>& m) {
		m.print(os);
		return os;
	}

};

} // end of namespace ark


#endif /* __ARK_MATRIX_H__ */
