#ifndef UTILS_H
#define UTILS_H

//#include <cmath>
//#include <cassert>
//#include <chrono>
//#include <ctime>

#ifdef USE_REGEX
#include <regex>
#endif

//#ifndef __ARK_MATRIX_H__
//#define ERROR(msg)  if(0){ } else { std::cout << std::endl << "Error, runtime error in file:'" << __FILE__ << "' at line:" << __LINE__ << ": " << std::endl << " " << msg << std::endl; exit(1);}
//#define ABORT(msg)  if(0){ } else { std::cout << std::endl << "Error, runtime error in file:'" << __FILE__ << "' at line:" << __LINE__ << ": " << std::endl << " " << msg << std::endl; exit(1); }
//#define ASSERT(cond, msg) if(cond){ } else { std::cout << std::endl << "Error, assertion failed in file:'" << __FILE__ << "' at line:" << __LINE__ << ": " << std::endl << ' ' << msg << std::endl; exit(1); }
//#define ASSERT_SHORT(cond) ASSERT(cond, #cond)
//#endif
//
////#include "ark_io.h"
//
//#include "ark_matrix.h"
//
//typedef unsigned char uchar;
//typedef unsigned short ushort;
//
//#define abs_dist(x1, y1, x2, y2) (pow((x1) - (x2), 2) + pow((y1) - (y2),2))
//#define PI (3.1415926535897932384626)
////#define cosd(x) ((float)cos((x) * PI / 180))
////#define sind(x) ((float)sin((x) * PI / 180))
//#define EL_ROW_MAJOR(i, j, cols) ((i)*(cols) + (j))
//#define EL_COL_MAJOR(i, j, rows) ((j)*(rows) + (i))
//
//// string util functions
//#define lower(__str) 									\
//	{													\
//		for(int __i = 0; __i < strlen(__str); __i++) {	\
//			if('A' <= __str[__i] && __str[__i] <= 'Z'){	\
//				__str[__i] = __str[__i] - 'A' + 'a';	\
//			}											\
//		} 												\
//	}
//
//// tic toc functions for time profiling
//#define _init_time_profile \
//	std::chrono::high_resolution_clock::time_point _last_tic; 	\
//	std::chrono::high_resolution_clock::time_point _cur_tic; 	\
//	float _tic_diff;
//
//#define _tic_time_profile \
//		_last_tic = std::chrono::high_resolution_clock::now();
//
//#define _toc_time_profile 			 							\
//	_cur_tic = std::chrono::high_resolution_clock::now(); 		\
//	_tic_diff = clock_diff(_cur_tic, _last_tic);				\
//	_last_tic = _cur_tic;
//
//#define _show_time_profile( func, params, internum ) 			\
//	_last_tic = _cur_tic; 										\
//	std::cerr << "Timeprofile: " 								\
//			<< " Func: " << func		  						\
//			<< " Params: " << params							\
//			<< " " << (_tic_diff/((double) internum)/1e9) <<	\
//			" (s)" << std::endl;
//
//#define _show_time_profile_csv( func, params, internum ) 		\
//	_last_tic = _cur_tic; 										\
//	std::cerr << std::setprecision(15) << "Timeprofile:" 		\
//			<< ",\"" << func << "\",\""		  					\
//			<< params << "\"," 		  							\
//			<< (_tic_diff/((double) internum)/1e9)  			\
//			<< std::endl;
//
//
//
//#define clock_diff(t2, t1) (std::chrono::duration_cast<std::chrono::nanoseconds>((t2) - (t1)).count());
//
//#ifdef _DEBUG
//#define printvar(a) std::cerr << (#a) << " = " << (a) << std::endl;
//#define printnvp(a, b) std::cerr << (a) << " = " << (b) << std::endl;
//#define printsth(a) std::cerr << (a) << std::endl;
//#define printline std::cerr << __FILE__ << " " << __LINE__ << std::endl;
//#define printlinetime std::cout << __FILE__ << " " << __LINE__ << "\n\t"; toc(); tic();
//#else
//#define printvar(a) std::cout << (#a) << " = " << (a) << std::endl;
//#define printnvp(a, b) std::cout << (a) << " = " << (b) << std::endl;
//#define printsth(a) std::cout << (a) << std::endl;
//#define printline std::cout << __FILE__ << " " << __LINE__ << std::endl;
//#define printlinetime // std::cout << __FILE__ << " " << __LINE__ << "\n\t"; toc(); tic();
//#define warning(msg) std::cout << __FILE__ << " " << __LINE__ << std::endl \											<< (msg) << std::endl;
//#endif
//
//namespace ark{
//template <class V>
//class matrix;
//}
//
//template <class V>
//void copy_data_to_array(const ark::matrix<V>& mx_image, V* arr, bool row_major){
//	if (row_major)
//		for (int i = 0; i < mx_image.nrows; i++) {
//			for (int j = 0; j < mx_image.ncols; j++) {
//				arr[j + i*(mx_image.ncols)] = mx_image.data[j*(mx_image.nrows) + i];
//			}
//		}
//	else
//		for (int i = 0; i < mx_image.numel(); i++) {
//			arr[i] = mx_image.data[i];
//		}
//}
//
//template <class V>
//void copy_data_from_array(ark::matrix<V>& mx_image, const V* arr, bool row_major){
//	if (row_major)
//		for (int i = 0; i < mx_image.nrows; i++) {
//			for (int j = 0; j < mx_image.ncols; j++) {
//				mx_image.data[j*(mx_image.nrows) + i] = arr[j + i*(mx_image.ncols)];
//			}
//		}
//	else
//		for (int i = 0; i < mx_image.numel(); i++) {
//			mx_image.data[i] = arr[i];
//		}
//}
//
/////////////////////////////////////////////////////////
//// angle unit conversion between degree and radian
/////////////////////////////////////////////////////////
//#define CONVANG_DEG_2_RAD(deg, V) ((V) ((deg) * PI / 180.0))
//#define CONVANG_RAD_2_DEG(deg, V) ((V) ((deg) * 180.0 / PI ))
//
//#undef ERROR
//#define ERROR(msg)  if(1){ } else { std::cout << std::endl << "Error, runtime error in file:'" << __FILE__ << "' at line:" << __LINE__ << ": " << std::endl << " " << msg << std::endl; exit(1);}
//
//template <class V> inline
//ark::matrix<V> convang(const ark::matrix<V>& ll0, const char* UI, const char* UO){
//	ark::matrix<V> retmat = ark::matrix<V>(ll0.size(1), ll0.size(2));
//	V* out_ptr = retmat.data;
//	if (strcmp(UI, "deg") == 0 && strcmp(UO, "rad") == 0){
//		for(int i = 0; i < ll0.numel(); i++){
//			*out_ptr++ = CONVANG_DEG_2_RAD(ll0.csi0(i), V);
//		}
//	} else if (strcmp(UI, "rad") == 0 && strcmp(UO, "deg") == 0){
//		for(int i = 0; i < ll0.numel(); i++){
//			*out_ptr++ = CONVANG_RAD_2_DEG(ll0.csi0(i), V);
//		}
//	} else {
//		ERROR( "Illegal conversion: deg->rad and rad->deg allowed only" );
//	}
//	return retmat;
//}
//
//template <class V>
//void convang_inplace(const ark::matrix<V>& ll0, const char* UI, const char* UO){
//	if (strcmp(UI, "deg") == 0 && strcmp(UO, "rad") == 0){
//		for(int i = 0; i < ll0.numel(); i++){
//			ll0.csi0(i) = CONVANG_DEG_2_RAD(ll0.csi0(i), V);
//		}
//	} else if (strcmp(UI, "rad") == 0 && strcmp(UO, "deg") == 0){
//		for(int i = 0; i < ll0.numel(); i++){
//			ll0.csi0(i) = CONVANG_RAD_2_DEG(ll0.csi0(i), V);
//		}
//	} else {
//		ERROR( "Illegal conversion: deg->rad and rad->deg allowed only" );
//	}
//}
//
//template <class V, class V1>
//inline V mod(V x, V1 y){
//    return (x/y - std::floor(x/y))*y;
//}
//
//template <typename V>
//short int sign(V x){
//	return (((x) > 0) ? (1): ((x) < 0 ? -1: 0) );
//}

#ifdef USE_REGEX
template <class V>
void string_to_matrix( std::string s, const ark::matrix<V>& mat){
//	std::string s(str_a_vals);
	std::regex e("[\\s;\\]\\[]+");
	std::regex_token_iterator<std::string::iterator>
									i(s.begin(), s.end(), e, -1);
	std::regex_token_iterator<std::string::iterator>
									end;
	int idx = 0;

	while (i != end && idx < mat.numel()){
		std::string ss = *i++;
		if (ss.size() > 0 ){

			V vv = static_cast<V> (std::stod( ss ));
		   mat.cij0(idx / mat.size(2), idx % mat.size(2)) = vv;
		   idx++;
		}
	}
}

template <class V>
void string_to_matrix( const char* str_a_vals, const ark::matrix<V>& mat){
	std::string s(str_a_vals);
	std::regex e("[\\s;\\]\\[]+");
	std::regex_token_iterator<std::string::iterator>
									i(s.begin(), s.end(), e, -1);
	std::regex_token_iterator<std::string::iterator>
									end;
	int idx = 0;

	while (i != end && idx < mat.numel()){
		std::string ss = *i++;
		if (ss.size() > 0 ){
		   mat.cij0(idx / mat.size(2), idx % mat.size(2)) =
				   	   	   	   	   	   	   static_cast<V> (std::stod( ss ));
		   idx++;
		}
	}
}
#endif

#undef DO_LOG
#endif // UTILS_H_



