/* ==============================================================================
File Name:	  	sineAnalyzerWithPowerMeas.c

Target: C2000 Floating Point Device

Author: Manish Bhardwaj, C2000 Systems Solutions Group

Description: improved sine analyzer routine for less noise on the AC output

Copyright (C) {2015} Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED*
=================================================================================  */
/* ==============================================================================
File Name:	  	sineAnalyzerWithPowerMeas.h

Target: C2000 Floating Point Device

Author: Manish Bhardwaj, C2000 Systems Solutions Group

Description: improved sine analyzer routine for less noise on the AC output

Copyright (C) {2015} Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED*
=================================================================================  */


//*****************************************************************************
// the includes
//*****************************************************************************
/*****************************************************************************/
/* STDINT.H v16.9.1                                                          */
/*                                                                           */
/* Copyright (c) 2002-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/

/* 7.18.1.1 Exact-width integer types */

    typedef          int    int16_t;
    typedef unsigned int   uint16_t;
    typedef          long   int32_t;
    typedef unsigned long  uint32_t;


    typedef          long long  int64_t;
    typedef unsigned long long uint64_t;

/* 7.18.1.2 Minimum-width integer types */

    typedef  int16_t  int_least8_t;
    typedef uint16_t uint_least8_t;

    typedef  int16_t  int_least16_t;
    typedef uint16_t uint_least16_t;
    typedef  int32_t  int_least32_t;
    typedef uint32_t uint_least32_t;


    typedef  int64_t  int_least64_t;
    typedef uint64_t uint_least64_t;

/* 7.18.1.3 Fastest minimum-width integer types */

    typedef  int16_t  int_fast8_t;
    typedef uint16_t uint_fast8_t;
    typedef  int16_t  int_fast16_t;
    typedef uint16_t uint_fast16_t;

    typedef  int32_t  int_fast32_t;
    typedef uint32_t uint_fast32_t;


    typedef  int64_t  int_fast64_t;
    typedef uint64_t uint_fast64_t;

/* 7.18.1.4 Integer types capable of holding object pointers */
    typedef          long intptr_t;
    typedef unsigned long uintptr_t;

/* 7.18.1.5 Greatest-width integer types */
    typedef          long long intmax_t;
    typedef unsigned long long uintmax_t;

/* 
   According to footnotes in the 1999 C standard, "C++ implementations
   should define these macros only when __STDC_LIMIT_MACROS is defined
   before <stdint.h> is included." 
*/

/* 7.18.2 Limits of specified width integer types */
















/* 7.18.3 Limits of other integer types */







/* 7.18.4.1 Macros for minimum-width integer constants */

/*
   There is a defect report filed against the C99 standard concerning how 
   the (U)INTN_C macros should be implemented.  Please refer to --
   http://wwwold.dkuug.dk/JTC1/SC22/WG14/www/docs/dr_209.htm 
   for more information.  These macros are implemented according to the
   suggestion given at this web site.
*/




/* 7.18.4.2 Macros for greatest-width integer constants */



/*
 * Copyright (c) 2015-2015 Texas Instruments Incorporated
 *
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

/*
 * from: @(#)fdlibm.h 5.1 93/09/24
 * $FreeBSD$
 */


#pragma diag_push
#pragma CHECK_MISRA("-6.3") /* standard types required for standard headers */
#pragma CHECK_MISRA("-16.4") /* identifiers in fn defn/decl identical??? fabs/fabsf */
#pragma CHECK_MISRA("-19.1") /* only comments and preproc before #include */
#pragma CHECK_MISRA("-19.7") /* macros required for implementation */
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */
#pragma CHECK_MISRA("-20.2") /* standard headers must define standard names */

/*****************************************************************************/
/* linkage.h   v16.9.1                                                        */
/*                                                                           */
/* Copyright (c) 1998-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push
#pragma CHECK_MISRA("-19.4") /* macros required for implementation */

/* No modifiers needed to access code */


/*--------------------------------------------------------------------------*/
/* Define _DATA_ACCESS ==> how to access RTS global or static data          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Define _OPTIMIZE_FOR_SPACE ==> Always optimize for space.                */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Define _IDECL ==> how inline functions are declared                      */
/*--------------------------------------------------------------------------*/

#pragma diag_pop

/*****************************************************************************/
/* _defs.h   v16.9.1                                                         */
/*                                                                           */
/* Copyright (c) 2015-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push

#pragma CHECK_MISRA("-8.1") /* visible prototypes */
#pragma CHECK_MISRA("-8.5") /* functions in header files */
#pragma CHECK_MISRA("-8.11") /* use static on fns with internal linkage */
#pragma CHECK_MISRA("-10.1") /* implicit conversion ... bool to int??? */
#pragma CHECK_MISRA("-12.1") /* operator precedence */
#pragma CHECK_MISRA("-12.2") /* different order of operations??? */
#pragma CHECK_MISRA("-12.4") /* RHS of &&/|| has side effects??? */
#pragma CHECK_MISRA("-14.7") /* single point of return */
#pragma CHECK_MISRA("-14.9") /* only compound statement after if/else */
#pragma CHECK_MISRA("-19.1") /* only comments and preproc before #include??? */
#pragma CHECK_MISRA("-19.4") /* macro expands to unparenthesized */

#pragma diag_suppress 1558 /* --float_operations_allowed checks */ 

/* This file is included in other user header files; take care not to
   pollute the namespace */


typedef unsigned long long __uint64_t;
typedef unsigned long __uint32_t;


/* normalize target-specific intrinsics */































/* always inline these functions so that calls to them don't appear in
   an object file and become part of the ABI. */

 __inline int __isfinite(double d)
{ return (((((unsigned int)(__f32_bits_as_u32(d) >> 16)) & 0x7f80u) == 0x7f80u)) == 0; }
 __inline int __isfinitef(float f)
{ return (((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)) == 0; }
 __inline int __isfinitel(long double e)
{ return (((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)) == 0; }

 __inline int __isnan(double d)
{ return (((((unsigned int)(__f32_bits_as_u32(d) >> 16)) & 0x7f80u) == 0x7f80u)) &&
        ((((__f32_bits_as_u32(d) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)) == 0); }
 __inline int __isnanf(float f)
{ return (((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)) &&
        ((((__f32_bits_as_u32(f) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)) == 0); }
 __inline int __isnanl(long double e)
{ return (((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)) &&
        ((((__f64_bits_as_u64(e) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)) == 0); }

 __inline int __isnormal(double d)
{ return ((((((unsigned int)(__f32_bits_as_u32(d) >> (24-1))) & ((128u * 2) - 1)) == 0)) == 0) &&
         ((((((unsigned int)(__f32_bits_as_u32(d) >> 16)) & 0x7f80u) == 0x7f80u)) == 0); }

 __inline int __isnormalf(float f)
{ return ((((((unsigned int)(__f32_bits_as_u32(f) >> (24-1))) & ((128u * 2) - 1)) == 0)) == 0) &&
         ((((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)) == 0); }

 __inline int __isnormall(long double e)
{ return (((((__f64_bits_as_u64(e) >> (53-1)) & ((1024u * 2) - 1)) == 0)) == 0) &&
         ((((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)) == 0); }

 __inline int __signbit(double d)
{ return (((__f32_bits_as_u32(d) & ((__uint32_t)(1) << (32-1))) == 0)) == 0; }
 __inline int __signbitf(float f)
{ return (((__f32_bits_as_u32(f) & ((__uint32_t)(1) << (32-1))) == 0)) == 0; }
 __inline int __signbitl(long double e)
{ return (((__f64_bits_as_u64(e) & ((__uint64_t)(1) << (64-1))) == 0)) == 0; }

/* FreeBSD lib/libc/gen/isinf.c says "These routines belong in libm,
   but they must remain in libc for binary compat until we can bump
   libm's major version number" */

 __inline int __isinff(float f)
{ return (((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)) && (((__f32_bits_as_u32(f) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)); }
 __inline int __isinf (double d)
{ return (((((unsigned int)(__f32_bits_as_u32(d) >> 16)) & 0x7f80u) == 0x7f80u)) && (((__f32_bits_as_u32(d) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)); }
 __inline int __isinfl(long double e)
{ return (((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)) && (((__f64_bits_as_u64(e) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)); }

/* Symbolic constants to classify floating point numbers. */

 __inline int __fpclassifyf(float f)
{
    if ((((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)))
    {
        if ((((__f32_bits_as_u32(f) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)))
            return 1;
        else return 2;
    }
    if ((((((unsigned int)(__f32_bits_as_u32(f) >> (24-1))) & ((128u * 2) - 1)) == 0)))
    {
        if ((((__f32_bits_as_u32(f) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)))
            return 0;
        else return (-2);
    }            
    return (-1);
}

 __inline int __fpclassify (double d)
{
    if ((((((unsigned int)(__f32_bits_as_u32(d) >> 16)) & 0x7f80u) == 0x7f80u)))
    {
        if ((((__f32_bits_as_u32(d) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)))
            return 1;
        else return 2;
    }
    if ((((((unsigned int)(__f32_bits_as_u32(d) >> (24-1))) & ((128u * 2) - 1)) == 0)))
    {
        if ((((__f32_bits_as_u32(d) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)))
            return 0;
        else return (-2);
    }            
    return (-1);
}

 __inline int __fpclassifyl(long double e)
{
    if ((((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)))
    {
        if ((((__f64_bits_as_u64(e) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)))
            return 1;
        else return 2;
    }
    if (((((__f64_bits_as_u64(e) >> (53-1)) & ((1024u * 2) - 1)) == 0)))
    {
        if ((((__f64_bits_as_u64(e) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)))
            return 0;
        else return (-2);
    }            
    return (-1);
}



/*
 * Relevant target macros indicating hardware float support
 *
 * all
 * 	__TI_STRICT_FP_MODE__
 * ARM
 *      __TI_VFPV3_SUPPORT__
 *      __TI_VFPV3D16_SUPPORT__
 *      __TI_FPv4SPD16_SUPPORT__
 *      __TI_VFP_SUPPORT__
 * C2000
 *      __TMS320C28XX_FPU32__
 *      __TMS320C28XX_FPU64__
 *      __TMS320C28XX_TMU__	adds div, sqrt, sin, cos, atan, atan2
 * C6000
 *      _TMS320C6700		indicates C67x or later
 */







#pragma diag_pop



/*
 * ANSI/POSIX
 */





/* Symbolic constants to classify floating point numbers. */





/*
 * XOPEN/SVID
 */


/*---------------------------------------------------------------------------*/
/* If --fp_mode=relaxed is used and VFP is enabled, use the hardware square  */
/* root directly instead of calling the sqrtx routine. This will not set     */
/* errno if the argument is negative.                                        */
/*                                                                           */
/* This is done by defining sqrt to _relaxed_sqrt to allow other translation */
/* units to use the normal sqrt routine under strict mode.                   */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* TMU SUPPORT AND RELAXED MODE: USE INSTRINSICS.                            */
/*---------------------------------------------------------------------------*/
#pragma CHECK_MISRA("-19.4") /* macro defined to be an identifier is OK */
#pragma CHECK_MISRA("-8.1") /* function definition with no prototype visible */
#pragma CHECK_MISRA("-8.5") /* function definitions required */
#pragma CHECK_MISRA("-8.11") /* non-static function definition OK */

#pragma diag_suppress 1558 /* --float_operations_allowed checks */

/* Float cases */
__inline float __relaxed_sqrtf(float x)
{
    return __sqrt(x);
}
__inline float __relaxed_sinf(float x)
{
    return __sin(x);
}
__inline float __relaxed_cosf(float x)
{
    return __cos(x);
}
__inline float __relaxed_atanf(float x)
{
  return __atan2(x, 1.0);
}
__inline float __relaxed_atan2f(float y, float x)
{
  return __atan2(y,x);
}

/* Double cases */
__inline double __relaxed_sqrt(double x)
{
    return __sqrt(x);
}
__inline double __relaxed_sin(double x)
{
    return __sin(x);
}
__inline double __relaxed_cos(double x)
{
    return __cos(x);
}
__inline double __relaxed_atan(double x)
{
  return __atan2(x, 1.0);
}
__inline double __relaxed_atan2(double y, double x)
{
  return __atan2(y,x);
}

/* Disable double_t and float_t for C28x because of Motorware (AY 2015) */

 double      acos(double x);
 float       acosf(float x);
 long double acosl(long double x);
 double      asin(double x);
 float       asinf(float x);
 long double asinl(long double x);
 double      __relaxed_atan(double x);
 float       __relaxed_atanf(float x);
 long double atanl(long double x);
 double      __relaxed_atan2(double y, double x);
 float       __relaxed_atan2f(float y, float x);
 long double atan2l(long double y, long double x);
 double      __relaxed_cos(double x);
 float       __relaxed_cosf(float x);
 long double cosl(long double x);
 double      __relaxed_sin(double x);
 float       __relaxed_sinf(float x);
 long double sinl(long double x);
 double      tan(double x);
 float       tanf(float x);
 long double tanl(long double x);
 double      acosh(double x);
 float       acoshf(float x);
 long double acoshl(long double x);
 double      asinh(double x);
 float       asinhf(float x);
 long double asinhl(long double x);
 double      atanh(double x);
 float       atanhf(float x);
 long double atanhl(long double x);
 double      cosh(double x);
 float       coshf(float x);
 long double coshl(long double x);
 double      sinh(double x);
 float       sinhf(float x);
 long double sinhl(long double x);
 double      tanh(double x);
 float       tanhf(float x);
 long double tanhl(long double x);
 double      exp(double x);
 float       expf(float x);
 long double expl(long double x);
 double      exp2(double x);
 float       exp2f(float x);
 long double exp2l(long double x);
 double      expm1(double x);
 float       expm1f(float x);
 long double expm1l(long double x);
 double      frexp(double val, int *e);
 float       frexpf(float val, int *e);
 long double frexpl(long double val, int *e);
 int         ilogb(double x);
 int         ilogbf(float x);
 int         ilogbl(long double x);
 double      ldexp(double x, int e);
 float       ldexpf(float x, int e);
 long double ldexpl(long double x, int e);
 double      log(double x);
 float       logf(float x);
 long double logl(long double x);
 double      log10(double x);
 float       log10f(float x);
 long double log10l(long double x);
 double      log1p(double x);
 float       log1pf(float x);
 long double log1pl(long double x);
 double      log2(double x);
 float       log2f(float x);
 long double log2l(long double x);
 double      logb(double x);
 float       logbf(float x);
 long double logbl(long double x);
 double      modf(double val, double *iptr);
 float       modff(float val, float *iptr);
 long double modfl(long double val, long double *iptr);
 double      scalbn(double x, int n);
 float       scalbnf(float x, int n);
 long double scalbnl(long double x, int n);
 double      scalbln(double x, long n);
 float       scalblnf(float x, long n);
 long double scalblnl(long double x, long n);
 double      cbrt(double x);
 float       cbrtf(float x);
 long double cbrtl(long double x);
 double      fabs(double x);
 float       fabsf(float x);
 long double fabsl(long double x);
 double      hypot(double x, double y);
 float       hypotf(float x, float y);
 long double hypotl(long double x, long double y);
 double      pow(double x, double y);
 float       powf(float x, float y);
 long double powl(long double x, long double y);
 double      __relaxed_sqrt(double x);
 float       __relaxed_sqrtf(float x);
 long double sqrtl(long double x);
 double      erf(double x);
 float       erff(float x);
 long double erfl(long double x);
 double      erfc(double x);
 float       erfcf(float x);
 long double erfcl(long double x);
 double      lgamma(double x);
 float       lgammaf(float x);
 long double lgammal(long double x);
 double      tgamma(double x);
 float       tgammaf(float x);
 long double tgammal(long double x);
 double      ceil(double x);
 float       ceilf(float x);
 long double ceill(long double x);
 double      floor(double x);
 float       floorf(float x);
 long double floorl(long double x);
 double      nearbyint(double x);
 float       nearbyintf(float x);
 long double nearbyintl(long double x);
 double      rint(double x);
 float       rintf(float x);
 long double rintl(long double x);
 long        lrint(double x);
 long        lrintf(float x);
 long        lrintl(long double x);
 long long   llrint(double x);
 long long   llrintf(float x);
 long long   llrintl(long double x);
 double      round(double x);
 float       roundf(float x);
 long double roundl(long double x);
 long        lround(double x);
 long        lroundf(float x);
 long        lroundl(long double x);
 long long   llround(double x);
 long long   llroundf(float x);
 long long   llroundl(long double x);
 double      trunc(double x);
 float       truncf(float x);
 long double truncl(long double x);
 double      fmod(double x, double y);
 float       fmodf(float x, float y);
 long double fmodl(long double x, long double y);
 double      remainder(double x, double y);
 float       remainderf(float x, float y);
 long double remainderl(long double x, long double y);
 double      remquo(double x, double y, int *quo);
 float       remquof(float x, float y, int *quo);
 long double remquol(long double x, long double y, int *quo);
 double      copysign(double x, double y);
 float       copysignf(float x, float y);
 long double copysignl(long double x, long double y);
 double      nan(const char *tagp);
 float       nanf(const char *tagp);
 long double nanl(const char *tagp);
 double      nextafter(double x, double y);
 float       nextafterf(float x, float y);
 long double nextafterl(long double x, long double y);
 double      nexttoward(double x, long double y);
 float       nexttowardf(float x, long double y);
 long double nexttowardl(long double x, long double y);
 double      fdim(double x, double y);
 float       fdimf(float x, float y);
 long double fdiml(long double x, long double y);
 double      fmax(double x, double y);
 float       fmaxf(float x, float y);
 long double fmaxl(long double x, long double y);
 double      fmin(double x, double y);
 float       fminf(float x, float y);
 long double fminl(long double x, long double y);
 double      fma(double x, double y, double z);
 float       fmaf(float x, float y, float z);
 long double fmal(long double x, long double y, long double z);


#pragma diag_pop


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop

//*****************************************************************************
//defines
//*****************************************************************************
typedef struct {
	float v;   					// Input: Voltage Sine Signal
	float i;   					// Input Current Signal
	float sampleFreq;   		// Input: Signal Sampling Freq
	float threshold;   			// Input: Voltage level corresponding to zero i/p
	float vRms;   				// Output: RMS Value
	float vAvg;   				// Output: Average Value
	float vEma;					// Output: Exponential Moving Average Value
	float acFreq;   			// Output: Signal Freq
	float acFreqAvg;   			// Output: Signal Freq
	float iRms;   				// Output: RMS Value of current
	float pRms;   				// Output: RMS Value of input power
	float vaRms;				// Output: RMS VA
	float powerFactor;			// Output: powerFactor
	int16_t  zcd;   			// Output: Zero Cross detected
	float vSum;				// Internal : running sum for vacc_avg calculation over one sine cycle
	float vSqrSum;      		// Internal : running sum for vacc_rms calculation over one sine cycle
	float iSqrSum;      		// Internal : running sum for Iacc_rms calculation over one sine cycle
	float acFreqSum;   			// Output: Signal Freq
	float pSum;      		// Internal : running sum for Pacc_rms calculation over one sine cycle
	float vaSumMul;      		// Internal : running sum for Pacc_rms calculation over one sine cycle
	float vNorm; 			// Internal: Normalized value of the input voltage
	float iNorm; 			// Internal: Normalized value of the input current
	int16_t  prevSign;			// Internal: Flag to detect ZCD
	int16_t  currSign;         	// Internal: Flag to detect ZCD
	int32_t  nSamples;			// Internal: No of samples in one cycle of the sine wave
	int32_t  nSamplesMin;		// Internal: Lowerbound for no of samples in one sine wave cycle
	int32_t  nSamplesMax;		// Internal: Upperbound for no of samples in one sine wave cycle
	float inverse_nSamples;		// Internal: 1/( No of samples in one cycle of the sine wave)
	float sqrt_inverse_nSamples;// Internal: sqrt(1/( No of samples in one cycle of the sine wave))
	int16_t  slewPowerUpdate; 	// Internal: used to slew update of the power value
	float pRmsSumMul;				// Internal: used to sum Pac value over multiple sine cycles (100)
	int16_t jitterCount;
	float emaFilterMultiplier;
} sineAnalyzerWithPowerMeas;

typedef sineAnalyzerWithPowerMeas *sineAnalyzerWithPowerMeas_Handle;

//*****************************************************************************
// the function prototypes
//*****************************************************************************

void sineAnalyzerWithPowerMeas_init(sineAnalyzerWithPowerMeas *v);
void sineAnalyzerWithPowerMeas_calc(sineAnalyzerWithPowerMeas *v);



//*********** Structure Init Function ****//
void sineAnalyzerWithPowerMeas_init(sineAnalyzerWithPowerMeas *v)
{
	v->v=0;
	v->i=0;
	v->sampleFreq=0;
	v->threshold=0;
	v->vRms=0;
	v->vAvg=0;
	v->vEma=0;
	v->acFreq=0;
	v->iRms=0;
	v->pRms=0;
	v->vaRms=0;
	v->powerFactor=0;
	v->zcd=0;
	v->vSum=0;
	v->vSqrSum=0;
	v->iSqrSum=0;
	v->pSum=0;
	v->vaSumMul=0;
	v->vNorm=0;
	v->iNorm=0;
	v->prevSign=1;
	v->currSign=1;
	v->nSamples=0;
	v->nSamplesMin = 0;
	v->nSamplesMax = 0;
	v->inverse_nSamples=0;
	v->sqrt_inverse_nSamples=0;
	v->slewPowerUpdate=0;
	v->pRmsSumMul=0;
	v->acFreqSum=0;
	v->acFreqAvg=0;
	v->jitterCount=0;
	v->emaFilterMultiplier=0;
}

//*********** Function Definition ********//
void sineAnalyzerWithPowerMeas_calc(sineAnalyzerWithPowerMeas *v)
{
	v->vNorm = fabs(v->v);
	v->iNorm = fabs(v->i);
	v->currSign = ( v->v > v->threshold) ? 1 : 0;
	v->nSamples++;
	v->vSum = v->vSum+v->vNorm;
	v->vSqrSum = v->vSqrSum+(v->vNorm*v->vNorm);
	v->vEma = v->vEma+(v->emaFilterMultiplier*(v->vNorm - v->vEma));
	v->iSqrSum = v->iSqrSum+(v->iNorm*v->iNorm);
	v->pSum = v->pSum+(v->i*v->v);
	v->zcd=0;

	if((v->prevSign != v->currSign)
			&& (v->currSign == 1))
	{
		// check if the nSamples are in the ball park of a real frequency
		// that can be on the grid, this is done by comparing the nSamples
		// with the max value and min value it can be for the AC Grid Connection
		// these Max and Min are initialized by the user in the code
		if(v->nSamplesMin < v->nSamples )
		{
			v->zcd=1;
			v->inverse_nSamples = (1.0)*__einvf32(v->nSamples);
			v->sqrt_inverse_nSamples = (1.0)*__eisqrtf32(v->nSamples);
			v->vAvg = (v->vSum*v->inverse_nSamples);
			v->vRms = __relaxed_sqrt(v->vSqrSum)*v->sqrt_inverse_nSamples;
			v->iRms = __relaxed_sqrt(v->iSqrSum)*v->sqrt_inverse_nSamples;
			v->pRmsSumMul = v->pRmsSumMul + (v->pSum*v->inverse_nSamples);
			v->vaSumMul = v->vaSumMul + v->vRms*v->iRms;
			v->acFreq = (v->sampleFreq*v->inverse_nSamples);
			v->acFreqSum = v->acFreqSum + v->acFreq;

			v->slewPowerUpdate++;

			if(v->slewPowerUpdate >= 100)
			{
				v->slewPowerUpdate=0;
				v->pRms = (v->pRmsSumMul*(0.01));
				v->pRmsSumMul = 0;
				v->vaRms = v->vaSumMul * (0.01);
				v->vaSumMul = 0;
				v->powerFactor=v->pRms/v->vaRms;
				v->acFreqAvg=v->acFreqSum*0.01;
				v->acFreqSum=0;
			}

			v->jitterCount=0;

			v->nSamples=0;
			v->vSum=0;
			v->vSqrSum=0;
			v->iSqrSum=0;
			v->pSum =0;
		}
		else
		{
			// otherwise it may be jitter ignore this reading
			// but count the number of jitters you are getting
			// but do not count to infinity as then when the grid comes back
			//it will take too much time to wind down the jitter count
			if(v->jitterCount<30)
				v->jitterCount++;
			v->nSamples=0;
		}

	}

	if(v->nSamples>v->nSamplesMax || v->jitterCount>20)
		{
			// most certainly the AC voltage is not present
			v->vRms = 0;
			v->vAvg = 0;
			v->vEma = 0;
			v->acFreq=0;
			v->iRms = 0;
			v->pRms = 0;
			v->vaRms =0;
			v->powerFactor=0;

			v->zcd=0;
			v->vSum=0;
			v->vSqrSum=0;
			v->iSqrSum=0;
			v->pSum=0;
			v->vaSumMul=0;
			v->pRmsSumMul = 0;
			v->acFreqAvg = 0;
			v->acFreqSum =0 ;
			v->nSamples=0;
			v->jitterCount=0;
		}

	v->prevSign = v->currSign;
}
