/*  system.c  */
#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/sysctl.h"
#include "driverlib/interrupt.h"
#include "driverlib/gpio.h"
#include "system.h"

// for UART0
#include "driverlib/pin_map.h"
#include "uart0.h"


uint32_t u32SysClk;

void system_init(void)
{
  // Initialize system clock to 120 MHz
  u32SysClk = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ |
    SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), SYSTEM_CLOCK);
  
  // LED pins Init
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPION); // Port N[0,1]
  while (!SysCtlPeripheralReady(SYSCTL_PERIPH_GPION)) { };
	GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_1 | GPIO_PIN_0);

  // State Flag Pins
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOL); // Port L[0..5]
  while (!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOL)) { };
  GPIOPinTypeGPIOOutput(GPIO_PORTL_BASE, GPIO_PIN_5 |  GPIO_PIN_4 |
                GPIO_PIN_3 |  GPIO_PIN_2 |  GPIO_PIN_1 | GPIO_PIN_0);

  // UART0 Init
	UART0_Init();
  IntMasterEnable();
} // system_init


void __error__(char *pcFilename, uint32_t ui32Line)
{
  // Place a breakpoint here to capture errors until logging routine is finished
  while (1)
  {
  }
} // __error__

