/*  uart0.c  */
#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/sysctl.h"
#include "system.h"

// for UART0
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/uart.h"
 #include "inc/hw_ints.h"
#include "driverlib/interrupt.h"

#define ETX  0x0A

const uint32_t fifo_len = 16;

bool fU0Rx;
uint8_t Buff[64];
uint32_t rxi, TxCount;
uint8_t *TxPtr;


void UART0_Init (void)
{
  // Enable the UART0 and GPIOA peripherals
	SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
	while (!SysCtlPeripheralReady(SYSCTL_PERIPH_UART0))	{	};
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
	while (!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOA))	{	};

  // Configure the pins for the receiver and transmitter
	GPIOPinConfigure(GPIO_PA0_U0RX);
	GPIOPinConfigure(GPIO_PA1_U0TX);
	GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

	UARTConfigSetExpClk(UART0_BASE, u32SysClk, 115200,
			(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
      
	UARTFIFOEnable(UART0_BASE); // actually enabled by default!
	UARTFIFOLevelSet(UART0_BASE, UART_FIFO_TX1_8, UART_FIFO_RX1_8);

	IntEnable(INT_UART0);
	UARTIntEnable(UART0_BASE, UART_INT_RX); // RX Only
	UARTIntEnable(UART0_BASE, UART_INT_RX | UART_INT_RT); // Rx 2 bytes or timeout
} // UART0_Init


void UART0_Send (uint8_t *txptr, uint32_t count)
{
  uint32_t fifo_count;

  fifo_count = 0;
//  GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_0, GPIO_PIN_0);
  while ((count) && (fifo_count < fifo_len + 1))
  {
    UARTCharPut(UART0_BASE, *txptr);
    count--;
    fifo_count++;
    txptr++;
  }
//  GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_0, 0);

  if (count)
  {
//    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_1, GPIO_PIN_1);
    TxPtr = txptr;
    TxCount = count;
    UARTIntEnable(UART0_BASE, UART_INT_TX);
//    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_1, 0);
  }
} // UART0_Send


void UARTIntHandler(void)
{
  uint32_t ui32Status;
  uint32_t fifo_count;

  ui32Status = UARTIntStatus(UART0_BASE, true); // get interrupt status
  UARTIntClear(UART0_BASE, ui32Status); // clear the asserted interrupts

  if (ui32Status & UART_INT_RX)
  {
    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_0, GPIO_PIN_0);
    while (UARTCharsAvail(UART0_BASE))
    {
      Buff[rxi] = (uint8_t)UARTCharGetNonBlocking(UART0_BASE); // UARTCharGet(UART0_BASE);
      if (Buff[rxi] == ETX)
      {
        GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_1, GPIO_PIN_1);
        fU0Rx = 1;
      }
      rxi++;
    }
    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_0, 0);
  }

  if (ui32Status & UART_INT_TX)
  {
//    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_2, GPIO_PIN_2);
    fifo_count = 0;
    while ((TxCount) && (fifo_count < 14)) // FIFO Size - 1/8
    {
      UARTCharPut(UART0_BASE, *TxPtr);
      TxCount--;
      fifo_count++;
      TxPtr++;
    }
//    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_2, 0);

    if (TxCount == 0)
    {
//      GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_3, GPIO_PIN_3);
      UARTIntDisable(UART0_BASE, UART_INT_TX);
//      GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_3, 0);
    }
  }
} // UARTIntHandler
