/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#include "HL_sci.h"
#include "HL_gio.h"
#include "HL_adc.h"
#include "HL_het.h"
#include "HL_rti.h"
#include "HL_sys_dma.h"
#include "HL_sys_vim.h"
#include "HL_system.h"
#include "HL_sys_core.h"
#include "HL_esm.h"

#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#define ADC_CONVERTED_DATA_BUFFER_SIZE 2
#define ADC_RESOLUTION_HALF 512
#define BNDA 16
#define BNDB 16
#define ADC1PIN1 0
#define ADC1PIN2 7
unsigned char buffertx[4];
unsigned int NumberOfChars;
uint32 counterval, countervalfree, OF;
uint32 aADC1ConvertedData1[1];
uint32 aADC1ConvertedData2[1];

g_dmaCTRL adc1_dmaCTRLPKT1, adc1_dmaCTRLPKT2;
int value = 0;
unsigned int Pges, PgesAV, Ptemp;
uint8 SW;
int I1, I2, I3;

uint16 Uzk = 140;
uint16 Ihat = 380;

adcData_t adc_data1[2];
adcData_t adc_data2[1];

/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
/* GIO POST INIT
 This function post initializes the given GIO PIN
 * Port = gioPORTA/B, num = pin number, func : 0 = Output, 1  = Input
 * Only Options are: PORTA and PORTB
 * Certain things have do be set in HalCoGen before:
 * - set GIO Low in VIM
 */
void gioPostInit(gioPORT_t* Port,uint32 num, _Bool func){

    /* Set Trigger sensitive to both Falling and Rising Edge, only needed for frequency calculation
     * Set Interrupt as active
     * Set Interrupt as low level priority ( and disable high priority )
     */
    if(Port == gioPORTA){
        gioREG->INTDET |= (1 << num);
        gioREG->ENASET |= (1 << num);
        gioREG->LVLSET &= ~(1 << num);
        gioREG->LVLCLR |= (1 << num);

    }
    if(Port == gioPORTB){
        gioREG->INTDET |= (1 << (num + 8));
        gioREG->ENASET |= (1 << (num + 8));
        gioREG->LVLSET &= ~(1 << (num + 8));
        gioREG->LVLCLR |= (1 << (num + 8));
    }

    /* Set GIO as Input / Output */
    if(func){
      Port->DIR  &= ~(1 << num); // Input
    }else{
      Port->DIR  |= (1 << num);  // Output
    }


    /* Set GIO as Input */

    /* GIO POST INIT END */

}

/* this functions sets the Counter limit
 * please calculate it before with Excel
 * enable HET driver and set HET configurations in HalCoGen before
 * enable Interrupt HET1 Low in HalCOGen before
 */
void hetPostInit(hetBASE_t* het){
    if(het == hetREG1){
        het->EXC1 |= (1 << 24); // enable CNT Overflow interrupt
    }
    if(het == hetREG2){
        het->EXC2 |= (1 << 24);
    }
}


/* this functions sets the adc so, that data is converted continously and read via DMA without software interrupts
 *
 */
void adcPostInit(adcBASE_t* adc){
    if(adc == adcREG1){
        adcREG1->G1DMACR |= (2 << 16); // number of group 1 result buffers to be transferred via DMA
        adcREG1->G1DMACR |= (1<< 0); // enable DMA , set G1DMA
        adcREG1->G1DMACR |= (1 << 2); // generates DMA request for each write to the group memory if G1DMA is set
        adcREG1->G1DMACR &= ~(1 << 3); // DMA request for each write to the group1 results RAM
        adcREG1->GxMODECR[1U] = (uint32)ADC_10_BIT
                                 | (uint32)0x00000030U      //Channel ID and OVR_G1_RAM_IGN
                                 | (uint32)0x00000000U
                                 | (uint32)0x00000002U;    //Continuous mode
    }

}

/* Vector Interrupt Post Init in Case something went wrong with HalCoGen
 * The Interrupt for rti1, overflow counter 0 is enabled here
 */


/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    _enable_interrupt_();
    /* Initialization */
    sciInit();
    gioInit();
    adcInit();
    hetInit();
    rtiInit();

    /* Interrupt Enable
     * the vimInit must be done after the rtiInit
     * enable_IRQ if the interrupt type is set as IRQ in HalCoGen, FRQ otherwise.
     * NOTE: the function __enable_IRQ_() is out of date and won't work  */
    vimInit();
    _enable_IRQ_interrupt_();

    /* Post Gio Configurations */
    gioPostInit(gioPORTA, 0, 1);
    gioPostInit(gioPORTA, 1, 1);
    gioPostInit(gioPORTA, 2, 1);

    /* Post het Configurations */
    hetPostInit(hetREG1);

    /* Post RTI Configurations
     *
     * These are the actual timers, not the HET
     */
    rtiStartCounter(rtiREG1, rtiCOUNTER_BLOCK0);
    /* Start RTI Overflow 0 interrupt notification */
    rtiEnableNotification(rtiREG1, rtiNOTIFICATION_COUNTER0);
    rtiEnableNotification(rtiREG1, rtiNOTIFICATION_COMPARE0);

    /* Post ADC Configuration
     *
     */
    adcPostInit(adcREG1);

    /* DMA CONFIG */
    dmaEnable();

    adc1_dmaCTRLPKT1.SADD      = (uint32_t) 0xFF3E0000 + 4*(BNDA + 0);  /* source address , here:  ADC Base RAM Address    */
    adc1_dmaCTRLPKT1.DADD      = (uint32_t)&aADC1ConvertedData1[0];            /* destination  address       */
    adc1_dmaCTRLPKT1.CHCTRL    = 0;                    /* next channel to be chained, 0 = disable chaining  */
    adc1_dmaCTRLPKT1.FRCNT     = 1;                  /* frame count, num ADC samples*/
    adc1_dmaCTRLPKT1.ELCNT     = 1;                    /* element count, num ADC channels*/
    adc1_dmaCTRLPKT1.ELDOFFSET = 0;                    /* element destination offset */
    adc1_dmaCTRLPKT1.ELSOFFSET = 0;                    /* element source offset */
    adc1_dmaCTRLPKT1.FRDOFFSET = 0;                    /* frame destination offset   */
    adc1_dmaCTRLPKT1.FRSOFFSET = 0;                    /* frame destination offset   */
    adc1_dmaCTRLPKT1.PORTASGN  = 4;                    /* port B , always 0x100 for all TMS570 */
    adc1_dmaCTRLPKT1.RDSIZE    = ACCESS_32_BIT;         /* read size = 1 => 16bits                 */
    adc1_dmaCTRLPKT1.WRSIZE    = ACCESS_32_BIT;         /* write size                 */
    adc1_dmaCTRLPKT1.TTYPE     = FRAME_TRANSFER;       /* transfer type              */
    adc1_dmaCTRLPKT1.ADDMODERD = ADDR_FIXED;            /* address mode read          */
    adc1_dmaCTRLPKT1.ADDMODEWR = ADDR_FIXED;           /* address mode write         */
    adc1_dmaCTRLPKT1.AUTOINIT  = AUTOINIT_ON;         /* autoinit */
//
    adc1_dmaCTRLPKT2.SADD      = (uint32_t) 0xFF3E0000 + 4*(BNDA + 1);    /* source address , here: Group 2 ADC Base Address    */
    adc1_dmaCTRLPKT2.DADD      = (uint32_t)&aADC1ConvertedData2[0];            /* destination  address       */
    adc1_dmaCTRLPKT2.CHCTRL    = 0;                    /* channel control            */
    adc1_dmaCTRLPKT2.FRCNT    =  1;                  /* frame count, num ADC samples*/
    adc1_dmaCTRLPKT2.ELCNT     = 1;                    /* element count, num ADC channels*/
    adc1_dmaCTRLPKT2.ELDOFFSET = 0;                    /* element destination offset */
    adc1_dmaCTRLPKT2.ELSOFFSET = 0;                    /* element destination offset */
    adc1_dmaCTRLPKT2.FRDOFFSET = 0;                    /* frame destination offset   */
    adc1_dmaCTRLPKT2.FRSOFFSET = 0;                    /* frame destination offset   */
    adc1_dmaCTRLPKT2.PORTASGN  = 4;                    /* port B , always 0x100 for all TMS570 */
    adc1_dmaCTRLPKT2.RDSIZE    = ACCESS_32_BIT;         /* read size                  */
    adc1_dmaCTRLPKT2.WRSIZE    = ACCESS_32_BIT;         /* write size                 */
    adc1_dmaCTRLPKT2.TTYPE     = FRAME_TRANSFER;       /* transfer type              */
    adc1_dmaCTRLPKT2.ADDMODERD = ADDR_FIXED;            /* address mode read          */
    adc1_dmaCTRLPKT2.ADDMODEWR = ADDR_FIXED;           /* address mode write         */
    adc1_dmaCTRLPKT2.AUTOINIT  = AUTOINIT_ON;         /* autoinit */
//
//    /* setting dma control packets */
    dmaSetCtrlPacket(DMA_CH0, adc1_dmaCTRLPKT1);
    dmaSetCtrlPacket(DMA_CH1, adc1_dmaCTRLPKT2);
    dmaReqAssign(DMA_CH0, DMA_REQ10);
    dmaReqAssign(DMA_CH1, DMA_REQ10);
//    dmaEnableInterrupt(DMA_CH0, BTC, DMA_INTA);
    dmaSetChEnable(DMA_CH0, DMA_HW);
//    dmaEnableInterrupt(DMA_CH1, BTC, DMA_INTA);
    dmaSetChEnable(DMA_CH1, DMA_HW);

    /* Start Conversionn :
     * REGX = adcX
     */
    adcStartConversion(adcREG1, adcGROUP1);
//    adcStartConversion(adcREG1, adcGROUP2);

    /* Init End */


    while(1)
    {
//
//           read free counter first so that counter is freezed and updated
//
          countervalfree = rtiREG1->CNT[0].FRCx;
          counterval = rtiREG1->CNT[0].UCx;
//          NumberOfChars = ltoa(counterval,(char*)buffertx); /* convert to ascii */
//          sciSend(sciREG1,NumberOfChars, buffertx);
//          sciSend(sciREG1,2, (unsigned char*)"\r\n");
//          value++;
//          gioSetBit(gioPORTA,6,0);
    }
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */

/* Timer Interrupt function : every 5 s is set for COMPARE0 value */
void rtiNotification(rtiBASE_t *rtiREG, uint32 notification){

    if(rtiREG == rtiREG1 && notification == rtiNOTIFICATION_COMPARE0){
        gioSetBit(gioPORTA,6,1);
        OF++;
//        adcGetData(adcREG1,adcGROUP1, &adc_data1[0]);
//        adcGetData(adcREG1,adcGROUP2, &adc_data2[0]);

        NumberOfChars = ltoa(adc_data1[0].value,(char*)buffertx); /* convert to ascii */
        sciSend(sciREG1,NumberOfChars, buffertx);
        sciSend(sciREG1,2, (unsigned char*)"\r\n");
        SW = (gioPORTA->DSET & 1) + (gioPORTA->DSET & 2) + (gioPORTA->DSET & 4); // 0b 1(S3) 1(S2) 1(S1)
        I1 =  (aADC1ConvertedData1[0] - ADC_RESOLUTION_HALF);
        I2 =  (aADC1ConvertedData2[0] - ADC_RESOLUTION_HALF);
        I3 = -(I1+I2);

        NumberOfChars = ltoa(aADC1ConvertedData1[0],(char*)buffertx); /* convert to ascii */
        sciSend(sciREG1,NumberOfChars, buffertx);
        sciSend(sciREG1,2, (unsigned char*)"\r\n");
        switch(SW) {
            case 0b000 : break;
            case 0b001 : Ptemp = Ptemp + (I1 >> 1) -I2 -I3;   break;
            case 0b010 : Ptemp = Ptemp - I1 + (I2 >> 1) - I3; break;
            case 0b011 : Ptemp = Ptemp + I1 + I2 -(I3 >> 1);  break;
            case 0b100 : Ptemp = Ptemp - I1 - I2 + (I3 >> 1); break;
            case 0b101 : Ptemp = Ptemp + I1 - (I2 >> 1) + I3; break;
            case 0b110 : Ptemp = Ptemp - (I1 >> 1) + I2 + I3; break;
            case 0b111 : break;
         }

         if(OF == 1){
             PgesAV = (Ptemp >> 11) * Ihat*Uzk;
             Ptemp = OF = 0;
         }
        gioSetBit(gioPORTA,6,0);
    }
}

/* USER CODE END */
