/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#define SLAVE_ADDRESS 0x4C
#define DATA_COUNT  1
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "i2c.h"
#include <stdio.h>
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint8_t TX_Data_Master[DATA_COUNT] = {0xAA};
uint8_t FLAG_STATUS = 0x00;
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */

    i2cInit();
    _enable_IRQ();

    /*Ignore NACK Mode*/
    i2cREG1->EMDR |=    0x2;

    /* Configure address of Slave to talk to */
    i2cSetSlaveAdd(i2cREG1, SLAVE_ADDRESS);

    /* Set direction to Transmitter */
    i2cSetDirection(i2cREG1, I2C_TRANSMITTER);

    /* Configure Data count */
    //i2cSetCount(i2cREG1, DATA_COUNT);

    /* Set mode as Master */
    i2cSetMode(i2cREG1, I2C_MASTER);

    /* Set Stop after programmed Count */
    i2cSetStop(i2cREG1);

    /* Transmit Start Condition */
    i2cSetStart(i2cREG1);

    /* Tranmit DATA_COUNT number of data in Polling mode */
    i2cSend(i2cREG1, DATA_COUNT, TX_Data_Master);

    //while(FLAG_STATUS == 0x00);

    /* Clear the Stop condition */
    i2cClearSCD(i2cREG1);

    //FLAG_STATUS =0;


    while(1);


/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
void i2cNotification(i2cBASE_t *i2c, uint32 flags)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
    if(i2c == i2cREG1 && (flags & I2C_TX_INT))
    {
        i2cREG1->MDR |= (uint32)((uint32)1U << 7U);
        i2cSetStop(i2cREG1);
        while(i2cIsBusBusy(i2cREG1) == true);
        while(i2cIsStopDetected(i2cREG1) == 0);
        printf("Master cihazdan slave cihaza veri baarrl bir ekilde gnderildi.\n");
        FLAG_STATUS = 0xFF;
        i2cREG1->MDR &= (uint32)(~((uint32)1U << 7U));
    }
}
/* USER CODE END */
